/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.utils.memory.BufferPool;

public class RandomAccessReader
extends RebufferingInputStream
implements FileDataInput {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int MAX_THROTTLED_BUFFER_SIZE = 65536;
    protected final ChannelProxy channel;
    protected final MmappedRegions regions;
    protected final RateLimiter limiter;
    private final long fileLength;
    protected final int bufferSize;
    private final BufferType bufferType;
    protected long bufferOffset;
    protected long markedPointer;

    protected RandomAccessReader(Builder builder) {
        super(null);
        this.channel = builder.channel;
        this.regions = builder.regions;
        this.limiter = builder.limiter;
        this.fileLength = builder.overrideLength <= 0L ? builder.channel.size() : builder.overrideLength;
        this.bufferSize = this.getBufferSize(builder);
        this.bufferType = builder.bufferType;
        if (builder.bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        if (builder.initializeBuffers) {
            this.initializeBuffer();
        }
    }

    protected int getBufferSize(Builder builder) {
        if (builder.limiter == null) {
            return builder.bufferSize;
        }
        return Math.min(65536, builder.bufferSize);
    }

    protected void initializeBuffer() {
        this.buffer = this.regions == null ? this.allocateBuffer(this.bufferSize) : this.regions.floor((long)0L).buffer.duplicate();
        this.buffer.limit(0);
    }

    protected ByteBuffer allocateBuffer(int size) {
        return BufferPool.get(size, this.bufferType).order(ByteOrder.BIG_ENDIAN);
    }

    protected void releaseBuffer() {
        if (this.buffer != null) {
            if (this.regions == null) {
                BufferPool.put(this.buffer);
            }
            this.buffer = null;
        }
    }

    @Override
    public void reBuffer() {
        if (this.isEOF()) {
            return;
        }
        if (this.regions == null) {
            this.reBufferStandard();
        } else {
            this.reBufferMmap();
        }
        if (this.limiter != null) {
            this.limiter.acquire(this.buffer.remaining());
        }
        assert (this.buffer.order() == ByteOrder.BIG_ENDIAN) : "Buffer must have BIG ENDIAN byte ordering";
    }

    protected void reBufferStandard() {
        this.bufferOffset += (long)this.buffer.position();
        assert (this.bufferOffset < this.fileLength);
        this.buffer.clear();
        long position = this.bufferOffset;
        long limit = this.bufferOffset;
        long pageAligedPos = position & 0xFFFFFFFFFFFFF000L;
        long upperLimit = Math.min(this.fileLength, pageAligedPos + (long)this.buffer.capacity());
        this.buffer.limit((int)(upperLimit - position));
        while (this.buffer.hasRemaining() && limit < upperLimit) {
            int n = this.channel.read(this.buffer, position);
            if (n < 0) {
                throw new FSReadError((Throwable)new IOException("Unexpected end of file"), this.channel.filePath());
            }
            position += (long)n;
            limit = this.bufferOffset + (long)this.buffer.position();
        }
        this.buffer.flip();
    }

    protected void reBufferMmap() {
        long position = this.bufferOffset + (long)this.buffer.position();
        assert (position < this.fileLength);
        MmappedRegions.Region region = this.regions.floor(position);
        this.bufferOffset = region.bottom();
        this.buffer = region.buffer.duplicate();
        this.buffer.position(Ints.checkedCast((long)(position - this.bufferOffset)));
        if (this.limiter != null && this.bufferSize < this.buffer.remaining()) {
            this.buffer.limit(this.buffer.position() + this.bufferSize);
        }
    }

    @Override
    public long getFilePointer() {
        return this.current();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    @Override
    public String getPath() {
        return this.channel.filePath();
    }

    public ChannelProxy getChannel() {
        return this.channel;
    }

    @Override
    public void reset() throws IOException {
        this.seek(this.markedPointer);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public FileMark mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.current() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public int available() throws IOException {
        return Ints.saturatedCast((long)this.bytesRemaining());
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.bufferOffset += (long)this.buffer.position();
        this.releaseBuffer();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(filePath='" + this.channel + "')";
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to seek in a closed RAR");
        }
        if (newPosition >= this.length()) {
            if (newPosition > this.length()) {
                throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
            }
            this.buffer.limit(0);
            this.bufferOffset = newPosition;
            return;
        }
        if (newPosition >= this.bufferOffset && newPosition < this.bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
            return;
        }
        this.bufferOffset = newPosition;
        this.buffer.clear();
        this.reBuffer();
        assert (this.current() == newPosition);
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        long unreadPosition = -1L;
        block5: while (true) {
            int nextByte = this.read();
            switch (nextByte) {
                case -1: {
                    return line.length() != 0 ? line.toString() : null;
                }
                case 13: {
                    if (foundTerminator) {
                        this.seek(unreadPosition);
                        return line.toString();
                    }
                    foundTerminator = true;
                    unreadPosition = this.getPosition();
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                this.seek(unreadPosition);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    public long length() {
        return this.fileLength;
    }

    public long getPosition() {
        return this.current();
    }

    public static RandomAccessReader open(File file) {
        return new Builder(new ChannelProxy(file)).buildWithChannel();
    }

    public static RandomAccessReader open(ChannelProxy channel) {
        return new Builder(channel).build();
    }

    public static class RandomAccessReaderWithOwnChannel
    extends RandomAccessReader {
        protected RandomAccessReaderWithOwnChannel(Builder builder) {
            super(builder);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                this.channel.close();
            }
        }
    }

    public static class Builder {
        public final ChannelProxy channel;
        public long overrideLength;
        public int bufferSize;
        public BufferType bufferType;
        public MmappedRegions regions;
        public RateLimiter limiter;
        public boolean initializeBuffers;

        public Builder(ChannelProxy channel) {
            this.channel = channel;
            this.overrideLength = -1L;
            this.bufferSize = Builder.getBufferSize(4096);
            this.bufferType = BufferType.OFF_HEAP;
            this.regions = null;
            this.limiter = null;
            this.initializeBuffers = true;
        }

        private static int getBufferSize(int size) {
            if ((size & 0xFFFFF000) != size) {
                size = size + 4095 & 0xFFFFF000;
            }
            return size;
        }

        public Builder overrideLength(long overrideLength) {
            if (overrideLength > this.channel.size()) {
                throw new IllegalArgumentException("overrideLength cannot be more than the file size");
            }
            this.overrideLength = overrideLength;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            if (bufferSize <= 0) {
                throw new IllegalArgumentException("bufferSize must be positive");
            }
            this.bufferSize = Builder.getBufferSize(bufferSize);
            return this;
        }

        public Builder bufferType(BufferType bufferType) {
            this.bufferType = bufferType;
            return this;
        }

        public Builder regions(MmappedRegions regions) {
            this.regions = regions;
            return this;
        }

        public Builder limiter(RateLimiter limiter) {
            this.limiter = limiter;
            return this;
        }

        public Builder initializeBuffers(boolean initializeBuffers) {
            this.initializeBuffers = initializeBuffers;
            return this;
        }

        public RandomAccessReader build() {
            return new RandomAccessReader(this);
        }

        public RandomAccessReader buildWithChannel() {
            return new RandomAccessReaderWithOwnChannel(this);
        }
    }

    protected static class BufferedRandomAccessFileMark
    implements FileMark {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

