/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.MaterializedViewDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.view.MaterializedView;
import org.apache.cassandra.db.view.TemporalRow;
import org.apache.cassandra.service.StorageProxy;

public class MaterializedViewManager {
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentWriters() * 1024));
    private static final boolean disableCoordinatorBatchlog = Boolean.getBoolean("cassandra.mv_disable_coordinator_batchlog");
    private final ConcurrentNavigableMap<String, MaterializedView> viewsByName = new ConcurrentSkipListMap<String, MaterializedView>();
    private final ColumnFamilyStore baseCfs;

    public MaterializedViewManager(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
    }

    public Iterable<MaterializedView> allViews() {
        return this.viewsByName.values();
    }

    public Iterable<ColumnFamilyStore> allViewsCfs() {
        ArrayList<ColumnFamilyStore> viewColumnFamilies = new ArrayList<ColumnFamilyStore>();
        for (MaterializedView view : this.allViews()) {
            viewColumnFamilies.add(view.getViewCfs());
        }
        return viewColumnFamilies;
    }

    public void init() {
        this.reload();
    }

    public void invalidate() {
        for (MaterializedView view : this.allViews()) {
            this.removeMaterializedView(view.name);
        }
    }

    public void reload() {
        HashMap<String, MaterializedViewDefinition> newViewsByName = new HashMap<String, MaterializedViewDefinition>();
        for (MaterializedViewDefinition materializedViewDefinition : this.baseCfs.metadata.getMaterializedViews()) {
            newViewsByName.put(materializedViewDefinition.viewName, materializedViewDefinition);
        }
        for (String string : this.viewsByName.keySet()) {
            if (newViewsByName.containsKey(string)) continue;
            this.removeMaterializedView(string);
        }
        for (Map.Entry entry : newViewsByName.entrySet()) {
            if (this.viewsByName.containsKey(entry.getKey())) continue;
            this.addMaterializedView((MaterializedViewDefinition)entry.getValue());
        }
        for (MaterializedView materializedView : this.allViews()) {
            materializedView.build();
            materializedView.updateDefinition((MaterializedViewDefinition)newViewsByName.get(materializedView.name));
        }
    }

    public void buildAllViews() {
        for (MaterializedView view : this.allViews()) {
            view.build();
        }
    }

    public void removeMaterializedView(String name) {
        MaterializedView view = (MaterializedView)this.viewsByName.remove(name);
        if (view == null) {
            return;
        }
        SystemKeyspace.setMaterializedViewRemoved(this.baseCfs.metadata.ksName, view.name);
    }

    public void addMaterializedView(MaterializedViewDefinition definition) {
        MaterializedView view = new MaterializedView(definition, this.baseCfs);
        this.viewsByName.put(definition.viewName, view);
    }

    public void pushViewReplicaUpdates(PartitionUpdate update, boolean writeCommitLog) {
        LinkedList mutations = null;
        TemporalRow.Set temporalRows = null;
        for (Map.Entry view : this.viewsByName.entrySet()) {
            temporalRows = ((MaterializedView)view.getValue()).getTemporalRowSet(update, temporalRows, false);
            Collection<Mutation> viewMutations = ((MaterializedView)view.getValue()).createMutations(update, temporalRows, false);
            if (viewMutations == null || viewMutations.isEmpty()) continue;
            if (mutations == null) {
                mutations = Lists.newLinkedList();
            }
            mutations.addAll(viewMutations);
        }
        if (mutations != null) {
            StorageProxy.mutateMV(update.partitionKey().getKey(), mutations, writeCommitLog);
        }
    }

    public boolean updateAffectsView(PartitionUpdate upd) {
        for (MaterializedView view : this.allViews()) {
            if (!view.updateAffectsView(upd)) continue;
            return true;
        }
        return false;
    }

    public static Lock acquireLockFor(ByteBuffer key) {
        Lock lock = (Lock)LOCKS.get((Object)key);
        if (lock.tryLock()) {
            return lock;
        }
        return null;
    }

    public static boolean updatesAffectView(Collection<? extends IMutation> mutations, boolean coordinatorBatchlog) {
        if (coordinatorBatchlog && disableCoordinatorBatchlog) {
            return false;
        }
        for (IMutation iMutation : mutations) {
            for (PartitionUpdate cf : iMutation.getPartitionUpdates()) {
                MaterializedViewManager viewManager;
                Keyspace keyspace = Keyspace.open(cf.metadata().ksName);
                if (coordinatorBatchlog && keyspace.getReplicationStrategy().getReplicationFactor() == 1 || !(viewManager = keyspace.getColumnFamilyStore((UUID)cf.metadata().cfId).materializedViewManager).updateAffectsView(cf)) continue;
                return true;
            }
        }
        return false;
    }

    public void forceBlockingFlush() {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.forceBlockingFlush();
        }
    }

    public void dumpMemtables() {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.dumpMemtable();
        }
    }

    public void truncateBlocking(long truncatedAt) {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            ReplayPosition replayAfter = viewCfs.discardSSTables(truncatedAt);
            SystemKeyspace.saveTruncationRecord(viewCfs, truncatedAt, replayAfter);
        }
    }
}

