/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.NoSuchElementException;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;

public abstract class AlteringUnfilteredRowIterator
extends WrappingUnfilteredRowIterator {
    private Row staticRow;
    private Unfiltered next;

    protected AlteringUnfilteredRowIterator(UnfilteredRowIterator wrapped) {
        super(wrapped);
    }

    protected Row computeNextStatic(Row row) {
        return row;
    }

    protected Row computeNext(Row row) {
        return row;
    }

    protected RangeTombstoneMarker computeNext(RangeTombstoneMarker marker) {
        return marker;
    }

    @Override
    public Row staticRow() {
        if (this.staticRow == null) {
            Row row = this.computeNextStatic(super.staticRow());
            this.staticRow = row == null ? Rows.EMPTY_STATIC_ROW : row;
        }
        return this.staticRow;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && super.hasNext()) {
            Unfiltered unfiltered = super.next();
            if (unfiltered.isRow()) {
                Row row = this.computeNext((Row)unfiltered);
                if (row == null || row.isEmpty()) continue;
                this.next = row;
                continue;
            }
            this.next = this.computeNext((RangeTombstoneMarker)unfiltered);
        }
        return this.next != null;
    }

    @Override
    public Unfiltered next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Unfiltered toReturn = this.next;
        this.next = null;
        return toReturn;
    }
}

