/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionNamesCommand;
import org.apache.cassandra.db.SinglePartitionSliceCommand;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.CachedBTreePartition;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.SingletonUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.MultiPartitionPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class SinglePartitionReadCommand<F extends ClusteringIndexFilter>
extends ReadCommand {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    private final DecoratedKey partitionKey;
    private final F clusteringIndexFilter;

    protected SinglePartitionReadCommand(boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, F clusteringIndexFilter) {
        super(ReadCommand.Kind.SINGLE_PARTITION, isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits);
        assert (partitionKey.getPartitioner() == metadata.partitioner);
        this.partitionKey = partitionKey;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    public static SinglePartitionReadCommand<?> create(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return SinglePartitionReadCommand.create(false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public static SinglePartitionReadCommand<?> create(boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        if (clusteringIndexFilter instanceof ClusteringIndexSliceFilter) {
            return new SinglePartitionSliceCommand(false, 0, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, (ClusteringIndexSliceFilter)clusteringIndexFilter);
        }
        assert (clusteringIndexFilter instanceof ClusteringIndexNamesFilter);
        return new SinglePartitionNamesCommand(false, 0, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, (ClusteringIndexNamesFilter)clusteringIndexFilter);
    }

    public static SinglePartitionReadCommand<?> create(CFMetaData metadata, int nowInSec, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand fullPartitionRead(CFMetaData metadata, int nowInSec, DecoratedKey key) {
        return SinglePartitionSliceCommand.create(metadata, nowInSec, key, Slices.ALL);
    }

    public static SinglePartitionReadCommand fullPartitionRead(CFMetaData metadata, int nowInSec, ByteBuffer key) {
        return SinglePartitionSliceCommand.create(metadata, nowInSec, metadata.decorateKey(key), Slices.ALL);
    }

    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    public F clusteringIndexFilter() {
        return this.clusteringIndexFilter;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.clusteringIndexFilter;
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public boolean selects(DecoratedKey partitionKey, Clustering clustering) {
        if (!this.partitionKey().equals(partitionKey)) {
            return false;
        }
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return !this.columnFilter().fetchedColumns().statics.isEmpty();
        }
        return this.clusteringIndexFilter().selects(clustering);
    }

    public SinglePartitionReadCommand forPaging(Clustering lastReturned, int pageSize) {
        assert (!this.isDigestQuery());
        return SinglePartitionReadCommand.create(this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits().forPaging(pageSize), this.partitionKey(), lastReturned == null ? this.clusteringIndexFilter() : this.clusteringIndexFilter.forPaging(this.metadata().comparator, lastReturned, false));
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
        return StorageProxy.read(Group.one(this), consistency, clientState);
    }

    @Override
    public SinglePartitionPager getPager(PagingState pagingState) {
        return SinglePartitionReadCommand.getPager(this, pagingState);
    }

    private static SinglePartitionPager getPager(SinglePartitionReadCommand command, PagingState pagingState) {
        return new SinglePartitionPager(command, pagingState);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.readLatency.addNano(latencyNanos);
    }

    @Override
    protected UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadOrderGroup orderGroup) {
        UnfilteredRowIterator partition = cfs.isRowCacheEnabled() ? this.getThroughCache(cfs, orderGroup.baseReadOpOrderGroup()) : this.queryMemtableAndDisk(cfs, orderGroup.baseReadOpOrderGroup());
        return new SingletonUnfilteredPartitionIterator(partition, this.isForThrift());
    }

    private UnfilteredRowIterator getThroughCache(ColumnFamilyStore cfs, OpOrder.Group readOp) {
        assert (!cfs.isIndex());
        assert (cfs.isRowCacheEnabled()) : String.format("Row cache is not enabled on table [%s]", cfs.name);
        UUID cfId = this.metadata().cfId;
        RowCacheKey key = new RowCacheKey(cfId, this.partitionKey());
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                cfs.metric.rowCacheMiss.inc();
                return this.queryMemtableAndDisk(cfs, readOp);
            }
            CachedPartition cachedPartition = (CachedPartition)cached;
            if (cfs.isFilterFullyCoveredBy((ClusteringIndexFilter)this.clusteringIndexFilter(), this.limits(), cachedPartition, this.nowInSec())) {
                cfs.metric.rowCacheHit.inc();
                Tracing.trace("Row cache hit");
                return this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), cachedPartition);
            }
            cfs.metric.rowCacheHitOutOfRange.inc();
            Tracing.trace("Ignoring row cache as cached value could not satisfy query");
            return this.queryMemtableAndDisk(cfs, readOp);
        }
        cfs.metric.rowCacheMiss.inc();
        Tracing.trace("Row cache miss");
        boolean cacheFullPartitions = this.metadata().params.caching.cacheAllRows();
        if (cacheFullPartitions || this.clusteringIndexFilter().isHeadFilter()) {
            RowCacheSentinel sentinel = new RowCacheSentinel();
            boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
            boolean sentinelReplaced = false;
            try {
                UnfilteredRowIterator cacheIterator;
                UnfilteredRowIterator iter;
                block16: {
                    int rowsToCache = this.metadata().params.caching.rowsPerPartitionToCache();
                    iter = SinglePartitionReadCommand.fullPartitionRead(this.metadata(), this.nowInSec(), this.partitionKey()).queryMemtableAndDisk(cfs, readOp);
                    try {
                        CachedBTreePartition toCache = CachedBTreePartition.create(DataLimits.cqlLimits(rowsToCache).filter(iter, this.nowInSec()), this.nowInSec());
                        if (sentinelSuccess && !toCache.isEmpty()) {
                            Tracing.trace("Caching {} rows", (Object)toCache.rowCount());
                            CacheService.instance.rowCache.replace(key, sentinel, toCache);
                            sentinelReplaced = true;
                        }
                        cacheIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), toCache);
                        if (!cacheFullPartitions) break block16;
                        assert (!iter.hasNext());
                        iter.close();
                        UnfilteredRowIterator unfilteredRowIterator = cacheIterator;
                        return unfilteredRowIterator;
                    }
                    catch (Error | RuntimeException e) {
                        iter.close();
                        throw e;
                    }
                }
                UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.concat(cacheIterator, this.clusteringIndexFilter().filterNotIndexed(this.columnFilter(), iter));
                return unfilteredRowIterator;
            }
            finally {
                if (sentinelSuccess && !sentinelReplaced) {
                    cfs.invalidateCachedPartition(key);
                }
            }
        }
        Tracing.trace("Fetching data but not populating cache as query does not query from the start of the partition");
        return this.queryMemtableAndDisk(cfs, readOp);
    }

    public UnfilteredRowIterator queryMemtableAndDisk(ColumnFamilyStore cfs, OpOrder.Group readOp) {
        Tracing.trace("Executing single-partition query on {}", (Object)cfs.name);
        boolean copyOnHeap = Memtable.MEMORY_POOL.needToCopyOnHeap();
        return this.queryMemtableAndDiskInternal(cfs, copyOnHeap);
    }

    protected abstract UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore var1, boolean var2);

    public String toString() {
        return String.format("Read(%s.%s columns=%s rowFilter=%s limits=%s key=%s filter=%s, nowInSec=%d)", this.metadata().ksName, this.metadata().cfName, this.columnFilter(), this.rowFilter(), this.limits(), this.metadata().getKeyValidator().getString(this.partitionKey().getKey()), this.clusteringIndexFilter.toString(this.metadata()), this.nowInSec());
    }

    @Override
    public MessageOut<ReadCommand> createMessage(int version) {
        return new MessageOut<ReadCommand>(MessagingService.Verb.READ, this, version < 10 ? legacyReadCommandSerializer : serializer);
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString;
        sb.append(" WHERE ");
        sb.append(ColumnDefinition.toCQLString(this.metadata().partitionKeyColumns())).append(" = ");
        DataRange.appendKeyString(sb, this.metadata().getKeyValidator(), this.partitionKey().getKey());
        if (!this.rowFilter().isEmpty()) {
            sb.append(" AND ").append(this.rowFilter());
        }
        if (!(filterString = this.clusteringIndexFilter().toCQLString(this.metadata())).isEmpty()) {
            sb.append(" AND ").append(filterString);
        }
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        this.metadata().getKeyValidator().writeValue(this.partitionKey().getKey(), out);
        ClusteringIndexFilter.serializer.serialize((ClusteringIndexFilter)this.clusteringIndexFilter(), out, version);
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return this.metadata().getKeyValidator().writtenLength(this.partitionKey().getKey()) + ClusteringIndexFilter.serializer.serializedSize((ClusteringIndexFilter)this.clusteringIndexFilter(), version);
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits) throws IOException {
            DecoratedKey key = metadata.decorateKey(metadata.getKeyValidator().readValue(in));
            ClusteringIndexFilter filter = ClusteringIndexFilter.serializer.deserialize(in, version, metadata);
            if (filter instanceof ClusteringIndexNamesFilter) {
                return new SinglePartitionNamesCommand(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, key, (ClusteringIndexNamesFilter)filter);
            }
            return new SinglePartitionSliceCommand(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, key, (ClusteringIndexSliceFilter)filter);
        }
    }

    public static class Group
    implements ReadQuery {
        public final List<SinglePartitionReadCommand<?>> commands;
        private final DataLimits limits;
        private final int nowInSec;

        public Group(List<SinglePartitionReadCommand<?>> commands, DataLimits limits) {
            assert (!commands.isEmpty());
            this.commands = commands;
            this.limits = limits;
            this.nowInSec = commands.get(0).nowInSec();
            for (int i = 1; i < commands.size(); ++i) {
                assert (commands.get(i).nowInSec() == this.nowInSec);
            }
        }

        public static Group one(SinglePartitionReadCommand<?> command) {
            return new Group(Collections.singletonList(command), command.limits());
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
            return StorageProxy.read(this, consistency, clientState);
        }

        public int nowInSec() {
            return this.nowInSec;
        }

        @Override
        public DataLimits limits() {
            return this.limits;
        }

        public CFMetaData metadata() {
            return this.commands.get(0).metadata();
        }

        @Override
        public ReadOrderGroup startOrderGroup() {
            return this.commands.get(0).startOrderGroup();
        }

        @Override
        public PartitionIterator executeInternal(ReadOrderGroup orderGroup) {
            ArrayList<PartitionIterator> partitions = new ArrayList<PartitionIterator>(this.commands.size());
            for (SinglePartitionReadCommand<?> cmd : this.commands) {
                partitions.add(cmd.executeInternal(orderGroup));
            }
            return this.limits.filter(PartitionIterators.concat(partitions), this.nowInSec);
        }

        @Override
        public QueryPager getPager(PagingState pagingState) {
            if (this.commands.size() == 1) {
                return SinglePartitionReadCommand.getPager((SinglePartitionReadCommand)this.commands.get(0), pagingState);
            }
            return new MultiPartitionPager(this, pagingState);
        }

        public String toString() {
            return this.commands.toString();
        }
    }
}

