/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.AtomicBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.DiskAwareRunnable;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memtable
implements Comparable<Memtable> {
    private static final Logger logger = LoggerFactory.getLogger(Memtable.class);
    static final MemtablePool MEMORY_POOL = DatabaseDescriptor.getMemtableAllocatorPool();
    private static final int ROW_OVERHEAD_HEAP_SIZE = Memtable.estimateRowOverhead(Integer.parseInt(System.getProperty("cassandra.memtable_row_overhead_computation_step", "100000")));
    private final MemtableAllocator allocator;
    private final AtomicLong liveDataSize = new AtomicLong(0L);
    private final AtomicLong currentOperations = new AtomicLong(0L);
    private volatile OpOrder.Barrier writeBarrier;
    private volatile AtomicReference<ReplayPosition> lastReplayPosition;
    private final ReplayPosition minReplayPosition = CommitLog.instance.getContext();
    private final ConcurrentNavigableMap<PartitionPosition, AtomicBTreePartition> partitions = new ConcurrentSkipListMap<PartitionPosition, AtomicBTreePartition>();
    public final ColumnFamilyStore cfs;
    private final long creationTime = System.currentTimeMillis();
    private final long creationNano = System.nanoTime();
    public final ClusteringComparator initialComparator;
    private final ColumnsCollector columnsCollector;
    private final StatsCollector statsCollector = new StatsCollector();

    @Override
    public int compareTo(Memtable that) {
        return this.minReplayPosition.compareTo(that.minReplayPosition);
    }

    public Memtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.allocator = MEMORY_POOL.newAllocator();
        this.initialComparator = cfs.metadata.comparator;
        this.cfs.scheduleFlush();
        this.columnsCollector = new ColumnsCollector(cfs.metadata.partitionColumns());
    }

    @VisibleForTesting
    public Memtable(CFMetaData metadata) {
        this.initialComparator = metadata.comparator;
        this.cfs = null;
        this.allocator = null;
        this.columnsCollector = new ColumnsCollector(metadata.partitionColumns());
    }

    public MemtableAllocator getAllocator() {
        return this.allocator;
    }

    public long getLiveDataSize() {
        return this.liveDataSize.get();
    }

    public long getOperations() {
        return this.currentOperations.get();
    }

    @VisibleForTesting
    public void setDiscarding(OpOrder.Barrier writeBarrier, AtomicReference<ReplayPosition> lastReplayPosition) {
        assert (this.writeBarrier == null);
        this.lastReplayPosition = lastReplayPosition;
        this.writeBarrier = writeBarrier;
        this.allocator.setDiscarding();
    }

    void setDiscarded() {
        this.allocator.setDiscarded();
    }

    public boolean accepts(OpOrder.Group opGroup, ReplayPosition replayPosition) {
        ReplayPosition currentLast;
        OpOrder.Barrier barrier = this.writeBarrier;
        if (barrier == null) {
            return true;
        }
        if (!barrier.isAfter(opGroup)) {
            return false;
        }
        if (replayPosition == null) {
            return true;
        }
        do {
            if ((currentLast = this.lastReplayPosition.get()) instanceof LastReplayPosition) {
                return currentLast.compareTo(replayPosition) >= 0;
            }
            if (currentLast == null || currentLast.compareTo(replayPosition) < 0) continue;
            return true;
        } while (!this.lastReplayPosition.compareAndSet(currentLast, replayPosition));
        return true;
    }

    public boolean isLive() {
        return this.allocator.isLive();
    }

    public boolean isClean() {
        return this.partitions.isEmpty();
    }

    public boolean isCleanAfter(ReplayPosition position) {
        return this.isClean() || position != null && this.minReplayPosition.compareTo(position) >= 0;
    }

    public boolean isExpired() {
        int period = this.cfs.metadata.params.memtableFlushPeriodInMs;
        return period > 0 && System.nanoTime() - this.creationNano >= TimeUnit.MILLISECONDS.toNanos(period);
    }

    long put(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) {
        AtomicBTreePartition previous = (AtomicBTreePartition)this.partitions.get(update.partitionKey());
        long initialSize = 0L;
        if (previous == null) {
            AtomicBTreePartition empty;
            DecoratedKey cloneKey = this.allocator.clone(update.partitionKey(), opGroup);
            previous = this.partitions.putIfAbsent(cloneKey, empty = new AtomicBTreePartition(this.cfs.metadata, cloneKey, this.allocator));
            if (previous == null) {
                previous = empty;
                int overhead = (int)(cloneKey.getToken().getHeapSize() + (long)ROW_OVERHEAD_HEAP_SIZE);
                this.allocator.onHeap().allocate(overhead, opGroup);
                initialSize = 8L;
            } else {
                this.allocator.reclaimer().reclaimImmediately(cloneKey);
            }
        }
        long[] pair = previous.addAllWithSizeDelta(update, opGroup, indexer);
        this.liveDataSize.addAndGet(initialSize + pair[0]);
        this.columnsCollector.update(update.columns());
        this.statsCollector.update(update.stats());
        this.currentOperations.addAndGet(update.operationCount());
        return pair[1];
    }

    public int partitionCount() {
        return this.partitions.size();
    }

    public FlushRunnable flushRunnable() {
        return new FlushRunnable(this.lastReplayPosition.get());
    }

    public String toString() {
        return String.format("Memtable-%s@%s(%s serialized bytes, %s ops, %.0f%%/%.0f%% of on/off-heap limit)", this.cfs.name, this.hashCode(), FBUtilities.prettyPrintMemory(this.liveDataSize.get()), this.currentOperations, Float.valueOf(100.0f * this.allocator.onHeap().ownershipRatio()), Float.valueOf(100.0f * this.allocator.offHeap().ownershipRatio()));
    }

    public MemtableUnfilteredPartitionIterator makePartitionIterator(ColumnFilter columnFilter, DataRange dataRange, boolean isForThrift) {
        boolean includeStop;
        AbstractBounds<PartitionPosition> keyRange = dataRange.keyRange();
        boolean startIsMin = ((PartitionPosition)keyRange.left).isMinimum();
        boolean stopIsMin = ((PartitionPosition)keyRange.right).isMinimum();
        boolean isBound = keyRange instanceof Bounds;
        boolean includeStart = isBound || keyRange instanceof IncludingExcludingBounds;
        boolean bl = includeStop = isBound || keyRange instanceof Range;
        NavigableMap<PartitionPosition, AtomicBTreePartition> subMap = startIsMin ? (stopIsMin ? this.partitions : this.partitions.headMap(keyRange.right, includeStop)) : (stopIsMin ? this.partitions.tailMap(keyRange.left, includeStart) : this.partitions.subMap(keyRange.left, includeStart, keyRange.right, includeStop));
        int minLocalDeletionTime = Integer.MAX_VALUE;
        if (this.cfs.getCompactionStrategyManager().onlyPurgeRepairedTombstones()) {
            minLocalDeletionTime = this.findMinLocalDeletionTime(subMap.entrySet().iterator());
        }
        Iterator<Map.Entry<PartitionPosition, AtomicBTreePartition>> iter = subMap.entrySet().iterator();
        return new MemtableUnfilteredPartitionIterator(this.cfs, iter, isForThrift, minLocalDeletionTime, columnFilter, dataRange);
    }

    private int findMinLocalDeletionTime(Iterator<Map.Entry<PartitionPosition, AtomicBTreePartition>> iterator) {
        int minLocalDeletionTime = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            Map.Entry<PartitionPosition, AtomicBTreePartition> entry = iterator.next();
            minLocalDeletionTime = Math.min(minLocalDeletionTime, entry.getValue().stats().minLocalDeletionTime);
        }
        return minLocalDeletionTime;
    }

    public Partition getPartition(DecoratedKey key) {
        return (Partition)this.partitions.get(key);
    }

    public long creationTime() {
        return this.creationTime;
    }

    private static int estimateRowOverhead(int count) {
        try (OpOrder.Group group = new OpOrder().start();){
            MemtableAllocator allocator = MEMORY_POOL.newAllocator();
            ConcurrentSkipListMap<DecoratedKey, Object> partitions = new ConcurrentSkipListMap<DecoratedKey, Object>();
            Object val = new Object();
            for (int i = 0; i < count; ++i) {
                partitions.put(allocator.clone(new BufferDecoratedKey(new Murmur3Partitioner.LongToken(i), ByteBufferUtil.EMPTY_BYTE_BUFFER), group), val);
            }
            double avgSize = (double)ObjectSizes.measureDeep(partitions) / (double)count;
            int rowOverhead = (int)(avgSize - Math.floor(avgSize) < 0.05 ? Math.floor(avgSize) : Math.ceil(avgSize));
            rowOverhead = (int)((long)rowOverhead - ObjectSizes.measureDeep(new Murmur3Partitioner.LongToken(0L)));
            rowOverhead = (int)((long)rowOverhead + AtomicBTreePartition.EMPTY_SIZE);
            allocator.setDiscarding();
            allocator.setDiscarded();
            int n = rowOverhead;
            return n;
        }
    }

    private static class StatsCollector {
        private final AtomicReference<EncodingStats> stats = new AtomicReference<EncodingStats>(EncodingStats.NO_STATS);

        private StatsCollector() {
        }

        public void update(EncodingStats newStats) {
            EncodingStats updated;
            EncodingStats current;
            while (!this.stats.compareAndSet(current = this.stats.get(), updated = current.mergeWith(newStats))) {
            }
        }

        public EncodingStats get() {
            return this.stats.get();
        }
    }

    private static class ColumnsCollector {
        private final HashMap<ColumnDefinition, AtomicBoolean> predefined = new HashMap();
        private final ConcurrentSkipListSet<ColumnDefinition> extra = new ConcurrentSkipListSet();

        ColumnsCollector(PartitionColumns columns) {
            for (ColumnDefinition def : columns.statics) {
                this.predefined.put(def, new AtomicBoolean());
            }
            for (ColumnDefinition def : columns.regulars) {
                this.predefined.put(def, new AtomicBoolean());
            }
        }

        public void update(PartitionColumns columns) {
            for (ColumnDefinition s : columns.statics) {
                this.update(s);
            }
            for (ColumnDefinition r : columns.regulars) {
                this.update(r);
            }
        }

        private void update(ColumnDefinition definition) {
            AtomicBoolean present = this.predefined.get(definition);
            if (present != null) {
                if (!present.get()) {
                    present.set(true);
                }
            } else {
                this.extra.add(definition);
            }
        }

        public PartitionColumns get() {
            PartitionColumns.Builder builder = PartitionColumns.builder();
            for (Map.Entry<ColumnDefinition, AtomicBoolean> e : this.predefined.entrySet()) {
                if (!e.getValue().get()) continue;
                builder.add(e.getKey());
            }
            return builder.addAll(this.extra).build();
        }
    }

    public static class MemtableUnfilteredPartitionIterator
    extends AbstractUnfilteredPartitionIterator {
        private final ColumnFamilyStore cfs;
        private final Iterator<Map.Entry<PartitionPosition, AtomicBTreePartition>> iter;
        private final boolean isForThrift;
        private final int minLocalDeletionTime;
        private final ColumnFilter columnFilter;
        private final DataRange dataRange;

        public MemtableUnfilteredPartitionIterator(ColumnFamilyStore cfs, Iterator<Map.Entry<PartitionPosition, AtomicBTreePartition>> iter, boolean isForThrift, int minLocalDeletionTime, ColumnFilter columnFilter, DataRange dataRange) {
            this.cfs = cfs;
            this.iter = iter;
            this.isForThrift = isForThrift;
            this.minLocalDeletionTime = minLocalDeletionTime;
            this.columnFilter = columnFilter;
            this.dataRange = dataRange;
        }

        @Override
        public boolean isForThrift() {
            return this.isForThrift;
        }

        public int getMinLocalDeletionTime() {
            return this.minLocalDeletionTime;
        }

        @Override
        public CFMetaData metadata() {
            return this.cfs.metadata;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public UnfilteredRowIterator next() {
            Map.Entry<PartitionPosition, AtomicBTreePartition> entry = this.iter.next();
            assert (entry.getKey() instanceof DecoratedKey);
            DecoratedKey key = (DecoratedKey)entry.getKey();
            ClusteringIndexFilter filter = this.dataRange.clusteringIndexFilter(key);
            return filter.getUnfilteredRowIterator(this.columnFilter, entry.getValue());
        }
    }

    class FlushRunnable
    extends DiskAwareRunnable {
        private final ReplayPosition context;
        private final long estimatedSize;
        private final boolean isBatchLogTable;

        FlushRunnable(ReplayPosition context) {
            this.context = context;
            long keySize = 0L;
            for (PartitionPosition key : Memtable.this.partitions.keySet()) {
                assert (key instanceof DecoratedKey);
                keySize += (long)((DecoratedKey)key).getKey().remaining();
            }
            this.estimatedSize = (long)((double)(keySize + keySize + Memtable.this.liveDataSize.get()) * 1.2);
            this.isBatchLogTable = Memtable.this.cfs.name.equals("batches") && Memtable.this.cfs.keyspace.getName().equals("system");
        }

        public long getExpectedWriteSize() {
            return this.estimatedSize;
        }

        @Override
        protected void runMayThrow() throws Exception {
            long writeSize = this.getExpectedWriteSize();
            Directories.DataDirectory dataDirectory = this.getWriteDirectory(writeSize);
            File sstableDirectory = Memtable.this.cfs.getDirectories().getLocationForDisk(dataDirectory);
            assert (sstableDirectory != null) : "Flush task is not bound to any disk";
            Collection<SSTableReader> sstables = this.writeSortedContents(this.context, sstableDirectory);
            Memtable.this.cfs.replaceFlushed(Memtable.this, sstables);
        }

        @Override
        protected Directories getDirectories() {
            return Memtable.this.cfs.getDirectories();
        }

        private Collection<SSTableReader> writeSortedContents(ReplayPosition context, File sstableDirectory) {
            logger.info("Writing {}", (Object)Memtable.this.toString());
            try (SSTableTxnWriter writer = this.createFlushWriter(Memtable.this.cfs.getSSTablePath(sstableDirectory), Memtable.this.columnsCollector.get(), Memtable.this.statsCollector.get());){
                Collection<SSTableReader> ssTables;
                boolean trackContention = logger.isDebugEnabled();
                int heavilyContendedRowCount = 0;
                for (AtomicBTreePartition partition : Memtable.this.partitions.values()) {
                    if (this.isBatchLogTable && !partition.partitionLevelDeletion().isLive() && partition.hasRows()) continue;
                    if (trackContention && partition.usePessimisticLocking()) {
                        ++heavilyContendedRowCount;
                    }
                    if (partition.isEmpty()) continue;
                    UnfilteredRowIterator iter = partition.unfilteredIterator();
                    Throwable throwable = null;
                    try {
                        writer.append(iter);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iter == null) continue;
                        if (throwable != null) {
                            try {
                                iter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iter.close();
                    }
                }
                if (writer.getFilePointer() > 0L) {
                    logger.info(String.format("Completed flushing %s (%s) for commitlog position %s", writer.getFilename(), FBUtilities.prettyPrintMemory(writer.getFilePointer()), context));
                    ssTables = writer.finish(true);
                } else {
                    logger.info("Completed flushing {}; nothing needed to be retained.  Commitlog position was {}", (Object)writer.getFilename(), (Object)context);
                    writer.abort();
                    ssTables = null;
                }
                if (heavilyContendedRowCount > 0) {
                    logger.debug(String.format("High update contention in %d/%d partitions of %s ", heavilyContendedRowCount, Memtable.this.partitions.size(), Memtable.this.toString()));
                }
                Iterator iterator = ssTables;
                return iterator;
            }
        }

        public SSTableTxnWriter createFlushWriter(String filename, PartitionColumns columns, EncodingStats stats) {
            LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.FLUSH, Memtable.this.cfs.metadata);
            MetadataCollector sstableMetadataCollector = new MetadataCollector(Memtable.this.cfs.metadata.comparator).replayPosition(this.context);
            return new SSTableTxnWriter(txn, Memtable.this.cfs.createSSTableMultiWriter(Descriptor.fromFilename(filename), (long)Memtable.this.partitions.size(), 0L, sstableMetadataCollector, new SerializationHeader(Memtable.this.cfs.metadata, columns, stats), txn));
        }
    }

    public static final class LastReplayPosition
    extends ReplayPosition {
        public LastReplayPosition(ReplayPosition copy) {
            super(copy.segment, copy.position);
        }
    }
}

