/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.view.MaterializedView;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class DropMaterializedViewStatement
extends SchemaAlteringStatement {
    public final boolean ifExists;

    public DropMaterializedViewStatement(CFName cf, boolean ifExists) {
        super(cf);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData baseTable = MaterializedView.findBaseTable(this.keyspace(), this.columnFamily());
        if (baseTable != null) {
            state.hasColumnFamilyAccess(this.keyspace(), baseTable.cfName, Permission.ALTER);
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        try {
            CFMetaData viewCfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily());
            if (viewCfm == null) {
                throw new ConfigurationException(String.format("Cannot drop non existing materialized view '%s' in keyspace '%s'.", this.columnFamily(), this.keyspace()));
            }
            if (!viewCfm.isMaterializedView()) {
                throw new ConfigurationException(String.format("Cannot drop non materialized view '%s' in keyspace '%s'", this.columnFamily(), this.keyspace()));
            }
            CFMetaData baseCfm = MaterializedView.findBaseTable(this.keyspace(), this.columnFamily());
            if (baseCfm == null) {
                if (this.ifExists) {
                    throw new ConfigurationException(String.format("Cannot drop materialized view '%s' in keyspace '%s' without base CF.", this.columnFamily(), this.keyspace()));
                }
                throw new InvalidRequestException(String.format("View '%s' could not be found in any of the tables of keyspace '%s'", this.cfName, this.keyspace()));
            }
            CFMetaData updatedCfm = baseCfm.copy();
            updatedCfm.materializedViews(updatedCfm.getMaterializedViews().without(this.columnFamily()));
            MigrationManager.announceColumnFamilyUpdate(updatedCfm, false, isLocalOnly);
            MigrationManager.announceColumnFamilyDrop(this.keyspace(), this.columnFamily(), isLocalOnly);
            return true;
        }
        catch (ConfigurationException e) {
            if (this.ifExists) {
                return false;
            }
            throw e;
        }
    }
}

