/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.MaterializedViewDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.cql3.statements.TableAttributes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type.Raw validator;
    public final ColumnIdentifier.Raw rawColumnName;
    private final TableAttributes attrs;
    private final Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames;
    private final boolean isStatic;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier.Raw columnName, CQL3Type.Raw validator, TableAttributes attrs, Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames, boolean isStatic) {
        super(name);
        this.oType = type;
        this.rawColumnName = columnName;
        this.validator = validator;
        this.attrs = attrs;
        this.renames = renames;
        this.isStatic = isStatic;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (meta.isMaterializedView()) {
            throw new InvalidRequestException("Cannot use ALTER TABLE on Materialized View");
        }
        CFMetaData cfm = meta.copy();
        CQL3Type validator = this.validator == null ? null : this.validator.prepare(this.keyspace());
        ColumnIdentifier columnName = null;
        ColumnDefinition def = null;
        if (this.rawColumnName != null) {
            columnName = this.rawColumnName.prepare(cfm);
            def = cfm.getColumnDefinition(columnName);
        }
        ArrayList<CFMetaData> materializedViewUpdates = null;
        switch (this.oType) {
            case ADD: {
                assert (columnName != null);
                if (cfm.isDense()) {
                    throw new InvalidRequestException("Cannot add new column to a COMPACT STORAGE table");
                }
                if (this.isStatic) {
                    if (!cfm.isCompound()) {
                        throw new InvalidRequestException("Static columns are not allowed in COMPACT STORAGE tables");
                    }
                    if (cfm.clusteringColumns().isEmpty()) {
                        throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
                    }
                }
                if (def != null) {
                    switch (def.kind) {
                        case PARTITION_KEY: 
                        case CLUSTERING: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", columnName));
                        }
                    }
                    throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", columnName));
                }
                if (meta.isCounter() && meta.getDroppedColumns().containsKey(columnName.bytes)) {
                    throw new InvalidRequestException(String.format("Cannot re-add previously dropped counter column %s", columnName));
                }
                AbstractType<?> type = validator.getType();
                if (type.isCollection() && type.isMultiCell()) {
                    if (!cfm.isCompound()) {
                        throw new InvalidRequestException("Cannot use non-frozen collections in COMPACT STORAGE tables");
                    }
                    if (cfm.isSuper()) {
                        throw new InvalidRequestException("Cannot use non-frozen collections with super column families");
                    }
                    CFMetaData.DroppedColumn dropped = cfm.getDroppedColumns().get(columnName.bytes);
                    if (dropped != null && dropped.type instanceof CollectionType && dropped.type.isMultiCell() && !type.isCompatibleWith(dropped.type)) {
                        String message = String.format("Cannot add a collection with the name %s because a collection with the same name and a different type (%s) has already been used in the past", columnName, dropped.type.asCQL3Type());
                        throw new InvalidRequestException(message);
                    }
                }
                cfm.addColumnDefinition(this.isStatic ? ColumnDefinition.staticDef(cfm, columnName.bytes, type) : ColumnDefinition.regularDef(cfm, columnName.bytes, type));
                for (MaterializedViewDefinition mv : cfm.getMaterializedViews()) {
                    if (!mv.includeAll) continue;
                    CFMetaData indexCfm = Schema.instance.getCFMetaData(this.keyspace(), mv.viewName).copy();
                    indexCfm.addColumnDefinition(this.isStatic ? ColumnDefinition.staticDef(indexCfm, columnName.bytes, type) : ColumnDefinition.regularDef(indexCfm, columnName.bytes, type));
                    if (materializedViewUpdates == null) {
                        materializedViewUpdates = new ArrayList();
                    }
                    materializedViewUpdates.add(indexCfm);
                }
                break;
            }
            case ALTER: {
                assert (columnName != null);
                if (def == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                AbstractType<?> validatorType = validator.getType();
                switch (def.kind) {
                    case PARTITION_KEY: {
                        if (validatorType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", columnName));
                        }
                        AbstractType<?> currentType = cfm.getKeyValidatorAsClusteringComparator().subtype(def.position());
                        if (validatorType.isValueCompatibleWith(currentType)) break;
                        throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, currentType.asCQL3Type(), validator));
                    }
                    case CLUSTERING: {
                        AbstractType<?> oldType = cfm.comparator.subtype(def.position());
                        if (validatorType.isCompatibleWith(oldType)) break;
                        throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are not order-compatible.", columnName, oldType.asCQL3Type(), validator));
                    }
                    case REGULAR: 
                    case STATIC: {
                        if (validatorType.isValueCompatibleWith(def.type)) break;
                        throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", columnName, def.type.asCQL3Type(), validator));
                    }
                }
                cfm.addOrReplaceColumnDefinition(def.withNewType(validatorType));
                for (Object mv : cfm.getMaterializedViews()) {
                    if (!((MaterializedViewDefinition)mv).includes(columnName)) continue;
                    CFMetaData indexCfm = Schema.instance.getCFMetaData(this.keyspace(), ((MaterializedViewDefinition)mv).viewName).copy();
                    indexCfm.addOrReplaceColumnDefinition(def.withNewType(validatorType));
                    if (materializedViewUpdates == null) {
                        materializedViewUpdates = new ArrayList<CFMetaData>();
                    }
                    materializedViewUpdates.add(indexCfm);
                }
                break;
            }
            case DROP: {
                assert (columnName != null);
                if (!cfm.isCQLTable()) {
                    throw new InvalidRequestException("Cannot drop columns from a non-CQL3 table");
                }
                if (def == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", columnName, this.columnFamily()));
                }
                switch (def.kind) {
                    case PARTITION_KEY: 
                    case CLUSTERING: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", columnName));
                    }
                    case REGULAR: 
                    case STATIC: {
                        Object toDelete = null;
                        for (Object columnDef : cfm.partitionColumns()) {
                            if (!((ColumnDefinition)columnDef).name.equals(columnName)) continue;
                            toDelete = columnDef;
                            break;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition((ColumnDefinition)toDelete);
                        cfm.recordColumnDrop((ColumnDefinition)toDelete);
                    }
                }
                Indexes allIndexes = cfm.getIndexes();
                Collection<IndexMetadata> indexes = allIndexes.get(def);
                for (IndexMetadata index : indexes) {
                    assert (index.columns.size() == 1) : String.format("Can't drop column %s as it's a target of multi-column index %s", def.name, index.name);
                    allIndexes = allIndexes.without(index.name);
                }
                cfm.indexes(allIndexes);
                boolean rejectAlter = false;
                StringBuilder builder = new StringBuilder();
                for (MaterializedViewDefinition mv : cfm.getMaterializedViews()) {
                    if (!mv.includes(columnName)) continue;
                    if (rejectAlter) {
                        builder.append(',');
                    }
                    rejectAlter = true;
                    builder.append(mv.viewName);
                }
                if (!rejectAlter) break;
                throw new InvalidRequestException(String.format("Cannot drop column %s, depended on by materialized views (%s.{%s})", columnName.toString(), this.keyspace(), builder.toString()));
            }
            case OPTS: {
                if (this.attrs == null) {
                    throw new InvalidRequestException("ALTER TABLE WITH invoked, but no parameters found");
                }
                this.attrs.validate();
                TableParams params = this.attrs.asAlteredTableParams(cfm.params);
                if (cfm.hasMaterializedViews() && params.gcGraceSeconds == 0) {
                    throw new InvalidRequestException("Cannot alter gc_grace_seconds of the base table of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.");
                }
                if (meta.isCounter() && params.defaultTimeToLive > 0) {
                    throw new InvalidRequestException("Cannot set default_time_to_live on a table with counters");
                }
                cfm.params(params);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier.Raw, ColumnIdentifier.Raw> entry : this.renames.entrySet()) {
                    ColumnIdentifier from = entry.getKey().prepare(cfm);
                    ColumnIdentifier to = entry.getValue().prepare(cfm);
                    cfm.renameColumn(from, to);
                    for (MaterializedViewDefinition mv : cfm.getMaterializedViews()) {
                        if (!mv.includes(from)) continue;
                        CFMetaData indexCfm = Schema.instance.getCFMetaData(this.keyspace(), mv.viewName).copy();
                        ColumnIdentifier indexFrom = entry.getKey().prepare(indexCfm);
                        ColumnIdentifier indexTo = entry.getValue().prepare(indexCfm);
                        indexCfm.renameColumn(indexFrom, indexTo);
                        MaterializedViewDefinition mvCopy = new MaterializedViewDefinition(mv);
                        mvCopy.renameColumn(from, to);
                        cfm.materializedViews(cfm.getMaterializedViews().replace(mvCopy));
                        if (materializedViewUpdates == null) {
                            materializedViewUpdates = new ArrayList();
                        }
                        materializedViewUpdates.add(indexCfm);
                    }
                }
                break;
            }
        }
        if (materializedViewUpdates != null) {
            for (CFMetaData mvUpdates : materializedViewUpdates) {
                MigrationManager.announceColumnFamilyUpdate(mvUpdates, false, isLocalOnly);
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, false, isLocalOnly);
        return true;
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.rawColumnName, this.validator});
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

