/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.ChecksummedRandomAccessReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.LengthAvailableInputStream;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.WrappedDataOutputStreamPlus;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSavingCache<K extends CacheKey, V>
extends InstrumentingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AutoSavingCache.class);
    public static final Set<CacheService.CacheType> flushInProgress = new NonBlockingHashSet();
    protected volatile ScheduledFuture<?> saveTask;
    protected final CacheService.CacheType cacheType;
    private final CacheSerializer<K, V> cacheLoader;
    private static final String CURRENT_VERSION = "d";
    private static volatile IStreamFactory streamFactory = new IStreamFactory(){

        @Override
        public InputStream getInputStream(File dataPath, File crcPath) throws IOException {
            return new ChecksummedRandomAccessReader.Builder(dataPath, crcPath).build();
        }

        @Override
        public OutputStream getOutputStream(File dataPath, File crcPath) {
            return SequentialWriter.open(dataPath, crcPath).finishOnClose();
        }
    };

    public static void setStreamFactory(IStreamFactory streamFactory) {
        AutoSavingCache.streamFactory = streamFactory;
    }

    public AutoSavingCache(ICache<K, V> cache, CacheService.CacheType cacheType, CacheSerializer<K, V> cacheloader) {
        super(cacheType.toString(), cache);
        this.cacheType = cacheType;
        this.cacheLoader = cacheloader;
    }

    public File getCacheDataPath(UUID cfId, String version) {
        Pair<String, String> names = Schema.instance.getCF(cfId);
        return DatabaseDescriptor.getSerializedCachePath((String)names.left, (String)names.right, cfId, this.cacheType, version, "db");
    }

    public File getCacheCrcPath(UUID cfId, String version) {
        Pair<String, String> names = Schema.instance.getCF(cfId);
        return DatabaseDescriptor.getSerializedCachePath((String)names.left, (String)names.right, cfId, this.cacheType, version, "crc");
    }

    public Writer getWriter(int keysToSave) {
        return new Writer(keysToSave);
    }

    public void scheduleSaving(int savePeriodInSeconds, final int keysToSave) {
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
            this.saveTask = null;
        }
        if (savePeriodInSeconds > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AutoSavingCache.this.submitWrite(keysToSave);
                }
            };
            this.saveTask = ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(runnable, savePeriodInSeconds, savePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public int loadSaved(ColumnFamilyStore cfs) {
        File dataPath;
        long start;
        int count;
        block11: {
            count = 0;
            start = System.nanoTime();
            dataPath = this.getCacheDataPath(cfs.metadata.cfId, CURRENT_VERSION);
            File crcPath = this.getCacheCrcPath(cfs.metadata.cfId, CURRENT_VERSION);
            if (dataPath.exists() && crcPath.exists()) {
                DataInputPlus.DataInputStreamPlus in = null;
                try {
                    logger.info(String.format("reading saved cache %s", dataPath));
                    in = new DataInputPlus.DataInputStreamPlus(new LengthAvailableInputStream(new BufferedInputStream(streamFactory.getInputStream(dataPath, crcPath)), dataPath.length()));
                    ArrayList<Future<Pair<K, V>>> futures = new ArrayList<Future<Pair<K, V>>>();
                    while (in.available() > 0) {
                        Future<Pair<K, V>> entry = this.cacheLoader.deserialize(in, cfs);
                        if (entry == null) continue;
                        futures.add(entry);
                        ++count;
                    }
                    for (Future future : futures) {
                        Pair entry = (Pair)future.get();
                        if (entry == null || entry.right == null) continue;
                        this.put(entry.left, entry.right);
                    }
                    FileUtils.closeQuietly(in);
                }
                catch (ChecksummedRandomAccessReader.CorruptFileException e) {
                    JVMStabilityInspector.inspectThrowable(e);
                    logger.warn(String.format("Non-fatal checksum error reading saved cache %s", dataPath.getAbsolutePath()), (Throwable)e);
                }
                catch (Exception e2) {
                    JVMStabilityInspector.inspectThrowable(e2);
                    logger.debug(String.format("harmless error reading saved cache %s", dataPath.getAbsolutePath()), (Throwable)e2);
                    break block11;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    FileUtils.closeQuietly(in);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("completed reading ({} ms; {} keys) saved cache {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), count, dataPath});
        }
        return count;
    }

    public Future<?> submitWrite(int keysToSave) {
        return CompactionManager.instance.submitCacheWrite(this.getWriter(keysToSave));
    }

    public static interface CacheSerializer<K extends CacheKey, V> {
        public void serialize(K var1, DataOutputPlus var2) throws IOException;

        public Future<Pair<K, V>> deserialize(DataInputPlus var1, ColumnFamilyStore var2) throws IOException;
    }

    public class Writer
    extends CompactionInfo.Holder {
        private final Iterator<K> keyIterator;
        private final CompactionInfo info;
        private long keysWritten;
        private final long keysEstimate;

        protected Writer(int keysToSave) {
            int size = AutoSavingCache.this.size();
            if (keysToSave >= size || keysToSave == 0) {
                this.keyIterator = AutoSavingCache.this.keyIterator();
                this.keysEstimate = size;
            } else {
                this.keyIterator = AutoSavingCache.this.hotKeyIterator(keysToSave);
                this.keysEstimate = keysToSave;
            }
            OperationType type = AutoSavingCache.this.cacheType == CacheService.CacheType.KEY_CACHE ? OperationType.KEY_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.ROW_CACHE ? OperationType.ROW_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.COUNTER_CACHE ? OperationType.COUNTER_CACHE_SAVE : OperationType.UNKNOWN));
            this.info = new CompactionInfo(CFMetaData.createFake("system", AutoSavingCache.this.cacheType.toString()), type, 0L, this.keysEstimate, "keys", UUIDGen.getTimeUUID());
        }

        public CacheService.CacheType cacheType() {
            return AutoSavingCache.this.cacheType;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            return this.info.forProgress(this.keysWritten, Math.max(this.keysWritten, this.keysEstimate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveCache() {
            logger.debug("Deleting old {} files.", (Object)AutoSavingCache.this.cacheType);
            this.deleteOldCacheFiles();
            if (!this.keyIterator.hasNext()) {
                logger.debug("Skipping {} save, cache is empty.", (Object)AutoSavingCache.this.cacheType);
                return;
            }
            long start = System.nanoTime();
            HashMap<UUID, DataOutputPlus> writers = new HashMap<UUID, DataOutputPlus>();
            HashMap<UUID, OutputStream> streams = new HashMap<UUID, OutputStream>();
            HashMap<UUID, Pair<File, File>> paths = new HashMap<UUID, Pair<File, File>>();
            try {
                while (this.keyIterator.hasNext()) {
                    CacheKey key = (CacheKey)this.keyIterator.next();
                    UUID uUID = key.getCFId();
                    if (!Schema.instance.hasCF(key.getCFId())) continue;
                    DataOutputPlus writer = (DataOutputPlus)writers.get(uUID);
                    if (writer == null) {
                        OutputStream stream;
                        Pair<File, File> cacheFilePaths = this.tempCacheFiles(uUID);
                        try {
                            stream = streamFactory.getOutputStream((File)cacheFilePaths.left, (File)cacheFilePaths.right);
                            writer = new WrappedDataOutputStreamPlus(stream);
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        paths.put(uUID, cacheFilePaths);
                        streams.put(uUID, stream);
                        writers.put(uUID, writer);
                    }
                    try {
                        AutoSavingCache.this.cacheLoader.serialize(key, writer);
                    }
                    catch (IOException e) {
                        throw new FSWriteError((Throwable)e, (File)((Pair)paths.get((Object)uUID)).left);
                    }
                    ++this.keysWritten;
                    if (this.keysWritten < this.keysEstimate) continue;
                    break;
                }
            }
            finally {
                if (this.keyIterator instanceof Closeable) {
                    try {
                        ((Closeable)((Object)this.keyIterator)).close();
                    }
                    catch (IOException iOException) {}
                }
                for (OutputStream outputStream : streams.values()) {
                    FileUtils.closeQuietly(outputStream);
                }
            }
            for (Map.Entry entry : writers.entrySet()) {
                UUID cfId = (UUID)entry.getKey();
                Pair tmpFiles = (Pair)paths.get(cfId);
                File cacheFile = AutoSavingCache.this.getCacheDataPath(cfId, AutoSavingCache.CURRENT_VERSION);
                File crcFile = AutoSavingCache.this.getCacheCrcPath(cfId, AutoSavingCache.CURRENT_VERSION);
                cacheFile.delete();
                crcFile.delete();
                if (!((File)tmpFiles.left).renameTo(cacheFile)) {
                    logger.error("Unable to rename {} to {}", tmpFiles.left, (Object)cacheFile);
                }
                if (((File)tmpFiles.right).renameTo(crcFile)) continue;
                logger.error("Unable to rename {} to {}", tmpFiles.right, (Object)crcFile);
            }
            logger.info("Saved {} ({} items) in {} ms", new Object[]{AutoSavingCache.this.cacheType, this.keysWritten, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        }

        private Pair<File, File> tempCacheFiles(UUID cfId) {
            File dataPath = AutoSavingCache.this.getCacheDataPath(cfId, AutoSavingCache.CURRENT_VERSION);
            File crcPath = AutoSavingCache.this.getCacheCrcPath(cfId, AutoSavingCache.CURRENT_VERSION);
            return Pair.create(FileUtils.createTempFile(dataPath.getName(), null, dataPath.getParentFile()), FileUtils.createTempFile(crcPath.getName(), null, crcPath.getParentFile()));
        }

        private void deleteOldCacheFiles() {
            File savedCachesDir = new File(DatabaseDescriptor.getSavedCachesLocation());
            assert (savedCachesDir.exists() && savedCachesDir.isDirectory());
            File[] files = savedCachesDir.listFiles();
            if (files != null) {
                String cacheNameFormat = String.format("%s-%s.db", AutoSavingCache.this.cacheType.toString(), AutoSavingCache.CURRENT_VERSION);
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(cacheNameFormat) && !file.getName().endsWith(AutoSavingCache.this.cacheType.toString()) || file.delete()) continue;
                    logger.warn("Failed to delete {}", (Object)file.getAbsolutePath());
                }
            } else {
                logger.warn("Could not list files in {}", (Object)savedCachesDir);
            }
        }
    }

    public static interface IStreamFactory {
        public InputStream getInputStream(File var1, File var2) throws IOException;

        public OutputStream getOutputStream(File var1, File var2) throws FileNotFoundException;
    }
}

