// $ANTLR 3.5.2 /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2015-09-04 20:39:35

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.*;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.selection.*;
    import org.apache.cassandra.cql3.functions.*;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class CqlParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "B", "BOOLEAN", "C", "COMMENT", 
		"D", "DIGIT", "E", "EXPONENT", "F", "FLOAT", "G", "H", "HEX", "HEXNUMBER", 
		"I", "IDENT", "INTEGER", "J", "K", "K_ADD", "K_AGGREGATE", "K_ALL", "K_ALLOW", 
		"K_ALTER", "K_AND", "K_APPLY", "K_AS", "K_ASC", "K_ASCII", "K_AUTHORIZE", 
		"K_BATCH", "K_BEGIN", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_BY", "K_CALLED", 
		"K_CLUSTERING", "K_COLUMNFAMILY", "K_COMPACT", "K_CONTAINS", "K_COUNT", 
		"K_COUNTER", "K_CREATE", "K_CUSTOM", "K_DATE", "K_DECIMAL", "K_DELETE", 
		"K_DESC", "K_DESCRIBE", "K_DISTINCT", "K_DOUBLE", "K_DROP", "K_ENTRIES", 
		"K_EXECUTE", "K_EXISTS", "K_FILTERING", "K_FINALFUNC", "K_FLOAT", "K_FROM", 
		"K_FROZEN", "K_FULL", "K_FUNCTION", "K_FUNCTIONS", "K_GRANT", "K_IF", 
		"K_IN", "K_INDEX", "K_INET", "K_INFINITY", "K_INITCOND", "K_INPUT", "K_INSERT", 
		"K_INT", "K_INTO", "K_IS", "K_JSON", "K_KEY", "K_KEYS", "K_KEYSPACE", 
		"K_KEYSPACES", "K_LANGUAGE", "K_LIMIT", "K_LIST", "K_LOGIN", "K_MAP", 
		"K_MATERIALIZED", "K_MODIFY", "K_NAN", "K_NOLOGIN", "K_NORECURSIVE", "K_NOSUPERUSER", 
		"K_NOT", "K_NULL", "K_OF", "K_ON", "K_OPTIONS", "K_OR", "K_ORDER", "K_PASSWORD", 
		"K_PERMISSION", "K_PERMISSIONS", "K_PRIMARY", "K_RENAME", "K_REPLACE", 
		"K_RETURNS", "K_REVOKE", "K_ROLE", "K_ROLES", "K_SELECT", "K_SET", "K_SFUNC", 
		"K_SMALLINT", "K_STATIC", "K_STORAGE", "K_STYPE", "K_SUPERUSER", "K_TEXT", 
		"K_TIME", "K_TIMESTAMP", "K_TIMEUUID", "K_TINYINT", "K_TO", "K_TOKEN", 
		"K_TRIGGER", "K_TRUNCATE", "K_TTL", "K_TUPLE", "K_TYPE", "K_UNLOGGED", 
		"K_UPDATE", "K_USE", "K_USER", "K_USERS", "K_USING", "K_UUID", "K_VALUES", 
		"K_VARCHAR", "K_VARINT", "K_VIEW", "K_WHERE", "K_WITH", "K_WRITETIME", 
		"L", "LETTER", "M", "MULTILINE_COMMENT", "N", "O", "P", "Q", "QMARK", 
		"QUOTED_NAME", "R", "S", "STRING_LITERAL", "T", "U", "UUID", "V", "W", 
		"WS", "X", "Y", "Z", "'!='", "'('", "')'", "'+'", "','", "'-'", "'.'", 
		"':'", "';'", "'<'", "'<='", "'='", "'>'", "'>='", "'['", "'\\*'", "']'", 
		"'{'", "'}'"
	};
	public static final int EOF=-1;
	public static final int T__170=170;
	public static final int T__171=171;
	public static final int T__172=172;
	public static final int T__173=173;
	public static final int T__174=174;
	public static final int T__175=175;
	public static final int T__176=176;
	public static final int T__177=177;
	public static final int T__178=178;
	public static final int T__179=179;
	public static final int T__180=180;
	public static final int T__181=181;
	public static final int T__182=182;
	public static final int T__183=183;
	public static final int T__184=184;
	public static final int T__185=185;
	public static final int T__186=186;
	public static final int T__187=187;
	public static final int T__188=188;
	public static final int A=4;
	public static final int B=5;
	public static final int BOOLEAN=6;
	public static final int C=7;
	public static final int COMMENT=8;
	public static final int D=9;
	public static final int DIGIT=10;
	public static final int E=11;
	public static final int EXPONENT=12;
	public static final int F=13;
	public static final int FLOAT=14;
	public static final int G=15;
	public static final int H=16;
	public static final int HEX=17;
	public static final int HEXNUMBER=18;
	public static final int I=19;
	public static final int IDENT=20;
	public static final int INTEGER=21;
	public static final int J=22;
	public static final int K=23;
	public static final int K_ADD=24;
	public static final int K_AGGREGATE=25;
	public static final int K_ALL=26;
	public static final int K_ALLOW=27;
	public static final int K_ALTER=28;
	public static final int K_AND=29;
	public static final int K_APPLY=30;
	public static final int K_AS=31;
	public static final int K_ASC=32;
	public static final int K_ASCII=33;
	public static final int K_AUTHORIZE=34;
	public static final int K_BATCH=35;
	public static final int K_BEGIN=36;
	public static final int K_BIGINT=37;
	public static final int K_BLOB=38;
	public static final int K_BOOLEAN=39;
	public static final int K_BY=40;
	public static final int K_CALLED=41;
	public static final int K_CLUSTERING=42;
	public static final int K_COLUMNFAMILY=43;
	public static final int K_COMPACT=44;
	public static final int K_CONTAINS=45;
	public static final int K_COUNT=46;
	public static final int K_COUNTER=47;
	public static final int K_CREATE=48;
	public static final int K_CUSTOM=49;
	public static final int K_DATE=50;
	public static final int K_DECIMAL=51;
	public static final int K_DELETE=52;
	public static final int K_DESC=53;
	public static final int K_DESCRIBE=54;
	public static final int K_DISTINCT=55;
	public static final int K_DOUBLE=56;
	public static final int K_DROP=57;
	public static final int K_ENTRIES=58;
	public static final int K_EXECUTE=59;
	public static final int K_EXISTS=60;
	public static final int K_FILTERING=61;
	public static final int K_FINALFUNC=62;
	public static final int K_FLOAT=63;
	public static final int K_FROM=64;
	public static final int K_FROZEN=65;
	public static final int K_FULL=66;
	public static final int K_FUNCTION=67;
	public static final int K_FUNCTIONS=68;
	public static final int K_GRANT=69;
	public static final int K_IF=70;
	public static final int K_IN=71;
	public static final int K_INDEX=72;
	public static final int K_INET=73;
	public static final int K_INFINITY=74;
	public static final int K_INITCOND=75;
	public static final int K_INPUT=76;
	public static final int K_INSERT=77;
	public static final int K_INT=78;
	public static final int K_INTO=79;
	public static final int K_IS=80;
	public static final int K_JSON=81;
	public static final int K_KEY=82;
	public static final int K_KEYS=83;
	public static final int K_KEYSPACE=84;
	public static final int K_KEYSPACES=85;
	public static final int K_LANGUAGE=86;
	public static final int K_LIMIT=87;
	public static final int K_LIST=88;
	public static final int K_LOGIN=89;
	public static final int K_MAP=90;
	public static final int K_MATERIALIZED=91;
	public static final int K_MODIFY=92;
	public static final int K_NAN=93;
	public static final int K_NOLOGIN=94;
	public static final int K_NORECURSIVE=95;
	public static final int K_NOSUPERUSER=96;
	public static final int K_NOT=97;
	public static final int K_NULL=98;
	public static final int K_OF=99;
	public static final int K_ON=100;
	public static final int K_OPTIONS=101;
	public static final int K_OR=102;
	public static final int K_ORDER=103;
	public static final int K_PASSWORD=104;
	public static final int K_PERMISSION=105;
	public static final int K_PERMISSIONS=106;
	public static final int K_PRIMARY=107;
	public static final int K_RENAME=108;
	public static final int K_REPLACE=109;
	public static final int K_RETURNS=110;
	public static final int K_REVOKE=111;
	public static final int K_ROLE=112;
	public static final int K_ROLES=113;
	public static final int K_SELECT=114;
	public static final int K_SET=115;
	public static final int K_SFUNC=116;
	public static final int K_SMALLINT=117;
	public static final int K_STATIC=118;
	public static final int K_STORAGE=119;
	public static final int K_STYPE=120;
	public static final int K_SUPERUSER=121;
	public static final int K_TEXT=122;
	public static final int K_TIME=123;
	public static final int K_TIMESTAMP=124;
	public static final int K_TIMEUUID=125;
	public static final int K_TINYINT=126;
	public static final int K_TO=127;
	public static final int K_TOKEN=128;
	public static final int K_TRIGGER=129;
	public static final int K_TRUNCATE=130;
	public static final int K_TTL=131;
	public static final int K_TUPLE=132;
	public static final int K_TYPE=133;
	public static final int K_UNLOGGED=134;
	public static final int K_UPDATE=135;
	public static final int K_USE=136;
	public static final int K_USER=137;
	public static final int K_USERS=138;
	public static final int K_USING=139;
	public static final int K_UUID=140;
	public static final int K_VALUES=141;
	public static final int K_VARCHAR=142;
	public static final int K_VARINT=143;
	public static final int K_VIEW=144;
	public static final int K_WHERE=145;
	public static final int K_WITH=146;
	public static final int K_WRITETIME=147;
	public static final int L=148;
	public static final int LETTER=149;
	public static final int M=150;
	public static final int MULTILINE_COMMENT=151;
	public static final int N=152;
	public static final int O=153;
	public static final int P=154;
	public static final int Q=155;
	public static final int QMARK=156;
	public static final int QUOTED_NAME=157;
	public static final int R=158;
	public static final int S=159;
	public static final int STRING_LITERAL=160;
	public static final int T=161;
	public static final int U=162;
	public static final int UUID=163;
	public static final int V=164;
	public static final int W=165;
	public static final int WS=166;
	public static final int X=167;
	public static final int Y=168;
	public static final int Z=169;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CqlParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CqlParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CqlParser.tokenNames; }
	@Override public String getGrammarFileName() { return "/tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


	    private final List<ErrorListener> listeners = new ArrayList<ErrorListener>();
	    private final List<ColumnIdentifier> bindVariables = new ArrayList<ColumnIdentifier>();

	    public static final Set<String> reservedTypeNames = new HashSet<String>()
	    {{
	        add("byte");
	        add("complex");
	        add("enum");
	        add("date");
	        add("interval");
	        add("macaddr");
	        add("bitstring");
	    }};

	    public AbstractMarker.Raw newBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.Raw marker = new AbstractMarker.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public AbstractMarker.INRaw newINBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.INRaw marker = new AbstractMarker.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.Raw newTupleBindVariables(ColumnIdentifier name)
	    {
	        Tuples.Raw marker = new Tuples.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.INRaw newTupleINBindVariables(ColumnIdentifier name)
	    {
	        Tuples.INRaw marker = new Tuples.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Json.Marker newJsonBindVariables(ColumnIdentifier name)
	    {
	        Json.Marker marker = new Json.Marker(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public void addErrorListener(ErrorListener listener)
	    {
	        this.listeners.add(listener);
	    }

	    public void removeErrorListener(ErrorListener listener)
	    {
	        this.listeners.remove(listener);
	    }

	    public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, tokenNames, e);
	    }

	    private void addRecognitionError(String msg)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, msg);
	    }

	    public Map<String, String> convertPropertyMap(Maps.Literal map)
	    {
	        if (map == null || map.entries == null || map.entries.isEmpty())
	            return Collections.<String, String>emptyMap();

	        Map<String, String> res = new HashMap<String, String>(map.entries.size());

	        for (Pair<Term.Raw, Term.Raw> entry : map.entries)
	        {
	            // Because the parser tries to be smart and recover on error (to
	            // allow displaying more than one error I suppose), we have null
	            // entries in there. Just skip those, a proper error will be thrown in the end.
	            if (entry.left == null || entry.right == null)
	                break;

	            if (!(entry.left instanceof Constants.Literal))
	            {
	                String msg = "Invalid property name: " + entry.left;
	                if (entry.left instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }
	            if (!(entry.right instanceof Constants.Literal))
	            {
	                String msg = "Invalid property value: " + entry.right + " for property: " + entry.left;
	                if (entry.right instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }

	            res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
	        }

	        return res;
	    }

	    public void addRawUpdate(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Operation.RawUpdate update)
	    {
	        for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> p : operations)
	        {
	            if (p.left.equals(key) && !p.right.isCompatibleWith(update))
	                addRecognitionError("Multiple incompatible setting of column " + key);
	        }
	        operations.add(Pair.create(key, update));
	    }

	    public Set<Permission> filterPermissions(Set<Permission> permissions, IResource resource)
	    {
	        if (resource == null)
	            return Collections.emptySet();
	        Set<Permission> filtered = new HashSet<>(permissions);
	        filtered.retainAll(resource.applicablePermissions());
	        if (filtered.isEmpty())
	            addRecognitionError("Resource type " + resource.getClass().getSimpleName() +
	                                    " does not support any of the requested permissions");

	        return filtered;
	    }



	// $ANTLR start "query"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:230:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
	public final ParsedStatement query() throws RecognitionException {
		ParsedStatement stmnt = null;


		ParsedStatement st =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:5: (st= cqlStatement ( ';' )* EOF )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:7: st= cqlStatement ( ';' )* EOF
			{
			pushFollow(FOLLOW_cqlStatement_in_query72);
			st=cqlStatement();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:23: ( ';' )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==178) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:24: ';'
					{
					match(input,178,FOLLOW_178_in_query75); 
					}
					break;

				default :
					break loop1;
				}
			}

			match(input,EOF,FOLLOW_EOF_in_query79); 
			 stmnt = st; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "query"



	// $ANTLR start "cqlStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement );
	public final ParsedStatement cqlStatement() throws RecognitionException {
		ParsedStatement stmt = null;


		SelectStatement.RawStatement st1 =null;
		ModificationStatement.Parsed st2 =null;
		UpdateStatement.ParsedUpdate st3 =null;
		BatchStatement.Parsed st4 =null;
		DeleteStatement.Parsed st5 =null;
		UseStatement st6 =null;
		TruncateStatement st7 =null;
		CreateKeyspaceStatement st8 =null;
		CreateTableStatement.RawStatement st9 =null;
		CreateIndexStatement st10 =null;
		DropKeyspaceStatement st11 =null;
		DropTableStatement st12 =null;
		DropIndexStatement st13 =null;
		AlterTableStatement st14 =null;
		AlterKeyspaceStatement st15 =null;
		GrantPermissionsStatement st16 =null;
		RevokePermissionsStatement st17 =null;
		ListPermissionsStatement st18 =null;
		CreateRoleStatement st19 =null;
		AlterRoleStatement st20 =null;
		DropRoleStatement st21 =null;
		ListRolesStatement st22 =null;
		CreateTriggerStatement st23 =null;
		DropTriggerStatement st24 =null;
		CreateTypeStatement st25 =null;
		AlterTypeStatement st26 =null;
		DropTypeStatement st27 =null;
		CreateFunctionStatement st28 =null;
		DropFunctionStatement st29 =null;
		CreateAggregateStatement st30 =null;
		DropAggregateStatement st31 =null;
		CreateRoleStatement st32 =null;
		AlterRoleStatement st33 =null;
		DropRoleStatement st34 =null;
		ListRolesStatement st35 =null;
		GrantRoleStatement st36 =null;
		RevokeRoleStatement st37 =null;
		CreateMaterializedViewStatement st38 =null;
		DropMaterializedViewStatement st39 =null;
		AlterMaterializedViewStatement st40 =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:5: (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement )
			int alt2=40;
			alt2 = dfa2.predict(input);
			switch (alt2) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:7: st1= selectStatement
					{
					pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
					st1=selectStatement();
					state._fsp--;

					 stmt = st1; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:237:7: st2= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_cqlStatement142);
					st2=insertStatement();
					state._fsp--;

					 stmt = st2; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: st3= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_cqlStatement171);
					st3=updateStatement();
					state._fsp--;

					 stmt = st3; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: st4= batchStatement
					{
					pushFollow(FOLLOW_batchStatement_in_cqlStatement200);
					st4=batchStatement();
					state._fsp--;

					 stmt = st4; 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:7: st5= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_cqlStatement230);
					st5=deleteStatement();
					state._fsp--;

					 stmt = st5; 
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:7: st6= useStatement
					{
					pushFollow(FOLLOW_useStatement_in_cqlStatement259);
					st6=useStatement();
					state._fsp--;

					 stmt = st6; 
					}
					break;
				case 7 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:242:7: st7= truncateStatement
					{
					pushFollow(FOLLOW_truncateStatement_in_cqlStatement291);
					st7=truncateStatement();
					state._fsp--;

					 stmt = st7; 
					}
					break;
				case 8 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:243:7: st8= createKeyspaceStatement
					{
					pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement318);
					st8=createKeyspaceStatement();
					state._fsp--;

					 stmt = st8; 
					}
					break;
				case 9 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:7: st9= createTableStatement
					{
					pushFollow(FOLLOW_createTableStatement_in_cqlStatement339);
					st9=createTableStatement();
					state._fsp--;

					 stmt = st9; 
					}
					break;
				case 10 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:245:7: st10= createIndexStatement
					{
					pushFollow(FOLLOW_createIndexStatement_in_cqlStatement362);
					st10=createIndexStatement();
					state._fsp--;

					 stmt = st10; 
					}
					break;
				case 11 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:246:7: st11= dropKeyspaceStatement
					{
					pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement385);
					st11=dropKeyspaceStatement();
					state._fsp--;

					 stmt = st11; 
					}
					break;
				case 12 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:247:7: st12= dropTableStatement
					{
					pushFollow(FOLLOW_dropTableStatement_in_cqlStatement407);
					st12=dropTableStatement();
					state._fsp--;

					 stmt = st12; 
					}
					break;
				case 13 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:248:7: st13= dropIndexStatement
					{
					pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement432);
					st13=dropIndexStatement();
					state._fsp--;

					 stmt = st13; 
					}
					break;
				case 14 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:249:7: st14= alterTableStatement
					{
					pushFollow(FOLLOW_alterTableStatement_in_cqlStatement457);
					st14=alterTableStatement();
					state._fsp--;

					 stmt = st14; 
					}
					break;
				case 15 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:250:7: st15= alterKeyspaceStatement
					{
					pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement481);
					st15=alterKeyspaceStatement();
					state._fsp--;

					 stmt = st15; 
					}
					break;
				case 16 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:7: st16= grantPermissionsStatement
					{
					pushFollow(FOLLOW_grantPermissionsStatement_in_cqlStatement502);
					st16=grantPermissionsStatement();
					state._fsp--;

					 stmt = st16; 
					}
					break;
				case 17 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:252:7: st17= revokePermissionsStatement
					{
					pushFollow(FOLLOW_revokePermissionsStatement_in_cqlStatement520);
					st17=revokePermissionsStatement();
					state._fsp--;

					 stmt = st17; 
					}
					break;
				case 18 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:253:7: st18= listPermissionsStatement
					{
					pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement537);
					st18=listPermissionsStatement();
					state._fsp--;

					 stmt = st18; 
					}
					break;
				case 19 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:254:7: st19= createUserStatement
					{
					pushFollow(FOLLOW_createUserStatement_in_cqlStatement556);
					st19=createUserStatement();
					state._fsp--;

					 stmt = st19; 
					}
					break;
				case 20 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:255:7: st20= alterUserStatement
					{
					pushFollow(FOLLOW_alterUserStatement_in_cqlStatement580);
					st20=alterUserStatement();
					state._fsp--;

					 stmt = st20; 
					}
					break;
				case 21 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:256:7: st21= dropUserStatement
					{
					pushFollow(FOLLOW_dropUserStatement_in_cqlStatement605);
					st21=dropUserStatement();
					state._fsp--;

					 stmt = st21; 
					}
					break;
				case 22 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:257:7: st22= listUsersStatement
					{
					pushFollow(FOLLOW_listUsersStatement_in_cqlStatement631);
					st22=listUsersStatement();
					state._fsp--;

					 stmt = st22; 
					}
					break;
				case 23 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:258:7: st23= createTriggerStatement
					{
					pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement656);
					st23=createTriggerStatement();
					state._fsp--;

					 stmt = st23; 
					}
					break;
				case 24 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:259:7: st24= dropTriggerStatement
					{
					pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement677);
					st24=dropTriggerStatement();
					state._fsp--;

					 stmt = st24; 
					}
					break;
				case 25 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:260:7: st25= createTypeStatement
					{
					pushFollow(FOLLOW_createTypeStatement_in_cqlStatement700);
					st25=createTypeStatement();
					state._fsp--;

					 stmt = st25; 
					}
					break;
				case 26 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:261:7: st26= alterTypeStatement
					{
					pushFollow(FOLLOW_alterTypeStatement_in_cqlStatement724);
					st26=alterTypeStatement();
					state._fsp--;

					 stmt = st26; 
					}
					break;
				case 27 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:262:7: st27= dropTypeStatement
					{
					pushFollow(FOLLOW_dropTypeStatement_in_cqlStatement749);
					st27=dropTypeStatement();
					state._fsp--;

					 stmt = st27; 
					}
					break;
				case 28 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:263:7: st28= createFunctionStatement
					{
					pushFollow(FOLLOW_createFunctionStatement_in_cqlStatement775);
					st28=createFunctionStatement();
					state._fsp--;

					 stmt = st28; 
					}
					break;
				case 29 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:264:7: st29= dropFunctionStatement
					{
					pushFollow(FOLLOW_dropFunctionStatement_in_cqlStatement795);
					st29=dropFunctionStatement();
					state._fsp--;

					 stmt = st29; 
					}
					break;
				case 30 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:265:7: st30= createAggregateStatement
					{
					pushFollow(FOLLOW_createAggregateStatement_in_cqlStatement817);
					st30=createAggregateStatement();
					state._fsp--;

					 stmt = st30; 
					}
					break;
				case 31 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:266:7: st31= dropAggregateStatement
					{
					pushFollow(FOLLOW_dropAggregateStatement_in_cqlStatement836);
					st31=dropAggregateStatement();
					state._fsp--;

					 stmt = st31; 
					}
					break;
				case 32 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:7: st32= createRoleStatement
					{
					pushFollow(FOLLOW_createRoleStatement_in_cqlStatement857);
					st32=createRoleStatement();
					state._fsp--;

					 stmt = st32; 
					}
					break;
				case 33 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:7: st33= alterRoleStatement
					{
					pushFollow(FOLLOW_alterRoleStatement_in_cqlStatement881);
					st33=alterRoleStatement();
					state._fsp--;

					 stmt = st33; 
					}
					break;
				case 34 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:7: st34= dropRoleStatement
					{
					pushFollow(FOLLOW_dropRoleStatement_in_cqlStatement906);
					st34=dropRoleStatement();
					state._fsp--;

					 stmt = st34; 
					}
					break;
				case 35 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:7: st35= listRolesStatement
					{
					pushFollow(FOLLOW_listRolesStatement_in_cqlStatement932);
					st35=listRolesStatement();
					state._fsp--;

					 stmt = st35; 
					}
					break;
				case 36 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:271:7: st36= grantRoleStatement
					{
					pushFollow(FOLLOW_grantRoleStatement_in_cqlStatement957);
					st36=grantRoleStatement();
					state._fsp--;

					 stmt = st36; 
					}
					break;
				case 37 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:7: st37= revokeRoleStatement
					{
					pushFollow(FOLLOW_revokeRoleStatement_in_cqlStatement982);
					st37=revokeRoleStatement();
					state._fsp--;

					 stmt = st37; 
					}
					break;
				case 38 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:7: st38= createMaterializedViewStatement
					{
					pushFollow(FOLLOW_createMaterializedViewStatement_in_cqlStatement1006);
					st38=createMaterializedViewStatement();
					state._fsp--;

					 stmt = st38; 
					}
					break;
				case 39 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:274:7: st39= dropMaterializedViewStatement
					{
					pushFollow(FOLLOW_dropMaterializedViewStatement_in_cqlStatement1018);
					st39=dropMaterializedViewStatement();
					state._fsp--;

					 stmt = st39; 
					}
					break;
				case 40 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:7: st40= alterMaterializedViewStatement
					{
					pushFollow(FOLLOW_alterMaterializedViewStatement_in_cqlStatement1032);
					st40=alterMaterializedViewStatement();
					state._fsp--;

					 stmt = st40; 
					}
					break;

			}
			 if (stmt != null) stmt.setBoundVariables(bindVariables); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "cqlStatement"



	// $ANTLR start "useStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:281:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
	public final UseStatement useStatement() throws RecognitionException {
		UseStatement stmt = null;


		String ks =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:282:5: ( K_USE ks= keyspaceName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:282:7: K_USE ks= keyspaceName
			{
			match(input,K_USE,FOLLOW_K_USE_in_useStatement1058); 
			pushFollow(FOLLOW_keyspaceName_in_useStatement1062);
			ks=keyspaceName();
			state._fsp--;

			 stmt = new UseStatement(ks); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "useStatement"



	// $ANTLR start "selectStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:291:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT ( K_JSON )? ( ( K_DISTINCT )? sclause= selectClause ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
	public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
		SelectStatement.RawStatement expr = null;


		List<RawSelector> sclause =null;
		CFName cf =null;
		List<Relation> wclause =null;
		Term.Raw rows =null;


		        boolean isDistinct = false;
		        Term.Raw limit = null;
		        Map<ColumnIdentifier.Raw, Boolean> orderings = new LinkedHashMap<ColumnIdentifier.Raw, Boolean>();
		        boolean allowFiltering = false;
		        boolean isJson = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:5: ( K_SELECT ( K_JSON )? ( ( K_DISTINCT )? sclause= selectClause ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:7: K_SELECT ( K_JSON )? ( ( K_DISTINCT )? sclause= selectClause ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
			{
			match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement1096); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:7: ( K_JSON )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==K_JSON) ) {
				int LA3_1 = input.LA(2);
				if ( (LA3_1==IDENT||(LA3_1 >= K_AGGREGATE && LA3_1 <= K_ALL)||LA3_1==K_ASCII||(LA3_1 >= K_BIGINT && LA3_1 <= K_BOOLEAN)||(LA3_1 >= K_CALLED && LA3_1 <= K_CLUSTERING)||(LA3_1 >= K_COMPACT && LA3_1 <= K_COUNTER)||(LA3_1 >= K_CUSTOM && LA3_1 <= K_DECIMAL)||(LA3_1 >= K_DISTINCT && LA3_1 <= K_DOUBLE)||(LA3_1 >= K_EXISTS && LA3_1 <= K_FLOAT)||LA3_1==K_FROZEN||(LA3_1 >= K_FUNCTION && LA3_1 <= K_FUNCTIONS)||LA3_1==K_INET||(LA3_1 >= K_INITCOND && LA3_1 <= K_INPUT)||LA3_1==K_INT||(LA3_1 >= K_JSON && LA3_1 <= K_KEYS)||(LA3_1 >= K_KEYSPACES && LA3_1 <= K_LANGUAGE)||(LA3_1 >= K_LIST && LA3_1 <= K_MAP)||LA3_1==K_NOLOGIN||LA3_1==K_NOSUPERUSER||LA3_1==K_OPTIONS||(LA3_1 >= K_PASSWORD && LA3_1 <= K_PERMISSIONS)||LA3_1==K_RETURNS||(LA3_1 >= K_ROLE && LA3_1 <= K_ROLES)||(LA3_1 >= K_SFUNC && LA3_1 <= K_TINYINT)||(LA3_1 >= K_TOKEN && LA3_1 <= K_TRIGGER)||(LA3_1 >= K_TTL && LA3_1 <= K_TYPE)||(LA3_1 >= K_USER && LA3_1 <= K_USERS)||(LA3_1 >= K_UUID && LA3_1 <= K_VARINT)||LA3_1==K_WRITETIME||(LA3_1 >= QMARK && LA3_1 <= QUOTED_NAME)||LA3_1==185) ) {
					alt3=1;
				}
				else if ( (LA3_1==K_AS) ) {
					int LA3_4 = input.LA(3);
					if ( (LA3_4==K_FROM||LA3_4==171||LA3_4==174||LA3_4==176) ) {
						alt3=1;
					}
					else if ( (LA3_4==K_AS) ) {
						int LA3_5 = input.LA(4);
						if ( (LA3_5==IDENT||(LA3_5 >= K_AGGREGATE && LA3_5 <= K_ALL)||LA3_5==K_AS||LA3_5==K_ASCII||(LA3_5 >= K_BIGINT && LA3_5 <= K_BOOLEAN)||(LA3_5 >= K_CALLED && LA3_5 <= K_CLUSTERING)||(LA3_5 >= K_COMPACT && LA3_5 <= K_COUNTER)||(LA3_5 >= K_CUSTOM && LA3_5 <= K_DECIMAL)||(LA3_5 >= K_DISTINCT && LA3_5 <= K_DOUBLE)||(LA3_5 >= K_EXISTS && LA3_5 <= K_FLOAT)||LA3_5==K_FROZEN||(LA3_5 >= K_FUNCTION && LA3_5 <= K_FUNCTIONS)||LA3_5==K_INET||(LA3_5 >= K_INITCOND && LA3_5 <= K_INPUT)||LA3_5==K_INT||(LA3_5 >= K_JSON && LA3_5 <= K_KEYS)||(LA3_5 >= K_KEYSPACES && LA3_5 <= K_LANGUAGE)||(LA3_5 >= K_LIST && LA3_5 <= K_MAP)||LA3_5==K_NOLOGIN||LA3_5==K_NOSUPERUSER||LA3_5==K_OPTIONS||(LA3_5 >= K_PASSWORD && LA3_5 <= K_PERMISSIONS)||LA3_5==K_RETURNS||(LA3_5 >= K_ROLE && LA3_5 <= K_ROLES)||(LA3_5 >= K_SFUNC && LA3_5 <= K_TINYINT)||LA3_5==K_TRIGGER||(LA3_5 >= K_TTL && LA3_5 <= K_TYPE)||(LA3_5 >= K_USER && LA3_5 <= K_USERS)||(LA3_5 >= K_UUID && LA3_5 <= K_VARINT)||LA3_5==K_WRITETIME||LA3_5==QUOTED_NAME) ) {
							alt3=1;
						}
					}
				}
			}
			switch (alt3) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:9: K_JSON
					{
					match(input,K_JSON,FOLLOW_K_JSON_in_selectStatement1107); 
					 isJson = true; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:7: ( ( K_DISTINCT )? sclause= selectClause )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:9: ( K_DISTINCT )? sclause= selectClause
			{
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:9: ( K_DISTINCT )?
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==K_DISTINCT) ) {
				int LA4_1 = input.LA(2);
				if ( (LA4_1==IDENT||(LA4_1 >= K_AGGREGATE && LA4_1 <= K_ALL)||LA4_1==K_ASCII||(LA4_1 >= K_BIGINT && LA4_1 <= K_BOOLEAN)||(LA4_1 >= K_CALLED && LA4_1 <= K_CLUSTERING)||(LA4_1 >= K_COMPACT && LA4_1 <= K_COUNTER)||(LA4_1 >= K_CUSTOM && LA4_1 <= K_DECIMAL)||(LA4_1 >= K_DISTINCT && LA4_1 <= K_DOUBLE)||(LA4_1 >= K_EXISTS && LA4_1 <= K_FLOAT)||LA4_1==K_FROZEN||(LA4_1 >= K_FUNCTION && LA4_1 <= K_FUNCTIONS)||LA4_1==K_INET||(LA4_1 >= K_INITCOND && LA4_1 <= K_INPUT)||LA4_1==K_INT||(LA4_1 >= K_JSON && LA4_1 <= K_KEYS)||(LA4_1 >= K_KEYSPACES && LA4_1 <= K_LANGUAGE)||(LA4_1 >= K_LIST && LA4_1 <= K_MAP)||LA4_1==K_NOLOGIN||LA4_1==K_NOSUPERUSER||LA4_1==K_OPTIONS||(LA4_1 >= K_PASSWORD && LA4_1 <= K_PERMISSIONS)||LA4_1==K_RETURNS||(LA4_1 >= K_ROLE && LA4_1 <= K_ROLES)||(LA4_1 >= K_SFUNC && LA4_1 <= K_TINYINT)||(LA4_1 >= K_TOKEN && LA4_1 <= K_TRIGGER)||(LA4_1 >= K_TTL && LA4_1 <= K_TYPE)||(LA4_1 >= K_USER && LA4_1 <= K_USERS)||(LA4_1 >= K_UUID && LA4_1 <= K_VARINT)||LA4_1==K_WRITETIME||(LA4_1 >= QMARK && LA4_1 <= QUOTED_NAME)||LA4_1==185) ) {
					alt4=1;
				}
				else if ( (LA4_1==K_AS) ) {
					int LA4_4 = input.LA(3);
					if ( (LA4_4==K_FROM||LA4_4==171||LA4_4==174||LA4_4==176) ) {
						alt4=1;
					}
					else if ( (LA4_4==K_AS) ) {
						int LA4_5 = input.LA(4);
						if ( (LA4_5==IDENT||(LA4_5 >= K_AGGREGATE && LA4_5 <= K_ALL)||LA4_5==K_AS||LA4_5==K_ASCII||(LA4_5 >= K_BIGINT && LA4_5 <= K_BOOLEAN)||(LA4_5 >= K_CALLED && LA4_5 <= K_CLUSTERING)||(LA4_5 >= K_COMPACT && LA4_5 <= K_COUNTER)||(LA4_5 >= K_CUSTOM && LA4_5 <= K_DECIMAL)||(LA4_5 >= K_DISTINCT && LA4_5 <= K_DOUBLE)||(LA4_5 >= K_EXISTS && LA4_5 <= K_FLOAT)||LA4_5==K_FROZEN||(LA4_5 >= K_FUNCTION && LA4_5 <= K_FUNCTIONS)||LA4_5==K_INET||(LA4_5 >= K_INITCOND && LA4_5 <= K_INPUT)||LA4_5==K_INT||(LA4_5 >= K_JSON && LA4_5 <= K_KEYS)||(LA4_5 >= K_KEYSPACES && LA4_5 <= K_LANGUAGE)||(LA4_5 >= K_LIST && LA4_5 <= K_MAP)||LA4_5==K_NOLOGIN||LA4_5==K_NOSUPERUSER||LA4_5==K_OPTIONS||(LA4_5 >= K_PASSWORD && LA4_5 <= K_PERMISSIONS)||LA4_5==K_RETURNS||(LA4_5 >= K_ROLE && LA4_5 <= K_ROLES)||(LA4_5 >= K_SFUNC && LA4_5 <= K_TINYINT)||LA4_5==K_TRIGGER||(LA4_5 >= K_TTL && LA4_5 <= K_TYPE)||(LA4_5 >= K_USER && LA4_5 <= K_USERS)||(LA4_5 >= K_UUID && LA4_5 <= K_VARINT)||LA4_5==K_WRITETIME||LA4_5==QUOTED_NAME) ) {
							alt4=1;
						}
					}
				}
			}
			switch (alt4) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:11: K_DISTINCT
					{
					match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_selectStatement1124); 
					 isDistinct = true; 
					}
					break;

			}

			pushFollow(FOLLOW_selectClause_in_selectStatement1133);
			sclause=selectClause();
			state._fsp--;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement1143); 
			pushFollow(FOLLOW_columnFamilyName_in_selectStatement1147);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:303:7: ( K_WHERE wclause= whereClause )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==K_WHERE) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:303:9: K_WHERE wclause= whereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement1157); 
					pushFollow(FOLLOW_whereClause_in_selectStatement1161);
					wclause=whereClause();
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
			int alt7=2;
			int LA7_0 = input.LA(1);
			if ( (LA7_0==K_ORDER) ) {
				alt7=1;
			}
			switch (alt7) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
					{
					match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement1174); 
					match(input,K_BY,FOLLOW_K_BY_in_selectStatement1176); 
					pushFollow(FOLLOW_orderByClause_in_selectStatement1178);
					orderByClause(orderings);
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:47: ( ',' orderByClause[orderings] )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( (LA6_0==174) ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:49: ',' orderByClause[orderings]
							{
							match(input,174,FOLLOW_174_in_selectStatement1183); 
							pushFollow(FOLLOW_orderByClause_in_selectStatement1185);
							orderByClause(orderings);
							state._fsp--;

							}
							break;

						default :
							break loop6;
						}
					}

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:7: ( K_LIMIT rows= intValue )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==K_LIMIT) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:9: K_LIMIT rows= intValue
					{
					match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement1202); 
					pushFollow(FOLLOW_intValue_in_selectStatement1206);
					rows=intValue();
					state._fsp--;

					 limit = rows; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:7: ( K_ALLOW K_FILTERING )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==K_ALLOW) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:9: K_ALLOW K_FILTERING
					{
					match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement1221); 
					match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement1223); 
					 allowFiltering = true; 
					}
					break;

			}


			          SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
			                                                                             isDistinct,
			                                                                             allowFiltering,
			                                                                             isJson);
			          expr = new SelectStatement.RawStatement(cf, params, sclause, wclause, limit);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectStatement"



	// $ANTLR start "selectClause"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:316:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
	public final List<RawSelector> selectClause() throws RecognitionException {
		List<RawSelector> expr = null;


		RawSelector t1 =null;
		RawSelector tN =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:5: (t1= selector ( ',' tN= selector )* | '\\*' )
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==IDENT||(LA11_0 >= K_AGGREGATE && LA11_0 <= K_ALL)||LA11_0==K_AS||LA11_0==K_ASCII||(LA11_0 >= K_BIGINT && LA11_0 <= K_BOOLEAN)||(LA11_0 >= K_CALLED && LA11_0 <= K_CLUSTERING)||(LA11_0 >= K_COMPACT && LA11_0 <= K_COUNTER)||(LA11_0 >= K_CUSTOM && LA11_0 <= K_DECIMAL)||(LA11_0 >= K_DISTINCT && LA11_0 <= K_DOUBLE)||(LA11_0 >= K_EXISTS && LA11_0 <= K_FLOAT)||LA11_0==K_FROZEN||(LA11_0 >= K_FUNCTION && LA11_0 <= K_FUNCTIONS)||LA11_0==K_INET||(LA11_0 >= K_INITCOND && LA11_0 <= K_INPUT)||LA11_0==K_INT||(LA11_0 >= K_JSON && LA11_0 <= K_KEYS)||(LA11_0 >= K_KEYSPACES && LA11_0 <= K_LANGUAGE)||(LA11_0 >= K_LIST && LA11_0 <= K_MAP)||LA11_0==K_NOLOGIN||LA11_0==K_NOSUPERUSER||LA11_0==K_OPTIONS||(LA11_0 >= K_PASSWORD && LA11_0 <= K_PERMISSIONS)||LA11_0==K_RETURNS||(LA11_0 >= K_ROLE && LA11_0 <= K_ROLES)||(LA11_0 >= K_SFUNC && LA11_0 <= K_TINYINT)||(LA11_0 >= K_TOKEN && LA11_0 <= K_TRIGGER)||(LA11_0 >= K_TTL && LA11_0 <= K_TYPE)||(LA11_0 >= K_USER && LA11_0 <= K_USERS)||(LA11_0 >= K_UUID && LA11_0 <= K_VARINT)||LA11_0==K_WRITETIME||(LA11_0 >= QMARK && LA11_0 <= QUOTED_NAME)) ) {
				alt11=1;
			}
			else if ( (LA11_0==185) ) {
				alt11=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}

			switch (alt11) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:7: t1= selector ( ',' tN= selector )*
					{
					pushFollow(FOLLOW_selector_in_selectClause1260);
					t1=selector();
					state._fsp--;

					 expr = new ArrayList<RawSelector>(); expr.add(t1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:76: ( ',' tN= selector )*
					loop10:
					while (true) {
						int alt10=2;
						int LA10_0 = input.LA(1);
						if ( (LA10_0==174) ) {
							alt10=1;
						}

						switch (alt10) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:77: ',' tN= selector
							{
							match(input,174,FOLLOW_174_in_selectClause1265); 
							pushFollow(FOLLOW_selector_in_selectClause1269);
							tN=selector();
							state._fsp--;

							 expr.add(tN); 
							}
							break;

						default :
							break loop10;
						}
					}

					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:318:7: '\\*'
					{
					match(input,185,FOLLOW_185_in_selectClause1281); 
					 expr = Collections.<RawSelector>emptyList();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selector"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:321:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= noncol_ident )? ;
	public final RawSelector selector() throws RecognitionException {
		RawSelector s = null;


		Selectable.Raw us =null;
		ColumnIdentifier c =null;

		 ColumnIdentifier alias = null; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:323:5: (us= unaliasedSelector ( K_AS c= noncol_ident )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:323:7: us= unaliasedSelector ( K_AS c= noncol_ident )?
			{
			pushFollow(FOLLOW_unaliasedSelector_in_selector1314);
			us=unaliasedSelector();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:323:28: ( K_AS c= noncol_ident )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==K_AS) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:323:29: K_AS c= noncol_ident
					{
					match(input,K_AS,FOLLOW_K_AS_in_selector1317); 
					pushFollow(FOLLOW_noncol_ident_in_selector1321);
					c=noncol_ident();
					state._fsp--;

					 alias = c; 
					}
					break;

			}

			 s = new RawSelector(us, alias); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selector"



	// $ANTLR start "unaliasedSelector"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:326:1: unaliasedSelector returns [Selectable.Raw s] : (c= cident | K_COUNT '(' countArgument ')' | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* ;
	public final Selectable.Raw unaliasedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		ColumnIdentifier.Raw c =null;
		FunctionName f =null;
		List<Selectable.Raw> args =null;
		ColumnIdentifier.Raw fi =null;

		 Selectable.Raw tmp = null; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:328:5: ( (c= cident | K_COUNT '(' countArgument ')' | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:328:8: (c= cident | K_COUNT '(' countArgument ')' | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )*
			{
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:328:8: (c= cident | K_COUNT '(' countArgument ')' | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs )
			int alt13=5;
			alt13 = dfa13.predict(input);
			switch (alt13) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:328:10: c= cident
					{
					pushFollow(FOLLOW_cident_in_unaliasedSelector1362);
					c=cident();
					state._fsp--;

					 tmp = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:329:10: K_COUNT '(' countArgument ')'
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_unaliasedSelector1408); 
					match(input,171,FOLLOW_171_in_unaliasedSelector1410); 
					pushFollow(FOLLOW_countArgument_in_unaliasedSelector1412);
					countArgument();
					state._fsp--;

					match(input,172,FOLLOW_172_in_unaliasedSelector1414); 
					 tmp = new Selectable.WithFunction.Raw(FunctionName.nativeFunction("countRows"), Collections.<Selectable.Raw>emptyList());
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:10: K_WRITETIME '(' c= cident ')'
					{
					match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_unaliasedSelector1439); 
					match(input,171,FOLLOW_171_in_unaliasedSelector1441); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1445);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_unaliasedSelector1447); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, true); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:331:10: K_TTL '(' c= cident ')'
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_unaliasedSelector1473); 
					match(input,171,FOLLOW_171_in_unaliasedSelector1481); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1485);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_unaliasedSelector1487); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, false); 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:10: f= functionName args= selectionFunctionArgs
					{
					pushFollow(FOLLOW_functionName_in_unaliasedSelector1515);
					f=functionName();
					state._fsp--;

					pushFollow(FOLLOW_selectionFunctionArgs_in_unaliasedSelector1519);
					args=selectionFunctionArgs();
					state._fsp--;

					 tmp = new Selectable.WithFunction.Raw(f, args); 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:10: ( '.' fi= cident )*
			loop14:
			while (true) {
				int alt14=2;
				int LA14_0 = input.LA(1);
				if ( (LA14_0==176) ) {
					alt14=1;
				}

				switch (alt14) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:12: '.' fi= cident
					{
					match(input,176,FOLLOW_176_in_unaliasedSelector1534); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1538);
					fi=cident();
					state._fsp--;

					 tmp = new Selectable.WithFieldSelection.Raw(tmp, fi); 
					}
					break;

				default :
					break loop14;
				}
			}

			 s = tmp; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "unaliasedSelector"



	// $ANTLR start "selectionFunctionArgs"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:1: selectionFunctionArgs returns [List<Selectable.Raw> a] : ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' );
	public final List<Selectable.Raw> selectionFunctionArgs() throws RecognitionException {
		List<Selectable.Raw> a = null;


		Selectable.Raw s1 =null;
		Selectable.Raw sn =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:5: ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' )
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==171) ) {
				int LA16_1 = input.LA(2);
				if ( (LA16_1==172) ) {
					alt16=1;
				}
				else if ( (LA16_1==IDENT||(LA16_1 >= K_AGGREGATE && LA16_1 <= K_ALL)||LA16_1==K_AS||LA16_1==K_ASCII||(LA16_1 >= K_BIGINT && LA16_1 <= K_BOOLEAN)||(LA16_1 >= K_CALLED && LA16_1 <= K_CLUSTERING)||(LA16_1 >= K_COMPACT && LA16_1 <= K_COUNTER)||(LA16_1 >= K_CUSTOM && LA16_1 <= K_DECIMAL)||(LA16_1 >= K_DISTINCT && LA16_1 <= K_DOUBLE)||(LA16_1 >= K_EXISTS && LA16_1 <= K_FLOAT)||LA16_1==K_FROZEN||(LA16_1 >= K_FUNCTION && LA16_1 <= K_FUNCTIONS)||LA16_1==K_INET||(LA16_1 >= K_INITCOND && LA16_1 <= K_INPUT)||LA16_1==K_INT||(LA16_1 >= K_JSON && LA16_1 <= K_KEYS)||(LA16_1 >= K_KEYSPACES && LA16_1 <= K_LANGUAGE)||(LA16_1 >= K_LIST && LA16_1 <= K_MAP)||LA16_1==K_NOLOGIN||LA16_1==K_NOSUPERUSER||LA16_1==K_OPTIONS||(LA16_1 >= K_PASSWORD && LA16_1 <= K_PERMISSIONS)||LA16_1==K_RETURNS||(LA16_1 >= K_ROLE && LA16_1 <= K_ROLES)||(LA16_1 >= K_SFUNC && LA16_1 <= K_TINYINT)||(LA16_1 >= K_TOKEN && LA16_1 <= K_TRIGGER)||(LA16_1 >= K_TTL && LA16_1 <= K_TYPE)||(LA16_1 >= K_USER && LA16_1 <= K_USERS)||(LA16_1 >= K_UUID && LA16_1 <= K_VARINT)||LA16_1==K_WRITETIME||(LA16_1 >= QMARK && LA16_1 <= QUOTED_NAME)) ) {
					alt16=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 16, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 16, 0, input);
				throw nvae;
			}

			switch (alt16) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:7: '(' ')'
					{
					match(input,171,FOLLOW_171_in_selectionFunctionArgs1566); 
					match(input,172,FOLLOW_172_in_selectionFunctionArgs1568); 
					 a = Collections.emptyList(); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:7: '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')'
					{
					match(input,171,FOLLOW_171_in_selectionFunctionArgs1578); 
					pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1582);
					s1=unaliasedSelector();
					state._fsp--;

					 List<Selectable.Raw> args = new ArrayList<Selectable.Raw>(); args.add(s1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:339:11: ( ',' sn= unaliasedSelector )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( (LA15_0==174) ) {
							alt15=1;
						}

						switch (alt15) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:339:13: ',' sn= unaliasedSelector
							{
							match(input,174,FOLLOW_174_in_selectionFunctionArgs1598); 
							pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1602);
							sn=unaliasedSelector();
							state._fsp--;

							 args.add(sn); 
							}
							break;

						default :
							break loop15;
						}
					}

					match(input,172,FOLLOW_172_in_selectionFunctionArgs1615); 
					 a = args; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return a;
	}
	// $ANTLR end "selectionFunctionArgs"



	// $ANTLR start "countArgument"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:1: countArgument : ( '\\*' |i= INTEGER );
	public final void countArgument() throws RecognitionException {
		Token i=null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:344:5: ( '\\*' |i= INTEGER )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==185) ) {
				alt17=1;
			}
			else if ( (LA17_0==INTEGER) ) {
				alt17=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:344:7: '\\*'
					{
					match(input,185,FOLLOW_185_in_countArgument1634); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:345:7: i= INTEGER
					{
					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_countArgument1644); 
					 if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "countArgument"



	// $ANTLR start "whereClause"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:348:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
	public final List<Relation> whereClause() throws RecognitionException {
		List<Relation> clause = null;


		 clause = new ArrayList<Relation>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:5: ( relation[$clause] ( K_AND relation[$clause] )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:7: relation[$clause] ( K_AND relation[$clause] )*
			{
			pushFollow(FOLLOW_relation_in_whereClause1675);
			relation(clause);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:25: ( K_AND relation[$clause] )*
			loop18:
			while (true) {
				int alt18=2;
				int LA18_0 = input.LA(1);
				if ( (LA18_0==K_AND) ) {
					alt18=1;
				}

				switch (alt18) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:26: K_AND relation[$clause]
					{
					match(input,K_AND,FOLLOW_K_AND_in_whereClause1679); 
					pushFollow(FOLLOW_relation_in_whereClause1681);
					relation(clause);
					state._fsp--;

					}
					break;

				default :
					break loop18;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return clause;
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "orderByClause"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:353:1: orderByClause[Map<ColumnIdentifier.Raw, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
	public final void orderByClause(Map<ColumnIdentifier.Raw, Boolean> orderings) throws RecognitionException {
		ColumnIdentifier.Raw c =null;


		        boolean reversed = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:357:5: (c= cident ( K_ASC | K_DESC )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:357:7: c= cident ( K_ASC | K_DESC )?
			{
			pushFollow(FOLLOW_cident_in_orderByClause1712);
			c=cident();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:357:16: ( K_ASC | K_DESC )?
			int alt19=3;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==K_ASC) ) {
				alt19=1;
			}
			else if ( (LA19_0==K_DESC) ) {
				alt19=2;
			}
			switch (alt19) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:357:17: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1715); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:357:25: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1719); 
					 reversed = true; 
					}
					break;

			}

			 orderings.put(c, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderByClause"



	// $ANTLR start "insertStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:366:1: insertStatement returns [ModificationStatement.Parsed expr] : K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] ) ;
	public final ModificationStatement.Parsed insertStatement() throws RecognitionException {
		ModificationStatement.Parsed expr = null;


		CFName cf =null;
		UpdateStatement.ParsedInsert st1 =null;
		UpdateStatement.ParsedInsertJson st2 =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:367:5: ( K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:367:7: K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] )
			{
			match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1748); 
			match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1750); 
			pushFollow(FOLLOW_columnFamilyName_in_insertStatement1754);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:9: (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] )
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==171) ) {
				alt20=1;
			}
			else if ( (LA20_0==K_JSON) ) {
				alt20=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}

			switch (alt20) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:11: st1= normalInsertStatement[cf]
					{
					pushFollow(FOLLOW_normalInsertStatement_in_insertStatement1768);
					st1=normalInsertStatement(cf);
					state._fsp--;

					 expr = st1; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:369:11: K_JSON st2= jsonInsertStatement[cf]
					{
					match(input,K_JSON,FOLLOW_K_JSON_in_insertStatement1783); 
					pushFollow(FOLLOW_jsonInsertStatement_in_insertStatement1787);
					st2=jsonInsertStatement(cf);
					state._fsp--;

					 expr = st2; 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "insertStatement"



	// $ANTLR start "normalInsertStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:372:1: normalInsertStatement[CFName cf] returns [UpdateStatement.ParsedInsert expr] : '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsert normalInsertStatement(CFName cf) throws RecognitionException {
		UpdateStatement.ParsedInsert expr = null;


		ColumnIdentifier.Raw c1 =null;
		ColumnIdentifier.Raw cn =null;
		Term.Raw v1 =null;
		Term.Raw vn =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<ColumnIdentifier.Raw> columnNames  = new ArrayList<ColumnIdentifier.Raw>();
		        List<Term.Raw> values = new ArrayList<Term.Raw>();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:379:5: ( '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:379:7: '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			match(input,171,FOLLOW_171_in_normalInsertStatement1823); 
			pushFollow(FOLLOW_cident_in_normalInsertStatement1827);
			c1=cident();
			state._fsp--;

			 columnNames.add(c1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:379:47: ( ',' cn= cident )*
			loop21:
			while (true) {
				int alt21=2;
				int LA21_0 = input.LA(1);
				if ( (LA21_0==174) ) {
					alt21=1;
				}

				switch (alt21) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:379:49: ',' cn= cident
					{
					match(input,174,FOLLOW_174_in_normalInsertStatement1834); 
					pushFollow(FOLLOW_cident_in_normalInsertStatement1838);
					cn=cident();
					state._fsp--;

					 columnNames.add(cn); 
					}
					break;

				default :
					break loop21;
				}
			}

			match(input,172,FOLLOW_172_in_normalInsertStatement1845); 
			match(input,K_VALUES,FOLLOW_K_VALUES_in_normalInsertStatement1853); 
			match(input,171,FOLLOW_171_in_normalInsertStatement1861); 
			pushFollow(FOLLOW_term_in_normalInsertStatement1865);
			v1=term();
			state._fsp--;

			 values.add(v1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:39: ( ',' vn= term )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==174) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:41: ',' vn= term
					{
					match(input,174,FOLLOW_174_in_normalInsertStatement1871); 
					pushFollow(FOLLOW_term_in_normalInsertStatement1875);
					vn=term();
					state._fsp--;

					 values.add(vn); 
					}
					break;

				default :
					break loop22;
				}
			}

			match(input,172,FOLLOW_172_in_normalInsertStatement1882); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:7: ( K_IF K_NOT K_EXISTS )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==K_IF) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:9: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_normalInsertStatement1892); 
					match(input,K_NOT,FOLLOW_K_NOT_in_normalInsertStatement1894); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_normalInsertStatement1896); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:7: ( usingClause[attrs] )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==K_USING) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_normalInsertStatement1911);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}


			          expr = new UpdateStatement.ParsedInsert(cf, attrs, columnNames, values, ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "normalInsertStatement"



	// $ANTLR start "jsonInsertStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:389:1: jsonInsertStatement[CFName cf] returns [UpdateStatement.ParsedInsertJson expr] : val= jsonValue ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsertJson jsonInsertStatement(CFName cf) throws RecognitionException {
		UpdateStatement.ParsedInsertJson expr = null;


		Json.Raw val =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:394:5: (val= jsonValue ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:394:7: val= jsonValue ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			pushFollow(FOLLOW_jsonValue_in_jsonInsertStatement1957);
			val=jsonValue();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:395:7: ( K_IF K_NOT K_EXISTS )?
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==K_IF) ) {
				alt25=1;
			}
			switch (alt25) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:395:9: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_jsonInsertStatement1967); 
					match(input,K_NOT,FOLLOW_K_NOT_in_jsonInsertStatement1969); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_jsonInsertStatement1971); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:396:7: ( usingClause[attrs] )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==K_USING) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:396:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_jsonInsertStatement1986);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}


			          expr = new UpdateStatement.ParsedInsertJson(cf, attrs, val, ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "jsonInsertStatement"



	// $ANTLR start "jsonValue"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:402:1: jsonValue returns [Json.Raw value] : (|s= STRING_LITERAL | ':' id= noncol_ident | QMARK );
	public final Json.Raw jsonValue() throws RecognitionException {
		Json.Raw value = null;


		Token s=null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:403:5: (|s= STRING_LITERAL | ':' id= noncol_ident | QMARK )
			int alt27=4;
			switch ( input.LA(1) ) {
			case EOF:
			case K_APPLY:
			case K_DELETE:
			case K_IF:
			case K_INSERT:
			case K_UPDATE:
			case K_USING:
			case 178:
				{
				alt27=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt27=2;
				}
				break;
			case 177:
				{
				alt27=3;
				}
				break;
			case QMARK:
				{
				alt27=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 27, 0, input);
				throw nvae;
			}
			switch (alt27) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:404:5: 
					{
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:404:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_jsonValue2027); 
					 value = new Json.Literal((s!=null?s.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:405:7: ':' id= noncol_ident
					{
					match(input,177,FOLLOW_177_in_jsonValue2037); 
					pushFollow(FOLLOW_noncol_ident_in_jsonValue2041);
					id=noncol_ident();
					state._fsp--;

					 value = newJsonBindVariables(id); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:406:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_jsonValue2055); 
					 value = newJsonBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "jsonValue"



	// $ANTLR start "usingClause"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:409:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* ;
	public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:410:5: ( K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:410:7: K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )*
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClause2086); 
			pushFollow(FOLLOW_usingClauseObjective_in_usingClause2088);
			usingClauseObjective(attrs);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:410:43: ( K_AND usingClauseObjective[attrs] )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==K_AND) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:410:45: K_AND usingClauseObjective[attrs]
					{
					match(input,K_AND,FOLLOW_K_AND_in_usingClause2093); 
					pushFollow(FOLLOW_usingClauseObjective_in_usingClause2095);
					usingClauseObjective(attrs);
					state._fsp--;

					}
					break;

				default :
					break loop28;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "usingClauseObjective"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:413:1: usingClauseObjective[Attributes.Raw attrs] : ( K_TIMESTAMP ts= intValue | K_TTL t= intValue );
	public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:414:5: ( K_TIMESTAMP ts= intValue | K_TTL t= intValue )
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==K_TIMESTAMP) ) {
				alt29=1;
			}
			else if ( (LA29_0==K_TTL) ) {
				alt29=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}

			switch (alt29) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:414:7: K_TIMESTAMP ts= intValue
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseObjective2117); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective2121);
					ts=intValue();
					state._fsp--;

					 attrs.timestamp = ts; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:7: K_TTL t= intValue
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective2131); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective2135);
					t=intValue();
					state._fsp--;

					 attrs.timeToLive = t; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseObjective"



	// $ANTLR start "updateStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:425:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
		UpdateStatement.ParsedUpdate expr = null;


		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>>();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement2169); 
			pushFollow(FOLLOW_columnFamilyName_in_updateStatement2173);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:432:7: ( usingClause[attrs] )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==K_USING) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:432:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_updateStatement2183);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_SET,FOLLOW_K_SET_in_updateStatement2195); 
			pushFollow(FOLLOW_columnOperation_in_updateStatement2197);
			columnOperation(operations);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:41: ( ',' columnOperation[operations] )*
			loop31:
			while (true) {
				int alt31=2;
				int LA31_0 = input.LA(1);
				if ( (LA31_0==174) ) {
					alt31=1;
				}

				switch (alt31) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:42: ',' columnOperation[operations]
					{
					match(input,174,FOLLOW_174_in_updateStatement2201); 
					pushFollow(FOLLOW_columnOperation_in_updateStatement2203);
					columnOperation(operations);
					state._fsp--;

					}
					break;

				default :
					break loop31;
				}
			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement2214); 
			pushFollow(FOLLOW_whereClause_in_updateStatement2218);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==K_IF) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_updateStatement2228); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:14: ( K_EXISTS |conditions= updateConditions )
					int alt32=2;
					int LA32_0 = input.LA(1);
					if ( (LA32_0==K_EXISTS) ) {
						int LA32_1 = input.LA(2);
						if ( (LA32_1==EOF||LA32_1==K_APPLY||LA32_1==K_DELETE||LA32_1==K_INSERT||LA32_1==K_UPDATE||LA32_1==178) ) {
							alt32=1;
						}
						else if ( (LA32_1==K_IN||LA32_1==170||(LA32_1 >= 179 && LA32_1 <= 184)) ) {
							alt32=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 32, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA32_0==IDENT||(LA32_0 >= K_AGGREGATE && LA32_0 <= K_ALL)||LA32_0==K_AS||LA32_0==K_ASCII||(LA32_0 >= K_BIGINT && LA32_0 <= K_BOOLEAN)||(LA32_0 >= K_CALLED && LA32_0 <= K_CLUSTERING)||(LA32_0 >= K_COMPACT && LA32_0 <= K_COUNTER)||(LA32_0 >= K_CUSTOM && LA32_0 <= K_DECIMAL)||(LA32_0 >= K_DISTINCT && LA32_0 <= K_DOUBLE)||(LA32_0 >= K_FILTERING && LA32_0 <= K_FLOAT)||LA32_0==K_FROZEN||(LA32_0 >= K_FUNCTION && LA32_0 <= K_FUNCTIONS)||LA32_0==K_INET||(LA32_0 >= K_INITCOND && LA32_0 <= K_INPUT)||LA32_0==K_INT||(LA32_0 >= K_JSON && LA32_0 <= K_KEYS)||(LA32_0 >= K_KEYSPACES && LA32_0 <= K_LANGUAGE)||(LA32_0 >= K_LIST && LA32_0 <= K_MAP)||LA32_0==K_NOLOGIN||LA32_0==K_NOSUPERUSER||LA32_0==K_OPTIONS||(LA32_0 >= K_PASSWORD && LA32_0 <= K_PERMISSIONS)||LA32_0==K_RETURNS||(LA32_0 >= K_ROLE && LA32_0 <= K_ROLES)||(LA32_0 >= K_SFUNC && LA32_0 <= K_TINYINT)||LA32_0==K_TRIGGER||(LA32_0 >= K_TTL && LA32_0 <= K_TYPE)||(LA32_0 >= K_USER && LA32_0 <= K_USERS)||(LA32_0 >= K_UUID && LA32_0 <= K_VARINT)||LA32_0==K_WRITETIME||LA32_0==QUOTED_NAME) ) {
						alt32=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 32, 0, input);
						throw nvae;
					}

					switch (alt32) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_updateStatement2232); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:435:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_updateStatement2240);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new UpdateStatement.ParsedUpdate(cf,
			                                                  attrs,
			                                                  operations,
			                                                  wclause,
			                                                  conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                                  ifExists);
			     
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "updateStatement"



	// $ANTLR start "updateConditions"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:446:1: updateConditions returns [List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : columnCondition[conditions] ( K_AND columnCondition[conditions] )* ;
	public final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> updateConditions() throws RecognitionException {
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions = null;


		 conditions = new ArrayList<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:448:5: ( columnCondition[conditions] ( K_AND columnCondition[conditions] )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:448:7: columnCondition[conditions] ( K_AND columnCondition[conditions] )*
			{
			pushFollow(FOLLOW_columnCondition_in_updateConditions2282);
			columnCondition(conditions);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:448:35: ( K_AND columnCondition[conditions] )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==K_AND) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:448:37: K_AND columnCondition[conditions]
					{
					match(input,K_AND,FOLLOW_K_AND_in_updateConditions2287); 
					pushFollow(FOLLOW_columnCondition_in_updateConditions2289);
					columnCondition(conditions);
					state._fsp--;

					}
					break;

				default :
					break loop34;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return conditions;
	}
	// $ANTLR end "updateConditions"



	// $ANTLR start "deleteStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:459:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
		DeleteStatement.Parsed expr = null;


		List<Operation.RawDeletion> dels =null;
		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement2326); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:16: (dels= deleteSelection )?
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==IDENT||(LA35_0 >= K_AGGREGATE && LA35_0 <= K_ALL)||LA35_0==K_AS||LA35_0==K_ASCII||(LA35_0 >= K_BIGINT && LA35_0 <= K_BOOLEAN)||(LA35_0 >= K_CALLED && LA35_0 <= K_CLUSTERING)||(LA35_0 >= K_COMPACT && LA35_0 <= K_COUNTER)||(LA35_0 >= K_CUSTOM && LA35_0 <= K_DECIMAL)||(LA35_0 >= K_DISTINCT && LA35_0 <= K_DOUBLE)||(LA35_0 >= K_EXISTS && LA35_0 <= K_FLOAT)||LA35_0==K_FROZEN||(LA35_0 >= K_FUNCTION && LA35_0 <= K_FUNCTIONS)||LA35_0==K_INET||(LA35_0 >= K_INITCOND && LA35_0 <= K_INPUT)||LA35_0==K_INT||(LA35_0 >= K_JSON && LA35_0 <= K_KEYS)||(LA35_0 >= K_KEYSPACES && LA35_0 <= K_LANGUAGE)||(LA35_0 >= K_LIST && LA35_0 <= K_MAP)||LA35_0==K_NOLOGIN||LA35_0==K_NOSUPERUSER||LA35_0==K_OPTIONS||(LA35_0 >= K_PASSWORD && LA35_0 <= K_PERMISSIONS)||LA35_0==K_RETURNS||(LA35_0 >= K_ROLE && LA35_0 <= K_ROLES)||(LA35_0 >= K_SFUNC && LA35_0 <= K_TINYINT)||LA35_0==K_TRIGGER||(LA35_0 >= K_TTL && LA35_0 <= K_TYPE)||(LA35_0 >= K_USER && LA35_0 <= K_USERS)||(LA35_0 >= K_UUID && LA35_0 <= K_VARINT)||LA35_0==K_WRITETIME||LA35_0==QUOTED_NAME) ) {
				alt35=1;
			}
			switch (alt35) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:18: dels= deleteSelection
					{
					pushFollow(FOLLOW_deleteSelection_in_deleteStatement2332);
					dels=deleteSelection();
					state._fsp--;

					 columnDeletions = dels; 
					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement2345); 
			pushFollow(FOLLOW_columnFamilyName_in_deleteStatement2349);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:467:7: ( usingClauseDelete[attrs] )?
			int alt36=2;
			int LA36_0 = input.LA(1);
			if ( (LA36_0==K_USING) ) {
				alt36=1;
			}
			switch (alt36) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:467:9: usingClauseDelete[attrs]
					{
					pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement2359);
					usingClauseDelete(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement2371); 
			pushFollow(FOLLOW_whereClause_in_deleteStatement2375);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==K_IF) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_deleteStatement2385); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:14: ( K_EXISTS |conditions= updateConditions )
					int alt37=2;
					int LA37_0 = input.LA(1);
					if ( (LA37_0==K_EXISTS) ) {
						int LA37_1 = input.LA(2);
						if ( (LA37_1==EOF||LA37_1==K_APPLY||LA37_1==K_DELETE||LA37_1==K_INSERT||LA37_1==K_UPDATE||LA37_1==178) ) {
							alt37=1;
						}
						else if ( (LA37_1==K_IN||LA37_1==170||(LA37_1 >= 179 && LA37_1 <= 184)) ) {
							alt37=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 37, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA37_0==IDENT||(LA37_0 >= K_AGGREGATE && LA37_0 <= K_ALL)||LA37_0==K_AS||LA37_0==K_ASCII||(LA37_0 >= K_BIGINT && LA37_0 <= K_BOOLEAN)||(LA37_0 >= K_CALLED && LA37_0 <= K_CLUSTERING)||(LA37_0 >= K_COMPACT && LA37_0 <= K_COUNTER)||(LA37_0 >= K_CUSTOM && LA37_0 <= K_DECIMAL)||(LA37_0 >= K_DISTINCT && LA37_0 <= K_DOUBLE)||(LA37_0 >= K_FILTERING && LA37_0 <= K_FLOAT)||LA37_0==K_FROZEN||(LA37_0 >= K_FUNCTION && LA37_0 <= K_FUNCTIONS)||LA37_0==K_INET||(LA37_0 >= K_INITCOND && LA37_0 <= K_INPUT)||LA37_0==K_INT||(LA37_0 >= K_JSON && LA37_0 <= K_KEYS)||(LA37_0 >= K_KEYSPACES && LA37_0 <= K_LANGUAGE)||(LA37_0 >= K_LIST && LA37_0 <= K_MAP)||LA37_0==K_NOLOGIN||LA37_0==K_NOSUPERUSER||LA37_0==K_OPTIONS||(LA37_0 >= K_PASSWORD && LA37_0 <= K_PERMISSIONS)||LA37_0==K_RETURNS||(LA37_0 >= K_ROLE && LA37_0 <= K_ROLES)||(LA37_0 >= K_SFUNC && LA37_0 <= K_TINYINT)||LA37_0==K_TRIGGER||(LA37_0 >= K_TTL && LA37_0 <= K_TYPE)||(LA37_0 >= K_USER && LA37_0 <= K_USERS)||(LA37_0 >= K_UUID && LA37_0 <= K_VARINT)||LA37_0==K_WRITETIME||LA37_0==QUOTED_NAME) ) {
						alt37=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 37, 0, input);
						throw nvae;
					}

					switch (alt37) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_deleteStatement2389); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_deleteStatement2397);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new DeleteStatement.Parsed(cf,
			                                            attrs,
			                                            columnDeletions,
			                                            wclause,
			                                            conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                            ifExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "deleteStatement"



	// $ANTLR start "deleteSelection"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:480:1: deleteSelection returns [List<Operation.RawDeletion> operations] :t1= deleteOp ( ',' tN= deleteOp )* ;
	public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
		List<Operation.RawDeletion> operations = null;


		Operation.RawDeletion t1 =null;
		Operation.RawDeletion tN =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:481:5: (t1= deleteOp ( ',' tN= deleteOp )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:481:7: t1= deleteOp ( ',' tN= deleteOp )*
			{
			 operations = new ArrayList<Operation.RawDeletion>(); 
			pushFollow(FOLLOW_deleteOp_in_deleteSelection2444);
			t1=deleteOp();
			state._fsp--;

			 operations.add(t1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:483:11: ( ',' tN= deleteOp )*
			loop39:
			while (true) {
				int alt39=2;
				int LA39_0 = input.LA(1);
				if ( (LA39_0==174) ) {
					alt39=1;
				}

				switch (alt39) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:483:12: ',' tN= deleteOp
					{
					match(input,174,FOLLOW_174_in_deleteSelection2459); 
					pushFollow(FOLLOW_deleteOp_in_deleteSelection2463);
					tN=deleteOp();
					state._fsp--;

					 operations.add(tN); 
					}
					break;

				default :
					break loop39;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return operations;
	}
	// $ANTLR end "deleteSelection"



	// $ANTLR start "deleteOp"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' );
	public final Operation.RawDeletion deleteOp() throws RecognitionException {
		Operation.RawDeletion op = null;


		ColumnIdentifier.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:487:5: (c= cident |c= cident '[' t= term ']' )
			int alt40=2;
			alt40 = dfa40.predict(input);
			switch (alt40) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:487:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_deleteOp2490);
					c=cident();
					state._fsp--;

					 op = new Operation.ColumnDeletion(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:488:7: c= cident '[' t= term ']'
					{
					pushFollow(FOLLOW_cident_in_deleteOp2517);
					c=cident();
					state._fsp--;

					match(input,184,FOLLOW_184_in_deleteOp2519); 
					pushFollow(FOLLOW_term_in_deleteOp2523);
					t=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_deleteOp2525); 
					 op = new Operation.ElementDeletion(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "deleteOp"



	// $ANTLR start "usingClauseDelete"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:491:1: usingClauseDelete[Attributes.Raw attrs] : K_USING K_TIMESTAMP ts= intValue ;
	public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:492:5: ( K_USING K_TIMESTAMP ts= intValue )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:492:7: K_USING K_TIMESTAMP ts= intValue
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete2545); 
			match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDelete2547); 
			pushFollow(FOLLOW_intValue_in_usingClauseDelete2551);
			ts=intValue();
			state._fsp--;

			 attrs.timestamp = ts; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseDelete"



	// $ANTLR start "batchStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
	public final BatchStatement.Parsed batchStatement() throws RecognitionException {
		BatchStatement.Parsed expr = null;


		ModificationStatement.Parsed s =null;


		        BatchStatement.Type type = BatchStatement.Type.LOGGED;
		        List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
		        Attributes.Raw attrs = new Attributes.Raw();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
			{
			match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement2585); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:526:7: ( K_UNLOGGED | K_COUNTER )?
			int alt41=3;
			int LA41_0 = input.LA(1);
			if ( (LA41_0==K_UNLOGGED) ) {
				alt41=1;
			}
			else if ( (LA41_0==K_COUNTER) ) {
				alt41=2;
			}
			switch (alt41) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:526:9: K_UNLOGGED
					{
					match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement2595); 
					 type = BatchStatement.Type.UNLOGGED; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:526:63: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement2601); 
					 type = BatchStatement.Type.COUNTER; 
					}
					break;

			}

			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2614); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:527:15: ( usingClause[attrs] )?
			int alt42=2;
			int LA42_0 = input.LA(1);
			if ( (LA42_0==K_USING) ) {
				alt42=1;
			}
			switch (alt42) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:527:17: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_batchStatement2618);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:528:11: (s= batchStatementObjective ( ';' )? )*
			loop44:
			while (true) {
				int alt44=2;
				int LA44_0 = input.LA(1);
				if ( (LA44_0==K_DELETE||LA44_0==K_INSERT||LA44_0==K_UPDATE) ) {
					alt44=1;
				}

				switch (alt44) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:528:13: s= batchStatementObjective ( ';' )?
					{
					pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2638);
					s=batchStatementObjective();
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:528:39: ( ';' )?
					int alt43=2;
					int LA43_0 = input.LA(1);
					if ( (LA43_0==178) ) {
						alt43=1;
					}
					switch (alt43) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:528:39: ';'
							{
							match(input,178,FOLLOW_178_in_batchStatement2640); 
							}
							break;

					}

					 statements.add(s); 
					}
					break;

				default :
					break loop44;
				}
			}

			match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement2654); 
			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2656); 

			          return new BatchStatement.Parsed(type, attrs, statements);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "batchStatement"



	// $ANTLR start "batchStatementObjective"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:535:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement |u= updateStatement |d= deleteStatement );
	public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
		ModificationStatement.Parsed statement = null;


		ModificationStatement.Parsed i =null;
		UpdateStatement.ParsedUpdate u =null;
		DeleteStatement.Parsed d =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:5: (i= insertStatement |u= updateStatement |d= deleteStatement )
			int alt45=3;
			switch ( input.LA(1) ) {
			case K_INSERT:
				{
				alt45=1;
				}
				break;
			case K_UPDATE:
				{
				alt45=2;
				}
				break;
			case K_DELETE:
				{
				alt45=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}
			switch (alt45) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:7: i= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_batchStatementObjective2687);
					i=insertStatement();
					state._fsp--;

					 statement = i; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:537:7: u= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_batchStatementObjective2700);
					u=updateStatement();
					state._fsp--;

					 statement = u; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:538:7: d= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective2713);
					d=deleteStatement();
					state._fsp--;

					 statement = d; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return statement;
	}
	// $ANTLR end "batchStatementObjective"



	// $ANTLR start "createAggregateStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:1: createAggregateStatement returns [CreateAggregateStatement expr] : K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= allowedFunctionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= allowedFunctionName )? ( K_INITCOND ival= term )? ;
	public final CreateAggregateStatement createAggregateStatement() throws RecognitionException {
		CreateAggregateStatement expr = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;
		String sfunc =null;
		CQL3Type.Raw stype =null;
		String ffunc =null;
		Term.Raw ival =null;


		        boolean orReplace = false;
		        boolean ifNotExists = false;

		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:548:5: ( K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= allowedFunctionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= allowedFunctionName )? ( K_INITCOND ival= term )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:548:7: K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= allowedFunctionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= allowedFunctionName )? ( K_INITCOND ival= term )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createAggregateStatement2746); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:548:16: ( K_OR K_REPLACE )?
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==K_OR) ) {
				alt46=1;
			}
			switch (alt46) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:548:17: K_OR K_REPLACE
					{
					match(input,K_OR,FOLLOW_K_OR_in_createAggregateStatement2749); 
					match(input,K_REPLACE,FOLLOW_K_REPLACE_in_createAggregateStatement2751); 
					 orReplace = true; 
					}
					break;

			}

			match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_createAggregateStatement2763); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:550:7: ( K_IF K_NOT K_EXISTS )?
			int alt47=2;
			int LA47_0 = input.LA(1);
			if ( (LA47_0==K_IF) ) {
				alt47=1;
			}
			switch (alt47) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:550:8: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createAggregateStatement2772); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createAggregateStatement2774); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createAggregateStatement2776); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_createAggregateStatement2790);
			fn=functionName();
			state._fsp--;

			match(input,171,FOLLOW_171_in_createAggregateStatement2798); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:9: (v= comparatorType ( ',' v= comparatorType )* )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==IDENT||(LA49_0 >= K_AGGREGATE && LA49_0 <= K_ALL)||LA49_0==K_AS||LA49_0==K_ASCII||(LA49_0 >= K_BIGINT && LA49_0 <= K_BOOLEAN)||(LA49_0 >= K_CALLED && LA49_0 <= K_CLUSTERING)||(LA49_0 >= K_COMPACT && LA49_0 <= K_COUNTER)||(LA49_0 >= K_CUSTOM && LA49_0 <= K_DECIMAL)||(LA49_0 >= K_DISTINCT && LA49_0 <= K_DOUBLE)||(LA49_0 >= K_EXISTS && LA49_0 <= K_FLOAT)||LA49_0==K_FROZEN||(LA49_0 >= K_FUNCTION && LA49_0 <= K_FUNCTIONS)||LA49_0==K_INET||(LA49_0 >= K_INITCOND && LA49_0 <= K_INPUT)||LA49_0==K_INT||(LA49_0 >= K_JSON && LA49_0 <= K_KEYS)||(LA49_0 >= K_KEYSPACES && LA49_0 <= K_LANGUAGE)||(LA49_0 >= K_LIST && LA49_0 <= K_MAP)||LA49_0==K_NOLOGIN||LA49_0==K_NOSUPERUSER||LA49_0==K_OPTIONS||(LA49_0 >= K_PASSWORD && LA49_0 <= K_PERMISSIONS)||LA49_0==K_RETURNS||(LA49_0 >= K_ROLE && LA49_0 <= K_ROLES)||(LA49_0 >= K_SET && LA49_0 <= K_TINYINT)||LA49_0==K_TRIGGER||(LA49_0 >= K_TTL && LA49_0 <= K_TYPE)||(LA49_0 >= K_USER && LA49_0 <= K_USERS)||(LA49_0 >= K_UUID && LA49_0 <= K_VARINT)||LA49_0==K_WRITETIME||LA49_0==QUOTED_NAME||LA49_0==STRING_LITERAL) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:11: v= comparatorType ( ',' v= comparatorType )*
					{
					pushFollow(FOLLOW_comparatorType_in_createAggregateStatement2822);
					v=comparatorType();
					state._fsp--;

					 argsTypes.add(v); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:555:11: ( ',' v= comparatorType )*
					loop48:
					while (true) {
						int alt48=2;
						int LA48_0 = input.LA(1);
						if ( (LA48_0==174) ) {
							alt48=1;
						}

						switch (alt48) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:555:13: ',' v= comparatorType
							{
							match(input,174,FOLLOW_174_in_createAggregateStatement2838); 
							pushFollow(FOLLOW_comparatorType_in_createAggregateStatement2842);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							}
							break;

						default :
							break loop48;
						}
					}

					}
					break;

			}

			match(input,172,FOLLOW_172_in_createAggregateStatement2866); 
			match(input,K_SFUNC,FOLLOW_K_SFUNC_in_createAggregateStatement2874); 
			pushFollow(FOLLOW_allowedFunctionName_in_createAggregateStatement2880);
			sfunc=allowedFunctionName();
			state._fsp--;

			match(input,K_STYPE,FOLLOW_K_STYPE_in_createAggregateStatement2888); 
			pushFollow(FOLLOW_comparatorType_in_createAggregateStatement2894);
			stype=comparatorType();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:7: ( K_FINALFUNC ffunc= allowedFunctionName )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==K_FINALFUNC) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:561:9: K_FINALFUNC ffunc= allowedFunctionName
					{
					match(input,K_FINALFUNC,FOLLOW_K_FINALFUNC_in_createAggregateStatement2912); 
					pushFollow(FOLLOW_allowedFunctionName_in_createAggregateStatement2918);
					ffunc=allowedFunctionName();
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:563:7: ( K_INITCOND ival= term )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==K_INITCOND) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:564:9: K_INITCOND ival= term
					{
					match(input,K_INITCOND,FOLLOW_K_INITCOND_in_createAggregateStatement2945); 
					pushFollow(FOLLOW_term_in_createAggregateStatement2951);
					ival=term();
					state._fsp--;

					}
					break;

			}

			 expr = new CreateAggregateStatement(fn, argsTypes, sfunc, stype, ffunc, ival, orReplace, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createAggregateStatement"



	// $ANTLR start "dropAggregateStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:569:1: dropAggregateStatement returns [DropAggregateStatement expr] : K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? ;
	public final DropAggregateStatement dropAggregateStatement() throws RecognitionException {
		DropAggregateStatement expr = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        boolean ifExists = false;
		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		        boolean argsPresent = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:575:5: ( K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:575:7: K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropAggregateStatement2998); 
			match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_dropAggregateStatement3000); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:576:7: ( K_IF K_EXISTS )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==K_IF) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:576:8: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropAggregateStatement3009); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropAggregateStatement3011); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_dropAggregateStatement3026);
			fn=functionName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==171) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:579:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,171,FOLLOW_171_in_dropAggregateStatement3044); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt54=2;
					int LA54_0 = input.LA(1);
					if ( (LA54_0==IDENT||(LA54_0 >= K_AGGREGATE && LA54_0 <= K_ALL)||LA54_0==K_AS||LA54_0==K_ASCII||(LA54_0 >= K_BIGINT && LA54_0 <= K_BOOLEAN)||(LA54_0 >= K_CALLED && LA54_0 <= K_CLUSTERING)||(LA54_0 >= K_COMPACT && LA54_0 <= K_COUNTER)||(LA54_0 >= K_CUSTOM && LA54_0 <= K_DECIMAL)||(LA54_0 >= K_DISTINCT && LA54_0 <= K_DOUBLE)||(LA54_0 >= K_EXISTS && LA54_0 <= K_FLOAT)||LA54_0==K_FROZEN||(LA54_0 >= K_FUNCTION && LA54_0 <= K_FUNCTIONS)||LA54_0==K_INET||(LA54_0 >= K_INITCOND && LA54_0 <= K_INPUT)||LA54_0==K_INT||(LA54_0 >= K_JSON && LA54_0 <= K_KEYS)||(LA54_0 >= K_KEYSPACES && LA54_0 <= K_LANGUAGE)||(LA54_0 >= K_LIST && LA54_0 <= K_MAP)||LA54_0==K_NOLOGIN||LA54_0==K_NOSUPERUSER||LA54_0==K_OPTIONS||(LA54_0 >= K_PASSWORD && LA54_0 <= K_PERMISSIONS)||LA54_0==K_RETURNS||(LA54_0 >= K_ROLE && LA54_0 <= K_ROLES)||(LA54_0 >= K_SET && LA54_0 <= K_TINYINT)||LA54_0==K_TRIGGER||(LA54_0 >= K_TTL && LA54_0 <= K_TYPE)||(LA54_0 >= K_USER && LA54_0 <= K_USERS)||(LA54_0 >= K_UUID && LA54_0 <= K_VARINT)||LA54_0==K_WRITETIME||LA54_0==QUOTED_NAME||LA54_0==STRING_LITERAL) ) {
						alt54=1;
					}
					switch (alt54) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:581:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_dropAggregateStatement3072);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:582:13: ( ',' v= comparatorType )*
							loop53:
							while (true) {
								int alt53=2;
								int LA53_0 = input.LA(1);
								if ( (LA53_0==174) ) {
									alt53=1;
								}

								switch (alt53) {
								case 1 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:582:15: ',' v= comparatorType
									{
									match(input,174,FOLLOW_174_in_dropAggregateStatement3090); 
									pushFollow(FOLLOW_comparatorType_in_dropAggregateStatement3094);
									v=comparatorType();
									state._fsp--;

									 argsTypes.add(v); 
									}
									break;

								default :
									break loop53;
								}
							}

							}
							break;

					}

					match(input,172,FOLLOW_172_in_dropAggregateStatement3122); 
					 argsPresent = true; 
					}
					break;

			}

			 expr = new DropAggregateStatement(fn, argsTypes, argsPresent, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropAggregateStatement"



	// $ANTLR start "createFunctionStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:590:1: createFunctionStatement returns [CreateFunctionStatement expr] : K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS rt= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL ;
	public final CreateFunctionStatement createFunctionStatement() throws RecognitionException {
		CreateFunctionStatement expr = null;


		Token language=null;
		Token body=null;
		FunctionName fn =null;
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		CQL3Type.Raw rt =null;


		        boolean orReplace = false;
		        boolean ifNotExists = false;

		        List<ColumnIdentifier> argsNames = new ArrayList<>();
		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		        boolean calledOnNullInput = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:599:5: ( K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS rt= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:599:7: K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS rt= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createFunctionStatement3179); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:599:16: ( K_OR K_REPLACE )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==K_OR) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:599:17: K_OR K_REPLACE
					{
					match(input,K_OR,FOLLOW_K_OR_in_createFunctionStatement3182); 
					match(input,K_REPLACE,FOLLOW_K_REPLACE_in_createFunctionStatement3184); 
					 orReplace = true; 
					}
					break;

			}

			match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_createFunctionStatement3196); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:601:7: ( K_IF K_NOT K_EXISTS )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==K_IF) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:601:8: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createFunctionStatement3205); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createFunctionStatement3207); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createFunctionStatement3209); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_createFunctionStatement3223);
			fn=functionName();
			state._fsp--;

			match(input,171,FOLLOW_171_in_createFunctionStatement3231); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:9: (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )?
			int alt59=2;
			int LA59_0 = input.LA(1);
			if ( (LA59_0==IDENT||(LA59_0 >= K_AGGREGATE && LA59_0 <= K_ALL)||LA59_0==K_AS||LA59_0==K_ASCII||(LA59_0 >= K_BIGINT && LA59_0 <= K_BOOLEAN)||(LA59_0 >= K_CALLED && LA59_0 <= K_CLUSTERING)||(LA59_0 >= K_COMPACT && LA59_0 <= K_COUNTER)||(LA59_0 >= K_CUSTOM && LA59_0 <= K_DECIMAL)||(LA59_0 >= K_DISTINCT && LA59_0 <= K_DOUBLE)||(LA59_0 >= K_EXISTS && LA59_0 <= K_FLOAT)||LA59_0==K_FROZEN||(LA59_0 >= K_FUNCTION && LA59_0 <= K_FUNCTIONS)||LA59_0==K_INET||(LA59_0 >= K_INITCOND && LA59_0 <= K_INPUT)||LA59_0==K_INT||(LA59_0 >= K_JSON && LA59_0 <= K_KEYS)||(LA59_0 >= K_KEYSPACES && LA59_0 <= K_LANGUAGE)||(LA59_0 >= K_LIST && LA59_0 <= K_MAP)||LA59_0==K_NOLOGIN||LA59_0==K_NOSUPERUSER||LA59_0==K_OPTIONS||(LA59_0 >= K_PASSWORD && LA59_0 <= K_PERMISSIONS)||LA59_0==K_RETURNS||(LA59_0 >= K_ROLE && LA59_0 <= K_ROLES)||(LA59_0 >= K_SFUNC && LA59_0 <= K_TINYINT)||LA59_0==K_TRIGGER||(LA59_0 >= K_TTL && LA59_0 <= K_TYPE)||(LA59_0 >= K_USER && LA59_0 <= K_USERS)||(LA59_0 >= K_UUID && LA59_0 <= K_VARINT)||LA59_0==K_WRITETIME||LA59_0==QUOTED_NAME) ) {
				alt59=1;
			}
			switch (alt59) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:11: k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )*
					{
					pushFollow(FOLLOW_noncol_ident_in_createFunctionStatement3255);
					k=noncol_ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_createFunctionStatement3259);
					v=comparatorType();
					state._fsp--;

					 argsNames.add(k); argsTypes.add(v); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:606:11: ( ',' k= noncol_ident v= comparatorType )*
					loop58:
					while (true) {
						int alt58=2;
						int LA58_0 = input.LA(1);
						if ( (LA58_0==174) ) {
							alt58=1;
						}

						switch (alt58) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:606:13: ',' k= noncol_ident v= comparatorType
							{
							match(input,174,FOLLOW_174_in_createFunctionStatement3275); 
							pushFollow(FOLLOW_noncol_ident_in_createFunctionStatement3279);
							k=noncol_ident();
							state._fsp--;

							pushFollow(FOLLOW_comparatorType_in_createFunctionStatement3283);
							v=comparatorType();
							state._fsp--;

							 argsNames.add(k); argsTypes.add(v); 
							}
							break;

						default :
							break loop58;
						}
					}

					}
					break;

			}

			match(input,172,FOLLOW_172_in_createFunctionStatement3307); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:7: ( ( K_RETURNS K_NULL ) | ( K_CALLED ) )
			int alt60=2;
			int LA60_0 = input.LA(1);
			if ( (LA60_0==K_RETURNS) ) {
				alt60=1;
			}
			else if ( (LA60_0==K_CALLED) ) {
				alt60=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 60, 0, input);
				throw nvae;
			}

			switch (alt60) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:9: ( K_RETURNS K_NULL )
					{
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:9: ( K_RETURNS K_NULL )
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:10: K_RETURNS K_NULL
					{
					match(input,K_RETURNS,FOLLOW_K_RETURNS_in_createFunctionStatement3318); 
					match(input,K_NULL,FOLLOW_K_NULL_in_createFunctionStatement3320); 
					}

					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:30: ( K_CALLED )
					{
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:30: ( K_CALLED )
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:31: K_CALLED
					{
					match(input,K_CALLED,FOLLOW_K_CALLED_in_createFunctionStatement3326); 
					 calledOnNullInput=true; 
					}

					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createFunctionStatement3332); 
			match(input,K_NULL,FOLLOW_K_NULL_in_createFunctionStatement3334); 
			match(input,K_INPUT,FOLLOW_K_INPUT_in_createFunctionStatement3336); 
			match(input,K_RETURNS,FOLLOW_K_RETURNS_in_createFunctionStatement3344); 
			pushFollow(FOLLOW_comparatorType_in_createFunctionStatement3350);
			rt=comparatorType();
			state._fsp--;

			match(input,K_LANGUAGE,FOLLOW_K_LANGUAGE_in_createFunctionStatement3358); 
			language=(Token)match(input,IDENT,FOLLOW_IDENT_in_createFunctionStatement3364); 
			match(input,K_AS,FOLLOW_K_AS_in_createFunctionStatement3372); 
			body=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createFunctionStatement3378); 
			 expr = new CreateFunctionStatement(fn, (language!=null?language.getText():null).toLowerCase(), (body!=null?body.getText():null),
			                                            argsNames, argsTypes, rt, calledOnNullInput, orReplace, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createFunctionStatement"



	// $ANTLR start "dropFunctionStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:617:1: dropFunctionStatement returns [DropFunctionStatement expr] : K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? ;
	public final DropFunctionStatement dropFunctionStatement() throws RecognitionException {
		DropFunctionStatement expr = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        boolean ifExists = false;
		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		        boolean argsPresent = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:623:5: ( K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:623:7: K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropFunctionStatement3416); 
			match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_dropFunctionStatement3418); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:624:7: ( K_IF K_EXISTS )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==K_IF) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:624:8: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropFunctionStatement3427); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropFunctionStatement3429); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_dropFunctionStatement3444);
			fn=functionName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:626:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==171) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:627:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,171,FOLLOW_171_in_dropFunctionStatement3462); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt63=2;
					int LA63_0 = input.LA(1);
					if ( (LA63_0==IDENT||(LA63_0 >= K_AGGREGATE && LA63_0 <= K_ALL)||LA63_0==K_AS||LA63_0==K_ASCII||(LA63_0 >= K_BIGINT && LA63_0 <= K_BOOLEAN)||(LA63_0 >= K_CALLED && LA63_0 <= K_CLUSTERING)||(LA63_0 >= K_COMPACT && LA63_0 <= K_COUNTER)||(LA63_0 >= K_CUSTOM && LA63_0 <= K_DECIMAL)||(LA63_0 >= K_DISTINCT && LA63_0 <= K_DOUBLE)||(LA63_0 >= K_EXISTS && LA63_0 <= K_FLOAT)||LA63_0==K_FROZEN||(LA63_0 >= K_FUNCTION && LA63_0 <= K_FUNCTIONS)||LA63_0==K_INET||(LA63_0 >= K_INITCOND && LA63_0 <= K_INPUT)||LA63_0==K_INT||(LA63_0 >= K_JSON && LA63_0 <= K_KEYS)||(LA63_0 >= K_KEYSPACES && LA63_0 <= K_LANGUAGE)||(LA63_0 >= K_LIST && LA63_0 <= K_MAP)||LA63_0==K_NOLOGIN||LA63_0==K_NOSUPERUSER||LA63_0==K_OPTIONS||(LA63_0 >= K_PASSWORD && LA63_0 <= K_PERMISSIONS)||LA63_0==K_RETURNS||(LA63_0 >= K_ROLE && LA63_0 <= K_ROLES)||(LA63_0 >= K_SET && LA63_0 <= K_TINYINT)||LA63_0==K_TRIGGER||(LA63_0 >= K_TTL && LA63_0 <= K_TYPE)||(LA63_0 >= K_USER && LA63_0 <= K_USERS)||(LA63_0 >= K_UUID && LA63_0 <= K_VARINT)||LA63_0==K_WRITETIME||LA63_0==QUOTED_NAME||LA63_0==STRING_LITERAL) ) {
						alt63=1;
					}
					switch (alt63) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_dropFunctionStatement3490);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:13: ( ',' v= comparatorType )*
							loop62:
							while (true) {
								int alt62=2;
								int LA62_0 = input.LA(1);
								if ( (LA62_0==174) ) {
									alt62=1;
								}

								switch (alt62) {
								case 1 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:15: ',' v= comparatorType
									{
									match(input,174,FOLLOW_174_in_dropFunctionStatement3508); 
									pushFollow(FOLLOW_comparatorType_in_dropFunctionStatement3512);
									v=comparatorType();
									state._fsp--;

									 argsTypes.add(v); 
									}
									break;

								default :
									break loop62;
								}
							}

							}
							break;

					}

					match(input,172,FOLLOW_172_in_dropFunctionStatement3540); 
					 argsPresent = true; 
					}
					break;

			}

			 expr = new DropFunctionStatement(fn, argsTypes, argsPresent, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropFunctionStatement"



	// $ANTLR start "createKeyspaceStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:641:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
	public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
		CreateKeyspaceStatement expr = null;


		String ks =null;


		        KeyspaceAttributes attrs = new KeyspaceAttributes();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement3599); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement3601); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:27: ( K_IF K_NOT K_EXISTS )?
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==K_IF) ) {
				alt65=1;
			}
			switch (alt65) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:28: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement3604); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement3606); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement3608); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement3617);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement3625); 
			pushFollow(FOLLOW_properties_in_createKeyspaceStatement3627);
			properties(attrs);
			state._fsp--;

			 expr = new CreateKeyspaceStatement(ks, attrs, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createKeyspaceStatement"



	// $ANTLR start "createTableStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:657:1: createTableStatement returns [CreateTableStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] ;
	public final CreateTableStatement.RawStatement createTableStatement() throws RecognitionException {
		CreateTableStatement.RawStatement expr = null;


		CFName cf =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement3662); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement3664); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:31: ( K_IF K_NOT K_EXISTS )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==K_IF) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:32: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTableStatement3667); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement3669); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement3671); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createTableStatement3686);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new CreateTableStatement.RawStatement(cf, ifNotExists); 
			pushFollow(FOLLOW_cfamDefinition_in_createTableStatement3696);
			cfamDefinition(expr);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTableStatement"



	// $ANTLR start "cfamDefinition"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:1: cfamDefinition[CreateTableStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? ;
	public final void cfamDefinition(CreateTableStatement.RawStatement expr) throws RecognitionException {
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			{
			match(input,171,FOLLOW_171_in_cfamDefinition3715); 
			pushFollow(FOLLOW_cfamColumns_in_cfamDefinition3717);
			cfamColumns(expr);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:29: ( ',' ( cfamColumns[expr] )? )*
			loop68:
			while (true) {
				int alt68=2;
				int LA68_0 = input.LA(1);
				if ( (LA68_0==174) ) {
					alt68=1;
				}

				switch (alt68) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:31: ',' ( cfamColumns[expr] )?
					{
					match(input,174,FOLLOW_174_in_cfamDefinition3722); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:35: ( cfamColumns[expr] )?
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( (LA67_0==IDENT||(LA67_0 >= K_AGGREGATE && LA67_0 <= K_ALL)||LA67_0==K_AS||LA67_0==K_ASCII||(LA67_0 >= K_BIGINT && LA67_0 <= K_BOOLEAN)||(LA67_0 >= K_CALLED && LA67_0 <= K_CLUSTERING)||(LA67_0 >= K_COMPACT && LA67_0 <= K_COUNTER)||(LA67_0 >= K_CUSTOM && LA67_0 <= K_DECIMAL)||(LA67_0 >= K_DISTINCT && LA67_0 <= K_DOUBLE)||(LA67_0 >= K_EXISTS && LA67_0 <= K_FLOAT)||LA67_0==K_FROZEN||(LA67_0 >= K_FUNCTION && LA67_0 <= K_FUNCTIONS)||LA67_0==K_INET||(LA67_0 >= K_INITCOND && LA67_0 <= K_INPUT)||LA67_0==K_INT||(LA67_0 >= K_JSON && LA67_0 <= K_KEYS)||(LA67_0 >= K_KEYSPACES && LA67_0 <= K_LANGUAGE)||(LA67_0 >= K_LIST && LA67_0 <= K_MAP)||LA67_0==K_NOLOGIN||LA67_0==K_NOSUPERUSER||LA67_0==K_OPTIONS||(LA67_0 >= K_PASSWORD && LA67_0 <= K_PRIMARY)||LA67_0==K_RETURNS||(LA67_0 >= K_ROLE && LA67_0 <= K_ROLES)||(LA67_0 >= K_SFUNC && LA67_0 <= K_TINYINT)||LA67_0==K_TRIGGER||(LA67_0 >= K_TTL && LA67_0 <= K_TYPE)||(LA67_0 >= K_USER && LA67_0 <= K_USERS)||(LA67_0 >= K_UUID && LA67_0 <= K_VARINT)||LA67_0==K_WRITETIME||LA67_0==QUOTED_NAME) ) {
						alt67=1;
					}
					switch (alt67) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:665:35: cfamColumns[expr]
							{
							pushFollow(FOLLOW_cfamColumns_in_cfamDefinition3724);
							cfamColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop68;
				}
			}

			match(input,172,FOLLOW_172_in_cfamDefinition3731); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:666:7: ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			int alt70=2;
			int LA70_0 = input.LA(1);
			if ( (LA70_0==K_WITH) ) {
				alt70=1;
			}
			switch (alt70) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:666:9: K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition3741); 
					pushFollow(FOLLOW_cfamProperty_in_cfamDefinition3743);
					cfamProperty(expr.properties);
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:666:46: ( K_AND cfamProperty[expr.properties] )*
					loop69:
					while (true) {
						int alt69=2;
						int LA69_0 = input.LA(1);
						if ( (LA69_0==K_AND) ) {
							alt69=1;
						}

						switch (alt69) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:666:48: K_AND cfamProperty[expr.properties]
							{
							match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition3748); 
							pushFollow(FOLLOW_cfamProperty_in_cfamDefinition3750);
							cfamProperty(expr.properties);
							state._fsp--;

							}
							break;

						default :
							break loop69;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamDefinition"



	// $ANTLR start "cfamColumns"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:669:1: cfamColumns[CreateTableStatement.RawStatement expr] : (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' );
	public final void cfamColumns(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier c =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:5: (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' )
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==IDENT||(LA74_0 >= K_AGGREGATE && LA74_0 <= K_ALL)||LA74_0==K_AS||LA74_0==K_ASCII||(LA74_0 >= K_BIGINT && LA74_0 <= K_BOOLEAN)||(LA74_0 >= K_CALLED && LA74_0 <= K_CLUSTERING)||(LA74_0 >= K_COMPACT && LA74_0 <= K_COUNTER)||(LA74_0 >= K_CUSTOM && LA74_0 <= K_DECIMAL)||(LA74_0 >= K_DISTINCT && LA74_0 <= K_DOUBLE)||(LA74_0 >= K_EXISTS && LA74_0 <= K_FLOAT)||LA74_0==K_FROZEN||(LA74_0 >= K_FUNCTION && LA74_0 <= K_FUNCTIONS)||LA74_0==K_INET||(LA74_0 >= K_INITCOND && LA74_0 <= K_INPUT)||LA74_0==K_INT||(LA74_0 >= K_JSON && LA74_0 <= K_KEYS)||(LA74_0 >= K_KEYSPACES && LA74_0 <= K_LANGUAGE)||(LA74_0 >= K_LIST && LA74_0 <= K_MAP)||LA74_0==K_NOLOGIN||LA74_0==K_NOSUPERUSER||LA74_0==K_OPTIONS||(LA74_0 >= K_PASSWORD && LA74_0 <= K_PERMISSIONS)||LA74_0==K_RETURNS||(LA74_0 >= K_ROLE && LA74_0 <= K_ROLES)||(LA74_0 >= K_SFUNC && LA74_0 <= K_TINYINT)||LA74_0==K_TRIGGER||(LA74_0 >= K_TTL && LA74_0 <= K_TYPE)||(LA74_0 >= K_USER && LA74_0 <= K_USERS)||(LA74_0 >= K_UUID && LA74_0 <= K_VARINT)||LA74_0==K_WRITETIME||LA74_0==QUOTED_NAME) ) {
				alt74=1;
			}
			else if ( (LA74_0==K_PRIMARY) ) {
				alt74=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 74, 0, input);
				throw nvae;
			}

			switch (alt74) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:7: k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )?
					{
					pushFollow(FOLLOW_ident_in_cfamColumns3776);
					k=ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_cfamColumns3780);
					v=comparatorType();
					state._fsp--;

					 boolean isStatic=false; 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:60: ( K_STATIC )?
					int alt71=2;
					int LA71_0 = input.LA(1);
					if ( (LA71_0==K_STATIC) ) {
						alt71=1;
					}
					switch (alt71) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:61: K_STATIC
							{
							match(input,K_STATIC,FOLLOW_K_STATIC_in_cfamColumns3785); 
							isStatic = true;
							}
							break;

					}

					 expr.addDefinition(k, v, isStatic); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:9: ( K_PRIMARY K_KEY )?
					int alt72=2;
					int LA72_0 = input.LA(1);
					if ( (LA72_0==K_PRIMARY) ) {
						alt72=1;
					}
					switch (alt72) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:10: K_PRIMARY K_KEY
							{
							match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns3802); 
							match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns3804); 
							 expr.addKeyAliases(Collections.singletonList(k)); 
							}
							break;

					}

					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:672:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')'
					{
					match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns3816); 
					match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns3818); 
					match(input,171,FOLLOW_171_in_cfamColumns3820); 
					pushFollow(FOLLOW_pkDef_in_cfamColumns3822);
					pkDef(expr);
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:672:39: ( ',' c= ident )*
					loop73:
					while (true) {
						int alt73=2;
						int LA73_0 = input.LA(1);
						if ( (LA73_0==174) ) {
							alt73=1;
						}

						switch (alt73) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:672:40: ',' c= ident
							{
							match(input,174,FOLLOW_174_in_cfamColumns3826); 
							pushFollow(FOLLOW_ident_in_cfamColumns3830);
							c=ident();
							state._fsp--;

							 expr.addColumnAlias(c); 
							}
							break;

						default :
							break loop73;
						}
					}

					match(input,172,FOLLOW_172_in_cfamColumns3837); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamColumns"



	// $ANTLR start "pkDef"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:675:1: pkDef[CreateTableStatement.RawStatement expr] : (k= ident | '(' k1= ident ( ',' kn= ident )* ')' );
	public final void pkDef(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		ColumnIdentifier k1 =null;
		ColumnIdentifier kn =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:676:5: (k= ident | '(' k1= ident ( ',' kn= ident )* ')' )
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==IDENT||(LA76_0 >= K_AGGREGATE && LA76_0 <= K_ALL)||LA76_0==K_AS||LA76_0==K_ASCII||(LA76_0 >= K_BIGINT && LA76_0 <= K_BOOLEAN)||(LA76_0 >= K_CALLED && LA76_0 <= K_CLUSTERING)||(LA76_0 >= K_COMPACT && LA76_0 <= K_COUNTER)||(LA76_0 >= K_CUSTOM && LA76_0 <= K_DECIMAL)||(LA76_0 >= K_DISTINCT && LA76_0 <= K_DOUBLE)||(LA76_0 >= K_EXISTS && LA76_0 <= K_FLOAT)||LA76_0==K_FROZEN||(LA76_0 >= K_FUNCTION && LA76_0 <= K_FUNCTIONS)||LA76_0==K_INET||(LA76_0 >= K_INITCOND && LA76_0 <= K_INPUT)||LA76_0==K_INT||(LA76_0 >= K_JSON && LA76_0 <= K_KEYS)||(LA76_0 >= K_KEYSPACES && LA76_0 <= K_LANGUAGE)||(LA76_0 >= K_LIST && LA76_0 <= K_MAP)||LA76_0==K_NOLOGIN||LA76_0==K_NOSUPERUSER||LA76_0==K_OPTIONS||(LA76_0 >= K_PASSWORD && LA76_0 <= K_PERMISSIONS)||LA76_0==K_RETURNS||(LA76_0 >= K_ROLE && LA76_0 <= K_ROLES)||(LA76_0 >= K_SFUNC && LA76_0 <= K_TINYINT)||LA76_0==K_TRIGGER||(LA76_0 >= K_TTL && LA76_0 <= K_TYPE)||(LA76_0 >= K_USER && LA76_0 <= K_USERS)||(LA76_0 >= K_UUID && LA76_0 <= K_VARINT)||LA76_0==K_WRITETIME||LA76_0==QUOTED_NAME) ) {
				alt76=1;
			}
			else if ( (LA76_0==171) ) {
				alt76=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 76, 0, input);
				throw nvae;
			}

			switch (alt76) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:676:7: k= ident
					{
					pushFollow(FOLLOW_ident_in_pkDef3857);
					k=ident();
					state._fsp--;

					 expr.addKeyAliases(Collections.singletonList(k)); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:677:7: '(' k1= ident ( ',' kn= ident )* ')'
					{
					match(input,171,FOLLOW_171_in_pkDef3867); 
					 List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
					pushFollow(FOLLOW_ident_in_pkDef3873);
					k1=ident();
					state._fsp--;

					 l.add(k1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:677:101: ( ',' kn= ident )*
					loop75:
					while (true) {
						int alt75=2;
						int LA75_0 = input.LA(1);
						if ( (LA75_0==174) ) {
							alt75=1;
						}

						switch (alt75) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:677:103: ',' kn= ident
							{
							match(input,174,FOLLOW_174_in_pkDef3879); 
							pushFollow(FOLLOW_ident_in_pkDef3883);
							kn=ident();
							state._fsp--;

							 l.add(kn); 
							}
							break;

						default :
							break loop75;
						}
					}

					match(input,172,FOLLOW_172_in_pkDef3890); 
					 expr.addKeyAliases(l); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pkDef"



	// $ANTLR start "cfamProperty"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:680:1: cfamProperty[CFProperties props] : ( property[props.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[props] ( ',' cfamOrdering[props] )* ')' );
	public final void cfamProperty(CFProperties props) throws RecognitionException {
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:5: ( property[props.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[props] ( ',' cfamOrdering[props] )* ')' )
			int alt78=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt78=1;
				}
				break;
			case K_COMPACT:
				{
				int LA78_2 = input.LA(2);
				if ( (LA78_2==K_STORAGE) ) {
					alt78=2;
				}
				else if ( (LA78_2==181) ) {
					alt78=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 78, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_CLUSTERING:
				{
				int LA78_3 = input.LA(2);
				if ( (LA78_3==K_ORDER) ) {
					alt78=3;
				}
				else if ( (LA78_3==181) ) {
					alt78=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 78, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 78, 0, input);
				throw nvae;
			}
			switch (alt78) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:7: property[props.properties]
					{
					pushFollow(FOLLOW_property_in_cfamProperty3910);
					property(props.properties);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:7: K_COMPACT K_STORAGE
					{
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty3919); 
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty3921); 
					 props.setCompactStorage(); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:683:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[props] ( ',' cfamOrdering[props] )* ')'
					{
					match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty3931); 
					match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty3933); 
					match(input,K_BY,FOLLOW_K_BY_in_cfamProperty3935); 
					match(input,171,FOLLOW_171_in_cfamProperty3937); 
					pushFollow(FOLLOW_cfamOrdering_in_cfamProperty3939);
					cfamOrdering(props);
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:683:57: ( ',' cfamOrdering[props] )*
					loop77:
					while (true) {
						int alt77=2;
						int LA77_0 = input.LA(1);
						if ( (LA77_0==174) ) {
							alt77=1;
						}

						switch (alt77) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:683:58: ',' cfamOrdering[props]
							{
							match(input,174,FOLLOW_174_in_cfamProperty3943); 
							pushFollow(FOLLOW_cfamOrdering_in_cfamProperty3945);
							cfamOrdering(props);
							state._fsp--;

							}
							break;

						default :
							break loop77;
						}
					}

					match(input,172,FOLLOW_172_in_cfamProperty3950); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamProperty"



	// $ANTLR start "cfamOrdering"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:1: cfamOrdering[CFProperties props] : k= ident ( K_ASC | K_DESC ) ;
	public final void cfamOrdering(CFProperties props) throws RecognitionException {
		ColumnIdentifier k =null;

		 boolean reversed=false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:5: (k= ident ( K_ASC | K_DESC ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:7: k= ident ( K_ASC | K_DESC )
			{
			pushFollow(FOLLOW_ident_in_cfamOrdering3978);
			k=ident();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:15: ( K_ASC | K_DESC )
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==K_ASC) ) {
				alt79=1;
			}
			else if ( (LA79_0==K_DESC) ) {
				alt79=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 79, 0, input);
				throw nvae;
			}

			switch (alt79) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:16: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering3981); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:24: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering3985); 
					 reversed=true;
					}
					break;

			}

			 props.setOrdering(k, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamOrdering"



	// $ANTLR start "createTypeStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:699:1: createTypeStatement returns [CreateTypeStatement expr] : K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' ;
	public final CreateTypeStatement createTypeStatement() throws RecognitionException {
		CreateTypeStatement expr = null;


		UTName tn =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:701:5: ( K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:701:7: K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')'
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTypeStatement4024); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_createTypeStatement4026); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:701:23: ( K_IF K_NOT K_EXISTS )?
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==K_IF) ) {
				alt80=1;
			}
			switch (alt80) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:701:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTypeStatement4029); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTypeStatement4031); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTypeStatement4033); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_createTypeStatement4051);
			tn=userTypeName();
			state._fsp--;

			 expr = new CreateTypeStatement(tn, ifNotExists); 
			match(input,171,FOLLOW_171_in_createTypeStatement4064); 
			pushFollow(FOLLOW_typeColumns_in_createTypeStatement4066);
			typeColumns(expr);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:32: ( ',' ( typeColumns[expr] )? )*
			loop82:
			while (true) {
				int alt82=2;
				int LA82_0 = input.LA(1);
				if ( (LA82_0==174) ) {
					alt82=1;
				}

				switch (alt82) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:34: ',' ( typeColumns[expr] )?
					{
					match(input,174,FOLLOW_174_in_createTypeStatement4071); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:38: ( typeColumns[expr] )?
					int alt81=2;
					int LA81_0 = input.LA(1);
					if ( (LA81_0==IDENT||(LA81_0 >= K_AGGREGATE && LA81_0 <= K_ALL)||LA81_0==K_AS||LA81_0==K_ASCII||(LA81_0 >= K_BIGINT && LA81_0 <= K_BOOLEAN)||(LA81_0 >= K_CALLED && LA81_0 <= K_CLUSTERING)||(LA81_0 >= K_COMPACT && LA81_0 <= K_COUNTER)||(LA81_0 >= K_CUSTOM && LA81_0 <= K_DECIMAL)||(LA81_0 >= K_DISTINCT && LA81_0 <= K_DOUBLE)||(LA81_0 >= K_EXISTS && LA81_0 <= K_FLOAT)||LA81_0==K_FROZEN||(LA81_0 >= K_FUNCTION && LA81_0 <= K_FUNCTIONS)||LA81_0==K_INET||(LA81_0 >= K_INITCOND && LA81_0 <= K_INPUT)||LA81_0==K_INT||(LA81_0 >= K_JSON && LA81_0 <= K_KEYS)||(LA81_0 >= K_KEYSPACES && LA81_0 <= K_LANGUAGE)||(LA81_0 >= K_LIST && LA81_0 <= K_MAP)||LA81_0==K_NOLOGIN||LA81_0==K_NOSUPERUSER||LA81_0==K_OPTIONS||(LA81_0 >= K_PASSWORD && LA81_0 <= K_PERMISSIONS)||LA81_0==K_RETURNS||(LA81_0 >= K_ROLE && LA81_0 <= K_ROLES)||(LA81_0 >= K_SFUNC && LA81_0 <= K_TINYINT)||LA81_0==K_TRIGGER||(LA81_0 >= K_TTL && LA81_0 <= K_TYPE)||(LA81_0 >= K_USER && LA81_0 <= K_USERS)||(LA81_0 >= K_UUID && LA81_0 <= K_VARINT)||LA81_0==K_WRITETIME||LA81_0==QUOTED_NAME) ) {
						alt81=1;
					}
					switch (alt81) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:703:38: typeColumns[expr]
							{
							pushFollow(FOLLOW_typeColumns_in_createTypeStatement4073);
							typeColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop82;
				}
			}

			match(input,172,FOLLOW_172_in_createTypeStatement4080); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTypeStatement"



	// $ANTLR start "typeColumns"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:1: typeColumns[CreateTypeStatement expr] : k= noncol_ident v= comparatorType ;
	public final void typeColumns(CreateTypeStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:707:5: (k= noncol_ident v= comparatorType )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:707:7: k= noncol_ident v= comparatorType
			{
			pushFollow(FOLLOW_noncol_ident_in_typeColumns4100);
			k=noncol_ident();
			state._fsp--;

			pushFollow(FOLLOW_comparatorType_in_typeColumns4104);
			v=comparatorType();
			state._fsp--;

			 expr.addDefinition(k, v); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "typeColumns"



	// $ANTLR start "createIndexStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:715:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? ;
	public final CreateIndexStatement createIndexStatement() throws RecognitionException {
		CreateIndexStatement expr = null;


		Token cls=null;
		CFName cf =null;
		IndexTarget.Raw id =null;


		        IndexPropDefs props = new IndexPropDefs();
		        boolean ifNotExists = false;
		        IndexName name = new IndexName();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement4139); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:16: ( K_CUSTOM )?
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==K_CUSTOM) ) {
				alt83=1;
			}
			switch (alt83) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:17: K_CUSTOM
					{
					match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement4142); 
					 props.isCustom = true; 
					}
					break;

			}

			match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement4148); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:63: ( K_IF K_NOT K_EXISTS )?
			int alt84=2;
			int LA84_0 = input.LA(1);
			if ( (LA84_0==K_IF) ) {
				alt84=1;
			}
			switch (alt84) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:64: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement4151); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement4153); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement4155); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:722:9: ( idxName[name] )?
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==IDENT||(LA85_0 >= K_AGGREGATE && LA85_0 <= K_ALL)||LA85_0==K_AS||LA85_0==K_ASCII||(LA85_0 >= K_BIGINT && LA85_0 <= K_BOOLEAN)||(LA85_0 >= K_CALLED && LA85_0 <= K_CLUSTERING)||(LA85_0 >= K_COMPACT && LA85_0 <= K_COUNTER)||(LA85_0 >= K_CUSTOM && LA85_0 <= K_DECIMAL)||(LA85_0 >= K_DISTINCT && LA85_0 <= K_DOUBLE)||(LA85_0 >= K_EXISTS && LA85_0 <= K_FLOAT)||LA85_0==K_FROZEN||(LA85_0 >= K_FUNCTION && LA85_0 <= K_FUNCTIONS)||LA85_0==K_INET||(LA85_0 >= K_INITCOND && LA85_0 <= K_INPUT)||LA85_0==K_INT||(LA85_0 >= K_JSON && LA85_0 <= K_KEYS)||(LA85_0 >= K_KEYSPACES && LA85_0 <= K_LANGUAGE)||(LA85_0 >= K_LIST && LA85_0 <= K_MAP)||LA85_0==K_NOLOGIN||LA85_0==K_NOSUPERUSER||LA85_0==K_OPTIONS||(LA85_0 >= K_PASSWORD && LA85_0 <= K_PERMISSIONS)||LA85_0==K_RETURNS||(LA85_0 >= K_ROLE && LA85_0 <= K_ROLES)||(LA85_0 >= K_SFUNC && LA85_0 <= K_TINYINT)||LA85_0==K_TRIGGER||(LA85_0 >= K_TTL && LA85_0 <= K_TYPE)||(LA85_0 >= K_USER && LA85_0 <= K_USERS)||(LA85_0 >= K_UUID && LA85_0 <= K_VARINT)||LA85_0==K_WRITETIME||(LA85_0 >= QMARK && LA85_0 <= QUOTED_NAME)) ) {
				alt85=1;
			}
			switch (alt85) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:722:10: idxName[name]
					{
					pushFollow(FOLLOW_idxName_in_createIndexStatement4171);
					idxName(name);
					state._fsp--;

					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement4176); 
			pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement4180);
			cf=columnFamilyName();
			state._fsp--;

			match(input,171,FOLLOW_171_in_createIndexStatement4182); 
			pushFollow(FOLLOW_indexIdent_in_createIndexStatement4186);
			id=indexIdent();
			state._fsp--;

			match(input,172,FOLLOW_172_in_createIndexStatement4188); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:723:9: ( K_USING cls= STRING_LITERAL )?
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==K_USING) ) {
				alt86=1;
			}
			switch (alt86) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:723:10: K_USING cls= STRING_LITERAL
					{
					match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement4199); 
					cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement4203); 
					 props.customClass = (cls!=null?cls.getText():null); 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:724:9: ( K_WITH properties[props] )?
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==K_WITH) ) {
				alt87=1;
			}
			switch (alt87) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:724:10: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement4218); 
					pushFollow(FOLLOW_properties_in_createIndexStatement4220);
					properties(props);
					state._fsp--;

					}
					break;

			}

			 expr = new CreateIndexStatement(cf, name, id, props, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createIndexStatement"



	// $ANTLR start "indexIdent"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:728:1: indexIdent returns [IndexTarget.Raw id] : (c= cident | K_KEYS '(' c= cident ')' | K_ENTRIES '(' c= cident ')' | K_FULL '(' c= cident ')' );
	public final IndexTarget.Raw indexIdent() throws RecognitionException {
		IndexTarget.Raw id = null;


		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:729:5: (c= cident | K_KEYS '(' c= cident ')' | K_ENTRIES '(' c= cident ')' | K_FULL '(' c= cident ')' )
			int alt88=4;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt88=1;
				}
				break;
			case K_KEYS:
				{
				int LA88_2 = input.LA(2);
				if ( (LA88_2==171) ) {
					alt88=2;
				}
				else if ( (LA88_2==172) ) {
					alt88=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 88, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ENTRIES:
				{
				alt88=3;
				}
				break;
			case K_FULL:
				{
				alt88=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 88, 0, input);
				throw nvae;
			}
			switch (alt88) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:729:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_indexIdent4254);
					c=cident();
					state._fsp--;

					 id = IndexTarget.Raw.valuesOf(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:730:7: K_KEYS '(' c= cident ')'
					{
					match(input,K_KEYS,FOLLOW_K_KEYS_in_indexIdent4282); 
					match(input,171,FOLLOW_171_in_indexIdent4284); 
					pushFollow(FOLLOW_cident_in_indexIdent4288);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_indexIdent4290); 
					 id = IndexTarget.Raw.keysOf(c); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:731:7: K_ENTRIES '(' c= cident ')'
					{
					match(input,K_ENTRIES,FOLLOW_K_ENTRIES_in_indexIdent4303); 
					match(input,171,FOLLOW_171_in_indexIdent4305); 
					pushFollow(FOLLOW_cident_in_indexIdent4309);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_indexIdent4311); 
					 id = IndexTarget.Raw.keysAndValuesOf(c); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:7: K_FULL '(' c= cident ')'
					{
					match(input,K_FULL,FOLLOW_K_FULL_in_indexIdent4321); 
					match(input,171,FOLLOW_171_in_indexIdent4323); 
					pushFollow(FOLLOW_cident_in_indexIdent4327);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_indexIdent4329); 
					 id = IndexTarget.Raw.fullCollection(c); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "indexIdent"



	// $ANTLR start "createMaterializedViewStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:743:1: createMaterializedViewStatement returns [CreateMaterializedViewStatement expr] : K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectClause K_FROM basecf= columnFamilyName ( K_WHERE wclause= mvWhereClause )? K_PRIMARY K_KEY ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' ) ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? ;
	public final CreateMaterializedViewStatement createMaterializedViewStatement() throws RecognitionException {
		CreateMaterializedViewStatement expr = null;


		CFName cf =null;
		List<RawSelector> sclause =null;
		CFName basecf =null;
		List<ColumnIdentifier.Raw> wclause =null;
		ColumnIdentifier.Raw k1 =null;
		ColumnIdentifier.Raw kn =null;
		ColumnIdentifier.Raw c1 =null;
		ColumnIdentifier.Raw cn =null;


		        boolean ifNotExists = false;
		        List<ColumnIdentifier.Raw> partitionKeys = new ArrayList<>();
		        List<ColumnIdentifier.Raw> compositeKeys = new ArrayList<>();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:5: ( K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectClause K_FROM basecf= columnFamilyName ( K_WHERE wclause= mvWhereClause )? K_PRIMARY K_KEY ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' ) ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:7: K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectClause K_FROM basecf= columnFamilyName ( K_WHERE wclause= mvWhereClause )? K_PRIMARY K_KEY ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' ) ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createMaterializedViewStatement4366); 
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_createMaterializedViewStatement4368); 
			match(input,K_VIEW,FOLLOW_K_VIEW_in_createMaterializedViewStatement4370); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:38: ( K_IF K_NOT K_EXISTS )?
			int alt89=2;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==K_IF) ) {
				alt89=1;
			}
			switch (alt89) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:749:39: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createMaterializedViewStatement4373); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createMaterializedViewStatement4375); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createMaterializedViewStatement4377); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createMaterializedViewStatement4385);
			cf=columnFamilyName();
			state._fsp--;

			match(input,K_AS,FOLLOW_K_AS_in_createMaterializedViewStatement4387); 
			match(input,K_SELECT,FOLLOW_K_SELECT_in_createMaterializedViewStatement4397); 
			pushFollow(FOLLOW_selectClause_in_createMaterializedViewStatement4401);
			sclause=selectClause();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_createMaterializedViewStatement4403); 
			pushFollow(FOLLOW_columnFamilyName_in_createMaterializedViewStatement4407);
			basecf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:9: ( K_WHERE wclause= mvWhereClause )?
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==K_WHERE) ) {
				alt90=1;
			}
			switch (alt90) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:10: K_WHERE wclause= mvWhereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_createMaterializedViewStatement4418); 
					pushFollow(FOLLOW_mvWhereClause_in_createMaterializedViewStatement4422);
					wclause=mvWhereClause();
					state._fsp--;

					}
					break;

			}

			match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_createMaterializedViewStatement4434); 
			match(input,K_KEY,FOLLOW_K_KEY_in_createMaterializedViewStatement4436); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:752:25: ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' )
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==171) ) {
				int LA94_1 = input.LA(2);
				if ( (LA94_1==171) ) {
					alt94=1;
				}
				else if ( (LA94_1==IDENT||(LA94_1 >= K_AGGREGATE && LA94_1 <= K_ALL)||LA94_1==K_AS||LA94_1==K_ASCII||(LA94_1 >= K_BIGINT && LA94_1 <= K_BOOLEAN)||(LA94_1 >= K_CALLED && LA94_1 <= K_CLUSTERING)||(LA94_1 >= K_COMPACT && LA94_1 <= K_COUNTER)||(LA94_1 >= K_CUSTOM && LA94_1 <= K_DECIMAL)||(LA94_1 >= K_DISTINCT && LA94_1 <= K_DOUBLE)||(LA94_1 >= K_EXISTS && LA94_1 <= K_FLOAT)||LA94_1==K_FROZEN||(LA94_1 >= K_FUNCTION && LA94_1 <= K_FUNCTIONS)||LA94_1==K_INET||(LA94_1 >= K_INITCOND && LA94_1 <= K_INPUT)||LA94_1==K_INT||(LA94_1 >= K_JSON && LA94_1 <= K_KEYS)||(LA94_1 >= K_KEYSPACES && LA94_1 <= K_LANGUAGE)||(LA94_1 >= K_LIST && LA94_1 <= K_MAP)||LA94_1==K_NOLOGIN||LA94_1==K_NOSUPERUSER||LA94_1==K_OPTIONS||(LA94_1 >= K_PASSWORD && LA94_1 <= K_PERMISSIONS)||LA94_1==K_RETURNS||(LA94_1 >= K_ROLE && LA94_1 <= K_ROLES)||(LA94_1 >= K_SFUNC && LA94_1 <= K_TINYINT)||LA94_1==K_TRIGGER||(LA94_1 >= K_TTL && LA94_1 <= K_TYPE)||(LA94_1 >= K_USER && LA94_1 <= K_USERS)||(LA94_1 >= K_UUID && LA94_1 <= K_VARINT)||LA94_1==K_WRITETIME||LA94_1==QUOTED_NAME) ) {
					alt94=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 94, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}

			switch (alt94) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:9: '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')'
					{
					match(input,171,FOLLOW_171_in_createMaterializedViewStatement4448); 
					match(input,171,FOLLOW_171_in_createMaterializedViewStatement4450); 
					pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4454);
					k1=cident();
					state._fsp--;

					 partitionKeys.add(k1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:54: ( ',' kn= cident )*
					loop91:
					while (true) {
						int alt91=2;
						int LA91_0 = input.LA(1);
						if ( (LA91_0==174) ) {
							alt91=1;
						}

						switch (alt91) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:56: ',' kn= cident
							{
							match(input,174,FOLLOW_174_in_createMaterializedViewStatement4460); 
							pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4464);
							kn=cident();
							state._fsp--;

							 partitionKeys.add(kn); 
							}
							break;

						default :
							break loop91;
						}
					}

					match(input,172,FOLLOW_172_in_createMaterializedViewStatement4471); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:104: ( ',' c1= cident )*
					loop92:
					while (true) {
						int alt92=2;
						int LA92_0 = input.LA(1);
						if ( (LA92_0==174) ) {
							alt92=1;
						}

						switch (alt92) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:106: ',' c1= cident
							{
							match(input,174,FOLLOW_174_in_createMaterializedViewStatement4475); 
							pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4479);
							c1=cident();
							state._fsp--;

							 compositeKeys.add(c1); 
							}
							break;

						default :
							break loop92;
						}
					}

					match(input,172,FOLLOW_172_in_createMaterializedViewStatement4486); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:9: '(' k1= cident ( ',' cn= cident )* ')'
					{
					match(input,171,FOLLOW_171_in_createMaterializedViewStatement4496); 
					pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4500);
					k1=cident();
					state._fsp--;

					 partitionKeys.add(k1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:50: ( ',' cn= cident )*
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==174) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:52: ',' cn= cident
							{
							match(input,174,FOLLOW_174_in_createMaterializedViewStatement4506); 
							pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4510);
							cn=cident();
							state._fsp--;

							 compositeKeys.add(cn); 
							}
							break;

						default :
							break loop93;
						}
					}

					match(input,172,FOLLOW_172_in_createMaterializedViewStatement4517); 
					}
					break;

			}

			 expr = new CreateMaterializedViewStatement(cf, basecf, sclause, wclause, partitionKeys, compositeKeys, ifNotExists); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:9: ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==K_WITH) ) {
				alt96=1;
			}
			switch (alt96) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:11: K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createMaterializedViewStatement4549); 
					pushFollow(FOLLOW_cfamProperty_in_createMaterializedViewStatement4551);
					cfamProperty(expr.properties);
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:48: ( K_AND cfamProperty[expr.properties] )*
					loop95:
					while (true) {
						int alt95=2;
						int LA95_0 = input.LA(1);
						if ( (LA95_0==K_AND) ) {
							alt95=1;
						}

						switch (alt95) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:50: K_AND cfamProperty[expr.properties]
							{
							match(input,K_AND,FOLLOW_K_AND_in_createMaterializedViewStatement4556); 
							pushFollow(FOLLOW_cfamProperty_in_createMaterializedViewStatement4558);
							cfamProperty(expr.properties);
							state._fsp--;

							}
							break;

						default :
							break loop95;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createMaterializedViewStatement"



	// $ANTLR start "mvWhereClause"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:760:1: mvWhereClause returns [List<ColumnIdentifier.Raw> expr] : t1= cident K_IS K_NOT K_NULL ( K_AND tN= cident K_IS K_NOT K_NULL )* ;
	public final List<ColumnIdentifier.Raw> mvWhereClause() throws RecognitionException {
		List<ColumnIdentifier.Raw> expr = null;


		ColumnIdentifier.Raw t1 =null;
		ColumnIdentifier.Raw tN =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:761:5: (t1= cident K_IS K_NOT K_NULL ( K_AND tN= cident K_IS K_NOT K_NULL )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:761:7: t1= cident K_IS K_NOT K_NULL ( K_AND tN= cident K_IS K_NOT K_NULL )*
			{
			pushFollow(FOLLOW_cident_in_mvWhereClause4587);
			t1=cident();
			state._fsp--;

			 expr = new ArrayList<ColumnIdentifier.Raw>(); expr.add(t1); 
			match(input,K_IS,FOLLOW_K_IS_in_mvWhereClause4591); 
			match(input,K_NOT,FOLLOW_K_NOT_in_mvWhereClause4593); 
			match(input,K_NULL,FOLLOW_K_NULL_in_mvWhereClause4595); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:761:101: ( K_AND tN= cident K_IS K_NOT K_NULL )*
			loop97:
			while (true) {
				int alt97=2;
				int LA97_0 = input.LA(1);
				if ( (LA97_0==K_AND) ) {
					alt97=1;
				}

				switch (alt97) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:761:102: K_AND tN= cident K_IS K_NOT K_NULL
					{
					match(input,K_AND,FOLLOW_K_AND_in_mvWhereClause4598); 
					pushFollow(FOLLOW_cident_in_mvWhereClause4602);
					tN=cident();
					state._fsp--;

					 expr.add(tN); 
					match(input,K_IS,FOLLOW_K_IS_in_mvWhereClause4606); 
					match(input,K_NOT,FOLLOW_K_NOT_in_mvWhereClause4608); 
					match(input,K_NULL,FOLLOW_K_NULL_in_mvWhereClause4610); 
					}
					break;

				default :
					break loop97;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "mvWhereClause"



	// $ANTLR start "createTriggerStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:767:1: createTriggerStatement returns [CreateTriggerStatement expr] : K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL ;
	public final CreateTriggerStatement createTriggerStatement() throws RecognitionException {
		CreateTriggerStatement expr = null;


		Token cls=null;
		ColumnIdentifier.Raw name =null;
		CFName cf =null;


		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:5: ( K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:7: K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement4644); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement4646); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:26: ( K_IF K_NOT K_EXISTS )?
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==K_IF) ) {
				alt98=1;
			}
			switch (alt98) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:27: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTriggerStatement4649); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTriggerStatement4651); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTriggerStatement4653); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:74: (name= cident )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:771:75: name= cident
			{
			pushFollow(FOLLOW_cident_in_createTriggerStatement4663);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement4674); 
			pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement4678);
			cf=columnFamilyName();
			state._fsp--;

			match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement4680); 
			cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement4684); 
			 expr = new CreateTriggerStatement(cf, name.toString(), (cls!=null?cls.getText():null), ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTriggerStatement"



	// $ANTLR start "dropTriggerStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:779:1: dropTriggerStatement returns [DropTriggerStatement expr] : K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName ;
	public final DropTriggerStatement dropTriggerStatement() throws RecognitionException {
		DropTriggerStatement expr = null;


		ColumnIdentifier.Raw name =null;
		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:5: ( K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:7: K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement4725); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement4727); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:24: ( K_IF K_EXISTS )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==K_IF) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:25: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTriggerStatement4730); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTriggerStatement4732); 
					 ifExists = true; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:63: (name= cident )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:64: name= cident
			{
			pushFollow(FOLLOW_cident_in_dropTriggerStatement4742);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement4745); 
			pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement4749);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new DropTriggerStatement(cf, name.toString(), ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropTriggerStatement"



	// $ANTLR start "alterKeyspaceStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:788:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
	public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
		AlterKeyspaceStatement expr = null;


		String ks =null;

		 KeyspaceAttributes attrs = new KeyspaceAttributes(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:790:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:790:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement4789); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement4791); 
			pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement4795);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement4805); 
			pushFollow(FOLLOW_properties_in_alterKeyspaceStatement4807);
			properties(attrs);
			state._fsp--;

			 expr = new AlterKeyspaceStatement(ks, attrs); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterKeyspaceStatement"



	// $ANTLR start "alterTableStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:802:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[attrs] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
	public final AlterTableStatement alterTableStatement() throws RecognitionException {
		AlterTableStatement expr = null;


		CFName cf =null;
		ColumnIdentifier.Raw id =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier.Raw id1 =null;
		ColumnIdentifier.Raw toId1 =null;
		ColumnIdentifier.Raw idn =null;
		ColumnIdentifier.Raw toIdn =null;


		        AlterTableStatement.Type type = null;
		        TableAttributes attrs = new TableAttributes();
		        Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames = new HashMap<ColumnIdentifier.Raw, ColumnIdentifier.Raw>();
		        boolean isStatic = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:809:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[attrs] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:809:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[attrs] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement4843); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement4845); 
			pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement4849);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:810:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[attrs] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			int alt102=5;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt102=1;
				}
				break;
			case K_ADD:
				{
				alt102=2;
				}
				break;
			case K_DROP:
				{
				alt102=3;
				}
				break;
			case K_WITH:
				{
				alt102=4;
				}
				break;
			case K_RENAME:
				{
				alt102=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 102, 0, input);
				throw nvae;
			}
			switch (alt102) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:810:13: K_ALTER id= cident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement4863); 
					pushFollow(FOLLOW_cident_in_alterTableStatement4867);
					id=cident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement4869); 
					pushFollow(FOLLOW_comparatorType_in_alterTableStatement4873);
					v=comparatorType();
					state._fsp--;

					 type = AlterTableStatement.Type.ALTER; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:13: K_ADD id= cident v= comparatorType ( K_STATIC )?
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement4889); 
					pushFollow(FOLLOW_cident_in_alterTableStatement4895);
					id=cident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTableStatement4899);
					v=comparatorType();
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:48: ( K_STATIC )?
					int alt100=2;
					int LA100_0 = input.LA(1);
					if ( (LA100_0==K_STATIC) ) {
						alt100=1;
					}
					switch (alt100) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:49: K_STATIC
							{
							 isStatic=true; 
							match(input,K_STATIC,FOLLOW_K_STATIC_in_alterTableStatement4904); 
							}
							break;

					}

					 type = AlterTableStatement.Type.ADD; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:812:13: K_DROP id= cident
					{
					match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement4922); 
					pushFollow(FOLLOW_cident_in_alterTableStatement4927);
					id=cident();
					state._fsp--;

					 type = AlterTableStatement.Type.DROP; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:813:13: K_WITH properties[attrs]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement4967); 
					pushFollow(FOLLOW_properties_in_alterTableStatement4970);
					properties(attrs);
					state._fsp--;

					 type = AlterTableStatement.Type.OPTS; 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:814:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement5003); 
					 type = AlterTableStatement.Type.RENAME; 
					pushFollow(FOLLOW_cident_in_alterTableStatement5057);
					id1=cident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement5059); 
					pushFollow(FOLLOW_cident_in_alterTableStatement5063);
					toId1=cident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:816:16: ( K_AND idn= cident K_TO toIdn= cident )*
					loop101:
					while (true) {
						int alt101=2;
						int LA101_0 = input.LA(1);
						if ( (LA101_0==K_AND) ) {
							alt101=1;
						}

						switch (alt101) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:816:18: K_AND idn= cident K_TO toIdn= cident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement5084); 
							pushFollow(FOLLOW_cident_in_alterTableStatement5088);
							idn=cident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement5090); 
							pushFollow(FOLLOW_cident_in_alterTableStatement5094);
							toIdn=cident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop101;
						}
					}

					}
					break;

			}


			        expr = new AlterTableStatement(cf, type, id, v, attrs, renames, isStatic);
			    
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTableStatement"



	// $ANTLR start "alterMaterializedViewStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:823:1: alterMaterializedViewStatement returns [AlterMaterializedViewStatement expr] : K_ALTER K_MATERIALIZED K_VIEW name= columnFamilyName K_WITH properties[attrs] ;
	public final AlterMaterializedViewStatement alterMaterializedViewStatement() throws RecognitionException {
		AlterMaterializedViewStatement expr = null;


		CFName name =null;


		        TableAttributes attrs = new TableAttributes();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:827:5: ( K_ALTER K_MATERIALIZED K_VIEW name= columnFamilyName K_WITH properties[attrs] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:827:7: K_ALTER K_MATERIALIZED K_VIEW name= columnFamilyName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterMaterializedViewStatement5147); 
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_alterMaterializedViewStatement5149); 
			match(input,K_VIEW,FOLLOW_K_VIEW_in_alterMaterializedViewStatement5151); 
			pushFollow(FOLLOW_columnFamilyName_in_alterMaterializedViewStatement5155);
			name=columnFamilyName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_alterMaterializedViewStatement5167); 
			pushFollow(FOLLOW_properties_in_alterMaterializedViewStatement5169);
			properties(attrs);
			state._fsp--;


			        expr = new AlterMaterializedViewStatement(name, attrs);
			    
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterMaterializedViewStatement"



	// $ANTLR start "alterTypeStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:840:1: alterTypeStatement returns [AlterTypeStatement expr] : K_ALTER K_TYPE name= userTypeName ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* ) ;
	public final AlterTypeStatement alterTypeStatement() throws RecognitionException {
		AlterTypeStatement expr = null;


		UTName name =null;
		ColumnIdentifier f =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier id1 =null;
		ColumnIdentifier toId1 =null;
		ColumnIdentifier idn =null;
		ColumnIdentifier toIdn =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:841:5: ( K_ALTER K_TYPE name= userTypeName ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:841:7: K_ALTER K_TYPE name= userTypeName ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement5204); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement5206); 
			pushFollow(FOLLOW_userTypeName_in_alterTypeStatement5210);
			name=userTypeName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:842:11: ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* )
			int alt104=3;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt104=1;
				}
				break;
			case K_ADD:
				{
				alt104=2;
				}
				break;
			case K_RENAME:
				{
				alt104=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}
			switch (alt104) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:842:13: K_ALTER f= noncol_ident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement5224); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5228);
					f=noncol_ident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement5230); 
					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement5234);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.alter(name, f, v); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:843:13: K_ADD f= noncol_ident v= comparatorType
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTypeStatement5250); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5256);
					f=noncol_ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement5260);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.addition(name, f, v); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:844:13: K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTypeStatement5283); 
					 Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>(); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5321);
					id1=noncol_ident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement5323); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5327);
					toId1=noncol_ident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:18: ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )*
					loop103:
					while (true) {
						int alt103=2;
						int LA103_0 = input.LA(1);
						if ( (LA103_0==K_AND) ) {
							alt103=1;
						}

						switch (alt103) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:20: K_AND idn= noncol_ident K_TO toIdn= noncol_ident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTypeStatement5350); 
							pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5354);
							idn=noncol_ident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement5356); 
							pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5360);
							toIdn=noncol_ident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop103;
						}
					}

					 expr = AlterTypeStatement.renames(name, renames); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTypeStatement"



	// $ANTLR start "dropKeyspaceStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:856:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
	public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
		DropKeyspaceStatement ksp = null;


		String ks =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement5427); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement5429); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:25: ( K_IF K_EXISTS )?
			int alt105=2;
			int LA105_0 = input.LA(1);
			if ( (LA105_0==K_IF) ) {
				alt105=1;
			}
			switch (alt105) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:26: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement5432); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement5434); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement5443);
			ks=keyspaceName();
			state._fsp--;

			 ksp = new DropKeyspaceStatement(ks, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ksp;
	}
	// $ANTLR end "dropKeyspaceStatement"



	// $ANTLR start "dropTableStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:1: dropTableStatement returns [DropTableStatement stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropTableStatement dropTableStatement() throws RecognitionException {
		DropTableStatement stmt = null;


		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:866:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:866:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement5477); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement5479); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:866:29: ( K_IF K_EXISTS )?
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==K_IF) ) {
				alt106=1;
			}
			switch (alt106) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:866:30: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement5482); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement5484); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement5493);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new DropTableStatement(cf, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTableStatement"



	// $ANTLR start "dropTypeStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:872:1: dropTypeStatement returns [DropTypeStatement stmt] : K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName ;
	public final DropTypeStatement dropTypeStatement() throws RecognitionException {
		DropTypeStatement stmt = null;


		UTName name =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:5: ( K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:7: K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTypeStatement5527); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_dropTypeStatement5529); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:21: ( K_IF K_EXISTS )?
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==K_IF) ) {
				alt107=1;
			}
			switch (alt107) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTypeStatement5532); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTypeStatement5534); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_dropTypeStatement5543);
			name=userTypeName();
			state._fsp--;

			 stmt = new DropTypeStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTypeStatement"



	// $ANTLR start "dropIndexStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:880:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName ;
	public final DropIndexStatement dropIndexStatement() throws RecognitionException {
		DropIndexStatement expr = null;


		IndexName index =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:882:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:882:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement5577); 
			match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement5579); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:882:22: ( K_IF K_EXISTS )?
			int alt108=2;
			int LA108_0 = input.LA(1);
			if ( (LA108_0==K_IF) ) {
				alt108=1;
			}
			switch (alt108) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:882:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement5582); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement5584); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_indexName_in_dropIndexStatement5593);
			index=indexName();
			state._fsp--;

			 expr = new DropIndexStatement(index, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropIndexStatement"



	// $ANTLR start "dropMaterializedViewStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:1: dropMaterializedViewStatement returns [DropMaterializedViewStatement expr] : K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropMaterializedViewStatement dropMaterializedViewStatement() throws RecognitionException {
		DropMaterializedViewStatement expr = null;


		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:5: ( K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:7: K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropMaterializedViewStatement5633); 
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_dropMaterializedViewStatement5635); 
			match(input,K_VIEW,FOLLOW_K_VIEW_in_dropMaterializedViewStatement5637); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:36: ( K_IF K_EXISTS )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==K_IF) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:37: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropMaterializedViewStatement5640); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropMaterializedViewStatement5642); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropMaterializedViewStatement5651);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new DropMaterializedViewStatement(cf, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropMaterializedViewStatement"



	// $ANTLR start "truncateStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:898:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
	public final TruncateStatement truncateStatement() throws RecognitionException {
		TruncateStatement stmt = null;


		CFName cf =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:899:5: ( K_TRUNCATE cf= columnFamilyName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:899:7: K_TRUNCATE cf= columnFamilyName
			{
			match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement5682); 
			pushFollow(FOLLOW_columnFamilyName_in_truncateStatement5686);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new TruncateStatement(cf); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "truncateStatement"



	// $ANTLR start "grantPermissionsStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:905:1: grantPermissionsStatement returns [GrantPermissionsStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName ;
	public final GrantPermissionsStatement grantPermissionsStatement() throws RecognitionException {
		GrantPermissionsStatement stmt = null;


		RoleName grantee =null;
		Set<Permission> permissionOrAll1 =null;
		IResource resource2 =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:906:5: ( K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:906:7: K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantPermissionsStatement5711); 
			pushFollow(FOLLOW_permissionOrAll_in_grantPermissionsStatement5723);
			permissionOrAll1=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_grantPermissionsStatement5731); 
			pushFollow(FOLLOW_resource_in_grantPermissionsStatement5743);
			resource2=resource();
			state._fsp--;

			match(input,K_TO,FOLLOW_K_TO_in_grantPermissionsStatement5751); 
			pushFollow(FOLLOW_userOrRoleName_in_grantPermissionsStatement5765);
			grantee=userOrRoleName();
			state._fsp--;

			 stmt = new GrantPermissionsStatement(filterPermissions(permissionOrAll1, resource2), resource2, grantee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantPermissionsStatement"



	// $ANTLR start "revokePermissionsStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:918:1: revokePermissionsStatement returns [RevokePermissionsStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName ;
	public final RevokePermissionsStatement revokePermissionsStatement() throws RecognitionException {
		RevokePermissionsStatement stmt = null;


		RoleName revokee =null;
		Set<Permission> permissionOrAll3 =null;
		IResource resource4 =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:919:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:919:7: K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokePermissionsStatement5796); 
			pushFollow(FOLLOW_permissionOrAll_in_revokePermissionsStatement5808);
			permissionOrAll3=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_revokePermissionsStatement5816); 
			pushFollow(FOLLOW_resource_in_revokePermissionsStatement5828);
			resource4=resource();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_revokePermissionsStatement5836); 
			pushFollow(FOLLOW_userOrRoleName_in_revokePermissionsStatement5850);
			revokee=userOrRoleName();
			state._fsp--;

			 stmt = new RevokePermissionsStatement(filterPermissions(permissionOrAll3, resource4), resource4, revokee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokePermissionsStatement"



	// $ANTLR start "grantRoleStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:931:1: grantRoleStatement returns [GrantRoleStatement stmt] : K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName ;
	public final GrantRoleStatement grantRoleStatement() throws RecognitionException {
		GrantRoleStatement stmt = null;


		RoleName role =null;
		RoleName grantee =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:932:5: ( K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:932:7: K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantRoleStatement5881); 
			pushFollow(FOLLOW_userOrRoleName_in_grantRoleStatement5895);
			role=userOrRoleName();
			state._fsp--;

			match(input,K_TO,FOLLOW_K_TO_in_grantRoleStatement5903); 
			pushFollow(FOLLOW_userOrRoleName_in_grantRoleStatement5917);
			grantee=userOrRoleName();
			state._fsp--;

			 stmt = new GrantRoleStatement(role, grantee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantRoleStatement"



	// $ANTLR start "revokeRoleStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:942:1: revokeRoleStatement returns [RevokeRoleStatement stmt] : K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName ;
	public final RevokeRoleStatement revokeRoleStatement() throws RecognitionException {
		RevokeRoleStatement stmt = null;


		RoleName role =null;
		RoleName revokee =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:943:5: ( K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:943:7: K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeRoleStatement5948); 
			pushFollow(FOLLOW_userOrRoleName_in_revokeRoleStatement5962);
			role=userOrRoleName();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_revokeRoleStatement5970); 
			pushFollow(FOLLOW_userOrRoleName_in_revokeRoleStatement5984);
			revokee=userOrRoleName();
			state._fsp--;

			 stmt = new RevokeRoleStatement(role, revokee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokeRoleStatement"



	// $ANTLR start "listPermissionsStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:950:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? ;
	public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
		ListPermissionsStatement stmt = null;


		IResource resource5 =null;
		Set<Permission> permissionOrAll6 =null;


		        IResource resource = null;
		        boolean recursive = true;
		        RoleName grantee = new RoleName();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:956:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:956:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement6022); 
			pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement6034);
			permissionOrAll6=permissionOrAll();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:958:7: ( K_ON resource )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==K_ON) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:958:9: K_ON resource
					{
					match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement6044); 
					pushFollow(FOLLOW_resource_in_listPermissionsStatement6046);
					resource5=resource();
					state._fsp--;

					 resource = resource5; 
					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:959:7: ( K_OF roleName[grantee] )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==K_OF) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:959:9: K_OF roleName[grantee]
					{
					match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement6061); 
					pushFollow(FOLLOW_roleName_in_listPermissionsStatement6063);
					roleName(grantee);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:960:7: ( K_NORECURSIVE )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==K_NORECURSIVE) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:960:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement6077); 
					 recursive = false; 
					}
					break;

			}

			 stmt = new ListPermissionsStatement(permissionOrAll6, resource, grantee, recursive); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listPermissionsStatement"



	// $ANTLR start "permission"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:964:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE ) ;
	public final Permission permission() throws RecognitionException {
		Permission perm = null;


		Token p=null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:965:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:965:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE )
			{
			p=input.LT(1);
			if ( input.LA(1)==K_ALTER||input.LA(1)==K_AUTHORIZE||input.LA(1)==K_CREATE||input.LA(1)==K_DESCRIBE||input.LA(1)==K_DROP||input.LA(1)==K_EXECUTE||input.LA(1)==K_MODIFY||input.LA(1)==K_SELECT ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perm;
	}
	// $ANTLR end "permission"



	// $ANTLR start "permissionOrAll"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:969:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? );
	public final Set<Permission> permissionOrAll() throws RecognitionException {
		Set<Permission> perms = null;


		Permission p =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:5: ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? )
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==K_ALL) ) {
				alt115=1;
			}
			else if ( (LA115_0==K_ALTER||LA115_0==K_AUTHORIZE||LA115_0==K_CREATE||LA115_0==K_DESCRIBE||LA115_0==K_DROP||LA115_0==K_EXECUTE||LA115_0==K_MODIFY||LA115_0==K_SELECT) ) {
				alt115=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 115, 0, input);
				throw nvae;
			}

			switch (alt115) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:7: K_ALL ( K_PERMISSIONS )?
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll6170); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:13: ( K_PERMISSIONS )?
					int alt113=2;
					int LA113_0 = input.LA(1);
					if ( (LA113_0==K_PERMISSIONS) ) {
						alt113=1;
					}
					switch (alt113) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:15: K_PERMISSIONS
							{
							match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll6174); 
							}
							break;

					}

					 perms = Permission.ALL; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:971:7: p= permission ( K_PERMISSION )?
					{
					pushFollow(FOLLOW_permission_in_permissionOrAll6195);
					p=permission();
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:971:20: ( K_PERMISSION )?
					int alt114=2;
					int LA114_0 = input.LA(1);
					if ( (LA114_0==K_PERMISSION) ) {
						alt114=1;
					}
					switch (alt114) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:971:22: K_PERMISSION
							{
							match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll6199); 
							}
							break;

					}

					 perms = EnumSet.of(p); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perms;
	}
	// $ANTLR end "permissionOrAll"



	// $ANTLR start "resource"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:974:1: resource returns [IResource res] : (d= dataResource |r= roleResource |f= functionResource );
	public final IResource resource() throws RecognitionException {
		IResource res = null;


		DataResource d =null;
		RoleResource r =null;
		FunctionResource f =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:975:5: (d= dataResource |r= roleResource |f= functionResource )
			int alt116=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				switch ( input.LA(2) ) {
				case EOF:
				case K_FROM:
				case K_KEYSPACES:
				case K_NORECURSIVE:
				case K_OF:
				case K_TO:
				case 176:
				case 178:
					{
					alt116=1;
					}
					break;
				case K_ROLES:
					{
					alt116=2;
					}
					break;
				case K_FUNCTIONS:
					{
					alt116=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
			case K_AGGREGATE:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACE:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QMARK:
			case QUOTED_NAME:
				{
				alt116=1;
				}
				break;
			case K_ROLE:
				{
				int LA116_3 = input.LA(2);
				if ( (LA116_3==EOF||LA116_3==K_FROM||LA116_3==K_NORECURSIVE||LA116_3==K_OF||LA116_3==K_TO||LA116_3==176||LA116_3==178) ) {
					alt116=1;
				}
				else if ( (LA116_3==IDENT||(LA116_3 >= K_AGGREGATE && LA116_3 <= K_ALL)||LA116_3==K_AS||LA116_3==K_ASCII||(LA116_3 >= K_BIGINT && LA116_3 <= K_BOOLEAN)||(LA116_3 >= K_CALLED && LA116_3 <= K_CLUSTERING)||(LA116_3 >= K_COMPACT && LA116_3 <= K_COUNTER)||(LA116_3 >= K_CUSTOM && LA116_3 <= K_DECIMAL)||(LA116_3 >= K_DISTINCT && LA116_3 <= K_DOUBLE)||(LA116_3 >= K_EXISTS && LA116_3 <= K_FLOAT)||LA116_3==K_FROZEN||(LA116_3 >= K_FUNCTION && LA116_3 <= K_FUNCTIONS)||LA116_3==K_INET||(LA116_3 >= K_INITCOND && LA116_3 <= K_INPUT)||LA116_3==K_INT||(LA116_3 >= K_JSON && LA116_3 <= K_KEYS)||(LA116_3 >= K_KEYSPACES && LA116_3 <= K_LANGUAGE)||(LA116_3 >= K_LIST && LA116_3 <= K_MAP)||LA116_3==K_NOLOGIN||LA116_3==K_NOSUPERUSER||LA116_3==K_OPTIONS||(LA116_3 >= K_PASSWORD && LA116_3 <= K_PERMISSIONS)||LA116_3==K_RETURNS||(LA116_3 >= K_ROLE && LA116_3 <= K_ROLES)||(LA116_3 >= K_SFUNC && LA116_3 <= K_TINYINT)||LA116_3==K_TRIGGER||(LA116_3 >= K_TTL && LA116_3 <= K_TYPE)||(LA116_3 >= K_USER && LA116_3 <= K_USERS)||(LA116_3 >= K_UUID && LA116_3 <= K_VARINT)||LA116_3==K_WRITETIME||(LA116_3 >= QMARK && LA116_3 <= QUOTED_NAME)||LA116_3==STRING_LITERAL) ) {
					alt116=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FUNCTION:
				{
				int LA116_4 = input.LA(2);
				if ( (LA116_4==EOF||LA116_4==K_FROM||LA116_4==K_NORECURSIVE||LA116_4==K_OF||LA116_4==K_TO||LA116_4==176||LA116_4==178) ) {
					alt116=1;
				}
				else if ( (LA116_4==IDENT||(LA116_4 >= K_AGGREGATE && LA116_4 <= K_ALL)||LA116_4==K_AS||LA116_4==K_ASCII||(LA116_4 >= K_BIGINT && LA116_4 <= K_BOOLEAN)||(LA116_4 >= K_CALLED && LA116_4 <= K_CLUSTERING)||(LA116_4 >= K_COMPACT && LA116_4 <= K_COUNTER)||(LA116_4 >= K_CUSTOM && LA116_4 <= K_DECIMAL)||(LA116_4 >= K_DISTINCT && LA116_4 <= K_DOUBLE)||(LA116_4 >= K_EXISTS && LA116_4 <= K_FLOAT)||LA116_4==K_FROZEN||(LA116_4 >= K_FUNCTION && LA116_4 <= K_FUNCTIONS)||LA116_4==K_INET||(LA116_4 >= K_INITCOND && LA116_4 <= K_INPUT)||LA116_4==K_INT||(LA116_4 >= K_JSON && LA116_4 <= K_KEYS)||(LA116_4 >= K_KEYSPACES && LA116_4 <= K_LANGUAGE)||(LA116_4 >= K_LIST && LA116_4 <= K_MAP)||LA116_4==K_NOLOGIN||LA116_4==K_NOSUPERUSER||LA116_4==K_OPTIONS||(LA116_4 >= K_PASSWORD && LA116_4 <= K_PERMISSIONS)||LA116_4==K_RETURNS||(LA116_4 >= K_ROLE && LA116_4 <= K_ROLES)||(LA116_4 >= K_SFUNC && LA116_4 <= K_TINYINT)||(LA116_4 >= K_TOKEN && LA116_4 <= K_TRIGGER)||(LA116_4 >= K_TTL && LA116_4 <= K_TYPE)||(LA116_4 >= K_USER && LA116_4 <= K_USERS)||(LA116_4 >= K_UUID && LA116_4 <= K_VARINT)||LA116_4==K_WRITETIME||(LA116_4 >= QMARK && LA116_4 <= QUOTED_NAME)) ) {
					alt116=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}
			switch (alt116) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:975:7: d= dataResource
					{
					pushFollow(FOLLOW_dataResource_in_resource6227);
					d=dataResource();
					state._fsp--;

					 res = d; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:976:7: r= roleResource
					{
					pushFollow(FOLLOW_roleResource_in_resource6239);
					r=roleResource();
					state._fsp--;

					 res = r; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:977:7: f= functionResource
					{
					pushFollow(FOLLOW_functionResource_in_resource6251);
					f=functionResource();
					state._fsp--;

					 res = f; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "resource"



	// $ANTLR start "dataResource"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:980:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
	public final DataResource dataResource() throws RecognitionException {
		DataResource res = null;


		String ks =null;
		CFName cf =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
			int alt118=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				int LA118_1 = input.LA(2);
				if ( (LA118_1==K_KEYSPACES) ) {
					alt118=1;
				}
				else if ( (LA118_1==EOF||LA118_1==K_FROM||LA118_1==K_NORECURSIVE||LA118_1==K_OF||LA118_1==K_TO||LA118_1==176||LA118_1==178) ) {
					alt118=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_KEYSPACE:
				{
				alt118=2;
				}
				break;
			case IDENT:
			case K_AGGREGATE:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QMARK:
			case QUOTED_NAME:
				{
				alt118=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:7: K_ALL K_KEYSPACES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_dataResource6274); 
					match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource6276); 
					 res = DataResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:982:7: K_KEYSPACE ks= keyspaceName
					{
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource6286); 
					pushFollow(FOLLOW_keyspaceName_in_dataResource6292);
					ks=keyspaceName();
					state._fsp--;

					 res = DataResource.keyspace(ks); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:983:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
					{
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:983:7: ( K_COLUMNFAMILY )?
					int alt117=2;
					int LA117_0 = input.LA(1);
					if ( (LA117_0==K_COLUMNFAMILY) ) {
						alt117=1;
					}
					switch (alt117) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:983:9: K_COLUMNFAMILY
							{
							match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource6304); 
							}
							break;

					}

					pushFollow(FOLLOW_columnFamilyName_in_dataResource6313);
					cf=columnFamilyName();
					state._fsp--;

					 res = DataResource.table(cf.getKeyspace(), cf.getColumnFamily()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "dataResource"



	// $ANTLR start "roleResource"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:987:1: roleResource returns [RoleResource res] : ( K_ALL K_ROLES | K_ROLE role= userOrRoleName );
	public final RoleResource roleResource() throws RecognitionException {
		RoleResource res = null;


		RoleName role =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:988:5: ( K_ALL K_ROLES | K_ROLE role= userOrRoleName )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==K_ALL) ) {
				alt119=1;
			}
			else if ( (LA119_0==K_ROLE) ) {
				alt119=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:988:7: K_ALL K_ROLES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_roleResource6342); 
					match(input,K_ROLES,FOLLOW_K_ROLES_in_roleResource6344); 
					 res = RoleResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:989:7: K_ROLE role= userOrRoleName
					{
					match(input,K_ROLE,FOLLOW_K_ROLE_in_roleResource6354); 
					pushFollow(FOLLOW_userOrRoleName_in_roleResource6360);
					role=userOrRoleName();
					state._fsp--;

					 res = RoleResource.role(role.getName()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "roleResource"



	// $ANTLR start "functionResource"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:992:1: functionResource returns [FunctionResource res] : ( K_ALL K_FUNCTIONS | K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName | K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' ) );
	public final FunctionResource functionResource() throws RecognitionException {
		FunctionResource res = null;


		String ks =null;
		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:996:5: ( K_ALL K_FUNCTIONS | K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName | K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' ) )
			int alt122=3;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==K_ALL) ) {
				int LA122_1 = input.LA(2);
				if ( (LA122_1==K_FUNCTIONS) ) {
					int LA122_3 = input.LA(3);
					if ( (LA122_3==K_IN) ) {
						alt122=2;
					}
					else if ( (LA122_3==EOF||LA122_3==K_FROM||LA122_3==K_NORECURSIVE||LA122_3==K_OF||LA122_3==K_TO||LA122_3==178) ) {
						alt122=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 122, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 122, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA122_0==K_FUNCTION) ) {
				alt122=3;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 122, 0, input);
				throw nvae;
			}

			switch (alt122) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:996:7: K_ALL K_FUNCTIONS
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_functionResource6392); 
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_functionResource6394); 
					 res = FunctionResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:997:7: K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_functionResource6404); 
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_functionResource6406); 
					match(input,K_IN,FOLLOW_K_IN_in_functionResource6408); 
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_functionResource6410); 
					pushFollow(FOLLOW_keyspaceName_in_functionResource6416);
					ks=keyspaceName();
					state._fsp--;

					 res = FunctionResource.keyspace(ks); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:999:7: K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )
					{
					match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_functionResource6431); 
					pushFollow(FOLLOW_functionName_in_functionResource6435);
					fn=functionName();
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1000:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1001:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,171,FOLLOW_171_in_functionResource6453); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1002:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt121=2;
					int LA121_0 = input.LA(1);
					if ( (LA121_0==IDENT||(LA121_0 >= K_AGGREGATE && LA121_0 <= K_ALL)||LA121_0==K_AS||LA121_0==K_ASCII||(LA121_0 >= K_BIGINT && LA121_0 <= K_BOOLEAN)||(LA121_0 >= K_CALLED && LA121_0 <= K_CLUSTERING)||(LA121_0 >= K_COMPACT && LA121_0 <= K_COUNTER)||(LA121_0 >= K_CUSTOM && LA121_0 <= K_DECIMAL)||(LA121_0 >= K_DISTINCT && LA121_0 <= K_DOUBLE)||(LA121_0 >= K_EXISTS && LA121_0 <= K_FLOAT)||LA121_0==K_FROZEN||(LA121_0 >= K_FUNCTION && LA121_0 <= K_FUNCTIONS)||LA121_0==K_INET||(LA121_0 >= K_INITCOND && LA121_0 <= K_INPUT)||LA121_0==K_INT||(LA121_0 >= K_JSON && LA121_0 <= K_KEYS)||(LA121_0 >= K_KEYSPACES && LA121_0 <= K_LANGUAGE)||(LA121_0 >= K_LIST && LA121_0 <= K_MAP)||LA121_0==K_NOLOGIN||LA121_0==K_NOSUPERUSER||LA121_0==K_OPTIONS||(LA121_0 >= K_PASSWORD && LA121_0 <= K_PERMISSIONS)||LA121_0==K_RETURNS||(LA121_0 >= K_ROLE && LA121_0 <= K_ROLES)||(LA121_0 >= K_SET && LA121_0 <= K_TINYINT)||LA121_0==K_TRIGGER||(LA121_0 >= K_TTL && LA121_0 <= K_TYPE)||(LA121_0 >= K_USER && LA121_0 <= K_USERS)||(LA121_0 >= K_UUID && LA121_0 <= K_VARINT)||LA121_0==K_WRITETIME||LA121_0==QUOTED_NAME||LA121_0==STRING_LITERAL) ) {
						alt121=1;
					}
					switch (alt121) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1003:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_functionResource6481);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:13: ( ',' v= comparatorType )*
							loop120:
							while (true) {
								int alt120=2;
								int LA120_0 = input.LA(1);
								if ( (LA120_0==174) ) {
									alt120=1;
								}

								switch (alt120) {
								case 1 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:15: ',' v= comparatorType
									{
									match(input,174,FOLLOW_174_in_functionResource6499); 
									pushFollow(FOLLOW_comparatorType_in_functionResource6503);
									v=comparatorType();
									state._fsp--;

									 argsTypes.add(v); 
									}
									break;

								default :
									break loop120;
								}
							}

							}
							break;

					}

					match(input,172,FOLLOW_172_in_functionResource6531); 
					}

					 res = FunctionResource.functionFromCql(fn.keyspace, fn.name, argsTypes); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "functionResource"



	// $ANTLR start "createUserStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1014:1: createUserStatement returns [CreateRoleStatement stmt] : K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final CreateRoleStatement createUserStatement() throws RecognitionException {
		CreateRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        RoleOptions opts = new RoleOptions();
		        opts.setOption(IRoleManager.Option.LOGIN, true);
		        boolean superuser = false;
		        boolean ifNotExists = false;
		        RoleName name = new RoleName();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1022:5: ( K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1022:7: K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement6579); 
			match(input,K_USER,FOLLOW_K_USER_in_createUserStatement6581); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1022:23: ( K_IF K_NOT K_EXISTS )?
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==K_IF) ) {
				alt123=1;
			}
			switch (alt123) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1022:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createUserStatement6584); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createUserStatement6586); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createUserStatement6588); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_createUserStatement6596);
			u=username();
			state._fsp--;

			 name.setName((u!=null?input.toString(u.start,u.stop):null), false); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1023:7: ( K_WITH userPassword[opts] )?
			int alt124=2;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==K_WITH) ) {
				alt124=1;
			}
			switch (alt124) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1023:9: K_WITH userPassword[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement6608); 
					pushFollow(FOLLOW_userPassword_in_createUserStatement6610);
					userPassword(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1024:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt125=3;
			int LA125_0 = input.LA(1);
			if ( (LA125_0==K_SUPERUSER) ) {
				alt125=1;
			}
			else if ( (LA125_0==K_NOSUPERUSER) ) {
				alt125=2;
			}
			switch (alt125) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1024:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement6624); 
					 superuser = true; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1024:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement6630); 
					 superuser = false; 
					}
					break;

			}

			 opts.setOption(IRoleManager.Option.SUPERUSER, superuser);
			        stmt = new CreateRoleStatement(name, opts, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createUserStatement"



	// $ANTLR start "alterUserStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1032:1: alterUserStatement returns [AlterRoleStatement stmt] : K_ALTER K_USER u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final AlterRoleStatement alterUserStatement() throws RecognitionException {
		AlterRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        RoleOptions opts = new RoleOptions();
		        RoleName name = new RoleName();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1037:5: ( K_ALTER K_USER u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1037:7: K_ALTER K_USER u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement6675); 
			match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement6677); 
			pushFollow(FOLLOW_username_in_alterUserStatement6681);
			u=username();
			state._fsp--;

			 name.setName((u!=null?input.toString(u.start,u.stop):null), false); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1038:7: ( K_WITH userPassword[opts] )?
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==K_WITH) ) {
				alt126=1;
			}
			switch (alt126) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1038:9: K_WITH userPassword[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement6693); 
					pushFollow(FOLLOW_userPassword_in_alterUserStatement6695);
					userPassword(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1039:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt127=3;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==K_SUPERUSER) ) {
				alt127=1;
			}
			else if ( (LA127_0==K_NOSUPERUSER) ) {
				alt127=2;
			}
			switch (alt127) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1039:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement6709); 
					 opts.setOption(IRoleManager.Option.SUPERUSER, true); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1040:11: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement6723); 
					 opts.setOption(IRoleManager.Option.SUPERUSER, false); 
					}
					break;

			}

			  stmt = new AlterRoleStatement(name, opts); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterUserStatement"



	// $ANTLR start "dropUserStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1047:1: dropUserStatement returns [DropRoleStatement stmt] : K_DROP K_USER ( K_IF K_EXISTS )? u= username ;
	public final DropRoleStatement dropUserStatement() throws RecognitionException {
		DropRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        boolean ifExists = false;
		        RoleName name = new RoleName();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:5: ( K_DROP K_USER ( K_IF K_EXISTS )? u= username )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:7: K_DROP K_USER ( K_IF K_EXISTS )? u= username
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement6769); 
			match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement6771); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:21: ( K_IF K_EXISTS )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==K_IF) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropUserStatement6774); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropUserStatement6776); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_dropUserStatement6784);
			u=username();
			state._fsp--;

			 name.setName((u!=null?input.toString(u.start,u.stop):null), false); stmt = new DropRoleStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropUserStatement"



	// $ANTLR start "listUsersStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1058:1: listUsersStatement returns [ListRolesStatement stmt] : K_LIST K_USERS ;
	public final ListRolesStatement listUsersStatement() throws RecognitionException {
		ListRolesStatement stmt = null;


		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1059:5: ( K_LIST K_USERS )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1059:7: K_LIST K_USERS
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement6809); 
			match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement6811); 
			 stmt = new ListUsersStatement(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listUsersStatement"



	// $ANTLR start "createRoleStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1071:1: createRoleStatement returns [CreateRoleStatement stmt] : K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts] )? ;
	public final CreateRoleStatement createRoleStatement() throws RecognitionException {
		CreateRoleStatement stmt = null;


		RoleName name =null;


		        RoleOptions opts = new RoleOptions();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1076:5: ( K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts] )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1076:7: K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createRoleStatement6845); 
			match(input,K_ROLE,FOLLOW_K_ROLE_in_createRoleStatement6847); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1076:23: ( K_IF K_NOT K_EXISTS )?
			int alt129=2;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==K_IF) ) {
				alt129=1;
			}
			switch (alt129) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1076:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createRoleStatement6850); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createRoleStatement6852); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createRoleStatement6854); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_createRoleStatement6862);
			name=userOrRoleName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:7: ( K_WITH roleOptions[opts] )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==K_WITH) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:9: K_WITH roleOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createRoleStatement6872); 
					pushFollow(FOLLOW_roleOptions_in_createRoleStatement6874);
					roleOptions(opts);
					state._fsp--;

					}
					break;

			}


			        // set defaults if they weren't explictly supplied
			        if (!opts.getLogin().isPresent())
			        {
			            opts.setOption(IRoleManager.Option.LOGIN, false);
			        }
			        if (!opts.getSuperuser().isPresent())
			        {
			            opts.setOption(IRoleManager.Option.SUPERUSER, false);
			        }
			        stmt = new CreateRoleStatement(name, opts, ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createRoleStatement"



	// $ANTLR start "alterRoleStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1101:1: alterRoleStatement returns [AlterRoleStatement stmt] : K_ALTER K_ROLE name= userOrRoleName ( K_WITH roleOptions[opts] )? ;
	public final AlterRoleStatement alterRoleStatement() throws RecognitionException {
		AlterRoleStatement stmt = null;


		RoleName name =null;


		        RoleOptions opts = new RoleOptions();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1105:5: ( K_ALTER K_ROLE name= userOrRoleName ( K_WITH roleOptions[opts] )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1105:7: K_ALTER K_ROLE name= userOrRoleName ( K_WITH roleOptions[opts] )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterRoleStatement6918); 
			match(input,K_ROLE,FOLLOW_K_ROLE_in_alterRoleStatement6920); 
			pushFollow(FOLLOW_userOrRoleName_in_alterRoleStatement6924);
			name=userOrRoleName();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1106:7: ( K_WITH roleOptions[opts] )?
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==K_WITH) ) {
				alt131=1;
			}
			switch (alt131) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1106:9: K_WITH roleOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterRoleStatement6934); 
					pushFollow(FOLLOW_roleOptions_in_alterRoleStatement6936);
					roleOptions(opts);
					state._fsp--;

					}
					break;

			}

			  stmt = new AlterRoleStatement(name, opts); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterRoleStatement"



	// $ANTLR start "dropRoleStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1113:1: dropRoleStatement returns [DropRoleStatement stmt] : K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName ;
	public final DropRoleStatement dropRoleStatement() throws RecognitionException {
		DropRoleStatement stmt = null;


		RoleName name =null;


		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1117:5: ( K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1117:7: K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropRoleStatement6980); 
			match(input,K_ROLE,FOLLOW_K_ROLE_in_dropRoleStatement6982); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1117:21: ( K_IF K_EXISTS )?
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==K_IF) ) {
				alt132=1;
			}
			switch (alt132) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1117:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropRoleStatement6985); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropRoleStatement6987); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_dropRoleStatement6995);
			name=userOrRoleName();
			state._fsp--;

			 stmt = new DropRoleStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropRoleStatement"



	// $ANTLR start "listRolesStatement"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1124:1: listRolesStatement returns [ListRolesStatement stmt] : K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? ;
	public final ListRolesStatement listRolesStatement() throws RecognitionException {
		ListRolesStatement stmt = null;



		        boolean recursive = true;
		        RoleName grantee = new RoleName();
		    
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1129:5: ( K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1129:7: K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listRolesStatement7035); 
			match(input,K_ROLES,FOLLOW_K_ROLES_in_listRolesStatement7037); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1130:7: ( K_OF roleName[grantee] )?
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==K_OF) ) {
				alt133=1;
			}
			switch (alt133) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1130:9: K_OF roleName[grantee]
					{
					match(input,K_OF,FOLLOW_K_OF_in_listRolesStatement7047); 
					pushFollow(FOLLOW_roleName_in_listRolesStatement7049);
					roleName(grantee);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1131:7: ( K_NORECURSIVE )?
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==K_NORECURSIVE) ) {
				alt134=1;
			}
			switch (alt134) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1131:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listRolesStatement7062); 
					 recursive = false; 
					}
					break;

			}

			 stmt = new ListRolesStatement(grantee, recursive); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listRolesStatement"



	// $ANTLR start "roleOptions"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1135:1: roleOptions[RoleOptions opts] : roleOption[opts] ( K_AND roleOption[opts] )* ;
	public final void roleOptions(RoleOptions opts) throws RecognitionException {
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:5: ( roleOption[opts] ( K_AND roleOption[opts] )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:7: roleOption[opts] ( K_AND roleOption[opts] )*
			{
			pushFollow(FOLLOW_roleOption_in_roleOptions7093);
			roleOption(opts);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:24: ( K_AND roleOption[opts] )*
			loop135:
			while (true) {
				int alt135=2;
				int LA135_0 = input.LA(1);
				if ( (LA135_0==K_AND) ) {
					alt135=1;
				}

				switch (alt135) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:25: K_AND roleOption[opts]
					{
					match(input,K_AND,FOLLOW_K_AND_in_roleOptions7097); 
					pushFollow(FOLLOW_roleOption_in_roleOptions7099);
					roleOption(opts);
					state._fsp--;

					}
					break;

				default :
					break loop135;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleOptions"



	// $ANTLR start "roleOption"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1139:1: roleOption[RoleOptions opts] : ( K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= mapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN );
	public final void roleOption(RoleOptions opts) throws RecognitionException {
		Token v=null;
		Token b=null;
		Maps.Literal m =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1140:5: ( K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= mapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN )
			int alt136=4;
			switch ( input.LA(1) ) {
			case K_PASSWORD:
				{
				alt136=1;
				}
				break;
			case K_OPTIONS:
				{
				alt136=2;
				}
				break;
			case K_SUPERUSER:
				{
				alt136=3;
				}
				break;
			case K_LOGIN:
				{
				alt136=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}
			switch (alt136) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1140:8: K_PASSWORD '=' v= STRING_LITERAL
					{
					match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_roleOption7121); 
					match(input,181,FOLLOW_181_in_roleOption7123); 
					v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_roleOption7127); 
					 opts.setOption(IRoleManager.Option.PASSWORD, (v!=null?v.getText():null)); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:8: K_OPTIONS '=' m= mapLiteral
					{
					match(input,K_OPTIONS,FOLLOW_K_OPTIONS_in_roleOption7138); 
					match(input,181,FOLLOW_181_in_roleOption7140); 
					pushFollow(FOLLOW_mapLiteral_in_roleOption7144);
					m=mapLiteral();
					state._fsp--;

					 opts.setOption(IRoleManager.Option.OPTIONS, convertPropertyMap(m)); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1142:8: K_SUPERUSER '=' b= BOOLEAN
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_roleOption7155); 
					match(input,181,FOLLOW_181_in_roleOption7157); 
					b=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_roleOption7161); 
					 opts.setOption(IRoleManager.Option.SUPERUSER, Boolean.valueOf((b!=null?b.getText():null))); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1143:8: K_LOGIN '=' b= BOOLEAN
					{
					match(input,K_LOGIN,FOLLOW_K_LOGIN_in_roleOption7172); 
					match(input,181,FOLLOW_181_in_roleOption7174); 
					b=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_roleOption7178); 
					 opts.setOption(IRoleManager.Option.LOGIN, Boolean.valueOf((b!=null?b.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleOption"



	// $ANTLR start "userPassword"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1147:1: userPassword[RoleOptions opts] : K_PASSWORD v= STRING_LITERAL ;
	public final void userPassword(RoleOptions opts) throws RecognitionException {
		Token v=null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1148:5: ( K_PASSWORD v= STRING_LITERAL )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1148:8: K_PASSWORD v= STRING_LITERAL
			{
			match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userPassword7200); 
			v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userPassword7204); 
			 opts.setOption(IRoleManager.Option.PASSWORD, (v!=null?v.getText():null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userPassword"



	// $ANTLR start "cident"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1156:1: cident returns [ColumnIdentifier.Raw id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier.Raw cident() throws RecognitionException {
		ColumnIdentifier.Raw id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1157:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt137=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt137=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt137=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt137=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}
			switch (alt137) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1157:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident7235); 
					 id = new ColumnIdentifier.Literal((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1158:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident7260); 
					 id = new ColumnIdentifier.Literal((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1159:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cident7279);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier.Literal(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "cident"



	// $ANTLR start "ident"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1163:1: ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1164:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt138=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt138=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt138=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt138=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}
			switch (alt138) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1164:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ident7305); 
					 id = ColumnIdentifier.getInterned((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1165:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ident7330); 
					 id = ColumnIdentifier.getInterned((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1166:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ident7349);
					k=unreserved_keyword();
					state._fsp--;

					 id = ColumnIdentifier.getInterned(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "ident"



	// $ANTLR start "noncol_ident"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1170:1: noncol_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier noncol_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1171:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt139=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt139=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt139=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt139=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1171:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_noncol_ident7375); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1172:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_noncol_ident7400); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1173:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_noncol_ident7419);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "noncol_ident"



	// $ANTLR start "keyspaceName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1177:1: keyspaceName returns [String id] : ksName[name] ;
	public final String keyspaceName() throws RecognitionException {
		String id = null;


		 CFName name = new CFName(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1179:5: ( ksName[name] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1179:7: ksName[name]
			{
			pushFollow(FOLLOW_ksName_in_keyspaceName7452);
			ksName(name);
			state._fsp--;

			 id = name.getKeyspace(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "keyspaceName"



	// $ANTLR start "indexName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1182:1: indexName returns [IndexName name] : ( ksName[name] '.' )? idxName[name] ;
	public final IndexName indexName() throws RecognitionException {
		IndexName name = null;


		 name = new IndexName(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:5: ( ( ksName[name] '.' )? idxName[name] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:7: ( ksName[name] '.' )? idxName[name]
			{
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:7: ( ksName[name] '.' )?
			int alt140=2;
			alt140 = dfa140.predict(input);
			switch (alt140) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_indexName7486);
					ksName(name);
					state._fsp--;

					match(input,176,FOLLOW_176_in_indexName7489); 
					}
					break;

			}

			pushFollow(FOLLOW_idxName_in_indexName7493);
			idxName(name);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "indexName"



	// $ANTLR start "columnFamilyName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1187:1: columnFamilyName returns [CFName name] : ( ksName[name] '.' )? cfName[name] ;
	public final CFName columnFamilyName() throws RecognitionException {
		CFName name = null;


		 name = new CFName(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:5: ( ( ksName[name] '.' )? cfName[name] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:7: ( ksName[name] '.' )? cfName[name]
			{
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:7: ( ksName[name] '.' )?
			int alt141=2;
			alt141 = dfa141.predict(input);
			switch (alt141) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_columnFamilyName7525);
					ksName(name);
					state._fsp--;

					match(input,176,FOLLOW_176_in_columnFamilyName7528); 
					}
					break;

			}

			pushFollow(FOLLOW_cfName_in_columnFamilyName7532);
			cfName(name);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "columnFamilyName"



	// $ANTLR start "userTypeName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1192:1: userTypeName returns [UTName name] : (ks= noncol_ident '.' )? ut= non_type_ident ;
	public final UTName userTypeName() throws RecognitionException {
		UTName name = null;


		ColumnIdentifier ks =null;
		ColumnIdentifier ut =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:5: ( (ks= noncol_ident '.' )? ut= non_type_ident )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:7: (ks= noncol_ident '.' )? ut= non_type_ident
			{
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:7: (ks= noncol_ident '.' )?
			int alt142=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA142_1 = input.LA(2);
					if ( (LA142_1==176) ) {
						alt142=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA142_2 = input.LA(2);
					if ( (LA142_2==176) ) {
						alt142=1;
					}
					}
					break;
				case K_AGGREGATE:
				case K_ALL:
				case K_AS:
				case K_CALLED:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FINALFUNC:
				case K_FROZEN:
				case K_FUNCTION:
				case K_FUNCTIONS:
				case K_INITCOND:
				case K_INPUT:
				case K_JSON:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LANGUAGE:
				case K_LIST:
				case K_LOGIN:
				case K_MAP:
				case K_NOLOGIN:
				case K_NOSUPERUSER:
				case K_OPTIONS:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_RETURNS:
				case K_ROLE:
				case K_ROLES:
				case K_SFUNC:
				case K_STATIC:
				case K_STORAGE:
				case K_STYPE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA142_3 = input.LA(2);
					if ( (LA142_3==176) ) {
						alt142=1;
					}
					}
					break;
				case K_ASCII:
				case K_BIGINT:
				case K_BLOB:
				case K_BOOLEAN:
				case K_COUNT:
				case K_COUNTER:
				case K_DATE:
				case K_DECIMAL:
				case K_DOUBLE:
				case K_FLOAT:
				case K_INET:
				case K_INT:
				case K_SMALLINT:
				case K_TEXT:
				case K_TIME:
				case K_TIMESTAMP:
				case K_TIMEUUID:
				case K_TINYINT:
				case K_TTL:
				case K_UUID:
				case K_VARCHAR:
				case K_VARINT:
				case K_WRITETIME:
					{
					alt142=1;
					}
					break;
				case K_KEY:
					{
					int LA142_5 = input.LA(2);
					if ( (LA142_5==176) ) {
						alt142=1;
					}
					}
					break;
			}
			switch (alt142) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:8: ks= noncol_ident '.'
					{
					pushFollow(FOLLOW_noncol_ident_in_userTypeName7557);
					ks=noncol_ident();
					state._fsp--;

					match(input,176,FOLLOW_176_in_userTypeName7559); 
					}
					break;

			}

			pushFollow(FOLLOW_non_type_ident_in_userTypeName7565);
			ut=non_type_ident();
			state._fsp--;

			 return new UTName(ks, ut); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userTypeName"



	// $ANTLR start "userOrRoleName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1196:1: userOrRoleName returns [RoleName name] : roleName[name] ;
	public final RoleName userOrRoleName() throws RecognitionException {
		RoleName name = null;


		 name = new RoleName(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1198:5: ( roleName[name] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1198:7: roleName[name]
			{
			pushFollow(FOLLOW_roleName_in_userOrRoleName7597);
			roleName(name);
			state._fsp--;

			return name;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userOrRoleName"



	// $ANTLR start "ksName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1201:1: ksName[KeyspaceElementName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void ksName(KeyspaceElementName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1202:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt143=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt143=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt143=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt143=3;
				}
				break;
			case QMARK:
				{
				alt143=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 143, 0, input);
				throw nvae;
			}
			switch (alt143) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1202:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ksName7620); 
					 name.setKeyspace((t!=null?t.getText():null), false);
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1203:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ksName7645); 
					 name.setKeyspace((t!=null?t.getText():null), true);
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1204:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ksName7664);
					k=unreserved_keyword();
					state._fsp--;

					 name.setKeyspace(k, false);
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1205:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_ksName7674); 
					addRecognitionError("Bind variables cannot be used for keyspace names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ksName"



	// $ANTLR start "cfName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1208:1: cfName[CFName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void cfName(CFName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1209:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt144=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt144=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt144=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt144=3;
				}
				break;
			case QMARK:
				{
				alt144=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}
			switch (alt144) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1209:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfName7696); 
					 name.setColumnFamily((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1210:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfName7721); 
					 name.setColumnFamily((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1211:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cfName7740);
					k=unreserved_keyword();
					state._fsp--;

					 name.setColumnFamily(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1212:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_cfName7750); 
					addRecognitionError("Bind variables cannot be used for table names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfName"



	// $ANTLR start "idxName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1215:1: idxName[IndexName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void idxName(IndexName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1216:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt145=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt145=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt145=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt145=3;
				}
				break;
			case QMARK:
				{
				alt145=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 145, 0, input);
				throw nvae;
			}
			switch (alt145) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1216:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_idxName7772); 
					 name.setIndex((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1217:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_idxName7797); 
					 name.setIndex((t!=null?t.getText():null), true);
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1218:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_idxName7816);
					k=unreserved_keyword();
					state._fsp--;

					 name.setIndex(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1219:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_idxName7826); 
					addRecognitionError("Bind variables cannot be used for index names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "idxName"



	// $ANTLR start "roleName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1222:1: roleName[RoleName name] : (t= IDENT |s= STRING_LITERAL |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void roleName(RoleName name) throws RecognitionException {
		Token t=null;
		Token s=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1223:5: (t= IDENT |s= STRING_LITERAL |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt146=5;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt146=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt146=2;
				}
				break;
			case QUOTED_NAME:
				{
				alt146=3;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt146=4;
				}
				break;
			case QMARK:
				{
				alt146=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 146, 0, input);
				throw nvae;
			}
			switch (alt146) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1223:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_roleName7848); 
					 name.setName((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1224:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_roleName7873); 
					 name.setName((s!=null?s.getText():null), false); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1225:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_roleName7889); 
					 name.setName((t!=null?t.getText():null), true); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1226:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_roleName7908);
					k=unreserved_keyword();
					state._fsp--;

					 name.setName(k, false); 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1227:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_roleName7918); 
					addRecognitionError("Bind variables cannot be used for role names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleName"



	// $ANTLR start "constant"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1230:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) );
	public final Constants.Literal constant() throws RecognitionException {
		Constants.Literal constant = null;


		Token t=null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1231:5: (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) )
			int alt148=7;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt148=1;
				}
				break;
			case INTEGER:
				{
				alt148=2;
				}
				break;
			case FLOAT:
				{
				alt148=3;
				}
				break;
			case BOOLEAN:
				{
				alt148=4;
				}
				break;
			case UUID:
				{
				alt148=5;
				}
				break;
			case HEXNUMBER:
				{
				alt148=6;
				}
				break;
			case K_INFINITY:
			case K_NAN:
			case 175:
				{
				alt148=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}
			switch (alt148) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1231:7: t= STRING_LITERAL
					{
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant7943); 
					 constant = Constants.Literal.string((t!=null?t.getText():null)); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1232:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant7955); 
					 constant = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1233:7: t= FLOAT
					{
					t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant7974); 
					 constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1234:7: t= BOOLEAN
					{
					t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant7995); 
					 constant = Constants.Literal.bool((t!=null?t.getText():null)); 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1235:7: t= UUID
					{
					t=(Token)match(input,UUID,FOLLOW_UUID_in_constant8014); 
					 constant = Constants.Literal.uuid((t!=null?t.getText():null)); 
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1236:7: t= HEXNUMBER
					{
					t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant8036); 
					 constant = Constants.Literal.hex((t!=null?t.getText():null)); 
					}
					break;
				case 7 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1237:7: ( '-' )? t= ( K_NAN | K_INFINITY )
					{
					 String sign=""; 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1237:27: ( '-' )?
					int alt147=2;
					int LA147_0 = input.LA(1);
					if ( (LA147_0==175) ) {
						alt147=1;
					}
					switch (alt147) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1237:28: '-'
							{
							match(input,175,FOLLOW_175_in_constant8054); 
							sign = "-"; 
							}
							break;

					}

					t=input.LT(1);
					if ( input.LA(1)==K_INFINITY||input.LA(1)==K_NAN ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 constant = Constants.Literal.floatingPoint(sign + (t!=null?t.getText():null)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return constant;
	}
	// $ANTLR end "constant"



	// $ANTLR start "mapLiteral"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1240:1: mapLiteral returns [Maps.Literal map] : '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' ;
	public final Maps.Literal mapLiteral() throws RecognitionException {
		Maps.Literal map = null;


		Term.Raw k1 =null;
		Term.Raw v1 =null;
		Term.Raw kn =null;
		Term.Raw vn =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1241:5: ( '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1241:7: '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}'
			{
			match(input,187,FOLLOW_187_in_mapLiteral8092); 
			 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1242:11: (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )?
			int alt150=2;
			int LA150_0 = input.LA(1);
			if ( (LA150_0==BOOLEAN||LA150_0==FLOAT||LA150_0==HEXNUMBER||(LA150_0 >= IDENT && LA150_0 <= INTEGER)||(LA150_0 >= K_AGGREGATE && LA150_0 <= K_ALL)||LA150_0==K_AS||LA150_0==K_ASCII||(LA150_0 >= K_BIGINT && LA150_0 <= K_BOOLEAN)||(LA150_0 >= K_CALLED && LA150_0 <= K_CLUSTERING)||(LA150_0 >= K_COMPACT && LA150_0 <= K_COUNTER)||(LA150_0 >= K_CUSTOM && LA150_0 <= K_DECIMAL)||(LA150_0 >= K_DISTINCT && LA150_0 <= K_DOUBLE)||(LA150_0 >= K_EXISTS && LA150_0 <= K_FLOAT)||LA150_0==K_FROZEN||(LA150_0 >= K_FUNCTION && LA150_0 <= K_FUNCTIONS)||(LA150_0 >= K_INET && LA150_0 <= K_INPUT)||LA150_0==K_INT||(LA150_0 >= K_JSON && LA150_0 <= K_KEYS)||(LA150_0 >= K_KEYSPACES && LA150_0 <= K_LANGUAGE)||(LA150_0 >= K_LIST && LA150_0 <= K_MAP)||(LA150_0 >= K_NAN && LA150_0 <= K_NOLOGIN)||LA150_0==K_NOSUPERUSER||LA150_0==K_NULL||LA150_0==K_OPTIONS||(LA150_0 >= K_PASSWORD && LA150_0 <= K_PERMISSIONS)||LA150_0==K_RETURNS||(LA150_0 >= K_ROLE && LA150_0 <= K_ROLES)||(LA150_0 >= K_SFUNC && LA150_0 <= K_TINYINT)||(LA150_0 >= K_TOKEN && LA150_0 <= K_TRIGGER)||(LA150_0 >= K_TTL && LA150_0 <= K_TYPE)||(LA150_0 >= K_USER && LA150_0 <= K_USERS)||(LA150_0 >= K_UUID && LA150_0 <= K_VARINT)||LA150_0==K_WRITETIME||(LA150_0 >= QMARK && LA150_0 <= QUOTED_NAME)||LA150_0==STRING_LITERAL||LA150_0==UUID||LA150_0==171||LA150_0==175||LA150_0==177||LA150_0==184||LA150_0==187) ) {
				alt150=1;
			}
			switch (alt150) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1242:13: k1= term ':' v1= term ( ',' kn= term ':' vn= term )*
					{
					pushFollow(FOLLOW_term_in_mapLiteral8110);
					k1=term();
					state._fsp--;

					match(input,177,FOLLOW_177_in_mapLiteral8112); 
					pushFollow(FOLLOW_term_in_mapLiteral8116);
					v1=term();
					state._fsp--;

					 m.add(Pair.create(k1, v1)); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1242:65: ( ',' kn= term ':' vn= term )*
					loop149:
					while (true) {
						int alt149=2;
						int LA149_0 = input.LA(1);
						if ( (LA149_0==174) ) {
							alt149=1;
						}

						switch (alt149) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1242:67: ',' kn= term ':' vn= term
							{
							match(input,174,FOLLOW_174_in_mapLiteral8122); 
							pushFollow(FOLLOW_term_in_mapLiteral8126);
							kn=term();
							state._fsp--;

							match(input,177,FOLLOW_177_in_mapLiteral8128); 
							pushFollow(FOLLOW_term_in_mapLiteral8132);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop149;
						}
					}

					}
					break;

			}

			match(input,188,FOLLOW_188_in_mapLiteral8148); 
			 map = new Maps.Literal(m); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return map;
	}
	// $ANTLR end "mapLiteral"



	// $ANTLR start "setOrMapLiteral"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1246:1: setOrMapLiteral[Term.Raw t] returns [Term.Raw value] : ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* );
	public final Term.Raw setOrMapLiteral(Term.Raw t) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw v =null;
		Term.Raw kn =null;
		Term.Raw vn =null;
		Term.Raw tn =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1247:5: ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* )
			int alt153=2;
			int LA153_0 = input.LA(1);
			if ( (LA153_0==177) ) {
				alt153=1;
			}
			else if ( (LA153_0==174||LA153_0==188) ) {
				alt153=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 153, 0, input);
				throw nvae;
			}

			switch (alt153) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1247:7: ':' v= term ( ',' kn= term ':' vn= term )*
					{
					match(input,177,FOLLOW_177_in_setOrMapLiteral8172); 
					pushFollow(FOLLOW_term_in_setOrMapLiteral8176);
					v=term();
					state._fsp--;

					 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1248:11: ( ',' kn= term ':' vn= term )*
					loop151:
					while (true) {
						int alt151=2;
						int LA151_0 = input.LA(1);
						if ( (LA151_0==174) ) {
							alt151=1;
						}

						switch (alt151) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1248:13: ',' kn= term ':' vn= term
							{
							match(input,174,FOLLOW_174_in_setOrMapLiteral8192); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral8196);
							kn=term();
							state._fsp--;

							match(input,177,FOLLOW_177_in_setOrMapLiteral8198); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral8202);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop151;
						}
					}

					 value = new Maps.Literal(m); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1250:7: ( ',' tn= term )*
					{
					 List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1251:11: ( ',' tn= term )*
					loop152:
					while (true) {
						int alt152=2;
						int LA152_0 = input.LA(1);
						if ( (LA152_0==174) ) {
							alt152=1;
						}

						switch (alt152) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1251:13: ',' tn= term
							{
							match(input,174,FOLLOW_174_in_setOrMapLiteral8237); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral8241);
							tn=term();
							state._fsp--;

							 s.add(tn); 
							}
							break;

						default :
							break loop152;
						}
					}

					 value = new Sets.Literal(s); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setOrMapLiteral"



	// $ANTLR start "collectionLiteral"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1255:1: collectionLiteral returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' );
	public final Term.Raw collectionLiteral() throws RecognitionException {
		Term.Raw value = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;
		Term.Raw t =null;
		Term.Raw v =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1256:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' )
			int alt156=3;
			int LA156_0 = input.LA(1);
			if ( (LA156_0==184) ) {
				alt156=1;
			}
			else if ( (LA156_0==187) ) {
				int LA156_2 = input.LA(2);
				if ( (LA156_2==188) ) {
					alt156=3;
				}
				else if ( (LA156_2==BOOLEAN||LA156_2==FLOAT||LA156_2==HEXNUMBER||(LA156_2 >= IDENT && LA156_2 <= INTEGER)||(LA156_2 >= K_AGGREGATE && LA156_2 <= K_ALL)||LA156_2==K_AS||LA156_2==K_ASCII||(LA156_2 >= K_BIGINT && LA156_2 <= K_BOOLEAN)||(LA156_2 >= K_CALLED && LA156_2 <= K_CLUSTERING)||(LA156_2 >= K_COMPACT && LA156_2 <= K_COUNTER)||(LA156_2 >= K_CUSTOM && LA156_2 <= K_DECIMAL)||(LA156_2 >= K_DISTINCT && LA156_2 <= K_DOUBLE)||(LA156_2 >= K_EXISTS && LA156_2 <= K_FLOAT)||LA156_2==K_FROZEN||(LA156_2 >= K_FUNCTION && LA156_2 <= K_FUNCTIONS)||(LA156_2 >= K_INET && LA156_2 <= K_INPUT)||LA156_2==K_INT||(LA156_2 >= K_JSON && LA156_2 <= K_KEYS)||(LA156_2 >= K_KEYSPACES && LA156_2 <= K_LANGUAGE)||(LA156_2 >= K_LIST && LA156_2 <= K_MAP)||(LA156_2 >= K_NAN && LA156_2 <= K_NOLOGIN)||LA156_2==K_NOSUPERUSER||LA156_2==K_NULL||LA156_2==K_OPTIONS||(LA156_2 >= K_PASSWORD && LA156_2 <= K_PERMISSIONS)||LA156_2==K_RETURNS||(LA156_2 >= K_ROLE && LA156_2 <= K_ROLES)||(LA156_2 >= K_SFUNC && LA156_2 <= K_TINYINT)||(LA156_2 >= K_TOKEN && LA156_2 <= K_TRIGGER)||(LA156_2 >= K_TTL && LA156_2 <= K_TYPE)||(LA156_2 >= K_USER && LA156_2 <= K_USERS)||(LA156_2 >= K_UUID && LA156_2 <= K_VARINT)||LA156_2==K_WRITETIME||(LA156_2 >= QMARK && LA156_2 <= QUOTED_NAME)||LA156_2==STRING_LITERAL||LA156_2==UUID||LA156_2==171||LA156_2==175||LA156_2==177||LA156_2==184||LA156_2==187) ) {
					alt156=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 156, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 156, 0, input);
				throw nvae;
			}

			switch (alt156) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1256:7: '[' (t1= term ( ',' tn= term )* )? ']'
					{
					match(input,184,FOLLOW_184_in_collectionLiteral8275); 
					 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1257:11: (t1= term ( ',' tn= term )* )?
					int alt155=2;
					int LA155_0 = input.LA(1);
					if ( (LA155_0==BOOLEAN||LA155_0==FLOAT||LA155_0==HEXNUMBER||(LA155_0 >= IDENT && LA155_0 <= INTEGER)||(LA155_0 >= K_AGGREGATE && LA155_0 <= K_ALL)||LA155_0==K_AS||LA155_0==K_ASCII||(LA155_0 >= K_BIGINT && LA155_0 <= K_BOOLEAN)||(LA155_0 >= K_CALLED && LA155_0 <= K_CLUSTERING)||(LA155_0 >= K_COMPACT && LA155_0 <= K_COUNTER)||(LA155_0 >= K_CUSTOM && LA155_0 <= K_DECIMAL)||(LA155_0 >= K_DISTINCT && LA155_0 <= K_DOUBLE)||(LA155_0 >= K_EXISTS && LA155_0 <= K_FLOAT)||LA155_0==K_FROZEN||(LA155_0 >= K_FUNCTION && LA155_0 <= K_FUNCTIONS)||(LA155_0 >= K_INET && LA155_0 <= K_INPUT)||LA155_0==K_INT||(LA155_0 >= K_JSON && LA155_0 <= K_KEYS)||(LA155_0 >= K_KEYSPACES && LA155_0 <= K_LANGUAGE)||(LA155_0 >= K_LIST && LA155_0 <= K_MAP)||(LA155_0 >= K_NAN && LA155_0 <= K_NOLOGIN)||LA155_0==K_NOSUPERUSER||LA155_0==K_NULL||LA155_0==K_OPTIONS||(LA155_0 >= K_PASSWORD && LA155_0 <= K_PERMISSIONS)||LA155_0==K_RETURNS||(LA155_0 >= K_ROLE && LA155_0 <= K_ROLES)||(LA155_0 >= K_SFUNC && LA155_0 <= K_TINYINT)||(LA155_0 >= K_TOKEN && LA155_0 <= K_TRIGGER)||(LA155_0 >= K_TTL && LA155_0 <= K_TYPE)||(LA155_0 >= K_USER && LA155_0 <= K_USERS)||(LA155_0 >= K_UUID && LA155_0 <= K_VARINT)||LA155_0==K_WRITETIME||(LA155_0 >= QMARK && LA155_0 <= QUOTED_NAME)||LA155_0==STRING_LITERAL||LA155_0==UUID||LA155_0==171||LA155_0==175||LA155_0==177||LA155_0==184||LA155_0==187) ) {
						alt155=1;
					}
					switch (alt155) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1257:13: t1= term ( ',' tn= term )*
							{
							pushFollow(FOLLOW_term_in_collectionLiteral8293);
							t1=term();
							state._fsp--;

							 l.add(t1); 
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1257:36: ( ',' tn= term )*
							loop154:
							while (true) {
								int alt154=2;
								int LA154_0 = input.LA(1);
								if ( (LA154_0==174) ) {
									alt154=1;
								}

								switch (alt154) {
								case 1 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1257:38: ',' tn= term
									{
									match(input,174,FOLLOW_174_in_collectionLiteral8299); 
									pushFollow(FOLLOW_term_in_collectionLiteral8303);
									tn=term();
									state._fsp--;

									 l.add(tn); 
									}
									break;

								default :
									break loop154;
								}
							}

							}
							break;

					}

					match(input,186,FOLLOW_186_in_collectionLiteral8319); 
					 value = new Lists.Literal(l); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1259:7: '{' t= term v= setOrMapLiteral[t] '}'
					{
					match(input,187,FOLLOW_187_in_collectionLiteral8329); 
					pushFollow(FOLLOW_term_in_collectionLiteral8333);
					t=term();
					state._fsp--;

					pushFollow(FOLLOW_setOrMapLiteral_in_collectionLiteral8337);
					v=setOrMapLiteral(t);
					state._fsp--;

					 value = v; 
					match(input,188,FOLLOW_188_in_collectionLiteral8342); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1262:7: '{' '}'
					{
					match(input,187,FOLLOW_187_in_collectionLiteral8360); 
					match(input,188,FOLLOW_188_in_collectionLiteral8362); 
					 value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "collectionLiteral"



	// $ANTLR start "usertypeLiteral"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1265:1: usertypeLiteral returns [UserTypes.Literal ut] : '{' k1= noncol_ident ':' v1= term ( ',' kn= noncol_ident ':' vn= term )* '}' ;
	public final UserTypes.Literal usertypeLiteral() throws RecognitionException {
		UserTypes.Literal ut = null;


		ColumnIdentifier k1 =null;
		Term.Raw v1 =null;
		ColumnIdentifier kn =null;
		Term.Raw vn =null;

		 Map<ColumnIdentifier, Term.Raw> m = new HashMap<ColumnIdentifier, Term.Raw>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1269:5: ( '{' k1= noncol_ident ':' v1= term ( ',' kn= noncol_ident ':' vn= term )* '}' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1269:7: '{' k1= noncol_ident ':' v1= term ( ',' kn= noncol_ident ':' vn= term )* '}'
			{
			match(input,187,FOLLOW_187_in_usertypeLiteral8406); 
			pushFollow(FOLLOW_noncol_ident_in_usertypeLiteral8410);
			k1=noncol_ident();
			state._fsp--;

			match(input,177,FOLLOW_177_in_usertypeLiteral8412); 
			pushFollow(FOLLOW_term_in_usertypeLiteral8416);
			v1=term();
			state._fsp--;

			 m.put(k1, v1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1269:58: ( ',' kn= noncol_ident ':' vn= term )*
			loop157:
			while (true) {
				int alt157=2;
				int LA157_0 = input.LA(1);
				if ( (LA157_0==174) ) {
					alt157=1;
				}

				switch (alt157) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1269:60: ',' kn= noncol_ident ':' vn= term
					{
					match(input,174,FOLLOW_174_in_usertypeLiteral8422); 
					pushFollow(FOLLOW_noncol_ident_in_usertypeLiteral8426);
					kn=noncol_ident();
					state._fsp--;

					match(input,177,FOLLOW_177_in_usertypeLiteral8428); 
					pushFollow(FOLLOW_term_in_usertypeLiteral8432);
					vn=term();
					state._fsp--;

					 m.put(kn, vn); 
					}
					break;

				default :
					break loop157;
				}
			}

			match(input,188,FOLLOW_188_in_usertypeLiteral8439); 
			}

			 ut = new UserTypes.Literal(m); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ut;
	}
	// $ANTLR end "usertypeLiteral"



	// $ANTLR start "tupleLiteral"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1272:1: tupleLiteral returns [Tuples.Literal tt] : '(' t1= term ( ',' tn= term )* ')' ;
	public final Tuples.Literal tupleLiteral() throws RecognitionException {
		Tuples.Literal tt = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1275:5: ( '(' t1= term ( ',' tn= term )* ')' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1275:7: '(' t1= term ( ',' tn= term )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleLiteral8476); 
			pushFollow(FOLLOW_term_in_tupleLiteral8480);
			t1=term();
			state._fsp--;

			 l.add(t1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1275:34: ( ',' tn= term )*
			loop158:
			while (true) {
				int alt158=2;
				int LA158_0 = input.LA(1);
				if ( (LA158_0==174) ) {
					alt158=1;
				}

				switch (alt158) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1275:36: ',' tn= term
					{
					match(input,174,FOLLOW_174_in_tupleLiteral8486); 
					pushFollow(FOLLOW_term_in_tupleLiteral8490);
					tn=term();
					state._fsp--;

					 l.add(tn); 
					}
					break;

				default :
					break loop158;
				}
			}

			match(input,172,FOLLOW_172_in_tupleLiteral8497); 
			}

			 tt = new Tuples.Literal(l); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return tt;
	}
	// $ANTLR end "tupleLiteral"



	// $ANTLR start "value"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1278:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK );
	public final Term.Raw value() throws RecognitionException {
		Term.Raw value = null;


		Constants.Literal c =null;
		Term.Raw l =null;
		UserTypes.Literal u =null;
		Tuples.Literal t =null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1279:5: (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK )
			int alt159=7;
			alt159 = dfa159.predict(input);
			switch (alt159) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1279:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_value8520);
					c=constant();
					state._fsp--;

					 value = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1280:7: l= collectionLiteral
					{
					pushFollow(FOLLOW_collectionLiteral_in_value8542);
					l=collectionLiteral();
					state._fsp--;

					 value = l; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1281:7: u= usertypeLiteral
					{
					pushFollow(FOLLOW_usertypeLiteral_in_value8555);
					u=usertypeLiteral();
					state._fsp--;

					 value = u; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1282:7: t= tupleLiteral
					{
					pushFollow(FOLLOW_tupleLiteral_in_value8570);
					t=tupleLiteral();
					state._fsp--;

					 value = t; 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1283:7: K_NULL
					{
					match(input,K_NULL,FOLLOW_K_NULL_in_value8586); 
					 value = Constants.NULL_LITERAL; 
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1284:7: ':' id= noncol_ident
					{
					match(input,177,FOLLOW_177_in_value8610); 
					pushFollow(FOLLOW_noncol_ident_in_value8614);
					id=noncol_ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 7 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1285:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_value8625); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "value"



	// $ANTLR start "intValue"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1288:1: intValue returns [Term.Raw value] : (|t= INTEGER | ':' id= noncol_ident | QMARK );
	public final Term.Raw intValue() throws RecognitionException {
		Term.Raw value = null;


		Token t=null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1289:5: (|t= INTEGER | ':' id= noncol_ident | QMARK )
			int alt160=4;
			switch ( input.LA(1) ) {
			case EOF:
			case K_ALLOW:
			case K_AND:
			case K_APPLY:
			case K_DELETE:
			case K_INSERT:
			case K_SET:
			case K_UPDATE:
			case K_WHERE:
			case 178:
				{
				alt160=1;
				}
				break;
			case INTEGER:
				{
				alt160=2;
				}
				break;
			case 177:
				{
				alt160=3;
				}
				break;
			case QMARK:
				{
				alt160=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 160, 0, input);
				throw nvae;
			}
			switch (alt160) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1290:5: 
					{
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1290:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue8671); 
					 value = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1291:7: ':' id= noncol_ident
					{
					match(input,177,FOLLOW_177_in_intValue8685); 
					pushFollow(FOLLOW_noncol_ident_in_intValue8689);
					id=noncol_ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1292:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_intValue8700); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "intValue"



	// $ANTLR start "functionName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1295:1: functionName returns [FunctionName s] : (ks= keyspaceName '.' )? f= allowedFunctionName ;
	public final FunctionName functionName() throws RecognitionException {
		FunctionName s = null;


		String ks =null;
		String f =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1296:5: ( (ks= keyspaceName '.' )? f= allowedFunctionName )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1296:7: (ks= keyspaceName '.' )? f= allowedFunctionName
			{
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1296:7: (ks= keyspaceName '.' )?
			int alt161=2;
			alt161 = dfa161.predict(input);
			switch (alt161) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1296:8: ks= keyspaceName '.'
					{
					pushFollow(FOLLOW_keyspaceName_in_functionName8734);
					ks=keyspaceName();
					state._fsp--;

					match(input,176,FOLLOW_176_in_functionName8736); 
					}
					break;

			}

			pushFollow(FOLLOW_allowedFunctionName_in_functionName8742);
			f=allowedFunctionName();
			state._fsp--;

			 s = new FunctionName(ks, f); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "functionName"



	// $ANTLR start "allowedFunctionName"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1299:1: allowedFunctionName returns [String s] : (f= IDENT |f= QUOTED_NAME |u= unreserved_function_keyword | K_TOKEN | K_COUNT );
	public final String allowedFunctionName() throws RecognitionException {
		String s = null;


		Token f=null;
		String u =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1300:5: (f= IDENT |f= QUOTED_NAME |u= unreserved_function_keyword | K_TOKEN | K_COUNT )
			int alt162=5;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt162=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt162=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
				{
				alt162=3;
				}
				break;
			case K_TOKEN:
				{
				alt162=4;
				}
				break;
			case K_COUNT:
				{
				alt162=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}
			switch (alt162) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1300:7: f= IDENT
					{
					f=(Token)match(input,IDENT,FOLLOW_IDENT_in_allowedFunctionName8769); 
					 s = (f!=null?f.getText():null).toLowerCase(); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1301:7: f= QUOTED_NAME
					{
					f=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_allowedFunctionName8803); 
					 s = (f!=null?f.getText():null); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1302:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_allowedFunctionName8831);
					u=unreserved_function_keyword();
					state._fsp--;

					 s = u; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1303:7: K_TOKEN
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_allowedFunctionName8841); 
					 s = "token"; 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1304:7: K_COUNT
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_allowedFunctionName8873); 
					 s = "count"; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "allowedFunctionName"



	// $ANTLR start "function"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1307:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );
	public final Term.Raw function() throws RecognitionException {
		Term.Raw t = null;


		FunctionName f =null;
		List<Term.Raw> args =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1308:5: (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' )
			int alt163=2;
			alt163 = dfa163.predict(input);
			switch (alt163) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1308:7: f= functionName '(' ')'
					{
					pushFollow(FOLLOW_functionName_in_function8920);
					f=functionName();
					state._fsp--;

					match(input,171,FOLLOW_171_in_function8922); 
					match(input,172,FOLLOW_172_in_function8924); 
					 t = new FunctionCall.Raw(f, Collections.<Term.Raw>emptyList()); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1309:7: f= functionName '(' args= functionArgs ')'
					{
					pushFollow(FOLLOW_functionName_in_function8954);
					f=functionName();
					state._fsp--;

					match(input,171,FOLLOW_171_in_function8956); 
					pushFollow(FOLLOW_functionArgs_in_function8960);
					args=functionArgs();
					state._fsp--;

					match(input,172,FOLLOW_172_in_function8962); 
					 t = new FunctionCall.Raw(f, args); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "function"



	// $ANTLR start "functionArgs"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1312:1: functionArgs returns [List<Term.Raw> args] : t1= term ( ',' tn= term )* ;
	public final List<Term.Raw> functionArgs() throws RecognitionException {
		List<Term.Raw> args = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 args = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1314:5: (t1= term ( ',' tn= term )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1314:7: t1= term ( ',' tn= term )*
			{
			pushFollow(FOLLOW_term_in_functionArgs8995);
			t1=term();
			state._fsp--;

			args.add(t1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1314:32: ( ',' tn= term )*
			loop164:
			while (true) {
				int alt164=2;
				int LA164_0 = input.LA(1);
				if ( (LA164_0==174) ) {
					alt164=1;
				}

				switch (alt164) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1314:34: ',' tn= term
					{
					match(input,174,FOLLOW_174_in_functionArgs9001); 
					pushFollow(FOLLOW_term_in_functionArgs9005);
					tn=term();
					state._fsp--;

					 args.add(tn); 
					}
					break;

				default :
					break loop164;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return args;
	}
	// $ANTLR end "functionArgs"



	// $ANTLR start "term"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1317:1: term returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= term );
	public final Term.Raw term() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw v =null;
		Term.Raw f =null;
		CQL3Type.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1318:5: (v= value |f= function | '(' c= comparatorType ')' t= term )
			int alt165=3;
			alt165 = dfa165.predict(input);
			switch (alt165) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1318:7: v= value
					{
					pushFollow(FOLLOW_value_in_term9033);
					v=value();
					state._fsp--;

					 term = v; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1319:7: f= function
					{
					pushFollow(FOLLOW_function_in_term9070);
					f=function();
					state._fsp--;

					 term = f; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1320:7: '(' c= comparatorType ')' t= term
					{
					match(input,171,FOLLOW_171_in_term9102); 
					pushFollow(FOLLOW_comparatorType_in_term9106);
					c=comparatorType();
					state._fsp--;

					match(input,172,FOLLOW_172_in_term9108); 
					pushFollow(FOLLOW_term_in_term9112);
					t=term();
					state._fsp--;

					 term = new TypeCast(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "term"



	// $ANTLR start "columnOperation"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1323:1: columnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations] : key= cident columnOperationDifferentiator[operations, key] ;
	public final void columnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations) throws RecognitionException {
		ColumnIdentifier.Raw key =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1324:5: (key= cident columnOperationDifferentiator[operations, key] )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1324:7: key= cident columnOperationDifferentiator[operations, key]
			{
			pushFollow(FOLLOW_cident_in_columnOperation9135);
			key=cident();
			state._fsp--;

			pushFollow(FOLLOW_columnOperationDifferentiator_in_columnOperation9137);
			columnOperationDifferentiator(operations, key);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperation"



	// $ANTLR start "columnOperationDifferentiator"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1327:1: columnOperationDifferentiator[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] );
	public final void columnOperationDifferentiator(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Term.Raw k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1328:5: ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] )
			int alt166=2;
			int LA166_0 = input.LA(1);
			if ( (LA166_0==181) ) {
				alt166=1;
			}
			else if ( (LA166_0==184) ) {
				alt166=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 166, 0, input);
				throw nvae;
			}

			switch (alt166) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1328:7: '=' normalColumnOperation[operations, key]
					{
					match(input,181,FOLLOW_181_in_columnOperationDifferentiator9156); 
					pushFollow(FOLLOW_normalColumnOperation_in_columnOperationDifferentiator9158);
					normalColumnOperation(operations, key);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1329:7: '[' k= term ']' specializedColumnOperation[operations, key, k]
					{
					match(input,184,FOLLOW_184_in_columnOperationDifferentiator9167); 
					pushFollow(FOLLOW_term_in_columnOperationDifferentiator9171);
					k=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_columnOperationDifferentiator9173); 
					pushFollow(FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator9175);
					specializedColumnOperation(operations, key, k);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperationDifferentiator"



	// $ANTLR start "normalColumnOperation"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1332:1: normalColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );
	public final void normalColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Token sig=null;
		Token i=null;
		Term.Raw t =null;
		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1333:5: (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER )
			int alt168=3;
			alt168 = dfa168.predict(input);
			switch (alt168) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1333:7: t= term ( '+' c= cident )?
					{
					pushFollow(FOLLOW_term_in_normalColumnOperation9196);
					t=term();
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1333:14: ( '+' c= cident )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==173) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1333:15: '+' c= cident
							{
							match(input,173,FOLLOW_173_in_normalColumnOperation9199); 
							pushFollow(FOLLOW_cident_in_normalColumnOperation9203);
							c=cident();
							state._fsp--;

							}
							break;

					}


					          if (c == null)
					          {
					              addRawUpdate(operations, key, new Operation.SetValue(t));
					          }
					          else
					          {
					              if (!key.equals(c))
					                  addRecognitionError("Only expressions of the form X = <value> + X are supported.");
					              addRawUpdate(operations, key, new Operation.Prepend(t));
					          }
					      
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1346:7: c= cident sig= ( '+' | '-' ) t= term
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation9224);
					c=cident();
					state._fsp--;

					sig=input.LT(1);
					if ( input.LA(1)==173||input.LA(1)==175 ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_term_in_normalColumnOperation9238);
					t=term();
					state._fsp--;


					          if (!key.equals(c))
					              addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
					          addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
					      
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1352:7: c= cident i= INTEGER
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation9256);
					c=cident();
					state._fsp--;

					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_normalColumnOperation9260); 

					          // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
					          if (!key.equals(c))
					              // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
					              addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
					          addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "normalColumnOperation"



	// $ANTLR start "specializedColumnOperation"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1362:1: specializedColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k] : '=' t= term ;
	public final void specializedColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k) throws RecognitionException {
		Term.Raw t =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1363:5: ( '=' t= term )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1363:7: '=' t= term
			{
			match(input,181,FOLLOW_181_in_specializedColumnOperation9286); 
			pushFollow(FOLLOW_term_in_specializedColumnOperation9290);
			t=term();
			state._fsp--;


			          addRawUpdate(operations, key, new Operation.SetElement(k, t));
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "specializedColumnOperation"



	// $ANTLR start "columnCondition"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1369:1: columnCondition[List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) ;
	public final void columnCondition(List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions) throws RecognitionException {
		ColumnIdentifier.Raw key =null;
		Operator op =null;
		Term.Raw t =null;
		List<Term.Raw> values =null;
		AbstractMarker.INRaw marker =null;
		Term.Raw element =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1371:5: (key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1371:7: key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			{
			pushFollow(FOLLOW_cident_in_columnCondition9323);
			key=cident();
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1372:9: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			int alt172=3;
			switch ( input.LA(1) ) {
			case 170:
			case 179:
			case 180:
			case 181:
			case 182:
			case 183:
				{
				alt172=1;
				}
				break;
			case K_IN:
				{
				alt172=2;
				}
				break;
			case 184:
				{
				alt172=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 172, 0, input);
				throw nvae;
			}
			switch (alt172) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1372:11: op= relationType t= term
					{
					pushFollow(FOLLOW_relationType_in_columnCondition9337);
					op=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_columnCondition9341);
					t=term();
					state._fsp--;

					 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleCondition(t, op))); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1373:11: K_IN (values= singleColumnInValues |marker= inMarker )
					{
					match(input,K_IN,FOLLOW_K_IN_in_columnCondition9355); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1374:13: (values= singleColumnInValues |marker= inMarker )
					int alt169=2;
					int LA169_0 = input.LA(1);
					if ( (LA169_0==171) ) {
						alt169=1;
					}
					else if ( (LA169_0==QMARK||LA169_0==177) ) {
						alt169=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 169, 0, input);
						throw nvae;
					}

					switch (alt169) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1374:15: values= singleColumnInValues
							{
							pushFollow(FOLLOW_singleColumnInValues_in_columnCondition9373);
							values=singleColumnInValues();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(values))); 
							}
							break;
						case 2 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1375:15: marker= inMarker
							{
							pushFollow(FOLLOW_inMarker_in_columnCondition9393);
							marker=inMarker();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(marker))); 
							}
							break;

					}

					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1377:11: '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					{
					match(input,184,FOLLOW_184_in_columnCondition9421); 
					pushFollow(FOLLOW_term_in_columnCondition9425);
					element=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_columnCondition9427); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1378:13: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					int alt171=2;
					int LA171_0 = input.LA(1);
					if ( (LA171_0==170||(LA171_0 >= 179 && LA171_0 <= 183)) ) {
						alt171=1;
					}
					else if ( (LA171_0==K_IN) ) {
						alt171=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 171, 0, input);
						throw nvae;
					}

					switch (alt171) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1378:15: op= relationType t= term
							{
							pushFollow(FOLLOW_relationType_in_columnCondition9445);
							op=relationType();
							state._fsp--;

							pushFollow(FOLLOW_term_in_columnCondition9449);
							t=term();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionCondition(t, element, op))); 
							}
							break;
						case 2 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1379:15: K_IN (values= singleColumnInValues |marker= inMarker )
							{
							match(input,K_IN,FOLLOW_K_IN_in_columnCondition9467); 
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1380:17: (values= singleColumnInValues |marker= inMarker )
							int alt170=2;
							int LA170_0 = input.LA(1);
							if ( (LA170_0==171) ) {
								alt170=1;
							}
							else if ( (LA170_0==QMARK||LA170_0==177) ) {
								alt170=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 170, 0, input);
								throw nvae;
							}

							switch (alt170) {
								case 1 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1380:19: values= singleColumnInValues
									{
									pushFollow(FOLLOW_singleColumnInValues_in_columnCondition9489);
									values=singleColumnInValues();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, values))); 
									}
									break;
								case 2 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1381:19: marker= inMarker
									{
									pushFollow(FOLLOW_inMarker_in_columnCondition9513);
									marker=inMarker();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, marker))); 
									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnCondition"



	// $ANTLR start "properties"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1387:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
	public final void properties(PropertyDefinitions props) throws RecognitionException {
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1388:5: ( property[props] ( K_AND property[props] )* )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1388:7: property[props] ( K_AND property[props] )*
			{
			pushFollow(FOLLOW_property_in_properties9575);
			property(props);
			state._fsp--;

			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1388:23: ( K_AND property[props] )*
			loop173:
			while (true) {
				int alt173=2;
				int LA173_0 = input.LA(1);
				if ( (LA173_0==K_AND) ) {
					alt173=1;
				}

				switch (alt173) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1388:24: K_AND property[props]
					{
					match(input,K_AND,FOLLOW_K_AND_in_properties9579); 
					pushFollow(FOLLOW_property_in_properties9581);
					property(props);
					state._fsp--;

					}
					break;

				default :
					break loop173;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "properties"



	// $ANTLR start "property"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1391:1: property[PropertyDefinitions props] : (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= mapLiteral );
	public final void property(PropertyDefinitions props) throws RecognitionException {
		ColumnIdentifier k =null;
		String simple =null;
		Maps.Literal map =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1392:5: (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= mapLiteral )
			int alt174=2;
			alt174 = dfa174.predict(input);
			switch (alt174) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1392:7: k= noncol_ident '=' simple= propertyValue
					{
					pushFollow(FOLLOW_noncol_ident_in_property9604);
					k=noncol_ident();
					state._fsp--;

					match(input,181,FOLLOW_181_in_property9606); 
					pushFollow(FOLLOW_propertyValue_in_property9610);
					simple=propertyValue();
					state._fsp--;

					 try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1393:7: k= noncol_ident '=' map= mapLiteral
					{
					pushFollow(FOLLOW_noncol_ident_in_property9622);
					k=noncol_ident();
					state._fsp--;

					match(input,181,FOLLOW_181_in_property9624); 
					pushFollow(FOLLOW_mapLiteral_in_property9628);
					map=mapLiteral();
					state._fsp--;

					 try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"



	// $ANTLR start "propertyValue"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1396:1: propertyValue returns [String str] : (c= constant |u= unreserved_keyword );
	public final String propertyValue() throws RecognitionException {
		String str = null;


		Constants.Literal c =null;
		String u =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1397:5: (c= constant |u= unreserved_keyword )
			int alt175=2;
			int LA175_0 = input.LA(1);
			if ( (LA175_0==BOOLEAN||LA175_0==FLOAT||LA175_0==HEXNUMBER||LA175_0==INTEGER||LA175_0==K_INFINITY||LA175_0==K_NAN||LA175_0==STRING_LITERAL||LA175_0==UUID||LA175_0==175) ) {
				alt175=1;
			}
			else if ( ((LA175_0 >= K_AGGREGATE && LA175_0 <= K_ALL)||LA175_0==K_AS||LA175_0==K_ASCII||(LA175_0 >= K_BIGINT && LA175_0 <= K_BOOLEAN)||(LA175_0 >= K_CALLED && LA175_0 <= K_CLUSTERING)||(LA175_0 >= K_COMPACT && LA175_0 <= K_COUNTER)||(LA175_0 >= K_CUSTOM && LA175_0 <= K_DECIMAL)||(LA175_0 >= K_DISTINCT && LA175_0 <= K_DOUBLE)||(LA175_0 >= K_EXISTS && LA175_0 <= K_FLOAT)||LA175_0==K_FROZEN||(LA175_0 >= K_FUNCTION && LA175_0 <= K_FUNCTIONS)||LA175_0==K_INET||(LA175_0 >= K_INITCOND && LA175_0 <= K_INPUT)||LA175_0==K_INT||(LA175_0 >= K_JSON && LA175_0 <= K_KEYS)||(LA175_0 >= K_KEYSPACES && LA175_0 <= K_LANGUAGE)||(LA175_0 >= K_LIST && LA175_0 <= K_MAP)||LA175_0==K_NOLOGIN||LA175_0==K_NOSUPERUSER||LA175_0==K_OPTIONS||(LA175_0 >= K_PASSWORD && LA175_0 <= K_PERMISSIONS)||LA175_0==K_RETURNS||(LA175_0 >= K_ROLE && LA175_0 <= K_ROLES)||(LA175_0 >= K_SFUNC && LA175_0 <= K_TINYINT)||LA175_0==K_TRIGGER||(LA175_0 >= K_TTL && LA175_0 <= K_TYPE)||(LA175_0 >= K_USER && LA175_0 <= K_USERS)||(LA175_0 >= K_UUID && LA175_0 <= K_VARINT)||LA175_0==K_WRITETIME) ) {
				alt175=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 175, 0, input);
				throw nvae;
			}

			switch (alt175) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1397:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_propertyValue9653);
					c=constant();
					state._fsp--;

					 str = c.getRawText(); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1398:7: u= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_propertyValue9675);
					u=unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "propertyValue"



	// $ANTLR start "relationType"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1401:1: relationType returns [Operator op] : ( '=' | '<' | '<=' | '>' | '>=' | '!=' );
	public final Operator relationType() throws RecognitionException {
		Operator op = null;


		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1402:5: ( '=' | '<' | '<=' | '>' | '>=' | '!=' )
			int alt176=6;
			switch ( input.LA(1) ) {
			case 181:
				{
				alt176=1;
				}
				break;
			case 179:
				{
				alt176=2;
				}
				break;
			case 180:
				{
				alt176=3;
				}
				break;
			case 182:
				{
				alt176=4;
				}
				break;
			case 183:
				{
				alt176=5;
				}
				break;
			case 170:
				{
				alt176=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 176, 0, input);
				throw nvae;
			}
			switch (alt176) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1402:7: '='
					{
					match(input,181,FOLLOW_181_in_relationType9698); 
					 op = Operator.EQ; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1403:7: '<'
					{
					match(input,179,FOLLOW_179_in_relationType9709); 
					 op = Operator.LT; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1404:7: '<='
					{
					match(input,180,FOLLOW_180_in_relationType9720); 
					 op = Operator.LTE; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1405:7: '>'
					{
					match(input,182,FOLLOW_182_in_relationType9730); 
					 op = Operator.GT; 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1406:7: '>='
					{
					match(input,183,FOLLOW_183_in_relationType9741); 
					 op = Operator.GTE; 
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1407:7: '!='
					{
					match(input,170,FOLLOW_170_in_relationType9751); 
					 op = Operator.NEQ; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "relationType"



	// $ANTLR start "relation"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1410:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );
	public final void relation(List<Relation> clauses) throws RecognitionException {
		ColumnIdentifier.Raw name =null;
		Operator type =null;
		Term.Raw t =null;
		List<ColumnIdentifier.Raw> l =null;
		AbstractMarker.INRaw marker =null;
		List<Term.Raw> inValues =null;
		Term.Raw key =null;
		List<ColumnIdentifier.Raw> ids =null;
		Tuples.INRaw tupleInMarker =null;
		List<Tuples.Literal> literals =null;
		List<Tuples.Raw> markers =null;
		Tuples.Literal literal =null;
		Tuples.Raw tupleMarker =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1411:5: (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' )
			int alt180=8;
			alt180 = dfa180.predict(input);
			switch (alt180) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1411:7: name= cident type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation9773);
					name=cident();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation9777);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation9781);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, type, t)); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1412:7: K_TOKEN l= tupleOfIdentifiers type= relationType t= term
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation9791); 
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation9795);
					l=tupleOfIdentifiers();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation9799);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation9803);
					t=term();
					state._fsp--;

					 clauses.add(new TokenRelation(l, type, t)); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1414:7: name= cident K_IN marker= inMarker
					{
					pushFollow(FOLLOW_cident_in_relation9823);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation9825); 
					pushFollow(FOLLOW_inMarker_in_relation9829);
					marker=inMarker();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, Operator.IN, marker)); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1416:7: name= cident K_IN inValues= singleColumnInValues
					{
					pushFollow(FOLLOW_cident_in_relation9849);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation9851); 
					pushFollow(FOLLOW_singleColumnInValues_in_relation9855);
					inValues=singleColumnInValues();
					state._fsp--;

					 clauses.add(SingleColumnRelation.createInRelation(name, inValues)); 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1418:7: name= cident K_CONTAINS ( K_KEY )? t= term
					{
					pushFollow(FOLLOW_cident_in_relation9875);
					name=cident();
					state._fsp--;

					match(input,K_CONTAINS,FOLLOW_K_CONTAINS_in_relation9877); 
					 Operator rt = Operator.CONTAINS; 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1418:67: ( K_KEY )?
					int alt177=2;
					int LA177_0 = input.LA(1);
					if ( (LA177_0==K_KEY) ) {
						int LA177_1 = input.LA(2);
						if ( (LA177_1==BOOLEAN||LA177_1==FLOAT||LA177_1==HEXNUMBER||(LA177_1 >= IDENT && LA177_1 <= INTEGER)||(LA177_1 >= K_AGGREGATE && LA177_1 <= K_ALL)||LA177_1==K_AS||LA177_1==K_ASCII||(LA177_1 >= K_BIGINT && LA177_1 <= K_BOOLEAN)||(LA177_1 >= K_CALLED && LA177_1 <= K_CLUSTERING)||(LA177_1 >= K_COMPACT && LA177_1 <= K_COUNTER)||(LA177_1 >= K_CUSTOM && LA177_1 <= K_DECIMAL)||(LA177_1 >= K_DISTINCT && LA177_1 <= K_DOUBLE)||(LA177_1 >= K_EXISTS && LA177_1 <= K_FLOAT)||LA177_1==K_FROZEN||(LA177_1 >= K_FUNCTION && LA177_1 <= K_FUNCTIONS)||(LA177_1 >= K_INET && LA177_1 <= K_INPUT)||LA177_1==K_INT||(LA177_1 >= K_JSON && LA177_1 <= K_KEYS)||(LA177_1 >= K_KEYSPACES && LA177_1 <= K_LANGUAGE)||(LA177_1 >= K_LIST && LA177_1 <= K_MAP)||(LA177_1 >= K_NAN && LA177_1 <= K_NOLOGIN)||LA177_1==K_NOSUPERUSER||LA177_1==K_NULL||LA177_1==K_OPTIONS||(LA177_1 >= K_PASSWORD && LA177_1 <= K_PERMISSIONS)||LA177_1==K_RETURNS||(LA177_1 >= K_ROLE && LA177_1 <= K_ROLES)||(LA177_1 >= K_SFUNC && LA177_1 <= K_TINYINT)||(LA177_1 >= K_TOKEN && LA177_1 <= K_TRIGGER)||(LA177_1 >= K_TTL && LA177_1 <= K_TYPE)||(LA177_1 >= K_USER && LA177_1 <= K_USERS)||(LA177_1 >= K_UUID && LA177_1 <= K_VARINT)||LA177_1==K_WRITETIME||(LA177_1 >= QMARK && LA177_1 <= QUOTED_NAME)||LA177_1==STRING_LITERAL||LA177_1==UUID||LA177_1==171||LA177_1==175||LA177_1==177||LA177_1==184||LA177_1==187) ) {
							alt177=1;
						}
					}
					switch (alt177) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1418:68: K_KEY
							{
							match(input,K_KEY,FOLLOW_K_KEY_in_relation9882); 
							 rt = Operator.CONTAINS_KEY; 
							}
							break;

					}

					pushFollow(FOLLOW_term_in_relation9898);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, rt, t)); 
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1420:7: name= cident '[' key= term ']' type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation9910);
					name=cident();
					state._fsp--;

					match(input,184,FOLLOW_184_in_relation9912); 
					pushFollow(FOLLOW_term_in_relation9916);
					key=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_relation9918); 
					pushFollow(FOLLOW_relationType_in_relation9922);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation9926);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, key, type, t)); 
					}
					break;
				case 7 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1421:7: ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					{
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation9938);
					ids=tupleOfIdentifiers();
					state._fsp--;

					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1422:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					int alt179=3;
					alt179 = dfa179.predict(input);
					switch (alt179) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1422:9: K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							{
							match(input,K_IN,FOLLOW_K_IN_in_relation9948); 
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1423:11: ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							int alt178=4;
							int LA178_0 = input.LA(1);
							if ( (LA178_0==171) ) {
								switch ( input.LA(2) ) {
								case 172:
									{
									alt178=1;
									}
									break;
								case 171:
									{
									alt178=3;
									}
									break;
								case QMARK:
								case 177:
									{
									alt178=4;
									}
									break;
								default:
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 178, 1, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}
							else if ( (LA178_0==QMARK||LA178_0==177) ) {
								alt178=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 178, 0, input);
								throw nvae;
							}

							switch (alt178) {
								case 1 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1423:13: '(' ')'
									{
									match(input,171,FOLLOW_171_in_relation9962); 
									match(input,172,FOLLOW_172_in_relation9964); 
									 clauses.add(MultiColumnRelation.createInRelation(ids, new ArrayList<Tuples.Literal>())); 
									}
									break;
								case 2 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1425:13: tupleInMarker= inMarkerForTuple
									{
									pushFollow(FOLLOW_inMarkerForTuple_in_relation9996);
									tupleInMarker=inMarkerForTuple();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createSingleMarkerInRelation(ids, tupleInMarker)); 
									}
									break;
								case 3 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1427:13: literals= tupleOfTupleLiterals
									{
									pushFollow(FOLLOW_tupleOfTupleLiterals_in_relation10030);
									literals=tupleOfTupleLiterals();
									state._fsp--;


									                  clauses.add(MultiColumnRelation.createInRelation(ids, literals));
									              
									}
									break;
								case 4 :
									// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1431:13: markers= tupleOfMarkersForTuples
									{
									pushFollow(FOLLOW_tupleOfMarkersForTuples_in_relation10064);
									markers=tupleOfMarkersForTuples();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createInRelation(ids, markers)); 
									}
									break;

							}

							}
							break;
						case 2 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1434:9: type= relationType literal= tupleLiteral
							{
							pushFollow(FOLLOW_relationType_in_relation10106);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_tupleLiteral_in_relation10110);
							literal=tupleLiteral();
							state._fsp--;


							              clauses.add(MultiColumnRelation.createNonInRelation(ids, type, literal));
							          
							}
							break;
						case 3 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1438:9: type= relationType tupleMarker= markerForTuple
							{
							pushFollow(FOLLOW_relationType_in_relation10136);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_markerForTuple_in_relation10140);
							tupleMarker=markerForTuple();
							state._fsp--;

							 clauses.add(MultiColumnRelation.createNonInRelation(ids, type, tupleMarker)); 
							}
							break;

					}

					}
					break;
				case 8 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1441:7: '(' relation[$clauses] ')'
					{
					match(input,171,FOLLOW_171_in_relation10170); 
					pushFollow(FOLLOW_relation_in_relation10172);
					relation(clauses);
					state._fsp--;

					match(input,172,FOLLOW_172_in_relation10175); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "relation"



	// $ANTLR start "inMarker"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1444:1: inMarker returns [AbstractMarker.INRaw marker] : ( QMARK | ':' name= noncol_ident );
	public final AbstractMarker.INRaw inMarker() throws RecognitionException {
		AbstractMarker.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1445:5: ( QMARK | ':' name= noncol_ident )
			int alt181=2;
			int LA181_0 = input.LA(1);
			if ( (LA181_0==QMARK) ) {
				alt181=1;
			}
			else if ( (LA181_0==177) ) {
				alt181=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 181, 0, input);
				throw nvae;
			}

			switch (alt181) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1445:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarker10196); 
					 marker = newINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1446:7: ':' name= noncol_ident
					{
					match(input,177,FOLLOW_177_in_inMarker10206); 
					pushFollow(FOLLOW_noncol_ident_in_inMarker10210);
					name=noncol_ident();
					state._fsp--;

					 marker = newINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarker"



	// $ANTLR start "tupleOfIdentifiers"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1449:1: tupleOfIdentifiers returns [List<ColumnIdentifier.Raw> ids] : '(' n1= cident ( ',' ni= cident )* ')' ;
	public final List<ColumnIdentifier.Raw> tupleOfIdentifiers() throws RecognitionException {
		List<ColumnIdentifier.Raw> ids = null;


		ColumnIdentifier.Raw n1 =null;
		ColumnIdentifier.Raw ni =null;

		 ids = new ArrayList<ColumnIdentifier.Raw>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1451:5: ( '(' n1= cident ( ',' ni= cident )* ')' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1451:7: '(' n1= cident ( ',' ni= cident )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleOfIdentifiers10242); 
			pushFollow(FOLLOW_cident_in_tupleOfIdentifiers10246);
			n1=cident();
			state._fsp--;

			 ids.add(n1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1451:39: ( ',' ni= cident )*
			loop182:
			while (true) {
				int alt182=2;
				int LA182_0 = input.LA(1);
				if ( (LA182_0==174) ) {
					alt182=1;
				}

				switch (alt182) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1451:40: ',' ni= cident
					{
					match(input,174,FOLLOW_174_in_tupleOfIdentifiers10251); 
					pushFollow(FOLLOW_cident_in_tupleOfIdentifiers10255);
					ni=cident();
					state._fsp--;

					 ids.add(ni); 
					}
					break;

				default :
					break loop182;
				}
			}

			match(input,172,FOLLOW_172_in_tupleOfIdentifiers10261); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ids;
	}
	// $ANTLR end "tupleOfIdentifiers"



	// $ANTLR start "singleColumnInValues"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1454:1: singleColumnInValues returns [List<Term.Raw> terms] : '(' (t1= term ( ',' ti= term )* )? ')' ;
	public final List<Term.Raw> singleColumnInValues() throws RecognitionException {
		List<Term.Raw> terms = null;


		Term.Raw t1 =null;
		Term.Raw ti =null;

		 terms = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1456:5: ( '(' (t1= term ( ',' ti= term )* )? ')' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1456:7: '(' (t1= term ( ',' ti= term )* )? ')'
			{
			match(input,171,FOLLOW_171_in_singleColumnInValues10291); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1456:11: (t1= term ( ',' ti= term )* )?
			int alt184=2;
			int LA184_0 = input.LA(1);
			if ( (LA184_0==BOOLEAN||LA184_0==FLOAT||LA184_0==HEXNUMBER||(LA184_0 >= IDENT && LA184_0 <= INTEGER)||(LA184_0 >= K_AGGREGATE && LA184_0 <= K_ALL)||LA184_0==K_AS||LA184_0==K_ASCII||(LA184_0 >= K_BIGINT && LA184_0 <= K_BOOLEAN)||(LA184_0 >= K_CALLED && LA184_0 <= K_CLUSTERING)||(LA184_0 >= K_COMPACT && LA184_0 <= K_COUNTER)||(LA184_0 >= K_CUSTOM && LA184_0 <= K_DECIMAL)||(LA184_0 >= K_DISTINCT && LA184_0 <= K_DOUBLE)||(LA184_0 >= K_EXISTS && LA184_0 <= K_FLOAT)||LA184_0==K_FROZEN||(LA184_0 >= K_FUNCTION && LA184_0 <= K_FUNCTIONS)||(LA184_0 >= K_INET && LA184_0 <= K_INPUT)||LA184_0==K_INT||(LA184_0 >= K_JSON && LA184_0 <= K_KEYS)||(LA184_0 >= K_KEYSPACES && LA184_0 <= K_LANGUAGE)||(LA184_0 >= K_LIST && LA184_0 <= K_MAP)||(LA184_0 >= K_NAN && LA184_0 <= K_NOLOGIN)||LA184_0==K_NOSUPERUSER||LA184_0==K_NULL||LA184_0==K_OPTIONS||(LA184_0 >= K_PASSWORD && LA184_0 <= K_PERMISSIONS)||LA184_0==K_RETURNS||(LA184_0 >= K_ROLE && LA184_0 <= K_ROLES)||(LA184_0 >= K_SFUNC && LA184_0 <= K_TINYINT)||(LA184_0 >= K_TOKEN && LA184_0 <= K_TRIGGER)||(LA184_0 >= K_TTL && LA184_0 <= K_TYPE)||(LA184_0 >= K_USER && LA184_0 <= K_USERS)||(LA184_0 >= K_UUID && LA184_0 <= K_VARINT)||LA184_0==K_WRITETIME||(LA184_0 >= QMARK && LA184_0 <= QUOTED_NAME)||LA184_0==STRING_LITERAL||LA184_0==UUID||LA184_0==171||LA184_0==175||LA184_0==177||LA184_0==184||LA184_0==187) ) {
				alt184=1;
			}
			switch (alt184) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1456:13: t1= term ( ',' ti= term )*
					{
					pushFollow(FOLLOW_term_in_singleColumnInValues10299);
					t1=term();
					state._fsp--;

					 terms.add(t1); 
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1456:43: ( ',' ti= term )*
					loop183:
					while (true) {
						int alt183=2;
						int LA183_0 = input.LA(1);
						if ( (LA183_0==174) ) {
							alt183=1;
						}

						switch (alt183) {
						case 1 :
							// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1456:44: ',' ti= term
							{
							match(input,174,FOLLOW_174_in_singleColumnInValues10304); 
							pushFollow(FOLLOW_term_in_singleColumnInValues10308);
							ti=term();
							state._fsp--;

							 terms.add(ti); 
							}
							break;

						default :
							break loop183;
						}
					}

					}
					break;

			}

			match(input,172,FOLLOW_172_in_singleColumnInValues10317); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return terms;
	}
	// $ANTLR end "singleColumnInValues"



	// $ANTLR start "tupleOfTupleLiterals"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1459:1: tupleOfTupleLiterals returns [List<Tuples.Literal> literals] : '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' ;
	public final List<Tuples.Literal> tupleOfTupleLiterals() throws RecognitionException {
		List<Tuples.Literal> literals = null;


		Tuples.Literal t1 =null;
		Tuples.Literal ti =null;

		 literals = new ArrayList<>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1461:5: ( '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1461:7: '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleOfTupleLiterals10347); 
			pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10351);
			t1=tupleLiteral();
			state._fsp--;

			 literals.add(t1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1461:50: ( ',' ti= tupleLiteral )*
			loop185:
			while (true) {
				int alt185=2;
				int LA185_0 = input.LA(1);
				if ( (LA185_0==174) ) {
					alt185=1;
				}

				switch (alt185) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1461:51: ',' ti= tupleLiteral
					{
					match(input,174,FOLLOW_174_in_tupleOfTupleLiterals10356); 
					pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10360);
					ti=tupleLiteral();
					state._fsp--;

					 literals.add(ti); 
					}
					break;

				default :
					break loop185;
				}
			}

			match(input,172,FOLLOW_172_in_tupleOfTupleLiterals10366); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return literals;
	}
	// $ANTLR end "tupleOfTupleLiterals"



	// $ANTLR start "markerForTuple"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1464:1: markerForTuple returns [Tuples.Raw marker] : ( QMARK | ':' name= noncol_ident );
	public final Tuples.Raw markerForTuple() throws RecognitionException {
		Tuples.Raw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1465:5: ( QMARK | ':' name= noncol_ident )
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==QMARK) ) {
				alt186=1;
			}
			else if ( (LA186_0==177) ) {
				alt186=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 186, 0, input);
				throw nvae;
			}

			switch (alt186) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1465:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_markerForTuple10387); 
					 marker = newTupleBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1466:7: ':' name= noncol_ident
					{
					match(input,177,FOLLOW_177_in_markerForTuple10397); 
					pushFollow(FOLLOW_noncol_ident_in_markerForTuple10401);
					name=noncol_ident();
					state._fsp--;

					 marker = newTupleBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "markerForTuple"



	// $ANTLR start "tupleOfMarkersForTuples"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1469:1: tupleOfMarkersForTuples returns [List<Tuples.Raw> markers] : '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' ;
	public final List<Tuples.Raw> tupleOfMarkersForTuples() throws RecognitionException {
		List<Tuples.Raw> markers = null;


		Tuples.Raw m1 =null;
		Tuples.Raw mi =null;

		 markers = new ArrayList<Tuples.Raw>(); 
		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1471:5: ( '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1471:7: '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleOfMarkersForTuples10433); 
			pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10437);
			m1=markerForTuple();
			state._fsp--;

			 markers.add(m1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1471:51: ( ',' mi= markerForTuple )*
			loop187:
			while (true) {
				int alt187=2;
				int LA187_0 = input.LA(1);
				if ( (LA187_0==174) ) {
					alt187=1;
				}

				switch (alt187) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1471:52: ',' mi= markerForTuple
					{
					match(input,174,FOLLOW_174_in_tupleOfMarkersForTuples10442); 
					pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10446);
					mi=markerForTuple();
					state._fsp--;

					 markers.add(mi); 
					}
					break;

				default :
					break loop187;
				}
			}

			match(input,172,FOLLOW_172_in_tupleOfMarkersForTuples10452); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return markers;
	}
	// $ANTLR end "tupleOfMarkersForTuples"



	// $ANTLR start "inMarkerForTuple"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1474:1: inMarkerForTuple returns [Tuples.INRaw marker] : ( QMARK | ':' name= noncol_ident );
	public final Tuples.INRaw inMarkerForTuple() throws RecognitionException {
		Tuples.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1475:5: ( QMARK | ':' name= noncol_ident )
			int alt188=2;
			int LA188_0 = input.LA(1);
			if ( (LA188_0==QMARK) ) {
				alt188=1;
			}
			else if ( (LA188_0==177) ) {
				alt188=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 188, 0, input);
				throw nvae;
			}

			switch (alt188) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1475:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarkerForTuple10473); 
					 marker = newTupleINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1476:7: ':' name= noncol_ident
					{
					match(input,177,FOLLOW_177_in_inMarkerForTuple10483); 
					pushFollow(FOLLOW_noncol_ident_in_inMarkerForTuple10487);
					name=noncol_ident();
					state._fsp--;

					 marker = newTupleINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarkerForTuple"



	// $ANTLR start "comparatorType"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1479:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );
	public final CQL3Type.Raw comparatorType() throws RecognitionException {
		CQL3Type.Raw t = null;


		Token s=null;
		CQL3Type n =null;
		CQL3Type.Raw c =null;
		CQL3Type.Raw tt =null;
		UTName id =null;
		CQL3Type.Raw f =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1480:5: (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL )
			int alt189=6;
			alt189 = dfa189.predict(input);
			switch (alt189) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1480:7: n= native_type
					{
					pushFollow(FOLLOW_native_type_in_comparatorType10512);
					n=native_type();
					state._fsp--;

					 t = CQL3Type.Raw.from(n); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1481:7: c= collection_type
					{
					pushFollow(FOLLOW_collection_type_in_comparatorType10528);
					c=collection_type();
					state._fsp--;

					 t = c; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1482:7: tt= tuple_type
					{
					pushFollow(FOLLOW_tuple_type_in_comparatorType10540);
					tt=tuple_type();
					state._fsp--;

					 t = tt; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1483:7: id= userTypeName
					{
					pushFollow(FOLLOW_userTypeName_in_comparatorType10556);
					id=userTypeName();
					state._fsp--;

					 t = CQL3Type.Raw.userType(id); 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1484:7: K_FROZEN '<' f= comparatorType '>'
					{
					match(input,K_FROZEN,FOLLOW_K_FROZEN_in_comparatorType10568); 
					match(input,179,FOLLOW_179_in_comparatorType10570); 
					pushFollow(FOLLOW_comparatorType_in_comparatorType10574);
					f=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_comparatorType10576); 

					        try {
					            t = CQL3Type.Raw.frozen(f);
					        } catch (InvalidRequestException e) {
					            addRecognitionError(e.getMessage());
					        }
					      
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1492:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType10594); 

					        try {
					            t = CQL3Type.Raw.from(new CQL3Type.Custom((s!=null?s.getText():null)));
					        } catch (SyntaxException e) {
					            addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        } catch (ConfigurationException e) {
					            addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        }
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "comparatorType"



	// $ANTLR start "native_type"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1504:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_SMALLINT | K_TEXT | K_TIMESTAMP | K_TINYINT | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID | K_DATE | K_TIME );
	public final CQL3Type native_type() throws RecognitionException {
		CQL3Type t = null;


		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1505:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_SMALLINT | K_TEXT | K_TIMESTAMP | K_TINYINT | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID | K_DATE | K_TIME )
			int alt190=20;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				alt190=1;
				}
				break;
			case K_BIGINT:
				{
				alt190=2;
				}
				break;
			case K_BLOB:
				{
				alt190=3;
				}
				break;
			case K_BOOLEAN:
				{
				alt190=4;
				}
				break;
			case K_COUNTER:
				{
				alt190=5;
				}
				break;
			case K_DECIMAL:
				{
				alt190=6;
				}
				break;
			case K_DOUBLE:
				{
				alt190=7;
				}
				break;
			case K_FLOAT:
				{
				alt190=8;
				}
				break;
			case K_INET:
				{
				alt190=9;
				}
				break;
			case K_INT:
				{
				alt190=10;
				}
				break;
			case K_SMALLINT:
				{
				alt190=11;
				}
				break;
			case K_TEXT:
				{
				alt190=12;
				}
				break;
			case K_TIMESTAMP:
				{
				alt190=13;
				}
				break;
			case K_TINYINT:
				{
				alt190=14;
				}
				break;
			case K_UUID:
				{
				alt190=15;
				}
				break;
			case K_VARCHAR:
				{
				alt190=16;
				}
				break;
			case K_VARINT:
				{
				alt190=17;
				}
				break;
			case K_TIMEUUID:
				{
				alt190=18;
				}
				break;
			case K_DATE:
				{
				alt190=19;
				}
				break;
			case K_TIME:
				{
				alt190=20;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 190, 0, input);
				throw nvae;
			}
			switch (alt190) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1505:7: K_ASCII
					{
					match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type10623); 
					 t = CQL3Type.Native.ASCII; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1506:7: K_BIGINT
					{
					match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type10637); 
					 t = CQL3Type.Native.BIGINT; 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1507:7: K_BLOB
					{
					match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type10650); 
					 t = CQL3Type.Native.BLOB; 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1508:7: K_BOOLEAN
					{
					match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type10665); 
					 t = CQL3Type.Native.BOOLEAN; 
					}
					break;
				case 5 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1509:7: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type10677); 
					 t = CQL3Type.Native.COUNTER; 
					}
					break;
				case 6 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1510:7: K_DECIMAL
					{
					match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type10689); 
					 t = CQL3Type.Native.DECIMAL; 
					}
					break;
				case 7 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1511:7: K_DOUBLE
					{
					match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type10701); 
					 t = CQL3Type.Native.DOUBLE; 
					}
					break;
				case 8 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1512:7: K_FLOAT
					{
					match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type10714); 
					 t = CQL3Type.Native.FLOAT; 
					}
					break;
				case 9 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1513:7: K_INET
					{
					match(input,K_INET,FOLLOW_K_INET_in_native_type10728); 
					 t = CQL3Type.Native.INET;
					}
					break;
				case 10 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1514:7: K_INT
					{
					match(input,K_INT,FOLLOW_K_INT_in_native_type10743); 
					 t = CQL3Type.Native.INT; 
					}
					break;
				case 11 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1515:7: K_SMALLINT
					{
					match(input,K_SMALLINT,FOLLOW_K_SMALLINT_in_native_type10759); 
					 t = CQL3Type.Native.SMALLINT; 
					}
					break;
				case 12 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1516:7: K_TEXT
					{
					match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type10770); 
					 t = CQL3Type.Native.TEXT; 
					}
					break;
				case 13 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1517:7: K_TIMESTAMP
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type10785); 
					 t = CQL3Type.Native.TIMESTAMP; 
					}
					break;
				case 14 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1518:7: K_TINYINT
					{
					match(input,K_TINYINT,FOLLOW_K_TINYINT_in_native_type10795); 
					 t = CQL3Type.Native.TINYINT; 
					}
					break;
				case 15 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1519:7: K_UUID
					{
					match(input,K_UUID,FOLLOW_K_UUID_in_native_type10807); 
					 t = CQL3Type.Native.UUID; 
					}
					break;
				case 16 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1520:7: K_VARCHAR
					{
					match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type10822); 
					 t = CQL3Type.Native.VARCHAR; 
					}
					break;
				case 17 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1521:7: K_VARINT
					{
					match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type10834); 
					 t = CQL3Type.Native.VARINT; 
					}
					break;
				case 18 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1522:7: K_TIMEUUID
					{
					match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type10847); 
					 t = CQL3Type.Native.TIMEUUID; 
					}
					break;
				case 19 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1523:7: K_DATE
					{
					match(input,K_DATE,FOLLOW_K_DATE_in_native_type10858); 
					 t = CQL3Type.Native.DATE; 
					}
					break;
				case 20 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1524:7: K_TIME
					{
					match(input,K_TIME,FOLLOW_K_TIME_in_native_type10873); 
					 t = CQL3Type.Native.TIME; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "native_type"



	// $ANTLR start "collection_type"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1527:1: collection_type returns [CQL3Type.Raw pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
	public final CQL3Type.Raw collection_type() throws RecognitionException {
		CQL3Type.Raw pt = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw t2 =null;
		CQL3Type.Raw t =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1528:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
			int alt191=3;
			switch ( input.LA(1) ) {
			case K_MAP:
				{
				alt191=1;
				}
				break;
			case K_LIST:
				{
				alt191=2;
				}
				break;
			case K_SET:
				{
				alt191=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 191, 0, input);
				throw nvae;
			}
			switch (alt191) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1528:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
					{
					match(input,K_MAP,FOLLOW_K_MAP_in_collection_type10901); 
					match(input,179,FOLLOW_179_in_collection_type10904); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10908);
					t1=comparatorType();
					state._fsp--;

					match(input,174,FOLLOW_174_in_collection_type10910); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10914);
					t2=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_collection_type10916); 

					            // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
					            if (t1 != null && t2 != null)
					                pt = CQL3Type.Raw.map(t1, t2);
					        
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1534:7: K_LIST '<' t= comparatorType '>'
					{
					match(input,K_LIST,FOLLOW_K_LIST_in_collection_type10934); 
					match(input,179,FOLLOW_179_in_collection_type10936); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10940);
					t=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_collection_type10942); 
					 if (t != null) pt = CQL3Type.Raw.list(t); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1536:7: K_SET '<' t= comparatorType '>'
					{
					match(input,K_SET,FOLLOW_K_SET_in_collection_type10960); 
					match(input,179,FOLLOW_179_in_collection_type10963); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10967);
					t=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_collection_type10969); 
					 if (t != null) pt = CQL3Type.Raw.set(t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pt;
	}
	// $ANTLR end "collection_type"



	// $ANTLR start "tuple_type"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1540:1: tuple_type returns [CQL3Type.Raw t] : K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' ;
	public final CQL3Type.Raw tuple_type() throws RecognitionException {
		CQL3Type.Raw t = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw tn =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1541:5: ( K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1541:7: K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>'
			{
			match(input,K_TUPLE,FOLLOW_K_TUPLE_in_tuple_type11000); 
			match(input,179,FOLLOW_179_in_tuple_type11002); 
			 List<CQL3Type.Raw> types = new ArrayList<>(); 
			pushFollow(FOLLOW_comparatorType_in_tuple_type11017);
			t1=comparatorType();
			state._fsp--;

			 types.add(t1); 
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1542:47: ( ',' tn= comparatorType )*
			loop192:
			while (true) {
				int alt192=2;
				int LA192_0 = input.LA(1);
				if ( (LA192_0==174) ) {
					alt192=1;
				}

				switch (alt192) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1542:48: ',' tn= comparatorType
					{
					match(input,174,FOLLOW_174_in_tuple_type11022); 
					pushFollow(FOLLOW_comparatorType_in_tuple_type11026);
					tn=comparatorType();
					state._fsp--;

					 types.add(tn); 
					}
					break;

				default :
					break loop192;
				}
			}

			match(input,182,FOLLOW_182_in_tuple_type11038); 
			 t = CQL3Type.Raw.tuple(types); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "tuple_type"


	public static class username_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "username"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1546:1: username : ( IDENT | STRING_LITERAL | QUOTED_NAME );
	public final CqlParser.username_return username() throws RecognitionException {
		CqlParser.username_return retval = new CqlParser.username_return();
		retval.start = input.LT(1);

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1547:5: ( IDENT | STRING_LITERAL | QUOTED_NAME )
			int alt193=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt193=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt193=2;
				}
				break;
			case QUOTED_NAME:
				{
				alt193=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 193, 0, input);
				throw nvae;
			}
			switch (alt193) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1547:7: IDENT
					{
					match(input,IDENT,FOLLOW_IDENT_in_username11057); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1548:7: STRING_LITERAL
					{
					match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_username11065); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1549:7: QUOTED_NAME
					{
					match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_username11073); 
					 addRecognitionError("Quoted strings are are not supported for user names and USER is deprecated, please use ROLE");
					}
					break;

			}
			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "username"



	// $ANTLR start "non_type_ident"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1554:1: non_type_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY );
	public final ColumnIdentifier non_type_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		Token kk=null;
		String k =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1555:5: (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY )
			int alt194=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt194=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt194=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INITCOND:
			case K_INPUT:
			case K_JSON:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				alt194=3;
				}
				break;
			case K_KEY:
				{
				alt194=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 194, 0, input);
				throw nvae;
			}
			switch (alt194) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1555:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_non_type_ident11100); 
					 if (reservedTypeNames.contains((t!=null?t.getText():null))) addRecognitionError("Invalid (reserved) user type name " + (t!=null?t.getText():null)); id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1556:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_non_type_ident11131); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1557:7: k= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_non_type_ident11156);
					k=basic_unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1558:7: kk= K_KEY
					{
					kk=(Token)match(input,K_KEY,FOLLOW_K_KEY_in_non_type_ident11168); 
					 id = new ColumnIdentifier((kk!=null?kk.getText():null), false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "non_type_ident"



	// $ANTLR start "unreserved_keyword"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1561:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) );
	public final String unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;
		String u =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1562:5: (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) )
			int alt195=2;
			int LA195_0 = input.LA(1);
			if ( ((LA195_0 >= K_AGGREGATE && LA195_0 <= K_ALL)||LA195_0==K_AS||LA195_0==K_ASCII||(LA195_0 >= K_BIGINT && LA195_0 <= K_BOOLEAN)||(LA195_0 >= K_CALLED && LA195_0 <= K_CLUSTERING)||(LA195_0 >= K_COMPACT && LA195_0 <= K_CONTAINS)||LA195_0==K_COUNTER||(LA195_0 >= K_CUSTOM && LA195_0 <= K_DECIMAL)||(LA195_0 >= K_DISTINCT && LA195_0 <= K_DOUBLE)||(LA195_0 >= K_EXISTS && LA195_0 <= K_FLOAT)||LA195_0==K_FROZEN||(LA195_0 >= K_FUNCTION && LA195_0 <= K_FUNCTIONS)||LA195_0==K_INET||(LA195_0 >= K_INITCOND && LA195_0 <= K_INPUT)||LA195_0==K_INT||LA195_0==K_JSON||LA195_0==K_KEYS||(LA195_0 >= K_KEYSPACES && LA195_0 <= K_LANGUAGE)||(LA195_0 >= K_LIST && LA195_0 <= K_MAP)||LA195_0==K_NOLOGIN||LA195_0==K_NOSUPERUSER||LA195_0==K_OPTIONS||(LA195_0 >= K_PASSWORD && LA195_0 <= K_PERMISSIONS)||LA195_0==K_RETURNS||(LA195_0 >= K_ROLE && LA195_0 <= K_ROLES)||(LA195_0 >= K_SFUNC && LA195_0 <= K_TINYINT)||LA195_0==K_TRIGGER||(LA195_0 >= K_TUPLE && LA195_0 <= K_TYPE)||(LA195_0 >= K_USER && LA195_0 <= K_USERS)||(LA195_0 >= K_UUID && LA195_0 <= K_VARINT)) ) {
				alt195=1;
			}
			else if ( (LA195_0==K_COUNT||LA195_0==K_KEY||LA195_0==K_TTL||LA195_0==K_WRITETIME) ) {
				alt195=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 195, 0, input);
				throw nvae;
			}

			switch (alt195) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1562:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword11211);
					u=unreserved_function_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1563:7: k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY )
					{
					k=input.LT(1);
					if ( input.LA(1)==K_COUNT||input.LA(1)==K_KEY||input.LA(1)==K_TTL||input.LA(1)==K_WRITETIME ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 str = (k!=null?k.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_keyword"



	// $ANTLR start "unreserved_function_keyword"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1566:1: unreserved_function_keyword returns [String str] : (u= basic_unreserved_keyword |t= native_type );
	public final String unreserved_function_keyword() throws RecognitionException {
		String str = null;


		String u =null;
		CQL3Type t =null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1567:5: (u= basic_unreserved_keyword |t= native_type )
			int alt196=2;
			int LA196_0 = input.LA(1);
			if ( ((LA196_0 >= K_AGGREGATE && LA196_0 <= K_ALL)||LA196_0==K_AS||(LA196_0 >= K_CALLED && LA196_0 <= K_CLUSTERING)||(LA196_0 >= K_COMPACT && LA196_0 <= K_CONTAINS)||LA196_0==K_CUSTOM||LA196_0==K_DISTINCT||(LA196_0 >= K_EXISTS && LA196_0 <= K_FINALFUNC)||LA196_0==K_FROZEN||(LA196_0 >= K_FUNCTION && LA196_0 <= K_FUNCTIONS)||(LA196_0 >= K_INITCOND && LA196_0 <= K_INPUT)||LA196_0==K_JSON||LA196_0==K_KEYS||(LA196_0 >= K_KEYSPACES && LA196_0 <= K_LANGUAGE)||(LA196_0 >= K_LIST && LA196_0 <= K_MAP)||LA196_0==K_NOLOGIN||LA196_0==K_NOSUPERUSER||LA196_0==K_OPTIONS||(LA196_0 >= K_PASSWORD && LA196_0 <= K_PERMISSIONS)||LA196_0==K_RETURNS||(LA196_0 >= K_ROLE && LA196_0 <= K_ROLES)||LA196_0==K_SFUNC||(LA196_0 >= K_STATIC && LA196_0 <= K_SUPERUSER)||LA196_0==K_TRIGGER||(LA196_0 >= K_TUPLE && LA196_0 <= K_TYPE)||(LA196_0 >= K_USER && LA196_0 <= K_USERS)||LA196_0==K_VALUES) ) {
				alt196=1;
			}
			else if ( (LA196_0==K_ASCII||(LA196_0 >= K_BIGINT && LA196_0 <= K_BOOLEAN)||LA196_0==K_COUNTER||(LA196_0 >= K_DATE && LA196_0 <= K_DECIMAL)||LA196_0==K_DOUBLE||LA196_0==K_FLOAT||LA196_0==K_INET||LA196_0==K_INT||LA196_0==K_SMALLINT||(LA196_0 >= K_TEXT && LA196_0 <= K_TINYINT)||LA196_0==K_UUID||(LA196_0 >= K_VARCHAR && LA196_0 <= K_VARINT)) ) {
				alt196=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 196, 0, input);
				throw nvae;
			}

			switch (alt196) {
				case 1 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1567:7: u= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword11266);
					u=basic_unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1568:7: t= native_type
					{
					pushFollow(FOLLOW_native_type_in_unreserved_function_keyword11278);
					t=native_type();
					state._fsp--;

					 str = t.toString(); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_function_keyword"



	// $ANTLR start "basic_unreserved_keyword"
	// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1571:1: basic_unreserved_keyword returns [String str] : k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_JSON | K_CALLED | K_INPUT ) ;
	public final String basic_unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;

		try {
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1572:5: (k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_JSON | K_CALLED | K_INPUT ) )
			// /tmp/tmp.W1C41Q5iN0/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1572:7: k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_JSON | K_CALLED | K_INPUT )
			{
			k=input.LT(1);
			if ( (input.LA(1) >= K_AGGREGATE && input.LA(1) <= K_ALL)||input.LA(1)==K_AS||(input.LA(1) >= K_CALLED && input.LA(1) <= K_CLUSTERING)||(input.LA(1) >= K_COMPACT && input.LA(1) <= K_CONTAINS)||input.LA(1)==K_CUSTOM||input.LA(1)==K_DISTINCT||(input.LA(1) >= K_EXISTS && input.LA(1) <= K_FINALFUNC)||input.LA(1)==K_FROZEN||(input.LA(1) >= K_FUNCTION && input.LA(1) <= K_FUNCTIONS)||(input.LA(1) >= K_INITCOND && input.LA(1) <= K_INPUT)||input.LA(1)==K_JSON||input.LA(1)==K_KEYS||(input.LA(1) >= K_KEYSPACES && input.LA(1) <= K_LANGUAGE)||(input.LA(1) >= K_LIST && input.LA(1) <= K_MAP)||input.LA(1)==K_NOLOGIN||input.LA(1)==K_NOSUPERUSER||input.LA(1)==K_OPTIONS||(input.LA(1) >= K_PASSWORD && input.LA(1) <= K_PERMISSIONS)||input.LA(1)==K_RETURNS||(input.LA(1) >= K_ROLE && input.LA(1) <= K_ROLES)||input.LA(1)==K_SFUNC||(input.LA(1) >= K_STATIC && input.LA(1) <= K_SUPERUSER)||input.LA(1)==K_TRIGGER||(input.LA(1) >= K_TUPLE && input.LA(1) <= K_TYPE)||(input.LA(1) >= K_USER && input.LA(1) <= K_USERS)||input.LA(1)==K_VALUES ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 str = (k!=null?k.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "basic_unreserved_keyword"

	// Delegated rules


	protected DFA2 dfa2 = new DFA2(this);
	protected DFA13 dfa13 = new DFA13(this);
	protected DFA40 dfa40 = new DFA40(this);
	protected DFA140 dfa140 = new DFA140(this);
	protected DFA141 dfa141 = new DFA141(this);
	protected DFA159 dfa159 = new DFA159(this);
	protected DFA161 dfa161 = new DFA161(this);
	protected DFA163 dfa163 = new DFA163(this);
	protected DFA165 dfa165 = new DFA165(this);
	protected DFA168 dfa168 = new DFA168(this);
	protected DFA174 dfa174 = new DFA174(this);
	protected DFA180 dfa180 = new DFA180(this);
	protected DFA179 dfa179 = new DFA179(this);
	protected DFA189 dfa189 = new DFA189(this);
	static final String DFA2_eotS =
		"\63\uffff";
	static final String DFA2_eofS =
		"\63\uffff";
	static final String DFA2_minS =
		"\1\34\7\uffff\2\31\1\53\2\24\1\32\10\uffff\1\155\22\uffff\1\144\2\uffff"+
		"\1\100\5\uffff\1\31";
	static final String DFA2_maxS =
		"\1\u0088\7\uffff\3\u0089\2\u00a0\1\u008a\10\uffff\1\155\22\uffff\1\177"+
		"\2\uffff\1\152\5\uffff\1\103";
	static final String DFA2_acceptS =
		"\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\6\uffff\1\10\1\11\1\23\1\27\1\31"+
		"\1\40\1\46\1\12\1\uffff\1\34\1\36\1\13\1\14\1\15\1\25\1\30\1\33\1\35\1"+
		"\37\1\42\1\47\1\16\1\17\1\24\1\32\1\41\1\50\1\uffff\1\20\1\44\1\uffff"+
		"\1\21\1\45\1\26\1\43\1\22\1\uffff";
	static final String DFA2_specialS =
		"\63\uffff}>";
	static final String[] DFA2_transitionS = {
			"\1\12\7\uffff\1\4\13\uffff\1\10\3\uffff\1\5\4\uffff\1\11\13\uffff\1\13"+
			"\7\uffff\1\2\12\uffff\1\15\26\uffff\1\14\2\uffff\1\1\17\uffff\1\7\4\uffff"+
			"\1\3\1\6",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\30\21\uffff\1\17\5\uffff\1\25\21\uffff\1\27\4\uffff\1\25\13\uffff"+
			"\1\16\6\uffff\1\24\12\uffff\1\26\11\uffff\1\23\20\uffff\1\21\3\uffff"+
			"\1\22\3\uffff\1\20",
			"\1\40\21\uffff\1\32\27\uffff\1\37\4\uffff\1\33\13\uffff\1\31\6\uffff"+
			"\1\42\24\uffff\1\41\20\uffff\1\35\3\uffff\1\36\3\uffff\1\34",
			"\1\43\50\uffff\1\44\6\uffff\1\50\24\uffff\1\47\24\uffff\1\46\3\uffff"+
			"\1\45",
			"\1\53\4\uffff\1\53\1\51\1\uffff\1\52\2\uffff\1\53\1\uffff\1\53\1\52"+
			"\2\uffff\3\53\1\uffff\2\53\1\uffff\4\53\1\52\3\53\2\uffff\1\52\2\53\1"+
			"\52\1\uffff\1\52\4\53\1\uffff\1\53\1\uffff\2\53\4\uffff\1\53\1\uffff"+
			"\2\53\1\uffff\1\53\2\uffff\3\53\1\uffff\2\53\1\uffff\3\53\1\uffff\1\52"+
			"\1\uffff\1\53\1\uffff\1\53\4\uffff\1\53\2\uffff\3\53\3\uffff\1\53\1\uffff"+
			"\2\53\1\52\1\uffff\13\53\2\uffff\1\53\1\uffff\3\53\3\uffff\2\53\1\uffff"+
			"\4\53\3\uffff\1\53\10\uffff\2\53\2\uffff\1\53",
			"\1\56\4\uffff\1\56\1\54\1\uffff\1\55\2\uffff\1\56\1\uffff\1\56\1\55"+
			"\2\uffff\3\56\1\uffff\2\56\1\uffff\4\56\1\55\3\56\2\uffff\1\55\2\56\1"+
			"\55\1\uffff\1\55\4\56\1\uffff\1\56\1\uffff\2\56\4\uffff\1\56\1\uffff"+
			"\2\56\1\uffff\1\56\2\uffff\3\56\1\uffff\2\56\1\uffff\3\56\1\uffff\1\55"+
			"\1\uffff\1\56\1\uffff\1\56\4\uffff\1\56\2\uffff\3\56\3\uffff\1\56\1\uffff"+
			"\2\56\1\55\1\uffff\13\56\2\uffff\1\56\1\uffff\3\56\3\uffff\2\56\1\uffff"+
			"\4\56\3\uffff\1\56\10\uffff\2\56\2\uffff\1\56",
			"\1\61\1\uffff\1\61\5\uffff\1\61\15\uffff\1\61\5\uffff\1\61\2\uffff\1"+
			"\61\1\uffff\1\61\40\uffff\1\61\24\uffff\1\60\1\61\27\uffff\1\57",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\62",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\52\5\uffff\1\52\24\uffff\1\53",
			"",
			"",
			"\1\56\43\uffff\1\55\5\uffff\1\55",
			"",
			"",
			"",
			"",
			"",
			"\1\30\51\uffff\1\27"
	};

	static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
	static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
	static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
	static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
	static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
	static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
	static final short[][] DFA2_transition;

	static {
		int numStates = DFA2_transitionS.length;
		DFA2_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
		}
	}

	protected class DFA2 extends DFA {

		public DFA2(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 2;
			this.eot = DFA2_eot;
			this.eof = DFA2_eof;
			this.min = DFA2_min;
			this.max = DFA2_max;
			this.accept = DFA2_accept;
			this.special = DFA2_special;
			this.transition = DFA2_transition;
		}
		@Override
		public String getDescription() {
			return "234:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement );";
		}
	}

	static final String DFA13_eotS =
		"\73\uffff";
	static final String DFA13_eofS =
		"\73\uffff";
	static final String DFA13_minS =
		"\1\24\33\37\1\uffff\1\24\1\uffff\1\24\2\uffff\30\37\1\uffff";
	static final String DFA13_maxS =
		"\1\u009d\33\u00b0\1\uffff\1\u009d\1\uffff\1\u00b9\2\uffff\30\u00b0\1\uffff";
	static final String DFA13_acceptS =
		"\34\uffff\1\5\1\uffff\1\1\1\uffff\1\3\1\4\30\uffff\1\2";
	static final String DFA13_specialS =
		"\73\uffff}>";
	static final String[] DFA13_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\33\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\34\1\3\1\uffff\1\32\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\31\10\uffff\1\34\1\2",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\37\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\40\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\41\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\153\uffff\1\36\1\uffff\1\36\1\uffff\1\35",
			"",
			"\1\42\4\uffff\2\44\4\uffff\1\44\1\uffff\1\45\3\uffff\1\46\1\47\1\50"+
			"\1\uffff\2\44\1\uffff\2\44\1\71\1\51\1\uffff\1\44\1\67\1\52\3\uffff\1"+
			"\44\1\53\3\uffff\3\44\1\54\1\uffff\1\44\1\uffff\2\44\4\uffff\1\55\1\uffff"+
			"\2\44\1\uffff\1\56\2\uffff\1\44\1\36\1\44\1\uffff\2\44\1\uffff\3\44\3"+
			"\uffff\1\44\1\uffff\1\44\4\uffff\1\44\2\uffff\3\44\3\uffff\1\44\1\uffff"+
			"\2\44\2\uffff\1\44\1\57\4\44\1\60\1\70\1\61\1\66\1\62\1\uffff\1\34\1"+
			"\44\1\uffff\1\36\2\44\3\uffff\2\44\1\uffff\1\63\1\44\1\64\1\65\3\uffff"+
			"\1\36\11\uffff\1\43",
			"",
			"\1\34\1\72\3\uffff\2\34\4\uffff\1\34\1\uffff\1\34\3\uffff\3\34\1\uffff"+
			"\2\34\1\uffff\4\34\1\uffff\3\34\3\uffff\2\34\3\uffff\4\34\1\uffff\1\34"+
			"\1\uffff\2\34\4\uffff\1\34\1\uffff\2\34\1\uffff\1\34\2\uffff\3\34\1\uffff"+
			"\2\34\1\uffff\3\34\3\uffff\1\34\1\uffff\1\34\4\uffff\1\34\2\uffff\3\34"+
			"\3\uffff\1\34\1\uffff\2\34\2\uffff\13\34\1\uffff\2\34\1\uffff\3\34\3"+
			"\uffff\2\34\1\uffff\4\34\3\uffff\1\34\10\uffff\2\34\16\uffff\1\34\14"+
			"\uffff\1\72",
			"",
			"",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\34\1\36\1\uffff\1\36\1\uffff\1\36",
			""
	};

	static final short[] DFA13_eot = DFA.unpackEncodedString(DFA13_eotS);
	static final short[] DFA13_eof = DFA.unpackEncodedString(DFA13_eofS);
	static final char[] DFA13_min = DFA.unpackEncodedStringToUnsignedChars(DFA13_minS);
	static final char[] DFA13_max = DFA.unpackEncodedStringToUnsignedChars(DFA13_maxS);
	static final short[] DFA13_accept = DFA.unpackEncodedString(DFA13_acceptS);
	static final short[] DFA13_special = DFA.unpackEncodedString(DFA13_specialS);
	static final short[][] DFA13_transition;

	static {
		int numStates = DFA13_transitionS.length;
		DFA13_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA13_transition[i] = DFA.unpackEncodedString(DFA13_transitionS[i]);
		}
	}

	protected class DFA13 extends DFA {

		public DFA13(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 13;
			this.eot = DFA13_eot;
			this.eof = DFA13_eof;
			this.min = DFA13_min;
			this.max = DFA13_max;
			this.accept = DFA13_accept;
			this.special = DFA13_special;
			this.transition = DFA13_transition;
		}
		@Override
		public String getDescription() {
			return "328:8: (c= cident | K_COUNT '(' countArgument ')' | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs )";
		}
	}

	static final String DFA40_eotS =
		"\33\uffff";
	static final String DFA40_eofS =
		"\33\uffff";
	static final String DFA40_minS =
		"\1\24\30\100\2\uffff";
	static final String DFA40_maxS =
		"\1\u009d\30\u00b8\2\uffff";
	static final String DFA40_acceptS =
		"\31\uffff\1\1\1\2";
	static final String DFA40_specialS =
		"\33\uffff}>";
	static final String[] DFA40_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\11\uffff\1\2",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"",
			""
	};

	static final short[] DFA40_eot = DFA.unpackEncodedString(DFA40_eotS);
	static final short[] DFA40_eof = DFA.unpackEncodedString(DFA40_eofS);
	static final char[] DFA40_min = DFA.unpackEncodedStringToUnsignedChars(DFA40_minS);
	static final char[] DFA40_max = DFA.unpackEncodedStringToUnsignedChars(DFA40_maxS);
	static final short[] DFA40_accept = DFA.unpackEncodedString(DFA40_acceptS);
	static final short[] DFA40_special = DFA.unpackEncodedString(DFA40_specialS);
	static final short[][] DFA40_transition;

	static {
		int numStates = DFA40_transitionS.length;
		DFA40_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA40_transition[i] = DFA.unpackEncodedString(DFA40_transitionS[i]);
		}
	}

	protected class DFA40 extends DFA {

		public DFA40(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 40;
			this.eot = DFA40_eot;
			this.eof = DFA40_eof;
			this.min = DFA40_min;
			this.max = DFA40_max;
			this.accept = DFA40_accept;
			this.special = DFA40_special;
			this.transition = DFA40_transition;
		}
		@Override
		public String getDescription() {
			return "486:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' );";
		}
	}

	static final String DFA140_eotS =
		"\34\uffff";
	static final String DFA140_eofS =
		"\1\uffff\31\33\2\uffff";
	static final String DFA140_minS =
		"\1\24\31\u00b0\2\uffff";
	static final String DFA140_maxS =
		"\1\u009d\31\u00b2\2\uffff";
	static final String DFA140_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA140_specialS =
		"\34\uffff}>";
	static final String[] DFA140_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\10\uffff\1\31\1\2",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"",
			""
	};

	static final short[] DFA140_eot = DFA.unpackEncodedString(DFA140_eotS);
	static final short[] DFA140_eof = DFA.unpackEncodedString(DFA140_eofS);
	static final char[] DFA140_min = DFA.unpackEncodedStringToUnsignedChars(DFA140_minS);
	static final char[] DFA140_max = DFA.unpackEncodedStringToUnsignedChars(DFA140_maxS);
	static final short[] DFA140_accept = DFA.unpackEncodedString(DFA140_acceptS);
	static final short[] DFA140_special = DFA.unpackEncodedString(DFA140_specialS);
	static final short[][] DFA140_transition;

	static {
		int numStates = DFA140_transitionS.length;
		DFA140_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA140_transition[i] = DFA.unpackEncodedString(DFA140_transitionS[i]);
		}
	}

	protected class DFA140 extends DFA {

		public DFA140(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 140;
			this.eot = DFA140_eot;
			this.eof = DFA140_eof;
			this.min = DFA140_min;
			this.max = DFA140_max;
			this.accept = DFA140_accept;
			this.special = DFA140_special;
			this.transition = DFA140_transition;
		}
		@Override
		public String getDescription() {
			return "1184:7: ( ksName[name] '.' )?";
		}
	}

	static final String DFA141_eotS =
		"\34\uffff";
	static final String DFA141_eofS =
		"\1\uffff\31\33\2\uffff";
	static final String DFA141_minS =
		"\1\24\31\30\2\uffff";
	static final String DFA141_maxS =
		"\1\u009d\31\u00b2\2\uffff";
	static final String DFA141_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA141_specialS =
		"\34\uffff}>";
	static final String[] DFA141_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\10\uffff\1\31\1\2",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"",
			""
	};

	static final short[] DFA141_eot = DFA.unpackEncodedString(DFA141_eotS);
	static final short[] DFA141_eof = DFA.unpackEncodedString(DFA141_eofS);
	static final char[] DFA141_min = DFA.unpackEncodedStringToUnsignedChars(DFA141_minS);
	static final char[] DFA141_max = DFA.unpackEncodedStringToUnsignedChars(DFA141_maxS);
	static final short[] DFA141_accept = DFA.unpackEncodedString(DFA141_acceptS);
	static final short[] DFA141_special = DFA.unpackEncodedString(DFA141_specialS);
	static final short[][] DFA141_transition;

	static {
		int numStates = DFA141_transitionS.length;
		DFA141_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA141_transition[i] = DFA.unpackEncodedString(DFA141_transitionS[i]);
		}
	}

	protected class DFA141 extends DFA {

		public DFA141(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 141;
			this.eot = DFA141_eot;
			this.eof = DFA141_eof;
			this.min = DFA141_min;
			this.max = DFA141_max;
			this.accept = DFA141_accept;
			this.special = DFA141_special;
			this.transition = DFA141_transition;
		}
		@Override
		public String getDescription() {
			return "1189:7: ( ksName[name] '.' )?";
		}
	}

	static final String DFA159_eotS =
		"\42\uffff";
	static final String DFA159_eofS =
		"\42\uffff";
	static final String DFA159_minS =
		"\1\6\2\uffff\1\6\4\uffff\30\u00ab\1\u00b0\1\uffff";
	static final String DFA159_maxS =
		"\1\u00bb\2\uffff\1\u00bc\4\uffff\31\u00b1\1\uffff";
	static final String DFA159_acceptS =
		"\1\uffff\1\1\1\2\1\uffff\1\4\1\5\1\6\1\7\31\uffff\1\3";
	static final String DFA159_specialS =
		"\42\uffff}>";
	static final String[] DFA159_transitionS = {
			"\1\1\7\uffff\1\1\3\uffff\1\1\2\uffff\1\1\64\uffff\1\1\22\uffff\1\1\4"+
			"\uffff\1\5\71\uffff\1\7\3\uffff\1\1\2\uffff\1\1\7\uffff\1\4\3\uffff\1"+
			"\1\1\uffff\1\6\6\uffff\1\2\2\uffff\1\3",
			"",
			"",
			"\1\2\7\uffff\1\2\3\uffff\1\2\1\uffff\1\10\1\2\3\uffff\2\12\4\uffff\1"+
			"\12\1\uffff\1\13\3\uffff\1\14\1\15\1\16\1\uffff\2\12\1\uffff\2\12\1\37"+
			"\1\17\1\uffff\1\12\1\35\1\20\3\uffff\1\12\1\21\3\uffff\3\12\1\22\1\uffff"+
			"\1\12\1\uffff\2\12\4\uffff\1\23\1\2\2\12\1\uffff\1\24\2\uffff\1\12\1"+
			"\40\1\12\1\uffff\2\12\1\uffff\3\12\2\uffff\1\2\1\12\1\uffff\1\12\1\uffff"+
			"\1\2\2\uffff\1\12\2\uffff\3\12\3\uffff\1\12\1\uffff\2\12\2\uffff\1\12"+
			"\1\25\4\12\1\26\1\36\1\27\1\34\1\30\1\uffff\1\2\1\12\1\uffff\1\40\2\12"+
			"\3\uffff\2\12\1\uffff\1\31\1\12\1\32\1\33\3\uffff\1\40\10\uffff\1\2\1"+
			"\11\2\uffff\1\2\2\uffff\1\2\7\uffff\1\2\3\uffff\1\2\1\uffff\1\2\6\uffff"+
			"\1\2\2\uffff\2\2",
			"",
			"",
			"",
			"",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\1\41",
			""
	};

	static final short[] DFA159_eot = DFA.unpackEncodedString(DFA159_eotS);
	static final short[] DFA159_eof = DFA.unpackEncodedString(DFA159_eofS);
	static final char[] DFA159_min = DFA.unpackEncodedStringToUnsignedChars(DFA159_minS);
	static final char[] DFA159_max = DFA.unpackEncodedStringToUnsignedChars(DFA159_maxS);
	static final short[] DFA159_accept = DFA.unpackEncodedString(DFA159_acceptS);
	static final short[] DFA159_special = DFA.unpackEncodedString(DFA159_specialS);
	static final short[][] DFA159_transition;

	static {
		int numStates = DFA159_transitionS.length;
		DFA159_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA159_transition[i] = DFA.unpackEncodedString(DFA159_transitionS[i]);
		}
	}

	protected class DFA159 extends DFA {

		public DFA159(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 159;
			this.eot = DFA159_eot;
			this.eof = DFA159_eof;
			this.min = DFA159_min;
			this.max = DFA159_max;
			this.accept = DFA159_accept;
			this.special = DFA159_special;
			this.transition = DFA159_transition;
		}
		@Override
		public String getDescription() {
			return "1278:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK );";
		}
	}

	static final String DFA161_eotS =
		"\33\uffff";
	static final String DFA161_eofS =
		"\1\uffff\30\32\2\uffff";
	static final String DFA161_minS =
		"\1\24\30\u00ab\2\uffff";
	static final String DFA161_maxS =
		"\1\u009d\30\u00b2\2\uffff";
	static final String DFA161_acceptS =
		"\31\uffff\1\1\1\2";
	static final String DFA161_specialS =
		"\33\uffff}>";
	static final String[] DFA161_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\31\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\32\1\3\1\uffff\1\31\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\31\10\uffff\1\31\1\2",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\4\uffff\1\31\1\uffff\1\32",
			"",
			""
	};

	static final short[] DFA161_eot = DFA.unpackEncodedString(DFA161_eotS);
	static final short[] DFA161_eof = DFA.unpackEncodedString(DFA161_eofS);
	static final char[] DFA161_min = DFA.unpackEncodedStringToUnsignedChars(DFA161_minS);
	static final char[] DFA161_max = DFA.unpackEncodedStringToUnsignedChars(DFA161_maxS);
	static final short[] DFA161_accept = DFA.unpackEncodedString(DFA161_acceptS);
	static final short[] DFA161_special = DFA.unpackEncodedString(DFA161_specialS);
	static final short[][] DFA161_transition;

	static {
		int numStates = DFA161_transitionS.length;
		DFA161_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA161_transition[i] = DFA.unpackEncodedString(DFA161_transitionS[i]);
		}
	}

	protected class DFA161 extends DFA {

		public DFA161(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 161;
			this.eot = DFA161_eot;
			this.eof = DFA161_eof;
			this.min = DFA161_min;
			this.max = DFA161_max;
			this.accept = DFA161_accept;
			this.special = DFA161_special;
			this.transition = DFA161_transition;
		}
		@Override
		public String getDescription() {
			return "1296:7: (ks= keyspaceName '.' )?";
		}
	}

	static final String DFA163_eotS =
		"\70\uffff";
	static final String DFA163_eofS =
		"\70\uffff";
	static final String DFA163_minS =
		"\1\24\30\u00ab\1\u00b0\1\u00ab\1\u00b0\1\24\1\6\30\u00ab\2\uffff";
	static final String DFA163_maxS =
		"\1\u009d\31\u00b0\1\u00ab\1\u00b0\1\u009d\1\u00bb\30\u00ab\2\uffff";
	static final String DFA163_acceptS =
		"\66\uffff\1\1\1\2";
	static final String DFA163_specialS =
		"\70\uffff}>";
	static final String[] DFA163_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\33\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\32\1\3\1\uffff\1\33\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\33\10\uffff\1\31\1\2",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\34",
			"\1\35",
			"\1\34",
			"\1\36\4\uffff\2\40\4\uffff\1\40\1\uffff\1\41\3\uffff\1\42\1\43\1\44"+
			"\1\uffff\2\40\1\uffff\2\40\1\65\1\45\1\uffff\1\40\1\63\1\46\3\uffff\1"+
			"\40\1\47\3\uffff\3\40\1\50\1\uffff\1\40\1\uffff\2\40\4\uffff\1\51\1\uffff"+
			"\2\40\1\uffff\1\52\2\uffff\1\40\1\uffff\1\40\1\uffff\2\40\1\uffff\3\40"+
			"\3\uffff\1\40\1\uffff\1\40\4\uffff\1\40\2\uffff\3\40\3\uffff\1\40\1\uffff"+
			"\2\40\2\uffff\1\40\1\53\4\40\1\54\1\64\1\55\1\62\1\56\1\uffff\1\32\1"+
			"\40\2\uffff\2\40\3\uffff\2\40\1\uffff\1\57\1\40\1\60\1\61\15\uffff\1"+
			"\37",
			"\1\67\7\uffff\1\67\3\uffff\1\67\1\uffff\2\67\3\uffff\2\67\4\uffff\1"+
			"\67\1\uffff\1\67\3\uffff\3\67\1\uffff\2\67\1\uffff\4\67\1\uffff\3\67"+
			"\3\uffff\2\67\3\uffff\4\67\1\uffff\1\67\1\uffff\2\67\4\uffff\4\67\1\uffff"+
			"\1\67\2\uffff\3\67\1\uffff\2\67\1\uffff\3\67\2\uffff\2\67\1\uffff\1\67"+
			"\1\uffff\1\67\2\uffff\1\67\2\uffff\3\67\3\uffff\1\67\1\uffff\2\67\2\uffff"+
			"\13\67\1\uffff\2\67\1\uffff\3\67\3\uffff\2\67\1\uffff\4\67\3\uffff\1"+
			"\67\10\uffff\2\67\2\uffff\1\67\2\uffff\1\67\7\uffff\1\67\1\66\2\uffff"+
			"\1\67\1\uffff\1\67\6\uffff\1\67\2\uffff\1\67",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"",
			""
	};

	static final short[] DFA163_eot = DFA.unpackEncodedString(DFA163_eotS);
	static final short[] DFA163_eof = DFA.unpackEncodedString(DFA163_eofS);
	static final char[] DFA163_min = DFA.unpackEncodedStringToUnsignedChars(DFA163_minS);
	static final char[] DFA163_max = DFA.unpackEncodedStringToUnsignedChars(DFA163_maxS);
	static final short[] DFA163_accept = DFA.unpackEncodedString(DFA163_acceptS);
	static final short[] DFA163_special = DFA.unpackEncodedString(DFA163_specialS);
	static final short[][] DFA163_transition;

	static {
		int numStates = DFA163_transitionS.length;
		DFA163_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA163_transition[i] = DFA.unpackEncodedString(DFA163_transitionS[i]);
		}
	}

	protected class DFA163 extends DFA {

		public DFA163(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 163;
			this.eot = DFA163_eot;
			this.eof = DFA163_eof;
			this.min = DFA163_min;
			this.max = DFA163_max;
			this.accept = DFA163_accept;
			this.special = DFA163_special;
			this.transition = DFA163_transition;
		}
		@Override
		public String getDescription() {
			return "1307:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );";
		}
	}

	static final String DFA165_eotS =
		"\104\uffff";
	static final String DFA165_eofS =
		"\3\uffff\1\1\41\uffff\1\1\5\uffff\31\41";
	static final String DFA165_minS =
		"\1\6\1\uffff\1\6\1\33\1\uffff\1\u00ac\30\u00ab\1\u00ac\2\u00ab\1\uffff"+
		"\1\u00ab\1\u00b0\1\u00ab\1\6\1\24\1\6\3\u00ab\31\33";
	static final String DFA165_maxS =
		"\1\u00bb\1\uffff\1\u00bb\1\u00bc\1\uffff\1\u00ae\2\u00b0\1\u00b3\26\u00b0"+
		"\2\u00b3\1\uffff\1\u00b3\2\u00b0\1\u00bc\1\u009d\1\u00bb\3\u00ac\31\u00bc";
	static final String DFA165_acceptS =
		"\1\uffff\1\1\2\uffff\1\2\34\uffff\1\3\42\uffff";
	static final String DFA165_specialS =
		"\104\uffff}>";
	static final String[] DFA165_transitionS = {
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\4\1\1\3\uffff\2\4\4\uffff\1\4"+
			"\1\uffff\1\4\3\uffff\3\4\1\uffff\2\4\1\uffff\4\4\1\uffff\3\4\3\uffff"+
			"\2\4\3\uffff\4\4\1\uffff\1\4\1\uffff\2\4\4\uffff\1\4\1\1\2\4\1\uffff"+
			"\1\4\2\uffff\3\4\1\uffff\2\4\1\uffff\3\4\2\uffff\1\1\1\4\1\uffff\1\4"+
			"\1\uffff\1\1\2\uffff\1\4\2\uffff\3\4\3\uffff\1\4\1\uffff\2\4\2\uffff"+
			"\13\4\1\uffff\2\4\1\uffff\3\4\3\uffff\2\4\1\uffff\4\4\3\uffff\1\4\10"+
			"\uffff\1\3\1\4\2\uffff\1\1\2\uffff\1\1\7\uffff\1\2\3\uffff\1\1\1\uffff"+
			"\1\1\6\uffff\1\1\2\uffff\1\1",
			"",
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\6\1\1\3\uffff\2\44\4\uffff\1"+
			"\44\1\uffff\1\11\3\uffff\1\12\1\13\1\14\1\uffff\2\44\1\uffff\2\44\1\35"+
			"\1\15\1\uffff\1\44\1\33\1\16\3\uffff\1\44\1\17\3\uffff\3\44\1\20\1\uffff"+
			"\1\42\1\uffff\2\44\4\uffff\1\21\1\1\2\44\1\uffff\1\22\2\uffff\1\44\1"+
			"\36\1\44\1\uffff\2\44\1\uffff\1\37\1\44\1\10\2\uffff\1\1\1\44\1\uffff"+
			"\1\44\1\uffff\1\1\2\uffff\1\44\2\uffff\3\44\3\uffff\1\44\1\uffff\2\44"+
			"\1\uffff\1\41\1\44\1\23\4\44\1\24\1\34\1\25\1\32\1\26\1\uffff\1\1\1\44"+
			"\1\uffff\1\43\1\40\1\44\3\uffff\2\44\1\uffff\1\27\1\44\1\30\1\31\3\uffff"+
			"\1\43\10\uffff\1\1\1\7\2\uffff\1\5\2\uffff\1\1\7\uffff\1\1\3\uffff\1"+
			"\1\1\uffff\1\1\6\uffff\1\1\2\uffff\1\1",
			"\1\1\1\uffff\2\1\25\uffff\1\1\21\uffff\1\1\6\uffff\1\1\11\uffff\1\1"+
			"\17\uffff\1\1\37\uffff\1\1\11\uffff\1\1\32\uffff\3\1\1\uffff\1\4\2\1"+
			"\7\uffff\1\1\1\uffff\1\1",
			"",
			"\1\45\1\uffff\1\1",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\4\uffff\1\46",
			"\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\41\7\uffff\1\41\3\uffff\1\41\1\uffff\2\41\3\uffff\2\41\1\1\1\uffff"+
			"\2\1\1\41\1\uffff\1\41\3\uffff\3\41\1\uffff\2\41\1\uffff\4\41\1\uffff"+
			"\3\41\1\1\2\uffff\2\41\3\uffff\4\41\1\uffff\1\41\1\uffff\2\41\1\uffff"+
			"\1\1\2\uffff\4\41\1\1\1\41\2\uffff\3\41\1\uffff\2\41\1\1\3\41\2\uffff"+
			"\2\41\1\uffff\1\41\1\uffff\1\41\2\uffff\1\41\1\uffff\1\1\3\41\3\uffff"+
			"\1\41\1\uffff\2\41\2\uffff\13\41\1\uffff\2\41\1\uffff\3\41\1\uffff\1"+
			"\1\1\uffff\2\41\1\uffff\4\41\1\uffff\1\1\1\uffff\1\41\10\uffff\2\41\2"+
			"\uffff\1\41\2\uffff\1\41\7\uffff\1\41\3\1\1\41\1\uffff\1\47\1\1\5\uffff"+
			"\1\41\1\uffff\1\1\1\41\1\1",
			"\1\50\4\uffff\2\52\4\uffff\1\52\1\uffff\1\1\3\uffff\3\1\1\uffff\2\52"+
			"\1\uffff\2\52\2\1\1\uffff\1\52\2\1\3\uffff\1\52\1\1\3\uffff\3\52\1\1"+
			"\1\uffff\1\52\1\uffff\2\52\4\uffff\1\1\1\uffff\2\52\1\uffff\1\1\2\uffff"+
			"\1\52\1\41\1\52\1\uffff\2\52\1\uffff\3\52\3\uffff\1\52\1\uffff\1\52\4"+
			"\uffff\1\52\2\uffff\3\52\3\uffff\1\52\1\uffff\2\52\2\uffff\1\52\1\1\4"+
			"\52\5\1\1\uffff\1\1\1\52\2\uffff\2\52\3\uffff\2\52\1\uffff\1\1\1\52\2"+
			"\1\15\uffff\1\51",
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\53\1\1\3\uffff\2\55\4\uffff\1"+
			"\55\1\uffff\1\56\3\uffff\1\57\1\60\1\61\1\uffff\2\55\1\uffff\2\55\1\102"+
			"\1\62\1\uffff\1\55\1\100\1\63\3\uffff\1\55\1\64\3\uffff\3\55\1\65\1\uffff"+
			"\1\55\1\uffff\2\55\4\uffff\1\66\1\1\2\55\1\uffff\1\67\2\uffff\1\55\1"+
			"\103\1\55\1\uffff\2\55\1\uffff\3\55\2\uffff\1\1\1\55\1\uffff\1\55\1\uffff"+
			"\1\1\2\uffff\1\55\2\uffff\3\55\3\uffff\1\55\1\uffff\2\55\2\uffff\1\55"+
			"\1\70\4\55\1\71\1\101\1\72\1\77\1\73\1\uffff\1\1\1\55\1\uffff\1\103\2"+
			"\55\3\uffff\2\55\1\uffff\1\74\1\55\1\75\1\76\3\uffff\1\103\10\uffff\1"+
			"\1\1\54\2\uffff\1\1\2\uffff\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\1\6"+
			"\uffff\1\1\2\uffff\1\1",
			"\1\1\1\41",
			"\1\1\1\41",
			"\1\1\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\32\uffff\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41"
	};

	static final short[] DFA165_eot = DFA.unpackEncodedString(DFA165_eotS);
	static final short[] DFA165_eof = DFA.unpackEncodedString(DFA165_eofS);
	static final char[] DFA165_min = DFA.unpackEncodedStringToUnsignedChars(DFA165_minS);
	static final char[] DFA165_max = DFA.unpackEncodedStringToUnsignedChars(DFA165_maxS);
	static final short[] DFA165_accept = DFA.unpackEncodedString(DFA165_acceptS);
	static final short[] DFA165_special = DFA.unpackEncodedString(DFA165_specialS);
	static final short[][] DFA165_transition;

	static {
		int numStates = DFA165_transitionS.length;
		DFA165_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA165_transition[i] = DFA.unpackEncodedString(DFA165_transitionS[i]);
		}
	}

	protected class DFA165 extends DFA {

		public DFA165(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 165;
			this.eot = DFA165_eot;
			this.eof = DFA165_eof;
			this.min = DFA165_min;
			this.max = DFA165_max;
			this.accept = DFA165_accept;
			this.special = DFA165_special;
			this.transition = DFA165_transition;
		}
		@Override
		public String getDescription() {
			return "1317:1: term returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= term );";
		}
	}

	static final String DFA168_eotS =
		"\35\uffff";
	static final String DFA168_eofS =
		"\35\uffff";
	static final String DFA168_minS =
		"\1\6\1\uffff\31\25\2\uffff";
	static final String DFA168_maxS =
		"\1\u00bb\1\uffff\31\u00b0\2\uffff";
	static final String DFA168_acceptS =
		"\1\uffff\1\1\31\uffff\1\2\1\3";
	static final String DFA168_specialS =
		"\35\uffff}>";
	static final String[] DFA168_transitionS = {
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\2\1\1\3\uffff\2\4\4\uffff\1\4"+
			"\1\uffff\1\5\3\uffff\1\6\1\7\1\10\1\uffff\2\4\1\uffff\2\4\1\31\1\11\1"+
			"\uffff\1\4\1\27\1\12\3\uffff\1\4\1\13\3\uffff\3\4\1\14\1\uffff\1\4\1"+
			"\uffff\2\4\4\uffff\1\15\1\1\2\4\1\uffff\1\16\2\uffff\1\4\1\32\1\4\1\uffff"+
			"\2\4\1\uffff\3\4\2\uffff\1\1\1\4\1\uffff\1\4\1\uffff\1\1\2\uffff\1\4"+
			"\2\uffff\3\4\3\uffff\1\4\1\uffff\2\4\2\uffff\1\4\1\17\4\4\1\20\1\30\1"+
			"\21\1\26\1\22\1\uffff\1\1\1\4\1\uffff\1\32\2\4\3\uffff\2\4\1\uffff\1"+
			"\23\1\4\1\24\1\25\3\uffff\1\32\10\uffff\1\1\1\3\2\uffff\1\1\2\uffff\1"+
			"\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\1\6\uffff\1\1\2\uffff\1\1",
			"",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0097\uffff\1\33\1\uffff\1\33\1\1",
			"",
			""
	};

	static final short[] DFA168_eot = DFA.unpackEncodedString(DFA168_eotS);
	static final short[] DFA168_eof = DFA.unpackEncodedString(DFA168_eofS);
	static final char[] DFA168_min = DFA.unpackEncodedStringToUnsignedChars(DFA168_minS);
	static final char[] DFA168_max = DFA.unpackEncodedStringToUnsignedChars(DFA168_maxS);
	static final short[] DFA168_accept = DFA.unpackEncodedString(DFA168_acceptS);
	static final short[] DFA168_special = DFA.unpackEncodedString(DFA168_specialS);
	static final short[][] DFA168_transition;

	static {
		int numStates = DFA168_transitionS.length;
		DFA168_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA168_transition[i] = DFA.unpackEncodedString(DFA168_transitionS[i]);
		}
	}

	protected class DFA168 extends DFA {

		public DFA168(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 168;
			this.eot = DFA168_eot;
			this.eof = DFA168_eof;
			this.min = DFA168_min;
			this.max = DFA168_max;
			this.accept = DFA168_accept;
			this.special = DFA168_special;
			this.transition = DFA168_transition;
		}
		@Override
		public String getDescription() {
			return "1332:1: normalColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );";
		}
	}

	static final String DFA174_eotS =
		"\34\uffff";
	static final String DFA174_eofS =
		"\34\uffff";
	static final String DFA174_minS =
		"\1\24\30\u00b5\1\6\2\uffff";
	static final String DFA174_maxS =
		"\1\u009d\30\u00b5\1\u00bb\2\uffff";
	static final String DFA174_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA174_specialS =
		"\34\uffff}>";
	static final String[] DFA174_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\11\uffff\1\2",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\32\7\uffff\1\32\3\uffff\1\32\2\uffff\1\32\3\uffff\2\32\4\uffff\1"+
			"\32\1\uffff\1\32\3\uffff\3\32\1\uffff\2\32\1\uffff\4\32\1\uffff\3\32"+
			"\3\uffff\2\32\3\uffff\4\32\1\uffff\1\32\1\uffff\2\32\4\uffff\4\32\1\uffff"+
			"\1\32\2\uffff\3\32\1\uffff\2\32\1\uffff\3\32\2\uffff\2\32\1\uffff\1\32"+
			"\4\uffff\1\32\2\uffff\3\32\3\uffff\1\32\1\uffff\2\32\2\uffff\13\32\2"+
			"\uffff\1\32\1\uffff\3\32\3\uffff\2\32\1\uffff\4\32\3\uffff\1\32\14\uffff"+
			"\1\32\2\uffff\1\32\13\uffff\1\32\13\uffff\1\33",
			"",
			""
	};

	static final short[] DFA174_eot = DFA.unpackEncodedString(DFA174_eotS);
	static final short[] DFA174_eof = DFA.unpackEncodedString(DFA174_eofS);
	static final char[] DFA174_min = DFA.unpackEncodedStringToUnsignedChars(DFA174_minS);
	static final char[] DFA174_max = DFA.unpackEncodedStringToUnsignedChars(DFA174_maxS);
	static final short[] DFA174_accept = DFA.unpackEncodedString(DFA174_acceptS);
	static final short[] DFA174_special = DFA.unpackEncodedString(DFA174_specialS);
	static final short[][] DFA174_transition;

	static {
		int numStates = DFA174_transitionS.length;
		DFA174_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA174_transition[i] = DFA.unpackEncodedString(DFA174_transitionS[i]);
		}
	}

	protected class DFA174 extends DFA {

		public DFA174(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 174;
			this.eot = DFA174_eot;
			this.eof = DFA174_eof;
			this.min = DFA174_min;
			this.max = DFA174_max;
			this.accept = DFA174_accept;
			this.special = DFA174_special;
			this.transition = DFA174_transition;
		}
		@Override
		public String getDescription() {
			return "1391:1: property[PropertyDefinitions props] : (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= mapLiteral );";
		}
	}

	static final String DFA180_eotS =
		"\73\uffff";
	static final String DFA180_eofS =
		"\73\uffff";
	static final String DFA180_minS =
		"\1\24\30\55\1\uffff\1\24\1\uffff\1\u009c\2\uffff\30\55\4\uffff";
	static final String DFA180_maxS =
		"\1\u00ab\30\u00b8\1\uffff\1\u00ab\1\uffff\1\u00b1\2\uffff\30\u00b8\4\uffff";
	static final String DFA180_acceptS =
		"\31\uffff\1\2\1\uffff\1\1\1\uffff\1\5\1\6\30\uffff\1\10\1\3\1\4\1\7";
	static final String DFA180_specialS =
		"\73\uffff}>";
	static final String[] DFA180_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\31\1\3\1\uffff\1\30\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\11\uffff\1\2\15\uffff\1"+
			"\32",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"",
			"\1\37\4\uffff\2\41\4\uffff\1\41\1\uffff\1\42\3\uffff\1\43\1\44\1\45"+
			"\1\uffff\2\41\1\uffff\2\41\1\66\1\46\1\uffff\1\41\1\64\1\47\3\uffff\1"+
			"\41\1\50\3\uffff\3\41\1\51\1\uffff\1\41\1\uffff\2\41\4\uffff\1\52\1\uffff"+
			"\2\41\1\uffff\1\53\2\uffff\1\41\1\66\1\41\1\uffff\2\41\1\uffff\3\41\3"+
			"\uffff\1\41\1\uffff\1\41\4\uffff\1\41\2\uffff\3\41\3\uffff\1\41\1\uffff"+
			"\2\41\2\uffff\1\41\1\54\4\41\1\55\1\65\1\56\1\63\1\57\1\uffff\1\67\1"+
			"\41\1\uffff\1\66\2\41\3\uffff\2\41\1\uffff\1\60\1\41\1\61\1\62\3\uffff"+
			"\1\66\11\uffff\1\40\15\uffff\1\67",
			"",
			"\1\70\16\uffff\1\71\5\uffff\1\70",
			"",
			"",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"",
			"",
			"",
			""
	};

	static final short[] DFA180_eot = DFA.unpackEncodedString(DFA180_eotS);
	static final short[] DFA180_eof = DFA.unpackEncodedString(DFA180_eofS);
	static final char[] DFA180_min = DFA.unpackEncodedStringToUnsignedChars(DFA180_minS);
	static final char[] DFA180_max = DFA.unpackEncodedStringToUnsignedChars(DFA180_maxS);
	static final short[] DFA180_accept = DFA.unpackEncodedString(DFA180_acceptS);
	static final short[] DFA180_special = DFA.unpackEncodedString(DFA180_specialS);
	static final short[][] DFA180_transition;

	static {
		int numStates = DFA180_transitionS.length;
		DFA180_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA180_transition[i] = DFA.unpackEncodedString(DFA180_transitionS[i]);
		}
	}

	protected class DFA180 extends DFA {

		public DFA180(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 180;
			this.eot = DFA180_eot;
			this.eof = DFA180_eof;
			this.min = DFA180_min;
			this.max = DFA180_max;
			this.accept = DFA180_accept;
			this.special = DFA180_special;
			this.transition = DFA180_transition;
		}
		@Override
		public String getDescription() {
			return "1410:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );";
		}
	}

	static final String DFA179_eotS =
		"\12\uffff";
	static final String DFA179_eofS =
		"\12\uffff";
	static final String DFA179_minS =
		"\1\107\1\uffff\6\u009c\2\uffff";
	static final String DFA179_maxS =
		"\1\u00b7\1\uffff\6\u00b1\2\uffff";
	static final String DFA179_acceptS =
		"\1\uffff\1\1\6\uffff\1\2\1\3";
	static final String DFA179_specialS =
		"\12\uffff}>";
	static final String[] DFA179_transitionS = {
			"\1\1\142\uffff\1\7\10\uffff\1\3\1\4\1\2\1\5\1\6",
			"",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"",
			""
	};

	static final short[] DFA179_eot = DFA.unpackEncodedString(DFA179_eotS);
	static final short[] DFA179_eof = DFA.unpackEncodedString(DFA179_eofS);
	static final char[] DFA179_min = DFA.unpackEncodedStringToUnsignedChars(DFA179_minS);
	static final char[] DFA179_max = DFA.unpackEncodedStringToUnsignedChars(DFA179_maxS);
	static final short[] DFA179_accept = DFA.unpackEncodedString(DFA179_acceptS);
	static final short[] DFA179_special = DFA.unpackEncodedString(DFA179_specialS);
	static final short[][] DFA179_transition;

	static {
		int numStates = DFA179_transitionS.length;
		DFA179_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA179_transition[i] = DFA.unpackEncodedString(DFA179_transitionS[i]);
		}
	}

	protected class DFA179 extends DFA {

		public DFA179(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 179;
			this.eot = DFA179_eot;
			this.eof = DFA179_eof;
			this.min = DFA179_min;
			this.max = DFA179_max;
			this.accept = DFA179_accept;
			this.special = DFA179_special;
			this.transition = DFA179_transition;
		}
		@Override
		public String getDescription() {
			return "1422:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )";
		}
	}

	static final String DFA189_eotS =
		"\37\uffff";
	static final String DFA189_eofS =
		"\1\uffff\24\34\2\31\1\uffff\1\31\1\uffff\1\31\4\uffff";
	static final String DFA189_minS =
		"\1\24\26\76\1\uffff\1\76\1\uffff\1\76\4\uffff";
	static final String DFA189_maxS =
		"\1\u00a0\26\u00b6\1\uffff\1\u00b6\1\uffff\1\u00b6\4\uffff";
	static final String DFA189_acceptS =
		"\27\uffff\1\2\1\uffff\1\4\1\uffff\1\6\1\1\1\3\1\5";
	static final String DFA189_specialS =
		"\37\uffff}>";
	static final String[] DFA189_transitionS = {
			"\1\31\4\uffff\2\31\4\uffff\1\31\1\uffff\1\1\3\uffff\1\2\1\3\1\4\1\uffff"+
			"\2\31\1\uffff\3\31\1\5\1\uffff\1\31\1\23\1\6\3\uffff\1\31\1\7\3\uffff"+
			"\3\31\1\10\1\uffff\1\32\1\uffff\2\31\4\uffff\1\11\1\uffff\2\31\1\uffff"+
			"\1\12\2\uffff\3\31\1\uffff\2\31\1\uffff\1\26\1\31\1\25\3\uffff\1\31\1"+
			"\uffff\1\31\4\uffff\1\31\2\uffff\3\31\3\uffff\1\31\1\uffff\2\31\1\uffff"+
			"\1\27\1\31\1\13\4\31\1\14\1\24\1\15\1\22\1\16\2\uffff\1\31\1\uffff\1"+
			"\31\1\30\1\31\3\uffff\2\31\1\uffff\1\17\1\31\1\20\1\21\3\uffff\1\31\11"+
			"\uffff\1\31\2\uffff\1\33",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\27\2\uffff\1\31",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\27\2\uffff\1\31",
			"",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\35\2\uffff\1\31",
			"",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\36\2\uffff\1\31",
			"",
			"",
			"",
			""
	};

	static final short[] DFA189_eot = DFA.unpackEncodedString(DFA189_eotS);
	static final short[] DFA189_eof = DFA.unpackEncodedString(DFA189_eofS);
	static final char[] DFA189_min = DFA.unpackEncodedStringToUnsignedChars(DFA189_minS);
	static final char[] DFA189_max = DFA.unpackEncodedStringToUnsignedChars(DFA189_maxS);
	static final short[] DFA189_accept = DFA.unpackEncodedString(DFA189_acceptS);
	static final short[] DFA189_special = DFA.unpackEncodedString(DFA189_specialS);
	static final short[][] DFA189_transition;

	static {
		int numStates = DFA189_transitionS.length;
		DFA189_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA189_transition[i] = DFA.unpackEncodedString(DFA189_transitionS[i]);
		}
	}

	protected class DFA189 extends DFA {

		public DFA189(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 189;
			this.eot = DFA189_eot;
			this.eof = DFA189_eof;
			this.min = DFA189_min;
			this.max = DFA189_max;
			this.accept = DFA189_accept;
			this.special = DFA189_special;
			this.transition = DFA189_transition;
		}
		@Override
		public String getDescription() {
			return "1479:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );";
		}
	}

	public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_178_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_cqlStatement142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_cqlStatement171 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_batchStatement_in_cqlStatement200 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_cqlStatement230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_useStatement_in_cqlStatement259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_truncateStatement_in_cqlStatement291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement318 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTableStatement_in_cqlStatement339 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement362 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement385 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement407 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement457 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement481 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantPermissionsStatement_in_cqlStatement502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokePermissionsStatement_in_cqlStatement520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createUserStatement_in_cqlStatement556 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement605 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement631 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement656 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTypeStatement_in_cqlStatement700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTypeStatement_in_cqlStatement724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTypeStatement_in_cqlStatement749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createFunctionStatement_in_cqlStatement775 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropFunctionStatement_in_cqlStatement795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createAggregateStatement_in_cqlStatement817 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropAggregateStatement_in_cqlStatement836 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createRoleStatement_in_cqlStatement857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterRoleStatement_in_cqlStatement881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropRoleStatement_in_cqlStatement906 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listRolesStatement_in_cqlStatement932 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantRoleStatement_in_cqlStatement957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokeRoleStatement_in_cqlStatement982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createMaterializedViewStatement_in_cqlStatement1006 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropMaterializedViewStatement_in_cqlStatement1018 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterMaterializedViewStatement_in_cqlStatement1032 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USE_in_useStatement1058 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_useStatement1062 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SELECT_in_selectStatement1096 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_K_JSON_in_selectStatement1107 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_K_DISTINCT_in_selectStatement1124 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_selectClause_in_selectStatement1133 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_selectStatement1143 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_selectStatement1147 = new BitSet(new long[]{0x0000000008000002L,0x0000008000800000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_selectStatement1157 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_whereClause_in_selectStatement1161 = new BitSet(new long[]{0x0000000008000002L,0x0000008000800000L});
	public static final BitSet FOLLOW_K_ORDER_in_selectStatement1174 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_BY_in_selectStatement1176 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement1178 = new BitSet(new long[]{0x0000000008000002L,0x0000000000800000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_selectStatement1183 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement1185 = new BitSet(new long[]{0x0000000008000002L,0x0000000000800000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_LIMIT_in_selectStatement1202 = new BitSet(new long[]{0x0000000008200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_selectStatement1206 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_K_ALLOW_in_selectStatement1221 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_K_FILTERING_in_selectStatement1223 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selector_in_selectClause1260 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_selectClause1265 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_selector_in_selectClause1269 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_185_in_selectClause1281 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selector1314 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_K_AS_in_selector1317 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_selector1321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1362 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_COUNT_in_unaliasedSelector1408 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_unaliasedSelector1410 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_countArgument_in_unaliasedSelector1412 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_unaliasedSelector1414 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_WRITETIME_in_unaliasedSelector1439 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_unaliasedSelector1441 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1445 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_unaliasedSelector1447 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_TTL_in_unaliasedSelector1473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_unaliasedSelector1481 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1485 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_unaliasedSelector1487 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_functionName_in_unaliasedSelector1515 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_selectionFunctionArgs_in_unaliasedSelector1519 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_unaliasedSelector1534 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1538 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_171_in_selectionFunctionArgs1566 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_selectionFunctionArgs1568 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_selectionFunctionArgs1578 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1582 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_selectionFunctionArgs1598 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1602 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_selectionFunctionArgs1615 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_185_in_countArgument1634 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_countArgument1644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relation_in_whereClause1675 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_whereClause1679 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_relation_in_whereClause1681 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_cident_in_orderByClause1712 = new BitSet(new long[]{0x0020000100000002L});
	public static final BitSet FOLLOW_K_ASC_in_orderByClause1715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_orderByClause1719 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INSERT_in_insertStatement1748 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_INTO_in_insertStatement1750 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1754 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L,0x0000080000000000L});
	public static final BitSet FOLLOW_normalInsertStatement_in_insertStatement1768 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_JSON_in_insertStatement1783 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L,0x0002000110000800L});
	public static final BitSet FOLLOW_jsonInsertStatement_in_insertStatement1787 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_normalInsertStatement1823 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_normalInsertStatement1827 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_normalInsertStatement1834 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_normalInsertStatement1838 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_normalInsertStatement1845 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_VALUES_in_normalInsertStatement1853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_normalInsertStatement1861 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_normalInsertStatement1865 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_normalInsertStatement1871 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_normalInsertStatement1875 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_normalInsertStatement1882 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_IF_in_normalInsertStatement1892 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_normalInsertStatement1894 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_normalInsertStatement1896 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_usingClause_in_normalInsertStatement1911 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_jsonValue_in_jsonInsertStatement1957 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_IF_in_jsonInsertStatement1967 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_jsonInsertStatement1969 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_jsonInsertStatement1971 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_usingClause_in_jsonInsertStatement1986 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_jsonValue2027 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_jsonValue2037 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_jsonValue2041 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_jsonValue2055 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClause2086 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause2088 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_usingClause2093 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause2095 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseObjective2117 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective2121 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective2131 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective2135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UPDATE_in_updateStatement2169 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_updateStatement2173 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_usingClause_in_updateStatement2183 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_K_SET_in_updateStatement2195 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement2197 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000020000L});
	public static final BitSet FOLLOW_174_in_updateStatement2201 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement2203 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_updateStatement2214 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_whereClause_in_updateStatement2218 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_IF_in_updateStatement2228 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_EXISTS_in_updateStatement2232 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_updateStatement2240 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions2282 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_updateConditions2287 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions2289 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_DELETE_in_deleteStatement2326 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1BL,0x000000002008F63AL});
	public static final BitSet FOLLOW_deleteSelection_in_deleteStatement2332 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_deleteStatement2345 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement2349 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020800L});
	public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement2359 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_deleteStatement2371 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_whereClause_in_deleteStatement2375 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_IF_in_deleteStatement2385 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_EXISTS_in_deleteStatement2389 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_deleteStatement2397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection2444 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_deleteSelection2459 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection2463 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_cident_in_deleteOp2490 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_deleteOp2517 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_184_in_deleteOp2519 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_deleteOp2523 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_deleteOp2525 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClauseDelete2545 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDelete2547 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseDelete2551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BEGIN_in_batchStatement2585 = new BitSet(new long[]{0x0000800800000000L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement2595 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_K_COUNTER_in_batchStatement2601 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2614 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0000000000000880L});
	public static final BitSet FOLLOW_usingClause_in_batchStatement2618 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0000000000000080L});
	public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2638 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0004000000000080L});
	public static final BitSet FOLLOW_178_in_batchStatement2640 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_APPLY_in_batchStatement2654 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2656 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective2687 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective2700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective2713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createAggregateStatement2746 = new BitSet(new long[]{0x0000000002000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_OR_in_createAggregateStatement2749 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_REPLACE_in_createAggregateStatement2751 = new BitSet(new long[]{0x0000000002000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_createAggregateStatement2763 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_createAggregateStatement2772 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createAggregateStatement2774 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createAggregateStatement2776 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_createAggregateStatement2790 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createAggregateStatement2798 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement2822 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createAggregateStatement2838 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement2842 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createAggregateStatement2866 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_SFUNC_in_createAggregateStatement2874 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476A5A1AL,0x000000002000F633L});
	public static final BitSet FOLLOW_allowedFunctionName_in_createAggregateStatement2880 = new BitSet(new long[]{0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_K_STYPE_in_createAggregateStatement2888 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement2894 = new BitSet(new long[]{0x4000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_FINALFUNC_in_createAggregateStatement2912 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476A5A1AL,0x000000002000F633L});
	public static final BitSet FOLLOW_allowedFunctionName_in_createAggregateStatement2918 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_INITCOND_in_createAggregateStatement2945 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_createAggregateStatement2951 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropAggregateStatement2998 = new BitSet(new long[]{0x0000000002000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_dropAggregateStatement3000 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_dropAggregateStatement3009 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropAggregateStatement3011 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_dropAggregateStatement3026 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_dropAggregateStatement3044 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropAggregateStatement3072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_dropAggregateStatement3090 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropAggregateStatement3094 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_dropAggregateStatement3122 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createFunctionStatement3179 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000008L});
	public static final BitSet FOLLOW_K_OR_in_createFunctionStatement3182 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_REPLACE_in_createFunctionStatement3184 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_FUNCTION_in_createFunctionStatement3196 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_createFunctionStatement3205 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createFunctionStatement3207 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createFunctionStatement3209 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_createFunctionStatement3223 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createFunctionStatement3231 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000010002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_createFunctionStatement3255 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement3259 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createFunctionStatement3275 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_createFunctionStatement3279 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement3283 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createFunctionStatement3307 = new BitSet(new long[]{0x0000020000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_RETURNS_in_createFunctionStatement3318 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_createFunctionStatement3320 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_CALLED_in_createFunctionStatement3326 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_createFunctionStatement3332 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_createFunctionStatement3334 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_K_INPUT_in_createFunctionStatement3336 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_RETURNS_in_createFunctionStatement3344 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement3350 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_LANGUAGE_in_createFunctionStatement3358 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_IDENT_in_createFunctionStatement3364 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_K_AS_in_createFunctionStatement3372 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createFunctionStatement3378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropFunctionStatement3416 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_FUNCTION_in_dropFunctionStatement3418 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_dropFunctionStatement3427 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropFunctionStatement3429 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_dropFunctionStatement3444 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_dropFunctionStatement3462 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropFunctionStatement3490 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_dropFunctionStatement3508 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropFunctionStatement3512 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_dropFunctionStatement3540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement3599 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement3601 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement3604 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement3606 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement3608 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement3617 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement3625 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_createKeyspaceStatement3627 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTableStatement3662 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement3664 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createTableStatement3667 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTableStatement3669 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement3671 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement3686 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cfamDefinition_in_createTableStatement3696 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_cfamDefinition3715 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34F21476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition3717 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_cfamDefinition3722 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34F21476E5A1AL,0x000050002008F63AL});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition3724 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_cfamDefinition3731 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_cfamDefinition3741 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition3743 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_cfamDefinition3748 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition3750 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ident_in_cfamColumns3776 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_cfamColumns3780 = new BitSet(new long[]{0x0000000000000002L,0x0040080000000000L});
	public static final BitSet FOLLOW_K_STATIC_in_cfamColumns3785 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns3802 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns3804 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns3816 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns3818 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_cfamColumns3820 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63AL});
	public static final BitSet FOLLOW_pkDef_in_cfamColumns3822 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_cfamColumns3826 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_ident_in_cfamColumns3830 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_cfamColumns3837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_pkDef3857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_pkDef3867 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_ident_in_pkDef3873 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_pkDef3879 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_ident_in_pkDef3883 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_pkDef3890 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_cfamProperty3910 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty3919 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty3921 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty3931 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_K_ORDER_in_cfamProperty3933 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_BY_in_cfamProperty3935 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_cfamProperty3937 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty3939 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_cfamProperty3943 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty3945 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_cfamProperty3950 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_cfamOrdering3978 = new BitSet(new long[]{0x0020000100000000L});
	public static final BitSet FOLLOW_K_ASC_in_cfamOrdering3981 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_cfamOrdering3985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTypeStatement4024 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_createTypeStatement4026 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createTypeStatement4029 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTypeStatement4031 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTypeStatement4033 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_userTypeName_in_createTypeStatement4051 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createTypeStatement4064 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement4066 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createTypeStatement4071 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000050002008F63AL});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement4073 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createTypeStatement4080 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_typeColumns4100 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_typeColumns4104 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement4139 = new BitSet(new long[]{0x0002000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement4142 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement4148 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34731476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createIndexStatement4151 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createIndexStatement4153 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement4155 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34731476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_idxName_in_createIndexStatement4171 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_createIndexStatement4176 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement4180 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createIndexStatement4182 = new BitSet(new long[]{0xF58EF6E286100000L,0x7FF34721476E5A1EL,0x000000002008F63AL});
	public static final BitSet FOLLOW_indexIdent_in_createIndexStatement4186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_createIndexStatement4188 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040800L});
	public static final BitSet FOLLOW_K_USING_in_createIndexStatement4199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement4203 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createIndexStatement4218 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_createIndexStatement4220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent4254 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYS_in_indexIdent4282 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_indexIdent4284 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_indexIdent4288 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_indexIdent4290 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ENTRIES_in_indexIdent4303 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_indexIdent4305 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_indexIdent4309 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_indexIdent4311 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FULL_in_indexIdent4321 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_indexIdent4323 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_indexIdent4327 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_indexIdent4329 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createMaterializedViewStatement4366 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_createMaterializedViewStatement4368 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_VIEW_in_createMaterializedViewStatement4370 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createMaterializedViewStatement4373 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createMaterializedViewStatement4375 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createMaterializedViewStatement4377 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createMaterializedViewStatement4385 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_K_AS_in_createMaterializedViewStatement4387 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_K_SELECT_in_createMaterializedViewStatement4397 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_selectClause_in_createMaterializedViewStatement4401 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_createMaterializedViewStatement4403 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createMaterializedViewStatement4407 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_createMaterializedViewStatement4418 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_mvWhereClause_in_createMaterializedViewStatement4422 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_K_PRIMARY_in_createMaterializedViewStatement4434 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_KEY_in_createMaterializedViewStatement4436 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createMaterializedViewStatement4448 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createMaterializedViewStatement4450 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4454 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createMaterializedViewStatement4460 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4464 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createMaterializedViewStatement4471 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createMaterializedViewStatement4475 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createMaterializedViewStatement4486 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_171_in_createMaterializedViewStatement4496 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4500 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createMaterializedViewStatement4506 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createMaterializedViewStatement4517 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createMaterializedViewStatement4549 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_createMaterializedViewStatement4551 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_createMaterializedViewStatement4556 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_createMaterializedViewStatement4558 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_cident_in_mvWhereClause4587 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_IS_in_mvWhereClause4591 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_mvWhereClause4593 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_mvWhereClause4595 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_mvWhereClause4598 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_mvWhereClause4602 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_IS_in_mvWhereClause4606 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_mvWhereClause4608 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_mvWhereClause4610 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement4644 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement4646 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createTriggerStatement4649 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTriggerStatement4651 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTriggerStatement4653 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createTriggerStatement4663 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_createTriggerStatement4674 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement4678 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_USING_in_createTriggerStatement4680 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement4684 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement4725 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement4727 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropTriggerStatement4730 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTriggerStatement4732 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_dropTriggerStatement4742 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement4745 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement4749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement4789 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement4791 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement4795 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement4805 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement4807 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement4843 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement4845 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement4849 = new BitSet(new long[]{0x0200000011000000L,0x0000100000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement4863 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement4867 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement4869 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement4873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTableStatement4889 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement4895 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement4899 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_STATIC_in_alterTableStatement4904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement4922 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement4927 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_WITH_in_alterTableStatement4967 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_alterTableStatement4970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement5003 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5057 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement5059 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5063 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTableStatement5084 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5088 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement5090 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5094 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterMaterializedViewStatement5147 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_alterMaterializedViewStatement5149 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_VIEW_in_alterMaterializedViewStatement5151 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_alterMaterializedViewStatement5155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterMaterializedViewStatement5167 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_alterMaterializedViewStatement5169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement5204 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement5206 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_userTypeName_in_alterTypeStatement5210 = new BitSet(new long[]{0x0000000011000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement5224 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5228 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement5230 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement5234 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTypeStatement5250 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5256 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement5260 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTypeStatement5283 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5321 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement5323 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5327 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTypeStatement5350 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5354 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement5356 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5360 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement5427 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement5429 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement5432 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement5434 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement5443 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTableStatement5477 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement5479 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropTableStatement5482 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement5484 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement5493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTypeStatement5527 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_dropTypeStatement5529 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropTypeStatement5532 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTypeStatement5534 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_userTypeName_in_dropTypeStatement5543 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement5577 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement5579 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropIndexStatement5582 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement5584 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_indexName_in_dropIndexStatement5593 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropMaterializedViewStatement5633 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_dropMaterializedViewStatement5635 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_VIEW_in_dropMaterializedViewStatement5637 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropMaterializedViewStatement5640 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropMaterializedViewStatement5642 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dropMaterializedViewStatement5651 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement5682 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement5686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantPermissionsStatement5711 = new BitSet(new long[]{0x0A41000414000000L,0x0004000010000000L});
	public static final BitSet FOLLOW_permissionOrAll_in_grantPermissionsStatement5723 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_grantPermissionsStatement5731 = new BitSet(new long[]{0xF18EFEE286100000L,0x7FF34721477E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_resource_in_grantPermissionsStatement5743 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_grantPermissionsStatement5751 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_grantPermissionsStatement5765 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokePermissionsStatement5796 = new BitSet(new long[]{0x0A41000414000000L,0x0004000010000000L});
	public static final BitSet FOLLOW_permissionOrAll_in_revokePermissionsStatement5808 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_revokePermissionsStatement5816 = new BitSet(new long[]{0xF18EFEE286100000L,0x7FF34721477E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_resource_in_revokePermissionsStatement5828 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_revokePermissionsStatement5836 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_revokePermissionsStatement5850 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantRoleStatement5881 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_grantRoleStatement5895 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_grantRoleStatement5903 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_grantRoleStatement5917 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokeRoleStatement5948 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_revokeRoleStatement5962 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_revokeRoleStatement5970 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_revokeRoleStatement5984 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement6022 = new BitSet(new long[]{0x0A41000414000000L,0x0004000010000000L});
	public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement6034 = new BitSet(new long[]{0x0000000000000002L,0x0000001880000000L});
	public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement6044 = new BitSet(new long[]{0xF18EFEE286100000L,0x7FF34721477E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_resource_in_listPermissionsStatement6046 = new BitSet(new long[]{0x0000000000000002L,0x0000000880000000L});
	public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement6061 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_roleName_in_listPermissionsStatement6063 = new BitSet(new long[]{0x0000000000000002L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement6077 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_permission6113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_permissionOrAll6170 = new BitSet(new long[]{0x0000000000000002L,0x0000040000000000L});
	public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll6174 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_permission_in_permissionOrAll6195 = new BitSet(new long[]{0x0000000000000002L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll6199 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dataResource_in_resource6227 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleResource_in_resource6239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionResource_in_resource6251 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_dataResource6274 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource6276 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource6286 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_dataResource6292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource6304 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dataResource6313 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_roleResource6342 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_K_ROLES_in_roleResource6344 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ROLE_in_roleResource6354 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_roleResource6360 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_functionResource6392 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_functionResource6394 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_functionResource6404 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_functionResource6406 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_IN_in_functionResource6408 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_functionResource6410 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_functionResource6416 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FUNCTION_in_functionResource6431 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_functionResource6435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_functionResource6453 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_functionResource6481 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_functionResource6499 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_functionResource6503 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_functionResource6531 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createUserStatement6579 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_USER_in_createUserStatement6581 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L,0x0000000120000000L});
	public static final BitSet FOLLOW_K_IF_in_createUserStatement6584 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createUserStatement6586 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createUserStatement6588 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000120000000L});
	public static final BitSet FOLLOW_username_in_createUserStatement6596 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createUserStatement6608 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_userPassword_in_createUserStatement6610 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement6624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement6630 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement6675 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_USER_in_alterUserStatement6677 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000120000000L});
	public static final BitSet FOLLOW_username_in_alterUserStatement6681 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterUserStatement6693 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_userPassword_in_alterUserStatement6695 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement6709 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement6723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropUserStatement6769 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_USER_in_dropUserStatement6771 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L,0x0000000120000000L});
	public static final BitSet FOLLOW_K_IF_in_dropUserStatement6774 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropUserStatement6776 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000120000000L});
	public static final BitSet FOLLOW_username_in_dropUserStatement6784 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listUsersStatement6809 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_K_USERS_in_listUsersStatement6811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createRoleStatement6845 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_ROLE_in_createRoleStatement6847 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createRoleStatement6850 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createRoleStatement6852 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createRoleStatement6854 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_createRoleStatement6862 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createRoleStatement6872 = new BitSet(new long[]{0x0000000000000000L,0x0200012002000000L});
	public static final BitSet FOLLOW_roleOptions_in_createRoleStatement6874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterRoleStatement6918 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_ROLE_in_alterRoleStatement6920 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_alterRoleStatement6924 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterRoleStatement6934 = new BitSet(new long[]{0x0000000000000000L,0x0200012002000000L});
	public static final BitSet FOLLOW_roleOptions_in_alterRoleStatement6936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropRoleStatement6980 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_ROLE_in_dropRoleStatement6982 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropRoleStatement6985 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropRoleStatement6987 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_dropRoleStatement6995 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listRolesStatement7035 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_K_ROLES_in_listRolesStatement7037 = new BitSet(new long[]{0x0000000000000002L,0x0000000880000000L});
	public static final BitSet FOLLOW_K_OF_in_listRolesStatement7047 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000013008F63AL});
	public static final BitSet FOLLOW_roleName_in_listRolesStatement7049 = new BitSet(new long[]{0x0000000000000002L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listRolesStatement7062 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleOption_in_roleOptions7093 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_roleOptions7097 = new BitSet(new long[]{0x0000000000000000L,0x0200012002000000L});
	public static final BitSet FOLLOW_roleOption_in_roleOptions7099 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_roleOption7121 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7123 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_roleOption7127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_OPTIONS_in_roleOption7138 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7140 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_mapLiteral_in_roleOption7144 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_roleOption7155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7157 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_BOOLEAN_in_roleOption7161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LOGIN_in_roleOption7172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7174 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_BOOLEAN_in_roleOption7178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_userPassword7200 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_userPassword7204 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cident7235 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cident7260 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cident7279 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ident7305 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ident7330 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ident7349 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_noncol_ident7375 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_noncol_ident7400 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_noncol_ident7419 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_keyspaceName7452 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_indexName7486 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_indexName7489 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_idxName_in_indexName7493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_columnFamilyName7525 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_columnFamilyName7528 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_cfName_in_columnFamilyName7532 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_userTypeName7557 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_userTypeName7559 = new BitSet(new long[]{0x7082360086100000L,0x03D34721476E181AL,0x0000000020002632L});
	public static final BitSet FOLLOW_non_type_ident_in_userTypeName7565 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleName_in_userOrRoleName7597 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ksName7620 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ksName7645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ksName7664 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_ksName7674 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cfName7696 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cfName7721 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cfName7740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_cfName7750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_idxName7772 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_idxName7797 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_idxName7816 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_idxName7826 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_roleName7848 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_roleName7873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_roleName7889 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_roleName7908 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_roleName7918 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_constant7943 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_constant7955 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_constant7974 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOOLEAN_in_constant7995 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UUID_in_constant8014 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEXNUMBER_in_constant8036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_175_in_constant8054 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000400L});
	public static final BitSet FOLLOW_set_in_constant8063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_mapLiteral8092 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x190288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8110 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_mapLiteral8112 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8116 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_174_in_mapLiteral8122 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8126 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_mapLiteral8128 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8132 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_188_in_mapLiteral8148 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_setOrMapLiteral8172 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8176 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_setOrMapLiteral8192 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8196 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_setOrMapLiteral8198 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8202 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_setOrMapLiteral8237 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8241 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_184_in_collectionLiteral8275 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x0D0288093008F63BL});
	public static final BitSet FOLLOW_term_in_collectionLiteral8293 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400400000000000L});
	public static final BitSet FOLLOW_174_in_collectionLiteral8299 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_collectionLiteral8303 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400400000000000L});
	public static final BitSet FOLLOW_186_in_collectionLiteral8319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_collectionLiteral8329 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_collectionLiteral8333 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1002400000000000L});
	public static final BitSet FOLLOW_setOrMapLiteral_in_collectionLiteral8337 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_188_in_collectionLiteral8342 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_collectionLiteral8360 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_188_in_collectionLiteral8362 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_usertypeLiteral8406 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_usertypeLiteral8410 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_usertypeLiteral8412 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_usertypeLiteral8416 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_174_in_usertypeLiteral8422 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_usertypeLiteral8426 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_usertypeLiteral8428 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_usertypeLiteral8432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_188_in_usertypeLiteral8439 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleLiteral8476 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_tupleLiteral8480 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleLiteral8486 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_tupleLiteral8490 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleLiteral8497 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_value8520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionLiteral_in_value8542 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_usertypeLiteral_in_value8555 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleLiteral_in_value8570 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NULL_in_value8586 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_value8610 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_value8614 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_value8625 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_intValue8671 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_intValue8685 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_intValue8689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_intValue8700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_keyspaceName_in_functionName8734 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_functionName8736 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476A5A1AL,0x000000002000F633L});
	public static final BitSet FOLLOW_allowedFunctionName_in_functionName8742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_allowedFunctionName8769 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_allowedFunctionName8803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_allowedFunctionName8831 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_allowedFunctionName8841 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNT_in_allowedFunctionName8873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function8920 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_function8922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_function8924 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function8954 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_function8956 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_functionArgs_in_function8960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_function8962 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_functionArgs8995 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_functionArgs9001 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_functionArgs9005 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_value_in_term9033 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_function_in_term9070 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_term9102 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_term9106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_term9108 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_term9112 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnOperation9135 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0120000000000000L});
	public static final BitSet FOLLOW_columnOperationDifferentiator_in_columnOperation9137 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_181_in_columnOperationDifferentiator9156 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_normalColumnOperation_in_columnOperationDifferentiator9158 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_184_in_columnOperationDifferentiator9167 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnOperationDifferentiator9171 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_columnOperationDifferentiator9173 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator9175 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation9196 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_173_in_normalColumnOperation9199 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation9203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation9224 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000A00000000000L});
	public static final BitSet FOLLOW_set_in_normalColumnOperation9228 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_normalColumnOperation9238 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation9256 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_INTEGER_in_normalColumnOperation9260 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_181_in_specializedColumnOperation9286 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_specializedColumnOperation9290 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnCondition9323 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x01F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition9337 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnCondition9341 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition9355 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002080010000000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition9373 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition9393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_184_in_columnCondition9421 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnCondition9425 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_columnCondition9427 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition9445 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnCondition9449 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition9467 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002080010000000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition9489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition9513 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_properties9575 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_properties9579 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_property_in_properties9581 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_noncol_ident_in_property9604 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_property9606 = new BitSet(new long[]{0xF18EF6E286244040L,0x7FF34721676E5E1AL,0x000080090008F63AL});
	public static final BitSet FOLLOW_propertyValue_in_property9610 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_property9622 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_property9624 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_mapLiteral_in_property9628 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_propertyValue9653 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue9675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_181_in_relationType9698 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_179_in_relationType9709 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_180_in_relationType9720 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_182_in_relationType9730 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_183_in_relationType9741 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_170_in_relationType9751 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9773 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_relation9777 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_relation9791 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation9795 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_relation9799 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9823 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_IN_in_relation9825 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_inMarker_in_relation9829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9849 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_IN_in_relation9851 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_relation9855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9875 = new BitSet(new long[]{0x0000200000000000L});
	public static final BitSet FOLLOW_K_CONTAINS_in_relation9877 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_K_KEY_in_relation9882 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9910 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_184_in_relation9912 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9916 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_relation9918 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_relation9922 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9926 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation9938 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x00F8040000000000L});
	public static final BitSet FOLLOW_K_IN_in_relation9948 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002080010000000L});
	public static final BitSet FOLLOW_171_in_relation9962 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_relation9964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarkerForTuple_in_relation9996 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfTupleLiterals_in_relation10030 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfMarkersForTuples_in_relation10064 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation10106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleLiteral_in_relation10110 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation10136 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_markerForTuple_in_relation10140 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_relation10170 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_relation_in_relation10172 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_relation10175 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarker10196 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_inMarker10206 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_inMarker10210 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleOfIdentifiers10242 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers10246 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleOfIdentifiers10251 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers10255 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleOfIdentifiers10261 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_singleColumnInValues10291 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090298093008F63BL});
	public static final BitSet FOLLOW_term_in_singleColumnInValues10299 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_singleColumnInValues10304 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_singleColumnInValues10308 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_singleColumnInValues10317 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleOfTupleLiterals10347 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10351 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleOfTupleLiterals10356 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10360 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleOfTupleLiterals10366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_markerForTuple10387 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_markerForTuple10397 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_markerForTuple10401 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleOfMarkersForTuples10433 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10437 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleOfMarkersForTuples10442 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10446 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleOfMarkersForTuples10452 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarkerForTuple10473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_inMarkerForTuple10483 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_inMarkerForTuple10487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_comparatorType10512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collection_type_in_comparatorType10528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tuple_type_in_comparatorType10540 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_comparatorType10556 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FROZEN_in_comparatorType10568 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_comparatorType10570 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_comparatorType10574 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_comparatorType10576 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType10594 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ASCII_in_native_type10623 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BIGINT_in_native_type10637 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BLOB_in_native_type10650 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BOOLEAN_in_native_type10665 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNTER_in_native_type10677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DECIMAL_in_native_type10689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DOUBLE_in_native_type10701 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FLOAT_in_native_type10714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INET_in_native_type10728 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INT_in_native_type10743 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SMALLINT_in_native_type10759 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TEXT_in_native_type10770 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type10785 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TINYINT_in_native_type10795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UUID_in_native_type10807 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARCHAR_in_native_type10822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARINT_in_native_type10834 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMEUUID_in_native_type10847 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DATE_in_native_type10858 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIME_in_native_type10873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MAP_in_collection_type10901 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_collection_type10904 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10908 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_collection_type10910 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10914 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_collection_type10916 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_collection_type10934 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_collection_type10936 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10940 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_collection_type10942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SET_in_collection_type10960 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_collection_type10963 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_collection_type10969 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TUPLE_in_tuple_type11000 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_tuple_type11002 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type11017 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040400000000000L});
	public static final BitSet FOLLOW_174_in_tuple_type11022 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type11026 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040400000000000L});
	public static final BitSet FOLLOW_182_in_tuple_type11038 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_username11057 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_username11065 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_username11073 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_non_type_ident11100 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_non_type_ident11131 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_non_type_ident11156 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEY_in_non_type_ident11168 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword11211 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_unreserved_keyword11227 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword11266 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword11278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_basic_unreserved_keyword11316 = new BitSet(new long[]{0x0000000000000002L});
}
