/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.tools.BulkLoader;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;

public class StandaloneLister {
    private static final String TOOL_NAME = "sstablelister";
    private static final String TYPE_OPTION = "type";
    private static final String OP_LOG_OPTION = "oplog";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";

    public static void main(String[] args) {
        Options options = Options.parseArgs(args);
        try {
            Schema.instance.loadFromDisk(false);
            CFMetaData metadata = Schema.instance.getCFMetaData(options.keyspaceName, options.cfName);
            if (metadata == null) {
                throw new IllegalArgumentException(String.format("Unknown keyspace/table %s.%s", options.keyspaceName, options.cfName));
            }
            OutputHandler.SystemOutput handler = new OutputHandler.SystemOutput(options.verbose, options.debug);
            Directories directories = new Directories(metadata);
            Directories.SSTableLister lister = directories.sstableLister();
            if (options.type == Options.FileType.FINAL) {
                lister.skipTemporary(true);
            } else if (options.type == Options.FileType.TMP) {
                lister.onlyTemporary(true);
            }
            for (File file : lister.listFiles()) {
                handler.output(file.getCanonicalPath());
            }
            if (options.oplogs) {
                for (File file : LifecycleTransaction.getLogFiles(metadata)) {
                    handler.output(file.getCanonicalPath());
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static class Options {
        public final String keyspaceName;
        public final String cfName;
        public boolean debug;
        public boolean verbose;
        public boolean oplogs;
        public FileType type;

        private Options(String keyspaceName, String cfName) {
            this.keyspaceName = keyspaceName;
            this.cfName = cfName;
        }

        public static Options parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            BulkLoader.CmdLineOptions options = Options.getCmdLineOptions();
            try {
                String[] args;
                CommandLine cmd = parser.parse((org.apache.commons.cli.Options)options, cmdArgs, false);
                if (cmd.hasOption(StandaloneLister.HELP_OPTION)) {
                    Options.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length != 2) {
                    String msg = args.length < 2 ? "Missing arguments" : "Too many arguments";
                    System.err.println(msg);
                    Options.printUsage(options);
                    System.exit(1);
                }
                String keyspaceName = args[0];
                String cfName = args[1];
                Options opts = new Options(keyspaceName, cfName);
                opts.debug = cmd.hasOption(StandaloneLister.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(StandaloneLister.VERBOSE_OPTION);
                opts.type = FileType.fromOption(cmd.getOptionValue(StandaloneLister.TYPE_OPTION));
                opts.oplogs = cmd.hasOption(StandaloneLister.OP_LOG_OPTION);
                return opts;
            }
            catch (ParseException e) {
                Options.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, BulkLoader.CmdLineOptions options) {
            System.err.println(msg);
            Options.printUsage(options);
            System.exit(1);
        }

        private static BulkLoader.CmdLineOptions getCmdLineOptions() {
            BulkLoader.CmdLineOptions options = new BulkLoader.CmdLineOptions();
            options.addOption("d", StandaloneLister.DEBUG_OPTION, "display stack traces");
            options.addOption("h", StandaloneLister.HELP_OPTION, "display this help message");
            options.addOption("o", StandaloneLister.OP_LOG_OPTION, "include operation logs");
            options.addOption("t", StandaloneLister.TYPE_OPTION, true, FileType.descr());
            options.addOption("v", StandaloneLister.VERBOSE_OPTION, "verbose output");
            return options;
        }

        public static void printUsage(BulkLoader.CmdLineOptions options) {
            String usage = String.format("%s [options] <keyspace> <column_family>", StandaloneLister.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("List sstable files for the provided table.");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), (org.apache.commons.cli.Options)options, "");
        }

        public static enum FileType {
            ALL("all", "list all files, final or temporary"),
            TMP("tmp", "list temporary files only"),
            FINAL("final", "list final files only");

            public String option;
            public String descr;

            private FileType(String option, String descr) {
                this.option = option;
                this.descr = descr;
            }

            static FileType fromOption(String option) {
                for (FileType fileType : FileType.values()) {
                    if (!fileType.option.equals(option)) continue;
                    return fileType;
                }
                return ALL;
            }

            static String descr() {
                StringBuilder str = new StringBuilder();
                for (FileType fileType : FileType.values()) {
                    str.append(fileType.option);
                    str.append(" (");
                    str.append(fileType.descr);
                    str.append("), ");
                }
                return str.toString();
            }
        }
    }
}

