/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.compress;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class CompressionInfo {
    public static final IVersionedSerializer<CompressionInfo> serializer = new CompressionInfoSerializer();
    public final CompressionMetadata.Chunk[] chunks;
    public final CompressionParameters parameters;

    public CompressionInfo(CompressionMetadata.Chunk[] chunks, CompressionParameters parameters) {
        assert (chunks != null && parameters != null);
        this.chunks = chunks;
        this.parameters = parameters;
    }

    static class CompressionInfoSerializer
    implements IVersionedSerializer<CompressionInfo> {
        CompressionInfoSerializer() {
        }

        @Override
        public void serialize(CompressionInfo info, DataOutputPlus out, int version) throws IOException {
            if (info == null) {
                out.writeInt(-1);
                return;
            }
            int chunkCount = info.chunks.length;
            out.writeInt(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                CompressionMetadata.Chunk.serializer.serialize(info.chunks[i], out, version);
            }
            CompressionParameters.serializer.serialize(info.parameters, out, version);
        }

        @Override
        public CompressionInfo deserialize(DataInputPlus in, int version) throws IOException {
            int chunkCount = in.readInt();
            if (chunkCount < 0) {
                return null;
            }
            CompressionMetadata.Chunk[] chunks = new CompressionMetadata.Chunk[chunkCount];
            for (int i = 0; i < chunkCount; ++i) {
                chunks[i] = CompressionMetadata.Chunk.serializer.deserialize(in, version);
            }
            CompressionParameters parameters = CompressionParameters.serializer.deserialize(in, version);
            return new CompressionInfo(chunks, parameters);
        }

        @Override
        public long serializedSize(CompressionInfo info, int version) {
            if (info == null) {
                return TypeSizes.sizeof(-1);
            }
            int chunkCount = info.chunks.length;
            long size = TypeSizes.sizeof(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                size += CompressionMetadata.Chunk.serializer.serializedSize(info.chunks[i], version);
            }
            return size += CompressionParameters.serializer.serializedSize(info.parameters, version);
        }
    }
}

