/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;

public class BatchlogResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    AbstractWriteResponseHandler<T> wrapped;
    BatchlogCleanup cleanup;
    protected volatile int requiredBeforeFinish;
    private static final AtomicIntegerFieldUpdater<BatchlogResponseHandler> requiredBeforeFinishUpdater = AtomicIntegerFieldUpdater.newUpdater(BatchlogResponseHandler.class, "requiredBeforeFinish");

    public BatchlogResponseHandler(AbstractWriteResponseHandler<T> wrapped, int requiredBeforeFinish, BatchlogCleanup cleanup) {
        super(wrapped.keyspace, wrapped.naturalEndpoints, wrapped.pendingEndpoints, wrapped.consistencyLevel, wrapped.callback, wrapped.writeType);
        this.wrapped = wrapped;
        this.requiredBeforeFinish = requiredBeforeFinish;
        this.cleanup = cleanup;
    }

    @Override
    protected int ackCount() {
        return this.wrapped.ackCount();
    }

    @Override
    public void response(MessageIn<T> msg) {
        this.wrapped.response(msg);
        if (requiredBeforeFinishUpdater.decrementAndGet(this) == 0) {
            this.cleanup.run();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return this.wrapped.isLatencyForSnitch();
    }

    @Override
    public void onFailure(InetAddress from) {
        this.wrapped.onFailure(from);
    }

    @Override
    public void assureSufficientLiveNodes() {
        this.wrapped.assureSufficientLiveNodes();
    }

    @Override
    public void get() throws WriteTimeoutException, WriteFailureException {
        this.wrapped.get();
    }

    @Override
    protected int totalBlockFor() {
        return this.wrapped.totalBlockFor();
    }

    @Override
    protected int totalEndpoints() {
        return this.wrapped.totalEndpoints();
    }

    @Override
    protected boolean waitingFor(InetAddress from) {
        return this.wrapped.waitingFor(from);
    }

    @Override
    protected void signal() {
        this.wrapped.signal();
    }

    public static interface BatchlogCleanupCallback {
        public void invoke();
    }

    public static class BatchlogCleanup {
        private final BatchlogCleanupCallback callback;
        protected volatile int mutationsWaitingFor;
        private static final AtomicIntegerFieldUpdater<BatchlogCleanup> mutationsWaitingForUpdater = AtomicIntegerFieldUpdater.newUpdater(BatchlogCleanup.class, "mutationsWaitingFor");

        public BatchlogCleanup(int mutationsWaitingFor, BatchlogCleanupCallback callback) {
            this.mutationsWaitingFor = mutationsWaitingFor;
            this.callback = callback;
        }

        public void run() {
            if (mutationsWaitingForUpdater.decrementAndGet(this) == 0) {
                this.callback.invoke();
            }
        }
    }
}

