/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LegacySchemaMigrator {
    private static final Logger logger = LoggerFactory.getLogger(LegacySchemaMigrator.class);
    static final List<CFMetaData> LegacySchemaTables = ImmutableList.of((Object)SystemKeyspace.LegacyKeyspaces, (Object)SystemKeyspace.LegacyColumnfamilies, (Object)SystemKeyspace.LegacyColumns, (Object)SystemKeyspace.LegacyTriggers, (Object)SystemKeyspace.LegacyUsertypes, (Object)SystemKeyspace.LegacyFunctions, (Object)SystemKeyspace.LegacyAggregates);

    private LegacySchemaMigrator() {
    }

    public static void migrate() {
        Collection<Keyspace> keyspaces = LegacySchemaMigrator.readSchema();
        if (keyspaces.isEmpty()) {
            LegacySchemaMigrator.unloadLegacySchemaTables();
            return;
        }
        logger.info("Moving {} keyspaces from legacy schema tables to the new schema keyspace ({})", (Object)keyspaces.size(), (Object)"system_schema");
        keyspaces.forEach(LegacySchemaMigrator::storeKeyspaceInNewSchemaTables);
        SchemaKeyspace.flush();
        logger.info("Truncating legacy schema tables");
        LegacySchemaMigrator.truncateLegacySchemaTables();
        LegacySchemaMigrator.unloadLegacySchemaTables();
        logger.info("Completed migration of legacy schema tables");
    }

    static void unloadLegacySchemaTables() {
        KeyspaceMetadata systemKeyspace = Schema.instance.getKSMetaData("system");
        Tables systemTables = systemKeyspace.tables;
        for (CFMetaData table : LegacySchemaTables) {
            systemTables = systemTables.without(table.cfName);
        }
        LegacySchemaTables.forEach(Schema.instance::unload);
        Schema.instance.setKeyspaceMetadata(systemKeyspace.withSwapped(systemTables));
    }

    private static void truncateLegacySchemaTables() {
        LegacySchemaTables.forEach(table -> Schema.instance.getColumnFamilyStoreInstance(table.cfId).truncateBlocking());
    }

    private static void storeKeyspaceInNewSchemaTables(Keyspace keyspace) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, keyspace.timestamp);
        for (Table table : keyspace.tables) {
            SchemaKeyspace.addTableToSchemaMutation(table.metadata, table.timestamp, true, mutation);
        }
        for (Type type : keyspace.types) {
            SchemaKeyspace.addTypeToSchemaMutation(type.metadata, type.timestamp, mutation);
        }
        for (Function function : keyspace.functions) {
            SchemaKeyspace.addFunctionToSchemaMutation(function.metadata, function.timestamp, mutation);
        }
        for (Aggregate aggregate : keyspace.aggregates) {
            SchemaKeyspace.addAggregateToSchemaMutation(aggregate.metadata, aggregate.timestamp, mutation);
        }
        mutation.apply();
    }

    private static Collection<Keyspace> readSchema() {
        String query = String.format("SELECT keyspace_name FROM %s.%s", "system", "schema_keyspaces");
        ArrayList keyspaceNames = new ArrayList();
        LegacySchemaMigrator.query(query, new Object[0]).forEach(row -> keyspaceNames.add(row.getString("keyspace_name")));
        keyspaceNames.removeAll(Schema.SYSTEM_KEYSPACE_NAMES);
        ArrayList<Keyspace> keyspaces = new ArrayList<Keyspace>();
        keyspaceNames.forEach(name -> keyspaces.add(LegacySchemaMigrator.readKeyspace(name)));
        return keyspaces;
    }

    private static Keyspace readKeyspace(String keyspaceName) {
        long timestamp = LegacySchemaMigrator.readKeyspaceTimestamp(keyspaceName);
        KeyspaceParams params = LegacySchemaMigrator.readKeyspaceParams(keyspaceName);
        Collection<Table> tables = LegacySchemaMigrator.readTables(keyspaceName);
        Collection<Type> types = LegacySchemaMigrator.readTypes(keyspaceName);
        Collection<Function> functions = LegacySchemaMigrator.readFunctions(keyspaceName);
        Collection<Aggregate> aggregates = LegacySchemaMigrator.readAggregates(keyspaceName);
        return new Keyspace(timestamp, keyspaceName, params, tables, types, functions, aggregates);
    }

    private static long readKeyspaceTimestamp(String keyspaceName) {
        String query = String.format("SELECT writeTime(durable_writes) AS timestamp FROM %s.%s WHERE keyspace_name = ?", "system", "schema_keyspaces");
        return LegacySchemaMigrator.query(query, keyspaceName).one().getLong("timestamp");
    }

    private static KeyspaceParams readKeyspaceParams(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system", "schema_keyspaces");
        UntypedResultSet.Row row = LegacySchemaMigrator.query(query, keyspaceName).one();
        boolean durableWrites = row.getBoolean("durable_writes");
        HashMap<String, String> replication = new HashMap<String, String>();
        replication.putAll(FBUtilities.fromJsonMap(row.getString("strategy_options")));
        replication.put(KeyspaceParams.Replication.CLASS, row.getString("strategy_class"));
        return KeyspaceParams.create(durableWrites, replication);
    }

    private static Collection<Table> readTables(String keyspaceName) {
        String query = String.format("SELECT columnfamily_name FROM %s.%s WHERE keyspace_name = ?", "system", "schema_columnfamilies");
        ArrayList tableNames = new ArrayList();
        LegacySchemaMigrator.query(query, keyspaceName).forEach(row -> tableNames.add(row.getString("columnfamily_name")));
        ArrayList<Table> tables = new ArrayList<Table>();
        tableNames.forEach(name -> tables.add(LegacySchemaMigrator.readTable(keyspaceName, name)));
        return tables;
    }

    private static Table readTable(String keyspaceName, String tableName) {
        long timestamp = LegacySchemaMigrator.readTableTimestamp(keyspaceName, tableName);
        CFMetaData metadata = LegacySchemaMigrator.readTableMetadata(keyspaceName, tableName);
        return new Table(timestamp, metadata);
    }

    private static long readTableTimestamp(String keyspaceName, String tableName) {
        String query = String.format("SELECT writeTime(type) AS timestamp FROM %s.%s WHERE keyspace_name = ? AND columnfamily_name = ?", "system", "schema_columnfamilies");
        return LegacySchemaMigrator.query(query, keyspaceName, tableName).one().getLong("timestamp");
    }

    private static CFMetaData readTableMetadata(String keyspaceName, String tableName) {
        String tableQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND columnfamily_name = ?", "system", "schema_columnfamilies");
        UntypedResultSet.Row tableRow = LegacySchemaMigrator.query(tableQuery, keyspaceName, tableName).one();
        String columnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND columnfamily_name = ?", "system", "schema_columns");
        UntypedResultSet columnRows = LegacySchemaMigrator.query(columnsQuery, keyspaceName, tableName);
        String triggersQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND columnfamily_name = ?", "system", "schema_triggers");
        UntypedResultSet triggerRows = LegacySchemaMigrator.query(triggersQuery, keyspaceName, tableName);
        return LegacySchemaMigrator.decodeTableMetadata(tableRow, columnRows, triggerRows);
    }

    private static CFMetaData decodeTableMetadata(UntypedResultSet.Row tableRow, UntypedResultSet columnRows, UntypedResultSet triggerRows) {
        String ksName = tableRow.getString("keyspace_name");
        String cfName = tableRow.getString("columnfamily_name");
        AbstractType<?> rawComparator = TypeParser.parse(tableRow.getString("comparator"));
        AbstractType<?> subComparator = tableRow.has("subcomparator") ? TypeParser.parse(tableRow.getString("subcomparator")) : null;
        boolean isSuper = "super".equals(tableRow.getString("type").toLowerCase());
        boolean isDense = tableRow.getBoolean("is_dense");
        boolean isCompound = rawComparator instanceof CompositeType;
        AbstractType<?> defaultValidator = TypeParser.parse(tableRow.getString("default_validator"));
        boolean isCounter = defaultValidator instanceof CounterColumnType;
        UUID cfId = tableRow.has("cf_id") ? tableRow.getUUID("cf_id") : CFMetaData.generateLegacyCfId(ksName, cfName);
        boolean isCQLTable = !isSuper && !isDense && isCompound;
        boolean isStaticCompactTable = !isDense && !isCompound;
        boolean needsUpgrade = !isCQLTable && LegacySchemaMigrator.checkNeedsUpgrade(columnRows, isSuper, isStaticCompactTable);
        List<ColumnDefinition> columnDefs = LegacySchemaMigrator.createColumnsFromColumnRows(columnRows, ksName, cfName, rawComparator, subComparator, isSuper, isCQLTable, isStaticCompactTable, needsUpgrade);
        if (needsUpgrade) {
            LegacySchemaMigrator.addDefinitionForUpgrade(columnDefs, ksName, cfName, isStaticCompactTable, isSuper, rawComparator, subComparator, defaultValidator);
        }
        boolean isMaterializedView = false;
        CFMetaData cfm = CFMetaData.create(ksName, cfName, cfId, isDense, isCompound, isSuper, isCounter, isMaterializedView, columnDefs);
        cfm.readRepairChance(tableRow.getDouble("read_repair_chance"));
        cfm.dcLocalReadRepairChance(tableRow.getDouble("local_read_repair_chance"));
        cfm.gcGraceSeconds(tableRow.getInt("gc_grace_seconds"));
        cfm.minCompactionThreshold(tableRow.getInt("min_compaction_threshold"));
        cfm.maxCompactionThreshold(tableRow.getInt("max_compaction_threshold"));
        if (tableRow.has("comment")) {
            cfm.comment(tableRow.getString("comment"));
        }
        if (tableRow.has("memtable_flush_period_in_ms")) {
            cfm.memtableFlushPeriod(tableRow.getInt("memtable_flush_period_in_ms"));
        }
        cfm.caching(CachingOptions.fromString(tableRow.getString("caching")));
        if (tableRow.has("default_time_to_live")) {
            cfm.defaultTimeToLive(tableRow.getInt("default_time_to_live"));
        }
        if (tableRow.has("speculative_retry")) {
            cfm.speculativeRetry(CFMetaData.SpeculativeRetry.fromString(tableRow.getString("speculative_retry")));
        }
        cfm.compactionStrategyClass(CFMetaData.createCompactionStrategy(tableRow.getString("compaction_strategy_class")));
        cfm.compressionParameters(CompressionParameters.fromMap(FBUtilities.fromJsonMap(tableRow.getString("compression_parameters"))));
        cfm.compactionStrategyOptions(FBUtilities.fromJsonMap(tableRow.getString("compaction_strategy_options")));
        if (tableRow.has("min_index_interval")) {
            cfm.minIndexInterval(tableRow.getInt("min_index_interval"));
        }
        if (tableRow.has("max_index_interval")) {
            cfm.maxIndexInterval(tableRow.getInt("max_index_interval"));
        }
        if (tableRow.has("bloom_filter_fp_chance")) {
            cfm.bloomFilterFpChance(tableRow.getDouble("bloom_filter_fp_chance"));
        } else {
            cfm.bloomFilterFpChance(cfm.getBloomFilterFpChance());
        }
        if (tableRow.has("dropped_columns")) {
            LegacySchemaMigrator.addDroppedColumns(cfm, rawComparator, tableRow.getMap("dropped_columns", UTF8Type.instance, LongType.instance));
        }
        cfm.triggers(LegacySchemaMigrator.createTriggersFromTriggerRows(triggerRows));
        return cfm;
    }

    private static boolean checkNeedsUpgrade(UntypedResultSet defs, boolean isSuper, boolean isStaticCompactTable) {
        if (isSuper) {
            for (UntypedResultSet.Row row : defs) {
                if (!row.getString("column_name").isEmpty()) continue;
                return false;
            }
            return true;
        }
        if (isStaticCompactTable) {
            return !LegacySchemaMigrator.hasKind(defs, ColumnDefinition.Kind.STATIC);
        }
        return !LegacySchemaMigrator.hasRegularColumns(defs);
    }

    private static boolean hasRegularColumns(UntypedResultSet columnRows) {
        for (UntypedResultSet.Row row : columnRows) {
            if (LegacySchemaMigrator.isEmptyCompactValueColumn(row)) {
                return false;
            }
            if (LegacySchemaMigrator.deserializeKind(row.getString("type")) != ColumnDefinition.Kind.REGULAR) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmptyCompactValueColumn(UntypedResultSet.Row row) {
        return "compact_value".equals(row.getString("type")) && row.getString("column_name").isEmpty();
    }

    private static void addDefinitionForUpgrade(List<ColumnDefinition> defs, String ksName, String cfName, boolean isStaticCompactTable, boolean isSuper, AbstractType<?> rawComparator, AbstractType<?> subComparator, AbstractType<?> defaultValidator) {
        CompactTables.DefaultNames names = CompactTables.defaultNameGenerator(defs);
        if (isSuper) {
            defs.add(ColumnDefinition.regularDef(ksName, cfName, CompactTables.SUPER_COLUMN_MAP_COLUMN_STR, MapType.getInstance(subComparator, defaultValidator, true)));
        } else if (isStaticCompactTable) {
            defs.add(ColumnDefinition.clusteringKeyDef(ksName, cfName, names.defaultClusteringName(), rawComparator, null));
            defs.add(ColumnDefinition.regularDef(ksName, cfName, names.defaultCompactValueName(), defaultValidator));
        } else {
            defs.add(ColumnDefinition.regularDef(ksName, cfName, names.defaultCompactValueName(), EmptyType.instance));
        }
    }

    private static boolean hasKind(UntypedResultSet defs, ColumnDefinition.Kind kind) {
        for (UntypedResultSet.Row row : defs) {
            if (LegacySchemaMigrator.deserializeKind(row.getString("type")) != kind) continue;
            return true;
        }
        return false;
    }

    private static void addDroppedColumns(CFMetaData cfm, AbstractType<?> comparator, Map<String, Long> droppedTimes) {
        AbstractType<?> last = comparator.getComponents().get(comparator.componentsCount() - 1);
        Map collections = last instanceof ColumnToCollectionType ? ((ColumnToCollectionType)last).defined : Collections.emptyMap();
        for (Map.Entry<String, Long> entry : droppedTimes.entrySet()) {
            String name = entry.getKey();
            ByteBuffer nameBytes = UTF8Type.instance.decompose(name);
            long time = entry.getValue();
            BytesType type = collections.containsKey(nameBytes) ? (AbstractType)collections.get(nameBytes) : BytesType.instance;
            cfm.getDroppedColumns().put(nameBytes, new CFMetaData.DroppedColumn(name, type, time));
        }
    }

    private static List<ColumnDefinition> createColumnsFromColumnRows(UntypedResultSet rows, String keyspace, String table, AbstractType<?> rawComparator, AbstractType<?> rawSubComparator, boolean isSuper, boolean isCQLTable, boolean isStaticCompactTable, boolean needsUpgrade) {
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        for (UntypedResultSet.Row row : rows) {
            if (LegacySchemaMigrator.isEmptyCompactValueColumn(row)) continue;
            ColumnDefinition.Kind kind = LegacySchemaMigrator.deserializeKind(row.getString("type"));
            if (needsUpgrade && isStaticCompactTable && kind == ColumnDefinition.Kind.REGULAR) {
                kind = ColumnDefinition.Kind.STATIC;
            }
            Integer componentIndex = null;
            if (kind.isPrimaryKeyKind() && row.has("component_index")) {
                componentIndex = row.getInt("component_index");
            }
            UTF8Type comparator = isCQLTable ? UTF8Type.instance : CompactTables.columnDefinitionComparator(kind, isSuper, rawComparator, rawSubComparator);
            ColumnIdentifier name = ColumnIdentifier.getInterned(((AbstractType)comparator).fromString(row.getString("column_name")), comparator);
            AbstractType<?> validator = LegacySchemaMigrator.parseType(row.getString("validator"));
            IndexType indexType = null;
            if (row.has("index_type")) {
                indexType = IndexType.valueOf(row.getString("index_type"));
            }
            Map<String, String> indexOptions = null;
            if (row.has("index_options")) {
                indexOptions = FBUtilities.fromJsonMap(row.getString("index_options"));
            }
            String indexName = null;
            if (row.has("index_name")) {
                indexName = row.getString("index_name");
            }
            columns.add(new ColumnDefinition(keyspace, table, name, validator, indexType, indexOptions, indexName, componentIndex, kind));
        }
        return columns;
    }

    private static ColumnDefinition.Kind deserializeKind(String kind) {
        if ("clustering_key".equalsIgnoreCase(kind)) {
            return ColumnDefinition.Kind.CLUSTERING;
        }
        if ("compact_value".equalsIgnoreCase(kind)) {
            return ColumnDefinition.Kind.REGULAR;
        }
        return Enum.valueOf(ColumnDefinition.Kind.class, kind.toUpperCase());
    }

    private static Triggers createTriggersFromTriggerRows(UntypedResultSet rows) {
        Triggers.Builder triggers = Triggers.builder();
        rows.forEach(row -> triggers.add(LegacySchemaMigrator.createTriggerFromTriggerRow(row)));
        return triggers.build();
    }

    private static TriggerMetadata createTriggerFromTriggerRow(UntypedResultSet.Row row) {
        String name = row.getString("trigger_name");
        String classOption = row.getTextMap("trigger_options").get("class");
        return new TriggerMetadata(name, classOption);
    }

    private static Collection<Type> readTypes(String keyspaceName) {
        String query = String.format("SELECT type_name FROM %s.%s WHERE keyspace_name = ?", "system", "schema_usertypes");
        ArrayList typeNames = new ArrayList();
        LegacySchemaMigrator.query(query, keyspaceName).forEach(row -> typeNames.add(row.getString("type_name")));
        ArrayList<Type> types = new ArrayList<Type>();
        typeNames.forEach(name -> types.add(LegacySchemaMigrator.readType(keyspaceName, name)));
        return types;
    }

    private static Type readType(String keyspaceName, String typeName) {
        long timestamp = LegacySchemaMigrator.readTypeTimestamp(keyspaceName, typeName);
        UserType metadata = LegacySchemaMigrator.readTypeMetadata(keyspaceName, typeName);
        return new Type(timestamp, metadata);
    }

    /*
     * Exception decompiling
     */
    private static long readTypeTimestamp(String keyspaceName, String typeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static UserType readTypeMetadata(String keyspaceName, String typeName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND type_name = ?", "system", "schema_usertypes");
        UntypedResultSet.Row row = LegacySchemaMigrator.query(query, keyspaceName, typeName).one();
        List<ByteBuffer> names = row.getList("field_names", UTF8Type.instance).stream().map(ByteBufferUtil::bytes).collect(Collectors.toList());
        List<AbstractType<?>> types = row.getList("field_types", UTF8Type.instance).stream().map(LegacySchemaMigrator::parseType).collect(Collectors.toList());
        return new UserType(keyspaceName, ByteBufferUtil.bytes(typeName), names, types);
    }

    private static Collection<Function> readFunctions(String keyspaceName) {
        String query = String.format("SELECT function_name, signature FROM %s.%s WHERE keyspace_name = ?", "system", "schema_functions");
        HashMultimap functionSignatures = HashMultimap.create();
        LegacySchemaMigrator.query(query, keyspaceName).forEach(row -> functionSignatures.put((Object)row.getString("function_name"), row.getList("signature", UTF8Type.instance)));
        ArrayList<Function> functions = new ArrayList<Function>();
        functionSignatures.entries().forEach(pair -> functions.add(LegacySchemaMigrator.readFunction(keyspaceName, (String)pair.getKey(), (List)pair.getValue())));
        return functions;
    }

    private static Function readFunction(String keyspaceName, String functionName, List<String> signature) {
        long timestamp = LegacySchemaMigrator.readFunctionTimestamp(keyspaceName, functionName, signature);
        UDFunction metadata = LegacySchemaMigrator.readFunctionMetadata(keyspaceName, functionName, signature);
        return new Function(timestamp, metadata);
    }

    private static long readFunctionTimestamp(String keyspaceName, String functionName, List<String> signature) {
        String query = String.format("SELECT writeTime(return_type) AS timestamp FROM %s.%s WHERE keyspace_name = ? AND function_name = ? AND signature = ?", "system", "schema_functions");
        return LegacySchemaMigrator.query(query, keyspaceName, functionName, signature).one().getLong("timestamp");
    }

    private static UDFunction readFunctionMetadata(String keyspaceName, String functionName, List<String> signature) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND function_name = ? AND signature = ?", "system", "schema_functions");
        UntypedResultSet.Row row = LegacySchemaMigrator.query(query, keyspaceName, functionName, signature).one();
        FunctionName name = new FunctionName(keyspaceName, functionName);
        ArrayList<ColumnIdentifier> argNames = new ArrayList<ColumnIdentifier>();
        if (row.has("argument_names")) {
            for (String string : row.getList("argument_names", UTF8Type.instance)) {
                argNames.add(new ColumnIdentifier(string, true));
            }
        }
        ArrayList argTypes = new ArrayList();
        if (row.has("argument_types")) {
            for (String type : row.getList("argument_types", UTF8Type.instance)) {
                argTypes.add(LegacySchemaMigrator.parseType(type));
            }
        }
        AbstractType<?> abstractType = LegacySchemaMigrator.parseType(row.getString("return_type"));
        String language = row.getString("language");
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBoolean("called_on_null_input");
        try {
            return UDFunction.create(name, argNames, argTypes, abstractType, calledOnNullInput, language, body);
        }
        catch (InvalidRequestException e) {
            return UDFunction.createBrokenFunction(name, argNames, argTypes, abstractType, calledOnNullInput, language, body, e);
        }
    }

    private static Collection<Aggregate> readAggregates(String keyspaceName) {
        String query = String.format("SELECT aggregate_name, signature FROM %s.%s WHERE keyspace_name = ?", "system", "schema_aggregates");
        HashMultimap aggregateSignatures = HashMultimap.create();
        LegacySchemaMigrator.query(query, keyspaceName).forEach(row -> aggregateSignatures.put((Object)row.getString("aggregate_name"), row.getList("signature", UTF8Type.instance)));
        ArrayList<Aggregate> aggregates = new ArrayList<Aggregate>();
        aggregateSignatures.entries().forEach(pair -> aggregates.add(LegacySchemaMigrator.readAggregate(keyspaceName, (String)pair.getKey(), (List)pair.getValue())));
        return aggregates;
    }

    private static Aggregate readAggregate(String keyspaceName, String aggregateName, List<String> signature) {
        long timestamp = LegacySchemaMigrator.readAggregateTimestamp(keyspaceName, aggregateName, signature);
        UDAggregate metadata = LegacySchemaMigrator.readAggregateMetadata(keyspaceName, aggregateName, signature);
        return new Aggregate(timestamp, metadata);
    }

    private static long readAggregateTimestamp(String keyspaceName, String aggregateName, List<String> signature) {
        String query = String.format("SELECT writeTime(return_type) AS timestamp FROM %s.%s WHERE keyspace_name = ? AND aggregate_name = ? AND signature = ?", "system", "schema_aggregates");
        return LegacySchemaMigrator.query(query, keyspaceName, aggregateName, signature).one().getLong("timestamp");
    }

    private static UDAggregate readAggregateMetadata(String keyspaceName, String functionName, List<String> signature) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND function_name = ? AND signature = ?", "system", "schema_aggregates");
        UntypedResultSet.Row row = LegacySchemaMigrator.query(query, keyspaceName, functionName, signature).one();
        FunctionName name = new FunctionName(keyspaceName, functionName);
        List<String> types = row.getList("argument_types", UTF8Type.instance);
        ArrayList argTypes = new ArrayList();
        if (types != null) {
            argTypes = new ArrayList(types.size());
            for (String type : types) {
                argTypes.add(LegacySchemaMigrator.parseType(type));
            }
        }
        AbstractType<?> returnType = LegacySchemaMigrator.parseType(row.getString("return_type"));
        FunctionName stateFunc = new FunctionName(keyspaceName, row.getString("state_func"));
        FunctionName finalFunc = row.has("final_func") ? new FunctionName(keyspaceName, row.getString("final_func")) : null;
        AbstractType<?> stateType = row.has("state_type") ? LegacySchemaMigrator.parseType(row.getString("state_type")) : null;
        ByteBuffer initcond = row.has("initcond") ? row.getBytes("initcond") : null;
        try {
            return UDAggregate.create(name, argTypes, returnType, stateFunc, finalFunc, stateType, initcond);
        }
        catch (InvalidRequestException reason) {
            return UDAggregate.createBroken(name, argTypes, returnType, initcond, reason);
        }
    }

    private static UntypedResultSet query(String query, Object ... values) {
        return QueryProcessor.executeOnceInternal(query, values);
    }

    private static AbstractType<?> parseType(String str) {
        return TypeParser.parse(str);
    }

    private static final class Aggregate {
        final long timestamp;
        final UDAggregate metadata;

        Aggregate(long timestamp, UDAggregate metadata) {
            this.timestamp = timestamp;
            this.metadata = metadata;
        }
    }

    private static final class Function {
        final long timestamp;
        final UDFunction metadata;

        Function(long timestamp, UDFunction metadata) {
            this.timestamp = timestamp;
            this.metadata = metadata;
        }
    }

    private static final class Type {
        final long timestamp;
        final UserType metadata;

        Type(long timestamp, UserType metadata) {
            this.timestamp = timestamp;
            this.metadata = metadata;
        }
    }

    private static final class Table {
        final long timestamp;
        final CFMetaData metadata;

        Table(long timestamp, CFMetaData metadata) {
            this.timestamp = timestamp;
            this.metadata = metadata;
        }
    }

    private static final class Keyspace {
        final long timestamp;
        final String name;
        final KeyspaceParams params;
        final Collection<Table> tables;
        final Collection<Type> types;
        final Collection<Function> functions;
        final Collection<Aggregate> aggregates;

        Keyspace(long timestamp, String name, KeyspaceParams params, Collection<Table> tables, Collection<Type> types, Collection<Function> functions, Collection<Aggregate> aggregates) {
            this.timestamp = timestamp;
            this.name = name;
            this.params = params;
            this.tables = tables;
            this.types = types;
            this.functions = functions;
            this.aggregates = aggregates;
        }
    }
}

