/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SSTableTxnWriter
extends Transactional.AbstractTransactional
implements Transactional {
    private final LifecycleTransaction txn;
    private final SSTableWriter writer;

    public SSTableTxnWriter(LifecycleTransaction txn, SSTableWriter writer) {
        this.txn = txn;
        this.writer = writer;
    }

    public RowIndexEntry append(UnfilteredRowIterator iterator) {
        return this.writer.append(iterator);
    }

    public String getFilename() {
        return this.writer.getFilename();
    }

    public long getFilePointer() {
        return this.writer.getFilePointer();
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.txn.commit(this.writer.commit(accumulate));
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.txn.abort(this.writer.abort(accumulate));
    }

    @Override
    protected void doPrepare() {
        this.writer.prepareToCommit();
        this.txn.prepareToCommit();
    }

    public SSTableReader finish(boolean openResult) {
        this.writer.setOpenResult(openResult);
        this.finish();
        return this.writer.finished();
    }

    public static SSTableTxnWriter create(Descriptor descriptor, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header) {
        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.WRITE, descriptor.directory);
        SSTableWriter writer = SSTableWriter.create(descriptor, keyCount, repairedAt, sstableLevel, header, txn);
        return new SSTableTxnWriter(txn, writer);
    }

    public static SSTableTxnWriter create(String filename, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header) {
        Descriptor desc = Descriptor.fromFilename(filename);
        return SSTableTxnWriter.create(desc, keyCount, repairedAt, sstableLevel, header);
    }

    public static SSTableTxnWriter create(String filename, long keyCount, long repairedAt, SerializationHeader header) {
        return SSTableTxnWriter.create(filename, keyCount, repairedAt, 0, header);
    }
}

