/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ObjectSizes;

public class IndexHelper {
    public static void skipBloomFilter(DataInput in) throws IOException {
        int size = in.readInt();
        FileUtils.skipBytesFully(in, size);
    }

    public static void skipIndex(DataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (in instanceof FileDataInput) {
            FileUtils.skipBytesFully(in, columnIndexSize);
        } else {
            byte[] skip = new byte[columnIndexSize];
            in.readFully(skip);
        }
    }

    public static int indexFor(ClusteringPrefix name, List<IndexInfo> indexList, ClusteringComparator comparator, boolean reversed, int lastIndex) {
        int index;
        IndexInfo target = new IndexInfo(name, name, 0L, 0L, null);
        int startIdx = 0;
        List<IndexInfo> toSearch = indexList;
        if (reversed) {
            if (lastIndex < indexList.size() - 1) {
                toSearch = indexList.subList(0, lastIndex + 1);
            }
        } else if (lastIndex > 0) {
            startIdx = lastIndex;
            toSearch = indexList.subList(lastIndex, indexList.size());
        }
        return startIdx + ((index = Collections.binarySearch(toSearch, target, comparator.indexComparator(reversed))) < 0 ? -index - (reversed ? 2 : 1) : index);
    }

    public static class IndexInfo {
        private static final long EMPTY_SIZE = ObjectSizes.measure(new IndexInfo(null, null, 0L, 0L, null));
        public final long width;
        public final ClusteringPrefix lastName;
        public final ClusteringPrefix firstName;
        public final long offset;
        public final DeletionTime endOpenMarker;

        public IndexInfo(ClusteringPrefix firstName, ClusteringPrefix lastName, long offset, long width, DeletionTime endOpenMarker) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
            this.endOpenMarker = endOpenMarker;
        }

        public long unsharedHeapSize() {
            return EMPTY_SIZE + this.firstName.unsharedHeapSize() + this.lastName.unsharedHeapSize() + (this.endOpenMarker == null ? 0L : this.endOpenMarker.unsharedHeapSize());
        }

        public static class Serializer {
            private final CFMetaData metadata;
            private final Version version;

            public Serializer(CFMetaData metadata, Version version) {
                this.metadata = metadata;
                this.version = version;
            }

            public void serialize(IndexInfo info, DataOutputPlus out, SerializationHeader header) throws IOException {
                ISerializer<ClusteringPrefix> clusteringSerializer = this.metadata.serializers().clusteringPrefixSerializer(this.version, header);
                clusteringSerializer.serialize(info.firstName, out);
                clusteringSerializer.serialize(info.lastName, out);
                out.writeLong(info.offset);
                out.writeLong(info.width);
                if (this.version.storeRows()) {
                    out.writeBoolean(info.endOpenMarker != null);
                    if (info.endOpenMarker != null) {
                        DeletionTime.serializer.serialize(info.endOpenMarker, out);
                    }
                }
            }

            public IndexInfo deserialize(DataInputPlus in, SerializationHeader header) throws IOException {
                ISerializer<ClusteringPrefix> clusteringSerializer = this.metadata.serializers().clusteringPrefixSerializer(this.version, header);
                ClusteringPrefix firstName = clusteringSerializer.deserialize(in);
                ClusteringPrefix lastName = clusteringSerializer.deserialize(in);
                long offset = in.readLong();
                long width = in.readLong();
                DeletionTime endOpenMarker = this.version.storeRows() && in.readBoolean() ? DeletionTime.serializer.deserialize(in) : null;
                return new IndexInfo(firstName, lastName, offset, width, endOpenMarker);
            }

            public long serializedSize(IndexInfo info, SerializationHeader header) {
                ISerializer<ClusteringPrefix> clusteringSerializer = this.metadata.serializers().clusteringPrefixSerializer(this.version, header);
                long size = clusteringSerializer.serializedSize(info.firstName) + clusteringSerializer.serializedSize(info.lastName) + (long)TypeSizes.sizeof(info.offset) + (long)TypeSizes.sizeof(info.width);
                if (this.version.storeRows()) {
                    size += (long)TypeSizes.sizeof(info.endOpenMarker != null);
                    if (info.endOpenMarker != null) {
                        size += DeletionTime.serializer.serializedSize(info.endOpenMarker);
                    }
                }
                return size;
            }
        }
    }
}

