/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOException;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.SearchIterator;

public class UnfilteredSerializer {
    public static final UnfilteredSerializer serializer = new UnfilteredSerializer();
    private static final int END_OF_PARTITION = 1;
    private static final int IS_MARKER = 2;
    private static final int IS_STATIC = 4;
    private static final int HAS_TIMESTAMP = 8;
    private static final int HAS_TTL = 16;
    private static final int HAS_DELETION = 32;
    private static final int HAS_COMPLEX_DELETION = 64;

    public void serialize(Unfiltered unfiltered, SerializationHeader header, DataOutputPlus out, int version) throws IOException {
        if (unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            this.serialize((RangeTombstoneMarker)unfiltered, header, out, version);
        } else {
            this.serialize((Row)unfiltered, header, out, version);
        }
    }

    public void serialize(Row row, SerializationHeader header, DataOutputPlus out, int version) throws IOException {
        int i;
        int flags = 0;
        boolean isStatic = row.isStatic();
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        DeletionTime deletion = row.deletion();
        boolean hasComplexDeletion = row.hasComplexDeletion();
        if (isStatic) {
            flags |= 4;
        }
        if (!pkLiveness.isEmpty()) {
            flags |= 8;
        }
        if (pkLiveness.isExpiring()) {
            flags |= 0x10;
        }
        if (!deletion.isLive()) {
            flags |= 0x20;
        }
        if (hasComplexDeletion) {
            flags |= 0x40;
        }
        out.writeByte((byte)flags);
        if (!isStatic) {
            Clustering.serializer.serialize(row.clustering(), out, version, header.clusteringTypes());
        }
        if ((flags & 8) != 0) {
            header.writeTimestamp(pkLiveness.timestamp(), out);
        }
        if ((flags & 0x10) != 0) {
            header.writeTTL(pkLiveness.ttl(), out);
            header.writeLocalDeletionTime(pkLiveness.localExpirationTime(), out);
        }
        if ((flags & 0x20) != 0) {
            header.writeDeletionTime(deletion, out);
        }
        Columns columns = header.columns(isStatic);
        int simpleCount = columns.simpleColumnCount();
        boolean useSparse = header.useSparseColumnLayout(isStatic);
        SearchIterator<ColumnDefinition, ColumnData> cells = row.searchIterator();
        for (i = 0; i < simpleCount; ++i) {
            this.writeSimpleColumn(i, (Cell)cells.next(columns.getSimple(i)), pkLiveness, header, out, useSparse);
        }
        for (i = simpleCount; i < columns.columnCount(); ++i) {
            this.writeComplexColumn(i, (ComplexColumnData)cells.next(columns.getComplex(i - simpleCount)), hasComplexDeletion, pkLiveness, header, out, useSparse);
        }
        if (useSparse) {
            out.writeVInt(-1L);
        }
    }

    private void writeSimpleColumn(int idx, Cell cell, LivenessInfo rowLiveness, SerializationHeader header, DataOutputPlus out, boolean useSparse) throws IOException {
        if (useSparse) {
            if (cell == null) {
                return;
            }
            out.writeVInt(idx);
        }
        Cell.serializer.serialize(cell, out, rowLiveness, header);
    }

    private void writeComplexColumn(int idx, ComplexColumnData data, boolean hasComplexDeletion, LivenessInfo rowLiveness, SerializationHeader header, DataOutputPlus out, boolean useSparse) throws IOException {
        if (useSparse) {
            if (data == null) {
                return;
            }
            out.writeVInt(idx);
        }
        if (hasComplexDeletion) {
            header.writeDeletionTime(data == null ? DeletionTime.LIVE : data.complexDeletion(), out);
        }
        if (data != null) {
            for (Cell cell : data) {
                Cell.serializer.serialize(cell, out, rowLiveness, header);
            }
        }
        Cell.serializer.serialize(null, out, rowLiveness, header);
    }

    public void serialize(RangeTombstoneMarker marker, SerializationHeader header, DataOutputPlus out, int version) throws IOException {
        out.writeByte(2);
        RangeTombstone.Bound.serializer.serialize(marker.clustering(), out, version, header.clusteringTypes());
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            header.writeDeletionTime(bm.endDeletionTime(), out);
            header.writeDeletionTime(bm.startDeletionTime(), out);
        } else {
            header.writeDeletionTime(((RangeTombstoneBoundMarker)marker).deletionTime(), out);
        }
    }

    public long serializedSize(Unfiltered unfiltered, SerializationHeader header, int version) {
        return unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER ? this.serializedSize((RangeTombstoneMarker)unfiltered, header, version) : this.serializedSize((Row)unfiltered, header, version);
    }

    public long serializedSize(Row row, SerializationHeader header, int version) {
        int i;
        long size = 1L;
        boolean isStatic = row.isStatic();
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        DeletionTime deletion = row.deletion();
        boolean hasComplexDeletion = row.hasComplexDeletion();
        if (!isStatic) {
            size += Clustering.serializer.serializedSize(row.clustering(), version, header.clusteringTypes());
        }
        if (!pkLiveness.isEmpty()) {
            size += header.timestampSerializedSize(pkLiveness.timestamp());
        }
        if (pkLiveness.isExpiring()) {
            size += header.ttlSerializedSize(pkLiveness.ttl());
            size += header.localDeletionTimeSerializedSize(pkLiveness.localExpirationTime());
        }
        if (!deletion.isLive()) {
            size += header.deletionTimeSerializedSize(deletion);
        }
        Columns columns = header.columns(isStatic);
        int simpleCount = columns.simpleColumnCount();
        boolean useSparse = header.useSparseColumnLayout(isStatic);
        SearchIterator<ColumnDefinition, ColumnData> cells = row.searchIterator();
        for (i = 0; i < simpleCount; ++i) {
            size += this.sizeOfSimpleColumn(i, (Cell)cells.next(columns.getSimple(i)), pkLiveness, header, useSparse);
        }
        for (i = simpleCount; i < columns.columnCount(); ++i) {
            size += this.sizeOfComplexColumn(i, (ComplexColumnData)cells.next(columns.getComplex(i - simpleCount)), hasComplexDeletion, pkLiveness, header, useSparse);
        }
        if (useSparse) {
            size += (long)TypeSizes.sizeofVInt(-1L);
        }
        return size;
    }

    private long sizeOfSimpleColumn(int idx, Cell cell, LivenessInfo rowLiveness, SerializationHeader header, boolean useSparse) {
        long size = 0L;
        if (useSparse) {
            if (cell == null) {
                return size;
            }
            size += (long)TypeSizes.sizeofVInt(idx);
        }
        return size + Cell.serializer.serializedSize(cell, rowLiveness, header);
    }

    private long sizeOfComplexColumn(int idx, ComplexColumnData data, boolean hasComplexDeletion, LivenessInfo rowLiveness, SerializationHeader header, boolean useSparse) {
        long size = 0L;
        if (useSparse) {
            if (data == null) {
                return size;
            }
            size += (long)TypeSizes.sizeofVInt(idx);
        }
        if (hasComplexDeletion) {
            size += header.deletionTimeSerializedSize(data == null ? DeletionTime.LIVE : data.complexDeletion());
        }
        if (data != null) {
            for (Cell cell : data) {
                size += Cell.serializer.serializedSize(cell, rowLiveness, header);
            }
        }
        return size + Cell.serializer.serializedSize(null, rowLiveness, header);
    }

    public long serializedSize(RangeTombstoneMarker marker, SerializationHeader header, int version) {
        long size = 1L + RangeTombstone.Bound.serializer.serializedSize(marker.clustering(), version, header.clusteringTypes());
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            size += header.deletionTimeSerializedSize(bm.endDeletionTime());
            size += header.deletionTimeSerializedSize(bm.startDeletionTime());
        } else {
            size += header.deletionTimeSerializedSize(((RangeTombstoneBoundMarker)marker).deletionTime());
        }
        return size;
    }

    public void writeEndOfPartition(DataOutputPlus out) throws IOException {
        out.writeByte(1);
    }

    public long serializedSizeEndOfPartition() {
        return 1L;
    }

    public Unfiltered deserialize(DataInputPlus in, SerializationHeader header, SerializationHelper helper, Row.Builder builder) throws IOException {
        assert (builder.isSorted());
        int flags = in.readUnsignedByte();
        if (UnfilteredSerializer.isEndOfPartition(flags)) {
            return null;
        }
        if (UnfilteredSerializer.kind(flags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            RangeTombstone.Bound bound = RangeTombstone.Bound.serializer.deserialize(in, helper.version, header.clusteringTypes());
            return this.deserializeMarkerBody(in, header, bound);
        }
        assert (!UnfilteredSerializer.isStatic(flags));
        builder.newRow(Clustering.serializer.deserialize(in, helper.version, header.clusteringTypes()));
        return this.deserializeRowBody(in, header, helper, flags, builder);
    }

    public Row deserializeStaticRow(DataInputPlus in, SerializationHeader header, SerializationHelper helper) throws IOException {
        int flags = in.readUnsignedByte();
        assert (!UnfilteredSerializer.isEndOfPartition(flags) && UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW && UnfilteredSerializer.isStatic(flags)) : flags;
        Row.Builder builder = BTreeBackedRow.sortedBuilder(helper.fetchedStaticColumns(header));
        builder.newRow(Clustering.STATIC_CLUSTERING);
        return this.deserializeRowBody(in, header, helper, flags, builder);
    }

    public RangeTombstoneMarker deserializeMarkerBody(DataInputPlus in, SerializationHeader header, RangeTombstone.Bound bound) throws IOException {
        if (bound.isBoundary()) {
            return new RangeTombstoneBoundaryMarker(bound, header.readDeletionTime(in), header.readDeletionTime(in));
        }
        return new RangeTombstoneBoundMarker(bound, header.readDeletionTime(in));
    }

    public Row deserializeRowBody(DataInputPlus in, SerializationHeader header, SerializationHelper helper, int flags, Row.Builder builder) throws IOException {
        try {
            boolean isStatic = UnfilteredSerializer.isStatic(flags);
            boolean hasTimestamp = (flags & 8) != 0;
            boolean hasTTL = (flags & 0x10) != 0;
            boolean hasDeletion = (flags & 0x20) != 0;
            boolean hasComplexDeletion = (flags & 0x40) != 0;
            LivenessInfo rowLiveness = LivenessInfo.EMPTY;
            if (hasTimestamp) {
                long timestamp = header.readTimestamp(in);
                int ttl = hasTTL ? header.readTTL(in) : 0;
                int localDeletionTime = hasTTL ? header.readLocalDeletionTime(in) : Integer.MAX_VALUE;
                rowLiveness = LivenessInfo.create(timestamp, ttl, localDeletionTime);
            }
            builder.addPrimaryKeyLivenessInfo(rowLiveness);
            builder.addRowDeletion(hasDeletion ? header.readDeletionTime(in) : DeletionTime.LIVE);
            Columns columns = header.columns(isStatic);
            if (header.useSparseColumnLayout(isStatic)) {
                int i;
                int count = columns.columnCount();
                int simpleCount = columns.simpleColumnCount();
                while ((i = (int)in.readVInt()) >= 0) {
                    if (i > count) {
                        throw new IOException(String.format("Impossible column index %d, the header has only %d columns defined", i, count));
                    }
                    if (i < simpleCount) {
                        this.readSimpleColumn(columns.getSimple(i), in, header, helper, builder, rowLiveness);
                        continue;
                    }
                    this.readComplexColumn(columns.getComplex(i - simpleCount), in, header, helper, hasComplexDeletion, builder, rowLiveness);
                }
            } else {
                int i;
                for (i = 0; i < columns.simpleColumnCount(); ++i) {
                    this.readSimpleColumn(columns.getSimple(i), in, header, helper, builder, rowLiveness);
                }
                for (i = 0; i < columns.complexColumnCount(); ++i) {
                    this.readComplexColumn(columns.getComplex(i), in, header, helper, hasComplexDeletion, builder, rowLiveness);
                }
            }
            return builder.build();
        }
        catch (AssertionError | RuntimeException e) {
            throw new IOException("Error building row with data deserialized from " + in, (Throwable)e);
        }
    }

    private void readSimpleColumn(ColumnDefinition column, DataInputPlus in, SerializationHeader header, SerializationHelper helper, Row.Builder builder, LivenessInfo rowLiveness) throws IOException {
        if (helper.includes(column)) {
            Cell cell = Cell.serializer.deserialize(in, rowLiveness, column, header, helper);
            if (cell != null && !helper.isDropped(cell, false)) {
                builder.addCell(cell);
            }
        } else {
            Cell.serializer.skip(in, column, header);
        }
    }

    private void readComplexColumn(ColumnDefinition column, DataInputPlus in, SerializationHeader header, SerializationHelper helper, boolean hasComplexDeletion, Row.Builder builder, LivenessInfo rowLiveness) throws IOException {
        if (helper.includes(column)) {
            Cell cell;
            DeletionTime complexDeletion;
            helper.startOfComplexColumn(column);
            if (hasComplexDeletion && !helper.isDroppedComplexDeletion(complexDeletion = header.readDeletionTime(in))) {
                builder.addComplexDeletion(column, complexDeletion);
            }
            while ((cell = Cell.serializer.deserialize(in, rowLiveness, column, header, helper)) != null) {
                if (!helper.includes(cell.path()) || helper.isDropped(cell, true)) continue;
                builder.addCell(cell);
            }
            helper.endOfComplexColumn();
        } else {
            this.skipComplexColumn(in, column, header, hasComplexDeletion);
        }
    }

    public void skipRowBody(DataInputPlus in, SerializationHeader header, int flags) throws IOException {
        boolean hasComplexDeletion;
        boolean isStatic = UnfilteredSerializer.isStatic(flags);
        boolean hasTimestamp = (flags & 8) != 0;
        boolean hasTTL = (flags & 0x10) != 0;
        boolean hasDeletion = (flags & 0x20) != 0;
        boolean bl = hasComplexDeletion = (flags & 0x40) != 0;
        if (hasTimestamp) {
            header.skipTimestamp(in);
        }
        if (hasTTL) {
            header.skipLocalDeletionTime(in);
            header.skipTTL(in);
        }
        if (hasDeletion) {
            header.skipDeletionTime(in);
        }
        Columns columns = header.columns(isStatic);
        if (header.useSparseColumnLayout(isStatic)) {
            int i;
            int count = columns.columnCount();
            int simpleCount = columns.simpleColumnCount();
            while ((i = (int)in.readVInt()) >= 0) {
                if (i > count) {
                    throw new IOException(String.format("Impossible column index %d, the header has only %d columns defined", i, count));
                }
                if (i < simpleCount) {
                    Cell.serializer.skip(in, columns.getSimple(i), header);
                    continue;
                }
                this.skipComplexColumn(in, columns.getComplex(i - simpleCount), header, hasComplexDeletion);
            }
        } else {
            int i;
            for (i = 0; i < columns.simpleColumnCount(); ++i) {
                Cell.serializer.skip(in, columns.getSimple(i), header);
            }
            for (i = 0; i < columns.complexColumnCount(); ++i) {
                this.skipComplexColumn(in, columns.getComplex(i), header, hasComplexDeletion);
            }
        }
    }

    public void skipStaticRow(DataInputPlus in, SerializationHeader header, SerializationHelper helper) throws IOException {
        int flags = in.readUnsignedByte();
        assert (!UnfilteredSerializer.isEndOfPartition(flags) && UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW && UnfilteredSerializer.isStatic(flags)) : "Flags is " + flags;
        this.skipRowBody(in, header, flags);
    }

    public void skipMarkerBody(DataInputPlus in, SerializationHeader header, boolean isBoundary) throws IOException {
        if (isBoundary) {
            header.skipDeletionTime(in);
            header.skipDeletionTime(in);
        } else {
            header.skipDeletionTime(in);
        }
    }

    private void skipComplexColumn(DataInputPlus in, ColumnDefinition column, SerializationHeader header, boolean hasComplexDeletion) throws IOException {
        if (hasComplexDeletion) {
            header.skipDeletionTime(in);
        }
        while (Cell.serializer.skip(in, column, header)) {
        }
    }

    public static boolean isEndOfPartition(int flags) {
        return (flags & 1) != 0;
    }

    public static Unfiltered.Kind kind(int flags) {
        return (flags & 2) != 0 ? Unfiltered.Kind.RANGE_TOMBSTONE_MARKER : Unfiltered.Kind.ROW;
    }

    public static boolean isStatic(int flags) {
        return (flags & 2) == 0 && (flags & 4) != 0;
    }
}

