/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;

public interface Row
extends Unfiltered,
Iterable<ColumnData> {
    @Override
    public Clustering clustering();

    public Columns columns();

    public DeletionTime deletion();

    public LivenessInfo primaryKeyLivenessInfo();

    public boolean isStatic();

    public boolean isEmpty();

    public boolean hasLiveData(int var1);

    public Cell getCell(ColumnDefinition var1);

    public Cell getCell(ColumnDefinition var1, CellPath var2);

    public ComplexColumnData getComplexColumnData(ColumnDefinition var1);

    public Iterable<Cell> cells();

    public boolean hasComplexDeletion();

    public boolean hasDeletion(int var1);

    public SearchIterator<ColumnDefinition, ColumnData> searchIterator();

    public Row filter(ColumnFilter var1, CFMetaData var2);

    public Row filter(ColumnFilter var1, DeletionTime var2, boolean var3, CFMetaData var4);

    public Row purge(DeletionPurger var1, int var2);

    public Row markCounterLocalToBeCleared();

    public Row updateAllTimestamp(long var1);

    public int dataSize();

    public long unsharedHeapSizeExcludingData();

    @Override
    public String toString(CFMetaData var1, boolean var2);

    public static class Merger {
        private final Columns columns;
        private final Row[] rows;
        private final List<Iterator<ColumnData>> columnDataIterators;
        private Clustering clustering;
        private int rowsToMerge;
        private int lastRowSet = -1;
        private final List<ColumnData> dataBuffer = new ArrayList<ColumnData>();
        private final ColumnDataReducer columnDataReducer;

        public Merger(int size, int nowInSec, Columns columns) {
            this.columns = columns;
            this.rows = new Row[size];
            this.columnDataIterators = new ArrayList<Iterator<ColumnData>>(size);
            this.columnDataReducer = new ColumnDataReducer(size, nowInSec, columns.hasComplex());
        }

        public void clear() {
            this.dataBuffer.clear();
            Arrays.fill(this.rows, null);
            this.columnDataIterators.clear();
            this.rowsToMerge = 0;
            this.lastRowSet = -1;
        }

        public void add(int i, Row row) {
            this.clustering = row.clustering();
            this.rows[i] = row;
            ++this.rowsToMerge;
            this.lastRowSet = i;
        }

        public Row merge(DeletionTime activeDeletion) {
            if (this.rowsToMerge == 1 && activeDeletion.isLive()) {
                Row row = this.rows[this.lastRowSet];
                assert (row != null);
                return row;
            }
            LivenessInfo rowInfo = LivenessInfo.EMPTY;
            DeletionTime rowDeletion = DeletionTime.LIVE;
            for (Row row : this.rows) {
                if (row == null) continue;
                if (row.primaryKeyLivenessInfo().supersedes(rowInfo)) {
                    rowInfo = row.primaryKeyLivenessInfo();
                }
                if (!row.deletion().supersedes(rowDeletion)) continue;
                rowDeletion = row.deletion();
            }
            if (activeDeletion.supersedes(rowDeletion)) {
                rowDeletion = DeletionTime.LIVE;
            } else {
                activeDeletion = rowDeletion;
            }
            if (activeDeletion.deletes(rowInfo)) {
                rowInfo = LivenessInfo.EMPTY;
            }
            for (Row row : this.rows) {
                this.columnDataIterators.add(row == null ? Collections.emptyIterator() : row.iterator());
            }
            this.columnDataReducer.setActiveDeletion(activeDeletion);
            MergeIterator<ColumnData, ColumnData> merged = MergeIterator.get(this.columnDataIterators, ColumnData.comparator, this.columnDataReducer);
            while (merged.hasNext()) {
                ColumnData data = (ColumnData)merged.next();
                if (data == null) continue;
                this.dataBuffer.add(data);
            }
            return rowInfo.isEmpty() && rowDeletion.isLive() && this.dataBuffer.isEmpty() ? null : BTreeBackedRow.create(this.clustering, this.columns, rowInfo, rowDeletion, BTree.build(this.dataBuffer, UpdateFunction.noOp()));
        }

        public Clustering mergedClustering() {
            return this.clustering;
        }

        public Row[] mergedRows() {
            return this.rows;
        }

        private static class CellReducer
        extends MergeIterator.Reducer<Cell, Cell> {
            private final int nowInSec;
            private DeletionTime activeDeletion;
            private Cell merged;

            public CellReducer(int nowInSec) {
                this.nowInSec = nowInSec;
            }

            public void setActiveDeletion(DeletionTime activeDeletion) {
                this.activeDeletion = activeDeletion;
                this.onKeyChange();
            }

            @Override
            public void reduce(int idx, Cell cell) {
                if (!this.activeDeletion.deletes(cell)) {
                    this.merged = this.merged == null ? cell : Cells.reconcile(this.merged, cell, this.nowInSec);
                }
            }

            @Override
            protected Cell getReduced() {
                return this.merged;
            }

            @Override
            protected void onKeyChange() {
                this.merged = null;
            }
        }

        private static class ColumnDataReducer
        extends MergeIterator.Reducer<ColumnData, ColumnData> {
            private final int nowInSec;
            private ColumnDefinition column;
            private final List<ColumnData> versions;
            private DeletionTime activeDeletion;
            private final ComplexColumnData.Builder complexBuilder;
            private final List<Iterator<Cell>> complexCells;
            private final CellReducer cellReducer;

            public ColumnDataReducer(int size, int nowInSec, boolean hasComplex) {
                this.nowInSec = nowInSec;
                this.versions = new ArrayList<ColumnData>(size);
                this.complexBuilder = hasComplex ? ComplexColumnData.builder() : null;
                this.complexCells = hasComplex ? new ArrayList(size) : null;
                this.cellReducer = new CellReducer(nowInSec);
            }

            public void setActiveDeletion(DeletionTime activeDeletion) {
                this.activeDeletion = activeDeletion;
            }

            @Override
            public void reduce(int idx, ColumnData data) {
                this.column = data.column();
                this.versions.add(data);
            }

            @Override
            protected ColumnData getReduced() {
                if (this.column.isSimple()) {
                    Cell merged = null;
                    for (ColumnData data : this.versions) {
                        Cell cell = (Cell)data;
                        if (this.activeDeletion.deletes(cell)) continue;
                        merged = merged == null ? cell : Cells.reconcile(merged, cell, this.nowInSec);
                    }
                    return merged;
                }
                this.complexBuilder.newColumn(this.column);
                this.complexCells.clear();
                DeletionTime complexDeletion = DeletionTime.LIVE;
                for (ColumnData data : this.versions) {
                    ComplexColumnData cd = (ComplexColumnData)data;
                    if (cd.complexDeletion().supersedes(complexDeletion)) {
                        complexDeletion = cd.complexDeletion();
                    }
                    this.complexCells.add(cd.iterator());
                }
                if (complexDeletion.supersedes(this.activeDeletion)) {
                    this.cellReducer.setActiveDeletion(complexDeletion);
                    this.complexBuilder.addComplexDeletion(complexDeletion);
                } else {
                    this.cellReducer.setActiveDeletion(this.activeDeletion);
                }
                MergeIterator<Cell, Cell> cells = MergeIterator.get(this.complexCells, ColumnData.comparator, this.cellReducer);
                while (cells.hasNext()) {
                    Cell merged = (Cell)cells.next();
                    if (merged == null) continue;
                    this.complexBuilder.addCell(merged);
                }
                return this.complexBuilder.build();
            }

            @Override
            protected void onKeyChange() {
                this.versions.clear();
            }
        }
    }

    public static interface Builder {
        public boolean isSorted();

        public void newRow(Clustering var1);

        public Clustering clustering();

        public void addPrimaryKeyLivenessInfo(LivenessInfo var1);

        public void addRowDeletion(DeletionTime var1);

        public void addCell(Cell var1);

        public void addComplexDeletion(ColumnDefinition var1, DeletionTime var2);

        public Row build();
    }
}

