/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class EncodingStats {
    private static final long TIMESTAMP_EPOCH;
    private static final int DELETION_TIME_EPOCH;
    private static final int TTL_EPOCH = 0;
    public static final EncodingStats NO_STATS;
    public static final Serializer serializer;
    public final long minTimestamp;
    public final int minLocalDeletionTime;
    public final int minTTL;
    public final int avgColumnSetPerRow;

    public EncodingStats(long minTimestamp, int minLocalDeletionTime, int minTTL, int avgColumnSetPerRow) {
        this.minTimestamp = minTimestamp == Long.MIN_VALUE ? TIMESTAMP_EPOCH : minTimestamp;
        this.minLocalDeletionTime = minLocalDeletionTime == Integer.MAX_VALUE ? DELETION_TIME_EPOCH : minLocalDeletionTime;
        this.minTTL = minTTL;
        this.avgColumnSetPerRow = avgColumnSetPerRow;
    }

    public EncodingStats mergeWith(EncodingStats that) {
        int minTTL;
        int minDelTime;
        long minTimestamp;
        long l = this.minTimestamp == TIMESTAMP_EPOCH ? that.minTimestamp : (minTimestamp = that.minTimestamp == TIMESTAMP_EPOCH ? this.minTimestamp : Math.min(this.minTimestamp, that.minTimestamp));
        int n = this.minLocalDeletionTime == DELETION_TIME_EPOCH ? that.minLocalDeletionTime : (minDelTime = that.minLocalDeletionTime == DELETION_TIME_EPOCH ? this.minLocalDeletionTime : Math.min(this.minLocalDeletionTime, that.minLocalDeletionTime));
        int n2 = this.minTTL == 0 ? that.minTTL : (minTTL = that.minTTL == 0 ? this.minTTL : Math.min(this.minTTL, that.minTTL));
        int avgColumnSetPerRow = this.avgColumnSetPerRow < 0 ? that.avgColumnSetPerRow : (that.avgColumnSetPerRow < 0 ? this.avgColumnSetPerRow : (this.avgColumnSetPerRow + that.avgColumnSetPerRow) / 2);
        return new EncodingStats(minTimestamp, minDelTime, minTTL, avgColumnSetPerRow);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingStats that = (EncodingStats)o;
        return this.avgColumnSetPerRow == that.avgColumnSetPerRow && this.minLocalDeletionTime == that.minLocalDeletionTime && this.minTTL == that.minTTL && this.minTimestamp == that.minTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.minTimestamp, this.minLocalDeletionTime, this.minTTL, this.avgColumnSetPerRow);
    }

    public String toString() {
        return String.format("EncodingStats(ts=%d, ldt=%d, ttl=%d, avgColPerRow=%d)", this.minTimestamp, this.minLocalDeletionTime, this.minTTL, this.avgColumnSetPerRow);
    }

    static {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"), Locale.US);
        c.set(1, 2015);
        c.set(2, 8);
        c.set(5, 22);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        TIMESTAMP_EPOCH = c.getTimeInMillis() * 1000L;
        DELETION_TIME_EPOCH = (int)(c.getTimeInMillis() / 1000L);
        NO_STATS = new EncodingStats(TIMESTAMP_EPOCH, DELETION_TIME_EPOCH, 0, -1);
        serializer = new Serializer();
    }

    public static class Serializer {
        public void serialize(EncodingStats stats, DataOutputPlus out) throws IOException {
            out.writeVInt(stats.minTimestamp - TIMESTAMP_EPOCH);
            out.writeVInt(stats.minLocalDeletionTime - DELETION_TIME_EPOCH);
            out.writeVInt(stats.minTTL - 0);
            out.writeVInt(stats.avgColumnSetPerRow);
        }

        public int serializedSize(EncodingStats stats) {
            return TypeSizes.sizeofVInt(stats.minTimestamp - TIMESTAMP_EPOCH) + TypeSizes.sizeofVInt(stats.minLocalDeletionTime - DELETION_TIME_EPOCH) + TypeSizes.sizeofVInt(stats.minTTL - 0) + TypeSizes.sizeofVInt(stats.avgColumnSetPerRow);
        }

        public EncodingStats deserialize(DataInputPlus in) throws IOException {
            long minTimestamp = in.readVInt() + TIMESTAMP_EPOCH;
            int minLocalDeletionTime = (int)in.readVInt() + DELETION_TIME_EPOCH;
            int minTTL = (int)in.readVInt() + 0;
            int avgColumnSetPerRow = (int)in.readVInt();
            return new EncodingStats(minTimestamp, minLocalDeletionTime, minTTL, avgColumnSetPerRow);
        }
    }

    public static class Collector
    implements PartitionStatisticsCollector {
        private boolean isTimestampSet;
        private long minTimestamp = Long.MAX_VALUE;
        private boolean isDelTimeSet;
        private int minDeletionTime = Integer.MAX_VALUE;
        private boolean isTTLSet;
        private int minTTL = Integer.MAX_VALUE;
        private boolean isColumnSetPerRowSet;
        private long totalColumnsSet;
        private long rows;

        @Override
        public void update(LivenessInfo info) {
            if (info.isEmpty()) {
                return;
            }
            this.updateTimestamp(info.timestamp());
            if (info.isExpiring()) {
                this.updateTTL(info.ttl());
                this.updateLocalDeletionTime(info.localExpirationTime());
            }
        }

        @Override
        public void update(Cell cell) {
            this.updateTimestamp(cell.timestamp());
            if (cell.isExpiring()) {
                this.updateTTL(cell.ttl());
                this.updateLocalDeletionTime(cell.localDeletionTime());
            } else if (cell.isTombstone()) {
                this.updateLocalDeletionTime(cell.localDeletionTime());
            }
        }

        @Override
        public void update(DeletionTime deletionTime) {
            if (deletionTime.isLive()) {
                return;
            }
            this.updateTimestamp(deletionTime.markedForDeleteAt());
            this.updateLocalDeletionTime(deletionTime.localDeletionTime());
        }

        public void updateTimestamp(long timestamp) {
            this.isTimestampSet = true;
            this.minTimestamp = Math.min(this.minTimestamp, timestamp);
        }

        public void updateLocalDeletionTime(int deletionTime) {
            this.isDelTimeSet = true;
            this.minDeletionTime = Math.min(this.minDeletionTime, deletionTime);
        }

        public void updateTTL(int ttl) {
            this.isTTLSet = true;
            this.minTTL = Math.min(this.minTTL, ttl);
        }

        @Override
        public void updateColumnSetPerRow(long columnSetInRow) {
            this.updateColumnSetPerRow(columnSetInRow, 1L);
        }

        public void updateColumnSetPerRow(long totalColumnsSet, long rows) {
            if (totalColumnsSet < 0L || rows < 0L) {
                return;
            }
            this.isColumnSetPerRowSet = true;
            this.totalColumnsSet += totalColumnsSet;
            this.rows += rows;
        }

        @Override
        public void updateHasLegacyCounterShards(boolean hasLegacyCounterShards) {
        }

        public EncodingStats get() {
            return new EncodingStats(this.isTimestampSet ? this.minTimestamp : TIMESTAMP_EPOCH, this.isDelTimeSet ? this.minDeletionTime : DELETION_TIME_EPOCH, this.isTTLSet ? this.minTTL : 0, this.isColumnSetPerRowSet ? (this.rows == 0L ? 0 : (int)(this.totalColumnsSet / this.rows)) : -1);
        }
    }
}

