/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;

public abstract class AbstractCell
extends Cell {
    protected AbstractCell(ColumnDefinition column) {
        super(column);
    }

    @Override
    public void digest(MessageDigest digest) {
        digest.update(this.value().duplicate());
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithInt(digest, this.localDeletionTime());
        FBUtilities.updateWithInt(digest, this.ttl());
        FBUtilities.updateWithBoolean(digest, this.isCounterCell());
        if (this.path() != null) {
            this.path().digest(digest);
        }
    }

    @Override
    public void validate() {
        this.column().validateCellValue(this.value());
        if (this.ttl() < 0) {
            throw new MarshalException("A TTL should not be negative");
        }
        if (this.localDeletionTime() < 0) {
            throw new MarshalException("A local deletion time should not be negative");
        }
        if (this.isExpiring() && this.localDeletionTime() == Integer.MAX_VALUE) {
            throw new MarshalException("Shoud not have a TTL without an associated local deletion time");
        }
        if (this.isTombstone() && this.value().hasRemaining()) {
            throw new MarshalException("A tombstone should not have a value");
        }
        if (this.path() != null) {
            this.column().validateCellPath(this.path());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Cell)) {
            return false;
        }
        Cell that = (Cell)other;
        return this.column().equals(that.column()) && this.isCounterCell() == that.isCounterCell() && this.timestamp() == that.timestamp() && this.ttl() == that.ttl() && this.localDeletionTime() == that.localDeletionTime() && Objects.equals(this.value(), that.value()) && Objects.equals(this.path(), that.path());
    }

    public int hashCode() {
        return Objects.hash(this.column(), this.isCounterCell(), this.timestamp(), this.ttl(), this.localDeletionTime(), this.value(), this.path());
    }

    public String toString() {
        if (this.isCounterCell()) {
            return String.format("[%s=%d ts=%d]", this.column().name, CounterContext.instance().total(this.value()), this.timestamp());
        }
        AbstractType type = this.column().type;
        if (type instanceof CollectionType && type.isMultiCell()) {
            CollectionType ct = (CollectionType)type;
            return String.format("[%s[%s]=%s %s]", this.column().name, ct.nameComparator().getString(this.path().get(0)), ct.valueComparator().getString(this.value()), this.livenessInfoString());
        }
        return String.format("[%s=%s %s]", this.column().name, type.getString(this.value()), this.livenessInfoString());
    }

    private String livenessInfoString() {
        if (this.isExpiring()) {
            return String.format("ts=%d ttl=%d ldt=%d", this.timestamp(), this.ttl(), this.localDeletionTime());
        }
        if (this.isTombstone()) {
            return String.format("ts=%d ldt=%d", this.timestamp(), this.localDeletionTime());
        }
        return String.format("ts=%d", this.timestamp());
    }
}

