/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.AbstractThreadUnsafePartition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;

public class FilteredPartition
extends AbstractThreadUnsafePartition {
    private final Row staticRow;

    private FilteredPartition(CFMetaData metadata, DecoratedKey partitionKey, PartitionColumns columns, Row staticRow, List<Row> rows) {
        super(metadata, partitionKey, columns, rows);
        this.staticRow = staticRow;
    }

    public static FilteredPartition create(RowIterator iterator) {
        CFMetaData metadata = iterator.metadata();
        boolean reversed = iterator.isReverseOrder();
        ArrayList<Row> rows = new ArrayList<Row>();
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            if (!unfiltered.isRow()) continue;
            rows.add((Row)unfiltered);
        }
        if (reversed) {
            Collections.reverse(rows);
        }
        return new FilteredPartition(metadata, iterator.partitionKey(), iterator.columns(), iterator.staticRow(), rows);
    }

    @Override
    protected boolean canHaveShadowedData() {
        return false;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return DeletionInfo.LIVE;
    }

    @Override
    public EncodingStats stats() {
        return EncodingStats.NO_STATS;
    }

    public RowIterator rowIterator() {
        final Iterator<Row> iter = this.iterator();
        return new RowIterator(){

            @Override
            public CFMetaData metadata() {
                return FilteredPartition.this.metadata;
            }

            @Override
            public boolean isReverseOrder() {
                return false;
            }

            @Override
            public PartitionColumns columns() {
                return FilteredPartition.this.columns;
            }

            @Override
            public DecoratedKey partitionKey() {
                return FilteredPartition.this.key;
            }

            @Override
            public Row staticRow() {
                return FilteredPartition.this.staticRow();
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row next() {
                return (Row)iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%s.%s] key=%s columns=%s", this.metadata.ksName, this.metadata.cfName, this.metadata.getKeyValidator().getString(this.partitionKey().getKey()), this.columns));
        if (this.staticRow() != Rows.EMPTY_STATIC_ROW) {
            sb.append("\n    ").append(this.staticRow().toString(this.metadata));
        }
        for (Row row : this) {
            sb.append("\n    ").append(row.toString(this.metadata));
        }
        return sb.toString();
    }
}

