/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Blocker;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogs
extends Transactional.AbstractTransactional
implements Transactional {
    private static final Logger logger = LoggerFactory.getLogger(TransactionLogs.class);
    private final Tracker tracker;
    private final TransactionData data;
    private final Ref<TransactionLogs> selfRef;
    private static final Queue<Runnable> failedDeletions = new ConcurrentLinkedQueue<Runnable>();
    private static final Blocker blocker = new Blocker();

    TransactionLogs(OperationType opType, CFMetaData metadata) {
        this(opType, metadata, null);
    }

    TransactionLogs(OperationType opType, CFMetaData metadata, Tracker tracker) {
        this(opType, new Directories(metadata), tracker);
    }

    TransactionLogs(OperationType opType, Directories directories, Tracker tracker) {
        this(opType, directories.getDirectoryForNewSSTables(), tracker);
    }

    TransactionLogs(OperationType opType, File folder, Tracker tracker) {
        this.tracker = tracker;
        this.data = new TransactionData(opType, Directories.getTransactionsDirectory(folder), UUIDGen.getTimeUUID());
        this.selfRef = new Ref<TransactionLogs>(this, new TransactionTidier(this.data));
        this.data.crossReference();
        if (logger.isDebugEnabled()) {
            logger.debug("Created transaction logs with id {}", (Object)this.data.id);
        }
    }

    void trackNew(SSTable table) {
        if (!this.data.newLog().add(table)) {
            throw new IllegalStateException(table + " is already tracked as new");
        }
        this.data.newLog().add(table);
    }

    void untrackNew(SSTable table) {
        this.data.newLog().remove(table);
    }

    SSTableTidier obsoleted(SSTableReader reader) {
        if (this.data.newLog().contains(reader)) {
            if (this.data.oldLog().contains(reader)) {
                throw new IllegalArgumentException();
            }
            return new SSTableTidier(reader, true, this);
        }
        if (!this.data.oldLog().add(reader)) {
            throw new IllegalStateException();
        }
        if (this.tracker != null) {
            this.tracker.notifyDeleting(reader);
        }
        return new SSTableTidier(reader, false, this);
    }

    OperationType getType() {
        return this.data.getType();
    }

    UUID getId() {
        return this.data.getId();
    }

    @VisibleForTesting
    String getDataFolder() {
        return this.data.getParentFolder();
    }

    @VisibleForTesting
    String getLogsFolder() {
        return StringUtils.join((Object[])new String[]{this.getDataFolder(), File.separator, "transactions"});
    }

    @VisibleForTesting
    TransactionData getData() {
        return this.data;
    }

    private static void delete(File file) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleting {}", (Object)file);
            }
            Files.delete(file.toPath());
        }
        catch (NoSuchFileException e) {
            logger.warn("Unable to delete {} as it does not exist", (Object)file);
        }
        catch (IOException e) {
            logger.error("Unable to delete {}", (Object)file, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static void rescheduleFailedDeletions() {
        Runnable task;
        while (null != (task = failedDeletions.poll())) {
            ScheduledExecutors.nonPeriodicTasks.submit(task);
        }
    }

    public static void waitForDeletions() {
        FBUtilities.waitOnFuture(ScheduledExecutors.nonPeriodicTasks.schedule(() -> {}, 0L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    public static void pauseDeletions(boolean stop) {
        blocker.block(stop);
    }

    private Throwable complete(Throwable accumulate) {
        try {
            try {
                if (this.data.succeeded) {
                    this.data.newLog().delete(false);
                } else {
                    this.data.oldLog().delete(false);
                }
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
            accumulate = this.selfRef.ensureReleased(accumulate);
            return accumulate;
        }
        catch (Throwable t) {
            logger.error("Failed to complete file transaction {}", (Object)this.getId(), (Object)t);
            return Throwables.merge(accumulate, t);
        }
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        this.data.succeeded(true);
        return this.complete(accumulate);
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        this.data.succeeded(false);
        return this.complete(accumulate);
    }

    @Override
    protected void doPrepare() {
    }

    static void removeUnfinishedLeftovers(CFMetaData metadata) {
        Throwable accumulate = null;
        HashSet<UUID> ids = new HashSet<UUID>();
        for (File dir : TransactionLogs.getFolders(metadata, null)) {
            File[] logs;
            for (File log : logs = dir.listFiles((dir1, name) -> TransactionData.isLogFile(name))) {
                try (TransactionData data = TransactionData.make(log);){
                    if (ids.contains(data.id)) continue;
                    ids.add(data.id);
                    accumulate = data.removeUnfinishedLeftovers(accumulate);
                }
            }
        }
        if (accumulate != null) {
            logger.error("Failed to remove unfinished transaction leftovers", accumulate);
        }
    }

    static Set<File> getTemporaryFiles(CFMetaData metadata, File folder) {
        HashSet<File> ret = new HashSet<File>();
        HashSet<UUID> ids = new HashSet<UUID>();
        for (File dir : TransactionLogs.getFolders(metadata, folder)) {
            File[] logs;
            for (File log : logs = dir.listFiles((dir1, name) -> TransactionData.isLogFile(name))) {
                try (TransactionData data = TransactionData.make(log);){
                    if (ids.contains(data.id)) continue;
                    ids.add(data.id);
                    ret.addAll(data.getTemporaryFiles().stream().filter(file2 -> FileUtils.isContained(folder, file2)).collect(Collectors.toSet()));
                }
            }
        }
        return ret;
    }

    static Set<File> getLogFiles(CFMetaData metadata) {
        HashSet<File> ret = new HashSet<File>();
        for (File dir : TransactionLogs.getFolders(metadata, null)) {
            ret.addAll(Arrays.asList(dir.listFiles((dir1, name) -> TransactionData.isLogFile(name))));
        }
        return ret;
    }

    private static List<File> getFolders(CFMetaData metadata, File folder) {
        File opDir;
        ArrayList<File> ret = new ArrayList<File>();
        if (metadata != null) {
            Directories directories = new Directories(metadata);
            ret.addAll(directories.getExistingDirectories("transactions"));
        }
        if (folder != null && (opDir = Directories.getExistingDirectory(folder, "transactions")) != null) {
            ret.add(opDir);
        }
        return ret;
    }

    public static class SSTableTidier
    implements Runnable {
        private final Descriptor desc;
        private final long sizeOnDisk;
        private final Tracker tracker;
        private final boolean wasNew;
        private final Ref<TransactionLogs> parentRef;

        public SSTableTidier(SSTableReader referent, boolean wasNew, TransactionLogs parent) {
            this.desc = referent.descriptor;
            this.sizeOnDisk = referent.bytesOnDisk();
            this.tracker = parent.tracker;
            this.wasNew = wasNew;
            this.parentRef = parent.selfRef.tryRef();
        }

        @Override
        public void run() {
            blocker.ask();
            SystemKeyspace.clearSSTableReadMeter(this.desc.ksname, this.desc.cfname, this.desc.generation);
            try {
                File datafile = new File(this.desc.filenameFor(Component.DATA));
                TransactionLogs.delete(datafile);
                SSTable.delete(this.desc, SSTable.discoverComponentsFor(this.desc));
            }
            catch (Throwable t) {
                logger.error("Failed deletion for {}, we'll retry after GC and on server restart", (Object)this.desc);
                failedDeletions.add(this);
                return;
            }
            if (this.tracker != null && !this.wasNew) {
                this.tracker.cfstore.metric.totalDiskSpaceUsed.dec(this.sizeOnDisk);
            }
            this.parentRef.release();
        }

        public void abort() {
            this.parentRef.release();
        }
    }

    static class Obsoletion {
        final SSTableReader reader;
        final SSTableTidier tidier;

        public Obsoletion(SSTableReader reader, SSTableTidier tidier) {
            this.reader = reader;
            this.tidier = tidier;
        }
    }

    private static class TransactionTidier
    implements RefCounted.Tidy,
    Runnable {
        private final TransactionData data;

        public TransactionTidier(TransactionData data) {
            this.data = data;
        }

        @Override
        public void tidy() throws Exception {
            this.run();
        }

        @Override
        public String name() {
            return this.data.id.toString();
        }

        @Override
        public void run() {
            Throwable err;
            if (logger.isDebugEnabled()) {
                logger.debug("Removing files for transaction {}", (Object)this.name());
            }
            if ((err = this.data.removeUnfinishedLeftovers(null)) != null) {
                logger.info("Failed deleting files for transaction {}, we'll retry after GC and on on server restart", (Object)this.name(), (Object)err);
                failedDeletions.add(this);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Closing file transaction {}", (Object)this.name());
                }
                this.data.close();
            }
        }
    }

    static final class TransactionData
    implements AutoCloseable {
        private final OperationType opType;
        private final UUID id;
        private final File folder;
        private final TransactionFile[] files;
        private int folderDescriptor;
        private boolean succeeded;

        static TransactionData make(File logFile) {
            Matcher matcher = TransactionFile.REGEX.matcher(logFile.getName());
            assert (matcher.matches());
            OperationType operationType = OperationType.fromFileName(matcher.group(1));
            UUID id = UUID.fromString(matcher.group(2));
            return new TransactionData(operationType, logFile.getParentFile(), id);
        }

        TransactionData(OperationType opType, File folder, UUID id) {
            this.opType = opType;
            this.id = id;
            this.folder = folder;
            this.files = new TransactionFile[TransactionFile.Type.values().length];
            for (TransactionFile.Type t : TransactionFile.Type.values()) {
                this.files[t.idx] = new TransactionFile(t, this);
            }
            this.folderDescriptor = CLibrary.tryOpenDirectory(folder.getPath());
            this.succeeded = !this.newLog().exists() && this.oldLog().exists();
        }

        public void succeeded(boolean succeeded) {
            this.succeeded = succeeded;
        }

        @Override
        public void close() {
            if (this.folderDescriptor > 0) {
                CLibrary.tryCloseFD(this.folderDescriptor);
                this.folderDescriptor = -1;
            }
        }

        void crossReference() {
            this.newLog().add(this.oldLog().file.getPath());
            this.oldLog().add(this.newLog().file.getPath());
        }

        void sync() {
            if (this.folderDescriptor > 0) {
                CLibrary.trySync(this.folderDescriptor);
            }
        }

        TransactionFile newLog() {
            return this.files[TransactionFile.Type.NEW.idx];
        }

        TransactionFile oldLog() {
            return this.files[TransactionFile.Type.OLD.idx];
        }

        OperationType getType() {
            return this.opType;
        }

        UUID getId() {
            return this.id;
        }

        Throwable removeUnfinishedLeftovers(Throwable accumulate) {
            try {
                if (this.succeeded) {
                    this.oldLog().delete(true);
                } else {
                    this.newLog().delete(true);
                }
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
            return accumulate;
        }

        Set<File> getTemporaryFiles() {
            this.sync();
            if (this.newLog().exists()) {
                return this.newLog().getTrackedFiles();
            }
            return this.oldLog().getTrackedFiles();
        }

        String getFileName(TransactionFile.Type type) {
            String fileName = StringUtils.join((Object[])new Serializable[]{this.opType.fileName, Character.valueOf(TransactionFile.SEP), this.id.toString(), Character.valueOf(TransactionFile.SEP), type.txt, TransactionFile.EXT});
            return StringUtils.join((Object[])new Serializable[]{this.folder, File.separator, fileName});
        }

        String getParentFolder() {
            return this.folder.getParent();
        }

        static boolean isLogFile(String name) {
            return TransactionFile.REGEX.matcher(name).matches();
        }
    }

    static final class TransactionFile {
        static String EXT = ".log";
        static char SEP = (char)95;
        static String REGEX_STR = String.format("^(.*)_(.*)_(%s|%s)%s$", Type.NEW.txt, Type.OLD.txt, EXT);
        static Pattern REGEX = Pattern.compile(REGEX_STR);
        public final Type type;
        public final File file;
        public final TransactionData parent;
        public final Set<String> lines = new HashSet<String>();

        public TransactionFile(Type type, TransactionData parent) {
            this.type = type;
            this.file = new File(parent.getFileName(type));
            this.parent = parent;
            if (this.exists()) {
                this.lines.addAll(FileUtils.readLines(this.file));
            }
        }

        public boolean add(SSTable table) {
            return this.add(table.descriptor.baseFilename());
        }

        private boolean add(String path) {
            String relativePath = FileUtils.getRelativePath(this.parent.getParentFolder(), path);
            if (this.lines.contains(relativePath)) {
                return false;
            }
            this.lines.add(relativePath);
            FileUtils.append(this.file, relativePath);
            return true;
        }

        public void remove(SSTable table) {
            String relativePath = FileUtils.getRelativePath(this.parent.getParentFolder(), table.descriptor.baseFilename());
            assert (this.lines.contains(relativePath)) : String.format("%s is not tracked by %s", relativePath, this.file);
            this.lines.remove(relativePath);
            this.delete(relativePath);
        }

        public boolean contains(SSTable table) {
            String relativePath = FileUtils.getRelativePath(this.parent.getParentFolder(), table.descriptor.baseFilename());
            return this.lines.contains(relativePath);
        }

        private void deleteContents() {
            this.deleteOpposite();
            this.parent.sync();
            this.lines.forEach(line -> this.delete((String)line));
            this.lines.clear();
        }

        private void deleteOpposite() {
            Type oppositeType = this.type == Type.NEW ? Type.OLD : Type.NEW;
            String oppositeFile = FileUtils.getRelativePath(this.parent.getParentFolder(), this.parent.getFileName(oppositeType));
            assert (this.lines.contains(oppositeFile)) : String.format("Could not find %s amongst lines", oppositeFile);
            this.delete(oppositeFile);
            this.lines.remove(oppositeFile);
        }

        private void delete(String relativePath) {
            this.getTrackedFiles(relativePath).forEach(file -> TransactionLogs.delete(file));
        }

        public Set<File> getTrackedFiles() {
            HashSet<File> ret = new HashSet<File>();
            FileUtils.readLines(this.file).forEach(line -> ret.addAll(this.getTrackedFiles((String)line)));
            ret.add(this.file);
            return ret;
        }

        private List<File> getTrackedFiles(String relativePath) {
            ArrayList<File> ret = new ArrayList<File>();
            File file = new File(StringUtils.join((Object[])new String[]{this.parent.getParentFolder(), File.separator, relativePath}));
            if (file.exists()) {
                ret.add(file);
            } else {
                ret.addAll(Arrays.asList(new File(this.parent.getParentFolder()).listFiles((dir, name) -> name.startsWith(relativePath))));
            }
            return ret;
        }

        public void delete(boolean deleteContents) {
            assert (this.file.exists()) : String.format("Expected %s to exists", this.file);
            if (deleteContents) {
                this.deleteContents();
            }
            this.parent.sync();
            TransactionLogs.delete(this.file);
        }

        public boolean exists() {
            return this.file.exists();
        }

        public static enum Type {
            NEW(0, "new"),
            OLD(1, "old");

            public final int idx;
            public final String txt;

            private Type(int idx, String txt) {
                this.idx = idx;
                this.txt = txt;
            }
        }
    }
}

