/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.partitions.ArrayBackedPartition;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(SecondaryIndexManager indexManager, Set<ColumnDefinition> columns) {
        super(indexManager, columns);
    }

    @Override
    protected UnfilteredPartitionIterator queryDataFromIndex(final AbstractSimplePerColumnSecondaryIndex index, final DecoratedKey indexKey, final RowIterator indexHits, final ReadCommand command, final ReadOrderGroup orderGroup) {
        assert (indexHits.staticRow() == Rows.EMPTY_STATIC_ROW);
        return new UnfilteredPartitionIterator(){
            private UnfilteredRowIterator next;

            @Override
            public boolean isForThrift() {
                return command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return command.metadata();
            }

            @Override
            public boolean hasNext() {
                return this.prepareNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                if (this.next == null) {
                    this.prepareNext();
                }
                UnfilteredRowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private boolean prepareNext() {
                while (this.next == null && indexHits.hasNext()) {
                    Row hit = (Row)indexHits.next();
                    DecoratedKey key = ((KeysSearcher)KeysSearcher.this).baseCfs.partitioner.decorateKey(hit.clustering().get(0));
                    SinglePartitionReadCommand<?> dataCmd = SinglePartitionReadCommand.create(this.isForThrift(), ((KeysSearcher)KeysSearcher.this).baseCfs.metadata, command.nowInSec(), command.columnFilter(), command.rowFilter(), DataLimits.NONE, key, command.clusteringIndexFilter(key));
                    UnfilteredRowIterator dataIter = KeysSearcher.this.filterIfStale(dataCmd.queryMemtableAndDisk(KeysSearcher.this.baseCfs, orderGroup.baseReadOpOrderGroup()), index, hit, indexKey.getKey(), orderGroup.writeOpOrderGroup(), this.isForThrift(), command.nowInSec());
                    if (dataIter == null) continue;
                    if (dataIter.isEmpty()) {
                        dataIter.close();
                        continue;
                    }
                    this.next = dataIter;
                }
                return this.next != null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                indexHits.close();
                if (this.next != null) {
                    this.next.close();
                }
            }
        };
    }

    private UnfilteredRowIterator filterIfStale(UnfilteredRowIterator iterator, AbstractSimplePerColumnSecondaryIndex index, Row indexHit, ByteBuffer indexedValue, OpOrder.Group writeOp, boolean isForThrift, int nowInSec) {
        Cell cell;
        if (isForThrift) {
            ArrayBackedPartition result = ArrayBackedPartition.create(iterator);
            iterator.close();
            Row data = result.getRow(new Clustering(index.indexedColumn().name.bytes));
            Cell cell2 = data == null ? null : data.getCell(this.baseCfs.metadata.compactValueColumn());
            return this.deleteIfStale(iterator.partitionKey(), cell2, index, indexHit, indexedValue, writeOp, nowInSec) ? null : result.unfilteredIterator();
        }
        assert (iterator.metadata().isCompactTable());
        Row data = iterator.staticRow();
        Cell cell3 = cell = data == null ? null : data.getCell(index.indexedColumn());
        if (this.deleteIfStale(iterator.partitionKey(), cell, index, indexHit, indexedValue, writeOp, nowInSec)) {
            iterator.close();
            return null;
        }
        return iterator;
    }

    private boolean deleteIfStale(DecoratedKey partitionKey, Cell cell, AbstractSimplePerColumnSecondaryIndex index, Row indexHit, ByteBuffer indexedValue, OpOrder.Group writeOp, int nowInSec) {
        if (cell == null || !cell.isLive(nowInSec) || index.indexedColumn().type.compare(indexedValue, cell.value()) != 0) {
            index.delete(partitionKey.getKey(), new Clustering(index.indexedColumn().name.bytes), indexedValue, null, new DeletionTime(indexHit.primaryKeyLivenessInfo().timestamp(), nowInSec), writeOp);
            return true;
        }
        return false;
    }
}

