/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CompositesIndexOnPartitionKey
extends CompositesIndex {
    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        CompositeType keyComparator = (CompositeType)this.baseCfs.metadata.getKeyValidator();
        ByteBuffer[] components = keyComparator.split(rowKey);
        return components[this.columnDef.position()];
    }

    @Override
    protected CBuilder buildIndexClusteringPrefix(ByteBuffer rowKey, ClusteringPrefix prefix, CellPath path) {
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(rowKey);
        for (int i = 0; i < prefix.size(); ++i) {
            builder.add(prefix.get(i));
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Row indexEntry) {
        int ckCount = this.baseCfs.metadata.clusteringColumns().size();
        Clustering clustering = indexEntry.clustering();
        CBuilder builder = CBuilder.create(this.baseCfs.getComparator());
        for (int i = 0; i < ckCount; ++i) {
            builder.add(clustering.get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, clustering, indexEntry.primaryKeyLivenessInfo().timestamp(), clustering.get(0), builder.build());
    }

    @Override
    protected boolean indexPrimaryKeyColumn() {
        return true;
    }

    @Override
    public boolean indexes(ColumnDefinition c) {
        return false;
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, int nowInSec) {
        return !data.hasLiveData(nowInSec);
    }

    @Override
    public void maybeIndex(ByteBuffer partitionKey, Clustering clustering, long timestamp, int ttl, OpOrder.Group opGroup, int nowInSec) {
        this.insert(partitionKey, clustering, null, LivenessInfo.create(this.indexCfs.metadata, timestamp, ttl, nowInSec), opGroup);
    }

    @Override
    public void delete(ByteBuffer rowKey, Clustering clustering, Cell cell, OpOrder.Group opGroup, int nowInSec) {
    }
}

