/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.index.composites.CompositesIndexIncludingCollectionKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;

public class CompositesIndexOnCollectionKeyAndValue
extends CompositesIndexIncludingCollectionKey {
    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        CollectionType colType = (CollectionType)this.columnDef.type;
        return CompositeType.getInstance(colType.nameComparator(), colType.valueComparator());
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        return CompositeType.build(path.get(0), cellValue);
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, int nowInSec) {
        ByteBuffer[] components = ((CompositeType)this.getIndexKeyComparator()).split(indexValue);
        ByteBuffer mapKey = components[0];
        ByteBuffer mapValue = components[1];
        Cell cell = data.getCell(this.columnDef, CellPath.create(mapKey));
        if (cell == null || !cell.isLive(nowInSec)) {
            return true;
        }
        AbstractType<?> valueComparator = ((CollectionType)this.columnDef.type).valueComparator();
        return valueComparator.compare(mapValue, cell.value()) != 0;
    }
}

