/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;

public abstract class CompositesIndexIncludingCollectionKey
extends CompositesIndex {
    @Override
    protected CBuilder buildIndexClusteringPrefix(ByteBuffer rowKey, ClusteringPrefix prefix, CellPath path) {
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(rowKey);
        for (int i = 0; i < prefix.size(); ++i) {
            builder.add(prefix.get(i));
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Row indexEntry) {
        int count = 1 + this.baseCfs.metadata.clusteringColumns().size();
        Clustering clustering = indexEntry.clustering();
        CBuilder builder = CBuilder.create(this.baseCfs.getComparator());
        for (int i = 0; i < count - 1; ++i) {
            builder.add(clustering.get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, clustering, indexEntry.primaryKeyLivenessInfo().timestamp(), clustering.get(0), builder.build());
    }
}

