/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.index.keys.KeysIndex;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.LocalByPartionerType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecondaryIndex {
    protected static final Logger logger = LoggerFactory.getLogger(SecondaryIndex.class);
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public static final String INDEX_KEYS_OPTION_NAME = "index_keys";
    public static final String INDEX_VALUES_OPTION_NAME = "index_values";
    public static final String INDEX_ENTRIES_OPTION_NAME = "index_keys_and_values";
    public static final AbstractType<?> keyComparator = StorageService.getPartitioner().preservesOrder() ? BytesType.instance : new LocalByPartionerType(StorageService.getPartitioner());
    protected ColumnFamilyStore baseCfs;
    protected final Set<ColumnDefinition> columnDefs = Collections.newSetFromMap(new ConcurrentHashMap());

    public abstract void init();

    public abstract void reload();

    public abstract void validateOptions() throws ConfigurationException;

    public abstract String getIndexName();

    String indexTypeForGrouping() {
        return this.getClass().getCanonicalName();
    }

    public abstract String getNameForSystemKeyspace(ByteBuffer var1);

    public boolean isIndexBuilt(ByteBuffer columnName) {
        return SystemKeyspace.isIndexBuilt(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(columnName));
    }

    public void setIndexBuilt() {
        for (ColumnDefinition columnDef : this.columnDefs) {
            SystemKeyspace.setIndexBuilt(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(columnDef.name.bytes));
        }
    }

    public void setIndexRemoved() {
        for (ColumnDefinition columnDef : this.columnDefs) {
            SystemKeyspace.setIndexRemoved(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(columnDef.name.bytes));
        }
    }

    protected abstract SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ColumnDefinition> var1);

    public abstract void forceBlockingFlush();

    public abstract ColumnFamilyStore getIndexCfs();

    public abstract void removeIndex(ByteBuffer var1);

    public abstract void invalidate();

    public abstract void truncateBlocking(long var1);

    protected void buildIndexBlocking() {
        logger.info(String.format("Submitting index build of %s for data in %s", this.getIndexName(), StringUtils.join(this.baseCfs.getSSTables(SSTableSet.CANONICAL), (String)", ")));
        try (Refs<SSTableReader> sstables = this.baseCfs.selectAndReference(View.select((SSTableSet)SSTableSet.CANONICAL)).refs;){
            SecondaryIndexBuilder builder = new SecondaryIndexBuilder(this.baseCfs, Collections.singleton(this.getIndexName()), new ReducingKeyIterator(sstables));
            Future<?> future = CompactionManager.instance.submitIndexBuild(builder);
            FBUtilities.waitOnFuture(future);
            this.forceBlockingFlush();
            this.setIndexBuilt();
        }
        logger.info("Index build of {} complete", (Object)this.getIndexName());
    }

    public Future<?> buildIndexAsync() {
        boolean allAreBuilt = true;
        for (ColumnDefinition cdef : this.columnDefs) {
            if (SystemKeyspace.isIndexBuilt(this.baseCfs.keyspace.getName(), this.getNameForSystemKeyspace(cdef.name.bytes))) continue;
            allAreBuilt = false;
            break;
        }
        if (allAreBuilt) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SecondaryIndex.this.baseCfs.forceBlockingFlush();
                SecondaryIndex.this.buildIndexBlocking();
            }
        };
        FutureTask<Object> f = new FutureTask<Object>(runnable, null);
        new Thread(f, "Creating index: " + this.getIndexName()).start();
        return f;
    }

    public ColumnFamilyStore getBaseCfs() {
        return this.baseCfs;
    }

    private void setBaseCfs(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
    }

    public Set<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    void addColumnDef(ColumnDefinition columnDef) {
        this.columnDefs.add(columnDef);
    }

    void removeColumnDef(ByteBuffer name) {
        Iterator<ColumnDefinition> it = this.columnDefs.iterator();
        while (it.hasNext()) {
            if (!it.next().name.bytes.equals(name)) continue;
            it.remove();
        }
    }

    public boolean supportsOperator(Operator operator) {
        return operator == Operator.EQ;
    }

    public DecoratedKey getIndexKeyFor(ByteBuffer value) {
        return this.getIndexCfs().partitioner.decorateKey(value);
    }

    public abstract boolean indexes(ColumnDefinition var1);

    public static SecondaryIndex createInstance(ColumnFamilyStore baseCfs, ColumnDefinition cdef) throws ConfigurationException {
        SecondaryIndex index;
        switch (cdef.getIndexType()) {
            case KEYS: {
                index = new KeysIndex();
                break;
            }
            case COMPOSITES: {
                index = CompositesIndex.create(cdef);
                break;
            }
            case CUSTOM: {
                assert (cdef.getIndexOptions() != null);
                String class_name = cdef.getIndexOptions().get(CUSTOM_INDEX_OPTION_NAME);
                assert (class_name != null);
                try {
                    index = (SecondaryIndex)Class.forName(class_name).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new RuntimeException("Unknown index type: " + cdef.getIndexName());
            }
        }
        index.addColumnDef(cdef);
        ((SecondaryIndex)index).validateOptions();
        super.setBaseCfs(baseCfs);
        return index;
    }

    public abstract void validate(DecoratedKey var1) throws InvalidRequestException;

    public abstract void validate(Clustering var1) throws InvalidRequestException;

    public abstract void validate(ByteBuffer var1, CellPath var2) throws InvalidRequestException;

    public abstract long estimateResultRows();

    protected String baseKeyspace() {
        return this.baseCfs.metadata.ksName;
    }

    protected String baseTable() {
        return this.baseCfs.metadata.cfName;
    }

    public static CFMetaData newIndexMetadata(CFMetaData baseMetadata, ColumnDefinition def) {
        if (def.getIndexType() == IndexType.CUSTOM) {
            return null;
        }
        CFMetaData.Builder builder = CFMetaData.Builder.create(baseMetadata.ksName, baseMetadata.indexColumnFamilyName(def)).withId(baseMetadata.cfId).addPartitionKey(def.name, def.type);
        if (def.getIndexType() == IndexType.COMPOSITES) {
            CompositesIndex.addIndexClusteringColumns(builder, baseMetadata, def);
        } else {
            assert (def.getIndexType() == IndexType.KEYS);
            KeysIndex.addIndexClusteringColumns(builder, baseMetadata, def);
        }
        return builder.build().reloadIndexMetadataProperties(baseMetadata);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("columnDefs", this.columnDefs).toString();
    }
}

