/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class PerColumnSecondaryIndex
extends SecondaryIndex {
    public abstract void delete(ByteBuffer var1, Clustering var2, Cell var3, OpOrder.Group var4, int var5);

    public abstract void deleteForCleanup(ByteBuffer var1, Clustering var2, Cell var3, OpOrder.Group var4, int var5);

    public void maybeIndex(ByteBuffer partitionKey, Clustering clustering, long timestamp, int ttl, OpOrder.Group opGroup, int nowInSec) {
    }

    public void maybeDelete(ByteBuffer partitionKey, Clustering clustering, DeletionTime deletion, OpOrder.Group opGroup) {
    }

    public abstract void insert(ByteBuffer var1, Clustering var2, Cell var3, OpOrder.Group var4);

    public abstract void update(ByteBuffer var1, Clustering var2, Cell var3, Cell var4, OpOrder.Group var5, int var6);

    protected boolean indexPrimaryKeyColumn() {
        return false;
    }

    public void indexRow(DecoratedKey key, Row row, OpOrder.Group opGroup, int nowInSec) {
        Clustering clustering = row.clustering();
        if (this.indexPrimaryKeyColumn()) {
            long timestamp = row.primaryKeyLivenessInfo().timestamp();
            int ttl = row.primaryKeyLivenessInfo().ttl();
            for (Cell cell : row.cells()) {
                if (!cell.isLive(nowInSec) || cell.timestamp() <= timestamp) continue;
                timestamp = cell.timestamp();
                ttl = cell.ttl();
            }
            this.maybeIndex(key.getKey(), clustering, timestamp, ttl, opGroup, nowInSec);
        }
        for (Cell cell : row.cells()) {
            if (!this.indexes(cell.column()) || !cell.isLive(nowInSec)) continue;
            this.insert(key.getKey(), clustering, cell, opGroup);
        }
    }

    @Override
    public String getNameForSystemKeyspace(ByteBuffer column) {
        return this.getIndexName();
    }
}

