/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.File;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;

public class MaxSSTableSizeWriter
extends CompactionAwareWriter {
    private final long estimatedTotalKeys;
    private final long expectedWriteSize;
    private final long maxSSTableSize;
    private final int level;
    private final long estimatedSSTables;
    private final Set<SSTableReader> allSSTables;

    public MaxSSTableSizeWriter(ColumnFamilyStore cfs, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, int level, boolean offline) {
        super(cfs, txn, nonExpiredSSTables, offline);
        this.allSSTables = txn.originals();
        this.level = level;
        this.maxSSTableSize = maxSSTableSize;
        long totalSize = cfs.getExpectedCompactedFileSize(nonExpiredSSTables, txn.opType());
        this.expectedWriteSize = Math.min(maxSSTableSize, totalSize);
        this.estimatedTotalKeys = SSTableReader.getApproximateKeyCount(nonExpiredSSTables);
        this.estimatedSSTables = Math.max(1L, this.estimatedTotalKeys / maxSSTableSize);
        File sstableDirectory = cfs.directories.getLocationForDisk(this.getWriteDirectory(this.expectedWriteSize));
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(cfs.getSSTablePath(sstableDirectory)), this.estimatedTotalKeys / this.estimatedSSTables, (Long)this.minRepairedAt, cfs.metadata, cfs.partitioner, new MetadataCollector(this.allSSTables, cfs.metadata.comparator, level), SerializationHeader.make(cfs.metadata, nonExpiredSSTables), txn);
        this.sstableWriter.switchWriter(writer);
    }

    @Override
    public boolean append(UnfilteredRowIterator partition) {
        RowIndexEntry rie = this.sstableWriter.append(partition);
        if (this.sstableWriter.currentWriter().getOnDiskFilePointer() > this.maxSSTableSize) {
            File sstableDirectory = this.cfs.directories.getLocationForDisk(this.getWriteDirectory(this.expectedWriteSize));
            SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(sstableDirectory)), this.estimatedTotalKeys / this.estimatedSSTables, (Long)this.minRepairedAt, this.cfs.metadata, this.cfs.partitioner, new MetadataCollector(this.allSSTables, this.cfs.metadata.comparator, this.level), SerializationHeader.make(this.cfs.metadata, this.nonExpiredSSTables), this.txn);
            this.sstableWriter.switchWriter(writer);
        }
        return rie != null;
    }

    @Override
    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }
}

