/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class ReadOrderGroup
implements AutoCloseable {
    private final OpOrder.Group baseOp;
    private final OpOrder.Group indexOp;
    private final OpOrder.Group writeOp;

    private ReadOrderGroup(OpOrder.Group baseOp, OpOrder.Group indexOp, OpOrder.Group writeOp) {
        this.baseOp = baseOp;
        this.indexOp = indexOp;
        this.writeOp = writeOp;
    }

    public OpOrder.Group baseReadOpOrderGroup() {
        return this.baseOp;
    }

    public OpOrder.Group indexReadOpOrderGroup() {
        return this.indexOp;
    }

    public OpOrder.Group writeOpOrderGroup() {
        return this.writeOp;
    }

    public static ReadOrderGroup emptyGroup() {
        return new ReadOrderGroup(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadOrderGroup forCommand(ReadCommand command) {
        ColumnFamilyStore baseCfs = Keyspace.openAndGetStore(command.metadata());
        ColumnFamilyStore indexCfs = ReadOrderGroup.maybeGetIndexCfs(baseCfs, command);
        if (indexCfs == null) {
            return new ReadOrderGroup(baseCfs.readOrdering.start(), null, null);
        }
        OpOrder.Group baseOp = null;
        OpOrder.Group indexOp = null;
        try {
            baseOp = baseCfs.readOrdering.start();
            indexOp = indexCfs.readOrdering.start();
            Keyspace cfr_ignored_0 = baseCfs.keyspace;
            OpOrder.Group writeOp = Keyspace.writeOrder.start();
            return new ReadOrderGroup(baseOp, indexOp, writeOp);
        }
        catch (RuntimeException e) {
            try {
                if (baseOp != null) {
                    baseOp.close();
                }
            }
            finally {
                if (indexOp != null) {
                    indexOp.close();
                }
            }
            throw e;
        }
    }

    private static ColumnFamilyStore maybeGetIndexCfs(ColumnFamilyStore baseCfs, ReadCommand command) {
        SecondaryIndexSearcher searcher = command.getIndexSearcher(baseCfs);
        if (searcher == null) {
            return null;
        }
        SecondaryIndex index = searcher.highestSelectivityIndex(command.rowFilter());
        return index == null || !(index instanceof AbstractSimplePerColumnSecondaryIndex) ? null : ((AbstractSimplePerColumnSecondaryIndex)index).getIndexCfs();
    }

    @Override
    public void close() {
        try {
            if (this.baseOp != null) {
                this.baseOp.close();
            }
        }
        finally {
            if (this.indexOp != null) {
                try {
                    this.indexOp.close();
                }
                finally {
                    this.writeOp.close();
                }
            }
        }
    }
}

