/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionsUpdateVerbHandler
implements IVerbHandler<Collection<Mutation>> {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionsUpdateVerbHandler.class);

    @Override
    public void doVerb(final MessageIn<Collection<Mutation>> message, int id) {
        logger.debug("Received schema mutation push from {}", (Object)message.from);
        StageManager.getStage(Stage.MIGRATION).submit(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                SchemaKeyspace.mergeSchema((Collection)message.payload);
            }
        });
    }
}

