/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.KeyspaceNotDefinedException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class DropMaterializedViewStatement
extends SchemaAlteringStatement {
    public final boolean ifExists;

    public DropMaterializedViewStatement(CFName cf, boolean ifExists) {
        super(cf);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.DROP);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        try {
            CFMetaData viewCfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily());
            if (viewCfm == null) {
                throw new ConfigurationException(String.format("Cannot drop non existing materialized view '%s' in keyspace '%s'.", this.columnFamily(), this.keyspace()));
            }
            if (!viewCfm.isMaterializedView()) {
                throw new ConfigurationException(String.format("Cannot drop non materialized view '%s' in keyspace '%s'", this.columnFamily(), this.keyspace()));
            }
            CFMetaData baseCfm = this.findBaseCf();
            if (baseCfm == null) {
                throw new ConfigurationException(String.format("Cannot drop materialized view '%s' in keyspace '%s' without base CF.", this.columnFamily(), this.keyspace()));
            }
            CFMetaData updatedCfm = baseCfm.copy();
            updatedCfm.materializedViews(updatedCfm.getMaterializedViews().without(this.columnFamily()));
            MigrationManager.announceColumnFamilyUpdate(updatedCfm, false, isLocalOnly);
            MigrationManager.announceColumnFamilyDrop(this.keyspace(), this.columnFamily(), isLocalOnly);
            return true;
        }
        catch (ConfigurationException e) {
            if (this.ifExists) {
                return false;
            }
            throw e;
        }
    }

    private CFMetaData findBaseCf() throws InvalidRequestException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.keyspace());
        if (ksm == null) {
            throw new KeyspaceNotDefinedException("Keyspace " + this.keyspace() + " does not exist");
        }
        for (CFMetaData cfm : ksm.tables) {
            if (!cfm.getMaterializedViews().get(this.columnFamily()).isPresent()) continue;
            return cfm;
        }
        if (this.ifExists) {
            return null;
        }
        throw new InvalidRequestException("View '" + this.cfName + "' could not be found in any of the tables of keyspace '" + this.keyspace() + '\'');
    }
}

