/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.IndexType;
import org.apache.cassandra.config.ReadRepairDecision;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.Serializers;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategy;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.LZ4Compressor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.MaterializedViews;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unmetered
public final class CFMetaData {
    private static final Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final Serializer serializer = new Serializer();
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.0;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.1;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final Class<? extends AbstractCompactionStrategy> DEFAULT_COMPACTION_STRATEGY_CLASS = SizeTieredCompactionStrategy.class;
    public static final CachingOptions DEFAULT_CACHING_STRATEGY = CachingOptions.KEYS_ONLY;
    public static final int DEFAULT_DEFAULT_TIME_TO_LIVE = 0;
    public static final SpeculativeRetry DEFAULT_SPECULATIVE_RETRY = new SpeculativeRetry(SpeculativeRetry.RetryType.PERCENTILE, 0.99);
    public static final int DEFAULT_MIN_INDEX_INTERVAL = 128;
    public static final int DEFAULT_MAX_INDEX_INTERVAL = 2048;
    public static final String DEFAULT_COMPRESSOR = LZ4Compressor.class.getCanonicalName();
    private static final Comparator<ColumnDefinition> regularColumnComparator = new Comparator<ColumnDefinition>(){

        @Override
        public int compare(ColumnDefinition def1, ColumnDefinition def2) {
            return ByteBufferUtil.compareUnsigned(def1.name.bytes, def2.name.bytes);
        }
    };
    public final UUID cfId;
    public final String ksName;
    public final String cfName;
    private final ImmutableSet<Flag> flags;
    private final boolean isDense;
    private final boolean isCompound;
    private final boolean isSuper;
    private final boolean isCounter;
    private final boolean isMaterializedView;
    public volatile ClusteringComparator comparator;
    private final Serializers serializers;
    private volatile String comment = "";
    private volatile double readRepairChance = 0.0;
    private volatile double dcLocalReadRepairChance = 0.1;
    private volatile int gcGraceSeconds = 864000;
    private volatile AbstractType<?> keyValidator = BytesType.instance;
    private volatile int minCompactionThreshold = 4;
    private volatile int maxCompactionThreshold = 32;
    private volatile Double bloomFilterFpChance = null;
    private volatile CachingOptions caching = DEFAULT_CACHING_STRATEGY;
    private volatile int minIndexInterval = 128;
    private volatile int maxIndexInterval = 2048;
    private volatile int memtableFlushPeriod = 0;
    private volatile int defaultTimeToLive = 0;
    private volatile SpeculativeRetry speculativeRetry = DEFAULT_SPECULATIVE_RETRY;
    private volatile Map<ByteBuffer, DroppedColumn> droppedColumns = new HashMap<ByteBuffer, DroppedColumn>();
    private volatile Triggers triggers = Triggers.none();
    private volatile MaterializedViews materializedViews = MaterializedViews.none();
    private final Map<ByteBuffer, ColumnDefinition> columnMetadata = new ConcurrentHashMap<ByteBuffer, ColumnDefinition>();
    private volatile List<ColumnDefinition> partitionKeyColumns;
    private volatile List<ColumnDefinition> clusteringColumns;
    private volatile PartitionColumns partitionColumns;
    private volatile ColumnDefinition compactValueColumn;
    public volatile Class<? extends AbstractCompactionStrategy> compactionStrategyClass = DEFAULT_COMPACTION_STRATEGY_CLASS;
    public volatile Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public volatile CompressionParameters compressionParameters = CompressionParameters.noCompression();

    public CFMetaData comment(String prop) {
        this.comment = Strings.nullToEmpty((String)prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(CachingOptions prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData minIndexInterval(int prop) {
        this.minIndexInterval = prop;
        return this;
    }

    public CFMetaData maxIndexInterval(int prop) {
        this.maxIndexInterval = prop;
        return this;
    }

    public CFMetaData memtableFlushPeriod(int prop) {
        this.memtableFlushPeriod = prop;
        return this;
    }

    public CFMetaData defaultTimeToLive(int prop) {
        this.defaultTimeToLive = prop;
        return this;
    }

    public CFMetaData speculativeRetry(SpeculativeRetry prop) {
        this.speculativeRetry = prop;
        return this;
    }

    public CFMetaData droppedColumns(Map<ByteBuffer, DroppedColumn> cols) {
        this.droppedColumns = cols;
        return this;
    }

    public CFMetaData triggers(Triggers prop) {
        this.triggers = prop;
        return this;
    }

    public CFMetaData materializedViews(MaterializedViews prop) {
        this.materializedViews = prop;
        return this;
    }

    private CFMetaData(String keyspace, String name, UUID cfId, boolean isSuper, boolean isCounter, boolean isDense, boolean isCompound, boolean isMaterializedView, List<ColumnDefinition> partitionKeyColumns, List<ColumnDefinition> clusteringColumns, PartitionColumns partitionColumns) {
        this.cfId = cfId;
        this.ksName = keyspace;
        this.cfName = name;
        this.isDense = isDense;
        this.isCompound = isCompound;
        this.isSuper = isSuper;
        this.isCounter = isCounter;
        this.isMaterializedView = isMaterializedView;
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (isSuper) {
            flags.add(Flag.SUPER);
        }
        if (isCounter) {
            flags.add(Flag.COUNTER);
        }
        if (isDense) {
            flags.add(Flag.DENSE);
        }
        if (isCompound) {
            flags.add(Flag.COMPOUND);
        }
        if (isMaterializedView) {
            flags.add(Flag.MATERIALIZEDVIEW);
        }
        this.flags = Sets.immutableEnumSet(flags);
        assert (this.isCQLTable() || !clusteringColumns.isEmpty()) : String.format("For table %s.%s, isDense=%b, isCompound=%b, clustering=%s", this.ksName, this.cfName, isDense, isCompound, clusteringColumns);
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringColumns = clusteringColumns;
        this.partitionColumns = partitionColumns;
        this.serializers = new Serializers(this);
        this.rebuild();
    }

    private void rebuild() {
        this.comparator = new ClusteringComparator(CFMetaData.extractTypes(this.clusteringColumns));
        this.columnMetadata.clear();
        for (ColumnDefinition def : this.partitionKeyColumns) {
            this.columnMetadata.put(def.name.bytes, def);
        }
        for (ColumnDefinition def : this.clusteringColumns) {
            this.columnMetadata.put(def.name.bytes, def);
        }
        for (ColumnDefinition def : this.partitionColumns) {
            this.columnMetadata.put(def.name.bytes, def);
        }
        List<AbstractType<?>> keyTypes = CFMetaData.extractTypes(this.partitionKeyColumns);
        AbstractType abstractType = this.keyValidator = keyTypes.size() == 1 ? keyTypes.get(0) : CompositeType.getInstance(keyTypes);
        if (this.isCompactTable()) {
            this.compactValueColumn = CompactTables.getCompactValueColumn(this.partitionColumns, this.isSuper());
        }
    }

    public MaterializedViews getMaterializedViews() {
        return this.materializedViews;
    }

    public static CFMetaData create(String ksName, String name, UUID cfId, boolean isDense, boolean isCompound, boolean isSuper, boolean isCounter, boolean isMaterializedView, List<ColumnDefinition> columns) {
        ArrayList<ColumnDefinition> partitions = new ArrayList<ColumnDefinition>();
        ArrayList<ColumnDefinition> clusterings = new ArrayList<ColumnDefinition>();
        PartitionColumns.Builder builder = PartitionColumns.builder();
        block4: for (ColumnDefinition column : columns) {
            switch (column.kind) {
                case PARTITION_KEY: {
                    partitions.add(column);
                    continue block4;
                }
                case CLUSTERING: {
                    clusterings.add(column);
                    continue block4;
                }
            }
            builder.add(column);
        }
        Collections.sort(partitions);
        Collections.sort(clusterings);
        return new CFMetaData(ksName, name, cfId, isSuper, isCounter, isDense, isCompound, isMaterializedView, partitions, clusterings, builder.build());
    }

    private static List<AbstractType<?>> extractTypes(List<ColumnDefinition> clusteringColumns) {
        ArrayList types = new ArrayList(clusteringColumns.size());
        for (ColumnDefinition def : clusteringColumns) {
            types.add(def.type);
        }
        return types;
    }

    public Set<Flag> flags() {
        return this.flags;
    }

    public static CFMetaData createFake(String keyspace, String name) {
        return Builder.create(keyspace, name).addPartitionKey("key", (AbstractType)BytesType.instance).build();
    }

    public Triggers getTriggers() {
        return this.triggers;
    }

    public static CFMetaData compile(String cql, String keyspace) {
        CFStatement parsed = (CFStatement)QueryProcessor.parseStatement(cql);
        parsed.prepareKeyspace(keyspace);
        CreateTableStatement statement = (CreateTableStatement)parsed.prepare().statement;
        Builder builder = statement.metadataBuilder();
        builder.withId(CFMetaData.generateLegacyCfId(keyspace, statement.columnFamily()));
        CFMetaData cfm = builder.build();
        statement.applyPropertiesTo(cfm);
        return cfm.readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).memtableFlushPeriod(3600000);
    }

    public static UUID generateLegacyCfId(String ksName, String cfName) {
        return UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])ksName.getBytes(), (byte[])cfName.getBytes()));
    }

    public CFMetaData reloadIndexMetadataProperties(CFMetaData parent) {
        CachingOptions indexCaching = parent.getCaching().keyCache.isEnabled() ? CachingOptions.KEYS_ONLY : CachingOptions.NONE;
        return this.readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).caching(indexCaching).speculativeRetry(parent.speculativeRetry).minCompactionThreshold(parent.minCompactionThreshold).maxCompactionThreshold(parent.maxCompactionThreshold).compactionStrategyClass(parent.compactionStrategyClass).compactionStrategyOptions(parent.compactionStrategyOptions).compressionParameters(parent.compressionParameters);
    }

    public CFMetaData copy() {
        return this.copy(this.cfId);
    }

    public CFMetaData copy(UUID newCfId) {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, newCfId, this.isSuper(), this.isCounter(), this.isDense(), this.isCompound(), this.isMaterializedView(), CFMetaData.copy(this.partitionKeyColumns), CFMetaData.copy(this.clusteringColumns), CFMetaData.copy(this.partitionColumns)), this);
    }

    private static List<ColumnDefinition> copy(List<ColumnDefinition> l) {
        ArrayList<ColumnDefinition> copied = new ArrayList<ColumnDefinition>(l.size());
        for (ColumnDefinition cd : l) {
            copied.add(cd.copy());
        }
        return copied;
    }

    private static PartitionColumns copy(PartitionColumns columns) {
        PartitionColumns.Builder newColumns = PartitionColumns.builder();
        for (ColumnDefinition cd : columns) {
            newColumns.add(cd.copy());
        }
        return newColumns.build();
    }

    @VisibleForTesting
    public static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        return newCFMD.comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dcLocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).gcGraceSeconds(oldCFMD.gcGraceSeconds).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(new HashMap<String, String>(oldCFMD.compactionStrategyOptions)).compressionParameters(oldCFMD.compressionParameters.copy()).bloomFilterFpChance(oldCFMD.getBloomFilterFpChance()).caching(oldCFMD.caching).defaultTimeToLive(oldCFMD.defaultTimeToLive).minIndexInterval(oldCFMD.minIndexInterval).maxIndexInterval(oldCFMD.maxIndexInterval).speculativeRetry(oldCFMD.speculativeRetry).memtableFlushPeriod(oldCFMD.memtableFlushPeriod).droppedColumns(new HashMap<ByteBuffer, DroppedColumn>(oldCFMD.droppedColumns)).triggers(oldCFMD.triggers).materializedViews(oldCFMD.materializedViews);
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name.bytes) : info.getIndexName());
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isSecondaryIndex() {
        return this.cfName.contains(".");
    }

    public Map<ByteBuffer, ColumnDefinition> getColumnMetadata() {
        return this.columnMetadata;
    }

    public String getParentColumnFamilyName() {
        return this.isSecondaryIndex() ? this.cfName.substring(0, this.cfName.indexOf(46)) : null;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepairChance() {
        return this.dcLocalReadRepairChance;
    }

    public ReadRepairDecision newReadRepairDecision() {
        double chance = ThreadLocalRandom.current().nextDouble();
        if (this.getReadRepairChance() > chance) {
            return ReadRepairDecision.GLOBAL;
        }
        if (this.getDcLocalReadRepairChance() > chance) {
            return ReadRepairDecision.DC_LOCAL;
        }
        return ReadRepairDecision.NONE;
    }

    public AbstractType<?> getColumnDefinitionNameComparator(ColumnDefinition.Kind kind) {
        return this.isSuper() && kind == ColumnDefinition.Kind.REGULAR || this.isStaticCompactTable() && kind == ColumnDefinition.Kind.STATIC ? this.thriftColumnNameType() : UTF8Type.instance;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public int getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public int getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Collection<ColumnDefinition> allColumns() {
        return this.columnMetadata.values();
    }

    public Iterator<ColumnDefinition> allColumnsInSelectOrder() {
        final boolean isStaticCompactTable = this.isStaticCompactTable();
        final boolean noNonPkColumns = this.isCompactTable() && CompactTables.hasEmptyCompactValue(this);
        return new AbstractIterator<ColumnDefinition>(){
            private final Iterator<ColumnDefinition> partitionKeyIter;
            private final Iterator<ColumnDefinition> clusteringIter;
            private final Iterator<ColumnDefinition> otherColumns;
            {
                this.partitionKeyIter = CFMetaData.this.partitionKeyColumns.iterator();
                Iterator<Object> iterator = this.clusteringIter = isStaticCompactTable ? Collections.emptyIterator() : CFMetaData.this.clusteringColumns.iterator();
                this.otherColumns = noNonPkColumns ? Collections.emptyIterator() : (isStaticCompactTable ? ((CFMetaData)CFMetaData.this).partitionColumns.statics.selectOrderIterator() : CFMetaData.this.partitionColumns.selectOrderIterator());
            }

            protected ColumnDefinition computeNext() {
                if (this.partitionKeyIter.hasNext()) {
                    return this.partitionKeyIter.next();
                }
                if (this.clusteringIter.hasNext()) {
                    return this.clusteringIter.next();
                }
                return this.otherColumns.hasNext() ? this.otherColumns.next() : (ColumnDefinition)this.endOfData();
            }
        };
    }

    public List<ColumnDefinition> partitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public List<ColumnDefinition> clusteringColumns() {
        return this.clusteringColumns;
    }

    public PartitionColumns partitionColumns() {
        return this.partitionColumns;
    }

    public ColumnDefinition compactValueColumn() {
        return this.compactValueColumn;
    }

    public ClusteringComparator getKeyValidatorAsClusteringComparator() {
        boolean isCompound = this.keyValidator instanceof CompositeType;
        List<AbstractType<?>> types = isCompound ? ((CompositeType)this.keyValidator).types : Collections.singletonList(this.keyValidator);
        return new ClusteringComparator(types);
    }

    public static ByteBuffer serializePartitionKey(ClusteringPrefix keyAsClustering) {
        if (keyAsClustering.size() == 1) {
            return keyAsClustering.get(0);
        }
        ByteBuffer[] values = new ByteBuffer[keyAsClustering.size()];
        for (int i = 0; i < keyAsClustering.size(); ++i) {
            values[i] = keyAsClustering.get(i);
        }
        return CompositeType.build(values);
    }

    public double getBloomFilterFpChance() {
        return this.bloomFilterFpChance == null || this.bloomFilterFpChance == 0.0 ? (this.compactionStrategyClass == LeveledCompactionStrategy.class ? 0.1 : 0.01) : this.bloomFilterFpChance;
    }

    public CachingOptions getCaching() {
        return this.caching;
    }

    public int getMinIndexInterval() {
        return this.minIndexInterval;
    }

    public int getMaxIndexInterval() {
        return this.maxIndexInterval;
    }

    public SpeculativeRetry getSpeculativeRetry() {
        return this.speculativeRetry;
    }

    public int getMemtableFlushPeriod() {
        return this.memtableFlushPeriod;
    }

    public int getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public Map<ByteBuffer, DroppedColumn> getDroppedColumns() {
        return this.droppedColumns;
    }

    public ColumnDefinition getDroppedColumnDefinition(ByteBuffer name) {
        DroppedColumn dropped = this.droppedColumns.get(name);
        if (dropped == null) {
            return null;
        }
        AbstractType type = dropped.type == null ? BytesType.instance : dropped.type;
        return ColumnDefinition.regularDef(this, name, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CFMetaData)) {
            return false;
        }
        CFMetaData other = (CFMetaData)o;
        return Objects.equal((Object)this.cfId, (Object)other.cfId) && Objects.equal(this.flags, other.flags) && Objects.equal((Object)this.ksName, (Object)other.ksName) && Objects.equal((Object)this.cfName, (Object)other.cfName) && Objects.equal((Object)this.comparator, (Object)other.comparator) && Objects.equal((Object)this.comment, (Object)other.comment) && Objects.equal((Object)this.readRepairChance, (Object)other.readRepairChance) && Objects.equal((Object)this.dcLocalReadRepairChance, (Object)other.dcLocalReadRepairChance) && Objects.equal((Object)this.gcGraceSeconds, (Object)other.gcGraceSeconds) && Objects.equal(this.keyValidator, other.keyValidator) && Objects.equal((Object)this.minCompactionThreshold, (Object)other.minCompactionThreshold) && Objects.equal((Object)this.maxCompactionThreshold, (Object)other.maxCompactionThreshold) && Objects.equal(this.columnMetadata, other.columnMetadata) && Objects.equal(this.compactionStrategyClass, other.compactionStrategyClass) && Objects.equal(this.compactionStrategyOptions, other.compactionStrategyOptions) && Objects.equal((Object)this.compressionParameters, (Object)other.compressionParameters) && Objects.equal((Object)this.getBloomFilterFpChance(), (Object)other.getBloomFilterFpChance()) && Objects.equal((Object)this.memtableFlushPeriod, (Object)other.memtableFlushPeriod) && Objects.equal((Object)this.caching, (Object)other.caching) && Objects.equal((Object)this.defaultTimeToLive, (Object)other.defaultTimeToLive) && Objects.equal((Object)this.minIndexInterval, (Object)other.minIndexInterval) && Objects.equal((Object)this.maxIndexInterval, (Object)other.maxIndexInterval) && Objects.equal((Object)this.speculativeRetry, (Object)other.speculativeRetry) && Objects.equal(this.droppedColumns, other.droppedColumns) && Objects.equal((Object)this.triggers, (Object)other.triggers) && Objects.equal((Object)this.materializedViews, (Object)other.materializedViews);
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.cfId).append((Object)this.ksName).append((Object)this.cfName).append(this.flags).append((Object)this.comparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.gcGraceSeconds).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append(this.columnMetadata).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append(this.getBloomFilterFpChance()).append(this.memtableFlushPeriod).append((Object)this.caching).append(this.defaultTimeToLive).append(this.minIndexInterval).append(this.maxIndexInterval).append((Object)this.speculativeRetry).append(this.droppedColumns).append((Object)this.triggers).append((Object)this.materializedViews).toHashCode();
    }

    public boolean reload() {
        return this.apply(SchemaKeyspace.createTableFromName(this.ksName, this.cfName));
    }

    @VisibleForTesting
    public boolean apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        this.validateCompatility(cfm);
        this.partitionKeyColumns = cfm.partitionKeyColumns;
        this.clusteringColumns = cfm.clusteringColumns;
        boolean hasColumnChange = !this.partitionColumns.equals(cfm.partitionColumns);
        this.partitionColumns = cfm.partitionColumns;
        this.rebuild();
        this.comment = Strings.nullToEmpty((String)cfm.comment);
        this.readRepairChance = cfm.readRepairChance;
        this.dcLocalReadRepairChance = cfm.dcLocalReadRepairChance;
        this.gcGraceSeconds = cfm.gcGraceSeconds;
        this.keyValidator = cfm.keyValidator;
        this.minCompactionThreshold = cfm.minCompactionThreshold;
        this.maxCompactionThreshold = cfm.maxCompactionThreshold;
        this.bloomFilterFpChance = cfm.getBloomFilterFpChance();
        this.caching = cfm.caching;
        this.minIndexInterval = cfm.minIndexInterval;
        this.maxIndexInterval = cfm.maxIndexInterval;
        this.memtableFlushPeriod = cfm.memtableFlushPeriod;
        this.defaultTimeToLive = cfm.defaultTimeToLive;
        this.speculativeRetry = cfm.speculativeRetry;
        if (!cfm.droppedColumns.isEmpty()) {
            this.droppedColumns = cfm.droppedColumns;
        }
        this.compactionStrategyClass = cfm.compactionStrategyClass;
        this.compactionStrategyOptions = cfm.compactionStrategyOptions;
        this.compressionParameters = cfm.compressionParameters;
        this.triggers = cfm.triggers;
        this.materializedViews = cfm.materializedViews;
        logger.debug("application result is {}", (Object)this);
        return hasColumnChange;
    }

    public void validateCompatility(CFMetaData cfm) throws ConfigurationException {
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (!cfm.flags.equals(this.flags)) {
            throw new ConfigurationException("types do not match.");
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException(String.format("Column family comparators do not match or are not compatible (found %s; expected %s).", cfm.comparator.getClass().getSimpleName(), this.comparator.getClass().getSimpleName()));
        }
    }

    public static void validateCompactionOptions(Class<? extends AbstractCompactionStrategy> strategyClass, Map<String, String> options) throws ConfigurationException {
        try {
            if (options == null) {
                return;
            }
            Map unknownOptions = (Map)strategyClass.getMethod("validateOptions", Map.class).invoke(null, options);
            if (!unknownOptions.isEmpty()) {
                throw new ConfigurationException(String.format("Properties specified %s are not understood by %s", unknownOptions.keySet(), strategyClass.getSimpleName()));
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("Compaction Strategy {} does not have a static validateOptions method. Validation ignored", (Object)strategyClass.getName());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getTargetException();
            }
            throw new ConfigurationException("Failed to validate compaction options: " + options);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to validate compaction options: " + options);
        }
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        Class strategyClass = FBUtilities.classForName(className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className, "compaction strategy");
        if (!AbstractCompactionStrategy.class.isAssignableFrom(strategyClass)) {
            throw new ConfigurationException(String.format("Specified compaction strategy class (%s) is not derived from AbstractReplicationStrategy", className));
        }
        return strategyClass;
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnDefinition getColumnDefinition(ColumnIdentifier name) {
        return this.columnMetadata.get(name.bytes);
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.columnMetadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.allColumns()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public void addDefaultIndexNames() throws ConfigurationException {
        UUID cfId = Schema.instance.getId(this.ksName, this.cfName);
        if (cfId != null) {
            CFMetaData cfm = Schema.instance.getCFMetaData(cfId);
            for (ColumnDefinition newDef : this.allColumns()) {
                String oldIndexName;
                if (!cfm.columnMetadata.containsKey(newDef.name.bytes) || newDef.getIndexType() == null || (oldIndexName = cfm.getColumnDefinition(newDef.name).getIndexName()) == null) continue;
                if (newDef.getIndexName() != null && !oldIndexName.equals(newDef.getIndexName())) {
                    throw new ConfigurationException("Can't modify index name: was '" + oldIndexName + "' changed to '" + newDef.getIndexName() + "'.");
                }
                newDef.setIndexName(oldIndexName);
            }
        }
        Set<String> existingNames = CFMetaData.existingIndexNames(null);
        for (ColumnDefinition column : this.allColumns()) {
            String baseName;
            if (column.getIndexType() == null || column.getIndexName() != null) continue;
            String indexName = baseName = CFMetaData.getDefaultIndexName(this.cfName, column.name);
            int i = 0;
            while (existingNames.contains(indexName)) {
                indexName = baseName + '_' + ++i;
            }
            column.setIndexName(indexName);
        }
    }

    public static String getDefaultIndexName(String cfName, ColumnIdentifier columnName) {
        return (cfName + "_" + columnName + "_idx").replaceAll("\\W", "");
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && name.matches("\\w+");
    }

    public static boolean isIndexNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public CFMetaData validate() throws ConfigurationException {
        this.rebuild();
        if (!CFMetaData.isNameValid(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.ksName));
        }
        if (!CFMetaData.isNameValid(this.cfName)) {
            throw new ConfigurationException(String.format("ColumnFamily name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.cfName));
        }
        for (int i = 0; i < this.comparator.size(); ++i) {
            if (!(this.comparator.subtype(i) instanceof CounterColumnType)) continue;
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.isCounter()) {
            for (ColumnDefinition def : this.partitionColumns()) {
                if (def.type instanceof CounterColumnType || CompactTables.isSuperColumnMapColumn(def)) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + def.name + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.allColumns()) {
                if (!(def.type instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + def.name + ") in a non counter column family");
            }
        }
        Set<String> indexNames = CFMetaData.existingIndexNames(this.cfName);
        for (ColumnDefinition c : this.allColumns()) {
            if (c.getIndexType() == null) {
                if (c.getIndexName() == null) continue;
                throw new ConfigurationException("Index name cannot be set without index type");
            }
            if (this.isSuper()) {
                throw new ConfigurationException("Secondary indexes are not supported on super column families");
            }
            if (!CFMetaData.isIndexNameValid(c.getIndexName())) {
                throw new ConfigurationException("Illegal index name " + c.getIndexName());
            }
            if (indexNames.contains(c.getIndexName())) {
                throw new ConfigurationException("Duplicate index name " + c.getIndexName());
            }
            indexNames.add(c.getIndexName());
            if (!(c.getIndexType() != IndexType.CUSTOM || c.getIndexOptions() != null && c.hasIndexOption("class_name"))) {
                throw new ConfigurationException("Required index option missing: class_name");
            }
            SecondaryIndex.createInstance(null, c);
        }
        this.validateCompactionThresholds();
        if (this.bloomFilterFpChance != null && this.bloomFilterFpChance == 0.0) {
            throw new ConfigurationException("Zero false positives is impossible; bloom filter false positive chance bffpc must be 0 < bffpc <= 1");
        }
        this.validateIndexIntervalThresholds();
        return this;
    }

    private static Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (cfToExclude != null && cfs.name.equals(cfToExclude)) continue;
            for (ColumnDefinition cd : cfs.metadata.allColumns()) {
                indexNames.add(cd.getIndexName());
            }
        }
        return indexNames;
    }

    private void validateCompactionThresholds() throws ConfigurationException {
        if (this.maxCompactionThreshold == 0) {
            logger.warn("Disabling compaction by setting max or min compaction has been deprecated, set the compaction strategy option 'enabled' to 'false' instead");
            return;
        }
        if (this.minCompactionThreshold <= 1) {
            throw new ConfigurationException(String.format("Min compaction threshold cannot be less than 2 (got %d).", this.minCompactionThreshold));
        }
        if (this.minCompactionThreshold > this.maxCompactionThreshold) {
            throw new ConfigurationException(String.format("Min compaction threshold (got %d) cannot be greater than max compaction threshold (got %d)", this.minCompactionThreshold, this.maxCompactionThreshold));
        }
    }

    private void validateIndexIntervalThresholds() throws ConfigurationException {
        if (this.minIndexInterval <= 0) {
            throw new ConfigurationException(String.format("Min index interval must be greater than 0 (got %d).", this.minIndexInterval));
        }
        if (this.maxIndexInterval < this.minIndexInterval) {
            throw new ConfigurationException(String.format("Max index interval (%d) must be greater than the min index interval (%d).", this.maxIndexInterval, this.minIndexInterval));
        }
    }

    public AbstractType<?> thriftColumnNameType() {
        if (this.isSuper()) {
            ColumnDefinition def = this.compactValueColumn();
            assert (def != null && def.type instanceof MapType);
            return ((MapType)def.type).nameComparator();
        }
        assert (this.isStaticCompactTable());
        return this.clusteringColumns.get((int)0).type;
    }

    public CFMetaData addAllColumnDefinitions(Collection<ColumnDefinition> defs) {
        for (ColumnDefinition def : defs) {
            this.addOrReplaceColumnDefinition(def);
        }
        return this;
    }

    public CFMetaData addColumnDefinition(ColumnDefinition def) throws ConfigurationException {
        if (this.columnMetadata.containsKey(def.name.bytes)) {
            throw new ConfigurationException(String.format("Cannot add column %s, a column with the same name already exists", def.name));
        }
        return this.addOrReplaceColumnDefinition(def);
    }

    public CFMetaData addOrReplaceColumnDefinition(ColumnDefinition def) {
        switch (def.kind) {
            case PARTITION_KEY: {
                this.partitionKeyColumns.set(def.position(), def);
                List<AbstractType<?>> keyTypes = CFMetaData.extractTypes(this.partitionKeyColumns);
                this.keyValidator = keyTypes.size() == 1 ? keyTypes.get(0) : CompositeType.getInstance(keyTypes);
                break;
            }
            case CLUSTERING: {
                this.clusteringColumns.set(def.position(), def);
                this.comparator = new ClusteringComparator(CFMetaData.extractTypes(this.clusteringColumns));
                break;
            }
            case REGULAR: 
            case STATIC: {
                PartitionColumns.Builder builder = PartitionColumns.builder();
                for (ColumnDefinition column : this.partitionColumns) {
                    if (column.name.equals(def.name)) continue;
                    builder.add(column);
                }
                builder.add(def);
                this.partitionColumns = builder.build();
                if (!this.isDense()) break;
                this.compactValueColumn = def;
            }
        }
        this.columnMetadata.put(def.name.bytes, def);
        return this;
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        boolean removed;
        assert (!def.isPartitionKey());
        boolean bl = removed = this.columnMetadata.remove(def.name.bytes) != null;
        if (removed) {
            this.partitionColumns = this.partitionColumns.without(def);
        }
        return removed;
    }

    public void recordColumnDrop(ColumnDefinition def) {
        this.droppedColumns.put(def.name.bytes, new DroppedColumn(def.name.toString(), def.type, FBUtilities.timestampMicros()));
    }

    public void renameColumn(ColumnIdentifier from, ColumnIdentifier to) throws InvalidRequestException {
        ColumnDefinition def = this.getColumnDefinition(from);
        if (def == null) {
            throw new InvalidRequestException(String.format("Cannot rename unknown column %s in keyspace %s", from, this.cfName));
        }
        if (this.getColumnDefinition(to) != null) {
            throw new InvalidRequestException(String.format("Cannot rename column %s to %s in keyspace %s; another column of that name already exist", from, to, this.cfName));
        }
        if (def.isPartOfCellName(this.isCQLTable(), this.isSuper())) {
            throw new InvalidRequestException(String.format("Cannot rename non PRIMARY KEY part %s", from));
        }
        if (def.isIndexed()) {
            throw new InvalidRequestException(String.format("Cannot rename column %s because it is secondary indexed", from));
        }
        ColumnDefinition newDef = def.withNewName(to);
        this.addOrReplaceColumnDefinition(newDef);
        if (def.isPartitionKey()) {
            this.columnMetadata.remove(def.name.bytes);
        } else {
            this.removeColumnDefinition(def);
        }
    }

    public boolean isCQLTable() {
        return !this.isSuper() && !this.isDense() && this.isCompound();
    }

    public boolean isCompactTable() {
        return !this.isCQLTable();
    }

    public boolean isStaticCompactTable() {
        return !this.isSuper() && !this.isDense() && !this.isCompound();
    }

    public boolean isThriftCompatible() {
        return this.isCompactTable();
    }

    public boolean hasStaticColumns() {
        return !this.partitionColumns.statics.isEmpty();
    }

    public boolean hasCollectionColumns() {
        for (ColumnDefinition def : this.partitionColumns()) {
            if (!(def.type instanceof CollectionType) || !def.type.isMultiCell()) continue;
            return true;
        }
        return false;
    }

    public boolean hasComplexColumns() {
        for (ColumnDefinition def : this.partitionColumns()) {
            if (!def.isComplex()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDroppedCollectionColumns() {
        for (DroppedColumn def : this.getDroppedColumns().values()) {
            if (!(def.type instanceof CollectionType) || !def.type.isMultiCell()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean isCounter() {
        return this.isCounter;
    }

    public boolean isDense() {
        return this.isDense;
    }

    public boolean isCompound() {
        return this.isCompound;
    }

    public boolean isMaterializedView() {
        return this.isMaterializedView;
    }

    public Serializers serializers() {
        return this.serializers;
    }

    public AbstractType<?> makeLegacyDefaultValidator() {
        return this.isCounter() ? CounterColumnType.instance : (this.isCompactTable() ? this.compactValueColumn().type : BytesType.instance);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("flags", this.flags).append("comparator", (Object)this.comparator).append("partitionColumns", (Object)this.partitionColumns).append("partitionKeyColumns", this.partitionKeyColumns).append("clusteringColumns", this.clusteringColumns).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dcLocalReadRepairChance", this.dcLocalReadRepairChance).append("gcGraceSeconds", this.gcGraceSeconds).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("columnMetadata", this.columnMetadata.values()).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionParameters", this.compressionParameters.asMap()).append("bloomFilterFpChance", this.getBloomFilterFpChance()).append("memtableFlushPeriod", this.memtableFlushPeriod).append("caching", (Object)this.caching).append("defaultTimeToLive", this.defaultTimeToLive).append("minIndexInterval", this.minIndexInterval).append("maxIndexInterval", this.maxIndexInterval).append("speculativeRetry", (Object)this.speculativeRetry).append("droppedColumns", this.droppedColumns).append("triggers", (Object)this.triggers).append("materializedViews", (Object)this.materializedViews).toString();
    }

    public static class DroppedColumn {
        public final String name;
        public final AbstractType<?> type;
        public final long droppedTime;

        public DroppedColumn(String name, AbstractType<?> type, long droppedTime) {
            this.name = name;
            this.type = type;
            this.droppedTime = droppedTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DroppedColumn)) {
                return false;
            }
            DroppedColumn dc = (DroppedColumn)o;
            return this.name.equals(dc.name) && this.type.equals(dc.type) && this.droppedTime == dc.droppedTime;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.droppedTime});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", this.type).add("droppedTime", this.droppedTime).toString();
        }
    }

    public static class Serializer {
        public void serialize(CFMetaData metadata, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(metadata.cfId, out, version);
        }

        public CFMetaData deserialize(DataInputPlus in, int version) throws IOException {
            UUID cfId = UUIDSerializer.serializer.deserialize(in, version);
            CFMetaData metadata = Schema.instance.getCFMetaData(cfId);
            if (metadata == null) {
                String message = String.format("Couldn't find table for cfId %s. If a table was just created, this is likely due to the schema not being fully propagated.  Please wait for schema agreement on table creation.", cfId);
                throw new UnknownColumnFamilyException(message, cfId);
            }
            return metadata;
        }

        public long serializedSize(CFMetaData metadata, int version) {
            return UUIDSerializer.serializer.serializedSize(metadata.cfId, version);
        }
    }

    public static class Builder {
        private final String keyspace;
        private final String table;
        private final boolean isDense;
        private final boolean isCompound;
        private final boolean isSuper;
        private final boolean isCounter;
        private final boolean isMaterializedView;
        private UUID tableId;
        private final List<Pair<ColumnIdentifier, AbstractType>> partitionKeys = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();
        private final List<Pair<ColumnIdentifier, AbstractType>> clusteringColumns = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();
        private final List<Pair<ColumnIdentifier, AbstractType>> staticColumns = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();
        private final List<Pair<ColumnIdentifier, AbstractType>> regularColumns = new ArrayList<Pair<ColumnIdentifier, AbstractType>>();

        private Builder(String keyspace, String table, boolean isDense, boolean isCompound, boolean isSuper, boolean isCounter, boolean isMaterializedView) {
            this.keyspace = keyspace;
            this.table = table;
            this.isDense = isDense;
            this.isCompound = isCompound;
            this.isSuper = isSuper;
            this.isCounter = isCounter;
            this.isMaterializedView = isMaterializedView;
        }

        public static Builder create(String keyspace, String table) {
            return Builder.create(keyspace, table, false, true, false);
        }

        public static Builder create(String keyspace, String table, boolean isDense, boolean isCompound, boolean isCounter) {
            return Builder.create(keyspace, table, isDense, isCompound, false, isCounter);
        }

        public static Builder create(String keyspace, String table, boolean isDense, boolean isCompound, boolean isSuper, boolean isCounter) {
            return new Builder(keyspace, table, isDense, isCompound, isSuper, isCounter, false);
        }

        public static Builder createView(String keyspace, String table) {
            return new Builder(keyspace, table, false, true, false, false, true);
        }

        public static Builder createDense(String keyspace, String table, boolean isCompound, boolean isCounter) {
            return Builder.create(keyspace, table, true, isCompound, isCounter);
        }

        public static Builder createSuper(String keyspace, String table, boolean isCounter) {
            return Builder.create(keyspace, table, false, false, true, isCounter);
        }

        public Builder withId(UUID tableId) {
            this.tableId = tableId;
            return this;
        }

        public Builder addPartitionKey(String name, AbstractType type) {
            return this.addPartitionKey(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addPartitionKey(ColumnIdentifier name, AbstractType type) {
            this.partitionKeys.add(Pair.create(name, type));
            return this;
        }

        public Builder addClusteringColumn(String name, AbstractType type) {
            return this.addClusteringColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addClusteringColumn(ColumnIdentifier name, AbstractType type) {
            this.clusteringColumns.add(Pair.create(name, type));
            return this;
        }

        public Builder addRegularColumn(String name, AbstractType type) {
            return this.addRegularColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addRegularColumn(ColumnIdentifier name, AbstractType type) {
            this.regularColumns.add(Pair.create(name, type));
            return this;
        }

        public boolean hasRegulars() {
            return !this.regularColumns.isEmpty();
        }

        public Builder addStaticColumn(String name, AbstractType type) {
            return this.addStaticColumn(ColumnIdentifier.getInterned(name, false), type);
        }

        public Builder addStaticColumn(ColumnIdentifier name, AbstractType type) {
            this.staticColumns.add(Pair.create(name, type));
            return this;
        }

        public Set<String> usedColumnNames() {
            HashSet<String> usedNames = new HashSet<String>();
            for (Pair<ColumnIdentifier, AbstractType> p : this.partitionKeys) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            for (Pair<ColumnIdentifier, AbstractType> p : this.clusteringColumns) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            for (Pair<ColumnIdentifier, AbstractType> p : this.staticColumns) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            for (Pair<ColumnIdentifier, AbstractType> p : this.regularColumns) {
                usedNames.add(((ColumnIdentifier)p.left).toString());
            }
            return usedNames;
        }

        public CFMetaData build() {
            Pair<ColumnIdentifier, AbstractType> p;
            int i;
            if (this.tableId == null) {
                this.tableId = UUIDGen.getTimeUUID();
            }
            ArrayList<ColumnDefinition> partitions = new ArrayList<ColumnDefinition>(this.partitionKeys.size());
            ArrayList<ColumnDefinition> clusterings = new ArrayList<ColumnDefinition>(this.clusteringColumns.size());
            PartitionColumns.Builder builder = PartitionColumns.builder();
            for (i = 0; i < this.partitionKeys.size(); ++i) {
                p = this.partitionKeys.get(i);
                Integer componentIndex = this.partitionKeys.size() == 1 ? null : Integer.valueOf(i);
                partitions.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p.left, (AbstractType)p.right, componentIndex, ColumnDefinition.Kind.PARTITION_KEY));
            }
            for (i = 0; i < this.clusteringColumns.size(); ++i) {
                p = this.clusteringColumns.get(i);
                clusterings.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p.left, (AbstractType)p.right, i, ColumnDefinition.Kind.CLUSTERING));
            }
            for (i = 0; i < this.regularColumns.size(); ++i) {
                p = this.regularColumns.get(i);
                builder.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p.left, (AbstractType)p.right, null, ColumnDefinition.Kind.REGULAR));
            }
            for (i = 0; i < this.staticColumns.size(); ++i) {
                p = this.staticColumns.get(i);
                builder.add(new ColumnDefinition(this.keyspace, this.table, (ColumnIdentifier)p.left, (AbstractType)p.right, null, ColumnDefinition.Kind.STATIC));
            }
            return new CFMetaData(this.keyspace, this.table, this.tableId, this.isSuper, this.isCounter, this.isDense, this.isCompound, this.isMaterializedView, partitions, clusterings, builder.build());
        }
    }

    public static class SpeculativeRetry {
        public final RetryType type;
        public final double value;

        private SpeculativeRetry(RetryType type, double value) {
            this.type = type;
            this.value = value;
        }

        public static SpeculativeRetry fromString(String retry) throws ConfigurationException {
            String name = retry.toUpperCase();
            try {
                if (name.endsWith(RetryType.PERCENTILE.toString())) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 10));
                    if (value > 100.0 || value < 0.0) {
                        throw new ConfigurationException("PERCENTILE should be between 0 and 100, but was " + value);
                    }
                    return new SpeculativeRetry(RetryType.PERCENTILE, value / 100.0);
                }
                if (name.endsWith("MS")) {
                    double value = Double.parseDouble(name.substring(0, name.length() - 2));
                    return new SpeculativeRetry(RetryType.CUSTOM, value);
                }
                return new SpeculativeRetry(RetryType.valueOf(name), 0.0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("invalid speculative_retry type: " + retry);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpeculativeRetry)) {
                return false;
            }
            SpeculativeRetry rhs = (SpeculativeRetry)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)rhs.type)) && Objects.equal((Object)this.value, (Object)rhs.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.value});
        }

        public String toString() {
            switch (this.type) {
                case PERCENTILE: {
                    return this.value * 100.0 + "PERCENTILE";
                }
                case CUSTOM: {
                    return this.value + "ms";
                }
            }
            return this.type.toString();
        }

        public static enum RetryType {
            NONE,
            CUSTOM,
            PERCENTILE,
            ALWAYS;

        }
    }

    public static enum Flag {
        SUPER,
        COUNTER,
        DENSE,
        COMPOUND,
        MATERIALIZEDVIEW;

    }
}

