/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;

public class CachingOptions {
    public static final CachingOptions KEYS_ONLY = new CachingOptions(new KeyCache(KeyCache.Type.ALL), new RowCache(RowCache.Type.NONE));
    public static final CachingOptions ALL = new CachingOptions(new KeyCache(KeyCache.Type.ALL), new RowCache(RowCache.Type.ALL));
    public static final CachingOptions ROWS_ONLY = new CachingOptions(new KeyCache(KeyCache.Type.NONE), new RowCache(RowCache.Type.ALL));
    public static final CachingOptions NONE = new CachingOptions(new KeyCache(KeyCache.Type.NONE), new RowCache(RowCache.Type.NONE));
    public final KeyCache keyCache;
    public final RowCache rowCache;
    private static final Set<String> legacyOptions = new HashSet<String>(Arrays.asList("ALL", "NONE", "KEYS_ONLY", "ROWS_ONLY"));

    public CachingOptions(KeyCache kc, RowCache rc) {
        this.keyCache = kc;
        this.rowCache = rc;
    }

    public static CachingOptions fromString(String cache) throws ConfigurationException {
        if (legacyOptions.contains(cache.toUpperCase())) {
            return CachingOptions.fromLegacyOption(cache.toUpperCase());
        }
        return CachingOptions.fromMap(FBUtilities.fromJsonMap(cache));
    }

    public static CachingOptions fromMap(Map<String, String> cacheConfig) throws ConfigurationException {
        CachingOptions.validateCacheConfig(cacheConfig);
        if (!cacheConfig.containsKey("keys") && !cacheConfig.containsKey("rows_per_partition")) {
            return NONE;
        }
        if (!cacheConfig.containsKey("keys")) {
            return new CachingOptions(new KeyCache(KeyCache.Type.NONE), RowCache.fromString(cacheConfig.get("rows_per_partition")));
        }
        if (!cacheConfig.containsKey("rows_per_partition")) {
            return KEYS_ONLY;
        }
        return new CachingOptions(KeyCache.fromString(cacheConfig.get("keys")), RowCache.fromString(cacheConfig.get("rows_per_partition")));
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("keys", this.keyCache.toString());
        map.put("rows_per_partition", this.rowCache.toString());
        return map;
    }

    private static void validateCacheConfig(Map<String, String> cacheConfig) throws ConfigurationException {
        for (Map.Entry<String, String> entry : cacheConfig.entrySet()) {
            String value = entry.getValue().toUpperCase();
            if (entry.getKey().equals("keys")) {
                if (value.equals("ALL") || value.equals("NONE")) continue;
                throw new ConfigurationException("'keys' can only have values 'ALL' or 'NONE', but was '" + value + "'");
            }
            if (entry.getKey().equals("rows_per_partition")) {
                if (value.equals("ALL") || value.equals("NONE") || StringUtils.isNumeric((CharSequence)value)) continue;
                throw new ConfigurationException("'rows_per_partition' can only have values 'ALL', 'NONE' or be numeric, but was '" + value + "'.");
            }
            throw new ConfigurationException("Only supported CachingOptions parameters are 'keys' and 'rows_per_partition', but was '" + entry.getKey() + "'");
        }
    }

    public String toString() {
        return String.format("{\"keys\":\"%s\", \"rows_per_partition\":\"%s\"}", this.keyCache.toString(), this.rowCache.toString());
    }

    private static CachingOptions fromLegacyOption(String cache) {
        if (cache.equals("ALL")) {
            return ALL;
        }
        if (cache.equals("KEYS_ONLY")) {
            return KEYS_ONLY;
        }
        if (cache.equals("ROWS_ONLY")) {
            return ROWS_ONLY;
        }
        return NONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingOptions o2 = (CachingOptions)o;
        if (!this.keyCache.equals(o2.keyCache)) {
            return false;
        }
        return this.rowCache.equals(o2.rowCache);
    }

    public int hashCode() {
        int result = this.keyCache.hashCode();
        result = 31 * result + this.rowCache.hashCode();
        return result;
    }

    public static CachingOptions fromThrift(String caching, String cellsPerRow) throws ConfigurationException {
        RowCache rc = new RowCache(RowCache.Type.NONE);
        KeyCache kc = new KeyCache(KeyCache.Type.ALL);
        if (caching != null) {
            CachingOptions givenOptions = CachingOptions.fromString(caching);
            rc = givenOptions.rowCache;
            kc = givenOptions.keyCache;
        }
        if (cellsPerRow != null && rc.isEnabled()) {
            rc = RowCache.fromString(cellsPerRow);
        }
        return new CachingOptions(kc, rc);
    }

    public String toThriftCaching() {
        if (this.rowCache.isEnabled() && this.keyCache.isEnabled()) {
            return "ALL";
        }
        if (this.rowCache.isEnabled()) {
            return "ROWS_ONLY";
        }
        if (this.keyCache.isEnabled()) {
            return "KEYS_ONLY";
        }
        return "NONE";
    }

    public String toThriftCellsPerRow() {
        if (this.rowCache.cacheFullPartitions()) {
            return "ALL";
        }
        return String.valueOf(this.rowCache.rowsToCache);
    }

    public static class RowCache {
        public final Type type;
        public final int rowsToCache;

        public RowCache(Type type) {
            this(type, type == Type.ALL ? Integer.MAX_VALUE : 0);
        }

        public RowCache(Type type, int rowsToCache) {
            this.type = type;
            this.rowsToCache = rowsToCache;
        }

        public static RowCache fromString(String rowCache) {
            if (rowCache == null || rowCache.equalsIgnoreCase("none")) {
                return new RowCache(Type.NONE, 0);
            }
            if (rowCache.equalsIgnoreCase("all")) {
                return new RowCache(Type.ALL, Integer.MAX_VALUE);
            }
            return new RowCache(Type.HEAD, Integer.parseInt(rowCache));
        }

        public boolean isEnabled() {
            return this.type == Type.ALL || this.type == Type.HEAD;
        }

        public boolean cacheFullPartitions() {
            return this.type == Type.ALL;
        }

        public String toString() {
            if (this.type == Type.ALL) {
                return "ALL";
            }
            if (this.type == Type.NONE) {
                return "NONE";
            }
            return String.valueOf(this.rowsToCache);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowCache rowCache = (RowCache)o;
            if (this.rowsToCache != rowCache.rowsToCache) {
                return false;
            }
            return this.type == rowCache.type;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.rowsToCache;
            return result;
        }

        public static enum Type {
            ALL,
            NONE,
            HEAD;

        }
    }

    public static class KeyCache {
        public final Type type;

        public KeyCache(Type type) {
            this.type = type;
        }

        public static KeyCache fromString(String keyCache) {
            return new KeyCache(Type.valueOf(keyCache.toUpperCase()));
        }

        public boolean isEnabled() {
            return this.type == Type.ALL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyCache keyCache = (KeyCache)o;
            return this.type == keyCache.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type.toString();
        }

        public static enum Type {
            ALL,
            NONE;

        }
    }
}

