// $ANTLR 3.5.2 /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2015-07-30 10:20:48

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.*;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.selection.*;
    import org.apache.cassandra.cql3.functions.*;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class CqlParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "B", "BOOLEAN", "C", "COMMENT", 
		"D", "DIGIT", "E", "EXPONENT", "F", "FLOAT", "G", "H", "HEX", "HEXNUMBER", 
		"I", "IDENT", "INTEGER", "J", "K", "K_ADD", "K_AGGREGATE", "K_ALL", "K_ALLOW", 
		"K_ALTER", "K_AND", "K_APPLY", "K_AS", "K_ASC", "K_ASCII", "K_AUTHORIZE", 
		"K_BATCH", "K_BEGIN", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_BY", "K_CALLED", 
		"K_CLUSTERING", "K_COLUMNFAMILY", "K_COMPACT", "K_CONTAINS", "K_COUNT", 
		"K_COUNTER", "K_CREATE", "K_CUSTOM", "K_DATE", "K_DECIMAL", "K_DELETE", 
		"K_DESC", "K_DESCRIBE", "K_DISTINCT", "K_DOUBLE", "K_DROP", "K_ENTRIES", 
		"K_EXECUTE", "K_EXISTS", "K_FILTERING", "K_FINALFUNC", "K_FLOAT", "K_FROM", 
		"K_FROZEN", "K_FULL", "K_FUNCTION", "K_FUNCTIONS", "K_GRANT", "K_IF", 
		"K_IN", "K_INDEX", "K_INET", "K_INFINITY", "K_INITCOND", "K_INPUT", "K_INSERT", 
		"K_INT", "K_INTO", "K_IS", "K_JSON", "K_KEY", "K_KEYS", "K_KEYSPACE", 
		"K_KEYSPACES", "K_LANGUAGE", "K_LIMIT", "K_LIST", "K_LOGIN", "K_MAP", 
		"K_MATERIALIZED", "K_MODIFY", "K_NAN", "K_NOLOGIN", "K_NORECURSIVE", "K_NOSUPERUSER", 
		"K_NOT", "K_NULL", "K_OF", "K_ON", "K_OPTIONS", "K_OR", "K_ORDER", "K_PASSWORD", 
		"K_PERMISSION", "K_PERMISSIONS", "K_PRIMARY", "K_RENAME", "K_REPLACE", 
		"K_RETURNS", "K_REVOKE", "K_ROLE", "K_ROLES", "K_SELECT", "K_SET", "K_SFUNC", 
		"K_SMALLINT", "K_STATIC", "K_STORAGE", "K_STYPE", "K_SUPERUSER", "K_TEXT", 
		"K_TIME", "K_TIMESTAMP", "K_TIMEUUID", "K_TINYINT", "K_TO", "K_TOKEN", 
		"K_TRIGGER", "K_TRUNCATE", "K_TTL", "K_TUPLE", "K_TYPE", "K_UNLOGGED", 
		"K_UPDATE", "K_USE", "K_USER", "K_USERS", "K_USING", "K_UUID", "K_VALUES", 
		"K_VARCHAR", "K_VARINT", "K_VIEW", "K_WHERE", "K_WITH", "K_WRITETIME", 
		"L", "LETTER", "M", "MULTILINE_COMMENT", "N", "O", "P", "Q", "QMARK", 
		"QUOTED_NAME", "R", "S", "STRING_LITERAL", "T", "U", "UUID", "V", "W", 
		"WS", "X", "Y", "Z", "'!='", "'('", "')'", "'+'", "','", "'-'", "'.'", 
		"':'", "';'", "'<'", "'<='", "'='", "'>'", "'>='", "'['", "'\\*'", "']'", 
		"'{'", "'}'"
	};
	public static final int EOF=-1;
	public static final int T__170=170;
	public static final int T__171=171;
	public static final int T__172=172;
	public static final int T__173=173;
	public static final int T__174=174;
	public static final int T__175=175;
	public static final int T__176=176;
	public static final int T__177=177;
	public static final int T__178=178;
	public static final int T__179=179;
	public static final int T__180=180;
	public static final int T__181=181;
	public static final int T__182=182;
	public static final int T__183=183;
	public static final int T__184=184;
	public static final int T__185=185;
	public static final int T__186=186;
	public static final int T__187=187;
	public static final int T__188=188;
	public static final int A=4;
	public static final int B=5;
	public static final int BOOLEAN=6;
	public static final int C=7;
	public static final int COMMENT=8;
	public static final int D=9;
	public static final int DIGIT=10;
	public static final int E=11;
	public static final int EXPONENT=12;
	public static final int F=13;
	public static final int FLOAT=14;
	public static final int G=15;
	public static final int H=16;
	public static final int HEX=17;
	public static final int HEXNUMBER=18;
	public static final int I=19;
	public static final int IDENT=20;
	public static final int INTEGER=21;
	public static final int J=22;
	public static final int K=23;
	public static final int K_ADD=24;
	public static final int K_AGGREGATE=25;
	public static final int K_ALL=26;
	public static final int K_ALLOW=27;
	public static final int K_ALTER=28;
	public static final int K_AND=29;
	public static final int K_APPLY=30;
	public static final int K_AS=31;
	public static final int K_ASC=32;
	public static final int K_ASCII=33;
	public static final int K_AUTHORIZE=34;
	public static final int K_BATCH=35;
	public static final int K_BEGIN=36;
	public static final int K_BIGINT=37;
	public static final int K_BLOB=38;
	public static final int K_BOOLEAN=39;
	public static final int K_BY=40;
	public static final int K_CALLED=41;
	public static final int K_CLUSTERING=42;
	public static final int K_COLUMNFAMILY=43;
	public static final int K_COMPACT=44;
	public static final int K_CONTAINS=45;
	public static final int K_COUNT=46;
	public static final int K_COUNTER=47;
	public static final int K_CREATE=48;
	public static final int K_CUSTOM=49;
	public static final int K_DATE=50;
	public static final int K_DECIMAL=51;
	public static final int K_DELETE=52;
	public static final int K_DESC=53;
	public static final int K_DESCRIBE=54;
	public static final int K_DISTINCT=55;
	public static final int K_DOUBLE=56;
	public static final int K_DROP=57;
	public static final int K_ENTRIES=58;
	public static final int K_EXECUTE=59;
	public static final int K_EXISTS=60;
	public static final int K_FILTERING=61;
	public static final int K_FINALFUNC=62;
	public static final int K_FLOAT=63;
	public static final int K_FROM=64;
	public static final int K_FROZEN=65;
	public static final int K_FULL=66;
	public static final int K_FUNCTION=67;
	public static final int K_FUNCTIONS=68;
	public static final int K_GRANT=69;
	public static final int K_IF=70;
	public static final int K_IN=71;
	public static final int K_INDEX=72;
	public static final int K_INET=73;
	public static final int K_INFINITY=74;
	public static final int K_INITCOND=75;
	public static final int K_INPUT=76;
	public static final int K_INSERT=77;
	public static final int K_INT=78;
	public static final int K_INTO=79;
	public static final int K_IS=80;
	public static final int K_JSON=81;
	public static final int K_KEY=82;
	public static final int K_KEYS=83;
	public static final int K_KEYSPACE=84;
	public static final int K_KEYSPACES=85;
	public static final int K_LANGUAGE=86;
	public static final int K_LIMIT=87;
	public static final int K_LIST=88;
	public static final int K_LOGIN=89;
	public static final int K_MAP=90;
	public static final int K_MATERIALIZED=91;
	public static final int K_MODIFY=92;
	public static final int K_NAN=93;
	public static final int K_NOLOGIN=94;
	public static final int K_NORECURSIVE=95;
	public static final int K_NOSUPERUSER=96;
	public static final int K_NOT=97;
	public static final int K_NULL=98;
	public static final int K_OF=99;
	public static final int K_ON=100;
	public static final int K_OPTIONS=101;
	public static final int K_OR=102;
	public static final int K_ORDER=103;
	public static final int K_PASSWORD=104;
	public static final int K_PERMISSION=105;
	public static final int K_PERMISSIONS=106;
	public static final int K_PRIMARY=107;
	public static final int K_RENAME=108;
	public static final int K_REPLACE=109;
	public static final int K_RETURNS=110;
	public static final int K_REVOKE=111;
	public static final int K_ROLE=112;
	public static final int K_ROLES=113;
	public static final int K_SELECT=114;
	public static final int K_SET=115;
	public static final int K_SFUNC=116;
	public static final int K_SMALLINT=117;
	public static final int K_STATIC=118;
	public static final int K_STORAGE=119;
	public static final int K_STYPE=120;
	public static final int K_SUPERUSER=121;
	public static final int K_TEXT=122;
	public static final int K_TIME=123;
	public static final int K_TIMESTAMP=124;
	public static final int K_TIMEUUID=125;
	public static final int K_TINYINT=126;
	public static final int K_TO=127;
	public static final int K_TOKEN=128;
	public static final int K_TRIGGER=129;
	public static final int K_TRUNCATE=130;
	public static final int K_TTL=131;
	public static final int K_TUPLE=132;
	public static final int K_TYPE=133;
	public static final int K_UNLOGGED=134;
	public static final int K_UPDATE=135;
	public static final int K_USE=136;
	public static final int K_USER=137;
	public static final int K_USERS=138;
	public static final int K_USING=139;
	public static final int K_UUID=140;
	public static final int K_VALUES=141;
	public static final int K_VARCHAR=142;
	public static final int K_VARINT=143;
	public static final int K_VIEW=144;
	public static final int K_WHERE=145;
	public static final int K_WITH=146;
	public static final int K_WRITETIME=147;
	public static final int L=148;
	public static final int LETTER=149;
	public static final int M=150;
	public static final int MULTILINE_COMMENT=151;
	public static final int N=152;
	public static final int O=153;
	public static final int P=154;
	public static final int Q=155;
	public static final int QMARK=156;
	public static final int QUOTED_NAME=157;
	public static final int R=158;
	public static final int S=159;
	public static final int STRING_LITERAL=160;
	public static final int T=161;
	public static final int U=162;
	public static final int UUID=163;
	public static final int V=164;
	public static final int W=165;
	public static final int WS=166;
	public static final int X=167;
	public static final int Y=168;
	public static final int Z=169;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CqlParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CqlParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CqlParser.tokenNames; }
	@Override public String getGrammarFileName() { return "/tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


	    private final List<ErrorListener> listeners = new ArrayList<ErrorListener>();
	    private final List<ColumnIdentifier> bindVariables = new ArrayList<ColumnIdentifier>();

	    public static final Set<String> reservedTypeNames = new HashSet<String>()
	    {{
	        add("byte");
	        add("complex");
	        add("enum");
	        add("date");
	        add("interval");
	        add("macaddr");
	        add("bitstring");
	    }};

	    public AbstractMarker.Raw newBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.Raw marker = new AbstractMarker.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public AbstractMarker.INRaw newINBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.INRaw marker = new AbstractMarker.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.Raw newTupleBindVariables(ColumnIdentifier name)
	    {
	        Tuples.Raw marker = new Tuples.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.INRaw newTupleINBindVariables(ColumnIdentifier name)
	    {
	        Tuples.INRaw marker = new Tuples.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Json.Marker newJsonBindVariables(ColumnIdentifier name)
	    {
	        Json.Marker marker = new Json.Marker(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public void addErrorListener(ErrorListener listener)
	    {
	        this.listeners.add(listener);
	    }

	    public void removeErrorListener(ErrorListener listener)
	    {
	        this.listeners.remove(listener);
	    }

	    public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, tokenNames, e);
	    }

	    private void addRecognitionError(String msg)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, msg);
	    }

	    public Map<String, String> convertPropertyMap(Maps.Literal map)
	    {
	        if (map == null || map.entries == null || map.entries.isEmpty())
	            return Collections.<String, String>emptyMap();

	        Map<String, String> res = new HashMap<String, String>(map.entries.size());

	        for (Pair<Term.Raw, Term.Raw> entry : map.entries)
	        {
	            // Because the parser tries to be smart and recover on error (to
	            // allow displaying more than one error I suppose), we have null
	            // entries in there. Just skip those, a proper error will be thrown in the end.
	            if (entry.left == null || entry.right == null)
	                break;

	            if (!(entry.left instanceof Constants.Literal))
	            {
	                String msg = "Invalid property name: " + entry.left;
	                if (entry.left instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }
	            if (!(entry.right instanceof Constants.Literal))
	            {
	                String msg = "Invalid property value: " + entry.right + " for property: " + entry.left;
	                if (entry.right instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }

	            res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
	        }

	        return res;
	    }

	    public void addRawUpdate(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Operation.RawUpdate update)
	    {
	        for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> p : operations)
	        {
	            if (p.left.equals(key) && !p.right.isCompatibleWith(update))
	                addRecognitionError("Multiple incompatible setting of column " + key);
	        }
	        operations.add(Pair.create(key, update));
	    }

	    public Set<Permission> filterPermissions(Set<Permission> permissions, IResource resource)
	    {
	        if (resource == null)
	            return Collections.emptySet();
	        Set<Permission> filtered = new HashSet<>(permissions);
	        filtered.retainAll(resource.applicablePermissions());
	        if (filtered.isEmpty())
	            addRecognitionError("Resource type " + resource.getClass().getSimpleName() +
	                                    " does not support any of the requested permissions");

	        return filtered;
	    }



	// $ANTLR start "query"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:230:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
	public final ParsedStatement query() throws RecognitionException {
		ParsedStatement stmnt = null;


		ParsedStatement st =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:5: (st= cqlStatement ( ';' )* EOF )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:7: st= cqlStatement ( ';' )* EOF
			{
			pushFollow(FOLLOW_cqlStatement_in_query72);
			st=cqlStatement();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:23: ( ';' )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==178) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:24: ';'
					{
					match(input,178,FOLLOW_178_in_query75); 
					}
					break;

				default :
					break loop1;
				}
			}

			match(input,EOF,FOLLOW_EOF_in_query79); 
			 stmnt = st; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "query"



	// $ANTLR start "cqlStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement );
	public final ParsedStatement cqlStatement() throws RecognitionException {
		ParsedStatement stmt = null;


		SelectStatement.RawStatement st1 =null;
		ModificationStatement.Parsed st2 =null;
		UpdateStatement.ParsedUpdate st3 =null;
		BatchStatement.Parsed st4 =null;
		DeleteStatement.Parsed st5 =null;
		UseStatement st6 =null;
		TruncateStatement st7 =null;
		CreateKeyspaceStatement st8 =null;
		CreateTableStatement.RawStatement st9 =null;
		CreateIndexStatement st10 =null;
		DropKeyspaceStatement st11 =null;
		DropTableStatement st12 =null;
		DropIndexStatement st13 =null;
		AlterTableStatement st14 =null;
		AlterKeyspaceStatement st15 =null;
		GrantPermissionsStatement st16 =null;
		RevokePermissionsStatement st17 =null;
		ListPermissionsStatement st18 =null;
		CreateRoleStatement st19 =null;
		AlterRoleStatement st20 =null;
		DropRoleStatement st21 =null;
		ListRolesStatement st22 =null;
		CreateTriggerStatement st23 =null;
		DropTriggerStatement st24 =null;
		CreateTypeStatement st25 =null;
		AlterTypeStatement st26 =null;
		DropTypeStatement st27 =null;
		CreateFunctionStatement st28 =null;
		DropFunctionStatement st29 =null;
		CreateAggregateStatement st30 =null;
		DropAggregateStatement st31 =null;
		CreateRoleStatement st32 =null;
		AlterRoleStatement st33 =null;
		DropRoleStatement st34 =null;
		ListRolesStatement st35 =null;
		GrantRoleStatement st36 =null;
		RevokeRoleStatement st37 =null;
		CreateMaterializedViewStatement st38 =null;
		DropMaterializedViewStatement st39 =null;
		AlterMaterializedViewStatement st40 =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:5: (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement )
			int alt2=40;
			alt2 = dfa2.predict(input);
			switch (alt2) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:7: st1= selectStatement
					{
					pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
					st1=selectStatement();
					state._fsp--;

					 stmt = st1; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:237:7: st2= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_cqlStatement142);
					st2=insertStatement();
					state._fsp--;

					 stmt = st2; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: st3= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_cqlStatement171);
					st3=updateStatement();
					state._fsp--;

					 stmt = st3; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: st4= batchStatement
					{
					pushFollow(FOLLOW_batchStatement_in_cqlStatement200);
					st4=batchStatement();
					state._fsp--;

					 stmt = st4; 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:7: st5= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_cqlStatement230);
					st5=deleteStatement();
					state._fsp--;

					 stmt = st5; 
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:7: st6= useStatement
					{
					pushFollow(FOLLOW_useStatement_in_cqlStatement259);
					st6=useStatement();
					state._fsp--;

					 stmt = st6; 
					}
					break;
				case 7 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:242:7: st7= truncateStatement
					{
					pushFollow(FOLLOW_truncateStatement_in_cqlStatement291);
					st7=truncateStatement();
					state._fsp--;

					 stmt = st7; 
					}
					break;
				case 8 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:243:7: st8= createKeyspaceStatement
					{
					pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement318);
					st8=createKeyspaceStatement();
					state._fsp--;

					 stmt = st8; 
					}
					break;
				case 9 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:7: st9= createTableStatement
					{
					pushFollow(FOLLOW_createTableStatement_in_cqlStatement339);
					st9=createTableStatement();
					state._fsp--;

					 stmt = st9; 
					}
					break;
				case 10 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:245:7: st10= createIndexStatement
					{
					pushFollow(FOLLOW_createIndexStatement_in_cqlStatement362);
					st10=createIndexStatement();
					state._fsp--;

					 stmt = st10; 
					}
					break;
				case 11 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:246:7: st11= dropKeyspaceStatement
					{
					pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement385);
					st11=dropKeyspaceStatement();
					state._fsp--;

					 stmt = st11; 
					}
					break;
				case 12 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:247:7: st12= dropTableStatement
					{
					pushFollow(FOLLOW_dropTableStatement_in_cqlStatement407);
					st12=dropTableStatement();
					state._fsp--;

					 stmt = st12; 
					}
					break;
				case 13 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:248:7: st13= dropIndexStatement
					{
					pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement432);
					st13=dropIndexStatement();
					state._fsp--;

					 stmt = st13; 
					}
					break;
				case 14 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:249:7: st14= alterTableStatement
					{
					pushFollow(FOLLOW_alterTableStatement_in_cqlStatement457);
					st14=alterTableStatement();
					state._fsp--;

					 stmt = st14; 
					}
					break;
				case 15 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:250:7: st15= alterKeyspaceStatement
					{
					pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement481);
					st15=alterKeyspaceStatement();
					state._fsp--;

					 stmt = st15; 
					}
					break;
				case 16 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:7: st16= grantPermissionsStatement
					{
					pushFollow(FOLLOW_grantPermissionsStatement_in_cqlStatement502);
					st16=grantPermissionsStatement();
					state._fsp--;

					 stmt = st16; 
					}
					break;
				case 17 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:252:7: st17= revokePermissionsStatement
					{
					pushFollow(FOLLOW_revokePermissionsStatement_in_cqlStatement520);
					st17=revokePermissionsStatement();
					state._fsp--;

					 stmt = st17; 
					}
					break;
				case 18 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:253:7: st18= listPermissionsStatement
					{
					pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement537);
					st18=listPermissionsStatement();
					state._fsp--;

					 stmt = st18; 
					}
					break;
				case 19 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:254:7: st19= createUserStatement
					{
					pushFollow(FOLLOW_createUserStatement_in_cqlStatement556);
					st19=createUserStatement();
					state._fsp--;

					 stmt = st19; 
					}
					break;
				case 20 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:255:7: st20= alterUserStatement
					{
					pushFollow(FOLLOW_alterUserStatement_in_cqlStatement580);
					st20=alterUserStatement();
					state._fsp--;

					 stmt = st20; 
					}
					break;
				case 21 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:256:7: st21= dropUserStatement
					{
					pushFollow(FOLLOW_dropUserStatement_in_cqlStatement605);
					st21=dropUserStatement();
					state._fsp--;

					 stmt = st21; 
					}
					break;
				case 22 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:257:7: st22= listUsersStatement
					{
					pushFollow(FOLLOW_listUsersStatement_in_cqlStatement631);
					st22=listUsersStatement();
					state._fsp--;

					 stmt = st22; 
					}
					break;
				case 23 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:258:7: st23= createTriggerStatement
					{
					pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement656);
					st23=createTriggerStatement();
					state._fsp--;

					 stmt = st23; 
					}
					break;
				case 24 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:259:7: st24= dropTriggerStatement
					{
					pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement677);
					st24=dropTriggerStatement();
					state._fsp--;

					 stmt = st24; 
					}
					break;
				case 25 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:260:7: st25= createTypeStatement
					{
					pushFollow(FOLLOW_createTypeStatement_in_cqlStatement700);
					st25=createTypeStatement();
					state._fsp--;

					 stmt = st25; 
					}
					break;
				case 26 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:261:7: st26= alterTypeStatement
					{
					pushFollow(FOLLOW_alterTypeStatement_in_cqlStatement724);
					st26=alterTypeStatement();
					state._fsp--;

					 stmt = st26; 
					}
					break;
				case 27 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:262:7: st27= dropTypeStatement
					{
					pushFollow(FOLLOW_dropTypeStatement_in_cqlStatement749);
					st27=dropTypeStatement();
					state._fsp--;

					 stmt = st27; 
					}
					break;
				case 28 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:263:7: st28= createFunctionStatement
					{
					pushFollow(FOLLOW_createFunctionStatement_in_cqlStatement775);
					st28=createFunctionStatement();
					state._fsp--;

					 stmt = st28; 
					}
					break;
				case 29 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:264:7: st29= dropFunctionStatement
					{
					pushFollow(FOLLOW_dropFunctionStatement_in_cqlStatement795);
					st29=dropFunctionStatement();
					state._fsp--;

					 stmt = st29; 
					}
					break;
				case 30 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:265:7: st30= createAggregateStatement
					{
					pushFollow(FOLLOW_createAggregateStatement_in_cqlStatement817);
					st30=createAggregateStatement();
					state._fsp--;

					 stmt = st30; 
					}
					break;
				case 31 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:266:7: st31= dropAggregateStatement
					{
					pushFollow(FOLLOW_dropAggregateStatement_in_cqlStatement836);
					st31=dropAggregateStatement();
					state._fsp--;

					 stmt = st31; 
					}
					break;
				case 32 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:267:7: st32= createRoleStatement
					{
					pushFollow(FOLLOW_createRoleStatement_in_cqlStatement857);
					st32=createRoleStatement();
					state._fsp--;

					 stmt = st32; 
					}
					break;
				case 33 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:7: st33= alterRoleStatement
					{
					pushFollow(FOLLOW_alterRoleStatement_in_cqlStatement881);
					st33=alterRoleStatement();
					state._fsp--;

					 stmt = st33; 
					}
					break;
				case 34 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:7: st34= dropRoleStatement
					{
					pushFollow(FOLLOW_dropRoleStatement_in_cqlStatement906);
					st34=dropRoleStatement();
					state._fsp--;

					 stmt = st34; 
					}
					break;
				case 35 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:7: st35= listRolesStatement
					{
					pushFollow(FOLLOW_listRolesStatement_in_cqlStatement932);
					st35=listRolesStatement();
					state._fsp--;

					 stmt = st35; 
					}
					break;
				case 36 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:271:7: st36= grantRoleStatement
					{
					pushFollow(FOLLOW_grantRoleStatement_in_cqlStatement957);
					st36=grantRoleStatement();
					state._fsp--;

					 stmt = st36; 
					}
					break;
				case 37 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:7: st37= revokeRoleStatement
					{
					pushFollow(FOLLOW_revokeRoleStatement_in_cqlStatement982);
					st37=revokeRoleStatement();
					state._fsp--;

					 stmt = st37; 
					}
					break;
				case 38 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:7: st38= createMaterializedViewStatement
					{
					pushFollow(FOLLOW_createMaterializedViewStatement_in_cqlStatement1006);
					st38=createMaterializedViewStatement();
					state._fsp--;

					 stmt = st38; 
					}
					break;
				case 39 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:274:7: st39= dropMaterializedViewStatement
					{
					pushFollow(FOLLOW_dropMaterializedViewStatement_in_cqlStatement1018);
					st39=dropMaterializedViewStatement();
					state._fsp--;

					 stmt = st39; 
					}
					break;
				case 40 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:7: st40= alterMaterializedViewStatement
					{
					pushFollow(FOLLOW_alterMaterializedViewStatement_in_cqlStatement1032);
					st40=alterMaterializedViewStatement();
					state._fsp--;

					 stmt = st40; 
					}
					break;

			}
			 if (stmt != null) stmt.setBoundVariables(bindVariables); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "cqlStatement"



	// $ANTLR start "useStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:281:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
	public final UseStatement useStatement() throws RecognitionException {
		UseStatement stmt = null;


		String ks =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:282:5: ( K_USE ks= keyspaceName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:282:7: K_USE ks= keyspaceName
			{
			match(input,K_USE,FOLLOW_K_USE_in_useStatement1058); 
			pushFollow(FOLLOW_keyspaceName_in_useStatement1062);
			ks=keyspaceName();
			state._fsp--;

			 stmt = new UseStatement(ks); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "useStatement"



	// $ANTLR start "selectStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:291:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT ( K_JSON )? ( ( K_DISTINCT )? sclause= selectClause |sclause= selectCountClause ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
	public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
		SelectStatement.RawStatement expr = null;


		List<RawSelector> sclause =null;
		CFName cf =null;
		List<Relation> wclause =null;
		Term.Raw rows =null;


		        boolean isDistinct = false;
		        Term.Raw limit = null;
		        Map<ColumnIdentifier.Raw, Boolean> orderings = new LinkedHashMap<ColumnIdentifier.Raw, Boolean>();
		        boolean allowFiltering = false;
		        boolean isJson = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:5: ( K_SELECT ( K_JSON )? ( ( K_DISTINCT )? sclause= selectClause |sclause= selectCountClause ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:7: K_SELECT ( K_JSON )? ( ( K_DISTINCT )? sclause= selectClause |sclause= selectCountClause ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
			{
			match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement1096); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:7: ( K_JSON )?
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==K_JSON) ) {
				int LA3_1 = input.LA(2);
				if ( (LA3_1==IDENT||(LA3_1 >= K_AGGREGATE && LA3_1 <= K_ALL)||LA3_1==K_ASCII||(LA3_1 >= K_BIGINT && LA3_1 <= K_BOOLEAN)||(LA3_1 >= K_CALLED && LA3_1 <= K_CLUSTERING)||(LA3_1 >= K_COMPACT && LA3_1 <= K_COUNTER)||(LA3_1 >= K_CUSTOM && LA3_1 <= K_DECIMAL)||(LA3_1 >= K_DISTINCT && LA3_1 <= K_DOUBLE)||(LA3_1 >= K_EXISTS && LA3_1 <= K_FLOAT)||LA3_1==K_FROZEN||(LA3_1 >= K_FUNCTION && LA3_1 <= K_FUNCTIONS)||LA3_1==K_INET||(LA3_1 >= K_INITCOND && LA3_1 <= K_INPUT)||LA3_1==K_INT||(LA3_1 >= K_JSON && LA3_1 <= K_KEYS)||(LA3_1 >= K_KEYSPACES && LA3_1 <= K_LANGUAGE)||(LA3_1 >= K_LIST && LA3_1 <= K_MAP)||LA3_1==K_NOLOGIN||LA3_1==K_NOSUPERUSER||LA3_1==K_OPTIONS||(LA3_1 >= K_PASSWORD && LA3_1 <= K_PERMISSIONS)||LA3_1==K_RETURNS||(LA3_1 >= K_ROLE && LA3_1 <= K_ROLES)||(LA3_1 >= K_SFUNC && LA3_1 <= K_TINYINT)||(LA3_1 >= K_TOKEN && LA3_1 <= K_TRIGGER)||(LA3_1 >= K_TTL && LA3_1 <= K_TYPE)||(LA3_1 >= K_USER && LA3_1 <= K_USERS)||(LA3_1 >= K_UUID && LA3_1 <= K_VARINT)||LA3_1==K_WRITETIME||(LA3_1 >= QMARK && LA3_1 <= QUOTED_NAME)||LA3_1==185) ) {
					alt3=1;
				}
				else if ( (LA3_1==K_AS) ) {
					int LA3_4 = input.LA(3);
					if ( (LA3_4==K_FROM||LA3_4==171||LA3_4==174||LA3_4==176) ) {
						alt3=1;
					}
					else if ( (LA3_4==K_AS) ) {
						int LA3_5 = input.LA(4);
						if ( (LA3_5==IDENT||(LA3_5 >= K_AGGREGATE && LA3_5 <= K_ALL)||LA3_5==K_AS||LA3_5==K_ASCII||(LA3_5 >= K_BIGINT && LA3_5 <= K_BOOLEAN)||(LA3_5 >= K_CALLED && LA3_5 <= K_CLUSTERING)||(LA3_5 >= K_COMPACT && LA3_5 <= K_COUNTER)||(LA3_5 >= K_CUSTOM && LA3_5 <= K_DECIMAL)||(LA3_5 >= K_DISTINCT && LA3_5 <= K_DOUBLE)||(LA3_5 >= K_EXISTS && LA3_5 <= K_FLOAT)||LA3_5==K_FROZEN||(LA3_5 >= K_FUNCTION && LA3_5 <= K_FUNCTIONS)||LA3_5==K_INET||(LA3_5 >= K_INITCOND && LA3_5 <= K_INPUT)||LA3_5==K_INT||(LA3_5 >= K_JSON && LA3_5 <= K_KEYS)||(LA3_5 >= K_KEYSPACES && LA3_5 <= K_LANGUAGE)||(LA3_5 >= K_LIST && LA3_5 <= K_MAP)||LA3_5==K_NOLOGIN||LA3_5==K_NOSUPERUSER||LA3_5==K_OPTIONS||(LA3_5 >= K_PASSWORD && LA3_5 <= K_PERMISSIONS)||LA3_5==K_RETURNS||(LA3_5 >= K_ROLE && LA3_5 <= K_ROLES)||(LA3_5 >= K_SFUNC && LA3_5 <= K_TINYINT)||LA3_5==K_TRIGGER||(LA3_5 >= K_TTL && LA3_5 <= K_TYPE)||(LA3_5 >= K_USER && LA3_5 <= K_USERS)||(LA3_5 >= K_UUID && LA3_5 <= K_VARINT)||LA3_5==K_WRITETIME||LA3_5==QUOTED_NAME) ) {
							alt3=1;
						}
					}
				}
			}
			switch (alt3) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:9: K_JSON
					{
					match(input,K_JSON,FOLLOW_K_JSON_in_selectStatement1107); 
					 isJson = true; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:7: ( ( K_DISTINCT )? sclause= selectClause |sclause= selectCountClause )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==IDENT||(LA5_0 >= K_AGGREGATE && LA5_0 <= K_ALL)||LA5_0==K_AS||LA5_0==K_ASCII||(LA5_0 >= K_BIGINT && LA5_0 <= K_BOOLEAN)||(LA5_0 >= K_CALLED && LA5_0 <= K_CLUSTERING)||(LA5_0 >= K_COMPACT && LA5_0 <= K_CONTAINS)||LA5_0==K_COUNTER||(LA5_0 >= K_CUSTOM && LA5_0 <= K_DECIMAL)||(LA5_0 >= K_DISTINCT && LA5_0 <= K_DOUBLE)||(LA5_0 >= K_EXISTS && LA5_0 <= K_FLOAT)||LA5_0==K_FROZEN||(LA5_0 >= K_FUNCTION && LA5_0 <= K_FUNCTIONS)||LA5_0==K_INET||(LA5_0 >= K_INITCOND && LA5_0 <= K_INPUT)||LA5_0==K_INT||(LA5_0 >= K_JSON && LA5_0 <= K_KEYS)||(LA5_0 >= K_KEYSPACES && LA5_0 <= K_LANGUAGE)||(LA5_0 >= K_LIST && LA5_0 <= K_MAP)||LA5_0==K_NOLOGIN||LA5_0==K_NOSUPERUSER||LA5_0==K_OPTIONS||(LA5_0 >= K_PASSWORD && LA5_0 <= K_PERMISSIONS)||LA5_0==K_RETURNS||(LA5_0 >= K_ROLE && LA5_0 <= K_ROLES)||(LA5_0 >= K_SFUNC && LA5_0 <= K_TINYINT)||(LA5_0 >= K_TOKEN && LA5_0 <= K_TRIGGER)||(LA5_0 >= K_TTL && LA5_0 <= K_TYPE)||(LA5_0 >= K_USER && LA5_0 <= K_USERS)||(LA5_0 >= K_UUID && LA5_0 <= K_VARINT)||LA5_0==K_WRITETIME||(LA5_0 >= QMARK && LA5_0 <= QUOTED_NAME)||LA5_0==185) ) {
				alt5=1;
			}
			else if ( (LA5_0==K_COUNT) ) {
				int LA5_2 = input.LA(2);
				if ( (LA5_2==171) ) {
					int LA5_3 = input.LA(3);
					if ( (LA5_3==IDENT||(LA5_3 >= K_AGGREGATE && LA5_3 <= K_ALL)||LA5_3==K_AS||LA5_3==K_ASCII||(LA5_3 >= K_BIGINT && LA5_3 <= K_BOOLEAN)||(LA5_3 >= K_CALLED && LA5_3 <= K_CLUSTERING)||(LA5_3 >= K_COMPACT && LA5_3 <= K_COUNTER)||(LA5_3 >= K_CUSTOM && LA5_3 <= K_DECIMAL)||(LA5_3 >= K_DISTINCT && LA5_3 <= K_DOUBLE)||(LA5_3 >= K_EXISTS && LA5_3 <= K_FLOAT)||LA5_3==K_FROZEN||(LA5_3 >= K_FUNCTION && LA5_3 <= K_FUNCTIONS)||LA5_3==K_INET||(LA5_3 >= K_INITCOND && LA5_3 <= K_INPUT)||LA5_3==K_INT||(LA5_3 >= K_JSON && LA5_3 <= K_KEYS)||(LA5_3 >= K_KEYSPACES && LA5_3 <= K_LANGUAGE)||(LA5_3 >= K_LIST && LA5_3 <= K_MAP)||LA5_3==K_NOLOGIN||LA5_3==K_NOSUPERUSER||LA5_3==K_OPTIONS||(LA5_3 >= K_PASSWORD && LA5_3 <= K_PERMISSIONS)||LA5_3==K_RETURNS||(LA5_3 >= K_ROLE && LA5_3 <= K_ROLES)||(LA5_3 >= K_SFUNC && LA5_3 <= K_TINYINT)||(LA5_3 >= K_TOKEN && LA5_3 <= K_TRIGGER)||(LA5_3 >= K_TTL && LA5_3 <= K_TYPE)||(LA5_3 >= K_USER && LA5_3 <= K_USERS)||(LA5_3 >= K_UUID && LA5_3 <= K_VARINT)||LA5_3==K_WRITETIME||(LA5_3 >= QMARK && LA5_3 <= QUOTED_NAME)||LA5_3==172) ) {
						alt5=1;
					}
					else if ( (LA5_3==INTEGER||LA5_3==185) ) {
						alt5=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 5, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}
				else if ( (LA5_2==K_AS||LA5_2==K_FROM||LA5_2==174||LA5_2==176) ) {
					alt5=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 5, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:9: ( K_DISTINCT )? sclause= selectClause
					{
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:9: ( K_DISTINCT )?
					int alt4=2;
					int LA4_0 = input.LA(1);
					if ( (LA4_0==K_DISTINCT) ) {
						int LA4_1 = input.LA(2);
						if ( (LA4_1==IDENT||(LA4_1 >= K_AGGREGATE && LA4_1 <= K_ALL)||LA4_1==K_ASCII||(LA4_1 >= K_BIGINT && LA4_1 <= K_BOOLEAN)||(LA4_1 >= K_CALLED && LA4_1 <= K_CLUSTERING)||(LA4_1 >= K_COMPACT && LA4_1 <= K_COUNTER)||(LA4_1 >= K_CUSTOM && LA4_1 <= K_DECIMAL)||(LA4_1 >= K_DISTINCT && LA4_1 <= K_DOUBLE)||(LA4_1 >= K_EXISTS && LA4_1 <= K_FLOAT)||LA4_1==K_FROZEN||(LA4_1 >= K_FUNCTION && LA4_1 <= K_FUNCTIONS)||LA4_1==K_INET||(LA4_1 >= K_INITCOND && LA4_1 <= K_INPUT)||LA4_1==K_INT||(LA4_1 >= K_JSON && LA4_1 <= K_KEYS)||(LA4_1 >= K_KEYSPACES && LA4_1 <= K_LANGUAGE)||(LA4_1 >= K_LIST && LA4_1 <= K_MAP)||LA4_1==K_NOLOGIN||LA4_1==K_NOSUPERUSER||LA4_1==K_OPTIONS||(LA4_1 >= K_PASSWORD && LA4_1 <= K_PERMISSIONS)||LA4_1==K_RETURNS||(LA4_1 >= K_ROLE && LA4_1 <= K_ROLES)||(LA4_1 >= K_SFUNC && LA4_1 <= K_TINYINT)||(LA4_1 >= K_TOKEN && LA4_1 <= K_TRIGGER)||(LA4_1 >= K_TTL && LA4_1 <= K_TYPE)||(LA4_1 >= K_USER && LA4_1 <= K_USERS)||(LA4_1 >= K_UUID && LA4_1 <= K_VARINT)||LA4_1==K_WRITETIME||(LA4_1 >= QMARK && LA4_1 <= QUOTED_NAME)||LA4_1==185) ) {
							alt4=1;
						}
						else if ( (LA4_1==K_AS) ) {
							int LA4_4 = input.LA(3);
							if ( (LA4_4==K_FROM||LA4_4==171||LA4_4==174||LA4_4==176) ) {
								alt4=1;
							}
							else if ( (LA4_4==K_AS) ) {
								int LA4_5 = input.LA(4);
								if ( (LA4_5==IDENT||(LA4_5 >= K_AGGREGATE && LA4_5 <= K_ALL)||LA4_5==K_AS||LA4_5==K_ASCII||(LA4_5 >= K_BIGINT && LA4_5 <= K_BOOLEAN)||(LA4_5 >= K_CALLED && LA4_5 <= K_CLUSTERING)||(LA4_5 >= K_COMPACT && LA4_5 <= K_COUNTER)||(LA4_5 >= K_CUSTOM && LA4_5 <= K_DECIMAL)||(LA4_5 >= K_DISTINCT && LA4_5 <= K_DOUBLE)||(LA4_5 >= K_EXISTS && LA4_5 <= K_FLOAT)||LA4_5==K_FROZEN||(LA4_5 >= K_FUNCTION && LA4_5 <= K_FUNCTIONS)||LA4_5==K_INET||(LA4_5 >= K_INITCOND && LA4_5 <= K_INPUT)||LA4_5==K_INT||(LA4_5 >= K_JSON && LA4_5 <= K_KEYS)||(LA4_5 >= K_KEYSPACES && LA4_5 <= K_LANGUAGE)||(LA4_5 >= K_LIST && LA4_5 <= K_MAP)||LA4_5==K_NOLOGIN||LA4_5==K_NOSUPERUSER||LA4_5==K_OPTIONS||(LA4_5 >= K_PASSWORD && LA4_5 <= K_PERMISSIONS)||LA4_5==K_RETURNS||(LA4_5 >= K_ROLE && LA4_5 <= K_ROLES)||(LA4_5 >= K_SFUNC && LA4_5 <= K_TINYINT)||LA4_5==K_TRIGGER||(LA4_5 >= K_TTL && LA4_5 <= K_TYPE)||(LA4_5 >= K_USER && LA4_5 <= K_USERS)||(LA4_5 >= K_UUID && LA4_5 <= K_VARINT)||LA4_5==K_WRITETIME||LA4_5==QUOTED_NAME) ) {
									alt4=1;
								}
							}
						}
					}
					switch (alt4) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:11: K_DISTINCT
							{
							match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_selectStatement1124); 
							 isDistinct = true; 
							}
							break;

					}

					pushFollow(FOLLOW_selectClause_in_selectStatement1133);
					sclause=selectClause();
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:302:11: sclause= selectCountClause
					{
					pushFollow(FOLLOW_selectCountClause_in_selectStatement1147);
					sclause=selectCountClause();
					state._fsp--;

					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement1157); 
			pushFollow(FOLLOW_columnFamilyName_in_selectStatement1161);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:7: ( K_WHERE wclause= whereClause )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==K_WHERE) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:304:9: K_WHERE wclause= whereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement1171); 
					pushFollow(FOLLOW_whereClause_in_selectStatement1175);
					wclause=whereClause();
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==K_ORDER) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
					{
					match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement1188); 
					match(input,K_BY,FOLLOW_K_BY_in_selectStatement1190); 
					pushFollow(FOLLOW_orderByClause_in_selectStatement1192);
					orderByClause(orderings);
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:47: ( ',' orderByClause[orderings] )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==174) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:49: ',' orderByClause[orderings]
							{
							match(input,174,FOLLOW_174_in_selectStatement1197); 
							pushFollow(FOLLOW_orderByClause_in_selectStatement1199);
							orderByClause(orderings);
							state._fsp--;

							}
							break;

						default :
							break loop7;
						}
					}

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:7: ( K_LIMIT rows= intValue )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==K_LIMIT) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:9: K_LIMIT rows= intValue
					{
					match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement1216); 
					pushFollow(FOLLOW_intValue_in_selectStatement1220);
					rows=intValue();
					state._fsp--;

					 limit = rows; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:307:7: ( K_ALLOW K_FILTERING )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==K_ALLOW) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:307:9: K_ALLOW K_FILTERING
					{
					match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement1235); 
					match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement1237); 
					 allowFiltering = true; 
					}
					break;

			}


			          SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
			                                                                             isDistinct,
			                                                                             allowFiltering,
			                                                                             isJson);
			          expr = new SelectStatement.RawStatement(cf, params, sclause, wclause, limit);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectStatement"



	// $ANTLR start "selectClause"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
	public final List<RawSelector> selectClause() throws RecognitionException {
		List<RawSelector> expr = null;


		RawSelector t1 =null;
		RawSelector tN =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:318:5: (t1= selector ( ',' tN= selector )* | '\\*' )
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==IDENT||(LA12_0 >= K_AGGREGATE && LA12_0 <= K_ALL)||LA12_0==K_AS||LA12_0==K_ASCII||(LA12_0 >= K_BIGINT && LA12_0 <= K_BOOLEAN)||(LA12_0 >= K_CALLED && LA12_0 <= K_CLUSTERING)||(LA12_0 >= K_COMPACT && LA12_0 <= K_COUNTER)||(LA12_0 >= K_CUSTOM && LA12_0 <= K_DECIMAL)||(LA12_0 >= K_DISTINCT && LA12_0 <= K_DOUBLE)||(LA12_0 >= K_EXISTS && LA12_0 <= K_FLOAT)||LA12_0==K_FROZEN||(LA12_0 >= K_FUNCTION && LA12_0 <= K_FUNCTIONS)||LA12_0==K_INET||(LA12_0 >= K_INITCOND && LA12_0 <= K_INPUT)||LA12_0==K_INT||(LA12_0 >= K_JSON && LA12_0 <= K_KEYS)||(LA12_0 >= K_KEYSPACES && LA12_0 <= K_LANGUAGE)||(LA12_0 >= K_LIST && LA12_0 <= K_MAP)||LA12_0==K_NOLOGIN||LA12_0==K_NOSUPERUSER||LA12_0==K_OPTIONS||(LA12_0 >= K_PASSWORD && LA12_0 <= K_PERMISSIONS)||LA12_0==K_RETURNS||(LA12_0 >= K_ROLE && LA12_0 <= K_ROLES)||(LA12_0 >= K_SFUNC && LA12_0 <= K_TINYINT)||(LA12_0 >= K_TOKEN && LA12_0 <= K_TRIGGER)||(LA12_0 >= K_TTL && LA12_0 <= K_TYPE)||(LA12_0 >= K_USER && LA12_0 <= K_USERS)||(LA12_0 >= K_UUID && LA12_0 <= K_VARINT)||LA12_0==K_WRITETIME||(LA12_0 >= QMARK && LA12_0 <= QUOTED_NAME)) ) {
				alt12=1;
			}
			else if ( (LA12_0==185) ) {
				alt12=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}

			switch (alt12) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:318:7: t1= selector ( ',' tN= selector )*
					{
					pushFollow(FOLLOW_selector_in_selectClause1274);
					t1=selector();
					state._fsp--;

					 expr = new ArrayList<RawSelector>(); expr.add(t1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:318:76: ( ',' tN= selector )*
					loop11:
					while (true) {
						int alt11=2;
						int LA11_0 = input.LA(1);
						if ( (LA11_0==174) ) {
							alt11=1;
						}

						switch (alt11) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:318:77: ',' tN= selector
							{
							match(input,174,FOLLOW_174_in_selectClause1279); 
							pushFollow(FOLLOW_selector_in_selectClause1283);
							tN=selector();
							state._fsp--;

							 expr.add(tN); 
							}
							break;

						default :
							break loop11;
						}
					}

					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:7: '\\*'
					{
					match(input,185,FOLLOW_185_in_selectClause1295); 
					 expr = Collections.<RawSelector>emptyList();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selector"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= noncol_ident )? ;
	public final RawSelector selector() throws RecognitionException {
		RawSelector s = null;


		Selectable.Raw us =null;
		ColumnIdentifier c =null;

		 ColumnIdentifier alias = null; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:324:5: (us= unaliasedSelector ( K_AS c= noncol_ident )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:324:7: us= unaliasedSelector ( K_AS c= noncol_ident )?
			{
			pushFollow(FOLLOW_unaliasedSelector_in_selector1328);
			us=unaliasedSelector();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:324:28: ( K_AS c= noncol_ident )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==K_AS) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:324:29: K_AS c= noncol_ident
					{
					match(input,K_AS,FOLLOW_K_AS_in_selector1331); 
					pushFollow(FOLLOW_noncol_ident_in_selector1335);
					c=noncol_ident();
					state._fsp--;

					 alias = c; 
					}
					break;

			}

			 s = new RawSelector(us, alias); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selector"



	// $ANTLR start "unaliasedSelector"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:1: unaliasedSelector returns [Selectable.Raw s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* ;
	public final Selectable.Raw unaliasedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		ColumnIdentifier.Raw c =null;
		FunctionName f =null;
		List<Selectable.Raw> args =null;
		ColumnIdentifier.Raw fi =null;

		 Selectable.Raw tmp = null; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:329:5: ( (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:329:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )*
			{
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:329:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs )
			int alt14=4;
			alt14 = dfa14.predict(input);
			switch (alt14) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:329:10: c= cident
					{
					pushFollow(FOLLOW_cident_in_unaliasedSelector1376);
					c=cident();
					state._fsp--;

					 tmp = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:330:10: K_WRITETIME '(' c= cident ')'
					{
					match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_unaliasedSelector1422); 
					match(input,171,FOLLOW_171_in_unaliasedSelector1424); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1428);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_unaliasedSelector1430); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:331:10: K_TTL '(' c= cident ')'
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_unaliasedSelector1456); 
					match(input,171,FOLLOW_171_in_unaliasedSelector1464); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1468);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_unaliasedSelector1470); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:332:10: f= functionName args= selectionFunctionArgs
					{
					pushFollow(FOLLOW_functionName_in_unaliasedSelector1498);
					f=functionName();
					state._fsp--;

					pushFollow(FOLLOW_selectionFunctionArgs_in_unaliasedSelector1502);
					args=selectionFunctionArgs();
					state._fsp--;

					 tmp = new Selectable.WithFunction.Raw(f, args); 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:10: ( '.' fi= cident )*
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( (LA15_0==176) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:333:12: '.' fi= cident
					{
					match(input,176,FOLLOW_176_in_unaliasedSelector1517); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1521);
					fi=cident();
					state._fsp--;

					 tmp = new Selectable.WithFieldSelection.Raw(tmp, fi); 
					}
					break;

				default :
					break loop15;
				}
			}

			 s = tmp; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "unaliasedSelector"



	// $ANTLR start "selectionFunctionArgs"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:1: selectionFunctionArgs returns [List<Selectable.Raw> a] : ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' );
	public final List<Selectable.Raw> selectionFunctionArgs() throws RecognitionException {
		List<Selectable.Raw> a = null;


		Selectable.Raw s1 =null;
		Selectable.Raw sn =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:5: ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==171) ) {
				int LA17_1 = input.LA(2);
				if ( (LA17_1==172) ) {
					alt17=1;
				}
				else if ( (LA17_1==IDENT||(LA17_1 >= K_AGGREGATE && LA17_1 <= K_ALL)||LA17_1==K_AS||LA17_1==K_ASCII||(LA17_1 >= K_BIGINT && LA17_1 <= K_BOOLEAN)||(LA17_1 >= K_CALLED && LA17_1 <= K_CLUSTERING)||(LA17_1 >= K_COMPACT && LA17_1 <= K_COUNTER)||(LA17_1 >= K_CUSTOM && LA17_1 <= K_DECIMAL)||(LA17_1 >= K_DISTINCT && LA17_1 <= K_DOUBLE)||(LA17_1 >= K_EXISTS && LA17_1 <= K_FLOAT)||LA17_1==K_FROZEN||(LA17_1 >= K_FUNCTION && LA17_1 <= K_FUNCTIONS)||LA17_1==K_INET||(LA17_1 >= K_INITCOND && LA17_1 <= K_INPUT)||LA17_1==K_INT||(LA17_1 >= K_JSON && LA17_1 <= K_KEYS)||(LA17_1 >= K_KEYSPACES && LA17_1 <= K_LANGUAGE)||(LA17_1 >= K_LIST && LA17_1 <= K_MAP)||LA17_1==K_NOLOGIN||LA17_1==K_NOSUPERUSER||LA17_1==K_OPTIONS||(LA17_1 >= K_PASSWORD && LA17_1 <= K_PERMISSIONS)||LA17_1==K_RETURNS||(LA17_1 >= K_ROLE && LA17_1 <= K_ROLES)||(LA17_1 >= K_SFUNC && LA17_1 <= K_TINYINT)||(LA17_1 >= K_TOKEN && LA17_1 <= K_TRIGGER)||(LA17_1 >= K_TTL && LA17_1 <= K_TYPE)||(LA17_1 >= K_USER && LA17_1 <= K_USERS)||(LA17_1 >= K_UUID && LA17_1 <= K_VARINT)||LA17_1==K_WRITETIME||(LA17_1 >= QMARK && LA17_1 <= QUOTED_NAME)) ) {
					alt17=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 17, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:7: '(' ')'
					{
					match(input,171,FOLLOW_171_in_selectionFunctionArgs1549); 
					match(input,172,FOLLOW_172_in_selectionFunctionArgs1551); 
					 a = Collections.emptyList(); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:7: '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')'
					{
					match(input,171,FOLLOW_171_in_selectionFunctionArgs1561); 
					pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1565);
					s1=unaliasedSelector();
					state._fsp--;

					 List<Selectable.Raw> args = new ArrayList<Selectable.Raw>(); args.add(s1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:339:11: ( ',' sn= unaliasedSelector )*
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( (LA16_0==174) ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:339:13: ',' sn= unaliasedSelector
							{
							match(input,174,FOLLOW_174_in_selectionFunctionArgs1581); 
							pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1585);
							sn=unaliasedSelector();
							state._fsp--;

							 args.add(sn); 
							}
							break;

						default :
							break loop16;
						}
					}

					match(input,172,FOLLOW_172_in_selectionFunctionArgs1598); 
					 a = args; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return a;
	}
	// $ANTLR end "selectionFunctionArgs"



	// $ANTLR start "selectCountClause"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:1: selectCountClause returns [List<RawSelector> expr] : K_COUNT '(' countArgument ')' ( K_AS c= noncol_ident )? ;
	public final List<RawSelector> selectCountClause() throws RecognitionException {
		List<RawSelector> expr = null;


		ColumnIdentifier c =null;

		 ColumnIdentifier alias = new ColumnIdentifier("count", false); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:345:5: ( K_COUNT '(' countArgument ')' ( K_AS c= noncol_ident )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:345:7: K_COUNT '(' countArgument ')' ( K_AS c= noncol_ident )?
			{
			match(input,K_COUNT,FOLLOW_K_COUNT_in_selectCountClause1629); 
			match(input,171,FOLLOW_171_in_selectCountClause1631); 
			pushFollow(FOLLOW_countArgument_in_selectCountClause1633);
			countArgument();
			state._fsp--;

			match(input,172,FOLLOW_172_in_selectCountClause1635); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:345:37: ( K_AS c= noncol_ident )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==K_AS) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:345:38: K_AS c= noncol_ident
					{
					match(input,K_AS,FOLLOW_K_AS_in_selectCountClause1638); 
					pushFollow(FOLLOW_noncol_ident_in_selectCountClause1642);
					c=noncol_ident();
					state._fsp--;

					 alias = c; 
					}
					break;

			}

			 expr = new ArrayList<RawSelector>(); expr.add( new RawSelector(new Selectable.WithFunction.Raw(FunctionName.nativeFunction("countRows"), Collections.<Selectable.Raw>emptyList()), alias));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectCountClause"



	// $ANTLR start "countArgument"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:348:1: countArgument : ( '\\*' |i= INTEGER );
	public final void countArgument() throws RecognitionException {
		Token i=null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:5: ( '\\*' |i= INTEGER )
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==185) ) {
				alt19=1;
			}
			else if ( (LA19_0==INTEGER) ) {
				alt19=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 19, 0, input);
				throw nvae;
			}

			switch (alt19) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:7: '\\*'
					{
					match(input,185,FOLLOW_185_in_countArgument1665); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:7: i= INTEGER
					{
					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_countArgument1675); 
					 if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "countArgument"



	// $ANTLR start "whereClause"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:353:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
	public final List<Relation> whereClause() throws RecognitionException {
		List<Relation> clause = null;


		 clause = new ArrayList<Relation>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:355:5: ( relation[$clause] ( K_AND relation[$clause] )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:355:7: relation[$clause] ( K_AND relation[$clause] )*
			{
			pushFollow(FOLLOW_relation_in_whereClause1706);
			relation(clause);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:355:25: ( K_AND relation[$clause] )*
			loop20:
			while (true) {
				int alt20=2;
				int LA20_0 = input.LA(1);
				if ( (LA20_0==K_AND) ) {
					alt20=1;
				}

				switch (alt20) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:355:26: K_AND relation[$clause]
					{
					match(input,K_AND,FOLLOW_K_AND_in_whereClause1710); 
					pushFollow(FOLLOW_relation_in_whereClause1712);
					relation(clause);
					state._fsp--;

					}
					break;

				default :
					break loop20;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return clause;
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "orderByClause"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:358:1: orderByClause[Map<ColumnIdentifier.Raw, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
	public final void orderByClause(Map<ColumnIdentifier.Raw, Boolean> orderings) throws RecognitionException {
		ColumnIdentifier.Raw c =null;


		        boolean reversed = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:362:5: (c= cident ( K_ASC | K_DESC )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:362:7: c= cident ( K_ASC | K_DESC )?
			{
			pushFollow(FOLLOW_cident_in_orderByClause1743);
			c=cident();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:362:16: ( K_ASC | K_DESC )?
			int alt21=3;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==K_ASC) ) {
				alt21=1;
			}
			else if ( (LA21_0==K_DESC) ) {
				alt21=2;
			}
			switch (alt21) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:362:17: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1746); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:362:25: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1750); 
					 reversed = true; 
					}
					break;

			}

			 orderings.put(c, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderByClause"



	// $ANTLR start "insertStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:371:1: insertStatement returns [ModificationStatement.Parsed expr] : K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] ) ;
	public final ModificationStatement.Parsed insertStatement() throws RecognitionException {
		ModificationStatement.Parsed expr = null;


		CFName cf =null;
		UpdateStatement.ParsedInsert st1 =null;
		UpdateStatement.ParsedInsertJson st2 =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:372:5: ( K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:372:7: K_INSERT K_INTO cf= columnFamilyName (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] )
			{
			match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1779); 
			match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1781); 
			pushFollow(FOLLOW_columnFamilyName_in_insertStatement1785);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:373:9: (st1= normalInsertStatement[cf] | K_JSON st2= jsonInsertStatement[cf] )
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==171) ) {
				alt22=1;
			}
			else if ( (LA22_0==K_JSON) ) {
				alt22=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 22, 0, input);
				throw nvae;
			}

			switch (alt22) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:373:11: st1= normalInsertStatement[cf]
					{
					pushFollow(FOLLOW_normalInsertStatement_in_insertStatement1799);
					st1=normalInsertStatement(cf);
					state._fsp--;

					 expr = st1; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:374:11: K_JSON st2= jsonInsertStatement[cf]
					{
					match(input,K_JSON,FOLLOW_K_JSON_in_insertStatement1814); 
					pushFollow(FOLLOW_jsonInsertStatement_in_insertStatement1818);
					st2=jsonInsertStatement(cf);
					state._fsp--;

					 expr = st2; 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "insertStatement"



	// $ANTLR start "normalInsertStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:377:1: normalInsertStatement[CFName cf] returns [UpdateStatement.ParsedInsert expr] : '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsert normalInsertStatement(CFName cf) throws RecognitionException {
		UpdateStatement.ParsedInsert expr = null;


		ColumnIdentifier.Raw c1 =null;
		ColumnIdentifier.Raw cn =null;
		Term.Raw v1 =null;
		Term.Raw vn =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<ColumnIdentifier.Raw> columnNames  = new ArrayList<ColumnIdentifier.Raw>();
		        List<Term.Raw> values = new ArrayList<Term.Raw>();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:384:5: ( '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:384:7: '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			match(input,171,FOLLOW_171_in_normalInsertStatement1854); 
			pushFollow(FOLLOW_cident_in_normalInsertStatement1858);
			c1=cident();
			state._fsp--;

			 columnNames.add(c1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:384:47: ( ',' cn= cident )*
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==174) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:384:49: ',' cn= cident
					{
					match(input,174,FOLLOW_174_in_normalInsertStatement1865); 
					pushFollow(FOLLOW_cident_in_normalInsertStatement1869);
					cn=cident();
					state._fsp--;

					 columnNames.add(cn); 
					}
					break;

				default :
					break loop23;
				}
			}

			match(input,172,FOLLOW_172_in_normalInsertStatement1876); 
			match(input,K_VALUES,FOLLOW_K_VALUES_in_normalInsertStatement1884); 
			match(input,171,FOLLOW_171_in_normalInsertStatement1892); 
			pushFollow(FOLLOW_term_in_normalInsertStatement1896);
			v1=term();
			state._fsp--;

			 values.add(v1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:386:39: ( ',' vn= term )*
			loop24:
			while (true) {
				int alt24=2;
				int LA24_0 = input.LA(1);
				if ( (LA24_0==174) ) {
					alt24=1;
				}

				switch (alt24) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:386:41: ',' vn= term
					{
					match(input,174,FOLLOW_174_in_normalInsertStatement1902); 
					pushFollow(FOLLOW_term_in_normalInsertStatement1906);
					vn=term();
					state._fsp--;

					 values.add(vn); 
					}
					break;

				default :
					break loop24;
				}
			}

			match(input,172,FOLLOW_172_in_normalInsertStatement1913); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:387:7: ( K_IF K_NOT K_EXISTS )?
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==K_IF) ) {
				alt25=1;
			}
			switch (alt25) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:387:9: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_normalInsertStatement1923); 
					match(input,K_NOT,FOLLOW_K_NOT_in_normalInsertStatement1925); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_normalInsertStatement1927); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:388:7: ( usingClause[attrs] )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==K_USING) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:388:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_normalInsertStatement1942);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}


			          expr = new UpdateStatement.ParsedInsert(cf, attrs, columnNames, values, ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "normalInsertStatement"



	// $ANTLR start "jsonInsertStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:394:1: jsonInsertStatement[CFName cf] returns [UpdateStatement.ParsedInsertJson expr] : val= jsonValue ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsertJson jsonInsertStatement(CFName cf) throws RecognitionException {
		UpdateStatement.ParsedInsertJson expr = null;


		Json.Raw val =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:399:5: (val= jsonValue ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:399:7: val= jsonValue ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			pushFollow(FOLLOW_jsonValue_in_jsonInsertStatement1988);
			val=jsonValue();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:400:7: ( K_IF K_NOT K_EXISTS )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==K_IF) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:400:9: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_jsonInsertStatement1998); 
					match(input,K_NOT,FOLLOW_K_NOT_in_jsonInsertStatement2000); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_jsonInsertStatement2002); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:401:7: ( usingClause[attrs] )?
			int alt28=2;
			int LA28_0 = input.LA(1);
			if ( (LA28_0==K_USING) ) {
				alt28=1;
			}
			switch (alt28) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:401:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_jsonInsertStatement2017);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}


			          expr = new UpdateStatement.ParsedInsertJson(cf, attrs, val, ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "jsonInsertStatement"



	// $ANTLR start "jsonValue"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:407:1: jsonValue returns [Json.Raw value] : (|s= STRING_LITERAL | ':' id= noncol_ident | QMARK );
	public final Json.Raw jsonValue() throws RecognitionException {
		Json.Raw value = null;


		Token s=null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:408:5: (|s= STRING_LITERAL | ':' id= noncol_ident | QMARK )
			int alt29=4;
			switch ( input.LA(1) ) {
			case EOF:
			case K_APPLY:
			case K_DELETE:
			case K_IF:
			case K_INSERT:
			case K_UPDATE:
			case K_USING:
			case 178:
				{
				alt29=1;
				}
				break;
			case STRING_LITERAL:
				{
				alt29=2;
				}
				break;
			case 177:
				{
				alt29=3;
				}
				break;
			case QMARK:
				{
				alt29=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}
			switch (alt29) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:409:5: 
					{
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:409:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_jsonValue2058); 
					 value = new Json.Literal((s!=null?s.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:410:7: ':' id= noncol_ident
					{
					match(input,177,FOLLOW_177_in_jsonValue2068); 
					pushFollow(FOLLOW_noncol_ident_in_jsonValue2072);
					id=noncol_ident();
					state._fsp--;

					 value = newJsonBindVariables(id); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:411:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_jsonValue2086); 
					 value = newJsonBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "jsonValue"



	// $ANTLR start "usingClause"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:414:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* ;
	public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:5: ( K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:7: K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )*
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClause2117); 
			pushFollow(FOLLOW_usingClauseObjective_in_usingClause2119);
			usingClauseObjective(attrs);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:43: ( K_AND usingClauseObjective[attrs] )*
			loop30:
			while (true) {
				int alt30=2;
				int LA30_0 = input.LA(1);
				if ( (LA30_0==K_AND) ) {
					alt30=1;
				}

				switch (alt30) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:45: K_AND usingClauseObjective[attrs]
					{
					match(input,K_AND,FOLLOW_K_AND_in_usingClause2124); 
					pushFollow(FOLLOW_usingClauseObjective_in_usingClause2126);
					usingClauseObjective(attrs);
					state._fsp--;

					}
					break;

				default :
					break loop30;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "usingClauseObjective"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:418:1: usingClauseObjective[Attributes.Raw attrs] : ( K_TIMESTAMP ts= intValue | K_TTL t= intValue );
	public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:5: ( K_TIMESTAMP ts= intValue | K_TTL t= intValue )
			int alt31=2;
			int LA31_0 = input.LA(1);
			if ( (LA31_0==K_TIMESTAMP) ) {
				alt31=1;
			}
			else if ( (LA31_0==K_TTL) ) {
				alt31=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}

			switch (alt31) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:7: K_TIMESTAMP ts= intValue
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseObjective2148); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective2152);
					ts=intValue();
					state._fsp--;

					 attrs.timestamp = ts; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:420:7: K_TTL t= intValue
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective2162); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective2166);
					t=intValue();
					state._fsp--;

					 attrs.timeToLive = t; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseObjective"



	// $ANTLR start "updateStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:430:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
		UpdateStatement.ParsedUpdate expr = null;


		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>>();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:436:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:436:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement2200); 
			pushFollow(FOLLOW_columnFamilyName_in_updateStatement2204);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:7: ( usingClause[attrs] )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==K_USING) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_updateStatement2214);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_SET,FOLLOW_K_SET_in_updateStatement2226); 
			pushFollow(FOLLOW_columnOperation_in_updateStatement2228);
			columnOperation(operations);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:41: ( ',' columnOperation[operations] )*
			loop33:
			while (true) {
				int alt33=2;
				int LA33_0 = input.LA(1);
				if ( (LA33_0==174) ) {
					alt33=1;
				}

				switch (alt33) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:42: ',' columnOperation[operations]
					{
					match(input,174,FOLLOW_174_in_updateStatement2232); 
					pushFollow(FOLLOW_columnOperation_in_updateStatement2234);
					columnOperation(operations);
					state._fsp--;

					}
					break;

				default :
					break loop33;
				}
			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement2245); 
			pushFollow(FOLLOW_whereClause_in_updateStatement2249);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==K_IF) ) {
				alt35=1;
			}
			switch (alt35) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_updateStatement2259); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:14: ( K_EXISTS |conditions= updateConditions )
					int alt34=2;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==K_EXISTS) ) {
						int LA34_1 = input.LA(2);
						if ( (LA34_1==EOF||LA34_1==K_APPLY||LA34_1==K_DELETE||LA34_1==K_INSERT||LA34_1==K_UPDATE||LA34_1==178) ) {
							alt34=1;
						}
						else if ( (LA34_1==K_IN||LA34_1==170||(LA34_1 >= 179 && LA34_1 <= 184)) ) {
							alt34=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 34, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA34_0==IDENT||(LA34_0 >= K_AGGREGATE && LA34_0 <= K_ALL)||LA34_0==K_AS||LA34_0==K_ASCII||(LA34_0 >= K_BIGINT && LA34_0 <= K_BOOLEAN)||(LA34_0 >= K_CALLED && LA34_0 <= K_CLUSTERING)||(LA34_0 >= K_COMPACT && LA34_0 <= K_COUNTER)||(LA34_0 >= K_CUSTOM && LA34_0 <= K_DECIMAL)||(LA34_0 >= K_DISTINCT && LA34_0 <= K_DOUBLE)||(LA34_0 >= K_FILTERING && LA34_0 <= K_FLOAT)||LA34_0==K_FROZEN||(LA34_0 >= K_FUNCTION && LA34_0 <= K_FUNCTIONS)||LA34_0==K_INET||(LA34_0 >= K_INITCOND && LA34_0 <= K_INPUT)||LA34_0==K_INT||(LA34_0 >= K_JSON && LA34_0 <= K_KEYS)||(LA34_0 >= K_KEYSPACES && LA34_0 <= K_LANGUAGE)||(LA34_0 >= K_LIST && LA34_0 <= K_MAP)||LA34_0==K_NOLOGIN||LA34_0==K_NOSUPERUSER||LA34_0==K_OPTIONS||(LA34_0 >= K_PASSWORD && LA34_0 <= K_PERMISSIONS)||LA34_0==K_RETURNS||(LA34_0 >= K_ROLE && LA34_0 <= K_ROLES)||(LA34_0 >= K_SFUNC && LA34_0 <= K_TINYINT)||LA34_0==K_TRIGGER||(LA34_0 >= K_TTL && LA34_0 <= K_TYPE)||(LA34_0 >= K_USER && LA34_0 <= K_USERS)||(LA34_0 >= K_UUID && LA34_0 <= K_VARINT)||LA34_0==K_WRITETIME||LA34_0==QUOTED_NAME) ) {
						alt34=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 34, 0, input);
						throw nvae;
					}

					switch (alt34) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_updateStatement2263); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:440:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_updateStatement2271);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new UpdateStatement.ParsedUpdate(cf,
			                                                  attrs,
			                                                  operations,
			                                                  wclause,
			                                                  conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                                  ifExists);
			     
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "updateStatement"



	// $ANTLR start "updateConditions"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:451:1: updateConditions returns [List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : columnCondition[conditions] ( K_AND columnCondition[conditions] )* ;
	public final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> updateConditions() throws RecognitionException {
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions = null;


		 conditions = new ArrayList<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:5: ( columnCondition[conditions] ( K_AND columnCondition[conditions] )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:7: columnCondition[conditions] ( K_AND columnCondition[conditions] )*
			{
			pushFollow(FOLLOW_columnCondition_in_updateConditions2313);
			columnCondition(conditions);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:35: ( K_AND columnCondition[conditions] )*
			loop36:
			while (true) {
				int alt36=2;
				int LA36_0 = input.LA(1);
				if ( (LA36_0==K_AND) ) {
					alt36=1;
				}

				switch (alt36) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:453:37: K_AND columnCondition[conditions]
					{
					match(input,K_AND,FOLLOW_K_AND_in_updateConditions2318); 
					pushFollow(FOLLOW_columnCondition_in_updateConditions2320);
					columnCondition(conditions);
					state._fsp--;

					}
					break;

				default :
					break loop36;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return conditions;
	}
	// $ANTLR end "updateConditions"



	// $ANTLR start "deleteStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
		DeleteStatement.Parsed expr = null;


		List<Operation.RawDeletion> dels =null;
		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement2357); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:16: (dels= deleteSelection )?
			int alt37=2;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==IDENT||(LA37_0 >= K_AGGREGATE && LA37_0 <= K_ALL)||LA37_0==K_AS||LA37_0==K_ASCII||(LA37_0 >= K_BIGINT && LA37_0 <= K_BOOLEAN)||(LA37_0 >= K_CALLED && LA37_0 <= K_CLUSTERING)||(LA37_0 >= K_COMPACT && LA37_0 <= K_COUNTER)||(LA37_0 >= K_CUSTOM && LA37_0 <= K_DECIMAL)||(LA37_0 >= K_DISTINCT && LA37_0 <= K_DOUBLE)||(LA37_0 >= K_EXISTS && LA37_0 <= K_FLOAT)||LA37_0==K_FROZEN||(LA37_0 >= K_FUNCTION && LA37_0 <= K_FUNCTIONS)||LA37_0==K_INET||(LA37_0 >= K_INITCOND && LA37_0 <= K_INPUT)||LA37_0==K_INT||(LA37_0 >= K_JSON && LA37_0 <= K_KEYS)||(LA37_0 >= K_KEYSPACES && LA37_0 <= K_LANGUAGE)||(LA37_0 >= K_LIST && LA37_0 <= K_MAP)||LA37_0==K_NOLOGIN||LA37_0==K_NOSUPERUSER||LA37_0==K_OPTIONS||(LA37_0 >= K_PASSWORD && LA37_0 <= K_PERMISSIONS)||LA37_0==K_RETURNS||(LA37_0 >= K_ROLE && LA37_0 <= K_ROLES)||(LA37_0 >= K_SFUNC && LA37_0 <= K_TINYINT)||LA37_0==K_TRIGGER||(LA37_0 >= K_TTL && LA37_0 <= K_TYPE)||(LA37_0 >= K_USER && LA37_0 <= K_USERS)||(LA37_0 >= K_UUID && LA37_0 <= K_VARINT)||LA37_0==K_WRITETIME||LA37_0==QUOTED_NAME) ) {
				alt37=1;
			}
			switch (alt37) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:18: dels= deleteSelection
					{
					pushFollow(FOLLOW_deleteSelection_in_deleteStatement2363);
					dels=deleteSelection();
					state._fsp--;

					 columnDeletions = dels; 
					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement2376); 
			pushFollow(FOLLOW_columnFamilyName_in_deleteStatement2380);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:472:7: ( usingClauseDelete[attrs] )?
			int alt38=2;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==K_USING) ) {
				alt38=1;
			}
			switch (alt38) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:472:9: usingClauseDelete[attrs]
					{
					pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement2390);
					usingClauseDelete(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement2402); 
			pushFollow(FOLLOW_whereClause_in_deleteStatement2406);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==K_IF) ) {
				alt40=1;
			}
			switch (alt40) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_deleteStatement2416); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:14: ( K_EXISTS |conditions= updateConditions )
					int alt39=2;
					int LA39_0 = input.LA(1);
					if ( (LA39_0==K_EXISTS) ) {
						int LA39_1 = input.LA(2);
						if ( (LA39_1==EOF||LA39_1==K_APPLY||LA39_1==K_DELETE||LA39_1==K_INSERT||LA39_1==K_UPDATE||LA39_1==178) ) {
							alt39=1;
						}
						else if ( (LA39_1==K_IN||LA39_1==170||(LA39_1 >= 179 && LA39_1 <= 184)) ) {
							alt39=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 39, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA39_0==IDENT||(LA39_0 >= K_AGGREGATE && LA39_0 <= K_ALL)||LA39_0==K_AS||LA39_0==K_ASCII||(LA39_0 >= K_BIGINT && LA39_0 <= K_BOOLEAN)||(LA39_0 >= K_CALLED && LA39_0 <= K_CLUSTERING)||(LA39_0 >= K_COMPACT && LA39_0 <= K_COUNTER)||(LA39_0 >= K_CUSTOM && LA39_0 <= K_DECIMAL)||(LA39_0 >= K_DISTINCT && LA39_0 <= K_DOUBLE)||(LA39_0 >= K_FILTERING && LA39_0 <= K_FLOAT)||LA39_0==K_FROZEN||(LA39_0 >= K_FUNCTION && LA39_0 <= K_FUNCTIONS)||LA39_0==K_INET||(LA39_0 >= K_INITCOND && LA39_0 <= K_INPUT)||LA39_0==K_INT||(LA39_0 >= K_JSON && LA39_0 <= K_KEYS)||(LA39_0 >= K_KEYSPACES && LA39_0 <= K_LANGUAGE)||(LA39_0 >= K_LIST && LA39_0 <= K_MAP)||LA39_0==K_NOLOGIN||LA39_0==K_NOSUPERUSER||LA39_0==K_OPTIONS||(LA39_0 >= K_PASSWORD && LA39_0 <= K_PERMISSIONS)||LA39_0==K_RETURNS||(LA39_0 >= K_ROLE && LA39_0 <= K_ROLES)||(LA39_0 >= K_SFUNC && LA39_0 <= K_TINYINT)||LA39_0==K_TRIGGER||(LA39_0 >= K_TTL && LA39_0 <= K_TYPE)||(LA39_0 >= K_USER && LA39_0 <= K_USERS)||(LA39_0 >= K_UUID && LA39_0 <= K_VARINT)||LA39_0==K_WRITETIME||LA39_0==QUOTED_NAME) ) {
						alt39=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 39, 0, input);
						throw nvae;
					}

					switch (alt39) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_deleteStatement2420); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_deleteStatement2428);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new DeleteStatement.Parsed(cf,
			                                            attrs,
			                                            columnDeletions,
			                                            wclause,
			                                            conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                            ifExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "deleteStatement"



	// $ANTLR start "deleteSelection"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:485:1: deleteSelection returns [List<Operation.RawDeletion> operations] :t1= deleteOp ( ',' tN= deleteOp )* ;
	public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
		List<Operation.RawDeletion> operations = null;


		Operation.RawDeletion t1 =null;
		Operation.RawDeletion tN =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:5: (t1= deleteOp ( ',' tN= deleteOp )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:7: t1= deleteOp ( ',' tN= deleteOp )*
			{
			 operations = new ArrayList<Operation.RawDeletion>(); 
			pushFollow(FOLLOW_deleteOp_in_deleteSelection2475);
			t1=deleteOp();
			state._fsp--;

			 operations.add(t1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:488:11: ( ',' tN= deleteOp )*
			loop41:
			while (true) {
				int alt41=2;
				int LA41_0 = input.LA(1);
				if ( (LA41_0==174) ) {
					alt41=1;
				}

				switch (alt41) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:488:12: ',' tN= deleteOp
					{
					match(input,174,FOLLOW_174_in_deleteSelection2490); 
					pushFollow(FOLLOW_deleteOp_in_deleteSelection2494);
					tN=deleteOp();
					state._fsp--;

					 operations.add(tN); 
					}
					break;

				default :
					break loop41;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return operations;
	}
	// $ANTLR end "deleteSelection"



	// $ANTLR start "deleteOp"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:491:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' );
	public final Operation.RawDeletion deleteOp() throws RecognitionException {
		Operation.RawDeletion op = null;


		ColumnIdentifier.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:492:5: (c= cident |c= cident '[' t= term ']' )
			int alt42=2;
			alt42 = dfa42.predict(input);
			switch (alt42) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:492:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_deleteOp2521);
					c=cident();
					state._fsp--;

					 op = new Operation.ColumnDeletion(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:493:7: c= cident '[' t= term ']'
					{
					pushFollow(FOLLOW_cident_in_deleteOp2548);
					c=cident();
					state._fsp--;

					match(input,184,FOLLOW_184_in_deleteOp2550); 
					pushFollow(FOLLOW_term_in_deleteOp2554);
					t=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_deleteOp2556); 
					 op = new Operation.ElementDeletion(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "deleteOp"



	// $ANTLR start "usingClauseDelete"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:496:1: usingClauseDelete[Attributes.Raw attrs] : K_USING K_TIMESTAMP ts= intValue ;
	public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:497:5: ( K_USING K_TIMESTAMP ts= intValue )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:497:7: K_USING K_TIMESTAMP ts= intValue
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete2576); 
			match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDelete2578); 
			pushFollow(FOLLOW_intValue_in_usingClauseDelete2582);
			ts=intValue();
			state._fsp--;

			 attrs.timestamp = ts; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseDelete"



	// $ANTLR start "batchStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:524:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
	public final BatchStatement.Parsed batchStatement() throws RecognitionException {
		BatchStatement.Parsed expr = null;


		ModificationStatement.Parsed s =null;


		        BatchStatement.Type type = BatchStatement.Type.LOGGED;
		        List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
		        Attributes.Raw attrs = new Attributes.Raw();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
			{
			match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement2616); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:531:7: ( K_UNLOGGED | K_COUNTER )?
			int alt43=3;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==K_UNLOGGED) ) {
				alt43=1;
			}
			else if ( (LA43_0==K_COUNTER) ) {
				alt43=2;
			}
			switch (alt43) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:531:9: K_UNLOGGED
					{
					match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement2626); 
					 type = BatchStatement.Type.UNLOGGED; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:531:63: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement2632); 
					 type = BatchStatement.Type.COUNTER; 
					}
					break;

			}

			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2645); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:532:15: ( usingClause[attrs] )?
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==K_USING) ) {
				alt44=1;
			}
			switch (alt44) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:532:17: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_batchStatement2649);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:11: (s= batchStatementObjective ( ';' )? )*
			loop46:
			while (true) {
				int alt46=2;
				int LA46_0 = input.LA(1);
				if ( (LA46_0==K_DELETE||LA46_0==K_INSERT||LA46_0==K_UPDATE) ) {
					alt46=1;
				}

				switch (alt46) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:13: s= batchStatementObjective ( ';' )?
					{
					pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2669);
					s=batchStatementObjective();
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:39: ( ';' )?
					int alt45=2;
					int LA45_0 = input.LA(1);
					if ( (LA45_0==178) ) {
						alt45=1;
					}
					switch (alt45) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:39: ';'
							{
							match(input,178,FOLLOW_178_in_batchStatement2671); 
							}
							break;

					}

					 statements.add(s); 
					}
					break;

				default :
					break loop46;
				}
			}

			match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement2685); 
			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2687); 

			          return new BatchStatement.Parsed(type, attrs, statements);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "batchStatement"



	// $ANTLR start "batchStatementObjective"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:540:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement |u= updateStatement |d= deleteStatement );
	public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
		ModificationStatement.Parsed statement = null;


		ModificationStatement.Parsed i =null;
		UpdateStatement.ParsedUpdate u =null;
		DeleteStatement.Parsed d =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:5: (i= insertStatement |u= updateStatement |d= deleteStatement )
			int alt47=3;
			switch ( input.LA(1) ) {
			case K_INSERT:
				{
				alt47=1;
				}
				break;
			case K_UPDATE:
				{
				alt47=2;
				}
				break;
			case K_DELETE:
				{
				alt47=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 47, 0, input);
				throw nvae;
			}
			switch (alt47) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:7: i= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_batchStatementObjective2718);
					i=insertStatement();
					state._fsp--;

					 statement = i; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:542:7: u= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_batchStatementObjective2731);
					u=updateStatement();
					state._fsp--;

					 statement = u; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:543:7: d= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective2744);
					d=deleteStatement();
					state._fsp--;

					 statement = d; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return statement;
	}
	// $ANTLR end "batchStatementObjective"



	// $ANTLR start "createAggregateStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:546:1: createAggregateStatement returns [CreateAggregateStatement expr] : K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= functionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= functionName )? ( K_INITCOND ival= term )? ;
	public final CreateAggregateStatement createAggregateStatement() throws RecognitionException {
		CreateAggregateStatement expr = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;
		FunctionName sfunc =null;
		CQL3Type.Raw stype =null;
		FunctionName ffunc =null;
		Term.Raw ival =null;


		        boolean orReplace = false;
		        boolean ifNotExists = false;

		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:5: ( K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= functionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= functionName )? ( K_INITCOND ival= term )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:7: K_CREATE ( K_OR K_REPLACE )? K_AGGREGATE ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' K_SFUNC sfunc= functionName K_STYPE stype= comparatorType ( K_FINALFUNC ffunc= functionName )? ( K_INITCOND ival= term )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createAggregateStatement2777); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:16: ( K_OR K_REPLACE )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==K_OR) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:553:17: K_OR K_REPLACE
					{
					match(input,K_OR,FOLLOW_K_OR_in_createAggregateStatement2780); 
					match(input,K_REPLACE,FOLLOW_K_REPLACE_in_createAggregateStatement2782); 
					 orReplace = true; 
					}
					break;

			}

			match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_createAggregateStatement2794); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:555:7: ( K_IF K_NOT K_EXISTS )?
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==K_IF) ) {
				alt49=1;
			}
			switch (alt49) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:555:8: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createAggregateStatement2803); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createAggregateStatement2805); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createAggregateStatement2807); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_createAggregateStatement2821);
			fn=functionName();
			state._fsp--;

			match(input,171,FOLLOW_171_in_createAggregateStatement2829); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:558:9: (v= comparatorType ( ',' v= comparatorType )* )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==IDENT||(LA51_0 >= K_AGGREGATE && LA51_0 <= K_ALL)||LA51_0==K_AS||LA51_0==K_ASCII||(LA51_0 >= K_BIGINT && LA51_0 <= K_BOOLEAN)||(LA51_0 >= K_CALLED && LA51_0 <= K_CLUSTERING)||(LA51_0 >= K_COMPACT && LA51_0 <= K_COUNTER)||(LA51_0 >= K_CUSTOM && LA51_0 <= K_DECIMAL)||(LA51_0 >= K_DISTINCT && LA51_0 <= K_DOUBLE)||(LA51_0 >= K_EXISTS && LA51_0 <= K_FLOAT)||LA51_0==K_FROZEN||(LA51_0 >= K_FUNCTION && LA51_0 <= K_FUNCTIONS)||LA51_0==K_INET||(LA51_0 >= K_INITCOND && LA51_0 <= K_INPUT)||LA51_0==K_INT||(LA51_0 >= K_JSON && LA51_0 <= K_KEYS)||(LA51_0 >= K_KEYSPACES && LA51_0 <= K_LANGUAGE)||(LA51_0 >= K_LIST && LA51_0 <= K_MAP)||LA51_0==K_NOLOGIN||LA51_0==K_NOSUPERUSER||LA51_0==K_OPTIONS||(LA51_0 >= K_PASSWORD && LA51_0 <= K_PERMISSIONS)||LA51_0==K_RETURNS||(LA51_0 >= K_ROLE && LA51_0 <= K_ROLES)||(LA51_0 >= K_SET && LA51_0 <= K_TINYINT)||LA51_0==K_TRIGGER||(LA51_0 >= K_TTL && LA51_0 <= K_TYPE)||(LA51_0 >= K_USER && LA51_0 <= K_USERS)||(LA51_0 >= K_UUID && LA51_0 <= K_VARINT)||LA51_0==K_WRITETIME||LA51_0==QUOTED_NAME||LA51_0==STRING_LITERAL) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:559:11: v= comparatorType ( ',' v= comparatorType )*
					{
					pushFollow(FOLLOW_comparatorType_in_createAggregateStatement2853);
					v=comparatorType();
					state._fsp--;

					 argsTypes.add(v); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:11: ( ',' v= comparatorType )*
					loop50:
					while (true) {
						int alt50=2;
						int LA50_0 = input.LA(1);
						if ( (LA50_0==174) ) {
							alt50=1;
						}

						switch (alt50) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:13: ',' v= comparatorType
							{
							match(input,174,FOLLOW_174_in_createAggregateStatement2869); 
							pushFollow(FOLLOW_comparatorType_in_createAggregateStatement2873);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							}
							break;

						default :
							break loop50;
						}
					}

					}
					break;

			}

			match(input,172,FOLLOW_172_in_createAggregateStatement2897); 
			match(input,K_SFUNC,FOLLOW_K_SFUNC_in_createAggregateStatement2905); 
			pushFollow(FOLLOW_functionName_in_createAggregateStatement2911);
			sfunc=functionName();
			state._fsp--;

			match(input,K_STYPE,FOLLOW_K_STYPE_in_createAggregateStatement2919); 
			pushFollow(FOLLOW_comparatorType_in_createAggregateStatement2925);
			stype=comparatorType();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:565:7: ( K_FINALFUNC ffunc= functionName )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==K_FINALFUNC) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:566:9: K_FINALFUNC ffunc= functionName
					{
					match(input,K_FINALFUNC,FOLLOW_K_FINALFUNC_in_createAggregateStatement2943); 
					pushFollow(FOLLOW_functionName_in_createAggregateStatement2949);
					ffunc=functionName();
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:568:7: ( K_INITCOND ival= term )?
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==K_INITCOND) ) {
				alt53=1;
			}
			switch (alt53) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:569:9: K_INITCOND ival= term
					{
					match(input,K_INITCOND,FOLLOW_K_INITCOND_in_createAggregateStatement2976); 
					pushFollow(FOLLOW_term_in_createAggregateStatement2982);
					ival=term();
					state._fsp--;

					}
					break;

			}

			 expr = new CreateAggregateStatement(fn, argsTypes, sfunc, stype, ffunc, ival, orReplace, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createAggregateStatement"



	// $ANTLR start "dropAggregateStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:1: dropAggregateStatement returns [DropAggregateStatement expr] : K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? ;
	public final DropAggregateStatement dropAggregateStatement() throws RecognitionException {
		DropAggregateStatement expr = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        boolean ifExists = false;
		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		        boolean argsPresent = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:5: ( K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:580:7: K_DROP K_AGGREGATE ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropAggregateStatement3029); 
			match(input,K_AGGREGATE,FOLLOW_K_AGGREGATE_in_dropAggregateStatement3031); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:581:7: ( K_IF K_EXISTS )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==K_IF) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:581:8: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropAggregateStatement3040); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropAggregateStatement3042); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_dropAggregateStatement3057);
			fn=functionName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:583:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==171) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:584:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,171,FOLLOW_171_in_dropAggregateStatement3075); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:585:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt56=2;
					int LA56_0 = input.LA(1);
					if ( (LA56_0==IDENT||(LA56_0 >= K_AGGREGATE && LA56_0 <= K_ALL)||LA56_0==K_AS||LA56_0==K_ASCII||(LA56_0 >= K_BIGINT && LA56_0 <= K_BOOLEAN)||(LA56_0 >= K_CALLED && LA56_0 <= K_CLUSTERING)||(LA56_0 >= K_COMPACT && LA56_0 <= K_COUNTER)||(LA56_0 >= K_CUSTOM && LA56_0 <= K_DECIMAL)||(LA56_0 >= K_DISTINCT && LA56_0 <= K_DOUBLE)||(LA56_0 >= K_EXISTS && LA56_0 <= K_FLOAT)||LA56_0==K_FROZEN||(LA56_0 >= K_FUNCTION && LA56_0 <= K_FUNCTIONS)||LA56_0==K_INET||(LA56_0 >= K_INITCOND && LA56_0 <= K_INPUT)||LA56_0==K_INT||(LA56_0 >= K_JSON && LA56_0 <= K_KEYS)||(LA56_0 >= K_KEYSPACES && LA56_0 <= K_LANGUAGE)||(LA56_0 >= K_LIST && LA56_0 <= K_MAP)||LA56_0==K_NOLOGIN||LA56_0==K_NOSUPERUSER||LA56_0==K_OPTIONS||(LA56_0 >= K_PASSWORD && LA56_0 <= K_PERMISSIONS)||LA56_0==K_RETURNS||(LA56_0 >= K_ROLE && LA56_0 <= K_ROLES)||(LA56_0 >= K_SET && LA56_0 <= K_TINYINT)||LA56_0==K_TRIGGER||(LA56_0 >= K_TTL && LA56_0 <= K_TYPE)||(LA56_0 >= K_USER && LA56_0 <= K_USERS)||(LA56_0 >= K_UUID && LA56_0 <= K_VARINT)||LA56_0==K_WRITETIME||LA56_0==QUOTED_NAME||LA56_0==STRING_LITERAL) ) {
						alt56=1;
					}
					switch (alt56) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:586:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_dropAggregateStatement3103);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:587:13: ( ',' v= comparatorType )*
							loop55:
							while (true) {
								int alt55=2;
								int LA55_0 = input.LA(1);
								if ( (LA55_0==174) ) {
									alt55=1;
								}

								switch (alt55) {
								case 1 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:587:15: ',' v= comparatorType
									{
									match(input,174,FOLLOW_174_in_dropAggregateStatement3121); 
									pushFollow(FOLLOW_comparatorType_in_dropAggregateStatement3125);
									v=comparatorType();
									state._fsp--;

									 argsTypes.add(v); 
									}
									break;

								default :
									break loop55;
								}
							}

							}
							break;

					}

					match(input,172,FOLLOW_172_in_dropAggregateStatement3153); 
					 argsPresent = true; 
					}
					break;

			}

			 expr = new DropAggregateStatement(fn, argsTypes, argsPresent, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropAggregateStatement"



	// $ANTLR start "createFunctionStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:1: createFunctionStatement returns [CreateFunctionStatement expr] : K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS rt= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL ;
	public final CreateFunctionStatement createFunctionStatement() throws RecognitionException {
		CreateFunctionStatement expr = null;


		Token language=null;
		Token body=null;
		FunctionName fn =null;
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		CQL3Type.Raw rt =null;


		        boolean orReplace = false;
		        boolean ifNotExists = false;

		        List<ColumnIdentifier> argsNames = new ArrayList<>();
		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		        boolean calledOnNullInput = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:5: ( K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS rt= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:7: K_CREATE ( K_OR K_REPLACE )? K_FUNCTION ( K_IF K_NOT K_EXISTS )? fn= functionName '(' (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )? ')' ( ( K_RETURNS K_NULL ) | ( K_CALLED ) ) K_ON K_NULL K_INPUT K_RETURNS rt= comparatorType K_LANGUAGE language= IDENT K_AS body= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createFunctionStatement3210); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:16: ( K_OR K_REPLACE )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==K_OR) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:604:17: K_OR K_REPLACE
					{
					match(input,K_OR,FOLLOW_K_OR_in_createFunctionStatement3213); 
					match(input,K_REPLACE,FOLLOW_K_REPLACE_in_createFunctionStatement3215); 
					 orReplace = true; 
					}
					break;

			}

			match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_createFunctionStatement3227); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:606:7: ( K_IF K_NOT K_EXISTS )?
			int alt59=2;
			int LA59_0 = input.LA(1);
			if ( (LA59_0==K_IF) ) {
				alt59=1;
			}
			switch (alt59) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:606:8: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createFunctionStatement3236); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createFunctionStatement3238); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createFunctionStatement3240); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_createFunctionStatement3254);
			fn=functionName();
			state._fsp--;

			match(input,171,FOLLOW_171_in_createFunctionStatement3262); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:609:9: (k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )* )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==IDENT||(LA61_0 >= K_AGGREGATE && LA61_0 <= K_ALL)||LA61_0==K_AS||LA61_0==K_ASCII||(LA61_0 >= K_BIGINT && LA61_0 <= K_BOOLEAN)||(LA61_0 >= K_CALLED && LA61_0 <= K_CLUSTERING)||(LA61_0 >= K_COMPACT && LA61_0 <= K_COUNTER)||(LA61_0 >= K_CUSTOM && LA61_0 <= K_DECIMAL)||(LA61_0 >= K_DISTINCT && LA61_0 <= K_DOUBLE)||(LA61_0 >= K_EXISTS && LA61_0 <= K_FLOAT)||LA61_0==K_FROZEN||(LA61_0 >= K_FUNCTION && LA61_0 <= K_FUNCTIONS)||LA61_0==K_INET||(LA61_0 >= K_INITCOND && LA61_0 <= K_INPUT)||LA61_0==K_INT||(LA61_0 >= K_JSON && LA61_0 <= K_KEYS)||(LA61_0 >= K_KEYSPACES && LA61_0 <= K_LANGUAGE)||(LA61_0 >= K_LIST && LA61_0 <= K_MAP)||LA61_0==K_NOLOGIN||LA61_0==K_NOSUPERUSER||LA61_0==K_OPTIONS||(LA61_0 >= K_PASSWORD && LA61_0 <= K_PERMISSIONS)||LA61_0==K_RETURNS||(LA61_0 >= K_ROLE && LA61_0 <= K_ROLES)||(LA61_0 >= K_SFUNC && LA61_0 <= K_TINYINT)||LA61_0==K_TRIGGER||(LA61_0 >= K_TTL && LA61_0 <= K_TYPE)||(LA61_0 >= K_USER && LA61_0 <= K_USERS)||(LA61_0 >= K_UUID && LA61_0 <= K_VARINT)||LA61_0==K_WRITETIME||LA61_0==QUOTED_NAME) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:610:11: k= noncol_ident v= comparatorType ( ',' k= noncol_ident v= comparatorType )*
					{
					pushFollow(FOLLOW_noncol_ident_in_createFunctionStatement3286);
					k=noncol_ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_createFunctionStatement3290);
					v=comparatorType();
					state._fsp--;

					 argsNames.add(k); argsTypes.add(v); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:611:11: ( ',' k= noncol_ident v= comparatorType )*
					loop60:
					while (true) {
						int alt60=2;
						int LA60_0 = input.LA(1);
						if ( (LA60_0==174) ) {
							alt60=1;
						}

						switch (alt60) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:611:13: ',' k= noncol_ident v= comparatorType
							{
							match(input,174,FOLLOW_174_in_createFunctionStatement3306); 
							pushFollow(FOLLOW_noncol_ident_in_createFunctionStatement3310);
							k=noncol_ident();
							state._fsp--;

							pushFollow(FOLLOW_comparatorType_in_createFunctionStatement3314);
							v=comparatorType();
							state._fsp--;

							 argsNames.add(k); argsTypes.add(v); 
							}
							break;

						default :
							break loop60;
						}
					}

					}
					break;

			}

			match(input,172,FOLLOW_172_in_createFunctionStatement3338); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:7: ( ( K_RETURNS K_NULL ) | ( K_CALLED ) )
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==K_RETURNS) ) {
				alt62=1;
			}
			else if ( (LA62_0==K_CALLED) ) {
				alt62=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}

			switch (alt62) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:9: ( K_RETURNS K_NULL )
					{
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:9: ( K_RETURNS K_NULL )
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:10: K_RETURNS K_NULL
					{
					match(input,K_RETURNS,FOLLOW_K_RETURNS_in_createFunctionStatement3349); 
					match(input,K_NULL,FOLLOW_K_NULL_in_createFunctionStatement3351); 
					}

					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:30: ( K_CALLED )
					{
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:30: ( K_CALLED )
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:31: K_CALLED
					{
					match(input,K_CALLED,FOLLOW_K_CALLED_in_createFunctionStatement3357); 
					 calledOnNullInput=true; 
					}

					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createFunctionStatement3363); 
			match(input,K_NULL,FOLLOW_K_NULL_in_createFunctionStatement3365); 
			match(input,K_INPUT,FOLLOW_K_INPUT_in_createFunctionStatement3367); 
			match(input,K_RETURNS,FOLLOW_K_RETURNS_in_createFunctionStatement3375); 
			pushFollow(FOLLOW_comparatorType_in_createFunctionStatement3381);
			rt=comparatorType();
			state._fsp--;

			match(input,K_LANGUAGE,FOLLOW_K_LANGUAGE_in_createFunctionStatement3389); 
			language=(Token)match(input,IDENT,FOLLOW_IDENT_in_createFunctionStatement3395); 
			match(input,K_AS,FOLLOW_K_AS_in_createFunctionStatement3403); 
			body=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createFunctionStatement3409); 
			 expr = new CreateFunctionStatement(fn, (language!=null?language.getText():null).toLowerCase(), (body!=null?body.getText():null),
			                                            argsNames, argsTypes, rt, calledOnNullInput, orReplace, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createFunctionStatement"



	// $ANTLR start "dropFunctionStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:622:1: dropFunctionStatement returns [DropFunctionStatement expr] : K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? ;
	public final DropFunctionStatement dropFunctionStatement() throws RecognitionException {
		DropFunctionStatement expr = null;


		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        boolean ifExists = false;
		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		        boolean argsPresent = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:5: ( K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:628:7: K_DROP K_FUNCTION ( K_IF K_EXISTS )? fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropFunctionStatement3447); 
			match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_dropFunctionStatement3449); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:7: ( K_IF K_EXISTS )?
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==K_IF) ) {
				alt63=1;
			}
			switch (alt63) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:8: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropFunctionStatement3458); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropFunctionStatement3460); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_functionName_in_dropFunctionStatement3475);
			fn=functionName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:631:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )?
			int alt66=2;
			int LA66_0 = input.LA(1);
			if ( (LA66_0==171) ) {
				alt66=1;
			}
			switch (alt66) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:632:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,171,FOLLOW_171_in_dropFunctionStatement3493); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt65=2;
					int LA65_0 = input.LA(1);
					if ( (LA65_0==IDENT||(LA65_0 >= K_AGGREGATE && LA65_0 <= K_ALL)||LA65_0==K_AS||LA65_0==K_ASCII||(LA65_0 >= K_BIGINT && LA65_0 <= K_BOOLEAN)||(LA65_0 >= K_CALLED && LA65_0 <= K_CLUSTERING)||(LA65_0 >= K_COMPACT && LA65_0 <= K_COUNTER)||(LA65_0 >= K_CUSTOM && LA65_0 <= K_DECIMAL)||(LA65_0 >= K_DISTINCT && LA65_0 <= K_DOUBLE)||(LA65_0 >= K_EXISTS && LA65_0 <= K_FLOAT)||LA65_0==K_FROZEN||(LA65_0 >= K_FUNCTION && LA65_0 <= K_FUNCTIONS)||LA65_0==K_INET||(LA65_0 >= K_INITCOND && LA65_0 <= K_INPUT)||LA65_0==K_INT||(LA65_0 >= K_JSON && LA65_0 <= K_KEYS)||(LA65_0 >= K_KEYSPACES && LA65_0 <= K_LANGUAGE)||(LA65_0 >= K_LIST && LA65_0 <= K_MAP)||LA65_0==K_NOLOGIN||LA65_0==K_NOSUPERUSER||LA65_0==K_OPTIONS||(LA65_0 >= K_PASSWORD && LA65_0 <= K_PERMISSIONS)||LA65_0==K_RETURNS||(LA65_0 >= K_ROLE && LA65_0 <= K_ROLES)||(LA65_0 >= K_SET && LA65_0 <= K_TINYINT)||LA65_0==K_TRIGGER||(LA65_0 >= K_TTL && LA65_0 <= K_TYPE)||(LA65_0 >= K_USER && LA65_0 <= K_USERS)||(LA65_0 >= K_UUID && LA65_0 <= K_VARINT)||LA65_0==K_WRITETIME||LA65_0==QUOTED_NAME||LA65_0==STRING_LITERAL) ) {
						alt65=1;
					}
					switch (alt65) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:634:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_dropFunctionStatement3521);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:13: ( ',' v= comparatorType )*
							loop64:
							while (true) {
								int alt64=2;
								int LA64_0 = input.LA(1);
								if ( (LA64_0==174) ) {
									alt64=1;
								}

								switch (alt64) {
								case 1 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:15: ',' v= comparatorType
									{
									match(input,174,FOLLOW_174_in_dropFunctionStatement3539); 
									pushFollow(FOLLOW_comparatorType_in_dropFunctionStatement3543);
									v=comparatorType();
									state._fsp--;

									 argsTypes.add(v); 
									}
									break;

								default :
									break loop64;
								}
							}

							}
							break;

					}

					match(input,172,FOLLOW_172_in_dropFunctionStatement3571); 
					 argsPresent = true; 
					}
					break;

			}

			 expr = new DropFunctionStatement(fn, argsTypes, argsPresent, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropFunctionStatement"



	// $ANTLR start "createKeyspaceStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
	public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
		CreateKeyspaceStatement expr = null;


		String ks =null;


		        KeyspaceAttributes attrs = new KeyspaceAttributes();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:651:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:651:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement3630); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement3632); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:651:27: ( K_IF K_NOT K_EXISTS )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==K_IF) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:651:28: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement3635); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement3637); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement3639); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement3648);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement3656); 
			pushFollow(FOLLOW_properties_in_createKeyspaceStatement3658);
			properties(attrs);
			state._fsp--;

			 expr = new CreateKeyspaceStatement(ks, attrs, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createKeyspaceStatement"



	// $ANTLR start "createTableStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:662:1: createTableStatement returns [CreateTableStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] ;
	public final CreateTableStatement.RawStatement createTableStatement() throws RecognitionException {
		CreateTableStatement.RawStatement expr = null;


		CFName cf =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement3693); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement3695); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:31: ( K_IF K_NOT K_EXISTS )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==K_IF) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:32: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTableStatement3698); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement3700); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement3702); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createTableStatement3717);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new CreateTableStatement.RawStatement(cf, ifNotExists); 
			pushFollow(FOLLOW_cfamDefinition_in_createTableStatement3727);
			cfamDefinition(expr);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTableStatement"



	// $ANTLR start "cfamDefinition"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:669:1: cfamDefinition[CreateTableStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? ;
	public final void cfamDefinition(CreateTableStatement.RawStatement expr) throws RecognitionException {
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			{
			match(input,171,FOLLOW_171_in_cfamDefinition3746); 
			pushFollow(FOLLOW_cfamColumns_in_cfamDefinition3748);
			cfamColumns(expr);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:29: ( ',' ( cfamColumns[expr] )? )*
			loop70:
			while (true) {
				int alt70=2;
				int LA70_0 = input.LA(1);
				if ( (LA70_0==174) ) {
					alt70=1;
				}

				switch (alt70) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:31: ',' ( cfamColumns[expr] )?
					{
					match(input,174,FOLLOW_174_in_cfamDefinition3753); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:35: ( cfamColumns[expr] )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==IDENT||(LA69_0 >= K_AGGREGATE && LA69_0 <= K_ALL)||LA69_0==K_AS||LA69_0==K_ASCII||(LA69_0 >= K_BIGINT && LA69_0 <= K_BOOLEAN)||(LA69_0 >= K_CALLED && LA69_0 <= K_CLUSTERING)||(LA69_0 >= K_COMPACT && LA69_0 <= K_COUNTER)||(LA69_0 >= K_CUSTOM && LA69_0 <= K_DECIMAL)||(LA69_0 >= K_DISTINCT && LA69_0 <= K_DOUBLE)||(LA69_0 >= K_EXISTS && LA69_0 <= K_FLOAT)||LA69_0==K_FROZEN||(LA69_0 >= K_FUNCTION && LA69_0 <= K_FUNCTIONS)||LA69_0==K_INET||(LA69_0 >= K_INITCOND && LA69_0 <= K_INPUT)||LA69_0==K_INT||(LA69_0 >= K_JSON && LA69_0 <= K_KEYS)||(LA69_0 >= K_KEYSPACES && LA69_0 <= K_LANGUAGE)||(LA69_0 >= K_LIST && LA69_0 <= K_MAP)||LA69_0==K_NOLOGIN||LA69_0==K_NOSUPERUSER||LA69_0==K_OPTIONS||(LA69_0 >= K_PASSWORD && LA69_0 <= K_PRIMARY)||LA69_0==K_RETURNS||(LA69_0 >= K_ROLE && LA69_0 <= K_ROLES)||(LA69_0 >= K_SFUNC && LA69_0 <= K_TINYINT)||LA69_0==K_TRIGGER||(LA69_0 >= K_TTL && LA69_0 <= K_TYPE)||(LA69_0 >= K_USER && LA69_0 <= K_USERS)||(LA69_0 >= K_UUID && LA69_0 <= K_VARINT)||LA69_0==K_WRITETIME||LA69_0==QUOTED_NAME) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:35: cfamColumns[expr]
							{
							pushFollow(FOLLOW_cfamColumns_in_cfamDefinition3755);
							cfamColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop70;
				}
			}

			match(input,172,FOLLOW_172_in_cfamDefinition3762); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:7: ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==K_WITH) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:9: K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition3772); 
					pushFollow(FOLLOW_cfamProperty_in_cfamDefinition3774);
					cfamProperty(expr.properties);
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:46: ( K_AND cfamProperty[expr.properties] )*
					loop71:
					while (true) {
						int alt71=2;
						int LA71_0 = input.LA(1);
						if ( (LA71_0==K_AND) ) {
							alt71=1;
						}

						switch (alt71) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:671:48: K_AND cfamProperty[expr.properties]
							{
							match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition3779); 
							pushFollow(FOLLOW_cfamProperty_in_cfamDefinition3781);
							cfamProperty(expr.properties);
							state._fsp--;

							}
							break;

						default :
							break loop71;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamDefinition"



	// $ANTLR start "cfamColumns"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:674:1: cfamColumns[CreateTableStatement.RawStatement expr] : (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' );
	public final void cfamColumns(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier c =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:675:5: (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' )
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==IDENT||(LA76_0 >= K_AGGREGATE && LA76_0 <= K_ALL)||LA76_0==K_AS||LA76_0==K_ASCII||(LA76_0 >= K_BIGINT && LA76_0 <= K_BOOLEAN)||(LA76_0 >= K_CALLED && LA76_0 <= K_CLUSTERING)||(LA76_0 >= K_COMPACT && LA76_0 <= K_COUNTER)||(LA76_0 >= K_CUSTOM && LA76_0 <= K_DECIMAL)||(LA76_0 >= K_DISTINCT && LA76_0 <= K_DOUBLE)||(LA76_0 >= K_EXISTS && LA76_0 <= K_FLOAT)||LA76_0==K_FROZEN||(LA76_0 >= K_FUNCTION && LA76_0 <= K_FUNCTIONS)||LA76_0==K_INET||(LA76_0 >= K_INITCOND && LA76_0 <= K_INPUT)||LA76_0==K_INT||(LA76_0 >= K_JSON && LA76_0 <= K_KEYS)||(LA76_0 >= K_KEYSPACES && LA76_0 <= K_LANGUAGE)||(LA76_0 >= K_LIST && LA76_0 <= K_MAP)||LA76_0==K_NOLOGIN||LA76_0==K_NOSUPERUSER||LA76_0==K_OPTIONS||(LA76_0 >= K_PASSWORD && LA76_0 <= K_PERMISSIONS)||LA76_0==K_RETURNS||(LA76_0 >= K_ROLE && LA76_0 <= K_ROLES)||(LA76_0 >= K_SFUNC && LA76_0 <= K_TINYINT)||LA76_0==K_TRIGGER||(LA76_0 >= K_TTL && LA76_0 <= K_TYPE)||(LA76_0 >= K_USER && LA76_0 <= K_USERS)||(LA76_0 >= K_UUID && LA76_0 <= K_VARINT)||LA76_0==K_WRITETIME||LA76_0==QUOTED_NAME) ) {
				alt76=1;
			}
			else if ( (LA76_0==K_PRIMARY) ) {
				alt76=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 76, 0, input);
				throw nvae;
			}

			switch (alt76) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:675:7: k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )?
					{
					pushFollow(FOLLOW_ident_in_cfamColumns3807);
					k=ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_cfamColumns3811);
					v=comparatorType();
					state._fsp--;

					 boolean isStatic=false; 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:675:60: ( K_STATIC )?
					int alt73=2;
					int LA73_0 = input.LA(1);
					if ( (LA73_0==K_STATIC) ) {
						alt73=1;
					}
					switch (alt73) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:675:61: K_STATIC
							{
							match(input,K_STATIC,FOLLOW_K_STATIC_in_cfamColumns3816); 
							isStatic = true;
							}
							break;

					}

					 expr.addDefinition(k, v, isStatic); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:676:9: ( K_PRIMARY K_KEY )?
					int alt74=2;
					int LA74_0 = input.LA(1);
					if ( (LA74_0==K_PRIMARY) ) {
						alt74=1;
					}
					switch (alt74) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:676:10: K_PRIMARY K_KEY
							{
							match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns3833); 
							match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns3835); 
							 expr.addKeyAliases(Collections.singletonList(k)); 
							}
							break;

					}

					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:677:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')'
					{
					match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns3847); 
					match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns3849); 
					match(input,171,FOLLOW_171_in_cfamColumns3851); 
					pushFollow(FOLLOW_pkDef_in_cfamColumns3853);
					pkDef(expr);
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:677:39: ( ',' c= ident )*
					loop75:
					while (true) {
						int alt75=2;
						int LA75_0 = input.LA(1);
						if ( (LA75_0==174) ) {
							alt75=1;
						}

						switch (alt75) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:677:40: ',' c= ident
							{
							match(input,174,FOLLOW_174_in_cfamColumns3857); 
							pushFollow(FOLLOW_ident_in_cfamColumns3861);
							c=ident();
							state._fsp--;

							 expr.addColumnAlias(c); 
							}
							break;

						default :
							break loop75;
						}
					}

					match(input,172,FOLLOW_172_in_cfamColumns3868); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamColumns"



	// $ANTLR start "pkDef"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:680:1: pkDef[CreateTableStatement.RawStatement expr] : (k= ident | '(' k1= ident ( ',' kn= ident )* ')' );
	public final void pkDef(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		ColumnIdentifier k1 =null;
		ColumnIdentifier kn =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:5: (k= ident | '(' k1= ident ( ',' kn= ident )* ')' )
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==IDENT||(LA78_0 >= K_AGGREGATE && LA78_0 <= K_ALL)||LA78_0==K_AS||LA78_0==K_ASCII||(LA78_0 >= K_BIGINT && LA78_0 <= K_BOOLEAN)||(LA78_0 >= K_CALLED && LA78_0 <= K_CLUSTERING)||(LA78_0 >= K_COMPACT && LA78_0 <= K_COUNTER)||(LA78_0 >= K_CUSTOM && LA78_0 <= K_DECIMAL)||(LA78_0 >= K_DISTINCT && LA78_0 <= K_DOUBLE)||(LA78_0 >= K_EXISTS && LA78_0 <= K_FLOAT)||LA78_0==K_FROZEN||(LA78_0 >= K_FUNCTION && LA78_0 <= K_FUNCTIONS)||LA78_0==K_INET||(LA78_0 >= K_INITCOND && LA78_0 <= K_INPUT)||LA78_0==K_INT||(LA78_0 >= K_JSON && LA78_0 <= K_KEYS)||(LA78_0 >= K_KEYSPACES && LA78_0 <= K_LANGUAGE)||(LA78_0 >= K_LIST && LA78_0 <= K_MAP)||LA78_0==K_NOLOGIN||LA78_0==K_NOSUPERUSER||LA78_0==K_OPTIONS||(LA78_0 >= K_PASSWORD && LA78_0 <= K_PERMISSIONS)||LA78_0==K_RETURNS||(LA78_0 >= K_ROLE && LA78_0 <= K_ROLES)||(LA78_0 >= K_SFUNC && LA78_0 <= K_TINYINT)||LA78_0==K_TRIGGER||(LA78_0 >= K_TTL && LA78_0 <= K_TYPE)||(LA78_0 >= K_USER && LA78_0 <= K_USERS)||(LA78_0 >= K_UUID && LA78_0 <= K_VARINT)||LA78_0==K_WRITETIME||LA78_0==QUOTED_NAME) ) {
				alt78=1;
			}
			else if ( (LA78_0==171) ) {
				alt78=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 78, 0, input);
				throw nvae;
			}

			switch (alt78) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:681:7: k= ident
					{
					pushFollow(FOLLOW_ident_in_pkDef3888);
					k=ident();
					state._fsp--;

					 expr.addKeyAliases(Collections.singletonList(k)); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:7: '(' k1= ident ( ',' kn= ident )* ')'
					{
					match(input,171,FOLLOW_171_in_pkDef3898); 
					 List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
					pushFollow(FOLLOW_ident_in_pkDef3904);
					k1=ident();
					state._fsp--;

					 l.add(k1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:101: ( ',' kn= ident )*
					loop77:
					while (true) {
						int alt77=2;
						int LA77_0 = input.LA(1);
						if ( (LA77_0==174) ) {
							alt77=1;
						}

						switch (alt77) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:103: ',' kn= ident
							{
							match(input,174,FOLLOW_174_in_pkDef3910); 
							pushFollow(FOLLOW_ident_in_pkDef3914);
							kn=ident();
							state._fsp--;

							 l.add(kn); 
							}
							break;

						default :
							break loop77;
						}
					}

					match(input,172,FOLLOW_172_in_pkDef3921); 
					 expr.addKeyAliases(l); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pkDef"



	// $ANTLR start "cfamProperty"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:685:1: cfamProperty[CFProperties props] : ( property[props.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[props] ( ',' cfamOrdering[props] )* ')' );
	public final void cfamProperty(CFProperties props) throws RecognitionException {
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:5: ( property[props.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[props] ( ',' cfamOrdering[props] )* ')' )
			int alt80=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt80=1;
				}
				break;
			case K_COMPACT:
				{
				int LA80_2 = input.LA(2);
				if ( (LA80_2==K_STORAGE) ) {
					alt80=2;
				}
				else if ( (LA80_2==181) ) {
					alt80=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 80, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_CLUSTERING:
				{
				int LA80_3 = input.LA(2);
				if ( (LA80_3==K_ORDER) ) {
					alt80=3;
				}
				else if ( (LA80_3==181) ) {
					alt80=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 80, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 80, 0, input);
				throw nvae;
			}
			switch (alt80) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:7: property[props.properties]
					{
					pushFollow(FOLLOW_property_in_cfamProperty3941);
					property(props.properties);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:687:7: K_COMPACT K_STORAGE
					{
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty3950); 
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty3952); 
					 props.setCompactStorage(); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[props] ( ',' cfamOrdering[props] )* ')'
					{
					match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty3962); 
					match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty3964); 
					match(input,K_BY,FOLLOW_K_BY_in_cfamProperty3966); 
					match(input,171,FOLLOW_171_in_cfamProperty3968); 
					pushFollow(FOLLOW_cfamOrdering_in_cfamProperty3970);
					cfamOrdering(props);
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:57: ( ',' cfamOrdering[props] )*
					loop79:
					while (true) {
						int alt79=2;
						int LA79_0 = input.LA(1);
						if ( (LA79_0==174) ) {
							alt79=1;
						}

						switch (alt79) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:688:58: ',' cfamOrdering[props]
							{
							match(input,174,FOLLOW_174_in_cfamProperty3974); 
							pushFollow(FOLLOW_cfamOrdering_in_cfamProperty3976);
							cfamOrdering(props);
							state._fsp--;

							}
							break;

						default :
							break loop79;
						}
					}

					match(input,172,FOLLOW_172_in_cfamProperty3981); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamProperty"



	// $ANTLR start "cfamOrdering"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:691:1: cfamOrdering[CFProperties props] : k= ident ( K_ASC | K_DESC ) ;
	public final void cfamOrdering(CFProperties props) throws RecognitionException {
		ColumnIdentifier k =null;

		 boolean reversed=false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:5: (k= ident ( K_ASC | K_DESC ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:7: k= ident ( K_ASC | K_DESC )
			{
			pushFollow(FOLLOW_ident_in_cfamOrdering4009);
			k=ident();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:15: ( K_ASC | K_DESC )
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==K_ASC) ) {
				alt81=1;
			}
			else if ( (LA81_0==K_DESC) ) {
				alt81=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}

			switch (alt81) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:16: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering4012); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:24: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering4016); 
					 reversed=true;
					}
					break;

			}

			 props.setOrdering(k, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamOrdering"



	// $ANTLR start "createTypeStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:704:1: createTypeStatement returns [CreateTypeStatement expr] : K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' ;
	public final CreateTypeStatement createTypeStatement() throws RecognitionException {
		CreateTypeStatement expr = null;


		UTName tn =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:5: ( K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:7: K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')'
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTypeStatement4055); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_createTypeStatement4057); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:23: ( K_IF K_NOT K_EXISTS )?
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==K_IF) ) {
				alt82=1;
			}
			switch (alt82) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTypeStatement4060); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTypeStatement4062); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTypeStatement4064); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_createTypeStatement4082);
			tn=userTypeName();
			state._fsp--;

			 expr = new CreateTypeStatement(tn, ifNotExists); 
			match(input,171,FOLLOW_171_in_createTypeStatement4095); 
			pushFollow(FOLLOW_typeColumns_in_createTypeStatement4097);
			typeColumns(expr);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:708:32: ( ',' ( typeColumns[expr] )? )*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==174) ) {
					alt84=1;
				}

				switch (alt84) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:708:34: ',' ( typeColumns[expr] )?
					{
					match(input,174,FOLLOW_174_in_createTypeStatement4102); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:708:38: ( typeColumns[expr] )?
					int alt83=2;
					int LA83_0 = input.LA(1);
					if ( (LA83_0==IDENT||(LA83_0 >= K_AGGREGATE && LA83_0 <= K_ALL)||LA83_0==K_AS||LA83_0==K_ASCII||(LA83_0 >= K_BIGINT && LA83_0 <= K_BOOLEAN)||(LA83_0 >= K_CALLED && LA83_0 <= K_CLUSTERING)||(LA83_0 >= K_COMPACT && LA83_0 <= K_COUNTER)||(LA83_0 >= K_CUSTOM && LA83_0 <= K_DECIMAL)||(LA83_0 >= K_DISTINCT && LA83_0 <= K_DOUBLE)||(LA83_0 >= K_EXISTS && LA83_0 <= K_FLOAT)||LA83_0==K_FROZEN||(LA83_0 >= K_FUNCTION && LA83_0 <= K_FUNCTIONS)||LA83_0==K_INET||(LA83_0 >= K_INITCOND && LA83_0 <= K_INPUT)||LA83_0==K_INT||(LA83_0 >= K_JSON && LA83_0 <= K_KEYS)||(LA83_0 >= K_KEYSPACES && LA83_0 <= K_LANGUAGE)||(LA83_0 >= K_LIST && LA83_0 <= K_MAP)||LA83_0==K_NOLOGIN||LA83_0==K_NOSUPERUSER||LA83_0==K_OPTIONS||(LA83_0 >= K_PASSWORD && LA83_0 <= K_PERMISSIONS)||LA83_0==K_RETURNS||(LA83_0 >= K_ROLE && LA83_0 <= K_ROLES)||(LA83_0 >= K_SFUNC && LA83_0 <= K_TINYINT)||LA83_0==K_TRIGGER||(LA83_0 >= K_TTL && LA83_0 <= K_TYPE)||(LA83_0 >= K_USER && LA83_0 <= K_USERS)||(LA83_0 >= K_UUID && LA83_0 <= K_VARINT)||LA83_0==K_WRITETIME||LA83_0==QUOTED_NAME) ) {
						alt83=1;
					}
					switch (alt83) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:708:38: typeColumns[expr]
							{
							pushFollow(FOLLOW_typeColumns_in_createTypeStatement4104);
							typeColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop84;
				}
			}

			match(input,172,FOLLOW_172_in_createTypeStatement4111); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTypeStatement"



	// $ANTLR start "typeColumns"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:711:1: typeColumns[CreateTypeStatement expr] : k= noncol_ident v= comparatorType ;
	public final void typeColumns(CreateTypeStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:712:5: (k= noncol_ident v= comparatorType )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:712:7: k= noncol_ident v= comparatorType
			{
			pushFollow(FOLLOW_noncol_ident_in_typeColumns4131);
			k=noncol_ident();
			state._fsp--;

			pushFollow(FOLLOW_comparatorType_in_typeColumns4135);
			v=comparatorType();
			state._fsp--;

			 expr.addDefinition(k, v); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "typeColumns"



	// $ANTLR start "createIndexStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:720:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? ;
	public final CreateIndexStatement createIndexStatement() throws RecognitionException {
		CreateIndexStatement expr = null;


		Token cls=null;
		CFName cf =null;
		IndexTarget.Raw id =null;


		        IndexPropDefs props = new IndexPropDefs();
		        boolean ifNotExists = false;
		        IndexName name = new IndexName();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement4170); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:16: ( K_CUSTOM )?
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==K_CUSTOM) ) {
				alt85=1;
			}
			switch (alt85) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:17: K_CUSTOM
					{
					match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement4173); 
					 props.isCustom = true; 
					}
					break;

			}

			match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement4179); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:63: ( K_IF K_NOT K_EXISTS )?
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==K_IF) ) {
				alt86=1;
			}
			switch (alt86) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:64: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement4182); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement4184); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement4186); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:727:9: ( idxName[name] )?
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==IDENT||(LA87_0 >= K_AGGREGATE && LA87_0 <= K_ALL)||LA87_0==K_AS||LA87_0==K_ASCII||(LA87_0 >= K_BIGINT && LA87_0 <= K_BOOLEAN)||(LA87_0 >= K_CALLED && LA87_0 <= K_CLUSTERING)||(LA87_0 >= K_COMPACT && LA87_0 <= K_COUNTER)||(LA87_0 >= K_CUSTOM && LA87_0 <= K_DECIMAL)||(LA87_0 >= K_DISTINCT && LA87_0 <= K_DOUBLE)||(LA87_0 >= K_EXISTS && LA87_0 <= K_FLOAT)||LA87_0==K_FROZEN||(LA87_0 >= K_FUNCTION && LA87_0 <= K_FUNCTIONS)||LA87_0==K_INET||(LA87_0 >= K_INITCOND && LA87_0 <= K_INPUT)||LA87_0==K_INT||(LA87_0 >= K_JSON && LA87_0 <= K_KEYS)||(LA87_0 >= K_KEYSPACES && LA87_0 <= K_LANGUAGE)||(LA87_0 >= K_LIST && LA87_0 <= K_MAP)||LA87_0==K_NOLOGIN||LA87_0==K_NOSUPERUSER||LA87_0==K_OPTIONS||(LA87_0 >= K_PASSWORD && LA87_0 <= K_PERMISSIONS)||LA87_0==K_RETURNS||(LA87_0 >= K_ROLE && LA87_0 <= K_ROLES)||(LA87_0 >= K_SFUNC && LA87_0 <= K_TINYINT)||LA87_0==K_TRIGGER||(LA87_0 >= K_TTL && LA87_0 <= K_TYPE)||(LA87_0 >= K_USER && LA87_0 <= K_USERS)||(LA87_0 >= K_UUID && LA87_0 <= K_VARINT)||LA87_0==K_WRITETIME||(LA87_0 >= QMARK && LA87_0 <= QUOTED_NAME)) ) {
				alt87=1;
			}
			switch (alt87) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:727:10: idxName[name]
					{
					pushFollow(FOLLOW_idxName_in_createIndexStatement4202);
					idxName(name);
					state._fsp--;

					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement4207); 
			pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement4211);
			cf=columnFamilyName();
			state._fsp--;

			match(input,171,FOLLOW_171_in_createIndexStatement4213); 
			pushFollow(FOLLOW_indexIdent_in_createIndexStatement4217);
			id=indexIdent();
			state._fsp--;

			match(input,172,FOLLOW_172_in_createIndexStatement4219); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:728:9: ( K_USING cls= STRING_LITERAL )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==K_USING) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:728:10: K_USING cls= STRING_LITERAL
					{
					match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement4230); 
					cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement4234); 
					 props.customClass = (cls!=null?cls.getText():null); 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:729:9: ( K_WITH properties[props] )?
			int alt89=2;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==K_WITH) ) {
				alt89=1;
			}
			switch (alt89) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:729:10: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement4249); 
					pushFollow(FOLLOW_properties_in_createIndexStatement4251);
					properties(props);
					state._fsp--;

					}
					break;

			}

			 expr = new CreateIndexStatement(cf, name, id, props, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createIndexStatement"



	// $ANTLR start "indexIdent"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:733:1: indexIdent returns [IndexTarget.Raw id] : (c= cident | K_KEYS '(' c= cident ')' | K_ENTRIES '(' c= cident ')' | K_FULL '(' c= cident ')' );
	public final IndexTarget.Raw indexIdent() throws RecognitionException {
		IndexTarget.Raw id = null;


		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:734:5: (c= cident | K_KEYS '(' c= cident ')' | K_ENTRIES '(' c= cident ')' | K_FULL '(' c= cident ')' )
			int alt90=4;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt90=1;
				}
				break;
			case K_KEYS:
				{
				int LA90_2 = input.LA(2);
				if ( (LA90_2==171) ) {
					alt90=2;
				}
				else if ( (LA90_2==172) ) {
					alt90=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 90, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ENTRIES:
				{
				alt90=3;
				}
				break;
			case K_FULL:
				{
				alt90=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 90, 0, input);
				throw nvae;
			}
			switch (alt90) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:734:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_indexIdent4285);
					c=cident();
					state._fsp--;

					 id = IndexTarget.Raw.valuesOf(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:735:7: K_KEYS '(' c= cident ')'
					{
					match(input,K_KEYS,FOLLOW_K_KEYS_in_indexIdent4313); 
					match(input,171,FOLLOW_171_in_indexIdent4315); 
					pushFollow(FOLLOW_cident_in_indexIdent4319);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_indexIdent4321); 
					 id = IndexTarget.Raw.keysOf(c); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:7: K_ENTRIES '(' c= cident ')'
					{
					match(input,K_ENTRIES,FOLLOW_K_ENTRIES_in_indexIdent4334); 
					match(input,171,FOLLOW_171_in_indexIdent4336); 
					pushFollow(FOLLOW_cident_in_indexIdent4340);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_indexIdent4342); 
					 id = IndexTarget.Raw.keysAndValuesOf(c); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:737:7: K_FULL '(' c= cident ')'
					{
					match(input,K_FULL,FOLLOW_K_FULL_in_indexIdent4352); 
					match(input,171,FOLLOW_171_in_indexIdent4354); 
					pushFollow(FOLLOW_cident_in_indexIdent4358);
					c=cident();
					state._fsp--;

					match(input,172,FOLLOW_172_in_indexIdent4360); 
					 id = IndexTarget.Raw.fullCollection(c); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "indexIdent"



	// $ANTLR start "createMaterializedViewStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:748:1: createMaterializedViewStatement returns [CreateMaterializedViewStatement expr] : K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectClause K_FROM basecf= columnFamilyName ( K_WHERE wclause= mvWhereClause )? K_PRIMARY K_KEY ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' ) ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? ;
	public final CreateMaterializedViewStatement createMaterializedViewStatement() throws RecognitionException {
		CreateMaterializedViewStatement expr = null;


		CFName cf =null;
		List<RawSelector> sclause =null;
		CFName basecf =null;
		List<ColumnIdentifier.Raw> wclause =null;
		ColumnIdentifier.Raw k1 =null;
		ColumnIdentifier.Raw kn =null;
		ColumnIdentifier.Raw c1 =null;
		ColumnIdentifier.Raw cn =null;


		        boolean ifNotExists = false;
		        List<ColumnIdentifier.Raw> partitionKeys = new ArrayList<>();
		        List<ColumnIdentifier.Raw> compositeKeys = new ArrayList<>();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:5: ( K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectClause K_FROM basecf= columnFamilyName ( K_WHERE wclause= mvWhereClause )? K_PRIMARY K_KEY ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' ) ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:7: K_CREATE K_MATERIALIZED K_VIEW ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName K_AS K_SELECT sclause= selectClause K_FROM basecf= columnFamilyName ( K_WHERE wclause= mvWhereClause )? K_PRIMARY K_KEY ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' ) ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createMaterializedViewStatement4397); 
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_createMaterializedViewStatement4399); 
			match(input,K_VIEW,FOLLOW_K_VIEW_in_createMaterializedViewStatement4401); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:38: ( K_IF K_NOT K_EXISTS )?
			int alt91=2;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==K_IF) ) {
				alt91=1;
			}
			switch (alt91) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:39: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createMaterializedViewStatement4404); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createMaterializedViewStatement4406); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createMaterializedViewStatement4408); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createMaterializedViewStatement4416);
			cf=columnFamilyName();
			state._fsp--;

			match(input,K_AS,FOLLOW_K_AS_in_createMaterializedViewStatement4418); 
			match(input,K_SELECT,FOLLOW_K_SELECT_in_createMaterializedViewStatement4428); 
			pushFollow(FOLLOW_selectClause_in_createMaterializedViewStatement4432);
			sclause=selectClause();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_createMaterializedViewStatement4434); 
			pushFollow(FOLLOW_columnFamilyName_in_createMaterializedViewStatement4438);
			basecf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:756:9: ( K_WHERE wclause= mvWhereClause )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==K_WHERE) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:756:10: K_WHERE wclause= mvWhereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_createMaterializedViewStatement4449); 
					pushFollow(FOLLOW_mvWhereClause_in_createMaterializedViewStatement4453);
					wclause=mvWhereClause();
					state._fsp--;

					}
					break;

			}

			match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_createMaterializedViewStatement4465); 
			match(input,K_KEY,FOLLOW_K_KEY_in_createMaterializedViewStatement4467); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:757:25: ( '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')' | '(' k1= cident ( ',' cn= cident )* ')' )
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==171) ) {
				int LA96_1 = input.LA(2);
				if ( (LA96_1==171) ) {
					alt96=1;
				}
				else if ( (LA96_1==IDENT||(LA96_1 >= K_AGGREGATE && LA96_1 <= K_ALL)||LA96_1==K_AS||LA96_1==K_ASCII||(LA96_1 >= K_BIGINT && LA96_1 <= K_BOOLEAN)||(LA96_1 >= K_CALLED && LA96_1 <= K_CLUSTERING)||(LA96_1 >= K_COMPACT && LA96_1 <= K_COUNTER)||(LA96_1 >= K_CUSTOM && LA96_1 <= K_DECIMAL)||(LA96_1 >= K_DISTINCT && LA96_1 <= K_DOUBLE)||(LA96_1 >= K_EXISTS && LA96_1 <= K_FLOAT)||LA96_1==K_FROZEN||(LA96_1 >= K_FUNCTION && LA96_1 <= K_FUNCTIONS)||LA96_1==K_INET||(LA96_1 >= K_INITCOND && LA96_1 <= K_INPUT)||LA96_1==K_INT||(LA96_1 >= K_JSON && LA96_1 <= K_KEYS)||(LA96_1 >= K_KEYSPACES && LA96_1 <= K_LANGUAGE)||(LA96_1 >= K_LIST && LA96_1 <= K_MAP)||LA96_1==K_NOLOGIN||LA96_1==K_NOSUPERUSER||LA96_1==K_OPTIONS||(LA96_1 >= K_PASSWORD && LA96_1 <= K_PERMISSIONS)||LA96_1==K_RETURNS||(LA96_1 >= K_ROLE && LA96_1 <= K_ROLES)||(LA96_1 >= K_SFUNC && LA96_1 <= K_TINYINT)||LA96_1==K_TRIGGER||(LA96_1 >= K_TTL && LA96_1 <= K_TYPE)||(LA96_1 >= K_USER && LA96_1 <= K_USERS)||(LA96_1 >= K_UUID && LA96_1 <= K_VARINT)||LA96_1==K_WRITETIME||LA96_1==QUOTED_NAME) ) {
					alt96=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 96, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 96, 0, input);
				throw nvae;
			}

			switch (alt96) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:758:9: '(' '(' k1= cident ( ',' kn= cident )* ')' ( ',' c1= cident )* ')'
					{
					match(input,171,FOLLOW_171_in_createMaterializedViewStatement4479); 
					match(input,171,FOLLOW_171_in_createMaterializedViewStatement4481); 
					pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4485);
					k1=cident();
					state._fsp--;

					 partitionKeys.add(k1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:758:54: ( ',' kn= cident )*
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==174) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:758:56: ',' kn= cident
							{
							match(input,174,FOLLOW_174_in_createMaterializedViewStatement4491); 
							pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4495);
							kn=cident();
							state._fsp--;

							 partitionKeys.add(kn); 
							}
							break;

						default :
							break loop93;
						}
					}

					match(input,172,FOLLOW_172_in_createMaterializedViewStatement4502); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:758:104: ( ',' c1= cident )*
					loop94:
					while (true) {
						int alt94=2;
						int LA94_0 = input.LA(1);
						if ( (LA94_0==174) ) {
							alt94=1;
						}

						switch (alt94) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:758:106: ',' c1= cident
							{
							match(input,174,FOLLOW_174_in_createMaterializedViewStatement4506); 
							pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4510);
							c1=cident();
							state._fsp--;

							 compositeKeys.add(c1); 
							}
							break;

						default :
							break loop94;
						}
					}

					match(input,172,FOLLOW_172_in_createMaterializedViewStatement4517); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:9: '(' k1= cident ( ',' cn= cident )* ')'
					{
					match(input,171,FOLLOW_171_in_createMaterializedViewStatement4527); 
					pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4531);
					k1=cident();
					state._fsp--;

					 partitionKeys.add(k1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:50: ( ',' cn= cident )*
					loop95:
					while (true) {
						int alt95=2;
						int LA95_0 = input.LA(1);
						if ( (LA95_0==174) ) {
							alt95=1;
						}

						switch (alt95) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:52: ',' cn= cident
							{
							match(input,174,FOLLOW_174_in_createMaterializedViewStatement4537); 
							pushFollow(FOLLOW_cident_in_createMaterializedViewStatement4541);
							cn=cident();
							state._fsp--;

							 compositeKeys.add(cn); 
							}
							break;

						default :
							break loop95;
						}
					}

					match(input,172,FOLLOW_172_in_createMaterializedViewStatement4548); 
					}
					break;

			}

			 expr = new CreateMaterializedViewStatement(cf, basecf, sclause, wclause, partitionKeys, compositeKeys, ifNotExists); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:9: ( K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )* )?
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==K_WITH) ) {
				alt98=1;
			}
			switch (alt98) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:11: K_WITH cfamProperty[expr.properties] ( K_AND cfamProperty[expr.properties] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createMaterializedViewStatement4580); 
					pushFollow(FOLLOW_cfamProperty_in_createMaterializedViewStatement4582);
					cfamProperty(expr.properties);
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:48: ( K_AND cfamProperty[expr.properties] )*
					loop97:
					while (true) {
						int alt97=2;
						int LA97_0 = input.LA(1);
						if ( (LA97_0==K_AND) ) {
							alt97=1;
						}

						switch (alt97) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:50: K_AND cfamProperty[expr.properties]
							{
							match(input,K_AND,FOLLOW_K_AND_in_createMaterializedViewStatement4587); 
							pushFollow(FOLLOW_cfamProperty_in_createMaterializedViewStatement4589);
							cfamProperty(expr.properties);
							state._fsp--;

							}
							break;

						default :
							break loop97;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createMaterializedViewStatement"



	// $ANTLR start "mvWhereClause"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:765:1: mvWhereClause returns [List<ColumnIdentifier.Raw> expr] : t1= cident K_IS K_NOT K_NULL ( K_AND tN= cident K_IS K_NOT K_NULL )* ;
	public final List<ColumnIdentifier.Raw> mvWhereClause() throws RecognitionException {
		List<ColumnIdentifier.Raw> expr = null;


		ColumnIdentifier.Raw t1 =null;
		ColumnIdentifier.Raw tN =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:766:5: (t1= cident K_IS K_NOT K_NULL ( K_AND tN= cident K_IS K_NOT K_NULL )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:766:7: t1= cident K_IS K_NOT K_NULL ( K_AND tN= cident K_IS K_NOT K_NULL )*
			{
			pushFollow(FOLLOW_cident_in_mvWhereClause4618);
			t1=cident();
			state._fsp--;

			 expr = new ArrayList<ColumnIdentifier.Raw>(); expr.add(t1); 
			match(input,K_IS,FOLLOW_K_IS_in_mvWhereClause4622); 
			match(input,K_NOT,FOLLOW_K_NOT_in_mvWhereClause4624); 
			match(input,K_NULL,FOLLOW_K_NULL_in_mvWhereClause4626); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:766:101: ( K_AND tN= cident K_IS K_NOT K_NULL )*
			loop99:
			while (true) {
				int alt99=2;
				int LA99_0 = input.LA(1);
				if ( (LA99_0==K_AND) ) {
					alt99=1;
				}

				switch (alt99) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:766:102: K_AND tN= cident K_IS K_NOT K_NULL
					{
					match(input,K_AND,FOLLOW_K_AND_in_mvWhereClause4629); 
					pushFollow(FOLLOW_cident_in_mvWhereClause4633);
					tN=cident();
					state._fsp--;

					 expr.add(tN); 
					match(input,K_IS,FOLLOW_K_IS_in_mvWhereClause4637); 
					match(input,K_NOT,FOLLOW_K_NOT_in_mvWhereClause4639); 
					match(input,K_NULL,FOLLOW_K_NULL_in_mvWhereClause4641); 
					}
					break;

				default :
					break loop99;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "mvWhereClause"



	// $ANTLR start "createTriggerStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:772:1: createTriggerStatement returns [CreateTriggerStatement expr] : K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL ;
	public final CreateTriggerStatement createTriggerStatement() throws RecognitionException {
		CreateTriggerStatement expr = null;


		Token cls=null;
		ColumnIdentifier.Raw name =null;
		CFName cf =null;


		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:5: ( K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:7: K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement4675); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement4677); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:26: ( K_IF K_NOT K_EXISTS )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==K_IF) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:27: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTriggerStatement4680); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTriggerStatement4682); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTriggerStatement4684); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:74: (name= cident )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:75: name= cident
			{
			pushFollow(FOLLOW_cident_in_createTriggerStatement4694);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement4705); 
			pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement4709);
			cf=columnFamilyName();
			state._fsp--;

			match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement4711); 
			cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement4715); 
			 expr = new CreateTriggerStatement(cf, name.toString(), (cls!=null?cls.getText():null), ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTriggerStatement"



	// $ANTLR start "dropTriggerStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:1: dropTriggerStatement returns [DropTriggerStatement expr] : K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName ;
	public final DropTriggerStatement dropTriggerStatement() throws RecognitionException {
		DropTriggerStatement expr = null;


		ColumnIdentifier.Raw name =null;
		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:5: ( K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:7: K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement4756); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement4758); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:24: ( K_IF K_EXISTS )?
			int alt101=2;
			int LA101_0 = input.LA(1);
			if ( (LA101_0==K_IF) ) {
				alt101=1;
			}
			switch (alt101) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:25: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTriggerStatement4761); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTriggerStatement4763); 
					 ifExists = true; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:63: (name= cident )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:64: name= cident
			{
			pushFollow(FOLLOW_cident_in_dropTriggerStatement4773);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement4776); 
			pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement4780);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new DropTriggerStatement(cf, name.toString(), ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropTriggerStatement"



	// $ANTLR start "alterKeyspaceStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
	public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
		AlterKeyspaceStatement expr = null;


		String ks =null;

		 KeyspaceAttributes attrs = new KeyspaceAttributes(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:795:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement4820); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement4822); 
			pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement4826);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement4836); 
			pushFollow(FOLLOW_properties_in_alterKeyspaceStatement4838);
			properties(attrs);
			state._fsp--;

			 expr = new AlterKeyspaceStatement(ks, attrs); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterKeyspaceStatement"



	// $ANTLR start "alterTableStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:807:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
	public final AlterTableStatement alterTableStatement() throws RecognitionException {
		AlterTableStatement expr = null;


		CFName cf =null;
		ColumnIdentifier.Raw id =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier.Raw id1 =null;
		ColumnIdentifier.Raw toId1 =null;
		ColumnIdentifier.Raw idn =null;
		ColumnIdentifier.Raw toIdn =null;


		        AlterTableStatement.Type type = null;
		        CFPropDefs props = new CFPropDefs();
		        Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames = new HashMap<ColumnIdentifier.Raw, ColumnIdentifier.Raw>();
		        boolean isStatic = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:814:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:814:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement4874); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement4876); 
			pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement4880);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:815:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			int alt104=5;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt104=1;
				}
				break;
			case K_ADD:
				{
				alt104=2;
				}
				break;
			case K_DROP:
				{
				alt104=3;
				}
				break;
			case K_WITH:
				{
				alt104=4;
				}
				break;
			case K_RENAME:
				{
				alt104=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}
			switch (alt104) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:815:13: K_ALTER id= cident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement4894); 
					pushFollow(FOLLOW_cident_in_alterTableStatement4898);
					id=cident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement4900); 
					pushFollow(FOLLOW_comparatorType_in_alterTableStatement4904);
					v=comparatorType();
					state._fsp--;

					 type = AlterTableStatement.Type.ALTER; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:816:13: K_ADD id= cident v= comparatorType ( K_STATIC )?
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement4920); 
					pushFollow(FOLLOW_cident_in_alterTableStatement4926);
					id=cident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTableStatement4930);
					v=comparatorType();
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:816:48: ( K_STATIC )?
					int alt102=2;
					int LA102_0 = input.LA(1);
					if ( (LA102_0==K_STATIC) ) {
						alt102=1;
					}
					switch (alt102) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:816:49: K_STATIC
							{
							 isStatic=true; 
							match(input,K_STATIC,FOLLOW_K_STATIC_in_alterTableStatement4935); 
							}
							break;

					}

					 type = AlterTableStatement.Type.ADD; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:817:13: K_DROP id= cident
					{
					match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement4953); 
					pushFollow(FOLLOW_cident_in_alterTableStatement4958);
					id=cident();
					state._fsp--;

					 type = AlterTableStatement.Type.DROP; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:818:13: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement4998); 
					pushFollow(FOLLOW_properties_in_alterTableStatement5001);
					properties(props);
					state._fsp--;

					 type = AlterTableStatement.Type.OPTS; 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:819:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement5034); 
					 type = AlterTableStatement.Type.RENAME; 
					pushFollow(FOLLOW_cident_in_alterTableStatement5088);
					id1=cident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement5090); 
					pushFollow(FOLLOW_cident_in_alterTableStatement5094);
					toId1=cident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:821:16: ( K_AND idn= cident K_TO toIdn= cident )*
					loop103:
					while (true) {
						int alt103=2;
						int LA103_0 = input.LA(1);
						if ( (LA103_0==K_AND) ) {
							alt103=1;
						}

						switch (alt103) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:821:18: K_AND idn= cident K_TO toIdn= cident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement5115); 
							pushFollow(FOLLOW_cident_in_alterTableStatement5119);
							idn=cident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement5121); 
							pushFollow(FOLLOW_cident_in_alterTableStatement5125);
							toIdn=cident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop103;
						}
					}

					}
					break;

			}


			        expr = new AlterTableStatement(cf, type, id, v, props, renames, isStatic);
			    
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTableStatement"



	// $ANTLR start "alterMaterializedViewStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:828:1: alterMaterializedViewStatement returns [AlterMaterializedViewStatement expr] : K_ALTER K_MATERIALIZED K_VIEW name= columnFamilyName K_WITH properties[props] ;
	public final AlterMaterializedViewStatement alterMaterializedViewStatement() throws RecognitionException {
		AlterMaterializedViewStatement expr = null;


		CFName name =null;


		        CFPropDefs props = new CFPropDefs();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:5: ( K_ALTER K_MATERIALIZED K_VIEW name= columnFamilyName K_WITH properties[props] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:7: K_ALTER K_MATERIALIZED K_VIEW name= columnFamilyName K_WITH properties[props]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterMaterializedViewStatement5178); 
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_alterMaterializedViewStatement5180); 
			match(input,K_VIEW,FOLLOW_K_VIEW_in_alterMaterializedViewStatement5182); 
			pushFollow(FOLLOW_columnFamilyName_in_alterMaterializedViewStatement5186);
			name=columnFamilyName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_alterMaterializedViewStatement5198); 
			pushFollow(FOLLOW_properties_in_alterMaterializedViewStatement5200);
			properties(props);
			state._fsp--;


			        expr = new AlterMaterializedViewStatement(name, props);
			    
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterMaterializedViewStatement"



	// $ANTLR start "alterTypeStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:845:1: alterTypeStatement returns [AlterTypeStatement expr] : K_ALTER K_TYPE name= userTypeName ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* ) ;
	public final AlterTypeStatement alterTypeStatement() throws RecognitionException {
		AlterTypeStatement expr = null;


		UTName name =null;
		ColumnIdentifier f =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier id1 =null;
		ColumnIdentifier toId1 =null;
		ColumnIdentifier idn =null;
		ColumnIdentifier toIdn =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:846:5: ( K_ALTER K_TYPE name= userTypeName ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:846:7: K_ALTER K_TYPE name= userTypeName ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement5235); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement5237); 
			pushFollow(FOLLOW_userTypeName_in_alterTypeStatement5241);
			name=userTypeName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:11: ( K_ALTER f= noncol_ident K_TYPE v= comparatorType | K_ADD f= noncol_ident v= comparatorType | K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )* )
			int alt106=3;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt106=1;
				}
				break;
			case K_ADD:
				{
				alt106=2;
				}
				break;
			case K_RENAME:
				{
				alt106=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 106, 0, input);
				throw nvae;
			}
			switch (alt106) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:13: K_ALTER f= noncol_ident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement5255); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5259);
					f=noncol_ident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement5261); 
					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement5265);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.alter(name, f, v); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:848:13: K_ADD f= noncol_ident v= comparatorType
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTypeStatement5281); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5287);
					f=noncol_ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement5291);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.addition(name, f, v); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:13: K_RENAME id1= noncol_ident K_TO toId1= noncol_ident ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTypeStatement5314); 
					 Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>(); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5352);
					id1=noncol_ident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement5354); 
					pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5358);
					toId1=noncol_ident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:852:18: ( K_AND idn= noncol_ident K_TO toIdn= noncol_ident )*
					loop105:
					while (true) {
						int alt105=2;
						int LA105_0 = input.LA(1);
						if ( (LA105_0==K_AND) ) {
							alt105=1;
						}

						switch (alt105) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:852:20: K_AND idn= noncol_ident K_TO toIdn= noncol_ident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTypeStatement5381); 
							pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5385);
							idn=noncol_ident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement5387); 
							pushFollow(FOLLOW_noncol_ident_in_alterTypeStatement5391);
							toIdn=noncol_ident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop105;
						}
					}

					 expr = AlterTypeStatement.renames(name, renames); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTypeStatement"



	// $ANTLR start "dropKeyspaceStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:861:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
	public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
		DropKeyspaceStatement ksp = null;


		String ks =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement5458); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement5460); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:25: ( K_IF K_EXISTS )?
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==K_IF) ) {
				alt107=1;
			}
			switch (alt107) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:26: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement5463); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement5465); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement5474);
			ks=keyspaceName();
			state._fsp--;

			 ksp = new DropKeyspaceStatement(ks, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ksp;
	}
	// $ANTLR end "dropKeyspaceStatement"



	// $ANTLR start "dropTableStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:869:1: dropTableStatement returns [DropTableStatement stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropTableStatement dropTableStatement() throws RecognitionException {
		DropTableStatement stmt = null;


		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:871:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:871:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement5508); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement5510); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:871:29: ( K_IF K_EXISTS )?
			int alt108=2;
			int LA108_0 = input.LA(1);
			if ( (LA108_0==K_IF) ) {
				alt108=1;
			}
			switch (alt108) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:871:30: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement5513); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement5515); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement5524);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new DropTableStatement(cf, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTableStatement"



	// $ANTLR start "dropTypeStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:877:1: dropTypeStatement returns [DropTypeStatement stmt] : K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName ;
	public final DropTypeStatement dropTypeStatement() throws RecognitionException {
		DropTypeStatement stmt = null;


		UTName name =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:5: ( K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:7: K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTypeStatement5558); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_dropTypeStatement5560); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:21: ( K_IF K_EXISTS )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==K_IF) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTypeStatement5563); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTypeStatement5565); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_dropTypeStatement5574);
			name=userTypeName();
			state._fsp--;

			 stmt = new DropTypeStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTypeStatement"



	// $ANTLR start "dropIndexStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:885:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName ;
	public final DropIndexStatement dropIndexStatement() throws RecognitionException {
		DropIndexStatement expr = null;


		IndexName index =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement5608); 
			match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement5610); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:22: ( K_IF K_EXISTS )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==K_IF) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement5613); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement5615); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_indexName_in_dropIndexStatement5624);
			index=indexName();
			state._fsp--;

			 expr = new DropIndexStatement(index, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropIndexStatement"



	// $ANTLR start "dropMaterializedViewStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:894:1: dropMaterializedViewStatement returns [DropMaterializedViewStatement expr] : K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropMaterializedViewStatement dropMaterializedViewStatement() throws RecognitionException {
		DropMaterializedViewStatement expr = null;


		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:896:5: ( K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:896:7: K_DROP K_MATERIALIZED K_VIEW ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropMaterializedViewStatement5664); 
			match(input,K_MATERIALIZED,FOLLOW_K_MATERIALIZED_in_dropMaterializedViewStatement5666); 
			match(input,K_VIEW,FOLLOW_K_VIEW_in_dropMaterializedViewStatement5668); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:896:36: ( K_IF K_EXISTS )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==K_IF) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:896:37: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropMaterializedViewStatement5671); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropMaterializedViewStatement5673); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropMaterializedViewStatement5682);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new DropMaterializedViewStatement(cf, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropMaterializedViewStatement"



	// $ANTLR start "truncateStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:903:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
	public final TruncateStatement truncateStatement() throws RecognitionException {
		TruncateStatement stmt = null;


		CFName cf =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:5: ( K_TRUNCATE cf= columnFamilyName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:7: K_TRUNCATE cf= columnFamilyName
			{
			match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement5713); 
			pushFollow(FOLLOW_columnFamilyName_in_truncateStatement5717);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new TruncateStatement(cf); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "truncateStatement"



	// $ANTLR start "grantPermissionsStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:910:1: grantPermissionsStatement returns [GrantPermissionsStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName ;
	public final GrantPermissionsStatement grantPermissionsStatement() throws RecognitionException {
		GrantPermissionsStatement stmt = null;


		RoleName grantee =null;
		Set<Permission> permissionOrAll1 =null;
		IResource resource2 =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:911:5: ( K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:911:7: K_GRANT permissionOrAll K_ON resource K_TO grantee= userOrRoleName
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantPermissionsStatement5742); 
			pushFollow(FOLLOW_permissionOrAll_in_grantPermissionsStatement5754);
			permissionOrAll1=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_grantPermissionsStatement5762); 
			pushFollow(FOLLOW_resource_in_grantPermissionsStatement5774);
			resource2=resource();
			state._fsp--;

			match(input,K_TO,FOLLOW_K_TO_in_grantPermissionsStatement5782); 
			pushFollow(FOLLOW_userOrRoleName_in_grantPermissionsStatement5796);
			grantee=userOrRoleName();
			state._fsp--;

			 stmt = new GrantPermissionsStatement(filterPermissions(permissionOrAll1, resource2), resource2, grantee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantPermissionsStatement"



	// $ANTLR start "revokePermissionsStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:923:1: revokePermissionsStatement returns [RevokePermissionsStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName ;
	public final RevokePermissionsStatement revokePermissionsStatement() throws RecognitionException {
		RevokePermissionsStatement stmt = null;


		RoleName revokee =null;
		Set<Permission> permissionOrAll3 =null;
		IResource resource4 =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:924:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:924:7: K_REVOKE permissionOrAll K_ON resource K_FROM revokee= userOrRoleName
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokePermissionsStatement5827); 
			pushFollow(FOLLOW_permissionOrAll_in_revokePermissionsStatement5839);
			permissionOrAll3=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_revokePermissionsStatement5847); 
			pushFollow(FOLLOW_resource_in_revokePermissionsStatement5859);
			resource4=resource();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_revokePermissionsStatement5867); 
			pushFollow(FOLLOW_userOrRoleName_in_revokePermissionsStatement5881);
			revokee=userOrRoleName();
			state._fsp--;

			 stmt = new RevokePermissionsStatement(filterPermissions(permissionOrAll3, resource4), resource4, revokee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokePermissionsStatement"



	// $ANTLR start "grantRoleStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:936:1: grantRoleStatement returns [GrantRoleStatement stmt] : K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName ;
	public final GrantRoleStatement grantRoleStatement() throws RecognitionException {
		GrantRoleStatement stmt = null;


		RoleName role =null;
		RoleName grantee =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:5: ( K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:7: K_GRANT role= userOrRoleName K_TO grantee= userOrRoleName
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantRoleStatement5912); 
			pushFollow(FOLLOW_userOrRoleName_in_grantRoleStatement5926);
			role=userOrRoleName();
			state._fsp--;

			match(input,K_TO,FOLLOW_K_TO_in_grantRoleStatement5934); 
			pushFollow(FOLLOW_userOrRoleName_in_grantRoleStatement5948);
			grantee=userOrRoleName();
			state._fsp--;

			 stmt = new GrantRoleStatement(role, grantee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantRoleStatement"



	// $ANTLR start "revokeRoleStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:947:1: revokeRoleStatement returns [RevokeRoleStatement stmt] : K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName ;
	public final RevokeRoleStatement revokeRoleStatement() throws RecognitionException {
		RevokeRoleStatement stmt = null;


		RoleName role =null;
		RoleName revokee =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:948:5: ( K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:948:7: K_REVOKE role= userOrRoleName K_FROM revokee= userOrRoleName
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeRoleStatement5979); 
			pushFollow(FOLLOW_userOrRoleName_in_revokeRoleStatement5993);
			role=userOrRoleName();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_revokeRoleStatement6001); 
			pushFollow(FOLLOW_userOrRoleName_in_revokeRoleStatement6015);
			revokee=userOrRoleName();
			state._fsp--;

			 stmt = new RevokeRoleStatement(role, revokee); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokeRoleStatement"



	// $ANTLR start "listPermissionsStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:955:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? ;
	public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
		ListPermissionsStatement stmt = null;


		IResource resource5 =null;
		Set<Permission> permissionOrAll6 =null;


		        IResource resource = null;
		        boolean recursive = true;
		        RoleName grantee = new RoleName();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:961:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:961:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF roleName[grantee] )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement6053); 
			pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement6065);
			permissionOrAll6=permissionOrAll();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:963:7: ( K_ON resource )?
			int alt112=2;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==K_ON) ) {
				alt112=1;
			}
			switch (alt112) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:963:9: K_ON resource
					{
					match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement6075); 
					pushFollow(FOLLOW_resource_in_listPermissionsStatement6077);
					resource5=resource();
					state._fsp--;

					 resource = resource5; 
					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:964:7: ( K_OF roleName[grantee] )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==K_OF) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:964:9: K_OF roleName[grantee]
					{
					match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement6092); 
					pushFollow(FOLLOW_roleName_in_listPermissionsStatement6094);
					roleName(grantee);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:965:7: ( K_NORECURSIVE )?
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==K_NORECURSIVE) ) {
				alt114=1;
			}
			switch (alt114) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:965:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement6108); 
					 recursive = false; 
					}
					break;

			}

			 stmt = new ListPermissionsStatement(permissionOrAll6, resource, grantee, recursive); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listPermissionsStatement"



	// $ANTLR start "permission"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:969:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE ) ;
	public final Permission permission() throws RecognitionException {
		Permission perm = null;


		Token p=null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE | K_DESCRIBE | K_EXECUTE )
			{
			p=input.LT(1);
			if ( input.LA(1)==K_ALTER||input.LA(1)==K_AUTHORIZE||input.LA(1)==K_CREATE||input.LA(1)==K_DESCRIBE||input.LA(1)==K_DROP||input.LA(1)==K_EXECUTE||input.LA(1)==K_MODIFY||input.LA(1)==K_SELECT ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perm;
	}
	// $ANTLR end "permission"



	// $ANTLR start "permissionOrAll"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:974:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? );
	public final Set<Permission> permissionOrAll() throws RecognitionException {
		Set<Permission> perms = null;


		Permission p =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:975:5: ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? )
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==K_ALL) ) {
				alt117=1;
			}
			else if ( (LA117_0==K_ALTER||LA117_0==K_AUTHORIZE||LA117_0==K_CREATE||LA117_0==K_DESCRIBE||LA117_0==K_DROP||LA117_0==K_EXECUTE||LA117_0==K_MODIFY||LA117_0==K_SELECT) ) {
				alt117=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 117, 0, input);
				throw nvae;
			}

			switch (alt117) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:975:7: K_ALL ( K_PERMISSIONS )?
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll6201); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:975:13: ( K_PERMISSIONS )?
					int alt115=2;
					int LA115_0 = input.LA(1);
					if ( (LA115_0==K_PERMISSIONS) ) {
						alt115=1;
					}
					switch (alt115) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:975:15: K_PERMISSIONS
							{
							match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll6205); 
							}
							break;

					}

					 perms = Permission.ALL; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:976:7: p= permission ( K_PERMISSION )?
					{
					pushFollow(FOLLOW_permission_in_permissionOrAll6226);
					p=permission();
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:976:20: ( K_PERMISSION )?
					int alt116=2;
					int LA116_0 = input.LA(1);
					if ( (LA116_0==K_PERMISSION) ) {
						alt116=1;
					}
					switch (alt116) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:976:22: K_PERMISSION
							{
							match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll6230); 
							}
							break;

					}

					 perms = EnumSet.of(p); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perms;
	}
	// $ANTLR end "permissionOrAll"



	// $ANTLR start "resource"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:979:1: resource returns [IResource res] : (d= dataResource |r= roleResource |f= functionResource );
	public final IResource resource() throws RecognitionException {
		IResource res = null;


		DataResource d =null;
		RoleResource r =null;
		FunctionResource f =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:980:5: (d= dataResource |r= roleResource |f= functionResource )
			int alt118=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				switch ( input.LA(2) ) {
				case EOF:
				case K_FROM:
				case K_KEYSPACES:
				case K_NORECURSIVE:
				case K_OF:
				case K_TO:
				case 176:
				case 178:
					{
					alt118=1;
					}
					break;
				case K_ROLES:
					{
					alt118=2;
					}
					break;
				case K_FUNCTIONS:
					{
					alt118=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
			case K_AGGREGATE:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACE:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QMARK:
			case QUOTED_NAME:
				{
				alt118=1;
				}
				break;
			case K_ROLE:
				{
				int LA118_3 = input.LA(2);
				if ( (LA118_3==EOF||LA118_3==K_FROM||LA118_3==K_NORECURSIVE||LA118_3==K_OF||LA118_3==K_TO||LA118_3==176||LA118_3==178) ) {
					alt118=1;
				}
				else if ( (LA118_3==IDENT||(LA118_3 >= K_AGGREGATE && LA118_3 <= K_ALL)||LA118_3==K_AS||LA118_3==K_ASCII||(LA118_3 >= K_BIGINT && LA118_3 <= K_BOOLEAN)||(LA118_3 >= K_CALLED && LA118_3 <= K_CLUSTERING)||(LA118_3 >= K_COMPACT && LA118_3 <= K_COUNTER)||(LA118_3 >= K_CUSTOM && LA118_3 <= K_DECIMAL)||(LA118_3 >= K_DISTINCT && LA118_3 <= K_DOUBLE)||(LA118_3 >= K_EXISTS && LA118_3 <= K_FLOAT)||LA118_3==K_FROZEN||(LA118_3 >= K_FUNCTION && LA118_3 <= K_FUNCTIONS)||LA118_3==K_INET||(LA118_3 >= K_INITCOND && LA118_3 <= K_INPUT)||LA118_3==K_INT||(LA118_3 >= K_JSON && LA118_3 <= K_KEYS)||(LA118_3 >= K_KEYSPACES && LA118_3 <= K_LANGUAGE)||(LA118_3 >= K_LIST && LA118_3 <= K_MAP)||LA118_3==K_NOLOGIN||LA118_3==K_NOSUPERUSER||LA118_3==K_OPTIONS||(LA118_3 >= K_PASSWORD && LA118_3 <= K_PERMISSIONS)||LA118_3==K_RETURNS||(LA118_3 >= K_ROLE && LA118_3 <= K_ROLES)||(LA118_3 >= K_SFUNC && LA118_3 <= K_TINYINT)||LA118_3==K_TRIGGER||(LA118_3 >= K_TTL && LA118_3 <= K_TYPE)||(LA118_3 >= K_USER && LA118_3 <= K_USERS)||(LA118_3 >= K_UUID && LA118_3 <= K_VARINT)||LA118_3==K_WRITETIME||(LA118_3 >= QMARK && LA118_3 <= QUOTED_NAME)) ) {
					alt118=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FUNCTION:
				{
				int LA118_4 = input.LA(2);
				if ( (LA118_4==EOF||LA118_4==K_FROM||LA118_4==K_NORECURSIVE||LA118_4==K_OF||LA118_4==K_TO||LA118_4==176||LA118_4==178) ) {
					alt118=1;
				}
				else if ( (LA118_4==IDENT||(LA118_4 >= K_AGGREGATE && LA118_4 <= K_ALL)||LA118_4==K_AS||LA118_4==K_ASCII||(LA118_4 >= K_BIGINT && LA118_4 <= K_BOOLEAN)||(LA118_4 >= K_CALLED && LA118_4 <= K_CLUSTERING)||(LA118_4 >= K_COMPACT && LA118_4 <= K_COUNTER)||(LA118_4 >= K_CUSTOM && LA118_4 <= K_DECIMAL)||(LA118_4 >= K_DISTINCT && LA118_4 <= K_DOUBLE)||(LA118_4 >= K_EXISTS && LA118_4 <= K_FLOAT)||LA118_4==K_FROZEN||(LA118_4 >= K_FUNCTION && LA118_4 <= K_FUNCTIONS)||LA118_4==K_INET||(LA118_4 >= K_INITCOND && LA118_4 <= K_INPUT)||LA118_4==K_INT||(LA118_4 >= K_JSON && LA118_4 <= K_KEYS)||(LA118_4 >= K_KEYSPACES && LA118_4 <= K_LANGUAGE)||(LA118_4 >= K_LIST && LA118_4 <= K_MAP)||LA118_4==K_NOLOGIN||LA118_4==K_NOSUPERUSER||LA118_4==K_OPTIONS||(LA118_4 >= K_PASSWORD && LA118_4 <= K_PERMISSIONS)||LA118_4==K_RETURNS||(LA118_4 >= K_ROLE && LA118_4 <= K_ROLES)||(LA118_4 >= K_SFUNC && LA118_4 <= K_TINYINT)||(LA118_4 >= K_TOKEN && LA118_4 <= K_TRIGGER)||(LA118_4 >= K_TTL && LA118_4 <= K_TYPE)||(LA118_4 >= K_USER && LA118_4 <= K_USERS)||(LA118_4 >= K_UUID && LA118_4 <= K_VARINT)||LA118_4==K_WRITETIME||(LA118_4 >= QMARK && LA118_4 <= QUOTED_NAME)) ) {
					alt118=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:980:7: d= dataResource
					{
					pushFollow(FOLLOW_dataResource_in_resource6258);
					d=dataResource();
					state._fsp--;

					 res = d; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:981:7: r= roleResource
					{
					pushFollow(FOLLOW_roleResource_in_resource6270);
					r=roleResource();
					state._fsp--;

					 res = r; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:982:7: f= functionResource
					{
					pushFollow(FOLLOW_functionResource_in_resource6282);
					f=functionResource();
					state._fsp--;

					 res = f; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "resource"



	// $ANTLR start "dataResource"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:985:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
	public final DataResource dataResource() throws RecognitionException {
		DataResource res = null;


		String ks =null;
		CFName cf =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:986:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
			int alt120=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				int LA120_1 = input.LA(2);
				if ( (LA120_1==K_KEYSPACES) ) {
					alt120=1;
				}
				else if ( (LA120_1==EOF||LA120_1==K_FROM||LA120_1==K_NORECURSIVE||LA120_1==K_OF||LA120_1==K_TO||LA120_1==176||LA120_1==178) ) {
					alt120=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 120, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_KEYSPACE:
				{
				alt120=2;
				}
				break;
			case IDENT:
			case K_AGGREGATE:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QMARK:
			case QUOTED_NAME:
				{
				alt120=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 120, 0, input);
				throw nvae;
			}
			switch (alt120) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:986:7: K_ALL K_KEYSPACES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_dataResource6305); 
					match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource6307); 
					 res = DataResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:987:7: K_KEYSPACE ks= keyspaceName
					{
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource6317); 
					pushFollow(FOLLOW_keyspaceName_in_dataResource6323);
					ks=keyspaceName();
					state._fsp--;

					 res = DataResource.keyspace(ks); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:988:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
					{
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:988:7: ( K_COLUMNFAMILY )?
					int alt119=2;
					int LA119_0 = input.LA(1);
					if ( (LA119_0==K_COLUMNFAMILY) ) {
						alt119=1;
					}
					switch (alt119) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:988:9: K_COLUMNFAMILY
							{
							match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource6335); 
							}
							break;

					}

					pushFollow(FOLLOW_columnFamilyName_in_dataResource6344);
					cf=columnFamilyName();
					state._fsp--;

					 res = DataResource.table(cf.getKeyspace(), cf.getColumnFamily()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "dataResource"



	// $ANTLR start "roleResource"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:992:1: roleResource returns [RoleResource res] : ( K_ALL K_ROLES | K_ROLE role= userOrRoleName );
	public final RoleResource roleResource() throws RecognitionException {
		RoleResource res = null;


		RoleName role =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:993:5: ( K_ALL K_ROLES | K_ROLE role= userOrRoleName )
			int alt121=2;
			int LA121_0 = input.LA(1);
			if ( (LA121_0==K_ALL) ) {
				alt121=1;
			}
			else if ( (LA121_0==K_ROLE) ) {
				alt121=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}

			switch (alt121) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:993:7: K_ALL K_ROLES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_roleResource6373); 
					match(input,K_ROLES,FOLLOW_K_ROLES_in_roleResource6375); 
					 res = RoleResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:994:7: K_ROLE role= userOrRoleName
					{
					match(input,K_ROLE,FOLLOW_K_ROLE_in_roleResource6385); 
					pushFollow(FOLLOW_userOrRoleName_in_roleResource6391);
					role=userOrRoleName();
					state._fsp--;

					 res = RoleResource.role(role.getName()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "roleResource"



	// $ANTLR start "functionResource"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:997:1: functionResource returns [FunctionResource res] : ( K_ALL K_FUNCTIONS | K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName | K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' ) );
	public final FunctionResource functionResource() throws RecognitionException {
		FunctionResource res = null;


		String ks =null;
		FunctionName fn =null;
		CQL3Type.Raw v =null;


		        List<CQL3Type.Raw> argsTypes = new ArrayList<>();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1001:5: ( K_ALL K_FUNCTIONS | K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName | K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' ) )
			int alt124=3;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==K_ALL) ) {
				int LA124_1 = input.LA(2);
				if ( (LA124_1==K_FUNCTIONS) ) {
					int LA124_3 = input.LA(3);
					if ( (LA124_3==K_IN) ) {
						alt124=2;
					}
					else if ( (LA124_3==EOF||LA124_3==K_FROM||LA124_3==K_NORECURSIVE||LA124_3==K_OF||LA124_3==K_TO||LA124_3==178) ) {
						alt124=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 124, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 124, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA124_0==K_FUNCTION) ) {
				alt124=3;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 124, 0, input);
				throw nvae;
			}

			switch (alt124) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1001:7: K_ALL K_FUNCTIONS
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_functionResource6423); 
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_functionResource6425); 
					 res = FunctionResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1002:7: K_ALL K_FUNCTIONS K_IN K_KEYSPACE ks= keyspaceName
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_functionResource6435); 
					match(input,K_FUNCTIONS,FOLLOW_K_FUNCTIONS_in_functionResource6437); 
					match(input,K_IN,FOLLOW_K_IN_in_functionResource6439); 
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_functionResource6441); 
					pushFollow(FOLLOW_keyspaceName_in_functionResource6447);
					ks=keyspaceName();
					state._fsp--;

					 res = FunctionResource.keyspace(ks); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:7: K_FUNCTION fn= functionName ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )
					{
					match(input,K_FUNCTION,FOLLOW_K_FUNCTION_in_functionResource6462); 
					pushFollow(FOLLOW_functionName_in_functionResource6466);
					fn=functionName();
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1005:7: ( '(' (v= comparatorType ( ',' v= comparatorType )* )? ')' )
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1006:9: '(' (v= comparatorType ( ',' v= comparatorType )* )? ')'
					{
					match(input,171,FOLLOW_171_in_functionResource6484); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1007:11: (v= comparatorType ( ',' v= comparatorType )* )?
					int alt123=2;
					int LA123_0 = input.LA(1);
					if ( (LA123_0==IDENT||(LA123_0 >= K_AGGREGATE && LA123_0 <= K_ALL)||LA123_0==K_AS||LA123_0==K_ASCII||(LA123_0 >= K_BIGINT && LA123_0 <= K_BOOLEAN)||(LA123_0 >= K_CALLED && LA123_0 <= K_CLUSTERING)||(LA123_0 >= K_COMPACT && LA123_0 <= K_COUNTER)||(LA123_0 >= K_CUSTOM && LA123_0 <= K_DECIMAL)||(LA123_0 >= K_DISTINCT && LA123_0 <= K_DOUBLE)||(LA123_0 >= K_EXISTS && LA123_0 <= K_FLOAT)||LA123_0==K_FROZEN||(LA123_0 >= K_FUNCTION && LA123_0 <= K_FUNCTIONS)||LA123_0==K_INET||(LA123_0 >= K_INITCOND && LA123_0 <= K_INPUT)||LA123_0==K_INT||(LA123_0 >= K_JSON && LA123_0 <= K_KEYS)||(LA123_0 >= K_KEYSPACES && LA123_0 <= K_LANGUAGE)||(LA123_0 >= K_LIST && LA123_0 <= K_MAP)||LA123_0==K_NOLOGIN||LA123_0==K_NOSUPERUSER||LA123_0==K_OPTIONS||(LA123_0 >= K_PASSWORD && LA123_0 <= K_PERMISSIONS)||LA123_0==K_RETURNS||(LA123_0 >= K_ROLE && LA123_0 <= K_ROLES)||(LA123_0 >= K_SET && LA123_0 <= K_TINYINT)||LA123_0==K_TRIGGER||(LA123_0 >= K_TTL && LA123_0 <= K_TYPE)||(LA123_0 >= K_USER && LA123_0 <= K_USERS)||(LA123_0 >= K_UUID && LA123_0 <= K_VARINT)||LA123_0==K_WRITETIME||LA123_0==QUOTED_NAME||LA123_0==STRING_LITERAL) ) {
						alt123=1;
					}
					switch (alt123) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1008:13: v= comparatorType ( ',' v= comparatorType )*
							{
							pushFollow(FOLLOW_comparatorType_in_functionResource6512);
							v=comparatorType();
							state._fsp--;

							 argsTypes.add(v); 
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1009:13: ( ',' v= comparatorType )*
							loop122:
							while (true) {
								int alt122=2;
								int LA122_0 = input.LA(1);
								if ( (LA122_0==174) ) {
									alt122=1;
								}

								switch (alt122) {
								case 1 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1009:15: ',' v= comparatorType
									{
									match(input,174,FOLLOW_174_in_functionResource6530); 
									pushFollow(FOLLOW_comparatorType_in_functionResource6534);
									v=comparatorType();
									state._fsp--;

									 argsTypes.add(v); 
									}
									break;

								default :
									break loop122;
								}
							}

							}
							break;

					}

					match(input,172,FOLLOW_172_in_functionResource6562); 
					}

					 res = FunctionResource.functionFromCql(fn.keyspace, fn.name, argsTypes); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "functionResource"



	// $ANTLR start "createUserStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1019:1: createUserStatement returns [CreateRoleStatement stmt] : K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final CreateRoleStatement createUserStatement() throws RecognitionException {
		CreateRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        RoleOptions opts = new RoleOptions();
		        opts.setOption(IRoleManager.Option.LOGIN, true);
		        boolean superuser = false;
		        boolean ifNotExists = false;
		        RoleName name = new RoleName();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1027:5: ( K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1027:7: K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement6610); 
			match(input,K_USER,FOLLOW_K_USER_in_createUserStatement6612); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1027:23: ( K_IF K_NOT K_EXISTS )?
			int alt125=2;
			int LA125_0 = input.LA(1);
			if ( (LA125_0==K_IF) ) {
				alt125=1;
			}
			switch (alt125) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1027:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createUserStatement6615); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createUserStatement6617); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createUserStatement6619); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_createUserStatement6627);
			u=username();
			state._fsp--;

			 name.setName((u!=null?input.toString(u.start,u.stop):null), false); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1028:7: ( K_WITH userPassword[opts] )?
			int alt126=2;
			int LA126_0 = input.LA(1);
			if ( (LA126_0==K_WITH) ) {
				alt126=1;
			}
			switch (alt126) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1028:9: K_WITH userPassword[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement6639); 
					pushFollow(FOLLOW_userPassword_in_createUserStatement6641);
					userPassword(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt127=3;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==K_SUPERUSER) ) {
				alt127=1;
			}
			else if ( (LA127_0==K_NOSUPERUSER) ) {
				alt127=2;
			}
			switch (alt127) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement6655); 
					 superuser = true; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement6661); 
					 superuser = false; 
					}
					break;

			}

			 opts.setOption(IRoleManager.Option.SUPERUSER, superuser);
			        stmt = new CreateRoleStatement(name, opts, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createUserStatement"



	// $ANTLR start "alterUserStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1037:1: alterUserStatement returns [AlterRoleStatement stmt] : K_ALTER K_USER u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final AlterRoleStatement alterUserStatement() throws RecognitionException {
		AlterRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        RoleOptions opts = new RoleOptions();
		        RoleName name = new RoleName();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1042:5: ( K_ALTER K_USER u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1042:7: K_ALTER K_USER u= username ( K_WITH userPassword[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement6706); 
			match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement6708); 
			pushFollow(FOLLOW_username_in_alterUserStatement6712);
			u=username();
			state._fsp--;

			 name.setName((u!=null?input.toString(u.start,u.stop):null), false); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1043:7: ( K_WITH userPassword[opts] )?
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==K_WITH) ) {
				alt128=1;
			}
			switch (alt128) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1043:9: K_WITH userPassword[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement6724); 
					pushFollow(FOLLOW_userPassword_in_alterUserStatement6726);
					userPassword(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1044:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt129=3;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==K_SUPERUSER) ) {
				alt129=1;
			}
			else if ( (LA129_0==K_NOSUPERUSER) ) {
				alt129=2;
			}
			switch (alt129) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1044:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement6740); 
					 opts.setOption(IRoleManager.Option.SUPERUSER, true); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1045:11: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement6754); 
					 opts.setOption(IRoleManager.Option.SUPERUSER, false); 
					}
					break;

			}

			  stmt = new AlterRoleStatement(name, opts); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterUserStatement"



	// $ANTLR start "dropUserStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:1: dropUserStatement returns [DropRoleStatement stmt] : K_DROP K_USER ( K_IF K_EXISTS )? u= username ;
	public final DropRoleStatement dropUserStatement() throws RecognitionException {
		DropRoleStatement stmt = null;


		ParserRuleReturnScope u =null;


		        boolean ifExists = false;
		        RoleName name = new RoleName();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1057:5: ( K_DROP K_USER ( K_IF K_EXISTS )? u= username )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1057:7: K_DROP K_USER ( K_IF K_EXISTS )? u= username
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement6800); 
			match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement6802); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1057:21: ( K_IF K_EXISTS )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==K_IF) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1057:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropUserStatement6805); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropUserStatement6807); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_dropUserStatement6815);
			u=username();
			state._fsp--;

			 name.setName((u!=null?input.toString(u.start,u.stop):null), false); stmt = new DropRoleStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropUserStatement"



	// $ANTLR start "listUsersStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1063:1: listUsersStatement returns [ListRolesStatement stmt] : K_LIST K_USERS ;
	public final ListRolesStatement listUsersStatement() throws RecognitionException {
		ListRolesStatement stmt = null;


		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1064:5: ( K_LIST K_USERS )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1064:7: K_LIST K_USERS
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement6840); 
			match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement6842); 
			 stmt = new ListUsersStatement(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listUsersStatement"



	// $ANTLR start "createRoleStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1076:1: createRoleStatement returns [CreateRoleStatement stmt] : K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts] )? ;
	public final CreateRoleStatement createRoleStatement() throws RecognitionException {
		CreateRoleStatement stmt = null;


		RoleName name =null;


		        RoleOptions opts = new RoleOptions();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1081:5: ( K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts] )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1081:7: K_CREATE K_ROLE ( K_IF K_NOT K_EXISTS )? name= userOrRoleName ( K_WITH roleOptions[opts] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createRoleStatement6876); 
			match(input,K_ROLE,FOLLOW_K_ROLE_in_createRoleStatement6878); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1081:23: ( K_IF K_NOT K_EXISTS )?
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==K_IF) ) {
				alt131=1;
			}
			switch (alt131) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1081:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createRoleStatement6881); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createRoleStatement6883); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createRoleStatement6885); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_createRoleStatement6893);
			name=userOrRoleName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:7: ( K_WITH roleOptions[opts] )?
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==K_WITH) ) {
				alt132=1;
			}
			switch (alt132) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1082:9: K_WITH roleOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createRoleStatement6903); 
					pushFollow(FOLLOW_roleOptions_in_createRoleStatement6905);
					roleOptions(opts);
					state._fsp--;

					}
					break;

			}


			        // set defaults if they weren't explictly supplied
			        if (!opts.getLogin().isPresent())
			        {
			            opts.setOption(IRoleManager.Option.LOGIN, false);
			        }
			        if (!opts.getSuperuser().isPresent())
			        {
			            opts.setOption(IRoleManager.Option.SUPERUSER, false);
			        }
			        stmt = new CreateRoleStatement(name, opts, ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createRoleStatement"



	// $ANTLR start "alterRoleStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1106:1: alterRoleStatement returns [AlterRoleStatement stmt] : K_ALTER K_ROLE name= userOrRoleName ( K_WITH roleOptions[opts] )? ;
	public final AlterRoleStatement alterRoleStatement() throws RecognitionException {
		AlterRoleStatement stmt = null;


		RoleName name =null;


		        RoleOptions opts = new RoleOptions();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1110:5: ( K_ALTER K_ROLE name= userOrRoleName ( K_WITH roleOptions[opts] )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1110:7: K_ALTER K_ROLE name= userOrRoleName ( K_WITH roleOptions[opts] )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterRoleStatement6949); 
			match(input,K_ROLE,FOLLOW_K_ROLE_in_alterRoleStatement6951); 
			pushFollow(FOLLOW_userOrRoleName_in_alterRoleStatement6955);
			name=userOrRoleName();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1111:7: ( K_WITH roleOptions[opts] )?
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==K_WITH) ) {
				alt133=1;
			}
			switch (alt133) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1111:9: K_WITH roleOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterRoleStatement6965); 
					pushFollow(FOLLOW_roleOptions_in_alterRoleStatement6967);
					roleOptions(opts);
					state._fsp--;

					}
					break;

			}

			  stmt = new AlterRoleStatement(name, opts); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterRoleStatement"



	// $ANTLR start "dropRoleStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1118:1: dropRoleStatement returns [DropRoleStatement stmt] : K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName ;
	public final DropRoleStatement dropRoleStatement() throws RecognitionException {
		DropRoleStatement stmt = null;


		RoleName name =null;


		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1122:5: ( K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1122:7: K_DROP K_ROLE ( K_IF K_EXISTS )? name= userOrRoleName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropRoleStatement7011); 
			match(input,K_ROLE,FOLLOW_K_ROLE_in_dropRoleStatement7013); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1122:21: ( K_IF K_EXISTS )?
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==K_IF) ) {
				alt134=1;
			}
			switch (alt134) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1122:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropRoleStatement7016); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropRoleStatement7018); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userOrRoleName_in_dropRoleStatement7026);
			name=userOrRoleName();
			state._fsp--;

			 stmt = new DropRoleStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropRoleStatement"



	// $ANTLR start "listRolesStatement"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1129:1: listRolesStatement returns [ListRolesStatement stmt] : K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? ;
	public final ListRolesStatement listRolesStatement() throws RecognitionException {
		ListRolesStatement stmt = null;



		        boolean recursive = true;
		        RoleName grantee = new RoleName();
		    
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1134:5: ( K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )? )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1134:7: K_LIST K_ROLES ( K_OF roleName[grantee] )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listRolesStatement7066); 
			match(input,K_ROLES,FOLLOW_K_ROLES_in_listRolesStatement7068); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1135:7: ( K_OF roleName[grantee] )?
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==K_OF) ) {
				alt135=1;
			}
			switch (alt135) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1135:9: K_OF roleName[grantee]
					{
					match(input,K_OF,FOLLOW_K_OF_in_listRolesStatement7078); 
					pushFollow(FOLLOW_roleName_in_listRolesStatement7080);
					roleName(grantee);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:7: ( K_NORECURSIVE )?
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==K_NORECURSIVE) ) {
				alt136=1;
			}
			switch (alt136) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1136:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listRolesStatement7093); 
					 recursive = false; 
					}
					break;

			}

			 stmt = new ListRolesStatement(grantee, recursive); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listRolesStatement"



	// $ANTLR start "roleOptions"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1140:1: roleOptions[RoleOptions opts] : roleOption[opts] ( K_AND roleOption[opts] )* ;
	public final void roleOptions(RoleOptions opts) throws RecognitionException {
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:5: ( roleOption[opts] ( K_AND roleOption[opts] )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:7: roleOption[opts] ( K_AND roleOption[opts] )*
			{
			pushFollow(FOLLOW_roleOption_in_roleOptions7124);
			roleOption(opts);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:24: ( K_AND roleOption[opts] )*
			loop137:
			while (true) {
				int alt137=2;
				int LA137_0 = input.LA(1);
				if ( (LA137_0==K_AND) ) {
					alt137=1;
				}

				switch (alt137) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1141:25: K_AND roleOption[opts]
					{
					match(input,K_AND,FOLLOW_K_AND_in_roleOptions7128); 
					pushFollow(FOLLOW_roleOption_in_roleOptions7130);
					roleOption(opts);
					state._fsp--;

					}
					break;

				default :
					break loop137;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleOptions"



	// $ANTLR start "roleOption"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1144:1: roleOption[RoleOptions opts] : ( K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= mapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN );
	public final void roleOption(RoleOptions opts) throws RecognitionException {
		Token v=null;
		Token b=null;
		Maps.Literal m =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1145:5: ( K_PASSWORD '=' v= STRING_LITERAL | K_OPTIONS '=' m= mapLiteral | K_SUPERUSER '=' b= BOOLEAN | K_LOGIN '=' b= BOOLEAN )
			int alt138=4;
			switch ( input.LA(1) ) {
			case K_PASSWORD:
				{
				alt138=1;
				}
				break;
			case K_OPTIONS:
				{
				alt138=2;
				}
				break;
			case K_SUPERUSER:
				{
				alt138=3;
				}
				break;
			case K_LOGIN:
				{
				alt138=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}
			switch (alt138) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1145:8: K_PASSWORD '=' v= STRING_LITERAL
					{
					match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_roleOption7152); 
					match(input,181,FOLLOW_181_in_roleOption7154); 
					v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_roleOption7158); 
					 opts.setOption(IRoleManager.Option.PASSWORD, (v!=null?v.getText():null)); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1146:8: K_OPTIONS '=' m= mapLiteral
					{
					match(input,K_OPTIONS,FOLLOW_K_OPTIONS_in_roleOption7169); 
					match(input,181,FOLLOW_181_in_roleOption7171); 
					pushFollow(FOLLOW_mapLiteral_in_roleOption7175);
					m=mapLiteral();
					state._fsp--;

					 opts.setOption(IRoleManager.Option.OPTIONS, convertPropertyMap(m)); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1147:8: K_SUPERUSER '=' b= BOOLEAN
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_roleOption7186); 
					match(input,181,FOLLOW_181_in_roleOption7188); 
					b=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_roleOption7192); 
					 opts.setOption(IRoleManager.Option.SUPERUSER, Boolean.valueOf((b!=null?b.getText():null))); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1148:8: K_LOGIN '=' b= BOOLEAN
					{
					match(input,K_LOGIN,FOLLOW_K_LOGIN_in_roleOption7203); 
					match(input,181,FOLLOW_181_in_roleOption7205); 
					b=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_roleOption7209); 
					 opts.setOption(IRoleManager.Option.LOGIN, Boolean.valueOf((b!=null?b.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleOption"



	// $ANTLR start "userPassword"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1152:1: userPassword[RoleOptions opts] : K_PASSWORD v= STRING_LITERAL ;
	public final void userPassword(RoleOptions opts) throws RecognitionException {
		Token v=null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1153:5: ( K_PASSWORD v= STRING_LITERAL )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1153:8: K_PASSWORD v= STRING_LITERAL
			{
			match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userPassword7231); 
			v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userPassword7235); 
			 opts.setOption(IRoleManager.Option.PASSWORD, (v!=null?v.getText():null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userPassword"



	// $ANTLR start "cident"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1161:1: cident returns [ColumnIdentifier.Raw id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier.Raw cident() throws RecognitionException {
		ColumnIdentifier.Raw id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1162:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt139=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt139=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt139=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt139=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1162:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident7266); 
					 id = new ColumnIdentifier.Raw((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1163:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident7291); 
					 id = new ColumnIdentifier.Raw((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1164:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cident7310);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier.Raw(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "cident"



	// $ANTLR start "ident"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1168:1: ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1169:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt140=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt140=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt140=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt140=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}
			switch (alt140) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1169:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ident7336); 
					 id = ColumnIdentifier.getInterned((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1170:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ident7361); 
					 id = ColumnIdentifier.getInterned((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1171:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ident7380);
					k=unreserved_keyword();
					state._fsp--;

					 id = ColumnIdentifier.getInterned(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "ident"



	// $ANTLR start "noncol_ident"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1175:1: noncol_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier noncol_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1176:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt141=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt141=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt141=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt141=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1176:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_noncol_ident7406); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1177:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_noncol_ident7431); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1178:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_noncol_ident7450);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "noncol_ident"



	// $ANTLR start "keyspaceName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1182:1: keyspaceName returns [String id] : ksName[name] ;
	public final String keyspaceName() throws RecognitionException {
		String id = null;


		 CFName name = new CFName(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:5: ( ksName[name] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1184:7: ksName[name]
			{
			pushFollow(FOLLOW_ksName_in_keyspaceName7483);
			ksName(name);
			state._fsp--;

			 id = name.getKeyspace(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "keyspaceName"



	// $ANTLR start "indexName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1187:1: indexName returns [IndexName name] : ( ksName[name] '.' )? idxName[name] ;
	public final IndexName indexName() throws RecognitionException {
		IndexName name = null;


		 name = new IndexName(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:5: ( ( ksName[name] '.' )? idxName[name] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:7: ( ksName[name] '.' )? idxName[name]
			{
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:7: ( ksName[name] '.' )?
			int alt142=2;
			alt142 = dfa142.predict(input);
			switch (alt142) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1189:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_indexName7517);
					ksName(name);
					state._fsp--;

					match(input,176,FOLLOW_176_in_indexName7520); 
					}
					break;

			}

			pushFollow(FOLLOW_idxName_in_indexName7524);
			idxName(name);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "indexName"



	// $ANTLR start "columnFamilyName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1192:1: columnFamilyName returns [CFName name] : ( ksName[name] '.' )? cfName[name] ;
	public final CFName columnFamilyName() throws RecognitionException {
		CFName name = null;


		 name = new CFName(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1194:5: ( ( ksName[name] '.' )? cfName[name] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1194:7: ( ksName[name] '.' )? cfName[name]
			{
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1194:7: ( ksName[name] '.' )?
			int alt143=2;
			alt143 = dfa143.predict(input);
			switch (alt143) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1194:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_columnFamilyName7556);
					ksName(name);
					state._fsp--;

					match(input,176,FOLLOW_176_in_columnFamilyName7559); 
					}
					break;

			}

			pushFollow(FOLLOW_cfName_in_columnFamilyName7563);
			cfName(name);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "columnFamilyName"



	// $ANTLR start "userTypeName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1197:1: userTypeName returns [UTName name] : (ks= noncol_ident '.' )? ut= non_type_ident ;
	public final UTName userTypeName() throws RecognitionException {
		UTName name = null;


		ColumnIdentifier ks =null;
		ColumnIdentifier ut =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1198:5: ( (ks= noncol_ident '.' )? ut= non_type_ident )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1198:7: (ks= noncol_ident '.' )? ut= non_type_ident
			{
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1198:7: (ks= noncol_ident '.' )?
			int alt144=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA144_1 = input.LA(2);
					if ( (LA144_1==176) ) {
						alt144=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA144_2 = input.LA(2);
					if ( (LA144_2==176) ) {
						alt144=1;
					}
					}
					break;
				case K_AGGREGATE:
				case K_ALL:
				case K_AS:
				case K_CALLED:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FINALFUNC:
				case K_FROZEN:
				case K_FUNCTION:
				case K_FUNCTIONS:
				case K_INITCOND:
				case K_INPUT:
				case K_JSON:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LANGUAGE:
				case K_LIST:
				case K_LOGIN:
				case K_MAP:
				case K_NOLOGIN:
				case K_NOSUPERUSER:
				case K_OPTIONS:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_RETURNS:
				case K_ROLE:
				case K_ROLES:
				case K_SFUNC:
				case K_STATIC:
				case K_STORAGE:
				case K_STYPE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA144_3 = input.LA(2);
					if ( (LA144_3==176) ) {
						alt144=1;
					}
					}
					break;
				case K_ASCII:
				case K_BIGINT:
				case K_BLOB:
				case K_BOOLEAN:
				case K_COUNT:
				case K_COUNTER:
				case K_DATE:
				case K_DECIMAL:
				case K_DOUBLE:
				case K_FLOAT:
				case K_INET:
				case K_INT:
				case K_SMALLINT:
				case K_TEXT:
				case K_TIME:
				case K_TIMESTAMP:
				case K_TIMEUUID:
				case K_TINYINT:
				case K_TTL:
				case K_UUID:
				case K_VARCHAR:
				case K_VARINT:
				case K_WRITETIME:
					{
					alt144=1;
					}
					break;
				case K_KEY:
					{
					int LA144_5 = input.LA(2);
					if ( (LA144_5==176) ) {
						alt144=1;
					}
					}
					break;
			}
			switch (alt144) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1198:8: ks= noncol_ident '.'
					{
					pushFollow(FOLLOW_noncol_ident_in_userTypeName7588);
					ks=noncol_ident();
					state._fsp--;

					match(input,176,FOLLOW_176_in_userTypeName7590); 
					}
					break;

			}

			pushFollow(FOLLOW_non_type_ident_in_userTypeName7596);
			ut=non_type_ident();
			state._fsp--;

			 return new UTName(ks, ut); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userTypeName"



	// $ANTLR start "userOrRoleName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1201:1: userOrRoleName returns [RoleName name] : roleName[name] ;
	public final RoleName userOrRoleName() throws RecognitionException {
		RoleName name = null;


		 name = new RoleName(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1203:5: ( roleName[name] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1203:7: roleName[name]
			{
			pushFollow(FOLLOW_roleName_in_userOrRoleName7628);
			roleName(name);
			state._fsp--;

			return name;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userOrRoleName"



	// $ANTLR start "ksName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1206:1: ksName[KeyspaceElementName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void ksName(KeyspaceElementName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1207:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt145=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt145=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt145=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt145=3;
				}
				break;
			case QMARK:
				{
				alt145=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 145, 0, input);
				throw nvae;
			}
			switch (alt145) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1207:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ksName7651); 
					 name.setKeyspace((t!=null?t.getText():null), false);
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1208:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ksName7676); 
					 name.setKeyspace((t!=null?t.getText():null), true);
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1209:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ksName7695);
					k=unreserved_keyword();
					state._fsp--;

					 name.setKeyspace(k, false);
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1210:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_ksName7705); 
					addRecognitionError("Bind variables cannot be used for keyspace names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ksName"



	// $ANTLR start "cfName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1213:1: cfName[CFName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void cfName(CFName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1214:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt146=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt146=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt146=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt146=3;
				}
				break;
			case QMARK:
				{
				alt146=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 146, 0, input);
				throw nvae;
			}
			switch (alt146) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1214:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfName7727); 
					 name.setColumnFamily((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1215:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfName7752); 
					 name.setColumnFamily((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1216:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cfName7771);
					k=unreserved_keyword();
					state._fsp--;

					 name.setColumnFamily(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1217:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_cfName7781); 
					addRecognitionError("Bind variables cannot be used for table names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfName"



	// $ANTLR start "idxName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1220:1: idxName[IndexName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void idxName(IndexName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1221:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt147=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt147=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt147=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt147=3;
				}
				break;
			case QMARK:
				{
				alt147=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 147, 0, input);
				throw nvae;
			}
			switch (alt147) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1221:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_idxName7803); 
					 name.setIndex((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1222:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_idxName7828); 
					 name.setIndex((t!=null?t.getText():null), true);
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1223:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_idxName7847);
					k=unreserved_keyword();
					state._fsp--;

					 name.setIndex(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1224:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_idxName7857); 
					addRecognitionError("Bind variables cannot be used for index names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "idxName"



	// $ANTLR start "roleName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1227:1: roleName[RoleName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void roleName(RoleName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1228:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt148=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt148=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt148=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt148=3;
				}
				break;
			case QMARK:
				{
				alt148=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}
			switch (alt148) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1228:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_roleName7879); 
					 name.setName((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1229:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_roleName7904); 
					 name.setName((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1230:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_roleName7923);
					k=unreserved_keyword();
					state._fsp--;

					 name.setName(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1231:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_roleName7933); 
					addRecognitionError("Bind variables cannot be used for role names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "roleName"



	// $ANTLR start "constant"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1234:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) );
	public final Constants.Literal constant() throws RecognitionException {
		Constants.Literal constant = null;


		Token t=null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1235:5: (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) )
			int alt150=7;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt150=1;
				}
				break;
			case INTEGER:
				{
				alt150=2;
				}
				break;
			case FLOAT:
				{
				alt150=3;
				}
				break;
			case BOOLEAN:
				{
				alt150=4;
				}
				break;
			case UUID:
				{
				alt150=5;
				}
				break;
			case HEXNUMBER:
				{
				alt150=6;
				}
				break;
			case K_INFINITY:
			case K_NAN:
			case 175:
				{
				alt150=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 150, 0, input);
				throw nvae;
			}
			switch (alt150) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1235:7: t= STRING_LITERAL
					{
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant7958); 
					 constant = Constants.Literal.string((t!=null?t.getText():null)); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1236:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant7970); 
					 constant = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1237:7: t= FLOAT
					{
					t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant7989); 
					 constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1238:7: t= BOOLEAN
					{
					t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant8010); 
					 constant = Constants.Literal.bool((t!=null?t.getText():null)); 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1239:7: t= UUID
					{
					t=(Token)match(input,UUID,FOLLOW_UUID_in_constant8029); 
					 constant = Constants.Literal.uuid((t!=null?t.getText():null)); 
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1240:7: t= HEXNUMBER
					{
					t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant8051); 
					 constant = Constants.Literal.hex((t!=null?t.getText():null)); 
					}
					break;
				case 7 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1241:7: ( '-' )? t= ( K_NAN | K_INFINITY )
					{
					 String sign=""; 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1241:27: ( '-' )?
					int alt149=2;
					int LA149_0 = input.LA(1);
					if ( (LA149_0==175) ) {
						alt149=1;
					}
					switch (alt149) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1241:28: '-'
							{
							match(input,175,FOLLOW_175_in_constant8069); 
							sign = "-"; 
							}
							break;

					}

					t=input.LT(1);
					if ( input.LA(1)==K_INFINITY||input.LA(1)==K_NAN ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 constant = Constants.Literal.floatingPoint(sign + (t!=null?t.getText():null)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return constant;
	}
	// $ANTLR end "constant"



	// $ANTLR start "mapLiteral"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1244:1: mapLiteral returns [Maps.Literal map] : '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' ;
	public final Maps.Literal mapLiteral() throws RecognitionException {
		Maps.Literal map = null;


		Term.Raw k1 =null;
		Term.Raw v1 =null;
		Term.Raw kn =null;
		Term.Raw vn =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1245:5: ( '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1245:7: '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}'
			{
			match(input,187,FOLLOW_187_in_mapLiteral8107); 
			 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1246:11: (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )?
			int alt152=2;
			int LA152_0 = input.LA(1);
			if ( (LA152_0==BOOLEAN||LA152_0==FLOAT||LA152_0==HEXNUMBER||(LA152_0 >= IDENT && LA152_0 <= INTEGER)||(LA152_0 >= K_AGGREGATE && LA152_0 <= K_ALL)||LA152_0==K_AS||LA152_0==K_ASCII||(LA152_0 >= K_BIGINT && LA152_0 <= K_BOOLEAN)||(LA152_0 >= K_CALLED && LA152_0 <= K_CLUSTERING)||(LA152_0 >= K_COMPACT && LA152_0 <= K_COUNTER)||(LA152_0 >= K_CUSTOM && LA152_0 <= K_DECIMAL)||(LA152_0 >= K_DISTINCT && LA152_0 <= K_DOUBLE)||(LA152_0 >= K_EXISTS && LA152_0 <= K_FLOAT)||LA152_0==K_FROZEN||(LA152_0 >= K_FUNCTION && LA152_0 <= K_FUNCTIONS)||(LA152_0 >= K_INET && LA152_0 <= K_INPUT)||LA152_0==K_INT||(LA152_0 >= K_JSON && LA152_0 <= K_KEYS)||(LA152_0 >= K_KEYSPACES && LA152_0 <= K_LANGUAGE)||(LA152_0 >= K_LIST && LA152_0 <= K_MAP)||(LA152_0 >= K_NAN && LA152_0 <= K_NOLOGIN)||LA152_0==K_NOSUPERUSER||LA152_0==K_NULL||LA152_0==K_OPTIONS||(LA152_0 >= K_PASSWORD && LA152_0 <= K_PERMISSIONS)||LA152_0==K_RETURNS||(LA152_0 >= K_ROLE && LA152_0 <= K_ROLES)||(LA152_0 >= K_SFUNC && LA152_0 <= K_TINYINT)||(LA152_0 >= K_TOKEN && LA152_0 <= K_TRIGGER)||(LA152_0 >= K_TTL && LA152_0 <= K_TYPE)||(LA152_0 >= K_USER && LA152_0 <= K_USERS)||(LA152_0 >= K_UUID && LA152_0 <= K_VARINT)||LA152_0==K_WRITETIME||(LA152_0 >= QMARK && LA152_0 <= QUOTED_NAME)||LA152_0==STRING_LITERAL||LA152_0==UUID||LA152_0==171||LA152_0==175||LA152_0==177||LA152_0==184||LA152_0==187) ) {
				alt152=1;
			}
			switch (alt152) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1246:13: k1= term ':' v1= term ( ',' kn= term ':' vn= term )*
					{
					pushFollow(FOLLOW_term_in_mapLiteral8125);
					k1=term();
					state._fsp--;

					match(input,177,FOLLOW_177_in_mapLiteral8127); 
					pushFollow(FOLLOW_term_in_mapLiteral8131);
					v1=term();
					state._fsp--;

					 m.add(Pair.create(k1, v1)); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1246:65: ( ',' kn= term ':' vn= term )*
					loop151:
					while (true) {
						int alt151=2;
						int LA151_0 = input.LA(1);
						if ( (LA151_0==174) ) {
							alt151=1;
						}

						switch (alt151) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1246:67: ',' kn= term ':' vn= term
							{
							match(input,174,FOLLOW_174_in_mapLiteral8137); 
							pushFollow(FOLLOW_term_in_mapLiteral8141);
							kn=term();
							state._fsp--;

							match(input,177,FOLLOW_177_in_mapLiteral8143); 
							pushFollow(FOLLOW_term_in_mapLiteral8147);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop151;
						}
					}

					}
					break;

			}

			match(input,188,FOLLOW_188_in_mapLiteral8163); 
			 map = new Maps.Literal(m); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return map;
	}
	// $ANTLR end "mapLiteral"



	// $ANTLR start "setOrMapLiteral"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1250:1: setOrMapLiteral[Term.Raw t] returns [Term.Raw value] : ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* );
	public final Term.Raw setOrMapLiteral(Term.Raw t) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw v =null;
		Term.Raw kn =null;
		Term.Raw vn =null;
		Term.Raw tn =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1251:5: ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* )
			int alt155=2;
			int LA155_0 = input.LA(1);
			if ( (LA155_0==177) ) {
				alt155=1;
			}
			else if ( (LA155_0==174||LA155_0==188) ) {
				alt155=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}

			switch (alt155) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1251:7: ':' v= term ( ',' kn= term ':' vn= term )*
					{
					match(input,177,FOLLOW_177_in_setOrMapLiteral8187); 
					pushFollow(FOLLOW_term_in_setOrMapLiteral8191);
					v=term();
					state._fsp--;

					 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1252:11: ( ',' kn= term ':' vn= term )*
					loop153:
					while (true) {
						int alt153=2;
						int LA153_0 = input.LA(1);
						if ( (LA153_0==174) ) {
							alt153=1;
						}

						switch (alt153) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1252:13: ',' kn= term ':' vn= term
							{
							match(input,174,FOLLOW_174_in_setOrMapLiteral8207); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral8211);
							kn=term();
							state._fsp--;

							match(input,177,FOLLOW_177_in_setOrMapLiteral8213); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral8217);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop153;
						}
					}

					 value = new Maps.Literal(m); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1254:7: ( ',' tn= term )*
					{
					 List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1255:11: ( ',' tn= term )*
					loop154:
					while (true) {
						int alt154=2;
						int LA154_0 = input.LA(1);
						if ( (LA154_0==174) ) {
							alt154=1;
						}

						switch (alt154) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1255:13: ',' tn= term
							{
							match(input,174,FOLLOW_174_in_setOrMapLiteral8252); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral8256);
							tn=term();
							state._fsp--;

							 s.add(tn); 
							}
							break;

						default :
							break loop154;
						}
					}

					 value = new Sets.Literal(s); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setOrMapLiteral"



	// $ANTLR start "collectionLiteral"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1259:1: collectionLiteral returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' );
	public final Term.Raw collectionLiteral() throws RecognitionException {
		Term.Raw value = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;
		Term.Raw t =null;
		Term.Raw v =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1260:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' )
			int alt158=3;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==184) ) {
				alt158=1;
			}
			else if ( (LA158_0==187) ) {
				int LA158_2 = input.LA(2);
				if ( (LA158_2==188) ) {
					alt158=3;
				}
				else if ( (LA158_2==BOOLEAN||LA158_2==FLOAT||LA158_2==HEXNUMBER||(LA158_2 >= IDENT && LA158_2 <= INTEGER)||(LA158_2 >= K_AGGREGATE && LA158_2 <= K_ALL)||LA158_2==K_AS||LA158_2==K_ASCII||(LA158_2 >= K_BIGINT && LA158_2 <= K_BOOLEAN)||(LA158_2 >= K_CALLED && LA158_2 <= K_CLUSTERING)||(LA158_2 >= K_COMPACT && LA158_2 <= K_COUNTER)||(LA158_2 >= K_CUSTOM && LA158_2 <= K_DECIMAL)||(LA158_2 >= K_DISTINCT && LA158_2 <= K_DOUBLE)||(LA158_2 >= K_EXISTS && LA158_2 <= K_FLOAT)||LA158_2==K_FROZEN||(LA158_2 >= K_FUNCTION && LA158_2 <= K_FUNCTIONS)||(LA158_2 >= K_INET && LA158_2 <= K_INPUT)||LA158_2==K_INT||(LA158_2 >= K_JSON && LA158_2 <= K_KEYS)||(LA158_2 >= K_KEYSPACES && LA158_2 <= K_LANGUAGE)||(LA158_2 >= K_LIST && LA158_2 <= K_MAP)||(LA158_2 >= K_NAN && LA158_2 <= K_NOLOGIN)||LA158_2==K_NOSUPERUSER||LA158_2==K_NULL||LA158_2==K_OPTIONS||(LA158_2 >= K_PASSWORD && LA158_2 <= K_PERMISSIONS)||LA158_2==K_RETURNS||(LA158_2 >= K_ROLE && LA158_2 <= K_ROLES)||(LA158_2 >= K_SFUNC && LA158_2 <= K_TINYINT)||(LA158_2 >= K_TOKEN && LA158_2 <= K_TRIGGER)||(LA158_2 >= K_TTL && LA158_2 <= K_TYPE)||(LA158_2 >= K_USER && LA158_2 <= K_USERS)||(LA158_2 >= K_UUID && LA158_2 <= K_VARINT)||LA158_2==K_WRITETIME||(LA158_2 >= QMARK && LA158_2 <= QUOTED_NAME)||LA158_2==STRING_LITERAL||LA158_2==UUID||LA158_2==171||LA158_2==175||LA158_2==177||LA158_2==184||LA158_2==187) ) {
					alt158=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 158, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 158, 0, input);
				throw nvae;
			}

			switch (alt158) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1260:7: '[' (t1= term ( ',' tn= term )* )? ']'
					{
					match(input,184,FOLLOW_184_in_collectionLiteral8290); 
					 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1261:11: (t1= term ( ',' tn= term )* )?
					int alt157=2;
					int LA157_0 = input.LA(1);
					if ( (LA157_0==BOOLEAN||LA157_0==FLOAT||LA157_0==HEXNUMBER||(LA157_0 >= IDENT && LA157_0 <= INTEGER)||(LA157_0 >= K_AGGREGATE && LA157_0 <= K_ALL)||LA157_0==K_AS||LA157_0==K_ASCII||(LA157_0 >= K_BIGINT && LA157_0 <= K_BOOLEAN)||(LA157_0 >= K_CALLED && LA157_0 <= K_CLUSTERING)||(LA157_0 >= K_COMPACT && LA157_0 <= K_COUNTER)||(LA157_0 >= K_CUSTOM && LA157_0 <= K_DECIMAL)||(LA157_0 >= K_DISTINCT && LA157_0 <= K_DOUBLE)||(LA157_0 >= K_EXISTS && LA157_0 <= K_FLOAT)||LA157_0==K_FROZEN||(LA157_0 >= K_FUNCTION && LA157_0 <= K_FUNCTIONS)||(LA157_0 >= K_INET && LA157_0 <= K_INPUT)||LA157_0==K_INT||(LA157_0 >= K_JSON && LA157_0 <= K_KEYS)||(LA157_0 >= K_KEYSPACES && LA157_0 <= K_LANGUAGE)||(LA157_0 >= K_LIST && LA157_0 <= K_MAP)||(LA157_0 >= K_NAN && LA157_0 <= K_NOLOGIN)||LA157_0==K_NOSUPERUSER||LA157_0==K_NULL||LA157_0==K_OPTIONS||(LA157_0 >= K_PASSWORD && LA157_0 <= K_PERMISSIONS)||LA157_0==K_RETURNS||(LA157_0 >= K_ROLE && LA157_0 <= K_ROLES)||(LA157_0 >= K_SFUNC && LA157_0 <= K_TINYINT)||(LA157_0 >= K_TOKEN && LA157_0 <= K_TRIGGER)||(LA157_0 >= K_TTL && LA157_0 <= K_TYPE)||(LA157_0 >= K_USER && LA157_0 <= K_USERS)||(LA157_0 >= K_UUID && LA157_0 <= K_VARINT)||LA157_0==K_WRITETIME||(LA157_0 >= QMARK && LA157_0 <= QUOTED_NAME)||LA157_0==STRING_LITERAL||LA157_0==UUID||LA157_0==171||LA157_0==175||LA157_0==177||LA157_0==184||LA157_0==187) ) {
						alt157=1;
					}
					switch (alt157) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1261:13: t1= term ( ',' tn= term )*
							{
							pushFollow(FOLLOW_term_in_collectionLiteral8308);
							t1=term();
							state._fsp--;

							 l.add(t1); 
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1261:36: ( ',' tn= term )*
							loop156:
							while (true) {
								int alt156=2;
								int LA156_0 = input.LA(1);
								if ( (LA156_0==174) ) {
									alt156=1;
								}

								switch (alt156) {
								case 1 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1261:38: ',' tn= term
									{
									match(input,174,FOLLOW_174_in_collectionLiteral8314); 
									pushFollow(FOLLOW_term_in_collectionLiteral8318);
									tn=term();
									state._fsp--;

									 l.add(tn); 
									}
									break;

								default :
									break loop156;
								}
							}

							}
							break;

					}

					match(input,186,FOLLOW_186_in_collectionLiteral8334); 
					 value = new Lists.Literal(l); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1263:7: '{' t= term v= setOrMapLiteral[t] '}'
					{
					match(input,187,FOLLOW_187_in_collectionLiteral8344); 
					pushFollow(FOLLOW_term_in_collectionLiteral8348);
					t=term();
					state._fsp--;

					pushFollow(FOLLOW_setOrMapLiteral_in_collectionLiteral8352);
					v=setOrMapLiteral(t);
					state._fsp--;

					 value = v; 
					match(input,188,FOLLOW_188_in_collectionLiteral8357); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1266:7: '{' '}'
					{
					match(input,187,FOLLOW_187_in_collectionLiteral8375); 
					match(input,188,FOLLOW_188_in_collectionLiteral8377); 
					 value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "collectionLiteral"



	// $ANTLR start "usertypeLiteral"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1269:1: usertypeLiteral returns [UserTypes.Literal ut] : '{' k1= noncol_ident ':' v1= term ( ',' kn= noncol_ident ':' vn= term )* '}' ;
	public final UserTypes.Literal usertypeLiteral() throws RecognitionException {
		UserTypes.Literal ut = null;


		ColumnIdentifier k1 =null;
		Term.Raw v1 =null;
		ColumnIdentifier kn =null;
		Term.Raw vn =null;

		 Map<ColumnIdentifier, Term.Raw> m = new HashMap<ColumnIdentifier, Term.Raw>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1273:5: ( '{' k1= noncol_ident ':' v1= term ( ',' kn= noncol_ident ':' vn= term )* '}' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1273:7: '{' k1= noncol_ident ':' v1= term ( ',' kn= noncol_ident ':' vn= term )* '}'
			{
			match(input,187,FOLLOW_187_in_usertypeLiteral8421); 
			pushFollow(FOLLOW_noncol_ident_in_usertypeLiteral8425);
			k1=noncol_ident();
			state._fsp--;

			match(input,177,FOLLOW_177_in_usertypeLiteral8427); 
			pushFollow(FOLLOW_term_in_usertypeLiteral8431);
			v1=term();
			state._fsp--;

			 m.put(k1, v1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1273:58: ( ',' kn= noncol_ident ':' vn= term )*
			loop159:
			while (true) {
				int alt159=2;
				int LA159_0 = input.LA(1);
				if ( (LA159_0==174) ) {
					alt159=1;
				}

				switch (alt159) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1273:60: ',' kn= noncol_ident ':' vn= term
					{
					match(input,174,FOLLOW_174_in_usertypeLiteral8437); 
					pushFollow(FOLLOW_noncol_ident_in_usertypeLiteral8441);
					kn=noncol_ident();
					state._fsp--;

					match(input,177,FOLLOW_177_in_usertypeLiteral8443); 
					pushFollow(FOLLOW_term_in_usertypeLiteral8447);
					vn=term();
					state._fsp--;

					 m.put(kn, vn); 
					}
					break;

				default :
					break loop159;
				}
			}

			match(input,188,FOLLOW_188_in_usertypeLiteral8454); 
			}

			 ut = new UserTypes.Literal(m); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ut;
	}
	// $ANTLR end "usertypeLiteral"



	// $ANTLR start "tupleLiteral"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1276:1: tupleLiteral returns [Tuples.Literal tt] : '(' t1= term ( ',' tn= term )* ')' ;
	public final Tuples.Literal tupleLiteral() throws RecognitionException {
		Tuples.Literal tt = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1279:5: ( '(' t1= term ( ',' tn= term )* ')' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1279:7: '(' t1= term ( ',' tn= term )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleLiteral8491); 
			pushFollow(FOLLOW_term_in_tupleLiteral8495);
			t1=term();
			state._fsp--;

			 l.add(t1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1279:34: ( ',' tn= term )*
			loop160:
			while (true) {
				int alt160=2;
				int LA160_0 = input.LA(1);
				if ( (LA160_0==174) ) {
					alt160=1;
				}

				switch (alt160) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1279:36: ',' tn= term
					{
					match(input,174,FOLLOW_174_in_tupleLiteral8501); 
					pushFollow(FOLLOW_term_in_tupleLiteral8505);
					tn=term();
					state._fsp--;

					 l.add(tn); 
					}
					break;

				default :
					break loop160;
				}
			}

			match(input,172,FOLLOW_172_in_tupleLiteral8512); 
			}

			 tt = new Tuples.Literal(l); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return tt;
	}
	// $ANTLR end "tupleLiteral"



	// $ANTLR start "value"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1282:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK );
	public final Term.Raw value() throws RecognitionException {
		Term.Raw value = null;


		Constants.Literal c =null;
		Term.Raw l =null;
		UserTypes.Literal u =null;
		Tuples.Literal t =null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1283:5: (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK )
			int alt161=7;
			alt161 = dfa161.predict(input);
			switch (alt161) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1283:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_value8535);
					c=constant();
					state._fsp--;

					 value = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1284:7: l= collectionLiteral
					{
					pushFollow(FOLLOW_collectionLiteral_in_value8557);
					l=collectionLiteral();
					state._fsp--;

					 value = l; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1285:7: u= usertypeLiteral
					{
					pushFollow(FOLLOW_usertypeLiteral_in_value8570);
					u=usertypeLiteral();
					state._fsp--;

					 value = u; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1286:7: t= tupleLiteral
					{
					pushFollow(FOLLOW_tupleLiteral_in_value8585);
					t=tupleLiteral();
					state._fsp--;

					 value = t; 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1287:7: K_NULL
					{
					match(input,K_NULL,FOLLOW_K_NULL_in_value8601); 
					 value = Constants.NULL_LITERAL; 
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1288:7: ':' id= noncol_ident
					{
					match(input,177,FOLLOW_177_in_value8625); 
					pushFollow(FOLLOW_noncol_ident_in_value8629);
					id=noncol_ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 7 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1289:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_value8640); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "value"



	// $ANTLR start "intValue"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1292:1: intValue returns [Term.Raw value] : (|t= INTEGER | ':' id= noncol_ident | QMARK );
	public final Term.Raw intValue() throws RecognitionException {
		Term.Raw value = null;


		Token t=null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1293:5: (|t= INTEGER | ':' id= noncol_ident | QMARK )
			int alt162=4;
			switch ( input.LA(1) ) {
			case EOF:
			case K_ALLOW:
			case K_AND:
			case K_APPLY:
			case K_DELETE:
			case K_INSERT:
			case K_SET:
			case K_UPDATE:
			case K_WHERE:
			case 178:
				{
				alt162=1;
				}
				break;
			case INTEGER:
				{
				alt162=2;
				}
				break;
			case 177:
				{
				alt162=3;
				}
				break;
			case QMARK:
				{
				alt162=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}
			switch (alt162) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1294:5: 
					{
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1294:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue8686); 
					 value = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1295:7: ':' id= noncol_ident
					{
					match(input,177,FOLLOW_177_in_intValue8700); 
					pushFollow(FOLLOW_noncol_ident_in_intValue8704);
					id=noncol_ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1296:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_intValue8715); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "intValue"



	// $ANTLR start "functionName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1299:1: functionName returns [FunctionName s] : (ks= keyspaceName '.' )? f= allowedFunctionName ;
	public final FunctionName functionName() throws RecognitionException {
		FunctionName s = null;


		String ks =null;
		String f =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1300:5: ( (ks= keyspaceName '.' )? f= allowedFunctionName )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1300:7: (ks= keyspaceName '.' )? f= allowedFunctionName
			{
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1300:7: (ks= keyspaceName '.' )?
			int alt163=2;
			alt163 = dfa163.predict(input);
			switch (alt163) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1300:8: ks= keyspaceName '.'
					{
					pushFollow(FOLLOW_keyspaceName_in_functionName8749);
					ks=keyspaceName();
					state._fsp--;

					match(input,176,FOLLOW_176_in_functionName8751); 
					}
					break;

			}

			pushFollow(FOLLOW_allowedFunctionName_in_functionName8757);
			f=allowedFunctionName();
			state._fsp--;

			 s = new FunctionName(ks, f); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "functionName"



	// $ANTLR start "allowedFunctionName"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1303:1: allowedFunctionName returns [String s] : (f= IDENT |f= QUOTED_NAME |u= unreserved_function_keyword | K_TOKEN | K_COUNT );
	public final String allowedFunctionName() throws RecognitionException {
		String s = null;


		Token f=null;
		String u =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1304:5: (f= IDENT |f= QUOTED_NAME |u= unreserved_function_keyword | K_TOKEN | K_COUNT )
			int alt164=5;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt164=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt164=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DATE:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FLOAT:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INET:
			case K_INITCOND:
			case K_INPUT:
			case K_INT:
			case K_JSON:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_SMALLINT:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIME:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TINYINT:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
				{
				alt164=3;
				}
				break;
			case K_TOKEN:
				{
				alt164=4;
				}
				break;
			case K_COUNT:
				{
				alt164=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 164, 0, input);
				throw nvae;
			}
			switch (alt164) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1304:7: f= IDENT
					{
					f=(Token)match(input,IDENT,FOLLOW_IDENT_in_allowedFunctionName8784); 
					 s = (f!=null?f.getText():null).toLowerCase(); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1305:7: f= QUOTED_NAME
					{
					f=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_allowedFunctionName8818); 
					 s = (f!=null?f.getText():null); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1306:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_allowedFunctionName8846);
					u=unreserved_function_keyword();
					state._fsp--;

					 s = u; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1307:7: K_TOKEN
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_allowedFunctionName8856); 
					 s = "token"; 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1308:7: K_COUNT
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_allowedFunctionName8888); 
					 s = "count"; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "allowedFunctionName"



	// $ANTLR start "function"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1311:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );
	public final Term.Raw function() throws RecognitionException {
		Term.Raw t = null;


		FunctionName f =null;
		List<Term.Raw> args =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1312:5: (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' )
			int alt165=2;
			alt165 = dfa165.predict(input);
			switch (alt165) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1312:7: f= functionName '(' ')'
					{
					pushFollow(FOLLOW_functionName_in_function8935);
					f=functionName();
					state._fsp--;

					match(input,171,FOLLOW_171_in_function8937); 
					match(input,172,FOLLOW_172_in_function8939); 
					 t = new FunctionCall.Raw(f, Collections.<Term.Raw>emptyList()); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1313:7: f= functionName '(' args= functionArgs ')'
					{
					pushFollow(FOLLOW_functionName_in_function8969);
					f=functionName();
					state._fsp--;

					match(input,171,FOLLOW_171_in_function8971); 
					pushFollow(FOLLOW_functionArgs_in_function8975);
					args=functionArgs();
					state._fsp--;

					match(input,172,FOLLOW_172_in_function8977); 
					 t = new FunctionCall.Raw(f, args); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "function"



	// $ANTLR start "functionArgs"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1316:1: functionArgs returns [List<Term.Raw> args] : t1= term ( ',' tn= term )* ;
	public final List<Term.Raw> functionArgs() throws RecognitionException {
		List<Term.Raw> args = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 args = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1318:5: (t1= term ( ',' tn= term )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1318:7: t1= term ( ',' tn= term )*
			{
			pushFollow(FOLLOW_term_in_functionArgs9010);
			t1=term();
			state._fsp--;

			args.add(t1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1318:32: ( ',' tn= term )*
			loop166:
			while (true) {
				int alt166=2;
				int LA166_0 = input.LA(1);
				if ( (LA166_0==174) ) {
					alt166=1;
				}

				switch (alt166) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1318:34: ',' tn= term
					{
					match(input,174,FOLLOW_174_in_functionArgs9016); 
					pushFollow(FOLLOW_term_in_functionArgs9020);
					tn=term();
					state._fsp--;

					 args.add(tn); 
					}
					break;

				default :
					break loop166;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return args;
	}
	// $ANTLR end "functionArgs"



	// $ANTLR start "term"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1321:1: term returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= term );
	public final Term.Raw term() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw v =null;
		Term.Raw f =null;
		CQL3Type.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1322:5: (v= value |f= function | '(' c= comparatorType ')' t= term )
			int alt167=3;
			alt167 = dfa167.predict(input);
			switch (alt167) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1322:7: v= value
					{
					pushFollow(FOLLOW_value_in_term9048);
					v=value();
					state._fsp--;

					 term = v; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1323:7: f= function
					{
					pushFollow(FOLLOW_function_in_term9085);
					f=function();
					state._fsp--;

					 term = f; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1324:7: '(' c= comparatorType ')' t= term
					{
					match(input,171,FOLLOW_171_in_term9117); 
					pushFollow(FOLLOW_comparatorType_in_term9121);
					c=comparatorType();
					state._fsp--;

					match(input,172,FOLLOW_172_in_term9123); 
					pushFollow(FOLLOW_term_in_term9127);
					t=term();
					state._fsp--;

					 term = new TypeCast(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "term"



	// $ANTLR start "columnOperation"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1327:1: columnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations] : key= cident columnOperationDifferentiator[operations, key] ;
	public final void columnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations) throws RecognitionException {
		ColumnIdentifier.Raw key =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1328:5: (key= cident columnOperationDifferentiator[operations, key] )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1328:7: key= cident columnOperationDifferentiator[operations, key]
			{
			pushFollow(FOLLOW_cident_in_columnOperation9150);
			key=cident();
			state._fsp--;

			pushFollow(FOLLOW_columnOperationDifferentiator_in_columnOperation9152);
			columnOperationDifferentiator(operations, key);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperation"



	// $ANTLR start "columnOperationDifferentiator"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1331:1: columnOperationDifferentiator[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] );
	public final void columnOperationDifferentiator(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Term.Raw k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1332:5: ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] )
			int alt168=2;
			int LA168_0 = input.LA(1);
			if ( (LA168_0==181) ) {
				alt168=1;
			}
			else if ( (LA168_0==184) ) {
				alt168=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 168, 0, input);
				throw nvae;
			}

			switch (alt168) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1332:7: '=' normalColumnOperation[operations, key]
					{
					match(input,181,FOLLOW_181_in_columnOperationDifferentiator9171); 
					pushFollow(FOLLOW_normalColumnOperation_in_columnOperationDifferentiator9173);
					normalColumnOperation(operations, key);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1333:7: '[' k= term ']' specializedColumnOperation[operations, key, k]
					{
					match(input,184,FOLLOW_184_in_columnOperationDifferentiator9182); 
					pushFollow(FOLLOW_term_in_columnOperationDifferentiator9186);
					k=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_columnOperationDifferentiator9188); 
					pushFollow(FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator9190);
					specializedColumnOperation(operations, key, k);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperationDifferentiator"



	// $ANTLR start "normalColumnOperation"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1336:1: normalColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );
	public final void normalColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Token sig=null;
		Token i=null;
		Term.Raw t =null;
		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1337:5: (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER )
			int alt170=3;
			alt170 = dfa170.predict(input);
			switch (alt170) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1337:7: t= term ( '+' c= cident )?
					{
					pushFollow(FOLLOW_term_in_normalColumnOperation9211);
					t=term();
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1337:14: ( '+' c= cident )?
					int alt169=2;
					int LA169_0 = input.LA(1);
					if ( (LA169_0==173) ) {
						alt169=1;
					}
					switch (alt169) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1337:15: '+' c= cident
							{
							match(input,173,FOLLOW_173_in_normalColumnOperation9214); 
							pushFollow(FOLLOW_cident_in_normalColumnOperation9218);
							c=cident();
							state._fsp--;

							}
							break;

					}


					          if (c == null)
					          {
					              addRawUpdate(operations, key, new Operation.SetValue(t));
					          }
					          else
					          {
					              if (!key.equals(c))
					                  addRecognitionError("Only expressions of the form X = <value> + X are supported.");
					              addRawUpdate(operations, key, new Operation.Prepend(t));
					          }
					      
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1350:7: c= cident sig= ( '+' | '-' ) t= term
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation9239);
					c=cident();
					state._fsp--;

					sig=input.LT(1);
					if ( input.LA(1)==173||input.LA(1)==175 ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_term_in_normalColumnOperation9253);
					t=term();
					state._fsp--;


					          if (!key.equals(c))
					              addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
					          addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
					      
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1356:7: c= cident i= INTEGER
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation9271);
					c=cident();
					state._fsp--;

					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_normalColumnOperation9275); 

					          // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
					          if (!key.equals(c))
					              // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
					              addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
					          addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "normalColumnOperation"



	// $ANTLR start "specializedColumnOperation"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1366:1: specializedColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k] : '=' t= term ;
	public final void specializedColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k) throws RecognitionException {
		Term.Raw t =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1367:5: ( '=' t= term )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1367:7: '=' t= term
			{
			match(input,181,FOLLOW_181_in_specializedColumnOperation9301); 
			pushFollow(FOLLOW_term_in_specializedColumnOperation9305);
			t=term();
			state._fsp--;


			          addRawUpdate(operations, key, new Operation.SetElement(k, t));
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "specializedColumnOperation"



	// $ANTLR start "columnCondition"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1373:1: columnCondition[List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) ;
	public final void columnCondition(List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions) throws RecognitionException {
		ColumnIdentifier.Raw key =null;
		Operator op =null;
		Term.Raw t =null;
		List<Term.Raw> values =null;
		AbstractMarker.INRaw marker =null;
		Term.Raw element =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1375:5: (key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1375:7: key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			{
			pushFollow(FOLLOW_cident_in_columnCondition9338);
			key=cident();
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1376:9: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			int alt174=3;
			switch ( input.LA(1) ) {
			case 170:
			case 179:
			case 180:
			case 181:
			case 182:
			case 183:
				{
				alt174=1;
				}
				break;
			case K_IN:
				{
				alt174=2;
				}
				break;
			case 184:
				{
				alt174=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 174, 0, input);
				throw nvae;
			}
			switch (alt174) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1376:11: op= relationType t= term
					{
					pushFollow(FOLLOW_relationType_in_columnCondition9352);
					op=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_columnCondition9356);
					t=term();
					state._fsp--;

					 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleCondition(t, op))); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1377:11: K_IN (values= singleColumnInValues |marker= inMarker )
					{
					match(input,K_IN,FOLLOW_K_IN_in_columnCondition9370); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1378:13: (values= singleColumnInValues |marker= inMarker )
					int alt171=2;
					int LA171_0 = input.LA(1);
					if ( (LA171_0==171) ) {
						alt171=1;
					}
					else if ( (LA171_0==QMARK||LA171_0==177) ) {
						alt171=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 171, 0, input);
						throw nvae;
					}

					switch (alt171) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1378:15: values= singleColumnInValues
							{
							pushFollow(FOLLOW_singleColumnInValues_in_columnCondition9388);
							values=singleColumnInValues();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(values))); 
							}
							break;
						case 2 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1379:15: marker= inMarker
							{
							pushFollow(FOLLOW_inMarker_in_columnCondition9408);
							marker=inMarker();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(marker))); 
							}
							break;

					}

					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1381:11: '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					{
					match(input,184,FOLLOW_184_in_columnCondition9436); 
					pushFollow(FOLLOW_term_in_columnCondition9440);
					element=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_columnCondition9442); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1382:13: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					int alt173=2;
					int LA173_0 = input.LA(1);
					if ( (LA173_0==170||(LA173_0 >= 179 && LA173_0 <= 183)) ) {
						alt173=1;
					}
					else if ( (LA173_0==K_IN) ) {
						alt173=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 173, 0, input);
						throw nvae;
					}

					switch (alt173) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1382:15: op= relationType t= term
							{
							pushFollow(FOLLOW_relationType_in_columnCondition9460);
							op=relationType();
							state._fsp--;

							pushFollow(FOLLOW_term_in_columnCondition9464);
							t=term();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionCondition(t, element, op))); 
							}
							break;
						case 2 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1383:15: K_IN (values= singleColumnInValues |marker= inMarker )
							{
							match(input,K_IN,FOLLOW_K_IN_in_columnCondition9482); 
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1384:17: (values= singleColumnInValues |marker= inMarker )
							int alt172=2;
							int LA172_0 = input.LA(1);
							if ( (LA172_0==171) ) {
								alt172=1;
							}
							else if ( (LA172_0==QMARK||LA172_0==177) ) {
								alt172=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 172, 0, input);
								throw nvae;
							}

							switch (alt172) {
								case 1 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1384:19: values= singleColumnInValues
									{
									pushFollow(FOLLOW_singleColumnInValues_in_columnCondition9504);
									values=singleColumnInValues();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, values))); 
									}
									break;
								case 2 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1385:19: marker= inMarker
									{
									pushFollow(FOLLOW_inMarker_in_columnCondition9528);
									marker=inMarker();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, marker))); 
									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnCondition"



	// $ANTLR start "properties"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1391:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
	public final void properties(PropertyDefinitions props) throws RecognitionException {
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1392:5: ( property[props] ( K_AND property[props] )* )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1392:7: property[props] ( K_AND property[props] )*
			{
			pushFollow(FOLLOW_property_in_properties9590);
			property(props);
			state._fsp--;

			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1392:23: ( K_AND property[props] )*
			loop175:
			while (true) {
				int alt175=2;
				int LA175_0 = input.LA(1);
				if ( (LA175_0==K_AND) ) {
					alt175=1;
				}

				switch (alt175) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1392:24: K_AND property[props]
					{
					match(input,K_AND,FOLLOW_K_AND_in_properties9594); 
					pushFollow(FOLLOW_property_in_properties9596);
					property(props);
					state._fsp--;

					}
					break;

				default :
					break loop175;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "properties"



	// $ANTLR start "property"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1395:1: property[PropertyDefinitions props] : (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= mapLiteral );
	public final void property(PropertyDefinitions props) throws RecognitionException {
		ColumnIdentifier k =null;
		String simple =null;
		Maps.Literal map =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1396:5: (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= mapLiteral )
			int alt176=2;
			alt176 = dfa176.predict(input);
			switch (alt176) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1396:7: k= noncol_ident '=' simple= propertyValue
					{
					pushFollow(FOLLOW_noncol_ident_in_property9619);
					k=noncol_ident();
					state._fsp--;

					match(input,181,FOLLOW_181_in_property9621); 
					pushFollow(FOLLOW_propertyValue_in_property9625);
					simple=propertyValue();
					state._fsp--;

					 try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1397:7: k= noncol_ident '=' map= mapLiteral
					{
					pushFollow(FOLLOW_noncol_ident_in_property9637);
					k=noncol_ident();
					state._fsp--;

					match(input,181,FOLLOW_181_in_property9639); 
					pushFollow(FOLLOW_mapLiteral_in_property9643);
					map=mapLiteral();
					state._fsp--;

					 try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"



	// $ANTLR start "propertyValue"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1400:1: propertyValue returns [String str] : (c= constant |u= unreserved_keyword );
	public final String propertyValue() throws RecognitionException {
		String str = null;


		Constants.Literal c =null;
		String u =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1401:5: (c= constant |u= unreserved_keyword )
			int alt177=2;
			int LA177_0 = input.LA(1);
			if ( (LA177_0==BOOLEAN||LA177_0==FLOAT||LA177_0==HEXNUMBER||LA177_0==INTEGER||LA177_0==K_INFINITY||LA177_0==K_NAN||LA177_0==STRING_LITERAL||LA177_0==UUID||LA177_0==175) ) {
				alt177=1;
			}
			else if ( ((LA177_0 >= K_AGGREGATE && LA177_0 <= K_ALL)||LA177_0==K_AS||LA177_0==K_ASCII||(LA177_0 >= K_BIGINT && LA177_0 <= K_BOOLEAN)||(LA177_0 >= K_CALLED && LA177_0 <= K_CLUSTERING)||(LA177_0 >= K_COMPACT && LA177_0 <= K_COUNTER)||(LA177_0 >= K_CUSTOM && LA177_0 <= K_DECIMAL)||(LA177_0 >= K_DISTINCT && LA177_0 <= K_DOUBLE)||(LA177_0 >= K_EXISTS && LA177_0 <= K_FLOAT)||LA177_0==K_FROZEN||(LA177_0 >= K_FUNCTION && LA177_0 <= K_FUNCTIONS)||LA177_0==K_INET||(LA177_0 >= K_INITCOND && LA177_0 <= K_INPUT)||LA177_0==K_INT||(LA177_0 >= K_JSON && LA177_0 <= K_KEYS)||(LA177_0 >= K_KEYSPACES && LA177_0 <= K_LANGUAGE)||(LA177_0 >= K_LIST && LA177_0 <= K_MAP)||LA177_0==K_NOLOGIN||LA177_0==K_NOSUPERUSER||LA177_0==K_OPTIONS||(LA177_0 >= K_PASSWORD && LA177_0 <= K_PERMISSIONS)||LA177_0==K_RETURNS||(LA177_0 >= K_ROLE && LA177_0 <= K_ROLES)||(LA177_0 >= K_SFUNC && LA177_0 <= K_TINYINT)||LA177_0==K_TRIGGER||(LA177_0 >= K_TTL && LA177_0 <= K_TYPE)||(LA177_0 >= K_USER && LA177_0 <= K_USERS)||(LA177_0 >= K_UUID && LA177_0 <= K_VARINT)||LA177_0==K_WRITETIME) ) {
				alt177=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 177, 0, input);
				throw nvae;
			}

			switch (alt177) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1401:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_propertyValue9668);
					c=constant();
					state._fsp--;

					 str = c.getRawText(); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1402:7: u= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_propertyValue9690);
					u=unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "propertyValue"



	// $ANTLR start "relationType"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1405:1: relationType returns [Operator op] : ( '=' | '<' | '<=' | '>' | '>=' | '!=' );
	public final Operator relationType() throws RecognitionException {
		Operator op = null;


		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1406:5: ( '=' | '<' | '<=' | '>' | '>=' | '!=' )
			int alt178=6;
			switch ( input.LA(1) ) {
			case 181:
				{
				alt178=1;
				}
				break;
			case 179:
				{
				alt178=2;
				}
				break;
			case 180:
				{
				alt178=3;
				}
				break;
			case 182:
				{
				alt178=4;
				}
				break;
			case 183:
				{
				alt178=5;
				}
				break;
			case 170:
				{
				alt178=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 178, 0, input);
				throw nvae;
			}
			switch (alt178) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1406:7: '='
					{
					match(input,181,FOLLOW_181_in_relationType9713); 
					 op = Operator.EQ; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1407:7: '<'
					{
					match(input,179,FOLLOW_179_in_relationType9724); 
					 op = Operator.LT; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1408:7: '<='
					{
					match(input,180,FOLLOW_180_in_relationType9735); 
					 op = Operator.LTE; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1409:7: '>'
					{
					match(input,182,FOLLOW_182_in_relationType9745); 
					 op = Operator.GT; 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1410:7: '>='
					{
					match(input,183,FOLLOW_183_in_relationType9756); 
					 op = Operator.GTE; 
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1411:7: '!='
					{
					match(input,170,FOLLOW_170_in_relationType9766); 
					 op = Operator.NEQ; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "relationType"



	// $ANTLR start "relation"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1414:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );
	public final void relation(List<Relation> clauses) throws RecognitionException {
		ColumnIdentifier.Raw name =null;
		Operator type =null;
		Term.Raw t =null;
		List<ColumnIdentifier.Raw> l =null;
		AbstractMarker.INRaw marker =null;
		List<Term.Raw> inValues =null;
		Term.Raw key =null;
		List<ColumnIdentifier.Raw> ids =null;
		Tuples.INRaw tupleInMarker =null;
		List<Tuples.Literal> literals =null;
		List<Tuples.Raw> markers =null;
		Tuples.Literal literal =null;
		Tuples.Raw tupleMarker =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1415:5: (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' )
			int alt182=8;
			alt182 = dfa182.predict(input);
			switch (alt182) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1415:7: name= cident type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation9788);
					name=cident();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation9792);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation9796);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, type, t)); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1416:7: K_TOKEN l= tupleOfIdentifiers type= relationType t= term
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation9806); 
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation9810);
					l=tupleOfIdentifiers();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation9814);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation9818);
					t=term();
					state._fsp--;

					 clauses.add(new TokenRelation(l, type, t)); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1418:7: name= cident K_IN marker= inMarker
					{
					pushFollow(FOLLOW_cident_in_relation9838);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation9840); 
					pushFollow(FOLLOW_inMarker_in_relation9844);
					marker=inMarker();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, Operator.IN, marker)); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1420:7: name= cident K_IN inValues= singleColumnInValues
					{
					pushFollow(FOLLOW_cident_in_relation9864);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation9866); 
					pushFollow(FOLLOW_singleColumnInValues_in_relation9870);
					inValues=singleColumnInValues();
					state._fsp--;

					 clauses.add(SingleColumnRelation.createInRelation(name, inValues)); 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1422:7: name= cident K_CONTAINS ( K_KEY )? t= term
					{
					pushFollow(FOLLOW_cident_in_relation9890);
					name=cident();
					state._fsp--;

					match(input,K_CONTAINS,FOLLOW_K_CONTAINS_in_relation9892); 
					 Operator rt = Operator.CONTAINS; 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1422:67: ( K_KEY )?
					int alt179=2;
					int LA179_0 = input.LA(1);
					if ( (LA179_0==K_KEY) ) {
						int LA179_1 = input.LA(2);
						if ( (LA179_1==BOOLEAN||LA179_1==FLOAT||LA179_1==HEXNUMBER||(LA179_1 >= IDENT && LA179_1 <= INTEGER)||(LA179_1 >= K_AGGREGATE && LA179_1 <= K_ALL)||LA179_1==K_AS||LA179_1==K_ASCII||(LA179_1 >= K_BIGINT && LA179_1 <= K_BOOLEAN)||(LA179_1 >= K_CALLED && LA179_1 <= K_CLUSTERING)||(LA179_1 >= K_COMPACT && LA179_1 <= K_COUNTER)||(LA179_1 >= K_CUSTOM && LA179_1 <= K_DECIMAL)||(LA179_1 >= K_DISTINCT && LA179_1 <= K_DOUBLE)||(LA179_1 >= K_EXISTS && LA179_1 <= K_FLOAT)||LA179_1==K_FROZEN||(LA179_1 >= K_FUNCTION && LA179_1 <= K_FUNCTIONS)||(LA179_1 >= K_INET && LA179_1 <= K_INPUT)||LA179_1==K_INT||(LA179_1 >= K_JSON && LA179_1 <= K_KEYS)||(LA179_1 >= K_KEYSPACES && LA179_1 <= K_LANGUAGE)||(LA179_1 >= K_LIST && LA179_1 <= K_MAP)||(LA179_1 >= K_NAN && LA179_1 <= K_NOLOGIN)||LA179_1==K_NOSUPERUSER||LA179_1==K_NULL||LA179_1==K_OPTIONS||(LA179_1 >= K_PASSWORD && LA179_1 <= K_PERMISSIONS)||LA179_1==K_RETURNS||(LA179_1 >= K_ROLE && LA179_1 <= K_ROLES)||(LA179_1 >= K_SFUNC && LA179_1 <= K_TINYINT)||(LA179_1 >= K_TOKEN && LA179_1 <= K_TRIGGER)||(LA179_1 >= K_TTL && LA179_1 <= K_TYPE)||(LA179_1 >= K_USER && LA179_1 <= K_USERS)||(LA179_1 >= K_UUID && LA179_1 <= K_VARINT)||LA179_1==K_WRITETIME||(LA179_1 >= QMARK && LA179_1 <= QUOTED_NAME)||LA179_1==STRING_LITERAL||LA179_1==UUID||LA179_1==171||LA179_1==175||LA179_1==177||LA179_1==184||LA179_1==187) ) {
							alt179=1;
						}
					}
					switch (alt179) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1422:68: K_KEY
							{
							match(input,K_KEY,FOLLOW_K_KEY_in_relation9897); 
							 rt = Operator.CONTAINS_KEY; 
							}
							break;

					}

					pushFollow(FOLLOW_term_in_relation9913);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, rt, t)); 
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1424:7: name= cident '[' key= term ']' type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation9925);
					name=cident();
					state._fsp--;

					match(input,184,FOLLOW_184_in_relation9927); 
					pushFollow(FOLLOW_term_in_relation9931);
					key=term();
					state._fsp--;

					match(input,186,FOLLOW_186_in_relation9933); 
					pushFollow(FOLLOW_relationType_in_relation9937);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation9941);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, key, type, t)); 
					}
					break;
				case 7 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1425:7: ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					{
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation9953);
					ids=tupleOfIdentifiers();
					state._fsp--;

					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1426:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					int alt181=3;
					alt181 = dfa181.predict(input);
					switch (alt181) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1426:9: K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							{
							match(input,K_IN,FOLLOW_K_IN_in_relation9963); 
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1427:11: ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							int alt180=4;
							int LA180_0 = input.LA(1);
							if ( (LA180_0==171) ) {
								switch ( input.LA(2) ) {
								case 172:
									{
									alt180=1;
									}
									break;
								case 171:
									{
									alt180=3;
									}
									break;
								case QMARK:
								case 177:
									{
									alt180=4;
									}
									break;
								default:
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 180, 1, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}
							else if ( (LA180_0==QMARK||LA180_0==177) ) {
								alt180=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 180, 0, input);
								throw nvae;
							}

							switch (alt180) {
								case 1 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1427:13: '(' ')'
									{
									match(input,171,FOLLOW_171_in_relation9977); 
									match(input,172,FOLLOW_172_in_relation9979); 
									 clauses.add(MultiColumnRelation.createInRelation(ids, new ArrayList<Tuples.Literal>())); 
									}
									break;
								case 2 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1429:13: tupleInMarker= inMarkerForTuple
									{
									pushFollow(FOLLOW_inMarkerForTuple_in_relation10011);
									tupleInMarker=inMarkerForTuple();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createSingleMarkerInRelation(ids, tupleInMarker)); 
									}
									break;
								case 3 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1431:13: literals= tupleOfTupleLiterals
									{
									pushFollow(FOLLOW_tupleOfTupleLiterals_in_relation10045);
									literals=tupleOfTupleLiterals();
									state._fsp--;


									                  clauses.add(MultiColumnRelation.createInRelation(ids, literals));
									              
									}
									break;
								case 4 :
									// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1435:13: markers= tupleOfMarkersForTuples
									{
									pushFollow(FOLLOW_tupleOfMarkersForTuples_in_relation10079);
									markers=tupleOfMarkersForTuples();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createInRelation(ids, markers)); 
									}
									break;

							}

							}
							break;
						case 2 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1438:9: type= relationType literal= tupleLiteral
							{
							pushFollow(FOLLOW_relationType_in_relation10121);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_tupleLiteral_in_relation10125);
							literal=tupleLiteral();
							state._fsp--;


							              clauses.add(MultiColumnRelation.createNonInRelation(ids, type, literal));
							          
							}
							break;
						case 3 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1442:9: type= relationType tupleMarker= markerForTuple
							{
							pushFollow(FOLLOW_relationType_in_relation10151);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_markerForTuple_in_relation10155);
							tupleMarker=markerForTuple();
							state._fsp--;

							 clauses.add(MultiColumnRelation.createNonInRelation(ids, type, tupleMarker)); 
							}
							break;

					}

					}
					break;
				case 8 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1445:7: '(' relation[$clauses] ')'
					{
					match(input,171,FOLLOW_171_in_relation10185); 
					pushFollow(FOLLOW_relation_in_relation10187);
					relation(clauses);
					state._fsp--;

					match(input,172,FOLLOW_172_in_relation10190); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "relation"



	// $ANTLR start "inMarker"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1448:1: inMarker returns [AbstractMarker.INRaw marker] : ( QMARK | ':' name= noncol_ident );
	public final AbstractMarker.INRaw inMarker() throws RecognitionException {
		AbstractMarker.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1449:5: ( QMARK | ':' name= noncol_ident )
			int alt183=2;
			int LA183_0 = input.LA(1);
			if ( (LA183_0==QMARK) ) {
				alt183=1;
			}
			else if ( (LA183_0==177) ) {
				alt183=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 183, 0, input);
				throw nvae;
			}

			switch (alt183) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1449:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarker10211); 
					 marker = newINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1450:7: ':' name= noncol_ident
					{
					match(input,177,FOLLOW_177_in_inMarker10221); 
					pushFollow(FOLLOW_noncol_ident_in_inMarker10225);
					name=noncol_ident();
					state._fsp--;

					 marker = newINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarker"



	// $ANTLR start "tupleOfIdentifiers"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1453:1: tupleOfIdentifiers returns [List<ColumnIdentifier.Raw> ids] : '(' n1= cident ( ',' ni= cident )* ')' ;
	public final List<ColumnIdentifier.Raw> tupleOfIdentifiers() throws RecognitionException {
		List<ColumnIdentifier.Raw> ids = null;


		ColumnIdentifier.Raw n1 =null;
		ColumnIdentifier.Raw ni =null;

		 ids = new ArrayList<ColumnIdentifier.Raw>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1455:5: ( '(' n1= cident ( ',' ni= cident )* ')' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1455:7: '(' n1= cident ( ',' ni= cident )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleOfIdentifiers10257); 
			pushFollow(FOLLOW_cident_in_tupleOfIdentifiers10261);
			n1=cident();
			state._fsp--;

			 ids.add(n1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1455:39: ( ',' ni= cident )*
			loop184:
			while (true) {
				int alt184=2;
				int LA184_0 = input.LA(1);
				if ( (LA184_0==174) ) {
					alt184=1;
				}

				switch (alt184) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1455:40: ',' ni= cident
					{
					match(input,174,FOLLOW_174_in_tupleOfIdentifiers10266); 
					pushFollow(FOLLOW_cident_in_tupleOfIdentifiers10270);
					ni=cident();
					state._fsp--;

					 ids.add(ni); 
					}
					break;

				default :
					break loop184;
				}
			}

			match(input,172,FOLLOW_172_in_tupleOfIdentifiers10276); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ids;
	}
	// $ANTLR end "tupleOfIdentifiers"



	// $ANTLR start "singleColumnInValues"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1458:1: singleColumnInValues returns [List<Term.Raw> terms] : '(' (t1= term ( ',' ti= term )* )? ')' ;
	public final List<Term.Raw> singleColumnInValues() throws RecognitionException {
		List<Term.Raw> terms = null;


		Term.Raw t1 =null;
		Term.Raw ti =null;

		 terms = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1460:5: ( '(' (t1= term ( ',' ti= term )* )? ')' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1460:7: '(' (t1= term ( ',' ti= term )* )? ')'
			{
			match(input,171,FOLLOW_171_in_singleColumnInValues10306); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1460:11: (t1= term ( ',' ti= term )* )?
			int alt186=2;
			int LA186_0 = input.LA(1);
			if ( (LA186_0==BOOLEAN||LA186_0==FLOAT||LA186_0==HEXNUMBER||(LA186_0 >= IDENT && LA186_0 <= INTEGER)||(LA186_0 >= K_AGGREGATE && LA186_0 <= K_ALL)||LA186_0==K_AS||LA186_0==K_ASCII||(LA186_0 >= K_BIGINT && LA186_0 <= K_BOOLEAN)||(LA186_0 >= K_CALLED && LA186_0 <= K_CLUSTERING)||(LA186_0 >= K_COMPACT && LA186_0 <= K_COUNTER)||(LA186_0 >= K_CUSTOM && LA186_0 <= K_DECIMAL)||(LA186_0 >= K_DISTINCT && LA186_0 <= K_DOUBLE)||(LA186_0 >= K_EXISTS && LA186_0 <= K_FLOAT)||LA186_0==K_FROZEN||(LA186_0 >= K_FUNCTION && LA186_0 <= K_FUNCTIONS)||(LA186_0 >= K_INET && LA186_0 <= K_INPUT)||LA186_0==K_INT||(LA186_0 >= K_JSON && LA186_0 <= K_KEYS)||(LA186_0 >= K_KEYSPACES && LA186_0 <= K_LANGUAGE)||(LA186_0 >= K_LIST && LA186_0 <= K_MAP)||(LA186_0 >= K_NAN && LA186_0 <= K_NOLOGIN)||LA186_0==K_NOSUPERUSER||LA186_0==K_NULL||LA186_0==K_OPTIONS||(LA186_0 >= K_PASSWORD && LA186_0 <= K_PERMISSIONS)||LA186_0==K_RETURNS||(LA186_0 >= K_ROLE && LA186_0 <= K_ROLES)||(LA186_0 >= K_SFUNC && LA186_0 <= K_TINYINT)||(LA186_0 >= K_TOKEN && LA186_0 <= K_TRIGGER)||(LA186_0 >= K_TTL && LA186_0 <= K_TYPE)||(LA186_0 >= K_USER && LA186_0 <= K_USERS)||(LA186_0 >= K_UUID && LA186_0 <= K_VARINT)||LA186_0==K_WRITETIME||(LA186_0 >= QMARK && LA186_0 <= QUOTED_NAME)||LA186_0==STRING_LITERAL||LA186_0==UUID||LA186_0==171||LA186_0==175||LA186_0==177||LA186_0==184||LA186_0==187) ) {
				alt186=1;
			}
			switch (alt186) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1460:13: t1= term ( ',' ti= term )*
					{
					pushFollow(FOLLOW_term_in_singleColumnInValues10314);
					t1=term();
					state._fsp--;

					 terms.add(t1); 
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1460:43: ( ',' ti= term )*
					loop185:
					while (true) {
						int alt185=2;
						int LA185_0 = input.LA(1);
						if ( (LA185_0==174) ) {
							alt185=1;
						}

						switch (alt185) {
						case 1 :
							// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1460:44: ',' ti= term
							{
							match(input,174,FOLLOW_174_in_singleColumnInValues10319); 
							pushFollow(FOLLOW_term_in_singleColumnInValues10323);
							ti=term();
							state._fsp--;

							 terms.add(ti); 
							}
							break;

						default :
							break loop185;
						}
					}

					}
					break;

			}

			match(input,172,FOLLOW_172_in_singleColumnInValues10332); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return terms;
	}
	// $ANTLR end "singleColumnInValues"



	// $ANTLR start "tupleOfTupleLiterals"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1463:1: tupleOfTupleLiterals returns [List<Tuples.Literal> literals] : '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' ;
	public final List<Tuples.Literal> tupleOfTupleLiterals() throws RecognitionException {
		List<Tuples.Literal> literals = null;


		Tuples.Literal t1 =null;
		Tuples.Literal ti =null;

		 literals = new ArrayList<>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1465:5: ( '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1465:7: '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleOfTupleLiterals10362); 
			pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10366);
			t1=tupleLiteral();
			state._fsp--;

			 literals.add(t1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1465:50: ( ',' ti= tupleLiteral )*
			loop187:
			while (true) {
				int alt187=2;
				int LA187_0 = input.LA(1);
				if ( (LA187_0==174) ) {
					alt187=1;
				}

				switch (alt187) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1465:51: ',' ti= tupleLiteral
					{
					match(input,174,FOLLOW_174_in_tupleOfTupleLiterals10371); 
					pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10375);
					ti=tupleLiteral();
					state._fsp--;

					 literals.add(ti); 
					}
					break;

				default :
					break loop187;
				}
			}

			match(input,172,FOLLOW_172_in_tupleOfTupleLiterals10381); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return literals;
	}
	// $ANTLR end "tupleOfTupleLiterals"



	// $ANTLR start "markerForTuple"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1468:1: markerForTuple returns [Tuples.Raw marker] : ( QMARK | ':' name= noncol_ident );
	public final Tuples.Raw markerForTuple() throws RecognitionException {
		Tuples.Raw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1469:5: ( QMARK | ':' name= noncol_ident )
			int alt188=2;
			int LA188_0 = input.LA(1);
			if ( (LA188_0==QMARK) ) {
				alt188=1;
			}
			else if ( (LA188_0==177) ) {
				alt188=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 188, 0, input);
				throw nvae;
			}

			switch (alt188) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1469:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_markerForTuple10402); 
					 marker = newTupleBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1470:7: ':' name= noncol_ident
					{
					match(input,177,FOLLOW_177_in_markerForTuple10412); 
					pushFollow(FOLLOW_noncol_ident_in_markerForTuple10416);
					name=noncol_ident();
					state._fsp--;

					 marker = newTupleBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "markerForTuple"



	// $ANTLR start "tupleOfMarkersForTuples"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1473:1: tupleOfMarkersForTuples returns [List<Tuples.Raw> markers] : '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' ;
	public final List<Tuples.Raw> tupleOfMarkersForTuples() throws RecognitionException {
		List<Tuples.Raw> markers = null;


		Tuples.Raw m1 =null;
		Tuples.Raw mi =null;

		 markers = new ArrayList<Tuples.Raw>(); 
		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1475:5: ( '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1475:7: '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')'
			{
			match(input,171,FOLLOW_171_in_tupleOfMarkersForTuples10448); 
			pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10452);
			m1=markerForTuple();
			state._fsp--;

			 markers.add(m1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1475:51: ( ',' mi= markerForTuple )*
			loop189:
			while (true) {
				int alt189=2;
				int LA189_0 = input.LA(1);
				if ( (LA189_0==174) ) {
					alt189=1;
				}

				switch (alt189) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1475:52: ',' mi= markerForTuple
					{
					match(input,174,FOLLOW_174_in_tupleOfMarkersForTuples10457); 
					pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10461);
					mi=markerForTuple();
					state._fsp--;

					 markers.add(mi); 
					}
					break;

				default :
					break loop189;
				}
			}

			match(input,172,FOLLOW_172_in_tupleOfMarkersForTuples10467); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return markers;
	}
	// $ANTLR end "tupleOfMarkersForTuples"



	// $ANTLR start "inMarkerForTuple"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1478:1: inMarkerForTuple returns [Tuples.INRaw marker] : ( QMARK | ':' name= noncol_ident );
	public final Tuples.INRaw inMarkerForTuple() throws RecognitionException {
		Tuples.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1479:5: ( QMARK | ':' name= noncol_ident )
			int alt190=2;
			int LA190_0 = input.LA(1);
			if ( (LA190_0==QMARK) ) {
				alt190=1;
			}
			else if ( (LA190_0==177) ) {
				alt190=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 190, 0, input);
				throw nvae;
			}

			switch (alt190) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1479:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarkerForTuple10488); 
					 marker = newTupleINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1480:7: ':' name= noncol_ident
					{
					match(input,177,FOLLOW_177_in_inMarkerForTuple10498); 
					pushFollow(FOLLOW_noncol_ident_in_inMarkerForTuple10502);
					name=noncol_ident();
					state._fsp--;

					 marker = newTupleINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarkerForTuple"



	// $ANTLR start "comparatorType"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1483:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );
	public final CQL3Type.Raw comparatorType() throws RecognitionException {
		CQL3Type.Raw t = null;


		Token s=null;
		CQL3Type n =null;
		CQL3Type.Raw c =null;
		CQL3Type.Raw tt =null;
		UTName id =null;
		CQL3Type.Raw f =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1484:5: (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL )
			int alt191=6;
			alt191 = dfa191.predict(input);
			switch (alt191) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1484:7: n= native_type
					{
					pushFollow(FOLLOW_native_type_in_comparatorType10527);
					n=native_type();
					state._fsp--;

					 t = CQL3Type.Raw.from(n); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1485:7: c= collection_type
					{
					pushFollow(FOLLOW_collection_type_in_comparatorType10543);
					c=collection_type();
					state._fsp--;

					 t = c; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1486:7: tt= tuple_type
					{
					pushFollow(FOLLOW_tuple_type_in_comparatorType10555);
					tt=tuple_type();
					state._fsp--;

					 t = tt; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1487:7: id= userTypeName
					{
					pushFollow(FOLLOW_userTypeName_in_comparatorType10571);
					id=userTypeName();
					state._fsp--;

					 t = CQL3Type.Raw.userType(id); 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1488:7: K_FROZEN '<' f= comparatorType '>'
					{
					match(input,K_FROZEN,FOLLOW_K_FROZEN_in_comparatorType10583); 
					match(input,179,FOLLOW_179_in_comparatorType10585); 
					pushFollow(FOLLOW_comparatorType_in_comparatorType10589);
					f=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_comparatorType10591); 

					        try {
					            t = CQL3Type.Raw.frozen(f);
					        } catch (InvalidRequestException e) {
					            addRecognitionError(e.getMessage());
					        }
					      
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1496:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType10609); 

					        try {
					            t = CQL3Type.Raw.from(new CQL3Type.Custom((s!=null?s.getText():null)));
					        } catch (SyntaxException e) {
					            addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        } catch (ConfigurationException e) {
					            addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        }
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "comparatorType"



	// $ANTLR start "native_type"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1508:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_SMALLINT | K_TEXT | K_TIMESTAMP | K_TINYINT | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID | K_DATE | K_TIME );
	public final CQL3Type native_type() throws RecognitionException {
		CQL3Type t = null;


		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1509:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_SMALLINT | K_TEXT | K_TIMESTAMP | K_TINYINT | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID | K_DATE | K_TIME )
			int alt192=20;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				alt192=1;
				}
				break;
			case K_BIGINT:
				{
				alt192=2;
				}
				break;
			case K_BLOB:
				{
				alt192=3;
				}
				break;
			case K_BOOLEAN:
				{
				alt192=4;
				}
				break;
			case K_COUNTER:
				{
				alt192=5;
				}
				break;
			case K_DECIMAL:
				{
				alt192=6;
				}
				break;
			case K_DOUBLE:
				{
				alt192=7;
				}
				break;
			case K_FLOAT:
				{
				alt192=8;
				}
				break;
			case K_INET:
				{
				alt192=9;
				}
				break;
			case K_INT:
				{
				alt192=10;
				}
				break;
			case K_SMALLINT:
				{
				alt192=11;
				}
				break;
			case K_TEXT:
				{
				alt192=12;
				}
				break;
			case K_TIMESTAMP:
				{
				alt192=13;
				}
				break;
			case K_TINYINT:
				{
				alt192=14;
				}
				break;
			case K_UUID:
				{
				alt192=15;
				}
				break;
			case K_VARCHAR:
				{
				alt192=16;
				}
				break;
			case K_VARINT:
				{
				alt192=17;
				}
				break;
			case K_TIMEUUID:
				{
				alt192=18;
				}
				break;
			case K_DATE:
				{
				alt192=19;
				}
				break;
			case K_TIME:
				{
				alt192=20;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 192, 0, input);
				throw nvae;
			}
			switch (alt192) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1509:7: K_ASCII
					{
					match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type10638); 
					 t = CQL3Type.Native.ASCII; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1510:7: K_BIGINT
					{
					match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type10652); 
					 t = CQL3Type.Native.BIGINT; 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1511:7: K_BLOB
					{
					match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type10665); 
					 t = CQL3Type.Native.BLOB; 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1512:7: K_BOOLEAN
					{
					match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type10680); 
					 t = CQL3Type.Native.BOOLEAN; 
					}
					break;
				case 5 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1513:7: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type10692); 
					 t = CQL3Type.Native.COUNTER; 
					}
					break;
				case 6 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1514:7: K_DECIMAL
					{
					match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type10704); 
					 t = CQL3Type.Native.DECIMAL; 
					}
					break;
				case 7 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1515:7: K_DOUBLE
					{
					match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type10716); 
					 t = CQL3Type.Native.DOUBLE; 
					}
					break;
				case 8 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1516:7: K_FLOAT
					{
					match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type10729); 
					 t = CQL3Type.Native.FLOAT; 
					}
					break;
				case 9 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1517:7: K_INET
					{
					match(input,K_INET,FOLLOW_K_INET_in_native_type10743); 
					 t = CQL3Type.Native.INET;
					}
					break;
				case 10 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1518:7: K_INT
					{
					match(input,K_INT,FOLLOW_K_INT_in_native_type10758); 
					 t = CQL3Type.Native.INT; 
					}
					break;
				case 11 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1519:7: K_SMALLINT
					{
					match(input,K_SMALLINT,FOLLOW_K_SMALLINT_in_native_type10774); 
					 t = CQL3Type.Native.SMALLINT; 
					}
					break;
				case 12 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1520:7: K_TEXT
					{
					match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type10785); 
					 t = CQL3Type.Native.TEXT; 
					}
					break;
				case 13 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1521:7: K_TIMESTAMP
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type10800); 
					 t = CQL3Type.Native.TIMESTAMP; 
					}
					break;
				case 14 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1522:7: K_TINYINT
					{
					match(input,K_TINYINT,FOLLOW_K_TINYINT_in_native_type10810); 
					 t = CQL3Type.Native.TINYINT; 
					}
					break;
				case 15 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1523:7: K_UUID
					{
					match(input,K_UUID,FOLLOW_K_UUID_in_native_type10822); 
					 t = CQL3Type.Native.UUID; 
					}
					break;
				case 16 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1524:7: K_VARCHAR
					{
					match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type10837); 
					 t = CQL3Type.Native.VARCHAR; 
					}
					break;
				case 17 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1525:7: K_VARINT
					{
					match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type10849); 
					 t = CQL3Type.Native.VARINT; 
					}
					break;
				case 18 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1526:7: K_TIMEUUID
					{
					match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type10862); 
					 t = CQL3Type.Native.TIMEUUID; 
					}
					break;
				case 19 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1527:7: K_DATE
					{
					match(input,K_DATE,FOLLOW_K_DATE_in_native_type10873); 
					 t = CQL3Type.Native.DATE; 
					}
					break;
				case 20 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1528:7: K_TIME
					{
					match(input,K_TIME,FOLLOW_K_TIME_in_native_type10888); 
					 t = CQL3Type.Native.TIME; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "native_type"



	// $ANTLR start "collection_type"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1531:1: collection_type returns [CQL3Type.Raw pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
	public final CQL3Type.Raw collection_type() throws RecognitionException {
		CQL3Type.Raw pt = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw t2 =null;
		CQL3Type.Raw t =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1532:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
			int alt193=3;
			switch ( input.LA(1) ) {
			case K_MAP:
				{
				alt193=1;
				}
				break;
			case K_LIST:
				{
				alt193=2;
				}
				break;
			case K_SET:
				{
				alt193=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 193, 0, input);
				throw nvae;
			}
			switch (alt193) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1532:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
					{
					match(input,K_MAP,FOLLOW_K_MAP_in_collection_type10916); 
					match(input,179,FOLLOW_179_in_collection_type10919); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10923);
					t1=comparatorType();
					state._fsp--;

					match(input,174,FOLLOW_174_in_collection_type10925); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10929);
					t2=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_collection_type10931); 

					            // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
					            if (t1 != null && t2 != null)
					                pt = CQL3Type.Raw.map(t1, t2);
					        
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1538:7: K_LIST '<' t= comparatorType '>'
					{
					match(input,K_LIST,FOLLOW_K_LIST_in_collection_type10949); 
					match(input,179,FOLLOW_179_in_collection_type10951); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10955);
					t=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_collection_type10957); 
					 if (t != null) pt = CQL3Type.Raw.list(t); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1540:7: K_SET '<' t= comparatorType '>'
					{
					match(input,K_SET,FOLLOW_K_SET_in_collection_type10975); 
					match(input,179,FOLLOW_179_in_collection_type10978); 
					pushFollow(FOLLOW_comparatorType_in_collection_type10982);
					t=comparatorType();
					state._fsp--;

					match(input,182,FOLLOW_182_in_collection_type10984); 
					 if (t != null) pt = CQL3Type.Raw.set(t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pt;
	}
	// $ANTLR end "collection_type"



	// $ANTLR start "tuple_type"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1544:1: tuple_type returns [CQL3Type.Raw t] : K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' ;
	public final CQL3Type.Raw tuple_type() throws RecognitionException {
		CQL3Type.Raw t = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw tn =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1545:5: ( K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1545:7: K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>'
			{
			match(input,K_TUPLE,FOLLOW_K_TUPLE_in_tuple_type11015); 
			match(input,179,FOLLOW_179_in_tuple_type11017); 
			 List<CQL3Type.Raw> types = new ArrayList<>(); 
			pushFollow(FOLLOW_comparatorType_in_tuple_type11032);
			t1=comparatorType();
			state._fsp--;

			 types.add(t1); 
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1546:47: ( ',' tn= comparatorType )*
			loop194:
			while (true) {
				int alt194=2;
				int LA194_0 = input.LA(1);
				if ( (LA194_0==174) ) {
					alt194=1;
				}

				switch (alt194) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1546:48: ',' tn= comparatorType
					{
					match(input,174,FOLLOW_174_in_tuple_type11037); 
					pushFollow(FOLLOW_comparatorType_in_tuple_type11041);
					tn=comparatorType();
					state._fsp--;

					 types.add(tn); 
					}
					break;

				default :
					break loop194;
				}
			}

			match(input,182,FOLLOW_182_in_tuple_type11053); 
			 t = CQL3Type.Raw.tuple(types); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "tuple_type"


	public static class username_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "username"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1550:1: username : ( IDENT | STRING_LITERAL );
	public final CqlParser.username_return username() throws RecognitionException {
		CqlParser.username_return retval = new CqlParser.username_return();
		retval.start = input.LT(1);

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1551:5: ( IDENT | STRING_LITERAL )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:
			{
			if ( input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "username"



	// $ANTLR start "non_type_ident"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1557:1: non_type_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY );
	public final ColumnIdentifier non_type_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		Token kk=null;
		String k =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1558:5: (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY )
			int alt195=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt195=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt195=2;
				}
				break;
			case K_AGGREGATE:
			case K_ALL:
			case K_AS:
			case K_CALLED:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FINALFUNC:
			case K_FROZEN:
			case K_FUNCTION:
			case K_FUNCTIONS:
			case K_INITCOND:
			case K_INPUT:
			case K_JSON:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LANGUAGE:
			case K_LIST:
			case K_LOGIN:
			case K_MAP:
			case K_NOLOGIN:
			case K_NOSUPERUSER:
			case K_OPTIONS:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_RETURNS:
			case K_ROLE:
			case K_ROLES:
			case K_SFUNC:
			case K_STATIC:
			case K_STORAGE:
			case K_STYPE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				alt195=3;
				}
				break;
			case K_KEY:
				{
				alt195=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 195, 0, input);
				throw nvae;
			}
			switch (alt195) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1558:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_non_type_ident11105); 
					 if (reservedTypeNames.contains((t!=null?t.getText():null))) addRecognitionError("Invalid (reserved) user type name " + (t!=null?t.getText():null)); id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1559:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_non_type_ident11136); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1560:7: k= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_non_type_ident11161);
					k=basic_unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1561:7: kk= K_KEY
					{
					kk=(Token)match(input,K_KEY,FOLLOW_K_KEY_in_non_type_ident11173); 
					 id = new ColumnIdentifier((kk!=null?kk.getText():null), false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "non_type_ident"



	// $ANTLR start "unreserved_keyword"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1564:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) );
	public final String unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;
		String u =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1565:5: (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) )
			int alt196=2;
			int LA196_0 = input.LA(1);
			if ( ((LA196_0 >= K_AGGREGATE && LA196_0 <= K_ALL)||LA196_0==K_AS||LA196_0==K_ASCII||(LA196_0 >= K_BIGINT && LA196_0 <= K_BOOLEAN)||(LA196_0 >= K_CALLED && LA196_0 <= K_CLUSTERING)||(LA196_0 >= K_COMPACT && LA196_0 <= K_CONTAINS)||LA196_0==K_COUNTER||(LA196_0 >= K_CUSTOM && LA196_0 <= K_DECIMAL)||(LA196_0 >= K_DISTINCT && LA196_0 <= K_DOUBLE)||(LA196_0 >= K_EXISTS && LA196_0 <= K_FLOAT)||LA196_0==K_FROZEN||(LA196_0 >= K_FUNCTION && LA196_0 <= K_FUNCTIONS)||LA196_0==K_INET||(LA196_0 >= K_INITCOND && LA196_0 <= K_INPUT)||LA196_0==K_INT||LA196_0==K_JSON||LA196_0==K_KEYS||(LA196_0 >= K_KEYSPACES && LA196_0 <= K_LANGUAGE)||(LA196_0 >= K_LIST && LA196_0 <= K_MAP)||LA196_0==K_NOLOGIN||LA196_0==K_NOSUPERUSER||LA196_0==K_OPTIONS||(LA196_0 >= K_PASSWORD && LA196_0 <= K_PERMISSIONS)||LA196_0==K_RETURNS||(LA196_0 >= K_ROLE && LA196_0 <= K_ROLES)||(LA196_0 >= K_SFUNC && LA196_0 <= K_TINYINT)||LA196_0==K_TRIGGER||(LA196_0 >= K_TUPLE && LA196_0 <= K_TYPE)||(LA196_0 >= K_USER && LA196_0 <= K_USERS)||(LA196_0 >= K_UUID && LA196_0 <= K_VARINT)) ) {
				alt196=1;
			}
			else if ( (LA196_0==K_COUNT||LA196_0==K_KEY||LA196_0==K_TTL||LA196_0==K_WRITETIME) ) {
				alt196=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 196, 0, input);
				throw nvae;
			}

			switch (alt196) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1565:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword11216);
					u=unreserved_function_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1566:7: k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY )
					{
					k=input.LT(1);
					if ( input.LA(1)==K_COUNT||input.LA(1)==K_KEY||input.LA(1)==K_TTL||input.LA(1)==K_WRITETIME ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 str = (k!=null?k.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_keyword"



	// $ANTLR start "unreserved_function_keyword"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1569:1: unreserved_function_keyword returns [String str] : (u= basic_unreserved_keyword |t= native_type );
	public final String unreserved_function_keyword() throws RecognitionException {
		String str = null;


		String u =null;
		CQL3Type t =null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1570:5: (u= basic_unreserved_keyword |t= native_type )
			int alt197=2;
			int LA197_0 = input.LA(1);
			if ( ((LA197_0 >= K_AGGREGATE && LA197_0 <= K_ALL)||LA197_0==K_AS||(LA197_0 >= K_CALLED && LA197_0 <= K_CLUSTERING)||(LA197_0 >= K_COMPACT && LA197_0 <= K_CONTAINS)||LA197_0==K_CUSTOM||LA197_0==K_DISTINCT||(LA197_0 >= K_EXISTS && LA197_0 <= K_FINALFUNC)||LA197_0==K_FROZEN||(LA197_0 >= K_FUNCTION && LA197_0 <= K_FUNCTIONS)||(LA197_0 >= K_INITCOND && LA197_0 <= K_INPUT)||LA197_0==K_JSON||LA197_0==K_KEYS||(LA197_0 >= K_KEYSPACES && LA197_0 <= K_LANGUAGE)||(LA197_0 >= K_LIST && LA197_0 <= K_MAP)||LA197_0==K_NOLOGIN||LA197_0==K_NOSUPERUSER||LA197_0==K_OPTIONS||(LA197_0 >= K_PASSWORD && LA197_0 <= K_PERMISSIONS)||LA197_0==K_RETURNS||(LA197_0 >= K_ROLE && LA197_0 <= K_ROLES)||LA197_0==K_SFUNC||(LA197_0 >= K_STATIC && LA197_0 <= K_SUPERUSER)||LA197_0==K_TRIGGER||(LA197_0 >= K_TUPLE && LA197_0 <= K_TYPE)||(LA197_0 >= K_USER && LA197_0 <= K_USERS)||LA197_0==K_VALUES) ) {
				alt197=1;
			}
			else if ( (LA197_0==K_ASCII||(LA197_0 >= K_BIGINT && LA197_0 <= K_BOOLEAN)||LA197_0==K_COUNTER||(LA197_0 >= K_DATE && LA197_0 <= K_DECIMAL)||LA197_0==K_DOUBLE||LA197_0==K_FLOAT||LA197_0==K_INET||LA197_0==K_INT||LA197_0==K_SMALLINT||(LA197_0 >= K_TEXT && LA197_0 <= K_TINYINT)||LA197_0==K_UUID||(LA197_0 >= K_VARCHAR && LA197_0 <= K_VARINT)) ) {
				alt197=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 197, 0, input);
				throw nvae;
			}

			switch (alt197) {
				case 1 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1570:7: u= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword11271);
					u=basic_unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1571:7: t= native_type
					{
					pushFollow(FOLLOW_native_type_in_unreserved_function_keyword11283);
					t=native_type();
					state._fsp--;

					 str = t.toString(); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_function_keyword"



	// $ANTLR start "basic_unreserved_keyword"
	// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1574:1: basic_unreserved_keyword returns [String str] : k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_JSON | K_CALLED | K_INPUT ) ;
	public final String basic_unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;

		try {
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1575:5: (k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_JSON | K_CALLED | K_INPUT ) )
			// /tmp/tmp.HyGWugwvCE/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1575:7: k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_ROLE | K_ROLES | K_SUPERUSER | K_NOSUPERUSER | K_LOGIN | K_NOLOGIN | K_OPTIONS | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE | K_FUNCTION | K_FUNCTIONS | K_AGGREGATE | K_SFUNC | K_STYPE | K_FINALFUNC | K_INITCOND | K_RETURNS | K_LANGUAGE | K_JSON | K_CALLED | K_INPUT )
			{
			k=input.LT(1);
			if ( (input.LA(1) >= K_AGGREGATE && input.LA(1) <= K_ALL)||input.LA(1)==K_AS||(input.LA(1) >= K_CALLED && input.LA(1) <= K_CLUSTERING)||(input.LA(1) >= K_COMPACT && input.LA(1) <= K_CONTAINS)||input.LA(1)==K_CUSTOM||input.LA(1)==K_DISTINCT||(input.LA(1) >= K_EXISTS && input.LA(1) <= K_FINALFUNC)||input.LA(1)==K_FROZEN||(input.LA(1) >= K_FUNCTION && input.LA(1) <= K_FUNCTIONS)||(input.LA(1) >= K_INITCOND && input.LA(1) <= K_INPUT)||input.LA(1)==K_JSON||input.LA(1)==K_KEYS||(input.LA(1) >= K_KEYSPACES && input.LA(1) <= K_LANGUAGE)||(input.LA(1) >= K_LIST && input.LA(1) <= K_MAP)||input.LA(1)==K_NOLOGIN||input.LA(1)==K_NOSUPERUSER||input.LA(1)==K_OPTIONS||(input.LA(1) >= K_PASSWORD && input.LA(1) <= K_PERMISSIONS)||input.LA(1)==K_RETURNS||(input.LA(1) >= K_ROLE && input.LA(1) <= K_ROLES)||input.LA(1)==K_SFUNC||(input.LA(1) >= K_STATIC && input.LA(1) <= K_SUPERUSER)||input.LA(1)==K_TRIGGER||(input.LA(1) >= K_TUPLE && input.LA(1) <= K_TYPE)||(input.LA(1) >= K_USER && input.LA(1) <= K_USERS)||input.LA(1)==K_VALUES ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 str = (k!=null?k.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "basic_unreserved_keyword"

	// Delegated rules


	protected DFA2 dfa2 = new DFA2(this);
	protected DFA14 dfa14 = new DFA14(this);
	protected DFA42 dfa42 = new DFA42(this);
	protected DFA142 dfa142 = new DFA142(this);
	protected DFA143 dfa143 = new DFA143(this);
	protected DFA161 dfa161 = new DFA161(this);
	protected DFA163 dfa163 = new DFA163(this);
	protected DFA165 dfa165 = new DFA165(this);
	protected DFA167 dfa167 = new DFA167(this);
	protected DFA170 dfa170 = new DFA170(this);
	protected DFA176 dfa176 = new DFA176(this);
	protected DFA182 dfa182 = new DFA182(this);
	protected DFA181 dfa181 = new DFA181(this);
	protected DFA191 dfa191 = new DFA191(this);
	static final String DFA2_eotS =
		"\63\uffff";
	static final String DFA2_eofS =
		"\63\uffff";
	static final String DFA2_minS =
		"\1\34\7\uffff\2\31\1\53\2\24\1\32\10\uffff\1\155\22\uffff\1\144\2\uffff"+
		"\1\100\5\uffff\1\31";
	static final String DFA2_maxS =
		"\1\u0088\7\uffff\3\u0089\2\u009d\1\u008a\10\uffff\1\155\22\uffff\1\177"+
		"\2\uffff\1\152\5\uffff\1\103";
	static final String DFA2_acceptS =
		"\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\6\uffff\1\10\1\11\1\23\1\27\1\31"+
		"\1\40\1\46\1\12\1\uffff\1\34\1\36\1\13\1\14\1\15\1\25\1\30\1\33\1\35\1"+
		"\37\1\42\1\47\1\16\1\17\1\24\1\32\1\41\1\50\1\uffff\1\20\1\44\1\uffff"+
		"\1\21\1\45\1\26\1\43\1\22\1\uffff";
	static final String DFA2_specialS =
		"\63\uffff}>";
	static final String[] DFA2_transitionS = {
			"\1\12\7\uffff\1\4\13\uffff\1\10\3\uffff\1\5\4\uffff\1\11\13\uffff\1\13"+
			"\7\uffff\1\2\12\uffff\1\15\26\uffff\1\14\2\uffff\1\1\17\uffff\1\7\4\uffff"+
			"\1\3\1\6",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\30\21\uffff\1\17\5\uffff\1\25\21\uffff\1\27\4\uffff\1\25\13\uffff"+
			"\1\16\6\uffff\1\24\12\uffff\1\26\11\uffff\1\23\20\uffff\1\21\3\uffff"+
			"\1\22\3\uffff\1\20",
			"\1\40\21\uffff\1\32\27\uffff\1\37\4\uffff\1\33\13\uffff\1\31\6\uffff"+
			"\1\42\24\uffff\1\41\20\uffff\1\35\3\uffff\1\36\3\uffff\1\34",
			"\1\43\50\uffff\1\44\6\uffff\1\50\24\uffff\1\47\24\uffff\1\46\3\uffff"+
			"\1\45",
			"\1\53\4\uffff\1\53\1\51\1\uffff\1\52\2\uffff\1\53\1\uffff\1\53\1\52"+
			"\2\uffff\3\53\1\uffff\2\53\1\uffff\4\53\1\52\3\53\2\uffff\1\52\2\53\1"+
			"\52\1\uffff\1\52\4\53\1\uffff\1\53\1\uffff\2\53\4\uffff\1\53\1\uffff"+
			"\2\53\1\uffff\1\53\2\uffff\3\53\1\uffff\2\53\1\uffff\3\53\1\uffff\1\52"+
			"\1\uffff\1\53\1\uffff\1\53\4\uffff\1\53\2\uffff\3\53\3\uffff\1\53\1\uffff"+
			"\2\53\1\52\1\uffff\13\53\2\uffff\1\53\1\uffff\3\53\3\uffff\2\53\1\uffff"+
			"\4\53\3\uffff\1\53\10\uffff\2\53",
			"\1\56\4\uffff\1\56\1\54\1\uffff\1\55\2\uffff\1\56\1\uffff\1\56\1\55"+
			"\2\uffff\3\56\1\uffff\2\56\1\uffff\4\56\1\55\3\56\2\uffff\1\55\2\56\1"+
			"\55\1\uffff\1\55\4\56\1\uffff\1\56\1\uffff\2\56\4\uffff\1\56\1\uffff"+
			"\2\56\1\uffff\1\56\2\uffff\3\56\1\uffff\2\56\1\uffff\3\56\1\uffff\1\55"+
			"\1\uffff\1\56\1\uffff\1\56\4\uffff\1\56\2\uffff\3\56\3\uffff\1\56\1\uffff"+
			"\2\56\1\55\1\uffff\13\56\2\uffff\1\56\1\uffff\3\56\3\uffff\2\56\1\uffff"+
			"\4\56\3\uffff\1\56\10\uffff\2\56",
			"\1\61\1\uffff\1\61\5\uffff\1\61\15\uffff\1\61\5\uffff\1\61\2\uffff\1"+
			"\61\1\uffff\1\61\40\uffff\1\61\24\uffff\1\60\1\61\27\uffff\1\57",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\62",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\52\5\uffff\1\52\24\uffff\1\53",
			"",
			"",
			"\1\56\43\uffff\1\55\5\uffff\1\55",
			"",
			"",
			"",
			"",
			"",
			"\1\30\51\uffff\1\27"
	};

	static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
	static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
	static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
	static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
	static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
	static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
	static final short[][] DFA2_transition;

	static {
		int numStates = DFA2_transitionS.length;
		DFA2_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
		}
	}

	protected class DFA2 extends DFA {

		public DFA2(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 2;
			this.eot = DFA2_eot;
			this.eof = DFA2_eof;
			this.min = DFA2_min;
			this.max = DFA2_max;
			this.accept = DFA2_accept;
			this.special = DFA2_special;
			this.transition = DFA2_transition;
		}
		@Override
		public String getDescription() {
			return "234:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantPermissionsStatement |st17= revokePermissionsStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement |st28= createFunctionStatement |st29= dropFunctionStatement |st30= createAggregateStatement |st31= dropAggregateStatement |st32= createRoleStatement |st33= alterRoleStatement |st34= dropRoleStatement |st35= listRolesStatement |st36= grantRoleStatement |st37= revokeRoleStatement |st38= createMaterializedViewStatement |st39= dropMaterializedViewStatement |st40= alterMaterializedViewStatement );";
		}
	}

	static final String DFA14_eotS =
		"\71\uffff";
	static final String DFA14_eofS =
		"\71\uffff";
	static final String DFA14_minS =
		"\1\24\32\37\1\uffff\1\37\1\24\3\uffff\30\37";
	static final String DFA14_maxS =
		"\1\u009d\32\u00b0\1\uffff\1\u00b0\1\u009d\3\uffff\30\u00b0";
	static final String DFA14_acceptS =
		"\33\uffff\1\4\2\uffff\1\1\1\2\1\3\30\uffff";
	static final String DFA14_specialS =
		"\71\uffff}>";
	static final String[] DFA14_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\32\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\34\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\33\1\3\1\uffff\1\31\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\10\uffff\1\33\1\2",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\37\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\40\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\35",
			"",
			"\1\36\40\uffff\1\36\153\uffff\1\36\1\uffff\1\36\1\uffff\1\35",
			"\1\41\4\uffff\2\43\4\uffff\1\43\1\uffff\1\44\3\uffff\1\45\1\46\1\47"+
			"\1\uffff\2\43\1\uffff\2\43\1\70\1\50\1\uffff\1\43\1\66\1\51\3\uffff\1"+
			"\43\1\52\3\uffff\3\43\1\53\1\uffff\1\43\1\uffff\2\43\4\uffff\1\54\1\uffff"+
			"\2\43\1\uffff\1\55\2\uffff\1\43\1\36\1\43\1\uffff\2\43\1\uffff\3\43\3"+
			"\uffff\1\43\1\uffff\1\43\4\uffff\1\43\2\uffff\3\43\3\uffff\1\43\1\uffff"+
			"\2\43\2\uffff\1\43\1\56\4\43\1\57\1\67\1\60\1\65\1\61\1\uffff\1\33\1"+
			"\43\1\uffff\1\36\2\43\3\uffff\2\43\1\uffff\1\62\1\43\1\63\1\64\3\uffff"+
			"\1\36\11\uffff\1\42",
			"",
			"",
			"",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36",
			"\1\36\40\uffff\1\36\152\uffff\1\33\1\36\1\uffff\1\36\1\uffff\1\36"
	};

	static final short[] DFA14_eot = DFA.unpackEncodedString(DFA14_eotS);
	static final short[] DFA14_eof = DFA.unpackEncodedString(DFA14_eofS);
	static final char[] DFA14_min = DFA.unpackEncodedStringToUnsignedChars(DFA14_minS);
	static final char[] DFA14_max = DFA.unpackEncodedStringToUnsignedChars(DFA14_maxS);
	static final short[] DFA14_accept = DFA.unpackEncodedString(DFA14_acceptS);
	static final short[] DFA14_special = DFA.unpackEncodedString(DFA14_specialS);
	static final short[][] DFA14_transition;

	static {
		int numStates = DFA14_transitionS.length;
		DFA14_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA14_transition[i] = DFA.unpackEncodedString(DFA14_transitionS[i]);
		}
	}

	protected class DFA14 extends DFA {

		public DFA14(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 14;
			this.eot = DFA14_eot;
			this.eof = DFA14_eof;
			this.min = DFA14_min;
			this.max = DFA14_max;
			this.accept = DFA14_accept;
			this.special = DFA14_special;
			this.transition = DFA14_transition;
		}
		@Override
		public String getDescription() {
			return "329:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs )";
		}
	}

	static final String DFA42_eotS =
		"\33\uffff";
	static final String DFA42_eofS =
		"\33\uffff";
	static final String DFA42_minS =
		"\1\24\30\100\2\uffff";
	static final String DFA42_maxS =
		"\1\u009d\30\u00b8\2\uffff";
	static final String DFA42_acceptS =
		"\31\uffff\1\1\1\2";
	static final String DFA42_specialS =
		"\33\uffff}>";
	static final String[] DFA42_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\11\uffff\1\2",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"\1\31\155\uffff\1\31\11\uffff\1\32",
			"",
			""
	};

	static final short[] DFA42_eot = DFA.unpackEncodedString(DFA42_eotS);
	static final short[] DFA42_eof = DFA.unpackEncodedString(DFA42_eofS);
	static final char[] DFA42_min = DFA.unpackEncodedStringToUnsignedChars(DFA42_minS);
	static final char[] DFA42_max = DFA.unpackEncodedStringToUnsignedChars(DFA42_maxS);
	static final short[] DFA42_accept = DFA.unpackEncodedString(DFA42_acceptS);
	static final short[] DFA42_special = DFA.unpackEncodedString(DFA42_specialS);
	static final short[][] DFA42_transition;

	static {
		int numStates = DFA42_transitionS.length;
		DFA42_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA42_transition[i] = DFA.unpackEncodedString(DFA42_transitionS[i]);
		}
	}

	protected class DFA42 extends DFA {

		public DFA42(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 42;
			this.eot = DFA42_eot;
			this.eof = DFA42_eof;
			this.min = DFA42_min;
			this.max = DFA42_max;
			this.accept = DFA42_accept;
			this.special = DFA42_special;
			this.transition = DFA42_transition;
		}
		@Override
		public String getDescription() {
			return "491:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' );";
		}
	}

	static final String DFA142_eotS =
		"\34\uffff";
	static final String DFA142_eofS =
		"\1\uffff\31\33\2\uffff";
	static final String DFA142_minS =
		"\1\24\31\u00b0\2\uffff";
	static final String DFA142_maxS =
		"\1\u009d\31\u00b2\2\uffff";
	static final String DFA142_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA142_specialS =
		"\34\uffff}>";
	static final String[] DFA142_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\10\uffff\1\31\1\2",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"\1\32\1\uffff\1\33",
			"",
			""
	};

	static final short[] DFA142_eot = DFA.unpackEncodedString(DFA142_eotS);
	static final short[] DFA142_eof = DFA.unpackEncodedString(DFA142_eofS);
	static final char[] DFA142_min = DFA.unpackEncodedStringToUnsignedChars(DFA142_minS);
	static final char[] DFA142_max = DFA.unpackEncodedStringToUnsignedChars(DFA142_maxS);
	static final short[] DFA142_accept = DFA.unpackEncodedString(DFA142_acceptS);
	static final short[] DFA142_special = DFA.unpackEncodedString(DFA142_specialS);
	static final short[][] DFA142_transition;

	static {
		int numStates = DFA142_transitionS.length;
		DFA142_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA142_transition[i] = DFA.unpackEncodedString(DFA142_transitionS[i]);
		}
	}

	protected class DFA142 extends DFA {

		public DFA142(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 142;
			this.eot = DFA142_eot;
			this.eof = DFA142_eof;
			this.min = DFA142_min;
			this.max = DFA142_max;
			this.accept = DFA142_accept;
			this.special = DFA142_special;
			this.transition = DFA142_transition;
		}
		@Override
		public String getDescription() {
			return "1189:7: ( ksName[name] '.' )?";
		}
	}

	static final String DFA143_eotS =
		"\34\uffff";
	static final String DFA143_eofS =
		"\1\uffff\31\33\2\uffff";
	static final String DFA143_minS =
		"\1\24\31\30\2\uffff";
	static final String DFA143_maxS =
		"\1\u009d\31\u00b2\2\uffff";
	static final String DFA143_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA143_specialS =
		"\34\uffff}>";
	static final String[] DFA143_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\10\uffff\1\31\1\2",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"\1\33\2\uffff\2\33\2\uffff\1\33\31\uffff\1\33\6\uffff\1\33\20\uffff"+
			"\1\33\5\uffff\1\33\7\uffff\1\33\3\uffff\1\33\3\uffff\1\33\3\uffff\2\33"+
			"\6\uffff\1\33\13\uffff\1\33\13\uffff\1\33\5\uffff\2\33\30\uffff\1\33"+
			"\4\uffff\1\32\1\uffff\1\33",
			"",
			""
	};

	static final short[] DFA143_eot = DFA.unpackEncodedString(DFA143_eotS);
	static final short[] DFA143_eof = DFA.unpackEncodedString(DFA143_eofS);
	static final char[] DFA143_min = DFA.unpackEncodedStringToUnsignedChars(DFA143_minS);
	static final char[] DFA143_max = DFA.unpackEncodedStringToUnsignedChars(DFA143_maxS);
	static final short[] DFA143_accept = DFA.unpackEncodedString(DFA143_acceptS);
	static final short[] DFA143_special = DFA.unpackEncodedString(DFA143_specialS);
	static final short[][] DFA143_transition;

	static {
		int numStates = DFA143_transitionS.length;
		DFA143_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA143_transition[i] = DFA.unpackEncodedString(DFA143_transitionS[i]);
		}
	}

	protected class DFA143 extends DFA {

		public DFA143(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 143;
			this.eot = DFA143_eot;
			this.eof = DFA143_eof;
			this.min = DFA143_min;
			this.max = DFA143_max;
			this.accept = DFA143_accept;
			this.special = DFA143_special;
			this.transition = DFA143_transition;
		}
		@Override
		public String getDescription() {
			return "1194:7: ( ksName[name] '.' )?";
		}
	}

	static final String DFA161_eotS =
		"\42\uffff";
	static final String DFA161_eofS =
		"\42\uffff";
	static final String DFA161_minS =
		"\1\6\2\uffff\1\6\4\uffff\30\u00ab\1\u00b0\1\uffff";
	static final String DFA161_maxS =
		"\1\u00bb\2\uffff\1\u00bc\4\uffff\31\u00b1\1\uffff";
	static final String DFA161_acceptS =
		"\1\uffff\1\1\1\2\1\uffff\1\4\1\5\1\6\1\7\31\uffff\1\3";
	static final String DFA161_specialS =
		"\42\uffff}>";
	static final String[] DFA161_transitionS = {
			"\1\1\7\uffff\1\1\3\uffff\1\1\2\uffff\1\1\64\uffff\1\1\22\uffff\1\1\4"+
			"\uffff\1\5\71\uffff\1\7\3\uffff\1\1\2\uffff\1\1\7\uffff\1\4\3\uffff\1"+
			"\1\1\uffff\1\6\6\uffff\1\2\2\uffff\1\3",
			"",
			"",
			"\1\2\7\uffff\1\2\3\uffff\1\2\1\uffff\1\10\1\2\3\uffff\2\12\4\uffff\1"+
			"\12\1\uffff\1\13\3\uffff\1\14\1\15\1\16\1\uffff\2\12\1\uffff\2\12\1\37"+
			"\1\17\1\uffff\1\12\1\35\1\20\3\uffff\1\12\1\21\3\uffff\3\12\1\22\1\uffff"+
			"\1\12\1\uffff\2\12\4\uffff\1\23\1\2\2\12\1\uffff\1\24\2\uffff\1\12\1"+
			"\40\1\12\1\uffff\2\12\1\uffff\3\12\2\uffff\1\2\1\12\1\uffff\1\12\1\uffff"+
			"\1\2\2\uffff\1\12\2\uffff\3\12\3\uffff\1\12\1\uffff\2\12\2\uffff\1\12"+
			"\1\25\4\12\1\26\1\36\1\27\1\34\1\30\1\uffff\1\2\1\12\1\uffff\1\40\2\12"+
			"\3\uffff\2\12\1\uffff\1\31\1\12\1\32\1\33\3\uffff\1\40\10\uffff\1\2\1"+
			"\11\2\uffff\1\2\2\uffff\1\2\7\uffff\1\2\3\uffff\1\2\1\uffff\1\2\6\uffff"+
			"\1\2\2\uffff\2\2",
			"",
			"",
			"",
			"",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\4\uffff\1\2\1\41",
			"\1\2\1\41",
			""
	};

	static final short[] DFA161_eot = DFA.unpackEncodedString(DFA161_eotS);
	static final short[] DFA161_eof = DFA.unpackEncodedString(DFA161_eofS);
	static final char[] DFA161_min = DFA.unpackEncodedStringToUnsignedChars(DFA161_minS);
	static final char[] DFA161_max = DFA.unpackEncodedStringToUnsignedChars(DFA161_maxS);
	static final short[] DFA161_accept = DFA.unpackEncodedString(DFA161_acceptS);
	static final short[] DFA161_special = DFA.unpackEncodedString(DFA161_specialS);
	static final short[][] DFA161_transition;

	static {
		int numStates = DFA161_transitionS.length;
		DFA161_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA161_transition[i] = DFA.unpackEncodedString(DFA161_transitionS[i]);
		}
	}

	protected class DFA161 extends DFA {

		public DFA161(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 161;
			this.eot = DFA161_eot;
			this.eof = DFA161_eof;
			this.min = DFA161_min;
			this.max = DFA161_max;
			this.accept = DFA161_accept;
			this.special = DFA161_special;
			this.transition = DFA161_transition;
		}
		@Override
		public String getDescription() {
			return "1282:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= noncol_ident | QMARK );";
		}
	}

	static final String DFA163_eotS =
		"\33\uffff";
	static final String DFA163_eofS =
		"\1\uffff\30\32\2\uffff";
	static final String DFA163_minS =
		"\1\24\30\113\2\uffff";
	static final String DFA163_maxS =
		"\1\u009d\30\u00b2\2\uffff";
	static final String DFA163_acceptS =
		"\31\uffff\1\1\1\2";
	static final String DFA163_specialS =
		"\33\uffff}>";
	static final String[] DFA163_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\31\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\32\1\3\1\uffff\1\31\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\31\10\uffff\1\31\1\2",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"\1\32\54\uffff\1\32\62\uffff\1\32\4\uffff\1\31\1\uffff\1\32",
			"",
			""
	};

	static final short[] DFA163_eot = DFA.unpackEncodedString(DFA163_eotS);
	static final short[] DFA163_eof = DFA.unpackEncodedString(DFA163_eofS);
	static final char[] DFA163_min = DFA.unpackEncodedStringToUnsignedChars(DFA163_minS);
	static final char[] DFA163_max = DFA.unpackEncodedStringToUnsignedChars(DFA163_maxS);
	static final short[] DFA163_accept = DFA.unpackEncodedString(DFA163_acceptS);
	static final short[] DFA163_special = DFA.unpackEncodedString(DFA163_specialS);
	static final short[][] DFA163_transition;

	static {
		int numStates = DFA163_transitionS.length;
		DFA163_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA163_transition[i] = DFA.unpackEncodedString(DFA163_transitionS[i]);
		}
	}

	protected class DFA163 extends DFA {

		public DFA163(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 163;
			this.eot = DFA163_eot;
			this.eof = DFA163_eof;
			this.min = DFA163_min;
			this.max = DFA163_max;
			this.accept = DFA163_accept;
			this.special = DFA163_special;
			this.transition = DFA163_transition;
		}
		@Override
		public String getDescription() {
			return "1300:7: (ks= keyspaceName '.' )?";
		}
	}

	static final String DFA165_eotS =
		"\70\uffff";
	static final String DFA165_eofS =
		"\70\uffff";
	static final String DFA165_minS =
		"\1\24\30\u00ab\1\u00b0\1\u00ab\1\u00b0\1\24\1\6\30\u00ab\2\uffff";
	static final String DFA165_maxS =
		"\1\u009d\31\u00b0\1\u00ab\1\u00b0\1\u009d\1\u00bb\30\u00ab\2\uffff";
	static final String DFA165_acceptS =
		"\66\uffff\1\1\1\2";
	static final String DFA165_specialS =
		"\70\uffff}>";
	static final String[] DFA165_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\33\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\32\1\3\1\uffff\1\33\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\33\10\uffff\1\31\1\2",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\35\4\uffff\1\34",
			"\1\34",
			"\1\35",
			"\1\34",
			"\1\36\4\uffff\2\40\4\uffff\1\40\1\uffff\1\41\3\uffff\1\42\1\43\1\44"+
			"\1\uffff\2\40\1\uffff\2\40\1\65\1\45\1\uffff\1\40\1\63\1\46\3\uffff\1"+
			"\40\1\47\3\uffff\3\40\1\50\1\uffff\1\40\1\uffff\2\40\4\uffff\1\51\1\uffff"+
			"\2\40\1\uffff\1\52\2\uffff\1\40\1\uffff\1\40\1\uffff\2\40\1\uffff\3\40"+
			"\3\uffff\1\40\1\uffff\1\40\4\uffff\1\40\2\uffff\3\40\3\uffff\1\40\1\uffff"+
			"\2\40\2\uffff\1\40\1\53\4\40\1\54\1\64\1\55\1\62\1\56\1\uffff\1\32\1"+
			"\40\2\uffff\2\40\3\uffff\2\40\1\uffff\1\57\1\40\1\60\1\61\15\uffff\1"+
			"\37",
			"\1\67\7\uffff\1\67\3\uffff\1\67\1\uffff\2\67\3\uffff\2\67\4\uffff\1"+
			"\67\1\uffff\1\67\3\uffff\3\67\1\uffff\2\67\1\uffff\4\67\1\uffff\3\67"+
			"\3\uffff\2\67\3\uffff\4\67\1\uffff\1\67\1\uffff\2\67\4\uffff\4\67\1\uffff"+
			"\1\67\2\uffff\3\67\1\uffff\2\67\1\uffff\3\67\2\uffff\2\67\1\uffff\1\67"+
			"\1\uffff\1\67\2\uffff\1\67\2\uffff\3\67\3\uffff\1\67\1\uffff\2\67\2\uffff"+
			"\13\67\1\uffff\2\67\1\uffff\3\67\3\uffff\2\67\1\uffff\4\67\3\uffff\1"+
			"\67\10\uffff\2\67\2\uffff\1\67\2\uffff\1\67\7\uffff\1\67\1\66\2\uffff"+
			"\1\67\1\uffff\1\67\6\uffff\1\67\2\uffff\1\67",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"\1\35",
			"",
			""
	};

	static final short[] DFA165_eot = DFA.unpackEncodedString(DFA165_eotS);
	static final short[] DFA165_eof = DFA.unpackEncodedString(DFA165_eofS);
	static final char[] DFA165_min = DFA.unpackEncodedStringToUnsignedChars(DFA165_minS);
	static final char[] DFA165_max = DFA.unpackEncodedStringToUnsignedChars(DFA165_maxS);
	static final short[] DFA165_accept = DFA.unpackEncodedString(DFA165_acceptS);
	static final short[] DFA165_special = DFA.unpackEncodedString(DFA165_specialS);
	static final short[][] DFA165_transition;

	static {
		int numStates = DFA165_transitionS.length;
		DFA165_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA165_transition[i] = DFA.unpackEncodedString(DFA165_transitionS[i]);
		}
	}

	protected class DFA165 extends DFA {

		public DFA165(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 165;
			this.eot = DFA165_eot;
			this.eof = DFA165_eof;
			this.min = DFA165_min;
			this.max = DFA165_max;
			this.accept = DFA165_accept;
			this.special = DFA165_special;
			this.transition = DFA165_transition;
		}
		@Override
		public String getDescription() {
			return "1311:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );";
		}
	}

	static final String DFA167_eotS =
		"\104\uffff";
	static final String DFA167_eofS =
		"\3\uffff\1\1\41\uffff\1\1\5\uffff\31\41";
	static final String DFA167_minS =
		"\1\6\1\uffff\1\6\1\33\1\uffff\1\u00ac\30\u00ab\1\u00ac\2\u00ab\1\uffff"+
		"\1\u00ab\1\u00b0\1\u00ab\1\6\1\24\1\6\3\u00ab\31\33";
	static final String DFA167_maxS =
		"\1\u00bb\1\uffff\1\u00bb\1\u00bc\1\uffff\1\u00ae\2\u00b0\1\u00b3\26\u00b0"+
		"\2\u00b3\1\uffff\1\u00b3\2\u00b0\1\u00bc\1\u009d\1\u00bb\3\u00ac\31\u00bc";
	static final String DFA167_acceptS =
		"\1\uffff\1\1\2\uffff\1\2\34\uffff\1\3\42\uffff";
	static final String DFA167_specialS =
		"\104\uffff}>";
	static final String[] DFA167_transitionS = {
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\4\1\1\3\uffff\2\4\4\uffff\1\4"+
			"\1\uffff\1\4\3\uffff\3\4\1\uffff\2\4\1\uffff\4\4\1\uffff\3\4\3\uffff"+
			"\2\4\3\uffff\4\4\1\uffff\1\4\1\uffff\2\4\4\uffff\1\4\1\1\2\4\1\uffff"+
			"\1\4\2\uffff\3\4\1\uffff\2\4\1\uffff\3\4\2\uffff\1\1\1\4\1\uffff\1\4"+
			"\1\uffff\1\1\2\uffff\1\4\2\uffff\3\4\3\uffff\1\4\1\uffff\2\4\2\uffff"+
			"\13\4\1\uffff\2\4\1\uffff\3\4\3\uffff\2\4\1\uffff\4\4\3\uffff\1\4\10"+
			"\uffff\1\3\1\4\2\uffff\1\1\2\uffff\1\1\7\uffff\1\2\3\uffff\1\1\1\uffff"+
			"\1\1\6\uffff\1\1\2\uffff\1\1",
			"",
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\6\1\1\3\uffff\2\44\4\uffff\1"+
			"\44\1\uffff\1\11\3\uffff\1\12\1\13\1\14\1\uffff\2\44\1\uffff\2\44\1\35"+
			"\1\15\1\uffff\1\44\1\33\1\16\3\uffff\1\44\1\17\3\uffff\3\44\1\20\1\uffff"+
			"\1\42\1\uffff\2\44\4\uffff\1\21\1\1\2\44\1\uffff\1\22\2\uffff\1\44\1"+
			"\36\1\44\1\uffff\2\44\1\uffff\1\37\1\44\1\10\2\uffff\1\1\1\44\1\uffff"+
			"\1\44\1\uffff\1\1\2\uffff\1\44\2\uffff\3\44\3\uffff\1\44\1\uffff\2\44"+
			"\1\uffff\1\41\1\44\1\23\4\44\1\24\1\34\1\25\1\32\1\26\1\uffff\1\1\1\44"+
			"\1\uffff\1\43\1\40\1\44\3\uffff\2\44\1\uffff\1\27\1\44\1\30\1\31\3\uffff"+
			"\1\43\10\uffff\1\1\1\7\2\uffff\1\5\2\uffff\1\1\7\uffff\1\1\3\uffff\1"+
			"\1\1\uffff\1\1\6\uffff\1\1\2\uffff\1\1",
			"\1\1\1\uffff\2\1\25\uffff\1\1\21\uffff\1\1\6\uffff\1\1\11\uffff\1\1"+
			"\17\uffff\1\1\37\uffff\1\1\11\uffff\1\1\32\uffff\3\1\1\uffff\1\4\2\1"+
			"\7\uffff\1\1\1\uffff\1\1",
			"",
			"\1\45\1\uffff\1\1",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\1\4\uffff\1\46",
			"\1\41\3\uffff\1\46",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"",
			"\1\1\1\41\3\uffff\1\46\2\uffff\1\41",
			"\1\46",
			"\1\1\1\41\3\uffff\1\46",
			"\1\41\7\uffff\1\41\3\uffff\1\41\1\uffff\2\41\3\uffff\2\41\1\1\1\uffff"+
			"\2\1\1\41\1\uffff\1\41\3\uffff\3\41\1\uffff\2\41\1\uffff\4\41\1\uffff"+
			"\3\41\1\1\2\uffff\2\41\3\uffff\4\41\1\uffff\1\41\1\uffff\2\41\1\uffff"+
			"\1\1\2\uffff\4\41\1\1\1\41\2\uffff\3\41\1\uffff\2\41\1\1\3\41\2\uffff"+
			"\2\41\1\uffff\1\41\1\uffff\1\41\2\uffff\1\41\1\uffff\1\1\3\41\3\uffff"+
			"\1\41\1\uffff\2\41\2\uffff\13\41\1\uffff\2\41\1\uffff\3\41\1\uffff\1"+
			"\1\1\uffff\2\41\1\uffff\4\41\1\uffff\1\1\1\uffff\1\41\10\uffff\2\41\2"+
			"\uffff\1\41\2\uffff\1\41\7\uffff\1\41\3\1\1\41\1\uffff\1\47\1\1\5\uffff"+
			"\1\41\1\uffff\1\1\1\41\1\1",
			"\1\50\4\uffff\2\52\4\uffff\1\52\1\uffff\1\1\3\uffff\3\1\1\uffff\2\52"+
			"\1\uffff\2\52\2\1\1\uffff\1\52\2\1\3\uffff\1\52\1\1\3\uffff\3\52\1\1"+
			"\1\uffff\1\52\1\uffff\2\52\4\uffff\1\1\1\uffff\2\52\1\uffff\1\1\2\uffff"+
			"\1\52\1\41\1\52\1\uffff\2\52\1\uffff\3\52\3\uffff\1\52\1\uffff\1\52\4"+
			"\uffff\1\52\2\uffff\3\52\3\uffff\1\52\1\uffff\2\52\2\uffff\1\52\1\1\4"+
			"\52\5\1\1\uffff\1\1\1\52\2\uffff\2\52\3\uffff\2\52\1\uffff\1\1\1\52\2"+
			"\1\15\uffff\1\51",
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\53\1\1\3\uffff\2\55\4\uffff\1"+
			"\55\1\uffff\1\56\3\uffff\1\57\1\60\1\61\1\uffff\2\55\1\uffff\2\55\1\102"+
			"\1\62\1\uffff\1\55\1\100\1\63\3\uffff\1\55\1\64\3\uffff\3\55\1\65\1\uffff"+
			"\1\55\1\uffff\2\55\4\uffff\1\66\1\1\2\55\1\uffff\1\67\2\uffff\1\55\1"+
			"\103\1\55\1\uffff\2\55\1\uffff\3\55\2\uffff\1\1\1\55\1\uffff\1\55\1\uffff"+
			"\1\1\2\uffff\1\55\2\uffff\3\55\3\uffff\1\55\1\uffff\2\55\2\uffff\1\55"+
			"\1\70\4\55\1\71\1\101\1\72\1\77\1\73\1\uffff\1\1\1\55\1\uffff\1\103\2"+
			"\55\3\uffff\2\55\1\uffff\1\74\1\55\1\75\1\76\3\uffff\1\103\10\uffff\1"+
			"\1\1\54\2\uffff\1\1\2\uffff\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\1\6"+
			"\uffff\1\1\2\uffff\1\1",
			"\1\1\1\41",
			"\1\1\1\41",
			"\1\1\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\31\uffff\1\1\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41",
			"\1\41\1\uffff\2\41\25\uffff\1\41\21\uffff\1\41\6\uffff\1\41\11\uffff"+
			"\1\41\17\uffff\1\41\37\uffff\1\41\11\uffff\1\41\32\uffff\3\41\1\uffff"+
			"\1\1\2\41\7\uffff\1\41\1\uffff\1\41"
	};

	static final short[] DFA167_eot = DFA.unpackEncodedString(DFA167_eotS);
	static final short[] DFA167_eof = DFA.unpackEncodedString(DFA167_eofS);
	static final char[] DFA167_min = DFA.unpackEncodedStringToUnsignedChars(DFA167_minS);
	static final char[] DFA167_max = DFA.unpackEncodedStringToUnsignedChars(DFA167_maxS);
	static final short[] DFA167_accept = DFA.unpackEncodedString(DFA167_acceptS);
	static final short[] DFA167_special = DFA.unpackEncodedString(DFA167_specialS);
	static final short[][] DFA167_transition;

	static {
		int numStates = DFA167_transitionS.length;
		DFA167_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA167_transition[i] = DFA.unpackEncodedString(DFA167_transitionS[i]);
		}
	}

	protected class DFA167 extends DFA {

		public DFA167(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 167;
			this.eot = DFA167_eot;
			this.eof = DFA167_eof;
			this.min = DFA167_min;
			this.max = DFA167_max;
			this.accept = DFA167_accept;
			this.special = DFA167_special;
			this.transition = DFA167_transition;
		}
		@Override
		public String getDescription() {
			return "1321:1: term returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= term );";
		}
	}

	static final String DFA170_eotS =
		"\35\uffff";
	static final String DFA170_eofS =
		"\35\uffff";
	static final String DFA170_minS =
		"\1\6\1\uffff\31\25\2\uffff";
	static final String DFA170_maxS =
		"\1\u00bb\1\uffff\31\u00b0\2\uffff";
	static final String DFA170_acceptS =
		"\1\uffff\1\1\31\uffff\1\2\1\3";
	static final String DFA170_specialS =
		"\35\uffff}>";
	static final String[] DFA170_transitionS = {
			"\1\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\2\1\1\3\uffff\2\4\4\uffff\1\4"+
			"\1\uffff\1\5\3\uffff\1\6\1\7\1\10\1\uffff\2\4\1\uffff\2\4\1\31\1\11\1"+
			"\uffff\1\4\1\27\1\12\3\uffff\1\4\1\13\3\uffff\3\4\1\14\1\uffff\1\4\1"+
			"\uffff\2\4\4\uffff\1\15\1\1\2\4\1\uffff\1\16\2\uffff\1\4\1\32\1\4\1\uffff"+
			"\2\4\1\uffff\3\4\2\uffff\1\1\1\4\1\uffff\1\4\1\uffff\1\1\2\uffff\1\4"+
			"\2\uffff\3\4\3\uffff\1\4\1\uffff\2\4\2\uffff\1\4\1\17\4\4\1\20\1\30\1"+
			"\21\1\26\1\22\1\uffff\1\1\1\4\1\uffff\1\32\2\4\3\uffff\2\4\1\uffff\1"+
			"\23\1\4\1\24\1\25\3\uffff\1\32\10\uffff\1\1\1\3\2\uffff\1\1\2\uffff\1"+
			"\1\7\uffff\1\1\3\uffff\1\1\1\uffff\1\1\6\uffff\1\1\2\uffff\1\1",
			"",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0095\uffff\1\1\1\uffff\1\33\1\uffff\1\33\1\1",
			"\1\34\u0097\uffff\1\33\1\uffff\1\33\1\1",
			"",
			""
	};

	static final short[] DFA170_eot = DFA.unpackEncodedString(DFA170_eotS);
	static final short[] DFA170_eof = DFA.unpackEncodedString(DFA170_eofS);
	static final char[] DFA170_min = DFA.unpackEncodedStringToUnsignedChars(DFA170_minS);
	static final char[] DFA170_max = DFA.unpackEncodedStringToUnsignedChars(DFA170_maxS);
	static final short[] DFA170_accept = DFA.unpackEncodedString(DFA170_acceptS);
	static final short[] DFA170_special = DFA.unpackEncodedString(DFA170_specialS);
	static final short[][] DFA170_transition;

	static {
		int numStates = DFA170_transitionS.length;
		DFA170_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA170_transition[i] = DFA.unpackEncodedString(DFA170_transitionS[i]);
		}
	}

	protected class DFA170 extends DFA {

		public DFA170(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 170;
			this.eot = DFA170_eot;
			this.eof = DFA170_eof;
			this.min = DFA170_min;
			this.max = DFA170_max;
			this.accept = DFA170_accept;
			this.special = DFA170_special;
			this.transition = DFA170_transition;
		}
		@Override
		public String getDescription() {
			return "1336:1: normalColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );";
		}
	}

	static final String DFA176_eotS =
		"\34\uffff";
	static final String DFA176_eofS =
		"\34\uffff";
	static final String DFA176_minS =
		"\1\24\30\u00b5\1\6\2\uffff";
	static final String DFA176_maxS =
		"\1\u009d\30\u00b5\1\u00bb\2\uffff";
	static final String DFA176_acceptS =
		"\32\uffff\1\1\1\2";
	static final String DFA176_specialS =
		"\34\uffff}>";
	static final String[] DFA176_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\2\uffff\1\3\1\uffff\1\30\2\3\3\uffff\2"+
			"\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\11\uffff\1\2",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\31",
			"\1\32\7\uffff\1\32\3\uffff\1\32\2\uffff\1\32\3\uffff\2\32\4\uffff\1"+
			"\32\1\uffff\1\32\3\uffff\3\32\1\uffff\2\32\1\uffff\4\32\1\uffff\3\32"+
			"\3\uffff\2\32\3\uffff\4\32\1\uffff\1\32\1\uffff\2\32\4\uffff\4\32\1\uffff"+
			"\1\32\2\uffff\3\32\1\uffff\2\32\1\uffff\3\32\2\uffff\2\32\1\uffff\1\32"+
			"\4\uffff\1\32\2\uffff\3\32\3\uffff\1\32\1\uffff\2\32\2\uffff\13\32\2"+
			"\uffff\1\32\1\uffff\3\32\3\uffff\2\32\1\uffff\4\32\3\uffff\1\32\14\uffff"+
			"\1\32\2\uffff\1\32\13\uffff\1\32\13\uffff\1\33",
			"",
			""
	};

	static final short[] DFA176_eot = DFA.unpackEncodedString(DFA176_eotS);
	static final short[] DFA176_eof = DFA.unpackEncodedString(DFA176_eofS);
	static final char[] DFA176_min = DFA.unpackEncodedStringToUnsignedChars(DFA176_minS);
	static final char[] DFA176_max = DFA.unpackEncodedStringToUnsignedChars(DFA176_maxS);
	static final short[] DFA176_accept = DFA.unpackEncodedString(DFA176_acceptS);
	static final short[] DFA176_special = DFA.unpackEncodedString(DFA176_specialS);
	static final short[][] DFA176_transition;

	static {
		int numStates = DFA176_transitionS.length;
		DFA176_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA176_transition[i] = DFA.unpackEncodedString(DFA176_transitionS[i]);
		}
	}

	protected class DFA176 extends DFA {

		public DFA176(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 176;
			this.eot = DFA176_eot;
			this.eof = DFA176_eof;
			this.min = DFA176_min;
			this.max = DFA176_max;
			this.accept = DFA176_accept;
			this.special = DFA176_special;
			this.transition = DFA176_transition;
		}
		@Override
		public String getDescription() {
			return "1395:1: property[PropertyDefinitions props] : (k= noncol_ident '=' simple= propertyValue |k= noncol_ident '=' map= mapLiteral );";
		}
	}

	static final String DFA182_eotS =
		"\73\uffff";
	static final String DFA182_eofS =
		"\73\uffff";
	static final String DFA182_minS =
		"\1\24\30\55\1\uffff\1\24\1\uffff\1\u009c\2\uffff\30\55\4\uffff";
	static final String DFA182_maxS =
		"\1\u00ab\30\u00b8\1\uffff\1\u00ab\1\uffff\1\u00b1\2\uffff\30\u00b8\4\uffff";
	static final String DFA182_acceptS =
		"\31\uffff\1\2\1\uffff\1\1\1\uffff\1\5\1\6\30\uffff\1\10\1\3\1\4\1\7";
	static final String DFA182_specialS =
		"\73\uffff}>";
	static final String[] DFA182_transitionS = {
			"\1\1\4\uffff\2\3\4\uffff\1\3\1\uffff\1\4\3\uffff\1\5\1\6\1\7\1\uffff"+
			"\2\3\1\uffff\2\3\1\30\1\10\1\uffff\1\3\1\26\1\11\3\uffff\1\3\1\12\3\uffff"+
			"\3\3\1\13\1\uffff\1\3\1\uffff\2\3\4\uffff\1\14\1\uffff\2\3\1\uffff\1"+
			"\15\2\uffff\1\3\1\30\1\3\1\uffff\2\3\1\uffff\3\3\3\uffff\1\3\1\uffff"+
			"\1\3\4\uffff\1\3\2\uffff\3\3\3\uffff\1\3\1\uffff\2\3\2\uffff\1\3\1\16"+
			"\4\3\1\17\1\27\1\20\1\25\1\21\1\uffff\1\31\1\3\1\uffff\1\30\2\3\3\uffff"+
			"\2\3\1\uffff\1\22\1\3\1\23\1\24\3\uffff\1\30\11\uffff\1\2\15\uffff\1"+
			"\32",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"\1\35\31\uffff\1\34\142\uffff\1\33\10\uffff\5\33\1\36",
			"",
			"\1\37\4\uffff\2\41\4\uffff\1\41\1\uffff\1\42\3\uffff\1\43\1\44\1\45"+
			"\1\uffff\2\41\1\uffff\2\41\1\66\1\46\1\uffff\1\41\1\64\1\47\3\uffff\1"+
			"\41\1\50\3\uffff\3\41\1\51\1\uffff\1\41\1\uffff\2\41\4\uffff\1\52\1\uffff"+
			"\2\41\1\uffff\1\53\2\uffff\1\41\1\66\1\41\1\uffff\2\41\1\uffff\3\41\3"+
			"\uffff\1\41\1\uffff\1\41\4\uffff\1\41\2\uffff\3\41\3\uffff\1\41\1\uffff"+
			"\2\41\2\uffff\1\41\1\54\4\41\1\55\1\65\1\56\1\63\1\57\1\uffff\1\67\1"+
			"\41\1\uffff\1\66\2\41\3\uffff\2\41\1\uffff\1\60\1\41\1\61\1\62\3\uffff"+
			"\1\66\11\uffff\1\40\15\uffff\1\67",
			"",
			"\1\70\16\uffff\1\71\5\uffff\1\70",
			"",
			"",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"\1\67\31\uffff\1\67\142\uffff\1\67\1\uffff\1\72\1\uffff\1\72\4\uffff"+
			"\6\67",
			"",
			"",
			"",
			""
	};

	static final short[] DFA182_eot = DFA.unpackEncodedString(DFA182_eotS);
	static final short[] DFA182_eof = DFA.unpackEncodedString(DFA182_eofS);
	static final char[] DFA182_min = DFA.unpackEncodedStringToUnsignedChars(DFA182_minS);
	static final char[] DFA182_max = DFA.unpackEncodedStringToUnsignedChars(DFA182_maxS);
	static final short[] DFA182_accept = DFA.unpackEncodedString(DFA182_acceptS);
	static final short[] DFA182_special = DFA.unpackEncodedString(DFA182_specialS);
	static final short[][] DFA182_transition;

	static {
		int numStates = DFA182_transitionS.length;
		DFA182_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA182_transition[i] = DFA.unpackEncodedString(DFA182_transitionS[i]);
		}
	}

	protected class DFA182 extends DFA {

		public DFA182(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 182;
			this.eot = DFA182_eot;
			this.eof = DFA182_eof;
			this.min = DFA182_min;
			this.max = DFA182_max;
			this.accept = DFA182_accept;
			this.special = DFA182_special;
			this.transition = DFA182_transition;
		}
		@Override
		public String getDescription() {
			return "1414:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |name= cident '[' key= term ']' type= relationType t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );";
		}
	}

	static final String DFA181_eotS =
		"\12\uffff";
	static final String DFA181_eofS =
		"\12\uffff";
	static final String DFA181_minS =
		"\1\107\1\uffff\6\u009c\2\uffff";
	static final String DFA181_maxS =
		"\1\u00b7\1\uffff\6\u00b1\2\uffff";
	static final String DFA181_acceptS =
		"\1\uffff\1\1\6\uffff\1\2\1\3";
	static final String DFA181_specialS =
		"\12\uffff}>";
	static final String[] DFA181_transitionS = {
			"\1\1\142\uffff\1\7\10\uffff\1\3\1\4\1\2\1\5\1\6",
			"",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"\1\11\16\uffff\1\10\5\uffff\1\11",
			"",
			""
	};

	static final short[] DFA181_eot = DFA.unpackEncodedString(DFA181_eotS);
	static final short[] DFA181_eof = DFA.unpackEncodedString(DFA181_eofS);
	static final char[] DFA181_min = DFA.unpackEncodedStringToUnsignedChars(DFA181_minS);
	static final char[] DFA181_max = DFA.unpackEncodedStringToUnsignedChars(DFA181_maxS);
	static final short[] DFA181_accept = DFA.unpackEncodedString(DFA181_acceptS);
	static final short[] DFA181_special = DFA.unpackEncodedString(DFA181_specialS);
	static final short[][] DFA181_transition;

	static {
		int numStates = DFA181_transitionS.length;
		DFA181_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA181_transition[i] = DFA.unpackEncodedString(DFA181_transitionS[i]);
		}
	}

	protected class DFA181 extends DFA {

		public DFA181(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 181;
			this.eot = DFA181_eot;
			this.eof = DFA181_eof;
			this.min = DFA181_min;
			this.max = DFA181_max;
			this.accept = DFA181_accept;
			this.special = DFA181_special;
			this.transition = DFA181_transition;
		}
		@Override
		public String getDescription() {
			return "1426:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )";
		}
	}

	static final String DFA191_eotS =
		"\37\uffff";
	static final String DFA191_eofS =
		"\1\uffff\24\34\2\31\1\uffff\1\31\1\uffff\1\31\4\uffff";
	static final String DFA191_minS =
		"\1\24\26\76\1\uffff\1\76\1\uffff\1\76\4\uffff";
	static final String DFA191_maxS =
		"\1\u00a0\26\u00b6\1\uffff\1\u00b6\1\uffff\1\u00b6\4\uffff";
	static final String DFA191_acceptS =
		"\27\uffff\1\2\1\uffff\1\4\1\uffff\1\6\1\1\1\3\1\5";
	static final String DFA191_specialS =
		"\37\uffff}>";
	static final String[] DFA191_transitionS = {
			"\1\31\4\uffff\2\31\4\uffff\1\31\1\uffff\1\1\3\uffff\1\2\1\3\1\4\1\uffff"+
			"\2\31\1\uffff\3\31\1\5\1\uffff\1\31\1\23\1\6\3\uffff\1\31\1\7\3\uffff"+
			"\3\31\1\10\1\uffff\1\32\1\uffff\2\31\4\uffff\1\11\1\uffff\2\31\1\uffff"+
			"\1\12\2\uffff\3\31\1\uffff\2\31\1\uffff\1\26\1\31\1\25\3\uffff\1\31\1"+
			"\uffff\1\31\4\uffff\1\31\2\uffff\3\31\3\uffff\1\31\1\uffff\2\31\1\uffff"+
			"\1\27\1\31\1\13\4\31\1\14\1\24\1\15\1\22\1\16\2\uffff\1\31\1\uffff\1"+
			"\31\1\30\1\31\3\uffff\2\31\1\uffff\1\17\1\31\1\20\1\21\3\uffff\1\31\11"+
			"\uffff\1\31\2\uffff\1\33",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\34\14\uffff\1\34\12\uffff\1\34\24\uffff\1\34\12\uffff\1\34\65\uffff"+
			"\1\34\1\uffff\1\34\1\uffff\1\31\1\uffff\1\34\3\uffff\1\34",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\27\2\uffff\1\31",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\27\2\uffff\1\31",
			"",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\35\2\uffff\1\31",
			"",
			"\1\31\14\uffff\1\31\12\uffff\1\31\24\uffff\1\31\12\uffff\1\31\65\uffff"+
			"\1\31\1\uffff\1\31\1\uffff\1\31\1\uffff\1\31\1\36\2\uffff\1\31",
			"",
			"",
			"",
			""
	};

	static final short[] DFA191_eot = DFA.unpackEncodedString(DFA191_eotS);
	static final short[] DFA191_eof = DFA.unpackEncodedString(DFA191_eofS);
	static final char[] DFA191_min = DFA.unpackEncodedStringToUnsignedChars(DFA191_minS);
	static final char[] DFA191_max = DFA.unpackEncodedStringToUnsignedChars(DFA191_maxS);
	static final short[] DFA191_accept = DFA.unpackEncodedString(DFA191_acceptS);
	static final short[] DFA191_special = DFA.unpackEncodedString(DFA191_specialS);
	static final short[][] DFA191_transition;

	static {
		int numStates = DFA191_transitionS.length;
		DFA191_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA191_transition[i] = DFA.unpackEncodedString(DFA191_transitionS[i]);
		}
	}

	protected class DFA191 extends DFA {

		public DFA191(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 191;
			this.eot = DFA191_eot;
			this.eof = DFA191_eof;
			this.min = DFA191_min;
			this.max = DFA191_max;
			this.accept = DFA191_accept;
			this.special = DFA191_special;
			this.transition = DFA191_transition;
		}
		@Override
		public String getDescription() {
			return "1483:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );";
		}
	}

	public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_178_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_cqlStatement142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_cqlStatement171 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_batchStatement_in_cqlStatement200 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_cqlStatement230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_useStatement_in_cqlStatement259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_truncateStatement_in_cqlStatement291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement318 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTableStatement_in_cqlStatement339 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement362 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement385 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement407 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement457 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement481 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantPermissionsStatement_in_cqlStatement502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokePermissionsStatement_in_cqlStatement520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement537 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createUserStatement_in_cqlStatement556 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement605 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement631 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement656 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTypeStatement_in_cqlStatement700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTypeStatement_in_cqlStatement724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTypeStatement_in_cqlStatement749 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createFunctionStatement_in_cqlStatement775 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropFunctionStatement_in_cqlStatement795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createAggregateStatement_in_cqlStatement817 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropAggregateStatement_in_cqlStatement836 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createRoleStatement_in_cqlStatement857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterRoleStatement_in_cqlStatement881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropRoleStatement_in_cqlStatement906 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listRolesStatement_in_cqlStatement932 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantRoleStatement_in_cqlStatement957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokeRoleStatement_in_cqlStatement982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createMaterializedViewStatement_in_cqlStatement1006 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropMaterializedViewStatement_in_cqlStatement1018 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterMaterializedViewStatement_in_cqlStatement1032 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USE_in_useStatement1058 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_useStatement1062 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SELECT_in_selectStatement1096 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_K_JSON_in_selectStatement1107 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_K_DISTINCT_in_selectStatement1124 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_selectClause_in_selectStatement1133 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_selectCountClause_in_selectStatement1147 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_selectStatement1157 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_selectStatement1161 = new BitSet(new long[]{0x0000000008000002L,0x0000008000800000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_selectStatement1171 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_whereClause_in_selectStatement1175 = new BitSet(new long[]{0x0000000008000002L,0x0000008000800000L});
	public static final BitSet FOLLOW_K_ORDER_in_selectStatement1188 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_BY_in_selectStatement1190 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement1192 = new BitSet(new long[]{0x0000000008000002L,0x0000000000800000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_selectStatement1197 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement1199 = new BitSet(new long[]{0x0000000008000002L,0x0000000000800000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_LIMIT_in_selectStatement1216 = new BitSet(new long[]{0x0000000008200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_selectStatement1220 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_K_ALLOW_in_selectStatement1235 = new BitSet(new long[]{0x2000000000000000L});
	public static final BitSet FOLLOW_K_FILTERING_in_selectStatement1237 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selector_in_selectClause1274 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_selectClause1279 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_selector_in_selectClause1283 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_185_in_selectClause1295 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selector1328 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_K_AS_in_selector1331 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_selector1335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1376 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_WRITETIME_in_unaliasedSelector1422 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_unaliasedSelector1424 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1428 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_unaliasedSelector1430 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_TTL_in_unaliasedSelector1456 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_unaliasedSelector1464 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1468 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_unaliasedSelector1470 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_functionName_in_unaliasedSelector1498 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_selectionFunctionArgs_in_unaliasedSelector1502 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_unaliasedSelector1517 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1521 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_171_in_selectionFunctionArgs1549 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_selectionFunctionArgs1551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_selectionFunctionArgs1561 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1565 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_selectionFunctionArgs1581 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1585 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_selectionFunctionArgs1598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNT_in_selectCountClause1629 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_selectCountClause1631 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_countArgument_in_selectCountClause1633 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_selectCountClause1635 = new BitSet(new long[]{0x0000000080000002L});
	public static final BitSet FOLLOW_K_AS_in_selectCountClause1638 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_selectCountClause1642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_185_in_countArgument1665 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_countArgument1675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relation_in_whereClause1706 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_whereClause1710 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_relation_in_whereClause1712 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_cident_in_orderByClause1743 = new BitSet(new long[]{0x0020000100000002L});
	public static final BitSet FOLLOW_K_ASC_in_orderByClause1746 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_orderByClause1750 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INSERT_in_insertStatement1779 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_K_INTO_in_insertStatement1781 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1785 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L,0x0000080000000000L});
	public static final BitSet FOLLOW_normalInsertStatement_in_insertStatement1799 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_JSON_in_insertStatement1814 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L,0x0002000110000800L});
	public static final BitSet FOLLOW_jsonInsertStatement_in_insertStatement1818 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_normalInsertStatement1854 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_normalInsertStatement1858 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_normalInsertStatement1865 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_normalInsertStatement1869 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_normalInsertStatement1876 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_K_VALUES_in_normalInsertStatement1884 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_normalInsertStatement1892 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_normalInsertStatement1896 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_normalInsertStatement1902 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_normalInsertStatement1906 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_normalInsertStatement1913 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_IF_in_normalInsertStatement1923 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_normalInsertStatement1925 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_normalInsertStatement1927 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_usingClause_in_normalInsertStatement1942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_jsonValue_in_jsonInsertStatement1988 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_IF_in_jsonInsertStatement1998 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_jsonInsertStatement2000 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_jsonInsertStatement2002 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_usingClause_in_jsonInsertStatement2017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_jsonValue2058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_jsonValue2068 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_jsonValue2072 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_jsonValue2086 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClause2117 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause2119 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_usingClause2124 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause2126 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseObjective2148 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective2152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective2162 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective2166 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UPDATE_in_updateStatement2200 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_updateStatement2204 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_usingClause_in_updateStatement2214 = new BitSet(new long[]{0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_K_SET_in_updateStatement2226 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement2228 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000020000L});
	public static final BitSet FOLLOW_174_in_updateStatement2232 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement2234 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_updateStatement2245 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_whereClause_in_updateStatement2249 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_IF_in_updateStatement2259 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_EXISTS_in_updateStatement2263 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_updateStatement2271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions2313 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_updateConditions2318 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions2320 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_DELETE_in_deleteStatement2357 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1BL,0x000000002008F63AL});
	public static final BitSet FOLLOW_deleteSelection_in_deleteStatement2363 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_deleteStatement2376 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement2380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020800L});
	public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement2390 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_deleteStatement2402 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_whereClause_in_deleteStatement2406 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_IF_in_deleteStatement2416 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_EXISTS_in_deleteStatement2420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_deleteStatement2428 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection2475 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_deleteSelection2490 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection2494 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_cident_in_deleteOp2521 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_deleteOp2548 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_184_in_deleteOp2550 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_deleteOp2554 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_deleteOp2556 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClauseDelete2576 = new BitSet(new long[]{0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDelete2578 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseDelete2582 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BEGIN_in_batchStatement2616 = new BitSet(new long[]{0x0000800800000000L,0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement2626 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_K_COUNTER_in_batchStatement2632 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2645 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0000000000000880L});
	public static final BitSet FOLLOW_usingClause_in_batchStatement2649 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0000000000000080L});
	public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2669 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0004000000000080L});
	public static final BitSet FOLLOW_178_in_batchStatement2671 = new BitSet(new long[]{0x0010000040000000L,0x0000000000002000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_APPLY_in_batchStatement2685 = new BitSet(new long[]{0x0000000800000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2687 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective2718 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective2731 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective2744 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createAggregateStatement2777 = new BitSet(new long[]{0x0000000002000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_K_OR_in_createAggregateStatement2780 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_REPLACE_in_createAggregateStatement2782 = new BitSet(new long[]{0x0000000002000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_createAggregateStatement2794 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_createAggregateStatement2803 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createAggregateStatement2805 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createAggregateStatement2807 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_createAggregateStatement2821 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createAggregateStatement2829 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement2853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createAggregateStatement2869 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement2873 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createAggregateStatement2897 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_SFUNC_in_createAggregateStatement2905 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_createAggregateStatement2911 = new BitSet(new long[]{0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_K_STYPE_in_createAggregateStatement2919 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createAggregateStatement2925 = new BitSet(new long[]{0x4000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_FINALFUNC_in_createAggregateStatement2943 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_createAggregateStatement2949 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_INITCOND_in_createAggregateStatement2976 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_createAggregateStatement2982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropAggregateStatement3029 = new BitSet(new long[]{0x0000000002000000L});
	public static final BitSet FOLLOW_K_AGGREGATE_in_dropAggregateStatement3031 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_dropAggregateStatement3040 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropAggregateStatement3042 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_dropAggregateStatement3057 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_dropAggregateStatement3075 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropAggregateStatement3103 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_dropAggregateStatement3121 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropAggregateStatement3125 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_dropAggregateStatement3153 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createFunctionStatement3210 = new BitSet(new long[]{0x0000000000000000L,0x0000004000000008L});
	public static final BitSet FOLLOW_K_OR_in_createFunctionStatement3213 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_REPLACE_in_createFunctionStatement3215 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_FUNCTION_in_createFunctionStatement3227 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_createFunctionStatement3236 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createFunctionStatement3238 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createFunctionStatement3240 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_createFunctionStatement3254 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createFunctionStatement3262 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000010002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_createFunctionStatement3286 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement3290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createFunctionStatement3306 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_createFunctionStatement3310 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement3314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createFunctionStatement3338 = new BitSet(new long[]{0x0000020000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_RETURNS_in_createFunctionStatement3349 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_createFunctionStatement3351 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_CALLED_in_createFunctionStatement3357 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_createFunctionStatement3363 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_createFunctionStatement3365 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_K_INPUT_in_createFunctionStatement3367 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_RETURNS_in_createFunctionStatement3375 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_createFunctionStatement3381 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_LANGUAGE_in_createFunctionStatement3389 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_IDENT_in_createFunctionStatement3395 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_K_AS_in_createFunctionStatement3403 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createFunctionStatement3409 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropFunctionStatement3447 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_FUNCTION_in_dropFunctionStatement3449 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_K_IF_in_dropFunctionStatement3458 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropFunctionStatement3460 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_dropFunctionStatement3475 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_dropFunctionStatement3493 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropFunctionStatement3521 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_dropFunctionStatement3539 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_dropFunctionStatement3543 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_dropFunctionStatement3571 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement3630 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement3632 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement3635 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement3637 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement3639 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement3648 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement3656 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_createKeyspaceStatement3658 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTableStatement3693 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement3695 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createTableStatement3698 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTableStatement3700 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement3702 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement3717 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_cfamDefinition_in_createTableStatement3727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_cfamDefinition3746 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34F21476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition3748 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_cfamDefinition3753 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34F21476E5A1AL,0x000050002008F63AL});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition3755 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_cfamDefinition3762 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_cfamDefinition3772 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition3774 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_cfamDefinition3779 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition3781 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_ident_in_cfamColumns3807 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_cfamColumns3811 = new BitSet(new long[]{0x0000000000000002L,0x0040080000000000L});
	public static final BitSet FOLLOW_K_STATIC_in_cfamColumns3816 = new BitSet(new long[]{0x0000000000000002L,0x0000080000000000L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns3833 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns3835 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns3847 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns3849 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_cfamColumns3851 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63AL});
	public static final BitSet FOLLOW_pkDef_in_cfamColumns3853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_cfamColumns3857 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_ident_in_cfamColumns3861 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_cfamColumns3868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_pkDef3888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_pkDef3898 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_ident_in_pkDef3904 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_pkDef3910 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_ident_in_pkDef3914 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_pkDef3921 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_cfamProperty3941 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty3950 = new BitSet(new long[]{0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty3952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty3962 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_K_ORDER_in_cfamProperty3964 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_K_BY_in_cfamProperty3966 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_cfamProperty3968 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty3970 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_cfamProperty3974 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty3976 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_cfamProperty3981 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_cfamOrdering4009 = new BitSet(new long[]{0x0020000100000000L});
	public static final BitSet FOLLOW_K_ASC_in_cfamOrdering4012 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_cfamOrdering4016 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTypeStatement4055 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_createTypeStatement4057 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createTypeStatement4060 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTypeStatement4062 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTypeStatement4064 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_userTypeName_in_createTypeStatement4082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createTypeStatement4095 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement4097 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createTypeStatement4102 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000050002008F63AL});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement4104 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createTypeStatement4111 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_typeColumns4131 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_typeColumns4135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement4170 = new BitSet(new long[]{0x0002000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement4173 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement4179 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34731476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createIndexStatement4182 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createIndexStatement4184 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement4186 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34731476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_idxName_in_createIndexStatement4202 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_createIndexStatement4207 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement4211 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createIndexStatement4213 = new BitSet(new long[]{0xF58EF6E286100000L,0x7FF34721476E5A1EL,0x000000002008F63AL});
	public static final BitSet FOLLOW_indexIdent_in_createIndexStatement4217 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_createIndexStatement4219 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040800L});
	public static final BitSet FOLLOW_K_USING_in_createIndexStatement4230 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement4234 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createIndexStatement4249 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_createIndexStatement4251 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent4285 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYS_in_indexIdent4313 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_indexIdent4315 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_indexIdent4319 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_indexIdent4321 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ENTRIES_in_indexIdent4334 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_indexIdent4336 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_indexIdent4340 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_indexIdent4342 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FULL_in_indexIdent4352 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_indexIdent4354 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_indexIdent4358 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_indexIdent4360 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createMaterializedViewStatement4397 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_createMaterializedViewStatement4399 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_VIEW_in_createMaterializedViewStatement4401 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createMaterializedViewStatement4404 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createMaterializedViewStatement4406 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createMaterializedViewStatement4408 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createMaterializedViewStatement4416 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_K_AS_in_createMaterializedViewStatement4418 = new BitSet(new long[]{0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_K_SELECT_in_createMaterializedViewStatement4428 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x020000003008F63BL});
	public static final BitSet FOLLOW_selectClause_in_createMaterializedViewStatement4432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_createMaterializedViewStatement4434 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createMaterializedViewStatement4438 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_createMaterializedViewStatement4449 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_mvWhereClause_in_createMaterializedViewStatement4453 = new BitSet(new long[]{0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_K_PRIMARY_in_createMaterializedViewStatement4465 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_KEY_in_createMaterializedViewStatement4467 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createMaterializedViewStatement4479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_createMaterializedViewStatement4481 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4485 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createMaterializedViewStatement4491 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4495 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createMaterializedViewStatement4502 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createMaterializedViewStatement4506 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4510 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createMaterializedViewStatement4517 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_171_in_createMaterializedViewStatement4527 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4531 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_createMaterializedViewStatement4537 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createMaterializedViewStatement4541 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_createMaterializedViewStatement4548 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createMaterializedViewStatement4580 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_createMaterializedViewStatement4582 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_createMaterializedViewStatement4587 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cfamProperty_in_createMaterializedViewStatement4589 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_cident_in_mvWhereClause4618 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_IS_in_mvWhereClause4622 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_mvWhereClause4624 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_mvWhereClause4626 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_mvWhereClause4629 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_mvWhereClause4633 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_IS_in_mvWhereClause4637 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_mvWhereClause4639 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_K_NULL_in_mvWhereClause4641 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement4675 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement4677 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createTriggerStatement4680 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createTriggerStatement4682 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTriggerStatement4684 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_createTriggerStatement4694 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_createTriggerStatement4705 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement4709 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_K_USING_in_createTriggerStatement4711 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement4715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement4756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement4758 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropTriggerStatement4761 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTriggerStatement4763 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_dropTriggerStatement4773 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement4776 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement4780 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement4820 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement4822 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement4826 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement4836 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement4838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement4874 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement4876 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement4880 = new BitSet(new long[]{0x0200000011000000L,0x0000100000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement4894 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement4898 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement4900 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement4904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTableStatement4920 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement4926 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement4930 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_K_STATIC_in_alterTableStatement4935 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement4953 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement4958 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_WITH_in_alterTableStatement4998 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_alterTableStatement5001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement5034 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5088 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement5090 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5094 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTableStatement5115 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5119 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement5121 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_alterTableStatement5125 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterMaterializedViewStatement5178 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_alterMaterializedViewStatement5180 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_VIEW_in_alterMaterializedViewStatement5182 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_alterMaterializedViewStatement5186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterMaterializedViewStatement5198 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_properties_in_alterMaterializedViewStatement5200 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement5235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement5237 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_userTypeName_in_alterTypeStatement5241 = new BitSet(new long[]{0x0000000011000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement5255 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5259 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement5261 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement5265 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTypeStatement5281 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5287 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement5291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTypeStatement5314 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5352 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement5354 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5358 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTypeStatement5381 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5385 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement5387 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_alterTypeStatement5391 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement5458 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement5460 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement5463 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement5465 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement5474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTableStatement5508 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement5510 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropTableStatement5513 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement5515 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement5524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTypeStatement5558 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_TYPE_in_dropTypeStatement5560 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropTypeStatement5563 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTypeStatement5565 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_userTypeName_in_dropTypeStatement5574 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement5608 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement5610 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropIndexStatement5613 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement5615 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_indexName_in_dropIndexStatement5624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropMaterializedViewStatement5664 = new BitSet(new long[]{0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_K_MATERIALIZED_in_dropMaterializedViewStatement5666 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_VIEW_in_dropMaterializedViewStatement5668 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropMaterializedViewStatement5671 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropMaterializedViewStatement5673 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dropMaterializedViewStatement5682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement5713 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement5717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantPermissionsStatement5742 = new BitSet(new long[]{0x0A41000414000000L,0x0004000010000000L});
	public static final BitSet FOLLOW_permissionOrAll_in_grantPermissionsStatement5754 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_grantPermissionsStatement5762 = new BitSet(new long[]{0xF18EFEE286100000L,0x7FF34721477E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_resource_in_grantPermissionsStatement5774 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_grantPermissionsStatement5782 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_grantPermissionsStatement5796 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokePermissionsStatement5827 = new BitSet(new long[]{0x0A41000414000000L,0x0004000010000000L});
	public static final BitSet FOLLOW_permissionOrAll_in_revokePermissionsStatement5839 = new BitSet(new long[]{0x0000000000000000L,0x0000001000000000L});
	public static final BitSet FOLLOW_K_ON_in_revokePermissionsStatement5847 = new BitSet(new long[]{0xF18EFEE286100000L,0x7FF34721477E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_resource_in_revokePermissionsStatement5859 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_revokePermissionsStatement5867 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_revokePermissionsStatement5881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantRoleStatement5912 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_grantRoleStatement5926 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L});
	public static final BitSet FOLLOW_K_TO_in_grantRoleStatement5934 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_grantRoleStatement5948 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokeRoleStatement5979 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_revokeRoleStatement5993 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_FROM_in_revokeRoleStatement6001 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_revokeRoleStatement6015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement6053 = new BitSet(new long[]{0x0A41000414000000L,0x0004000010000000L});
	public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement6065 = new BitSet(new long[]{0x0000000000000002L,0x0000001880000000L});
	public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement6075 = new BitSet(new long[]{0xF18EFEE286100000L,0x7FF34721477E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_resource_in_listPermissionsStatement6077 = new BitSet(new long[]{0x0000000000000002L,0x0000000880000000L});
	public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement6092 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_roleName_in_listPermissionsStatement6094 = new BitSet(new long[]{0x0000000000000002L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement6108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_permission6144 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_permissionOrAll6201 = new BitSet(new long[]{0x0000000000000002L,0x0000040000000000L});
	public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll6205 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_permission_in_permissionOrAll6226 = new BitSet(new long[]{0x0000000000000002L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll6230 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dataResource_in_resource6258 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleResource_in_resource6270 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionResource_in_resource6282 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_dataResource6305 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource6307 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource6317 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_dataResource6323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource6335 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_columnFamilyName_in_dataResource6344 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_roleResource6373 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_K_ROLES_in_roleResource6375 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ROLE_in_roleResource6385 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_roleResource6391 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_functionResource6423 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_functionResource6425 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_functionResource6435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_FUNCTIONS_in_functionResource6437 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_IN_in_functionResource6439 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_functionResource6441 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_keyspaceName_in_functionResource6447 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FUNCTION_in_functionResource6462 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63BL});
	public static final BitSet FOLLOW_functionName_in_functionResource6466 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_functionResource6484 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000010012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_functionResource6512 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_functionResource6530 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_functionResource6534 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_functionResource6562 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createUserStatement6610 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_USER_in_createUserStatement6612 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L,0x0000000100000000L});
	public static final BitSet FOLLOW_K_IF_in_createUserStatement6615 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createUserStatement6617 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createUserStatement6619 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_username_in_createUserStatement6627 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createUserStatement6639 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_userPassword_in_createUserStatement6641 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement6655 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement6661 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement6706 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_USER_in_alterUserStatement6708 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_username_in_alterUserStatement6712 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterUserStatement6724 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_userPassword_in_alterUserStatement6726 = new BitSet(new long[]{0x0000000000000002L,0x0200000100000000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement6740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement6754 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropUserStatement6800 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_K_USER_in_dropUserStatement6802 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L,0x0000000100000000L});
	public static final BitSet FOLLOW_K_IF_in_dropUserStatement6805 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropUserStatement6807 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_username_in_dropUserStatement6815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listUsersStatement6840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_K_USERS_in_listUsersStatement6842 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createRoleStatement6876 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_ROLE_in_createRoleStatement6878 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_createRoleStatement6881 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_NOT_in_createRoleStatement6883 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createRoleStatement6885 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_createRoleStatement6893 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_createRoleStatement6903 = new BitSet(new long[]{0x0000000000000000L,0x0200012002000000L});
	public static final BitSet FOLLOW_roleOptions_in_createRoleStatement6905 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterRoleStatement6949 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_ROLE_in_alterRoleStatement6951 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_alterRoleStatement6955 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_K_WITH_in_alterRoleStatement6965 = new BitSet(new long[]{0x0000000000000000L,0x0200012002000000L});
	public static final BitSet FOLLOW_roleOptions_in_alterRoleStatement6967 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropRoleStatement7011 = new BitSet(new long[]{0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_K_ROLE_in_dropRoleStatement7013 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A5AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_K_IF_in_dropRoleStatement7016 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropRoleStatement7018 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_userOrRoleName_in_dropRoleStatement7026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listRolesStatement7066 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_K_ROLES_in_listRolesStatement7068 = new BitSet(new long[]{0x0000000000000002L,0x0000000880000000L});
	public static final BitSet FOLLOW_K_OF_in_listRolesStatement7078 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_roleName_in_listRolesStatement7080 = new BitSet(new long[]{0x0000000000000002L,0x0000000080000000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listRolesStatement7093 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleOption_in_roleOptions7124 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_roleOptions7128 = new BitSet(new long[]{0x0000000000000000L,0x0200012002000000L});
	public static final BitSet FOLLOW_roleOption_in_roleOptions7130 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_roleOption7152 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7154 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_roleOption7158 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_OPTIONS_in_roleOption7169 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7171 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_mapLiteral_in_roleOption7175 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_roleOption7186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7188 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_BOOLEAN_in_roleOption7192 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LOGIN_in_roleOption7203 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_roleOption7205 = new BitSet(new long[]{0x0000000000000040L});
	public static final BitSet FOLLOW_BOOLEAN_in_roleOption7209 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_userPassword7231 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_userPassword7235 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cident7266 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cident7291 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cident7310 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ident7336 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ident7361 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ident7380 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_noncol_ident7406 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_noncol_ident7431 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_noncol_ident7450 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_keyspaceName7483 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_indexName7517 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_indexName7520 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_idxName_in_indexName7524 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_columnFamilyName7556 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_columnFamilyName7559 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000003008F63AL});
	public static final BitSet FOLLOW_cfName_in_columnFamilyName7563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_userTypeName7588 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_userTypeName7590 = new BitSet(new long[]{0x7082360086100000L,0x03D34721476E181AL,0x0000000020002632L});
	public static final BitSet FOLLOW_non_type_ident_in_userTypeName7596 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_roleName_in_userOrRoleName7628 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ksName7651 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ksName7676 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ksName7695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_ksName7705 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cfName7727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cfName7752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cfName7771 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_cfName7781 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_idxName7803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_idxName7828 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_idxName7847 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_idxName7857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_roleName7879 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_roleName7904 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_roleName7923 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_roleName7933 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_constant7958 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_constant7970 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_constant7989 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOOLEAN_in_constant8010 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UUID_in_constant8029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEXNUMBER_in_constant8051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_175_in_constant8069 = new BitSet(new long[]{0x0000000000000000L,0x0000000020000400L});
	public static final BitSet FOLLOW_set_in_constant8078 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_mapLiteral8107 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x190288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8125 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_mapLiteral8127 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8131 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_174_in_mapLiteral8137 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8141 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_mapLiteral8143 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_mapLiteral8147 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_188_in_mapLiteral8163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_setOrMapLiteral8187 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8191 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_setOrMapLiteral8207 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8211 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_setOrMapLiteral8213 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8217 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_setOrMapLiteral8252 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral8256 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_184_in_collectionLiteral8290 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x0D0288093008F63BL});
	public static final BitSet FOLLOW_term_in_collectionLiteral8308 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400400000000000L});
	public static final BitSet FOLLOW_174_in_collectionLiteral8314 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_collectionLiteral8318 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400400000000000L});
	public static final BitSet FOLLOW_186_in_collectionLiteral8334 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_collectionLiteral8344 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_collectionLiteral8348 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1002400000000000L});
	public static final BitSet FOLLOW_setOrMapLiteral_in_collectionLiteral8352 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_188_in_collectionLiteral8357 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_collectionLiteral8375 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000000000000000L});
	public static final BitSet FOLLOW_188_in_collectionLiteral8377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_187_in_usertypeLiteral8421 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_usertypeLiteral8425 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_usertypeLiteral8427 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_usertypeLiteral8431 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_174_in_usertypeLiteral8437 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_usertypeLiteral8441 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_177_in_usertypeLiteral8443 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_usertypeLiteral8447 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x1000400000000000L});
	public static final BitSet FOLLOW_188_in_usertypeLiteral8454 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleLiteral8491 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_tupleLiteral8495 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleLiteral8501 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_tupleLiteral8505 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleLiteral8512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_value8535 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionLiteral_in_value8557 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_usertypeLiteral_in_value8570 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleLiteral_in_value8585 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NULL_in_value8601 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_value8625 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_value8629 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_value8640 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_intValue8686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_intValue8700 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_intValue8704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_intValue8715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_keyspaceName_in_functionName8749 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_176_in_functionName8751 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476A5A1AL,0x000000002000F633L});
	public static final BitSet FOLLOW_allowedFunctionName_in_functionName8757 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_allowedFunctionName8784 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_allowedFunctionName8818 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_allowedFunctionName8846 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_allowedFunctionName8856 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNT_in_allowedFunctionName8888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function8935 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_function8937 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_function8939 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function8969 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_171_in_function8971 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_functionArgs_in_function8975 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_function8977 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_functionArgs9010 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_functionArgs9016 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_functionArgs9020 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_value_in_term9048 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_function_in_term9085 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_term9117 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_term9121 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_term9123 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_term9127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnOperation9150 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0120000000000000L});
	public static final BitSet FOLLOW_columnOperationDifferentiator_in_columnOperation9152 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_181_in_columnOperationDifferentiator9171 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_normalColumnOperation_in_columnOperationDifferentiator9173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_184_in_columnOperationDifferentiator9182 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnOperationDifferentiator9186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_columnOperationDifferentiator9188 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator9190 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation9211 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_173_in_normalColumnOperation9214 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation9218 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation9239 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000A00000000000L});
	public static final BitSet FOLLOW_set_in_normalColumnOperation9243 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_normalColumnOperation9253 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation9271 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_INTEGER_in_normalColumnOperation9275 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_181_in_specializedColumnOperation9301 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_specializedColumnOperation9305 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnCondition9338 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x01F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition9352 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnCondition9356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition9370 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002080010000000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition9388 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition9408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_184_in_columnCondition9436 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnCondition9440 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_columnCondition9442 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition9460 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_columnCondition9464 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition9482 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002080010000000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition9504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition9528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_properties9590 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_K_AND_in_properties9594 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_property_in_properties9596 = new BitSet(new long[]{0x0000000020000002L});
	public static final BitSet FOLLOW_noncol_ident_in_property9619 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_property9621 = new BitSet(new long[]{0xF18EF6E286244040L,0x7FF34721676E5E1AL,0x000080090008F63AL});
	public static final BitSet FOLLOW_propertyValue_in_property9625 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_noncol_ident_in_property9637 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_181_in_property9639 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
	public static final BitSet FOLLOW_mapLiteral_in_property9643 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_propertyValue9668 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue9690 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_181_in_relationType9713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_179_in_relationType9724 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_180_in_relationType9735 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_182_in_relationType9745 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_183_in_relationType9756 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_170_in_relationType9766 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9788 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_relation9792 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9796 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_relation9806 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation9810 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_relation9814 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9818 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9838 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_IN_in_relation9840 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_inMarker_in_relation9844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9864 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_IN_in_relation9866 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_relation9870 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9890 = new BitSet(new long[]{0x0000200000000000L});
	public static final BitSet FOLLOW_K_CONTAINS_in_relation9892 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_K_KEY_in_relation9897 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9913 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation9925 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_184_in_relation9927 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9931 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_186_in_relation9933 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00F8040000000000L});
	public static final BitSet FOLLOW_relationType_in_relation9937 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_relation9941 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation9953 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L,0x00F8040000000000L});
	public static final BitSet FOLLOW_K_IN_in_relation9963 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002080010000000L});
	public static final BitSet FOLLOW_171_in_relation9977 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_relation9979 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarkerForTuple_in_relation10011 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfTupleLiterals_in_relation10045 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfMarkersForTuples_in_relation10079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation10121 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleLiteral_in_relation10125 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation10151 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_markerForTuple_in_relation10155 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_relation10185 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000008002008F63BL});
	public static final BitSet FOLLOW_relation_in_relation10187 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000100000000000L});
	public static final BitSet FOLLOW_172_in_relation10190 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarker10211 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_inMarker10221 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_inMarker10225 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleOfIdentifiers10257 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers10261 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleOfIdentifiers10266 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers10270 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleOfIdentifiers10276 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_singleColumnInValues10306 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090298093008F63BL});
	public static final BitSet FOLLOW_term_in_singleColumnInValues10314 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_singleColumnInValues10319 = new BitSet(new long[]{0xF18EF6E286344040L,0x7FF34725676E5E1AL,0x090288093008F63BL});
	public static final BitSet FOLLOW_term_in_singleColumnInValues10323 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_singleColumnInValues10332 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleOfTupleLiterals10362 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10366 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleOfTupleLiterals10371 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals10375 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleOfTupleLiterals10381 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_markerForTuple10402 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_markerForTuple10412 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_markerForTuple10416 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_171_in_tupleOfMarkersForTuples10448 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10452 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_174_in_tupleOfMarkersForTuples10457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0002000010000000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples10461 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000500000000000L});
	public static final BitSet FOLLOW_172_in_tupleOfMarkersForTuples10467 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarkerForTuple10488 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_177_in_inMarkerForTuple10498 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FF34721476E5A1AL,0x000000002008F63AL});
	public static final BitSet FOLLOW_noncol_ident_in_inMarkerForTuple10502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_comparatorType10527 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collection_type_in_comparatorType10543 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tuple_type_in_comparatorType10555 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_comparatorType10571 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FROZEN_in_comparatorType10583 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_comparatorType10585 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_comparatorType10589 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_comparatorType10591 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType10609 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ASCII_in_native_type10638 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BIGINT_in_native_type10652 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BLOB_in_native_type10665 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BOOLEAN_in_native_type10680 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNTER_in_native_type10692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DECIMAL_in_native_type10704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DOUBLE_in_native_type10716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FLOAT_in_native_type10729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INET_in_native_type10743 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INT_in_native_type10758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SMALLINT_in_native_type10774 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TEXT_in_native_type10785 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type10800 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TINYINT_in_native_type10810 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UUID_in_native_type10822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARCHAR_in_native_type10837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARINT_in_native_type10849 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMEUUID_in_native_type10862 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DATE_in_native_type10873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIME_in_native_type10888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MAP_in_collection_type10916 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_collection_type10919 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_174_in_collection_type10925 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10929 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_collection_type10931 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_collection_type10949 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_collection_type10951 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10955 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_collection_type10957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SET_in_collection_type10975 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_collection_type10978 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_collection_type10982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_182_in_collection_type10984 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TUPLE_in_tuple_type11015 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_179_in_tuple_type11017 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type11032 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040400000000000L});
	public static final BitSet FOLLOW_174_in_tuple_type11037 = new BitSet(new long[]{0xF18EF6E286100000L,0x7FFB4721476E5A1AL,0x000000012008F63AL});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type11041 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0040400000000000L});
	public static final BitSet FOLLOW_182_in_tuple_type11053 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_non_type_ident11105 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_non_type_ident11136 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_non_type_ident11161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEY_in_non_type_ident11173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword11216 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_unreserved_keyword11232 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword11271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword11283 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_basic_unreserved_keyword11321 = new BitSet(new long[]{0x0000000000000002L});
}
