/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.utils.concurrent.RefCountedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ref {
    static final Logger logger = LoggerFactory.getLogger(Ref.class);
    static final boolean DEBUG_ENABLED = System.getProperty("cassandra.debugrefcount", "false").equalsIgnoreCase("true");
    final State state;

    Ref(RefCountedImpl.GlobalState state, boolean isSharedRef) {
        this.state = new State(state, this, RefCountedImpl.referenceQueue, isSharedRef);
    }

    public void release() {
        this.state.release(false);
    }

    public int globalCount() {
        return this.state.globalState.count();
    }

    static final class Debug {
        String allocateThread;
        String deallocateThread;
        StackTraceElement[] allocateTrace;
        StackTraceElement[] deallocateTrace;

        Debug() {
            Thread thread = Thread.currentThread();
            this.allocateThread = thread.toString();
            this.allocateTrace = thread.getStackTrace();
        }

        synchronized void deallocate() {
            Thread thread = Thread.currentThread();
            this.deallocateThread = thread.toString();
            this.deallocateTrace = thread.getStackTrace();
        }

        synchronized void log(String id) {
            logger.error("Allocate trace {}:\n{}", (Object)id, (Object)this.print(this.allocateThread, this.allocateTrace));
            if (this.deallocateThread != null) {
                logger.error("Deallocate trace {}:\n{}", (Object)id, (Object)this.print(this.deallocateThread, this.deallocateTrace));
            }
        }

        String print(String thread, StackTraceElement[] trace) {
            StringBuilder sb = new StringBuilder();
            sb.append(thread.toString());
            sb.append("\n");
            for (StackTraceElement element : trace) {
                sb.append("\tat ");
                sb.append(element);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    static final class State
    extends PhantomReference<Ref> {
        final Debug debug = DEBUG_ENABLED ? new Debug() : null;
        final boolean isSharedRef;
        final RefCountedImpl.GlobalState globalState;
        private volatile int released;
        private static final AtomicIntegerFieldUpdater<State> releasedUpdater = AtomicIntegerFieldUpdater.newUpdater(State.class, "released");

        public State(RefCountedImpl.GlobalState globalState, Ref reference, ReferenceQueue<? super Ref> q, boolean isSharedRef) {
            super(reference, q);
            this.globalState = globalState;
            this.isSharedRef = isSharedRef;
            globalState.register(this);
        }

        void release(boolean leak) {
            if (!releasedUpdater.compareAndSet(this, 0, 1)) {
                if (!leak) {
                    String id = this.toString();
                    logger.error("BAD RELEASE: attempted to release a{} reference ({}) that has already been released", (Object)(this.isSharedRef ? " shared" : ""), (Object)id);
                    if (DEBUG_ENABLED) {
                        this.debug.log(id);
                    }
                    throw new IllegalStateException("Attempted to release a reference that has already been released");
                }
                return;
            }
            this.globalState.release(this);
            if (leak) {
                String id = this.toString();
                if (this.isSharedRef) {
                    logger.error("LEAK DETECTED: the shared reference ({}) to {} was not released before the object was garbage collected", (Object)id, (Object)this.globalState);
                } else {
                    logger.error("LEAK DETECTED: a reference ({}) to {} was not released before the reference was garbage collected", (Object)id, (Object)this.globalState);
                }
                if (DEBUG_ENABLED) {
                    this.debug.log(id);
                }
            } else if (DEBUG_ENABLED) {
                this.debug.deallocate();
            }
        }
    }
}

