/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.addthis.metrics.reporter.config.ReporterConfig;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.NativeAccessMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ThriftServer;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=NativeAccess";
    private static final Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private static final CassandraDaemon instance = new CassandraDaemon();
    private static final long EARLIEST_LAUNCH_DATE = 1215820800000L;
    public Server thriftServer;
    public Server nativeServer;
    private final boolean runManaged;

    public CassandraDaemon() {
        this(false);
    }

    public CassandraDaemon(boolean runManaged) {
        this.runManaged = runManaged;
    }

    protected void setup() {
        try {
            logger.info("Hostname: {}", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e1) {
            logger.info("Could not resolve local host");
        }
        long now = System.currentTimeMillis();
        if (now < 1215820800000L) {
            logger.error("current machine time is {}, but that is seemingly incorrect. exiting now.", (Object)new Date(now));
            System.exit(3);
        }
        if (!DatabaseDescriptor.hasLargeAddressSpace()) {
            logger.info("32bit JVM detected.  It is recommended to run Cassandra on a 64bit JVM for better performance.");
        }
        String javaVersion = System.getProperty("java.version");
        String javaVmName = System.getProperty("java.vm.name");
        logger.info("JVM vendor/version: {}/{}", (Object)javaVmName, (Object)javaVersion);
        if (javaVmName.contains("OpenJDK")) {
            logger.warn("OpenJDK is not recommended. Please upgrade to the newest Oracle Java release");
        } else if (!javaVmName.contains("HotSpot")) {
            logger.warn("Non-Oracle JVM detected.  Some features, such as immediate unmap of compacted SSTables, may not work as intended");
        }
        logger.info("Heap size: {}/{}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().maxMemory());
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            logger.info("{} {}: {}", new Object[]{pool.getName(), pool.getType(), pool.getPeakUsage()});
        }
        logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
        if (!CLibrary.jnaAvailable()) {
            boolean jnaRequired;
            boolean bl = jnaRequired = !Boolean.getBoolean("cassandra.boot_without_jna");
            if (jnaRequired) {
                this.exitOrFail(3, "JNA failing to initialize properly. Use -Dcassandra.boot_without_jna=true to bootstrap even so.");
            }
        }
        CLibrary.tryMlockall();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StorageMetrics.exceptions.inc();
                logger.error("Exception in thread {}", (Object)t, (Object)e);
                Tracing.trace("Exception in thread {}", t, e);
                for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                    JVMStabilityInspector.inspectThrowable(e2);
                    if (e2 instanceof FSError) {
                        if (e2 != e) {
                            logger.error("Exception in thread {}", (Object)t, (Object)e2);
                        }
                        FileUtils.handleFSError((FSError)e2);
                    }
                    if (!(e2 instanceof CorruptSSTableException)) continue;
                    if (e2 != e) {
                        logger.error("Exception in thread " + t, e2);
                    }
                    FileUtils.handleCorruptSSTable((CorruptSSTableException)e2);
                }
            }
        });
        Iterable dirs = Iterables.concat(Arrays.asList(DatabaseDescriptor.getAllDataFileLocations()), Arrays.asList(DatabaseDescriptor.getCommitLogLocation(), DatabaseDescriptor.getSavedCachesLocation()));
        for (String dataDir : dirs) {
            logger.debug("Checking directory {}", (Object)dataDir);
            File dir = new File(dataDir);
            if (!dir.exists()) {
                logger.error("Directory {} doesn't exist", (Object)dataDir);
                if (!dir.mkdirs()) {
                    this.exitOrFail(3, "Has no permission to create directory " + dataDir);
                }
            }
            if (Directories.verifyFullPermissions(dir, dataDir)) continue;
            this.exitOrFail(3, "Insufficient permissions on directory " + dataDir);
        }
        if (CacheService.instance == null) {
            throw new RuntimeException("Failed to initialize Cache Service.");
        }
        for (CFMetaData cfm : Schema.instance.getKeyspaceMetaData("system").values()) {
            ColumnFamilyStore.scrubDataDirectories(cfm);
        }
        try {
            SystemKeyspace.checkHealth();
        }
        catch (ConfigurationException e) {
            this.exitOrFail(100, "Fatal exception during initialization", e);
        }
        DatabaseDescriptor.loadSchemas();
        Map<Pair<String, String>, Map<Integer, UUID>> unfinishedCompactions = SystemKeyspace.getUnfinishedCompactions();
        for (Pair<String, String> kscf : unfinishedCompactions.keySet()) {
            CFMetaData cfm = Schema.instance.getCFMetaData((String)kscf.left, (String)kscf.right);
            if (cfm == null) continue;
            ColumnFamilyStore.removeUnfinishedCompactionLeftovers(cfm, unfinishedCompactions.get(kscf));
        }
        SystemKeyspace.discardCompactionsInProgress();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (keyspaceName.equals("system")) continue;
            for (CFMetaData cfm : Schema.instance.getKeyspaceMetaData(keyspaceName).values()) {
                ColumnFamilyStore.scrubDataDirectories(cfm);
            }
        }
        Keyspace.setInitialized();
        for (String keyspaceName : Schema.instance.getKeyspaces()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace {}", (Object)keyspaceName);
            }
            for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.disableAutoCompaction();
                }
            }
        }
        if (CacheService.instance.keyCache.size() > 0) {
            logger.info("completed pre-loading ({} keys) key cache.", (Object)CacheService.instance.keyCache.size());
        }
        if (CacheService.instance.rowCache.size() > 0) {
            logger.info("completed pre-loading ({} keys) row cache.", (Object)CacheService.instance.rowCache.size());
        }
        try {
            GCInspector.register();
        }
        catch (Throwable t) {
            JVMStabilityInspector.inspectThrowable(t);
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        try {
            CommitLog.instance.recover();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore cfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    if (!store.getCompactionStrategy().shouldBeEnabled()) continue;
                    store.enableAutoCompaction();
                }
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (Keyspace keyspaceName : Keyspace.all()) {
                    for (ColumnFamilyStore cf : keyspaceName.getColumnFamilyStores()) {
                        for (ColumnFamilyStore store : cf.concatWithIndexes()) {
                            CompactionManager.instance.submitBackground(store);
                        }
                    }
                }
            }
        };
        ScheduledExecutors.optionalTasks.schedule(runnable, 5L, TimeUnit.MINUTES);
        SystemKeyspace.finishStartup();
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e) {
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            this.exitOrFail(1, "Fatal configuration error", e);
        }
        Mx4jTool.maybeLoad();
        String metricsReporterConfigFile = System.getProperty("cassandra.metricsReporterConfigFile");
        if (metricsReporterConfigFile != null) {
            logger.info("Trying to load metrics-reporter-config from file: {}", (Object)metricsReporterConfigFile);
            try {
                String reportFileLocation = CassandraDaemon.class.getClassLoader().getResource(metricsReporterConfigFile).getFile();
                ReporterConfig.loadFromFile((String)reportFileLocation).enableAll();
            }
            catch (Exception e) {
                logger.warn("Failed to load metrics-reporter-config, metric sinks will not be activated", (Throwable)e);
            }
        }
        if (!FBUtilities.getBroadcastAddress().equals(InetAddress.getLoopbackAddress())) {
            this.waitForGossipToSettle();
        }
        InetAddress rpcAddr = DatabaseDescriptor.getRpcAddress();
        int rpcPort = DatabaseDescriptor.getRpcPort();
        int listenBacklog = DatabaseDescriptor.getRpcListenBacklog();
        this.thriftServer = new ThriftServer(rpcAddr, rpcPort, listenBacklog);
        InetAddress nativeAddr = DatabaseDescriptor.getRpcAddress();
        int nativePort = DatabaseDescriptor.getNativeTransportPort();
        this.nativeServer = new org.apache.cassandra.transport.Server(nativeAddr, nativePort);
    }

    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() {
        String nativeFlag = System.getProperty("cassandra.start_native_transport");
        if (nativeFlag != null && Boolean.parseBoolean(nativeFlag) || nativeFlag == null && DatabaseDescriptor.startNativeTransport()) {
            this.nativeServer.start();
        } else {
            logger.info("Not starting native transport as requested. Use JMX (StorageService->startNativeTransport()) or nodetool (enablebinary) to start it");
        }
        String rpcFlag = System.getProperty("cassandra.start_rpc");
        if (rpcFlag != null && Boolean.parseBoolean(rpcFlag) || rpcFlag == null && DatabaseDescriptor.startRpc()) {
            this.thriftServer.start();
        } else {
            logger.info("Not starting RPC server as requested. Use JMX (StorageService->startRPCServer()) or nodetool (enablethrift) to start it");
        }
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        this.thriftServer.stop();
        this.nativeServer.stop();
        if (FBUtilities.isWindows()) {
            System.exit(0);
        }
    }

    public void destroy() {
    }

    public void activate() {
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(new StandardMBean(new NativeAccess(), NativeAccessMBean.class), new ObjectName(MBEAN_NAME));
            }
            catch (Exception e) {
                logger.error("error registering MBean {}", (Object)MBEAN_NAME, (Object)e);
            }
            this.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            logger.error("Exception encountered during startup", e);
            e.printStackTrace();
            System.out.println("Exception encountered during startup: " + e.getMessage());
            this.exitOrFail(3, "Exception encountered during startup", e);
        }
    }

    public void deactivate() {
        this.stop();
        this.destroy();
        if (!this.runManaged) {
            System.exit(0);
        }
    }

    private void waitForGossipToSettle() {
        int forceAfter = Integer.getInteger("cassandra.skip_wait_for_gossip_to_settle", -1);
        if (forceAfter == 0) {
            return;
        }
        int GOSSIP_SETTLE_MIN_WAIT_MS = 5000;
        int GOSSIP_SETTLE_POLL_INTERVAL_MS = 1000;
        int GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED = 3;
        logger.info("Waiting for gossip to settle before accepting client requests...");
        Uninterruptibles.sleepUninterruptibly((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        int totalPolls = 0;
        int numOkay = 0;
        JMXEnabledThreadPoolExecutor gossipStage = (JMXEnabledThreadPoolExecutor)StageManager.getStage(Stage.GOSSIP);
        while (numOkay < 3) {
            Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            long completed = gossipStage.getCompletedTasks();
            long active = gossipStage.getActiveCount();
            long pending = gossipStage.getPendingTasks();
            ++totalPolls;
            if (active == 0L && pending == 0L) {
                logger.debug("Gossip looks settled. CompletedTasks: {}", (Object)completed);
                ++numOkay;
            } else {
                logger.info("Gossip not settled after {} polls. Gossip Stage active/pending/completed: {}/{}/{}", new Object[]{totalPolls, active, pending, completed});
                numOkay = 0;
            }
            if (forceAfter <= 0 || totalPolls <= forceAfter) continue;
            logger.warn("Gossip not settled but startup forced by cassandra.skip_wait_for_gossip_to_settle. Gossip Stage total/active/pending/completed: {}/{}/{}/{}", new Object[]{totalPolls, active, pending, completed});
            break;
        }
        if (totalPolls > 3) {
            logger.info("Gossip settled after {} extra polls; proceeding", (Object)(totalPolls - 3));
        } else {
            logger.info("No gossip backlog; proceeding");
        }
    }

    public static void stop(String[] args) {
        instance.deactivate();
    }

    public static void main(String[] args) {
        instance.activate();
    }

    private void exitOrFail(int code, String message) {
        this.exitOrFail(code, message, null);
    }

    private void exitOrFail(int code, String message, Throwable cause) {
        if (this.runManaged) {
            RuntimeException t = cause != null ? new RuntimeException(message, cause) : new RuntimeException(message);
            throw t;
        }
        logger.error(message, cause);
        System.exit(code);
    }

    public static interface Server {
        public void start();

        public void stop();

        public boolean isRunning();
    }

    static class NativeAccess
    implements NativeAccessMBean {
        NativeAccess() {
        }

        @Override
        public boolean isAvailable() {
            return CLibrary.jnaAvailable();
        }

        @Override
        public boolean isMemoryLockable() {
            return CLibrary.jnaMemoryLockable();
        }
    }
}

