/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.zip.Adler32;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.SequentialWriter;

public class CompressedSequentialWriter
extends SequentialWriter {
    private final DataIntegrityMetadata.ChecksumWriter crcMetadata;
    private long chunkOffset = 0L;
    private final CompressionMetadata.Writer metadataWriter;
    private final ICompressor compressor;
    private final ICompressor.WrappedArray compressed;
    private int chunkCount = 0;
    private long originalSize = 0L;
    private long compressedSize = 0L;
    private final MetadataCollector sstableMetadataCollector;

    public CompressedSequentialWriter(File file, String offsetsPath, CompressionParameters parameters, MetadataCollector sstableMetadataCollector) {
        super(file, parameters.chunkLength());
        this.compressor = parameters.sstableCompressor;
        this.compressed = new ICompressor.WrappedArray(new byte[this.compressor.initialCompressedBufferLength(this.buffer.length)]);
        this.metadataWriter = CompressionMetadata.Writer.open(parameters, offsetsPath);
        this.sstableMetadataCollector = sstableMetadataCollector;
        this.crcMetadata = new DataIntegrityMetadata.ChecksumWriter(this.out);
    }

    @Override
    public long getOnDiskFilePointer() {
        try {
            return this.out.getFilePointer();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    @Override
    public void sync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void flushData() {
        int compressedLength;
        this.seekToChunkStart();
        try {
            compressedLength = this.compressor.compress(this.buffer, 0, this.validBufferBytes, this.compressed, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Compression exception", e);
        }
        this.originalSize += (long)this.validBufferBytes;
        this.compressedSize += (long)compressedLength;
        try {
            this.metadataWriter.addOffset(this.chunkOffset);
            ++this.chunkCount;
            assert (compressedLength <= this.compressed.buffer.length);
            this.out.write(this.compressed.buffer, 0, compressedLength);
            this.crcMetadata.append(this.compressed.buffer, 0, compressedLength);
            this.lastFlushOffset += (long)(compressedLength + 4);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
        this.chunkOffset += (long)(compressedLength + 4);
    }

    public CompressionMetadata open(SSTableWriter.FinishType finishType) {
        assert (finishType != SSTableWriter.FinishType.NORMAL || this.current == this.originalSize);
        return this.metadataWriter.open(this.originalSize, this.chunkOffset, finishType);
    }

    @Override
    public FileMark mark() {
        return new CompressedFileWriterMark(this.chunkOffset, this.current, this.validBufferBytes, this.chunkCount + 1);
    }

    @Override
    public synchronized void resetAndTruncate(FileMark mark) {
        assert (mark instanceof CompressedFileWriterMark);
        CompressedFileWriterMark realMark = (CompressedFileWriterMark)mark;
        this.current = realMark.uncDataOffset;
        if (realMark.chunkOffset == this.chunkOffset) {
            this.validBufferBytes = realMark.bufferOffset;
            return;
        }
        this.syncInternal();
        this.chunkOffset = realMark.chunkOffset;
        int chunkSize = (int)(this.metadataWriter.chunkOffsetBy(realMark.nextChunkIndex) - this.chunkOffset - 4L);
        if (this.compressed.buffer.length < chunkSize) {
            this.compressed.buffer = new byte[chunkSize];
        }
        try {
            this.out.seek(this.chunkOffset);
            this.out.readFully(this.compressed.buffer, 0, chunkSize);
            try {
                this.compressor.uncompress(this.compressed.buffer, 0, chunkSize, this.buffer, 0);
            }
            catch (IOException e) {
                throw new CorruptBlockException(this.getPath(), this.chunkOffset, chunkSize);
            }
            Adler32 checksum = new Adler32();
            checksum.update(this.compressed.buffer, 0, chunkSize);
            if (this.out.readInt() != (int)checksum.getValue()) {
                throw new CorruptBlockException(this.getPath(), this.chunkOffset, chunkSize);
            }
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
        catch (EOFException e) {
            throw new CorruptSSTableException((Exception)new CorruptBlockException(this.getPath(), this.chunkOffset, chunkSize), this.getPath());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
        this.validBufferBytes = realMark.bufferOffset;
        this.bufferOffset = this.current - (long)this.validBufferBytes;
        this.chunkCount = realMark.nextChunkIndex - 1;
        this.truncate(this.chunkOffset);
        this.metadataWriter.resetAndTruncate(realMark.nextChunkIndex - 1);
    }

    private void seekToChunkStart() {
        if (this.getOnDiskFilePointer() != this.chunkOffset) {
            try {
                this.out.seek(this.chunkOffset);
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, this.getPath());
            }
        }
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        super.close();
        this.sstableMetadataCollector.addCompressionRatio(this.compressedSize, this.originalSize);
        try {
            this.metadataWriter.close(this.current, this.chunkCount);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public void abort() {
        super.abort();
        this.metadataWriter.abort();
    }

    @Override
    public void writeFullChecksum(Descriptor descriptor) {
        this.crcMetadata.writeFullChecksum(descriptor);
    }

    protected static class CompressedFileWriterMark
    implements FileMark {
        final long chunkOffset;
        final long uncDataOffset;
        final int bufferOffset;
        final int nextChunkIndex;

        public CompressedFileWriterMark(long chunkOffset, long uncDataOffset, int bufferOffset, int nextChunkIndex) {
            this.chunkOffset = chunkOffset;
            this.uncDataOffset = uncDataOffset;
            this.bufferOffset = bufferOffset;
            this.nextChunkIndex = nextChunkIndex;
        }
    }
}

