/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;

public class ColumnCounter {
    protected int live;
    protected int ignored;
    protected final long timestamp;

    public ColumnCounter(long timestamp) {
        this.timestamp = timestamp;
    }

    public void count(Cell cell, DeletionInfo.InOrderTester tester) {
        if (!ColumnCounter.isLive(cell, tester, this.timestamp)) {
            ++this.ignored;
        } else {
            ++this.live;
        }
    }

    protected static boolean isLive(Cell cell, DeletionInfo.InOrderTester tester, long timestamp) {
        return cell.isLive(timestamp) && !tester.isDeleted(cell);
    }

    public int live() {
        return this.live;
    }

    public int ignored() {
        return this.ignored;
    }

    public ColumnCounter countAll(ColumnFamily container) {
        if (container == null) {
            return this;
        }
        DeletionInfo.InOrderTester tester = container.inOrderDeletionTester();
        for (Cell c : container) {
            this.count(c, tester);
        }
        return this;
    }

    public static class GroupByPrefix
    extends ColumnCounter {
        private final CellNameType type;
        private final int toGroup;
        private CellName previous;

        public GroupByPrefix(long timestamp, CellNameType type, int toGroup) {
            super(timestamp);
            this.type = type;
            this.toGroup = toGroup;
            assert (toGroup == 0 || type != null);
        }

        @Override
        public void count(Cell cell, DeletionInfo.InOrderTester tester) {
            if (!GroupByPrefix.isLive(cell, tester, this.timestamp)) {
                ++this.ignored;
                return;
            }
            if (this.toGroup == 0) {
                this.live = 1;
                return;
            }
            CellName current = cell.name();
            assert (current.size() >= this.toGroup);
            if (this.previous != null) {
                boolean isSameGroup;
                boolean bl = isSameGroup = this.previous.isStatic() == current.isStatic();
                if (isSameGroup) {
                    for (int i = 0; i < this.toGroup; ++i) {
                        if (this.type.subtype(i).compare(this.previous.get(i), current.get(i)) == 0) continue;
                        isSameGroup = false;
                        break;
                    }
                }
                if (isSameGroup) {
                    return;
                }
                if (this.previous.isStatic()) {
                    this.previous = current;
                    return;
                }
            }
            ++this.live;
            this.previous = current;
        }
    }
}

