/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.metrics.KeyspaceMetrics;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.QueryPagers;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keyspace {
    public static final String SYSTEM_KS = "system";
    private static final int DEFAULT_PAGE_SIZE = 10000;
    private static final Logger logger = LoggerFactory.getLogger(Keyspace.class);
    public final KeyspaceMetrics metric;
    public final KSMetaData metadata;
    public final OpOrder writeOrder = new OpOrder();
    private final ConcurrentMap<UUID, ColumnFamilyStore> columnFamilyStores = new ConcurrentHashMap<UUID, ColumnFamilyStore>();
    private volatile AbstractReplicationStrategy replicationStrategy;
    public static final Function<String, Keyspace> keyspaceTransformer;
    private static volatile boolean initialized;

    public static void setInitialized() {
        initialized = true;
    }

    public static Keyspace open(String keyspaceName) {
        assert (initialized || keyspaceName.equals(SYSTEM_KS));
        return Keyspace.open(keyspaceName, Schema.instance, true);
    }

    public static Keyspace openWithoutSSTables(String keyspaceName) {
        return Keyspace.open(keyspaceName, Schema.instance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Keyspace open(String keyspaceName, Schema schema, boolean loadSSTables) {
        Keyspace keyspaceInstance = schema.getKeyspaceInstance(keyspaceName);
        if (keyspaceInstance != null) return keyspaceInstance;
        Class<Keyspace> clazz = Keyspace.class;
        synchronized (Keyspace.class) {
            keyspaceInstance = schema.getKeyspaceInstance(keyspaceName);
            if (keyspaceInstance != null) return keyspaceInstance;
            keyspaceInstance = new Keyspace(keyspaceName, loadSSTables);
            schema.storeKeyspaceInstance(keyspaceInstance);
            for (ColumnFamilyStore cfs : keyspaceInstance.getColumnFamilyStores()) {
                cfs.initRowCache();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return keyspaceInstance;
        }
    }

    public static Keyspace clear(String keyspaceName) {
        return Keyspace.clear(keyspaceName, Schema.instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyspace clear(String keyspaceName, Schema schema) {
        Class<Keyspace> clazz = Keyspace.class;
        synchronized (Keyspace.class) {
            Keyspace t = schema.removeKeyspaceInstance(keyspaceName);
            if (t != null) {
                for (ColumnFamilyStore cfs : t.getColumnFamilyStores()) {
                    t.unloadCf(cfs);
                }
                t.metric.release();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return t;
        }
    }

    public static void removeUnreadableSSTables(File directory) {
        for (Keyspace keyspace : Keyspace.all()) {
            for (ColumnFamilyStore baseCfs : keyspace.getColumnFamilyStores()) {
                for (ColumnFamilyStore cfs : baseCfs.concatWithIndexes()) {
                    cfs.maybeRemoveUnreadableSSTables(directory);
                }
            }
        }
    }

    public Collection<ColumnFamilyStore> getColumnFamilyStores() {
        return Collections.unmodifiableCollection(this.columnFamilyStores.values());
    }

    public ColumnFamilyStore getColumnFamilyStore(String cfName) {
        UUID id = Schema.instance.getId(this.getName(), cfName);
        if (id == null) {
            throw new IllegalArgumentException(String.format("Unknown keyspace/cf pair (%s.%s)", this.getName(), cfName));
        }
        return this.getColumnFamilyStore(id);
    }

    public ColumnFamilyStore getColumnFamilyStore(UUID id) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(id);
        if (cfs == null) {
            throw new IllegalArgumentException("Unknown CF " + id);
        }
        return cfs;
    }

    public void snapshot(String snapshotName, String columnFamilyName) throws IOException {
        assert (snapshotName != null);
        boolean tookSnapShot = false;
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (columnFamilyName != null && !cfStore.name.equals(columnFamilyName)) continue;
            tookSnapShot = true;
            cfStore.snapshot(snapshotName);
        }
        if (columnFamilyName != null && !tookSnapShot) {
            throw new IOException("Failed taking snapshot. Column family " + columnFamilyName + " does not exist.");
        }
    }

    public static String getTimestampedSnapshotName(String clientSuppliedName) {
        String snapshotName = Long.toString(System.currentTimeMillis());
        if (clientSuppliedName != null && !clientSuppliedName.equals("")) {
            snapshotName = snapshotName + "-" + clientSuppliedName;
        }
        return snapshotName;
    }

    public boolean snapshotExists(String snapshotName) {
        assert (snapshotName != null);
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            if (!cfStore.snapshotExists(snapshotName)) continue;
            return true;
        }
        return false;
    }

    public static void clearSnapshot(String snapshotName, String keyspace) {
        List<File> snapshotDirs = Directories.getKSChildDirectories(keyspace);
        Directories.clearSnapshot(snapshotName, snapshotDirs);
    }

    public List<SSTableReader> getAllSSTables() {
        ArrayList<SSTableReader> list = new ArrayList<SSTableReader>(this.columnFamilyStores.size());
        for (ColumnFamilyStore cfStore : this.columnFamilyStores.values()) {
            list.addAll(cfStore.getSSTables());
        }
        return list;
    }

    private Keyspace(String keyspaceName, boolean loadSSTables) {
        this.metadata = Schema.instance.getKSMetaData(keyspaceName);
        assert (this.metadata != null) : "Unknown keyspace " + keyspaceName;
        this.createReplicationStrategy(this.metadata);
        this.metric = new KeyspaceMetrics(this);
        for (CFMetaData cfm : new ArrayList<CFMetaData>(this.metadata.cfMetaData().values())) {
            logger.debug("Initializing {}.{}", (Object)this.getName(), (Object)cfm.cfName);
            this.initCf(cfm.cfId, cfm.cfName, loadSSTables);
        }
    }

    public void createReplicationStrategy(KSMetaData ksm) {
        this.replicationStrategy = AbstractReplicationStrategy.createReplicationStrategy(ksm.name, ksm.strategyClass, StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), ksm.strategyOptions);
    }

    public void dropCf(UUID cfId) {
        assert (this.columnFamilyStores.containsKey(cfId));
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.remove(cfId);
        if (cfs == null) {
            return;
        }
        cfs.keyspace.writeOrder.awaitNewBarrier();
        cfs.readOrdering.awaitNewBarrier();
        this.unloadCf(cfs);
    }

    private void unloadCf(ColumnFamilyStore cfs) {
        cfs.forceBlockingFlush();
        cfs.invalidate();
    }

    public void initCf(UUID cfId, String cfName, boolean loadSSTables) {
        ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(cfId);
        if (cfs == null) {
            ColumnFamilyStore oldCfs = this.columnFamilyStores.putIfAbsent(cfId, ColumnFamilyStore.createColumnFamilyStore(this, cfName, loadSSTables));
            if (oldCfs != null) {
                throw new IllegalStateException("added multiple mappings for cf id " + cfId);
            }
        } else {
            assert (cfs.name.equals(cfName));
            cfs.metadata.reload();
            cfs.reload();
        }
    }

    public Row getRow(QueryFilter filter) {
        ColumnFamilyStore cfStore = this.getColumnFamilyStore(filter.getColumnFamilyName());
        ColumnFamily columnFamily = cfStore.getColumnFamily(filter);
        return new Row(filter.key, columnFamily);
    }

    public void apply(Mutation mutation, boolean writeCommitLog) {
        this.apply(mutation, writeCommitLog, true);
    }

    public void apply(Mutation mutation, boolean writeCommitLog, boolean updateIndexes) {
        try (OpOrder.Group opGroup = this.writeOrder.start();){
            ReplayPosition replayPosition = null;
            if (writeCommitLog) {
                Tracing.trace("Appending to commitlog");
                replayPosition = CommitLog.instance.add(mutation);
            }
            DecoratedKey key = StorageService.getPartitioner().decorateKey(mutation.key());
            for (ColumnFamily cf : mutation.getColumnFamilies()) {
                ColumnFamilyStore cfs = (ColumnFamilyStore)this.columnFamilyStores.get(cf.id());
                if (cfs == null) {
                    logger.error("Attempting to mutate non-existant column family {}", (Object)cf.id());
                    continue;
                }
                Tracing.trace("Adding to {} memtable", cf.metadata().cfName);
                SecondaryIndexManager.Updater updater = updateIndexes ? cfs.indexManager.updaterFor(key, cf, opGroup) : SecondaryIndexManager.nullUpdater;
                cfs.apply(key, cf, updater, opGroup, replayPosition);
            }
        }
    }

    public AbstractReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public static void indexRow(DecoratedKey key, ColumnFamilyStore cfs, Set<String> idxNames) {
        if (logger.isDebugEnabled()) {
            logger.debug("Indexing row {} ", (Object)cfs.metadata.getKeyValidator().getString(key.getKey()));
        }
        try (OpOrder.Group opGroup = cfs.keyspace.writeOrder.start();){
            Set<SecondaryIndex> indexes = cfs.indexManager.getIndexesByNames(idxNames);
            Iterator<ColumnFamily> pager = QueryPagers.pageRowLocally(cfs, key.getKey(), 10000);
            while (pager.hasNext()) {
                ColumnFamily cf = pager.next();
                ColumnFamily cf2 = cf.cloneMeShallow();
                for (Cell cell : cf) {
                    if (!cfs.indexManager.indexes(cell.name(), indexes)) continue;
                    cf2.addColumn(cell);
                }
                cfs.indexManager.indexRow(key.getKey(), cf2, opGroup);
            }
        }
    }

    public List<Future<?>> flush() {
        ArrayList futures = new ArrayList(this.columnFamilyStores.size());
        for (UUID cfId : this.columnFamilyStores.keySet()) {
            futures.add((Future<?>)((ColumnFamilyStore)this.columnFamilyStores.get(cfId)).forceFlush());
        }
        return futures;
    }

    public static Iterable<Keyspace> all() {
        return Iterables.transform(Schema.instance.getKeyspaces(), keyspaceTransformer);
    }

    public static Iterable<Keyspace> nonSystem() {
        return Iterables.transform(Schema.instance.getNonSystemKeyspaces(), keyspaceTransformer);
    }

    public static Iterable<Keyspace> system() {
        return Iterables.transform(Schema.systemKeyspaceNames, keyspaceTransformer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name='" + this.getName() + "')";
    }

    public String getName() {
        return this.metadata.name;
    }

    static {
        if (!Config.isClientMode() && !StorageService.instance.isClientMode()) {
            DatabaseDescriptor.createAllDirectories();
        }
        keyspaceTransformer = new Function<String, Keyspace>(){

            public Keyspace apply(String keyspaceName) {
                return Keyspace.open(keyspaceName);
            }
        };
        initialized = false;
    }
}

