// $ANTLR 3.2 Sep 23, 2009 12:02:23 /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2013-07-22 17:17:18

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.Permission;
    import org.apache.cassandra.auth.DataResource;
    import org.apache.cassandra.auth.IResource;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.functions.FunctionCall;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class CqlParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "K_USE", "K_SELECT", "K_COUNT", "K_AS", "K_FROM", "K_WHERE", "K_ORDER", "K_BY", "K_LIMIT", "K_ALLOW", "K_FILTERING", "K_WRITETIME", "K_TTL", "INTEGER", "K_AND", "K_ASC", "K_DESC", "K_INSERT", "K_INTO", "K_VALUES", "K_IF", "K_NOT", "K_EXISTS", "K_USING", "K_TIMESTAMP", "K_UPDATE", "K_SET", "K_DELETE", "K_BEGIN", "K_UNLOGGED", "K_COUNTER", "K_BATCH", "K_APPLY", "K_CREATE", "K_KEYSPACE", "K_WITH", "K_COLUMNFAMILY", "K_PRIMARY", "K_KEY", "K_COMPACT", "K_STORAGE", "K_CLUSTERING", "K_CUSTOM", "K_INDEX", "IDENT", "K_ON", "STRING_LITERAL", "K_TRIGGER", "K_DROP", "K_ALTER", "K_TYPE", "K_ADD", "K_RENAME", "K_TO", "K_TRUNCATE", "K_GRANT", "K_REVOKE", "K_LIST", "K_OF", "K_NORECURSIVE", "K_MODIFY", "K_AUTHORIZE", "K_ALL", "K_PERMISSIONS", "K_PERMISSION", "K_KEYSPACES", "K_USER", "K_SUPERUSER", "K_NOSUPERUSER", "K_USERS", "K_PASSWORD", "QUOTED_NAME", "FLOAT", "BOOLEAN", "UUID", "HEXNUMBER", "K_NULL", "QMARK", "K_TOKEN", "K_IN", "K_ASCII", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_DECIMAL", "K_DOUBLE", "K_FLOAT", "K_INET", "K_INT", "K_TEXT", "K_UUID", "K_VARCHAR", "K_VARINT", "K_TIMEUUID", "K_MAP", "S", "E", "L", "C", "T", "F", "R", "O", "M", "A", "W", "H", "N", "D", "K", "Y", "I", "U", "P", "G", "B", "X", "V", "Z", "J", "Q", "DIGIT", "LETTER", "HEX", "EXPONENT", "WS", "COMMENT", "MULTILINE_COMMENT", "';'", "'('", "')'", "','", "'\\*'", "'['", "']'", "'.'", "'}'", "':'", "'{'", "'='", "'+'", "'-'", "'<'", "'<='", "'>'", "'>='"
    };
    public static final int EXPONENT=128;
    public static final int K_PERMISSIONS=67;
    public static final int LETTER=126;
    public static final int K_INT=92;
    public static final int K_PERMISSION=68;
    public static final int K_CREATE=37;
    public static final int K_CLUSTERING=45;
    public static final int K_WRITETIME=15;
    public static final int K_EXISTS=26;
    public static final int EOF=-1;
    public static final int K_PRIMARY=41;
    public static final int K_AUTHORIZE=65;
    public static final int K_VALUES=23;
    public static final int K_USE=4;
    public static final int T__148=148;
    public static final int STRING_LITERAL=50;
    public static final int T__147=147;
    public static final int K_GRANT=59;
    public static final int T__149=149;
    public static final int K_ON=49;
    public static final int K_USING=27;
    public static final int K_ADD=55;
    public static final int K_ASC=19;
    public static final int K_CUSTOM=46;
    public static final int K_KEY=42;
    public static final int COMMENT=130;
    public static final int K_TRUNCATE=58;
    public static final int K_ORDER=10;
    public static final int HEXNUMBER=79;
    public static final int K_OF=62;
    public static final int K_ALL=66;
    public static final int D=112;
    public static final int T__139=139;
    public static final int E=100;
    public static final int T__138=138;
    public static final int F=104;
    public static final int T__137=137;
    public static final int G=118;
    public static final int T__136=136;
    public static final int K_COUNT=6;
    public static final int K_KEYSPACE=38;
    public static final int K_TYPE=54;
    public static final int A=108;
    public static final int B=119;
    public static final int C=102;
    public static final int L=101;
    public static final int M=107;
    public static final int N=111;
    public static final int O=106;
    public static final int H=110;
    public static final int I=115;
    public static final int J=123;
    public static final int K_UPDATE=29;
    public static final int K=113;
    public static final int K_FILTERING=14;
    public static final int U=116;
    public static final int T=103;
    public static final int W=109;
    public static final int K_TEXT=93;
    public static final int V=121;
    public static final int Q=124;
    public static final int P=117;
    public static final int K_COMPACT=43;
    public static final int S=99;
    public static final int R=105;
    public static final int T__141=141;
    public static final int T__142=142;
    public static final int K_TTL=16;
    public static final int T__140=140;
    public static final int Y=114;
    public static final int T__145=145;
    public static final int X=120;
    public static final int T__146=146;
    public static final int T__143=143;
    public static final int Z=122;
    public static final int T__144=144;
    public static final int K_INDEX=47;
    public static final int K_INSERT=21;
    public static final int WS=129;
    public static final int K_NOT=25;
    public static final int K_RENAME=56;
    public static final int K_APPLY=36;
    public static final int K_INET=91;
    public static final int K_STORAGE=44;
    public static final int K_TIMESTAMP=28;
    public static final int K_NULL=80;
    public static final int K_AND=18;
    public static final int K_DESC=20;
    public static final int K_TOKEN=82;
    public static final int QMARK=81;
    public static final int T__132=132;
    public static final int T__133=133;
    public static final int T__134=134;
    public static final int K_UUID=94;
    public static final int T__135=135;
    public static final int K_BATCH=35;
    public static final int K_ASCII=84;
    public static final int UUID=78;
    public static final int K_LIST=61;
    public static final int K_DELETE=31;
    public static final int K_TO=57;
    public static final int K_BY=11;
    public static final int FLOAT=76;
    public static final int K_VARINT=96;
    public static final int K_FLOAT=90;
    public static final int K_SUPERUSER=71;
    public static final int K_DOUBLE=89;
    public static final int K_SELECT=5;
    public static final int K_LIMIT=12;
    public static final int K_BOOLEAN=87;
    public static final int K_ALTER=53;
    public static final int K_SET=30;
    public static final int K_TRIGGER=51;
    public static final int K_WHERE=9;
    public static final int QUOTED_NAME=75;
    public static final int MULTILINE_COMMENT=131;
    public static final int K_BLOB=86;
    public static final int BOOLEAN=77;
    public static final int K_UNLOGGED=33;
    public static final int HEX=127;
    public static final int K_INTO=22;
    public static final int K_PASSWORD=74;
    public static final int K_REVOKE=60;
    public static final int K_ALLOW=13;
    public static final int K_VARCHAR=95;
    public static final int IDENT=48;
    public static final int DIGIT=125;
    public static final int K_USERS=73;
    public static final int K_BEGIN=32;
    public static final int INTEGER=17;
    public static final int K_KEYSPACES=69;
    public static final int K_COUNTER=34;
    public static final int K_DECIMAL=88;
    public static final int K_WITH=39;
    public static final int K_IN=83;
    public static final int K_NORECURSIVE=63;
    public static final int K_MAP=98;
    public static final int K_IF=24;
    public static final int K_FROM=8;
    public static final int K_COLUMNFAMILY=40;
    public static final int K_MODIFY=64;
    public static final int K_DROP=52;
    public static final int K_NOSUPERUSER=72;
    public static final int K_AS=7;
    public static final int K_BIGINT=85;
    public static final int K_TIMEUUID=97;
    public static final int K_USER=70;

    // delegates
    // delegators


        public CqlParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public CqlParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CqlParser.tokenNames; }
    public String getGrammarFileName() { return "/tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


        private List<String> recognitionErrors = new ArrayList<String>();
        private int currentBindMarkerIdx = -1;

        public void displayRecognitionError(String[] tokenNames, RecognitionException e)
        {
            String hdr = getErrorHeader(e);
            String msg = getErrorMessage(e, tokenNames);
            recognitionErrors.add(hdr + " " + msg);
        }

        public void addRecognitionError(String msg)
        {
            recognitionErrors.add(msg);
        }

        public List<String> getRecognitionErrors()
        {
            return recognitionErrors;
        }

        public void throwLastRecognitionError() throws SyntaxException
        {
            if (recognitionErrors.size() > 0)
                throw new SyntaxException(recognitionErrors.get((recognitionErrors.size()-1)));
        }

        public Map<String, String> convertPropertyMap(Maps.Literal map)
        {
            if (map == null || map.entries == null || map.entries.isEmpty())
                return Collections.<String, String>emptyMap();

            Map<String, String> res = new HashMap<String, String>(map.entries.size());

            for (Pair<Term.Raw, Term.Raw> entry : map.entries)
            {
                // Because the parser tries to be smart and recover on error (to
                // allow displaying more than one error I suppose), we have null
                // entries in there. Just skip those, a proper error will be thrown in the end.
                if (entry.left == null || entry.right == null)
                    break;

                if (!(entry.left instanceof Constants.Literal))
                {
                    addRecognitionError("Invalid property name: " + entry.left);
                    break;
                }
                if (!(entry.right instanceof Constants.Literal))
                {
                    addRecognitionError("Invalid property value: " + entry.right);
                    break;
                }

                res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
            }

            return res;
        }

        public void addRawUpdate(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, ColumnIdentifier key, Operation.RawUpdate update)
        {
            for (Pair<ColumnIdentifier, Operation.RawUpdate> p : operations)
            {
                if (p.left.equals(key) && !p.right.isCompatibleWith(update))
                    addRecognitionError("Multiple incompatible setting of column " + key);
            }
            operations.add(Pair.create(key, update));
        }



    // $ANTLR start "query"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:166:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
    public final ParsedStatement query() throws RecognitionException {
        ParsedStatement stmnt = null;

        ParsedStatement st = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:5: (st= cqlStatement ( ';' )* EOF )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:7: st= cqlStatement ( ';' )* EOF
            {
            pushFollow(FOLLOW_cqlStatement_in_query72);
            st=cqlStatement();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:23: ( ';' )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==132) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:169:24: ';'
            	    {
            	    match(input,132,FOLLOW_132_in_query75); 

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            match(input,EOF,FOLLOW_EOF_in_query79); 
             stmnt = st; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmnt;
    }
    // $ANTLR end "query"


    // $ANTLR start "cqlStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:172:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createTableStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropTableStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement | st23= createTriggerStatement | st24= dropTriggerStatement );
    public final ParsedStatement cqlStatement() throws RecognitionException {
        ParsedStatement stmt = null;

        SelectStatement.RawStatement st1 = null;

        UpdateStatement.ParsedInsert st2 = null;

        UpdateStatement.ParsedUpdate st3 = null;

        BatchStatement.Parsed st4 = null;

        DeleteStatement.Parsed st5 = null;

        UseStatement st6 = null;

        TruncateStatement st7 = null;

        CreateKeyspaceStatement st8 = null;

        CreateTableStatement.RawStatement st9 = null;

        CreateIndexStatement st10 = null;

        DropKeyspaceStatement st11 = null;

        DropTableStatement st12 = null;

        DropIndexStatement st13 = null;

        AlterTableStatement st14 = null;

        AlterKeyspaceStatement st15 = null;

        GrantStatement st16 = null;

        RevokeStatement st17 = null;

        ListPermissionsStatement st18 = null;

        CreateUserStatement st19 = null;

        AlterUserStatement st20 = null;

        DropUserStatement st21 = null;

        ListUsersStatement st22 = null;

        CreateTriggerStatement st23 = null;

        DropTriggerStatement st24 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:174:5: (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createTableStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropTableStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement | st23= createTriggerStatement | st24= dropTriggerStatement )
            int alt2=24;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:174:7: st1= selectStatement
                    {
                    pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
                    st1=selectStatement();

                    state._fsp--;

                     stmt = st1; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:175:7: st2= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_cqlStatement138);
                    st2=insertStatement();

                    state._fsp--;

                     stmt = st2; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:176:7: st3= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_cqlStatement163);
                    st3=updateStatement();

                    state._fsp--;

                     stmt = st3; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:177:7: st4= batchStatement
                    {
                    pushFollow(FOLLOW_batchStatement_in_cqlStatement188);
                    st4=batchStatement();

                    state._fsp--;

                     stmt = st4; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:178:7: st5= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_cqlStatement214);
                    st5=deleteStatement();

                    state._fsp--;

                     stmt = st5; 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:179:7: st6= useStatement
                    {
                    pushFollow(FOLLOW_useStatement_in_cqlStatement239);
                    st6=useStatement();

                    state._fsp--;

                     stmt = st6; 

                    }
                    break;
                case 7 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:180:7: st7= truncateStatement
                    {
                    pushFollow(FOLLOW_truncateStatement_in_cqlStatement267);
                    st7=truncateStatement();

                    state._fsp--;

                     stmt = st7; 

                    }
                    break;
                case 8 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:181:7: st8= createKeyspaceStatement
                    {
                    pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement290);
                    st8=createKeyspaceStatement();

                    state._fsp--;

                     stmt = st8; 

                    }
                    break;
                case 9 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:182:7: st9= createTableStatement
                    {
                    pushFollow(FOLLOW_createTableStatement_in_cqlStatement307);
                    st9=createTableStatement();

                    state._fsp--;

                     stmt = st9; 

                    }
                    break;
                case 10 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:183:7: st10= createIndexStatement
                    {
                    pushFollow(FOLLOW_createIndexStatement_in_cqlStatement326);
                    st10=createIndexStatement();

                    state._fsp--;

                     stmt = st10; 

                    }
                    break;
                case 11 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:184:7: st11= dropKeyspaceStatement
                    {
                    pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement345);
                    st11=dropKeyspaceStatement();

                    state._fsp--;

                     stmt = st11; 

                    }
                    break;
                case 12 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:185:7: st12= dropTableStatement
                    {
                    pushFollow(FOLLOW_dropTableStatement_in_cqlStatement363);
                    st12=dropTableStatement();

                    state._fsp--;

                     stmt = st12; 

                    }
                    break;
                case 13 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:186:7: st13= dropIndexStatement
                    {
                    pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement384);
                    st13=dropIndexStatement();

                    state._fsp--;

                     stmt = st13; 

                    }
                    break;
                case 14 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:187:7: st14= alterTableStatement
                    {
                    pushFollow(FOLLOW_alterTableStatement_in_cqlStatement405);
                    st14=alterTableStatement();

                    state._fsp--;

                     stmt = st14; 

                    }
                    break;
                case 15 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:188:7: st15= alterKeyspaceStatement
                    {
                    pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement425);
                    st15=alterKeyspaceStatement();

                    state._fsp--;

                     stmt = st15; 

                    }
                    break;
                case 16 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:189:7: st16= grantStatement
                    {
                    pushFollow(FOLLOW_grantStatement_in_cqlStatement442);
                    st16=grantStatement();

                    state._fsp--;

                     stmt = st16; 

                    }
                    break;
                case 17 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:190:7: st17= revokeStatement
                    {
                    pushFollow(FOLLOW_revokeStatement_in_cqlStatement467);
                    st17=revokeStatement();

                    state._fsp--;

                     stmt = st17; 

                    }
                    break;
                case 18 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:191:7: st18= listPermissionsStatement
                    {
                    pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement491);
                    st18=listPermissionsStatement();

                    state._fsp--;

                     stmt = st18; 

                    }
                    break;
                case 19 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:192:7: st19= createUserStatement
                    {
                    pushFollow(FOLLOW_createUserStatement_in_cqlStatement506);
                    st19=createUserStatement();

                    state._fsp--;

                     stmt = st19; 

                    }
                    break;
                case 20 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:193:7: st20= alterUserStatement
                    {
                    pushFollow(FOLLOW_alterUserStatement_in_cqlStatement526);
                    st20=alterUserStatement();

                    state._fsp--;

                     stmt = st20; 

                    }
                    break;
                case 21 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:194:7: st21= dropUserStatement
                    {
                    pushFollow(FOLLOW_dropUserStatement_in_cqlStatement547);
                    st21=dropUserStatement();

                    state._fsp--;

                     stmt = st21; 

                    }
                    break;
                case 22 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:195:7: st22= listUsersStatement
                    {
                    pushFollow(FOLLOW_listUsersStatement_in_cqlStatement569);
                    st22=listUsersStatement();

                    state._fsp--;

                     stmt = st22; 

                    }
                    break;
                case 23 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:196:7: st23= createTriggerStatement
                    {
                    pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement590);
                    st23=createTriggerStatement();

                    state._fsp--;

                     stmt = st23; 

                    }
                    break;
                case 24 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:197:7: st24= dropTriggerStatement
                    {
                    pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement607);
                    st24=dropTriggerStatement();

                    state._fsp--;

                     stmt = st24; 

                    }
                    break;

            }
             if (stmt != null) stmt.setBoundTerms(currentBindMarkerIdx + 1); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "cqlStatement"


    // $ANTLR start "useStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:203:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
    public final UseStatement useStatement() throws RecognitionException {
        UseStatement stmt = null;

        String ks = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:204:5: ( K_USE ks= keyspaceName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:204:7: K_USE ks= keyspaceName
            {
            match(input,K_USE,FOLLOW_K_USE_in_useStatement639); 
            pushFollow(FOLLOW_keyspaceName_in_useStatement643);
            ks=keyspaceName();

            state._fsp--;

             stmt = new UseStatement(ks); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "useStatement"


    // $ANTLR start "selectStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:207:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
    public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
        SelectStatement.RawStatement expr = null;

        List<RawSelector> sclause = null;

        ColumnIdentifier c = null;

        CFName cf = null;

        List<Relation> wclause = null;

        Term.Raw rows = null;



                boolean isCount = false;
                ColumnIdentifier countAlias = null;
                Term.Raw limit = null;
                Map<ColumnIdentifier, Boolean> orderings = new LinkedHashMap<ColumnIdentifier, Boolean>();
                boolean allowFiltering = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:5: ( K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:7: K_SELECT (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
            {
            match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement677); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:16: (sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? ) )
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==K_AS||(LA4_0>=K_FILTERING && LA4_0<=K_TTL)||LA4_0==K_VALUES||LA4_0==K_EXISTS||LA4_0==K_TIMESTAMP||LA4_0==K_COUNTER||(LA4_0>=K_KEY && LA4_0<=K_CUSTOM)||LA4_0==IDENT||LA4_0==K_TRIGGER||LA4_0==K_TYPE||LA4_0==K_LIST||(LA4_0>=K_ALL && LA4_0<=QUOTED_NAME)||LA4_0==K_TOKEN||(LA4_0>=K_ASCII && LA4_0<=K_MAP)||LA4_0==136) ) {
                alt4=1;
            }
            else if ( (LA4_0==K_COUNT) ) {
                int LA4_2 = input.LA(2);

                if ( (LA4_2==133) ) {
                    alt4=2;
                }
                else if ( ((LA4_2>=K_AS && LA4_2<=K_FROM)||LA4_2==135) ) {
                    alt4=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }
            switch (alt4) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:18: sclause= selectClause
                    {
                    pushFollow(FOLLOW_selectClause_in_selectStatement683);
                    sclause=selectClause();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? )
                    {
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )? )
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:19: K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= cident )?
                    {
                    match(input,K_COUNT,FOLLOW_K_COUNT_in_selectStatement703); 
                    match(input,133,FOLLOW_133_in_selectStatement705); 
                    pushFollow(FOLLOW_selectCountClause_in_selectStatement709);
                    sclause=selectCountClause();

                    state._fsp--;

                    match(input,134,FOLLOW_134_in_selectStatement711); 
                     isCount = true; 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:81: ( K_AS c= cident )?
                    int alt3=2;
                    int LA3_0 = input.LA(1);

                    if ( (LA3_0==K_AS) ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:82: K_AS c= cident
                            {
                            match(input,K_AS,FOLLOW_K_AS_in_selectStatement716); 
                            pushFollow(FOLLOW_cident_in_selectStatement720);
                            c=cident();

                            state._fsp--;

                             countAlias = c; 

                            }
                            break;

                    }


                    }


                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement735); 
            pushFollow(FOLLOW_columnFamilyName_in_selectStatement739);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:224:7: ( K_WHERE wclause= whereClause )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==K_WHERE) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:224:9: K_WHERE wclause= whereClause
                    {
                    match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement749); 
                    pushFollow(FOLLOW_whereClause_in_selectStatement753);
                    wclause=whereClause();

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==K_ORDER) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
                    {
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement766); 
                    match(input,K_BY,FOLLOW_K_BY_in_selectStatement768); 
                    pushFollow(FOLLOW_orderByClause_in_selectStatement770);
                    orderByClause(orderings);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:47: ( ',' orderByClause[orderings] )*
                    loop6:
                    do {
                        int alt6=2;
                        int LA6_0 = input.LA(1);

                        if ( (LA6_0==135) ) {
                            alt6=1;
                        }


                        switch (alt6) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:49: ',' orderByClause[orderings]
                    	    {
                    	    match(input,135,FOLLOW_135_in_selectStatement775); 
                    	    pushFollow(FOLLOW_orderByClause_in_selectStatement777);
                    	    orderByClause(orderings);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop6;
                        }
                    } while (true);


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:226:7: ( K_LIMIT rows= intValue )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==K_LIMIT) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:226:9: K_LIMIT rows= intValue
                    {
                    match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement794); 
                    pushFollow(FOLLOW_intValue_in_selectStatement798);
                    rows=intValue();

                    state._fsp--;

                     limit = rows; 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:227:7: ( K_ALLOW K_FILTERING )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==K_ALLOW) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:227:9: K_ALLOW K_FILTERING
                    {
                    match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement813); 
                    match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement815); 
                     allowFiltering = true; 

                    }
                    break;

            }


                      SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
                                                                                         isCount,
                                                                                         countAlias,
                                                                                         allowFiltering);
                      expr = new SelectStatement.RawStatement(cf, params, sclause, wclause, limit);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectStatement"


    // $ANTLR start "selectClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:237:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
    public final List<RawSelector> selectClause() throws RecognitionException {
        List<RawSelector> expr = null;

        RawSelector t1 = null;

        RawSelector tN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:5: (t1= selector ( ',' tN= selector )* | '\\*' )
            int alt11=2;
            int LA11_0 = input.LA(1);

            if ( ((LA11_0>=K_COUNT && LA11_0<=K_AS)||(LA11_0>=K_FILTERING && LA11_0<=K_TTL)||LA11_0==K_VALUES||LA11_0==K_EXISTS||LA11_0==K_TIMESTAMP||LA11_0==K_COUNTER||(LA11_0>=K_KEY && LA11_0<=K_CUSTOM)||LA11_0==IDENT||LA11_0==K_TRIGGER||LA11_0==K_TYPE||LA11_0==K_LIST||(LA11_0>=K_ALL && LA11_0<=QUOTED_NAME)||LA11_0==K_TOKEN||(LA11_0>=K_ASCII && LA11_0<=K_MAP)) ) {
                alt11=1;
            }
            else if ( (LA11_0==136) ) {
                alt11=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;
            }
            switch (alt11) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: t1= selector ( ',' tN= selector )*
                    {
                    pushFollow(FOLLOW_selector_in_selectClause852);
                    t1=selector();

                    state._fsp--;

                     expr = new ArrayList<RawSelector>(); expr.add(t1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:76: ( ',' tN= selector )*
                    loop10:
                    do {
                        int alt10=2;
                        int LA10_0 = input.LA(1);

                        if ( (LA10_0==135) ) {
                            alt10=1;
                        }


                        switch (alt10) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:77: ',' tN= selector
                    	    {
                    	    match(input,135,FOLLOW_135_in_selectClause857); 
                    	    pushFollow(FOLLOW_selector_in_selectClause861);
                    	    tN=selector();

                    	    state._fsp--;

                    	     expr.add(tN); 

                    	    }
                    	    break;

                    	default :
                    	    break loop10;
                        }
                    } while (true);


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: '\\*'
                    {
                    match(input,136,FOLLOW_136_in_selectClause873); 
                     expr = Collections.<RawSelector>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectClause"


    // $ANTLR start "selector"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:242:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= cident )? ;
    public final RawSelector selector() throws RecognitionException {
        RawSelector s = null;

        Selectable us = null;

        ColumnIdentifier c = null;


         ColumnIdentifier alias = null; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:5: (us= unaliasedSelector ( K_AS c= cident )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:7: us= unaliasedSelector ( K_AS c= cident )?
            {
            pushFollow(FOLLOW_unaliasedSelector_in_selector906);
            us=unaliasedSelector();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:28: ( K_AS c= cident )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==K_AS) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:29: K_AS c= cident
                    {
                    match(input,K_AS,FOLLOW_K_AS_in_selector909); 
                    pushFollow(FOLLOW_cident_in_selector913);
                    c=cident();

                    state._fsp--;

                     alias = c; 

                    }
                    break;

            }

             s = new RawSelector(us, alias); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "selector"


    // $ANTLR start "unaliasedSelector"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:247:1: unaliasedSelector returns [Selectable s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs );
    public final Selectable unaliasedSelector() throws RecognitionException {
        Selectable s = null;

        ColumnIdentifier c = null;

        String f = null;

        List<Selectable> args = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:248:5: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs )
            int alt13=4;
            alt13 = dfa13.predict(input);
            switch (alt13) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:248:7: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_unaliasedSelector942);
                    c=cident();

                    state._fsp--;

                     s = c; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:249:7: K_WRITETIME '(' c= cident ')'
                    {
                    match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_unaliasedSelector985); 
                    match(input,133,FOLLOW_133_in_unaliasedSelector987); 
                    pushFollow(FOLLOW_cident_in_unaliasedSelector991);
                    c=cident();

                    state._fsp--;

                    match(input,134,FOLLOW_134_in_unaliasedSelector993); 
                     s = new Selectable.WritetimeOrTTL(c, true); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:250:7: K_TTL '(' c= cident ')'
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_unaliasedSelector1016); 
                    match(input,133,FOLLOW_133_in_unaliasedSelector1024); 
                    pushFollow(FOLLOW_cident_in_unaliasedSelector1028);
                    c=cident();

                    state._fsp--;

                    match(input,134,FOLLOW_134_in_unaliasedSelector1030); 
                     s = new Selectable.WritetimeOrTTL(c, false); 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:7: f= functionName args= selectionFunctionArgs
                    {
                    pushFollow(FOLLOW_functionName_in_unaliasedSelector1055);
                    f=functionName();

                    state._fsp--;

                    pushFollow(FOLLOW_selectionFunctionArgs_in_unaliasedSelector1059);
                    args=selectionFunctionArgs();

                    state._fsp--;

                     s = new Selectable.WithFunction(f, args); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "unaliasedSelector"


    // $ANTLR start "selectionFunctionArgs"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:254:1: selectionFunctionArgs returns [List<Selectable> a] : ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' );
    public final List<Selectable> selectionFunctionArgs() throws RecognitionException {
        List<Selectable> a = null;

        Selectable s1 = null;

        Selectable sn = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:255:5: ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' )
            int alt15=2;
            int LA15_0 = input.LA(1);

            if ( (LA15_0==133) ) {
                int LA15_1 = input.LA(2);

                if ( (LA15_1==134) ) {
                    alt15=1;
                }
                else if ( ((LA15_1>=K_COUNT && LA15_1<=K_AS)||(LA15_1>=K_FILTERING && LA15_1<=K_TTL)||LA15_1==K_VALUES||LA15_1==K_EXISTS||LA15_1==K_TIMESTAMP||LA15_1==K_COUNTER||(LA15_1>=K_KEY && LA15_1<=K_CUSTOM)||LA15_1==IDENT||LA15_1==K_TRIGGER||LA15_1==K_TYPE||LA15_1==K_LIST||(LA15_1>=K_ALL && LA15_1<=QUOTED_NAME)||LA15_1==K_TOKEN||(LA15_1>=K_ASCII && LA15_1<=K_MAP)) ) {
                    alt15=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 15, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 15, 0, input);

                throw nvae;
            }
            switch (alt15) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:255:7: '(' ')'
                    {
                    match(input,133,FOLLOW_133_in_selectionFunctionArgs1082); 
                    match(input,134,FOLLOW_134_in_selectionFunctionArgs1084); 
                     a = Collections.emptyList(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:256:7: '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')'
                    {
                    match(input,133,FOLLOW_133_in_selectionFunctionArgs1094); 
                    pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1098);
                    s1=unaliasedSelector();

                    state._fsp--;

                     List<Selectable> args = new ArrayList<Selectable>(); args.add(s1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:257:11: ( ',' sn= unaliasedSelector )*
                    loop14:
                    do {
                        int alt14=2;
                        int LA14_0 = input.LA(1);

                        if ( (LA14_0==135) ) {
                            alt14=1;
                        }


                        switch (alt14) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:257:13: ',' sn= unaliasedSelector
                    	    {
                    	    match(input,135,FOLLOW_135_in_selectionFunctionArgs1114); 
                    	    pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1118);
                    	    sn=unaliasedSelector();

                    	    state._fsp--;

                    	     args.add(sn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop14;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_selectionFunctionArgs1132); 
                     a = args; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return a;
    }
    // $ANTLR end "selectionFunctionArgs"


    // $ANTLR start "selectCountClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:261:1: selectCountClause returns [List<RawSelector> expr] : ( '\\*' | i= INTEGER );
    public final List<RawSelector> selectCountClause() throws RecognitionException {
        List<RawSelector> expr = null;

        Token i=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:262:5: ( '\\*' | i= INTEGER )
            int alt16=2;
            int LA16_0 = input.LA(1);

            if ( (LA16_0==136) ) {
                alt16=1;
            }
            else if ( (LA16_0==INTEGER) ) {
                alt16=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;
            }
            switch (alt16) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:262:7: '\\*'
                    {
                    match(input,136,FOLLOW_136_in_selectCountClause1155); 
                     expr = Collections.<RawSelector>emptyList();

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:263:7: i= INTEGER
                    {
                    i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectCountClause1177); 
                     if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")"); expr = Collections.<RawSelector>emptyList();

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "selectCountClause"


    // $ANTLR start "whereClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:266:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
    public final List<Relation> whereClause() throws RecognitionException {
        List<Relation> clause = null;

         clause = new ArrayList<Relation>(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:5: ( relation[$clause] ( K_AND relation[$clause] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:7: relation[$clause] ( K_AND relation[$clause] )*
            {
            pushFollow(FOLLOW_relation_in_whereClause1213);
            relation(clause);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:25: ( K_AND relation[$clause] )*
            loop17:
            do {
                int alt17=2;
                int LA17_0 = input.LA(1);

                if ( (LA17_0==K_AND) ) {
                    alt17=1;
                }


                switch (alt17) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:268:26: K_AND relation[$clause]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_whereClause1217); 
            	    pushFollow(FOLLOW_relation_in_whereClause1219);
            	    relation(clause);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop17;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return clause;
    }
    // $ANTLR end "whereClause"


    // $ANTLR start "orderByClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:271:1: orderByClause[Map<ColumnIdentifier, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
    public final void orderByClause(Map<ColumnIdentifier, Boolean> orderings) throws RecognitionException {
        ColumnIdentifier c = null;



                ColumnIdentifier orderBy = null;
                boolean reversed = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:5: (c= cident ( K_ASC | K_DESC )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:7: c= cident ( K_ASC | K_DESC )?
            {
            pushFollow(FOLLOW_cident_in_orderByClause1250);
            c=cident();

            state._fsp--;

             orderBy = c; 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:33: ( K_ASC | K_DESC )?
            int alt18=3;
            int LA18_0 = input.LA(1);

            if ( (LA18_0==K_ASC) ) {
                alt18=1;
            }
            else if ( (LA18_0==K_DESC) ) {
                alt18=2;
            }
            switch (alt18) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:34: K_ASC
                    {
                    match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1255); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:276:42: K_DESC
                    {
                    match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1259); 
                     reversed = true; 

                    }
                    break;

            }

             orderings.put(c, reversed); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "orderByClause"


    // $ANTLR start "insertStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:279:1: insertStatement returns [UpdateStatement.ParsedInsert expr] : K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
    public final UpdateStatement.ParsedInsert insertStatement() throws RecognitionException {
        UpdateStatement.ParsedInsert expr = null;

        CFName cf = null;

        ColumnIdentifier c1 = null;

        ColumnIdentifier cn = null;

        Term.Raw v1 = null;

        Term.Raw vn = null;



                Attributes.Raw attrs = new Attributes.Raw();
                List<ColumnIdentifier> columnNames  = new ArrayList<ColumnIdentifier>();
                List<Term.Raw> values = new ArrayList<Term.Raw>();
                boolean ifNotExists = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:292:5: ( K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:292:7: K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
            {
            match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1297); 
            match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1299); 
            pushFollow(FOLLOW_columnFamilyName_in_insertStatement1303);
            cf=columnFamilyName();

            state._fsp--;

            match(input,133,FOLLOW_133_in_insertStatement1315); 
            pushFollow(FOLLOW_cident_in_insertStatement1319);
            c1=cident();

            state._fsp--;

             columnNames.add(c1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:51: ( ',' cn= cident )*
            loop19:
            do {
                int alt19=2;
                int LA19_0 = input.LA(1);

                if ( (LA19_0==135) ) {
                    alt19=1;
                }


                switch (alt19) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:53: ',' cn= cident
            	    {
            	    match(input,135,FOLLOW_135_in_insertStatement1326); 
            	    pushFollow(FOLLOW_cident_in_insertStatement1330);
            	    cn=cident();

            	    state._fsp--;

            	     columnNames.add(cn); 

            	    }
            	    break;

            	default :
            	    break loop19;
                }
            } while (true);

            match(input,134,FOLLOW_134_in_insertStatement1337); 
            match(input,K_VALUES,FOLLOW_K_VALUES_in_insertStatement1347); 
            match(input,133,FOLLOW_133_in_insertStatement1359); 
            pushFollow(FOLLOW_term_in_insertStatement1363);
            v1=term();

            state._fsp--;

             values.add(v1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:295:43: ( ',' vn= term )*
            loop20:
            do {
                int alt20=2;
                int LA20_0 = input.LA(1);

                if ( (LA20_0==135) ) {
                    alt20=1;
                }


                switch (alt20) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:295:45: ',' vn= term
            	    {
            	    match(input,135,FOLLOW_135_in_insertStatement1369); 
            	    pushFollow(FOLLOW_term_in_insertStatement1373);
            	    vn=term();

            	    state._fsp--;

            	     values.add(vn); 

            	    }
            	    break;

            	default :
            	    break loop20;
                }
            } while (true);

            match(input,134,FOLLOW_134_in_insertStatement1380); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:9: ( K_IF K_NOT K_EXISTS )?
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==K_IF) ) {
                alt21=1;
            }
            switch (alt21) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:297:11: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_insertStatement1393); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_insertStatement1395); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_insertStatement1397); 
                     ifNotExists = true; 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:9: ( usingClause[attrs] )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==K_USING) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:11: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_insertStatement1414);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }


                      expr = new UpdateStatement.ParsedInsert(cf,
                                                               attrs,
                                                               columnNames,
                                                               values,
                                                               ifNotExists);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "insertStatement"


    // $ANTLR start "usingClause"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )* ;
    public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:5: ( K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:7: K_USING usingClauseObjective[attrs] ( ( K_AND )? usingClauseObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClause1444); 
            pushFollow(FOLLOW_usingClauseObjective_in_usingClause1446);
            usingClauseObjective(attrs);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:43: ( ( K_AND )? usingClauseObjective[attrs] )*
            loop24:
            do {
                int alt24=2;
                int LA24_0 = input.LA(1);

                if ( (LA24_0==K_TTL||LA24_0==K_AND||LA24_0==K_TIMESTAMP) ) {
                    alt24=1;
                }


                switch (alt24) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:45: ( K_AND )? usingClauseObjective[attrs]
            	    {
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:45: ( K_AND )?
            	    int alt23=2;
            	    int LA23_0 = input.LA(1);

            	    if ( (LA23_0==K_AND) ) {
            	        alt23=1;
            	    }
            	    switch (alt23) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:309:45: K_AND
            	            {
            	            match(input,K_AND,FOLLOW_K_AND_in_usingClause1451); 

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_usingClauseObjective_in_usingClause1454);
            	    usingClauseObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop24;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClause"


    // $ANTLR start "usingClauseDelete"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:312:1: usingClauseDelete[Attributes.Raw attrs] : K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )* ;
    public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:5: ( K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:7: K_USING usingClauseDeleteObjective[attrs] ( ( K_AND )? usingClauseDeleteObjective[attrs] )*
            {
            match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete1476); 
            pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1478);
            usingClauseDeleteObjective(attrs);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:49: ( ( K_AND )? usingClauseDeleteObjective[attrs] )*
            loop26:
            do {
                int alt26=2;
                int LA26_0 = input.LA(1);

                if ( (LA26_0==K_AND||LA26_0==K_TIMESTAMP) ) {
                    alt26=1;
                }


                switch (alt26) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:51: ( K_AND )? usingClauseDeleteObjective[attrs]
            	    {
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:51: ( K_AND )?
            	    int alt25=2;
            	    int LA25_0 = input.LA(1);

            	    if ( (LA25_0==K_AND) ) {
            	        alt25=1;
            	    }
            	    switch (alt25) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:51: K_AND
            	            {
            	            match(input,K_AND,FOLLOW_K_AND_in_usingClauseDelete1483); 

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1486);
            	    usingClauseDeleteObjective(attrs);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop26;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDelete"


    // $ANTLR start "usingClauseDeleteObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:316:1: usingClauseDeleteObjective[Attributes.Raw attrs] : K_TIMESTAMP ts= intValue ;
    public final void usingClauseDeleteObjective(Attributes.Raw attrs) throws RecognitionException {
        Term.Raw ts = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:5: ( K_TIMESTAMP ts= intValue )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:7: K_TIMESTAMP ts= intValue
            {
            match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDeleteObjective1508); 
            pushFollow(FOLLOW_intValue_in_usingClauseDeleteObjective1512);
            ts=intValue();

            state._fsp--;

             attrs.timestamp = ts; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseDeleteObjective"


    // $ANTLR start "usingClauseObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:320:1: usingClauseObjective[Attributes.Raw attrs] : ( usingClauseDeleteObjective[attrs] | K_TTL t= intValue );
    public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:321:5: ( usingClauseDeleteObjective[attrs] | K_TTL t= intValue )
            int alt27=2;
            int LA27_0 = input.LA(1);

            if ( (LA27_0==K_TIMESTAMP) ) {
                alt27=1;
            }
            else if ( (LA27_0==K_TTL) ) {
                alt27=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;
            }
            switch (alt27) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:321:7: usingClauseDeleteObjective[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDeleteObjective_in_usingClauseObjective1532);
                    usingClauseDeleteObjective(attrs);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:7: K_TTL t= intValue
                    {
                    match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective1541); 
                    pushFollow(FOLLOW_intValue_in_usingClauseObjective1545);
                    t=intValue();

                    state._fsp--;

                     attrs.timeToLive = t; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "usingClauseObjective"


    // $ANTLR start "updateStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:325:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateCondition )? ;
    public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
        UpdateStatement.ParsedUpdate expr = null;

        CFName cf = null;

        List<Relation> wclause = null;

        List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions = null;



                Attributes.Raw attrs = new Attributes.Raw();
                List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier, Operation.RawUpdate>>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateCondition )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF conditions= updateCondition )?
            {
            match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement1579); 
            pushFollow(FOLLOW_columnFamilyName_in_updateStatement1583);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:7: ( usingClause[attrs] )?
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( (LA28_0==K_USING) ) {
                alt28=1;
            }
            switch (alt28) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:337:9: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_updateStatement1593);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_SET,FOLLOW_K_SET_in_updateStatement1605); 
            pushFollow(FOLLOW_columnOperation_in_updateStatement1607);
            columnOperation(operations);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:41: ( ',' columnOperation[operations] )*
            loop29:
            do {
                int alt29=2;
                int LA29_0 = input.LA(1);

                if ( (LA29_0==135) ) {
                    alt29=1;
                }


                switch (alt29) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:338:42: ',' columnOperation[operations]
            	    {
            	    match(input,135,FOLLOW_135_in_updateStatement1611); 
            	    pushFollow(FOLLOW_columnOperation_in_updateStatement1613);
            	    columnOperation(operations);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop29;
                }
            } while (true);

            match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement1624); 
            pushFollow(FOLLOW_whereClause_in_updateStatement1628);
            wclause=whereClause();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:340:7: ( K_IF conditions= updateCondition )?
            int alt30=2;
            int LA30_0 = input.LA(1);

            if ( (LA30_0==K_IF) ) {
                alt30=1;
            }
            switch (alt30) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:340:9: K_IF conditions= updateCondition
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_updateStatement1638); 
                    pushFollow(FOLLOW_updateCondition_in_updateStatement1642);
                    conditions=updateCondition();

                    state._fsp--;


                    }
                    break;

            }


                      return new UpdateStatement.ParsedUpdate(cf,
                                                              attrs,
                                                              operations,
                                                              wclause,
                                                              conditions == null ? Collections.<Pair<ColumnIdentifier, Operation.RawUpdate>>emptyList() : conditions);
                 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "updateStatement"


    // $ANTLR start "updateCondition"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:350:1: updateCondition returns [List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions] : columnOperation[conditions] ( K_AND columnOperation[conditions] )* ;
    public final List<Pair<ColumnIdentifier, Operation.RawUpdate>> updateCondition() throws RecognitionException {
        List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions = null;

         conditions = new ArrayList<Pair<ColumnIdentifier, Operation.RawUpdate>>(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:5: ( columnOperation[conditions] ( K_AND columnOperation[conditions] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:7: columnOperation[conditions] ( K_AND columnOperation[conditions] )*
            {
            pushFollow(FOLLOW_columnOperation_in_updateCondition1683);
            columnOperation(conditions);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:35: ( K_AND columnOperation[conditions] )*
            loop31:
            do {
                int alt31=2;
                int LA31_0 = input.LA(1);

                if ( (LA31_0==K_AND) ) {
                    alt31=1;
                }


                switch (alt31) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:352:37: K_AND columnOperation[conditions]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_updateCondition1688); 
            	    pushFollow(FOLLOW_columnOperation_in_updateCondition1690);
            	    columnOperation(conditions);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop31;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return conditions;
    }
    // $ANTLR end "updateCondition"


    // $ANTLR start "deleteStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:355:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF conditions= updateCondition )? ;
    public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
        DeleteStatement.Parsed expr = null;

        List<Operation.RawDeletion> dels = null;

        CFName cf = null;

        List<Relation> wclause = null;

        List<Pair<ColumnIdentifier, Operation.RawUpdate>> conditions = null;



                Attributes.Raw attrs = new Attributes.Raw();
                List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:366:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF conditions= updateCondition )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:366:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF conditions= updateCondition )?
            {
            match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement1726); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:366:16: (dels= deleteSelection )?
            int alt32=2;
            int LA32_0 = input.LA(1);

            if ( ((LA32_0>=K_COUNT && LA32_0<=K_AS)||(LA32_0>=K_FILTERING && LA32_0<=K_TTL)||LA32_0==K_VALUES||LA32_0==K_EXISTS||LA32_0==K_TIMESTAMP||LA32_0==K_COUNTER||(LA32_0>=K_KEY && LA32_0<=K_CUSTOM)||LA32_0==IDENT||LA32_0==K_TRIGGER||LA32_0==K_TYPE||LA32_0==K_LIST||(LA32_0>=K_ALL && LA32_0<=QUOTED_NAME)||(LA32_0>=K_ASCII && LA32_0<=K_MAP)) ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:366:18: dels= deleteSelection
                    {
                    pushFollow(FOLLOW_deleteSelection_in_deleteStatement1732);
                    dels=deleteSelection();

                    state._fsp--;

                     columnDeletions = dels; 

                    }
                    break;

            }

            match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement1745); 
            pushFollow(FOLLOW_columnFamilyName_in_deleteStatement1749);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:7: ( usingClauseDelete[attrs] )?
            int alt33=2;
            int LA33_0 = input.LA(1);

            if ( (LA33_0==K_USING) ) {
                alt33=1;
            }
            switch (alt33) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:368:9: usingClauseDelete[attrs]
                    {
                    pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement1759);
                    usingClauseDelete(attrs);

                    state._fsp--;


                    }
                    break;

            }

            match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement1771); 
            pushFollow(FOLLOW_whereClause_in_deleteStatement1775);
            wclause=whereClause();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:370:7: ( K_IF conditions= updateCondition )?
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==K_IF) ) {
                alt34=1;
            }
            switch (alt34) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:370:9: K_IF conditions= updateCondition
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_deleteStatement1785); 
                    pushFollow(FOLLOW_updateCondition_in_deleteStatement1789);
                    conditions=updateCondition();

                    state._fsp--;


                    }
                    break;

            }


                      return new DeleteStatement.Parsed(cf,
                                                        attrs,
                                                        columnDeletions,
                                                        wclause,
                                                        conditions == null ? Collections.<Pair<ColumnIdentifier, Operation.RawUpdate>>emptyList() : conditions);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "deleteStatement"


    // $ANTLR start "deleteSelection"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:380:1: deleteSelection returns [List<Operation.RawDeletion> operations] : t1= deleteOp ( ',' tN= deleteOp )* ;
    public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
        List<Operation.RawDeletion> operations = null;

        Operation.RawDeletion t1 = null;

        Operation.RawDeletion tN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:5: (t1= deleteOp ( ',' tN= deleteOp )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:7: t1= deleteOp ( ',' tN= deleteOp )*
            {
             operations = new ArrayList<Operation.RawDeletion>(); 
            pushFollow(FOLLOW_deleteOp_in_deleteSelection1835);
            t1=deleteOp();

            state._fsp--;

             operations.add(t1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:11: ( ',' tN= deleteOp )*
            loop35:
            do {
                int alt35=2;
                int LA35_0 = input.LA(1);

                if ( (LA35_0==135) ) {
                    alt35=1;
                }


                switch (alt35) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:12: ',' tN= deleteOp
            	    {
            	    match(input,135,FOLLOW_135_in_deleteSelection1850); 
            	    pushFollow(FOLLOW_deleteOp_in_deleteSelection1854);
            	    tN=deleteOp();

            	    state._fsp--;

            	     operations.add(tN); 

            	    }
            	    break;

            	default :
            	    break loop35;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return operations;
    }
    // $ANTLR end "deleteSelection"


    // $ANTLR start "deleteOp"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:386:1: deleteOp returns [Operation.RawDeletion op] : (c= cident | c= cident '[' t= term ']' );
    public final Operation.RawDeletion deleteOp() throws RecognitionException {
        Operation.RawDeletion op = null;

        ColumnIdentifier c = null;

        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:387:5: (c= cident | c= cident '[' t= term ']' )
            int alt36=2;
            alt36 = dfa36.predict(input);
            switch (alt36) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:387:7: c= cident
                    {
                    pushFollow(FOLLOW_cident_in_deleteOp1881);
                    c=cident();

                    state._fsp--;

                     op = new Operation.ColumnDeletion(c); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:388:7: c= cident '[' t= term ']'
                    {
                    pushFollow(FOLLOW_cident_in_deleteOp1908);
                    c=cident();

                    state._fsp--;

                    match(input,137,FOLLOW_137_in_deleteOp1910); 
                    pushFollow(FOLLOW_term_in_deleteOp1914);
                    t=term();

                    state._fsp--;

                    match(input,138,FOLLOW_138_in_deleteOp1916); 
                     op = new Operation.ElementDeletion(c, t); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "deleteOp"


    // $ANTLR start "batchStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:391:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
    public final BatchStatement.Parsed batchStatement() throws RecognitionException {
        BatchStatement.Parsed expr = null;

        ModificationStatement.Parsed s1 = null;

        ModificationStatement.Parsed sN = null;



                BatchStatement.Type type = BatchStatement.Type.LOGGED;
                List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
                Attributes.Raw attrs = new Attributes.Raw();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:421:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:421:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? s1= batchStatementObjective ( ';' )? (sN= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
            {
            match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement1950); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:422:7: ( K_UNLOGGED | K_COUNTER )?
            int alt37=3;
            int LA37_0 = input.LA(1);

            if ( (LA37_0==K_UNLOGGED) ) {
                alt37=1;
            }
            else if ( (LA37_0==K_COUNTER) ) {
                alt37=2;
            }
            switch (alt37) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:422:9: K_UNLOGGED
                    {
                    match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement1960); 
                     type = BatchStatement.Type.UNLOGGED; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:422:63: K_COUNTER
                    {
                    match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement1966); 
                     type = BatchStatement.Type.COUNTER; 

                    }
                    break;

            }

            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement1979); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:423:15: ( usingClause[attrs] )?
            int alt38=2;
            int LA38_0 = input.LA(1);

            if ( (LA38_0==K_USING) ) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:423:17: usingClause[attrs]
                    {
                    pushFollow(FOLLOW_usingClause_in_batchStatement1983);
                    usingClause(attrs);

                    state._fsp--;


                    }
                    break;

            }

            pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2001);
            s1=batchStatementObjective();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:424:38: ( ';' )?
            int alt39=2;
            int LA39_0 = input.LA(1);

            if ( (LA39_0==132) ) {
                alt39=1;
            }
            switch (alt39) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:424:38: ';'
                    {
                    match(input,132,FOLLOW_132_in_batchStatement2003); 

                    }
                    break;

            }

             statements.add(s1); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:424:67: (sN= batchStatementObjective ( ';' )? )*
            loop41:
            do {
                int alt41=2;
                int LA41_0 = input.LA(1);

                if ( (LA41_0==K_INSERT||LA41_0==K_UPDATE||LA41_0==K_DELETE) ) {
                    alt41=1;
                }


                switch (alt41) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:424:69: sN= batchStatementObjective ( ';' )?
            	    {
            	    pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2012);
            	    sN=batchStatementObjective();

            	    state._fsp--;

            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:424:96: ( ';' )?
            	    int alt40=2;
            	    int LA40_0 = input.LA(1);

            	    if ( (LA40_0==132) ) {
            	        alt40=1;
            	    }
            	    switch (alt40) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:424:96: ';'
            	            {
            	            match(input,132,FOLLOW_132_in_batchStatement2014); 

            	            }
            	            break;

            	    }

            	     statements.add(sN); 

            	    }
            	    break;

            	default :
            	    break loop41;
                }
            } while (true);

            match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement2028); 
            match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2030); 

                      return new BatchStatement.Parsed(type, attrs, statements);
                  

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "batchStatement"


    // $ANTLR start "batchStatementObjective"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement | u= updateStatement | d= deleteStatement );
    public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
        ModificationStatement.Parsed statement = null;

        UpdateStatement.ParsedInsert i = null;

        UpdateStatement.ParsedUpdate u = null;

        DeleteStatement.Parsed d = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:432:5: (i= insertStatement | u= updateStatement | d= deleteStatement )
            int alt42=3;
            switch ( input.LA(1) ) {
            case K_INSERT:
                {
                alt42=1;
                }
                break;
            case K_UPDATE:
                {
                alt42=2;
                }
                break;
            case K_DELETE:
                {
                alt42=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;
            }

            switch (alt42) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:432:7: i= insertStatement
                    {
                    pushFollow(FOLLOW_insertStatement_in_batchStatementObjective2061);
                    i=insertStatement();

                    state._fsp--;

                     statement = i; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:7: u= updateStatement
                    {
                    pushFollow(FOLLOW_updateStatement_in_batchStatementObjective2074);
                    u=updateStatement();

                    state._fsp--;

                     statement = u; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:434:7: d= deleteStatement
                    {
                    pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective2087);
                    d=deleteStatement();

                    state._fsp--;

                     statement = d; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return statement;
    }
    // $ANTLR end "batchStatementObjective"


    // $ANTLR start "createKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
    public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
        CreateKeyspaceStatement expr = null;

        String ks = null;



                KSPropDefs attrs = new KSPropDefs();
                boolean ifNotExists = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement2122); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2124); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:27: ( K_IF K_NOT K_EXISTS )?
            int alt43=2;
            int LA43_0 = input.LA(1);

            if ( (LA43_0==K_IF) ) {
                alt43=1;
            }
            switch (alt43) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:445:28: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement2127); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement2129); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement2131); 
                     ifNotExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement2140);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement2148); 
            pushFollow(FOLLOW_properties_in_createKeyspaceStatement2150);
            properties(attrs);

            state._fsp--;

             expr = new CreateKeyspaceStatement(ks, attrs, ifNotExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createKeyspaceStatement"


    // $ANTLR start "createTableStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:449:1: createTableStatement returns [CreateTableStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] ;
    public final CreateTableStatement.RawStatement createTableStatement() throws RecognitionException {
        CreateTableStatement.RawStatement expr = null;

        CFName cf = null;


         boolean ifNotExists = false; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:458:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:458:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr]
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement2185); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement2187); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:458:31: ( K_IF K_NOT K_EXISTS )?
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==K_IF) ) {
                alt44=1;
            }
            switch (alt44) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:458:32: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createTableStatement2190); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement2192); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement2194); 
                     ifNotExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_columnFamilyName_in_createTableStatement2209);
            cf=columnFamilyName();

            state._fsp--;

             expr = new CreateTableStatement.RawStatement(cf, ifNotExists); 
            pushFollow(FOLLOW_cfamDefinition_in_createTableStatement2219);
            cfamDefinition(expr);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createTableStatement"


    // $ANTLR start "cfamDefinition"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:463:1: cfamDefinition[CreateTableStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? ;
    public final void cfamDefinition(CreateTableStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            {
            match(input,133,FOLLOW_133_in_cfamDefinition2238); 
            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2240);
            cfamColumns(expr);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:29: ( ',' ( cfamColumns[expr] )? )*
            loop46:
            do {
                int alt46=2;
                int LA46_0 = input.LA(1);

                if ( (LA46_0==135) ) {
                    alt46=1;
                }


                switch (alt46) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:31: ',' ( cfamColumns[expr] )?
            	    {
            	    match(input,135,FOLLOW_135_in_cfamDefinition2245); 
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:35: ( cfamColumns[expr] )?
            	    int alt45=2;
            	    int LA45_0 = input.LA(1);

            	    if ( ((LA45_0>=K_COUNT && LA45_0<=K_AS)||(LA45_0>=K_FILTERING && LA45_0<=K_TTL)||LA45_0==K_VALUES||LA45_0==K_EXISTS||LA45_0==K_TIMESTAMP||LA45_0==K_COUNTER||(LA45_0>=K_PRIMARY && LA45_0<=K_CUSTOM)||LA45_0==IDENT||LA45_0==K_TRIGGER||LA45_0==K_TYPE||LA45_0==K_LIST||(LA45_0>=K_ALL && LA45_0<=QUOTED_NAME)||(LA45_0>=K_ASCII && LA45_0<=K_MAP)) ) {
            	        alt45=1;
            	    }
            	    switch (alt45) {
            	        case 1 :
            	            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:464:35: cfamColumns[expr]
            	            {
            	            pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2247);
            	            cfamColumns(expr);

            	            state._fsp--;


            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop46;
                }
            } while (true);

            match(input,134,FOLLOW_134_in_cfamDefinition2254); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:7: ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( (LA48_0==K_WITH) ) {
                alt48=1;
            }
            switch (alt48) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:9: K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )*
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition2264); 
                    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2266);
                    cfamProperty(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:35: ( K_AND cfamProperty[expr] )*
                    loop47:
                    do {
                        int alt47=2;
                        int LA47_0 = input.LA(1);

                        if ( (LA47_0==K_AND) ) {
                            alt47=1;
                        }


                        switch (alt47) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:465:37: K_AND cfamProperty[expr]
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition2271); 
                    	    pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2273);
                    	    cfamProperty(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop47;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamDefinition"


    // $ANTLR start "cfamColumns"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:468:1: cfamColumns[CreateTableStatement.RawStatement expr] : (k= cident v= comparatorType ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')' );
    public final void cfamColumns(CreateTableStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        CQL3Type v = null;

        ColumnIdentifier c = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:5: (k= cident v= comparatorType ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')' )
            int alt51=2;
            int LA51_0 = input.LA(1);

            if ( ((LA51_0>=K_COUNT && LA51_0<=K_AS)||(LA51_0>=K_FILTERING && LA51_0<=K_TTL)||LA51_0==K_VALUES||LA51_0==K_EXISTS||LA51_0==K_TIMESTAMP||LA51_0==K_COUNTER||(LA51_0>=K_KEY && LA51_0<=K_CUSTOM)||LA51_0==IDENT||LA51_0==K_TRIGGER||LA51_0==K_TYPE||LA51_0==K_LIST||(LA51_0>=K_ALL && LA51_0<=QUOTED_NAME)||(LA51_0>=K_ASCII && LA51_0<=K_MAP)) ) {
                alt51=1;
            }
            else if ( (LA51_0==K_PRIMARY) ) {
                alt51=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 51, 0, input);

                throw nvae;
            }
            switch (alt51) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:7: k= cident v= comparatorType ( K_PRIMARY K_KEY )?
                    {
                    pushFollow(FOLLOW_cident_in_cfamColumns2299);
                    k=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_cfamColumns2303);
                    v=comparatorType();

                    state._fsp--;

                     expr.addDefinition(k, v); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:64: ( K_PRIMARY K_KEY )?
                    int alt49=2;
                    int LA49_0 = input.LA(1);

                    if ( (LA49_0==K_PRIMARY) ) {
                        alt49=1;
                    }
                    switch (alt49) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:65: K_PRIMARY K_KEY
                            {
                            match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2308); 
                            match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2310); 
                             expr.addKeyAliases(Collections.singletonList(k)); 

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= cident )* ')'
                    {
                    match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2322); 
                    match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2324); 
                    match(input,133,FOLLOW_133_in_cfamColumns2326); 
                    pushFollow(FOLLOW_pkDef_in_cfamColumns2328);
                    pkDef(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:39: ( ',' c= cident )*
                    loop50:
                    do {
                        int alt50=2;
                        int LA50_0 = input.LA(1);

                        if ( (LA50_0==135) ) {
                            alt50=1;
                        }


                        switch (alt50) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:470:40: ',' c= cident
                    	    {
                    	    match(input,135,FOLLOW_135_in_cfamColumns2332); 
                    	    pushFollow(FOLLOW_cident_in_cfamColumns2336);
                    	    c=cident();

                    	    state._fsp--;

                    	     expr.addColumnAlias(c); 

                    	    }
                    	    break;

                    	default :
                    	    break loop50;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_cfamColumns2343); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamColumns"


    // $ANTLR start "pkDef"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:473:1: pkDef[CreateTableStatement.RawStatement expr] : (k= cident | '(' k1= cident ( ',' kn= cident )* ')' );
    public final void pkDef(CreateTableStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;

        ColumnIdentifier k1 = null;

        ColumnIdentifier kn = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:5: (k= cident | '(' k1= cident ( ',' kn= cident )* ')' )
            int alt53=2;
            int LA53_0 = input.LA(1);

            if ( ((LA53_0>=K_COUNT && LA53_0<=K_AS)||(LA53_0>=K_FILTERING && LA53_0<=K_TTL)||LA53_0==K_VALUES||LA53_0==K_EXISTS||LA53_0==K_TIMESTAMP||LA53_0==K_COUNTER||(LA53_0>=K_KEY && LA53_0<=K_CUSTOM)||LA53_0==IDENT||LA53_0==K_TRIGGER||LA53_0==K_TYPE||LA53_0==K_LIST||(LA53_0>=K_ALL && LA53_0<=QUOTED_NAME)||(LA53_0>=K_ASCII && LA53_0<=K_MAP)) ) {
                alt53=1;
            }
            else if ( (LA53_0==133) ) {
                alt53=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;
            }
            switch (alt53) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:474:7: k= cident
                    {
                    pushFollow(FOLLOW_cident_in_pkDef2363);
                    k=cident();

                    state._fsp--;

                     expr.addKeyAliases(Collections.singletonList(k)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:7: '(' k1= cident ( ',' kn= cident )* ')'
                    {
                    match(input,133,FOLLOW_133_in_pkDef2373); 
                     List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
                    pushFollow(FOLLOW_cident_in_pkDef2379);
                    k1=cident();

                    state._fsp--;

                     l.add(k1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:102: ( ',' kn= cident )*
                    loop52:
                    do {
                        int alt52=2;
                        int LA52_0 = input.LA(1);

                        if ( (LA52_0==135) ) {
                            alt52=1;
                        }


                        switch (alt52) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:104: ',' kn= cident
                    	    {
                    	    match(input,135,FOLLOW_135_in_pkDef2385); 
                    	    pushFollow(FOLLOW_cident_in_pkDef2389);
                    	    kn=cident();

                    	    state._fsp--;

                    	     l.add(kn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop52;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_pkDef2396); 
                     expr.addKeyAliases(l); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "pkDef"


    // $ANTLR start "cfamProperty"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:1: cfamProperty[CreateTableStatement.RawStatement expr] : ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' );
    public final void cfamProperty(CreateTableStatement.RawStatement expr) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:479:5: ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' )
            int alt55=3;
            switch ( input.LA(1) ) {
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_STORAGE:
            case K_CUSTOM:
            case IDENT:
            case K_TRIGGER:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case QUOTED_NAME:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt55=1;
                }
                break;
            case K_COMPACT:
                {
                int LA55_2 = input.LA(2);

                if ( (LA55_2==K_STORAGE) ) {
                    alt55=2;
                }
                else if ( (LA55_2==143) ) {
                    alt55=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 55, 2, input);

                    throw nvae;
                }
                }
                break;
            case K_CLUSTERING:
                {
                int LA55_3 = input.LA(2);

                if ( (LA55_3==K_ORDER) ) {
                    alt55=3;
                }
                else if ( (LA55_3==143) ) {
                    alt55=1;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 55, 3, input);

                    throw nvae;
                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 55, 0, input);

                throw nvae;
            }

            switch (alt55) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:479:7: property[expr.properties]
                    {
                    pushFollow(FOLLOW_property_in_cfamProperty2416);
                    property(expr.properties);

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:480:7: K_COMPACT K_STORAGE
                    {
                    match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty2425); 
                    match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty2427); 
                     expr.setCompactStorage(); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:481:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')'
                    {
                    match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty2437); 
                    match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty2439); 
                    match(input,K_BY,FOLLOW_K_BY_in_cfamProperty2441); 
                    match(input,133,FOLLOW_133_in_cfamProperty2443); 
                    pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2445);
                    cfamOrdering(expr);

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:481:56: ( ',' cfamOrdering[expr] )*
                    loop54:
                    do {
                        int alt54=2;
                        int LA54_0 = input.LA(1);

                        if ( (LA54_0==135) ) {
                            alt54=1;
                        }


                        switch (alt54) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:481:57: ',' cfamOrdering[expr]
                    	    {
                    	    match(input,135,FOLLOW_135_in_cfamProperty2449); 
                    	    pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2451);
                    	    cfamOrdering(expr);

                    	    state._fsp--;


                    	    }
                    	    break;

                    	default :
                    	    break loop54;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_cfamProperty2456); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamProperty"


    // $ANTLR start "cfamOrdering"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:484:1: cfamOrdering[CreateTableStatement.RawStatement expr] : k= cident ( K_ASC | K_DESC ) ;
    public final void cfamOrdering(CreateTableStatement.RawStatement expr) throws RecognitionException {
        ColumnIdentifier k = null;


         boolean reversed=false; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:5: (k= cident ( K_ASC | K_DESC ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:7: k= cident ( K_ASC | K_DESC )
            {
            pushFollow(FOLLOW_cident_in_cfamOrdering2484);
            k=cident();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:16: ( K_ASC | K_DESC )
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0==K_ASC) ) {
                alt56=1;
            }
            else if ( (LA56_0==K_DESC) ) {
                alt56=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }
            switch (alt56) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:17: K_ASC
                    {
                    match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering2487); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:25: K_DESC
                    {
                    match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering2491); 
                     reversed=true;

                    }
                    break;

            }

             expr.setOrdering(k, reversed); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfamOrdering"


    // $ANTLR start "createIndexStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:489:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ( K_USING cls= STRING_LITERAL )? ;
    public final CreateIndexStatement createIndexStatement() throws RecognitionException {
        CreateIndexStatement expr = null;

        Token idxName=null;
        Token cls=null;
        CFName cf = null;

        ColumnIdentifier id = null;



                boolean isCustom = false;
                boolean ifNotExists = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:498:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ( K_USING cls= STRING_LITERAL )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:498:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? (idxName= IDENT )? K_ON cf= columnFamilyName '(' id= cident ')' ( K_USING cls= STRING_LITERAL )?
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement2529); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:498:16: ( K_CUSTOM )?
            int alt57=2;
            int LA57_0 = input.LA(1);

            if ( (LA57_0==K_CUSTOM) ) {
                alt57=1;
            }
            switch (alt57) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:498:17: K_CUSTOM
                    {
                    match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement2532); 
                     isCustom = true; 

                    }
                    break;

            }

            match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement2538); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:498:57: ( K_IF K_NOT K_EXISTS )?
            int alt58=2;
            int LA58_0 = input.LA(1);

            if ( (LA58_0==K_IF) ) {
                alt58=1;
            }
            switch (alt58) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:498:58: K_IF K_NOT K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement2541); 
                    match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement2543); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement2545); 
                     ifNotExists = true; 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:9: (idxName= IDENT )?
            int alt59=2;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==IDENT) ) {
                alt59=1;
            }
            switch (alt59) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:10: idxName= IDENT
                    {
                    idxName=(Token)match(input,IDENT,FOLLOW_IDENT_in_createIndexStatement2563); 

                    }
                    break;

            }

            match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement2567); 
            pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement2571);
            cf=columnFamilyName();

            state._fsp--;

            match(input,133,FOLLOW_133_in_createIndexStatement2573); 
            pushFollow(FOLLOW_cident_in_createIndexStatement2577);
            id=cident();

            state._fsp--;

            match(input,134,FOLLOW_134_in_createIndexStatement2579); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:500:9: ( K_USING cls= STRING_LITERAL )?
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( (LA60_0==K_USING) ) {
                alt60=1;
            }
            switch (alt60) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:500:11: K_USING cls= STRING_LITERAL
                    {
                    match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement2591); 
                    cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement2595); 

                    }
                    break;

            }

             expr = new CreateIndexStatement(cf, (idxName!=null?idxName.getText():null), id, ifNotExists, isCustom, (cls!=null?cls.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createIndexStatement"


    // $ANTLR start "createTriggerStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:504:1: createTriggerStatement returns [CreateTriggerStatement expr] : K_CREATE K_TRIGGER (tn= IDENT ) K_ON cf= columnFamilyName K_USING tc1= STRING_LITERAL ;
    public final CreateTriggerStatement createTriggerStatement() throws RecognitionException {
        CreateTriggerStatement expr = null;

        Token tn=null;
        Token tc1=null;
        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:508:5: ( K_CREATE K_TRIGGER (tn= IDENT ) K_ON cf= columnFamilyName K_USING tc1= STRING_LITERAL )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:508:7: K_CREATE K_TRIGGER (tn= IDENT ) K_ON cf= columnFamilyName K_USING tc1= STRING_LITERAL
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement2629); 
            match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement2631); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:508:26: (tn= IDENT )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:508:27: tn= IDENT
            {
            tn=(Token)match(input,IDENT,FOLLOW_IDENT_in_createTriggerStatement2636); 

            }

            match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement2639); 
            pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement2643);
            cf=columnFamilyName();

            state._fsp--;

            match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement2645); 
            tc1=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement2649); 
             expr = new CreateTriggerStatement(cf, (tn!=null?tn.getText():null), (tc1!=null?tc1.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "createTriggerStatement"


    // $ANTLR start "dropTriggerStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:1: dropTriggerStatement returns [DropTriggerStatement expr] : K_DROP K_TRIGGER (tn= IDENT ) K_ON cf= columnFamilyName ;
    public final DropTriggerStatement dropTriggerStatement() throws RecognitionException {
        DropTriggerStatement expr = null;

        Token tn=null;
        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:5: ( K_DROP K_TRIGGER (tn= IDENT ) K_ON cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:7: K_DROP K_TRIGGER (tn= IDENT ) K_ON cf= columnFamilyName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement2680); 
            match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement2682); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:24: (tn= IDENT )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:516:25: tn= IDENT
            {
            tn=(Token)match(input,IDENT,FOLLOW_IDENT_in_dropTriggerStatement2687); 

            }

            match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement2690); 
            pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement2694);
            cf=columnFamilyName();

            state._fsp--;

             expr = new DropTriggerStatement(cf, (tn!=null?tn.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "dropTriggerStatement"


    // $ANTLR start "alterKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:520:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
    public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
        AlterKeyspaceStatement expr = null;

        String ks = null;


         KSPropDefs attrs = new KSPropDefs(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement2734); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement2736); 
            pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement2740);
            ks=keyspaceName();

            state._fsp--;

            match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement2750); 
            pushFollow(FOLLOW_properties_in_alterKeyspaceStatement2752);
            properties(attrs);

            state._fsp--;

             expr = new AlterKeyspaceStatement(ks, attrs); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterKeyspaceStatement"


    // $ANTLR start "alterTableStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
    public final AlterTableStatement alterTableStatement() throws RecognitionException {
        AlterTableStatement expr = null;

        CFName cf = null;

        ColumnIdentifier id = null;

        CQL3Type v = null;

        ColumnIdentifier id1 = null;

        ColumnIdentifier toId1 = null;

        ColumnIdentifier idn = null;

        ColumnIdentifier toIdn = null;



                AlterTableStatement.Type type = null;
                CFPropDefs props = new CFPropDefs();
                Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>();
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:543:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:543:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement2788); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement2790); 
            pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement2794);
            cf=columnFamilyName();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:544:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
            int alt62=5;
            switch ( input.LA(1) ) {
            case K_ALTER:
                {
                alt62=1;
                }
                break;
            case K_ADD:
                {
                alt62=2;
                }
                break;
            case K_DROP:
                {
                alt62=3;
                }
                break;
            case K_WITH:
                {
                alt62=4;
                }
                break;
            case K_RENAME:
                {
                alt62=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;
            }

            switch (alt62) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:544:13: K_ALTER id= cident K_TYPE v= comparatorType
                    {
                    match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement2808); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2812);
                    id=cident();

                    state._fsp--;

                    match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement2814); 
                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement2818);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ALTER; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:545:13: K_ADD id= cident v= comparatorType
                    {
                    match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement2834); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2840);
                    id=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_comparatorType_in_alterTableStatement2844);
                    v=comparatorType();

                    state._fsp--;

                     type = AlterTableStatement.Type.ADD; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:546:13: K_DROP id= cident
                    {
                    match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement2867); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement2872);
                    id=cident();

                    state._fsp--;

                     type = AlterTableStatement.Type.DROP; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:547:13: K_WITH properties[props]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement2912); 
                    pushFollow(FOLLOW_properties_in_alterTableStatement2915);
                    properties(props);

                    state._fsp--;

                     type = AlterTableStatement.Type.OPTS; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:548:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
                    {
                    match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement2948); 
                     type = AlterTableStatement.Type.RENAME; 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3002);
                    id1=cident();

                    state._fsp--;

                    match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3004); 
                    pushFollow(FOLLOW_cident_in_alterTableStatement3008);
                    toId1=cident();

                    state._fsp--;

                     renames.put(id1, toId1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:550:16: ( K_AND idn= cident K_TO toIdn= cident )*
                    loop61:
                    do {
                        int alt61=2;
                        int LA61_0 = input.LA(1);

                        if ( (LA61_0==K_AND) ) {
                            alt61=1;
                        }


                        switch (alt61) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:550:18: K_AND idn= cident K_TO toIdn= cident
                    	    {
                    	    match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement3029); 
                    	    pushFollow(FOLLOW_cident_in_alterTableStatement3033);
                    	    idn=cident();

                    	    state._fsp--;

                    	    match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3035); 
                    	    pushFollow(FOLLOW_cident_in_alterTableStatement3039);
                    	    toIdn=cident();

                    	    state._fsp--;

                    	     renames.put(idn, toIdn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop61;
                        }
                    } while (true);


                    }
                    break;

            }


                    expr = new AlterTableStatement(cf, type, id, v, props, renames);
                

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "alterTableStatement"


    // $ANTLR start "dropKeyspaceStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:557:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
    public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
        DropKeyspaceStatement ksp = null;

        String ks = null;


         boolean ifExists = false; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:562:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:562:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement3094); 
            match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3096); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:562:25: ( K_IF K_EXISTS )?
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==K_IF) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:562:26: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement3099); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement3101); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement3110);
            ks=keyspaceName();

            state._fsp--;

             ksp = new DropKeyspaceStatement(ks, ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ksp;
    }
    // $ANTLR end "dropKeyspaceStatement"


    // $ANTLR start "dropTableStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:565:1: dropTableStatement returns [DropTableStatement stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ;
    public final DropTableStatement dropTableStatement() throws RecognitionException {
        DropTableStatement stmt = null;

        CFName cf = null;


         boolean ifExists = false; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement3144); 
            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3146); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:29: ( K_IF K_EXISTS )?
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( (LA64_0==K_IF) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:570:30: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement3149); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement3151); 
                     ifExists = true; 

                    }
                    break;

            }

            pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement3160);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new DropTableStatement(cf, ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropTableStatement"


    // $ANTLR start "dropIndexStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:573:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= IDENT ;
    public final DropIndexStatement dropIndexStatement() throws RecognitionException {
        DropIndexStatement expr = null;

        Token index=null;

         boolean ifExists = false; 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= IDENT )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= IDENT
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement3194); 
            match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement3196); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:22: ( K_IF K_EXISTS )?
            int alt65=2;
            int LA65_0 = input.LA(1);

            if ( (LA65_0==K_IF) ) {
                alt65=1;
            }
            switch (alt65) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:578:23: K_IF K_EXISTS
                    {
                    match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement3199); 
                    match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement3201); 
                     ifExists = true; 

                    }
                    break;

            }

            index=(Token)match(input,IDENT,FOLLOW_IDENT_in_dropIndexStatement3210); 
             expr = new DropIndexStatement((index!=null?index.getText():null), ifExists); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return expr;
    }
    // $ANTLR end "dropIndexStatement"


    // $ANTLR start "truncateStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:582:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE cf= columnFamilyName ;
    public final TruncateStatement truncateStatement() throws RecognitionException {
        TruncateStatement stmt = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:586:5: ( K_TRUNCATE cf= columnFamilyName )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:586:7: K_TRUNCATE cf= columnFamilyName
            {
            match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement3241); 
            pushFollow(FOLLOW_columnFamilyName_in_truncateStatement3245);
            cf=columnFamilyName();

            state._fsp--;

             stmt = new TruncateStatement(cf); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "truncateStatement"


    // $ANTLR start "grantStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:589:1: grantStatement returns [GrantStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO username ;
    public final GrantStatement grantStatement() throws RecognitionException {
        GrantStatement stmt = null;

        Set<Permission> permissionOrAll1 = null;

        IResource resource2 = null;

        CqlParser.username_return username3 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:593:5: ( K_GRANT permissionOrAll K_ON resource K_TO username )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:593:7: K_GRANT permissionOrAll K_ON resource K_TO username
            {
            match(input,K_GRANT,FOLLOW_K_GRANT_in_grantStatement3270); 
            pushFollow(FOLLOW_permissionOrAll_in_grantStatement3282);
            permissionOrAll1=permissionOrAll();

            state._fsp--;

            match(input,K_ON,FOLLOW_K_ON_in_grantStatement3290); 
            pushFollow(FOLLOW_resource_in_grantStatement3302);
            resource2=resource();

            state._fsp--;

            match(input,K_TO,FOLLOW_K_TO_in_grantStatement3310); 
            pushFollow(FOLLOW_username_in_grantStatement3322);
            username3=username();

            state._fsp--;

             stmt = new GrantStatement(permissionOrAll1, resource2, (username3!=null?input.toString(username3.start,username3.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "grantStatement"


    // $ANTLR start "revokeStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:602:1: revokeStatement returns [RevokeStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM username ;
    public final RevokeStatement revokeStatement() throws RecognitionException {
        RevokeStatement stmt = null;

        Set<Permission> permissionOrAll4 = null;

        IResource resource5 = null;

        CqlParser.username_return username6 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:606:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM username )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:606:7: K_REVOKE permissionOrAll K_ON resource K_FROM username
            {
            match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeStatement3353); 
            pushFollow(FOLLOW_permissionOrAll_in_revokeStatement3365);
            permissionOrAll4=permissionOrAll();

            state._fsp--;

            match(input,K_ON,FOLLOW_K_ON_in_revokeStatement3373); 
            pushFollow(FOLLOW_resource_in_revokeStatement3385);
            resource5=resource();

            state._fsp--;

            match(input,K_FROM,FOLLOW_K_FROM_in_revokeStatement3393); 
            pushFollow(FOLLOW_username_in_revokeStatement3405);
            username6=username();

            state._fsp--;

             stmt = new RevokeStatement(permissionOrAll4, resource5, (username6!=null?input.toString(username6.start,username6.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "revokeStatement"


    // $ANTLR start "listPermissionsStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:615:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? ;
    public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
        ListPermissionsStatement stmt = null;

        IResource resource7 = null;

        CqlParser.username_return username8 = null;

        Set<Permission> permissionOrAll9 = null;



                IResource resource = null;
                String username = null;
                boolean recursive = true;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:621:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:621:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )?
            {
            match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement3443); 
            pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement3455);
            permissionOrAll9=permissionOrAll();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:623:7: ( K_ON resource )?
            int alt66=2;
            int LA66_0 = input.LA(1);

            if ( (LA66_0==K_ON) ) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:623:9: K_ON resource
                    {
                    match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement3465); 
                    pushFollow(FOLLOW_resource_in_listPermissionsStatement3467);
                    resource7=resource();

                    state._fsp--;

                     resource = resource7; 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:624:7: ( K_OF username )?
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==K_OF) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:624:9: K_OF username
                    {
                    match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement3482); 
                    pushFollow(FOLLOW_username_in_listPermissionsStatement3484);
                    username8=username();

                    state._fsp--;

                     username = (username8!=null?input.toString(username8.start,username8.stop):null); 

                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:625:7: ( K_NORECURSIVE )?
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( (LA68_0==K_NORECURSIVE) ) {
                alt68=1;
            }
            switch (alt68) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:625:9: K_NORECURSIVE
                    {
                    match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement3499); 
                     recursive = false; 

                    }
                    break;

            }

             stmt = new ListPermissionsStatement(permissionOrAll9, resource, username, recursive); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "listPermissionsStatement"


    // $ANTLR start "permission"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:629:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) ;
    public final Permission permission() throws RecognitionException {
        Permission perm = null;

        Token p=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:630:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE )
            {
            p=(Token)input.LT(1);
            if ( input.LA(1)==K_SELECT||input.LA(1)==K_CREATE||(input.LA(1)>=K_DROP && input.LA(1)<=K_ALTER)||(input.LA(1)>=K_MODIFY && input.LA(1)<=K_AUTHORIZE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return perm;
    }
    // $ANTLR end "permission"


    // $ANTLR start "permissionOrAll"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:634:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? | p= permission ( K_PERMISSION )? );
    public final Set<Permission> permissionOrAll() throws RecognitionException {
        Set<Permission> perms = null;

        Permission p = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:5: ( K_ALL ( K_PERMISSIONS )? | p= permission ( K_PERMISSION )? )
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==K_ALL) ) {
                alt71=1;
            }
            else if ( (LA71_0==K_SELECT||LA71_0==K_CREATE||(LA71_0>=K_DROP && LA71_0<=K_ALTER)||(LA71_0>=K_MODIFY && LA71_0<=K_AUTHORIZE)) ) {
                alt71=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;
            }
            switch (alt71) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:7: K_ALL ( K_PERMISSIONS )?
                    {
                    match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll3584); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:13: ( K_PERMISSIONS )?
                    int alt69=2;
                    int LA69_0 = input.LA(1);

                    if ( (LA69_0==K_PERMISSIONS) ) {
                        alt69=1;
                    }
                    switch (alt69) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:15: K_PERMISSIONS
                            {
                            match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll3588); 

                            }
                            break;

                    }

                     perms = Permission.ALL_DATA; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:636:7: p= permission ( K_PERMISSION )?
                    {
                    pushFollow(FOLLOW_permission_in_permissionOrAll3609);
                    p=permission();

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:636:20: ( K_PERMISSION )?
                    int alt70=2;
                    int LA70_0 = input.LA(1);

                    if ( (LA70_0==K_PERMISSION) ) {
                        alt70=1;
                    }
                    switch (alt70) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:636:22: K_PERMISSION
                            {
                            match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll3613); 

                            }
                            break;

                    }

                     perms = EnumSet.of(p); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return perms;
    }
    // $ANTLR end "permissionOrAll"


    // $ANTLR start "resource"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:639:1: resource returns [IResource res] : r= dataResource ;
    public final IResource resource() throws RecognitionException {
        IResource res = null;

        DataResource r = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:640:5: (r= dataResource )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:640:7: r= dataResource
            {
            pushFollow(FOLLOW_dataResource_in_resource3641);
            r=dataResource();

            state._fsp--;

             res = r; 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "resource"


    // $ANTLR start "dataResource"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:643:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
    public final DataResource dataResource() throws RecognitionException {
        DataResource res = null;

        String ks = null;

        CFName cf = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:644:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
            int alt73=3;
            switch ( input.LA(1) ) {
            case K_ALL:
                {
                int LA73_1 = input.LA(2);

                if ( (LA73_1==K_KEYSPACES) ) {
                    alt73=1;
                }
                else if ( (LA73_1==EOF||LA73_1==K_FROM||LA73_1==K_TO||(LA73_1>=K_OF && LA73_1<=K_NORECURSIVE)||LA73_1==132||LA73_1==139) ) {
                    alt73=3;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 73, 1, input);

                    throw nvae;
                }
                }
                break;
            case K_KEYSPACE:
                {
                alt73=2;
                }
                break;
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_COLUMNFAMILY:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case IDENT:
            case K_TRIGGER:
            case K_TYPE:
            case K_LIST:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case QUOTED_NAME:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt73=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;
            }

            switch (alt73) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:644:7: K_ALL K_KEYSPACES
                    {
                    match(input,K_ALL,FOLLOW_K_ALL_in_dataResource3664); 
                    match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource3666); 
                     res = DataResource.root(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:645:7: K_KEYSPACE ks= keyspaceName
                    {
                    match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource3676); 
                    pushFollow(FOLLOW_keyspaceName_in_dataResource3682);
                    ks=keyspaceName();

                    state._fsp--;

                     res = DataResource.keyspace(ks); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
                    {
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:7: ( K_COLUMNFAMILY )?
                    int alt72=2;
                    int LA72_0 = input.LA(1);

                    if ( (LA72_0==K_COLUMNFAMILY) ) {
                        alt72=1;
                    }
                    switch (alt72) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:646:9: K_COLUMNFAMILY
                            {
                            match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource3694); 

                            }
                            break;

                    }

                    pushFollow(FOLLOW_columnFamilyName_in_dataResource3703);
                    cf=columnFamilyName();

                    state._fsp--;

                     res = DataResource.columnFamily(cf.getKeyspace(), cf.getColumnFamily()); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return res;
    }
    // $ANTLR end "dataResource"


    // $ANTLR start "createUserStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:650:1: createUserStatement returns [CreateUserStatement stmt] : K_CREATE K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
    public final CreateUserStatement createUserStatement() throws RecognitionException {
        CreateUserStatement stmt = null;

        CqlParser.username_return username10 = null;



                UserOptions opts = new UserOptions();
                boolean superuser = false;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:658:5: ( K_CREATE K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:658:7: K_CREATE K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
            {
            match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement3743); 
            match(input,K_USER,FOLLOW_K_USER_in_createUserStatement3745); 
            pushFollow(FOLLOW_username_in_createUserStatement3747);
            username10=username();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:7: ( K_WITH userOptions[opts] )?
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==K_WITH) ) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:9: K_WITH userOptions[opts]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement3757); 
                    pushFollow(FOLLOW_userOptions_in_createUserStatement3759);
                    userOptions(opts);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:660:7: ( K_SUPERUSER | K_NOSUPERUSER )?
            int alt75=3;
            int LA75_0 = input.LA(1);

            if ( (LA75_0==K_SUPERUSER) ) {
                alt75=1;
            }
            else if ( (LA75_0==K_NOSUPERUSER) ) {
                alt75=2;
            }
            switch (alt75) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:660:9: K_SUPERUSER
                    {
                    match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement3773); 
                     superuser = true; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:660:45: K_NOSUPERUSER
                    {
                    match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement3779); 
                     superuser = false; 

                    }
                    break;

            }

             stmt = new CreateUserStatement((username10!=null?input.toString(username10.start,username10.stop):null), opts, superuser); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "createUserStatement"


    // $ANTLR start "alterUserStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:664:1: alterUserStatement returns [AlterUserStatement stmt] : K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
    public final AlterUserStatement alterUserStatement() throws RecognitionException {
        AlterUserStatement stmt = null;

        CqlParser.username_return username11 = null;



                UserOptions opts = new UserOptions();
                Boolean superuser = null;
            
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:672:5: ( K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:672:7: K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
            {
            match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement3824); 
            match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement3826); 
            pushFollow(FOLLOW_username_in_alterUserStatement3828);
            username11=username();

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:7: ( K_WITH userOptions[opts] )?
            int alt76=2;
            int LA76_0 = input.LA(1);

            if ( (LA76_0==K_WITH) ) {
                alt76=1;
            }
            switch (alt76) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:673:9: K_WITH userOptions[opts]
                    {
                    match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement3838); 
                    pushFollow(FOLLOW_userOptions_in_alterUserStatement3840);
                    userOptions(opts);

                    state._fsp--;


                    }
                    break;

            }

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:674:7: ( K_SUPERUSER | K_NOSUPERUSER )?
            int alt77=3;
            int LA77_0 = input.LA(1);

            if ( (LA77_0==K_SUPERUSER) ) {
                alt77=1;
            }
            else if ( (LA77_0==K_NOSUPERUSER) ) {
                alt77=2;
            }
            switch (alt77) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:674:9: K_SUPERUSER
                    {
                    match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement3854); 
                     superuser = true; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:674:45: K_NOSUPERUSER
                    {
                    match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement3860); 
                     superuser = false; 

                    }
                    break;

            }

             stmt = new AlterUserStatement((username11!=null?input.toString(username11.start,username11.stop):null), opts, superuser); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "alterUserStatement"


    // $ANTLR start "dropUserStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:678:1: dropUserStatement returns [DropUserStatement stmt] : K_DROP K_USER username ;
    public final DropUserStatement dropUserStatement() throws RecognitionException {
        DropUserStatement stmt = null;

        CqlParser.username_return username12 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:5: ( K_DROP K_USER username )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:682:7: K_DROP K_USER username
            {
            match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement3896); 
            match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement3898); 
            pushFollow(FOLLOW_username_in_dropUserStatement3900);
            username12=username();

            state._fsp--;

             stmt = new DropUserStatement((username12!=null?input.toString(username12.start,username12.stop):null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "dropUserStatement"


    // $ANTLR start "listUsersStatement"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:685:1: listUsersStatement returns [ListUsersStatement stmt] : K_LIST K_USERS ;
    public final ListUsersStatement listUsersStatement() throws RecognitionException {
        ListUsersStatement stmt = null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:5: ( K_LIST K_USERS )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:689:7: K_LIST K_USERS
            {
            match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement3925); 
            match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement3927); 
             stmt = new ListUsersStatement(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return stmt;
    }
    // $ANTLR end "listUsersStatement"


    // $ANTLR start "userOptions"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:692:1: userOptions[UserOptions opts] : userOption[opts] ;
    public final void userOptions(UserOptions opts) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:5: ( userOption[opts] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:693:7: userOption[opts]
            {
            pushFollow(FOLLOW_userOption_in_userOptions3947);
            userOption(opts);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "userOptions"


    // $ANTLR start "userOption"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:696:1: userOption[UserOptions opts] : k= K_PASSWORD v= STRING_LITERAL ;
    public final void userOption(UserOptions opts) throws RecognitionException {
        Token k=null;
        Token v=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:697:5: (k= K_PASSWORD v= STRING_LITERAL )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:697:7: k= K_PASSWORD v= STRING_LITERAL
            {
            k=(Token)match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userOption3968); 
            v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userOption3972); 
             opts.put((k!=null?k.getText():null), (v!=null?v.getText():null)); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "userOption"


    // $ANTLR start "cident"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:700:1: cident returns [ColumnIdentifier id] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final ColumnIdentifier cident() throws RecognitionException {
        ColumnIdentifier id = null;

        Token t=null;
        String k = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:704:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt78=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt78=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt78=2;
                }
                break;
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case K_TRIGGER:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt78=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;
            }

            switch (alt78) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:704:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident4001); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:705:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident4026); 
                     id = new ColumnIdentifier((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:706:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_cident4045);
                    k=unreserved_keyword();

                    state._fsp--;

                     id = new ColumnIdentifier(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "cident"


    // $ANTLR start "keyspaceName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:710:1: keyspaceName returns [String id] : cfOrKsName[name, true] ;
    public final String keyspaceName() throws RecognitionException {
        String id = null;

         CFName name = new CFName(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:712:5: ( cfOrKsName[name, true] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:712:7: cfOrKsName[name, true]
            {
            pushFollow(FOLLOW_cfOrKsName_in_keyspaceName4078);
            cfOrKsName(name, true);

            state._fsp--;

             id = name.getKeyspace(); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return id;
    }
    // $ANTLR end "keyspaceName"


    // $ANTLR start "columnFamilyName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:715:1: columnFamilyName returns [CFName name] : ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] ;
    public final CFName columnFamilyName() throws RecognitionException {
        CFName name = null;

         name = new CFName(); 
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:5: ( ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false] )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:7: ( cfOrKsName[name, true] '.' )? cfOrKsName[name, false]
            {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:7: ( cfOrKsName[name, true] '.' )?
            int alt79=2;
            alt79 = dfa79.predict(input);
            switch (alt79) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:717:8: cfOrKsName[name, true] '.'
                    {
                    pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName4112);
                    cfOrKsName(name, true);

                    state._fsp--;

                    match(input,139,FOLLOW_139_in_columnFamilyName4115); 

                    }
                    break;

            }

            pushFollow(FOLLOW_cfOrKsName_in_columnFamilyName4119);
            cfOrKsName(name, false);

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return name;
    }
    // $ANTLR end "columnFamilyName"


    // $ANTLR start "cfOrKsName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:720:1: cfOrKsName[CFName name, boolean isKs] : (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword );
    public final void cfOrKsName(CFName name, boolean isKs) throws RecognitionException {
        Token t=null;
        String k = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:5: (t= IDENT | t= QUOTED_NAME | k= unreserved_keyword )
            int alt80=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt80=1;
                }
                break;
            case QUOTED_NAME:
                {
                alt80=2;
                }
                break;
            case K_COUNT:
            case K_AS:
            case K_FILTERING:
            case K_WRITETIME:
            case K_TTL:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case K_TRIGGER:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt80=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;
            }

            switch (alt80) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:7: t= IDENT
                    {
                    t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfOrKsName4140); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), false); else name.setColumnFamily((t!=null?t.getText():null), false); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:722:7: t= QUOTED_NAME
                    {
                    t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfOrKsName4165); 
                     if (isKs) name.setKeyspace((t!=null?t.getText():null), true); else name.setColumnFamily((t!=null?t.getText():null), true); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:723:7: k= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_cfOrKsName4184);
                    k=unreserved_keyword();

                    state._fsp--;

                     if (isKs) name.setKeyspace(k, false); else name.setColumnFamily(k, false); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "cfOrKsName"


    // $ANTLR start "constant"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:726:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL | t= INTEGER | t= FLOAT | t= BOOLEAN | t= UUID | t= HEXNUMBER );
    public final Constants.Literal constant() throws RecognitionException {
        Constants.Literal constant = null;

        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:727:5: (t= STRING_LITERAL | t= INTEGER | t= FLOAT | t= BOOLEAN | t= UUID | t= HEXNUMBER )
            int alt81=6;
            switch ( input.LA(1) ) {
            case STRING_LITERAL:
                {
                alt81=1;
                }
                break;
            case INTEGER:
                {
                alt81=2;
                }
                break;
            case FLOAT:
                {
                alt81=3;
                }
                break;
            case BOOLEAN:
                {
                alt81=4;
                }
                break;
            case UUID:
                {
                alt81=5;
                }
                break;
            case HEXNUMBER:
                {
                alt81=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;
            }

            switch (alt81) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:727:7: t= STRING_LITERAL
                    {
                    t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant4209); 
                     constant = Constants.Literal.string((t!=null?t.getText():null)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:728:7: t= INTEGER
                    {
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant4221); 
                     constant = Constants.Literal.integer((t!=null?t.getText():null)); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:729:7: t= FLOAT
                    {
                    t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant4240); 
                     constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:730:7: t= BOOLEAN
                    {
                    t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant4261); 
                     constant = Constants.Literal.bool((t!=null?t.getText():null)); 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:731:7: t= UUID
                    {
                    t=(Token)match(input,UUID,FOLLOW_UUID_in_constant4280); 
                     constant = Constants.Literal.uuid((t!=null?t.getText():null)); 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:732:7: t= HEXNUMBER
                    {
                    t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant4302); 
                     constant = Constants.Literal.hex((t!=null?t.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return constant;
    }
    // $ANTLR end "constant"


    // $ANTLR start "set_tail"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:735:1: set_tail[List<Term.Raw> s] : ( '}' | ',' t= term set_tail[s] );
    public final void set_tail(List<Term.Raw> s) throws RecognitionException {
        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:5: ( '}' | ',' t= term set_tail[s] )
            int alt82=2;
            int LA82_0 = input.LA(1);

            if ( (LA82_0==140) ) {
                alt82=1;
            }
            else if ( (LA82_0==135) ) {
                alt82=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;
            }
            switch (alt82) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:736:7: '}'
                    {
                    match(input,140,FOLLOW_140_in_set_tail4327); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:737:7: ',' t= term set_tail[s]
                    {
                    match(input,135,FOLLOW_135_in_set_tail4335); 
                    pushFollow(FOLLOW_term_in_set_tail4339);
                    t=term();

                    state._fsp--;

                     s.add(t); 
                    pushFollow(FOLLOW_set_tail_in_set_tail4343);
                    set_tail(s);

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "set_tail"


    // $ANTLR start "map_tail"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:740:1: map_tail[List<Pair<Term.Raw, Term.Raw>> m] : ( '}' | ',' k= term ':' v= term map_tail[m] );
    public final void map_tail(List<Pair<Term.Raw, Term.Raw>> m) throws RecognitionException {
        Term.Raw k = null;

        Term.Raw v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:741:5: ( '}' | ',' k= term ':' v= term map_tail[m] )
            int alt83=2;
            int LA83_0 = input.LA(1);

            if ( (LA83_0==140) ) {
                alt83=1;
            }
            else if ( (LA83_0==135) ) {
                alt83=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 83, 0, input);

                throw nvae;
            }
            switch (alt83) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:741:7: '}'
                    {
                    match(input,140,FOLLOW_140_in_map_tail4362); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:742:7: ',' k= term ':' v= term map_tail[m]
                    {
                    match(input,135,FOLLOW_135_in_map_tail4370); 
                    pushFollow(FOLLOW_term_in_map_tail4374);
                    k=term();

                    state._fsp--;

                    match(input,141,FOLLOW_141_in_map_tail4376); 
                    pushFollow(FOLLOW_term_in_map_tail4380);
                    v=term();

                    state._fsp--;

                     m.add(Pair.create(k, v)); 
                    pushFollow(FOLLOW_map_tail_in_map_tail4384);
                    map_tail(m);

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "map_tail"


    // $ANTLR start "map_literal"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:745:1: map_literal returns [Maps.Literal map] : ( '{' '}' | '{' k1= term ':' v1= term map_tail[m] );
    public final Maps.Literal map_literal() throws RecognitionException {
        Maps.Literal map = null;

        Term.Raw k1 = null;

        Term.Raw v1 = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:5: ( '{' '}' | '{' k1= term ':' v1= term map_tail[m] )
            int alt84=2;
            int LA84_0 = input.LA(1);

            if ( (LA84_0==142) ) {
                int LA84_1 = input.LA(2);

                if ( (LA84_1==140) ) {
                    alt84=1;
                }
                else if ( (LA84_1==K_AS||LA84_1==K_FILTERING||LA84_1==INTEGER||LA84_1==K_VALUES||LA84_1==K_EXISTS||LA84_1==K_TIMESTAMP||LA84_1==K_COUNTER||(LA84_1>=K_KEY && LA84_1<=K_CUSTOM)||LA84_1==IDENT||(LA84_1>=STRING_LITERAL && LA84_1<=K_TRIGGER)||LA84_1==K_TYPE||LA84_1==K_LIST||(LA84_1>=K_ALL && LA84_1<=K_PASSWORD)||(LA84_1>=FLOAT && LA84_1<=K_TOKEN)||(LA84_1>=K_ASCII && LA84_1<=K_MAP)||LA84_1==133||LA84_1==137||LA84_1==142) ) {
                    alt84=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 84, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 84, 0, input);

                throw nvae;
            }
            switch (alt84) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:7: '{' '}'
                    {
                    match(input,142,FOLLOW_142_in_map_literal4406); 
                    match(input,140,FOLLOW_140_in_map_literal4408); 
                     map = new Maps.Literal(Collections.<Pair<Term.Raw, Term.Raw>>emptyList()); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:747:7: '{' k1= term ':' v1= term map_tail[m]
                    {
                    match(input,142,FOLLOW_142_in_map_literal4418); 
                     List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
                    pushFollow(FOLLOW_term_in_map_literal4434);
                    k1=term();

                    state._fsp--;

                    match(input,141,FOLLOW_141_in_map_literal4436); 
                    pushFollow(FOLLOW_term_in_map_literal4440);
                    v1=term();

                    state._fsp--;

                     m.add(Pair.create(k1, v1)); 
                    pushFollow(FOLLOW_map_tail_in_map_literal4444);
                    map_tail(m);

                    state._fsp--;

                     map = new Maps.Literal(m); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return map;
    }
    // $ANTLR end "map_literal"


    // $ANTLR start "set_or_map"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:752:1: set_or_map[Term.Raw t] returns [Term.Raw value] : ( ':' v= term map_tail[m] | set_tail[s] );
    public final Term.Raw set_or_map(Term.Raw t) throws RecognitionException {
        Term.Raw value = null;

        Term.Raw v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:5: ( ':' v= term map_tail[m] | set_tail[s] )
            int alt85=2;
            int LA85_0 = input.LA(1);

            if ( (LA85_0==141) ) {
                alt85=1;
            }
            else if ( (LA85_0==135||LA85_0==140) ) {
                alt85=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;
            }
            switch (alt85) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:753:7: ':' v= term map_tail[m]
                    {
                    match(input,141,FOLLOW_141_in_set_or_map4476); 
                    pushFollow(FOLLOW_term_in_set_or_map4480);
                    v=term();

                    state._fsp--;

                     List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
                    pushFollow(FOLLOW_map_tail_in_set_or_map4484);
                    map_tail(m);

                    state._fsp--;

                     value = new Maps.Literal(m); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:754:7: set_tail[s]
                    {
                     List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
                    pushFollow(FOLLOW_set_tail_in_set_or_map4497);
                    set_tail(s);

                    state._fsp--;

                     value = new Sets.Literal(s); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "set_or_map"


    // $ANTLR start "collection_literal"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:758:1: collection_literal returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= set_or_map[t] | '{' '}' );
    public final Term.Raw collection_literal() throws RecognitionException {
        Term.Raw value = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;

        Term.Raw t = null;

        Term.Raw v = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= set_or_map[t] | '{' '}' )
            int alt88=3;
            int LA88_0 = input.LA(1);

            if ( (LA88_0==137) ) {
                alt88=1;
            }
            else if ( (LA88_0==142) ) {
                int LA88_2 = input.LA(2);

                if ( (LA88_2==140) ) {
                    alt88=3;
                }
                else if ( (LA88_2==K_AS||LA88_2==K_FILTERING||LA88_2==INTEGER||LA88_2==K_VALUES||LA88_2==K_EXISTS||LA88_2==K_TIMESTAMP||LA88_2==K_COUNTER||(LA88_2>=K_KEY && LA88_2<=K_CUSTOM)||LA88_2==IDENT||(LA88_2>=STRING_LITERAL && LA88_2<=K_TRIGGER)||LA88_2==K_TYPE||LA88_2==K_LIST||(LA88_2>=K_ALL && LA88_2<=K_PASSWORD)||(LA88_2>=FLOAT && LA88_2<=K_TOKEN)||(LA88_2>=K_ASCII && LA88_2<=K_MAP)||LA88_2==133||LA88_2==137||LA88_2==142) ) {
                    alt88=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 88, 2, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 88, 0, input);

                throw nvae;
            }
            switch (alt88) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:7: '[' (t1= term ( ',' tn= term )* )? ']'
                    {
                    match(input,137,FOLLOW_137_in_collection_literal4522); 
                     List<Term.Raw> l = new ArrayList<Term.Raw>(); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:61: (t1= term ( ',' tn= term )* )?
                    int alt87=2;
                    int LA87_0 = input.LA(1);

                    if ( (LA87_0==K_AS||LA87_0==K_FILTERING||LA87_0==INTEGER||LA87_0==K_VALUES||LA87_0==K_EXISTS||LA87_0==K_TIMESTAMP||LA87_0==K_COUNTER||(LA87_0>=K_KEY && LA87_0<=K_CUSTOM)||LA87_0==IDENT||(LA87_0>=STRING_LITERAL && LA87_0<=K_TRIGGER)||LA87_0==K_TYPE||LA87_0==K_LIST||(LA87_0>=K_ALL && LA87_0<=K_PASSWORD)||(LA87_0>=FLOAT && LA87_0<=K_TOKEN)||(LA87_0>=K_ASCII && LA87_0<=K_MAP)||LA87_0==133||LA87_0==137||LA87_0==142) ) {
                        alt87=1;
                    }
                    switch (alt87) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:63: t1= term ( ',' tn= term )*
                            {
                            pushFollow(FOLLOW_term_in_collection_literal4530);
                            t1=term();

                            state._fsp--;

                             l.add(t1); 
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:86: ( ',' tn= term )*
                            loop86:
                            do {
                                int alt86=2;
                                int LA86_0 = input.LA(1);

                                if ( (LA86_0==135) ) {
                                    alt86=1;
                                }


                                switch (alt86) {
                            	case 1 :
                            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:88: ',' tn= term
                            	    {
                            	    match(input,135,FOLLOW_135_in_collection_literal4536); 
                            	    pushFollow(FOLLOW_term_in_collection_literal4540);
                            	    tn=term();

                            	    state._fsp--;

                            	     l.add(tn); 

                            	    }
                            	    break;

                            	default :
                            	    break loop86;
                                }
                            } while (true);


                            }
                            break;

                    }

                    match(input,138,FOLLOW_138_in_collection_literal4550); 
                     value = new Lists.Literal(l); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:760:7: '{' t= term v= set_or_map[t]
                    {
                    match(input,142,FOLLOW_142_in_collection_literal4560); 
                    pushFollow(FOLLOW_term_in_collection_literal4564);
                    t=term();

                    state._fsp--;

                    pushFollow(FOLLOW_set_or_map_in_collection_literal4568);
                    v=set_or_map(t);

                    state._fsp--;

                     value = v; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:7: '{' '}'
                    {
                    match(input,142,FOLLOW_142_in_collection_literal4584); 
                    match(input,140,FOLLOW_140_in_collection_literal4586); 
                     value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "collection_literal"


    // $ANTLR start "value"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:765:1: value returns [Term.Raw value] : (c= constant | l= collection_literal | K_NULL | QMARK );
    public final Term.Raw value() throws RecognitionException {
        Term.Raw value = null;

        Constants.Literal c = null;

        Term.Raw l = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:766:5: (c= constant | l= collection_literal | K_NULL | QMARK )
            int alt89=4;
            switch ( input.LA(1) ) {
            case INTEGER:
            case STRING_LITERAL:
            case FLOAT:
            case BOOLEAN:
            case UUID:
            case HEXNUMBER:
                {
                alt89=1;
                }
                break;
            case 137:
            case 142:
                {
                alt89=2;
                }
                break;
            case K_NULL:
                {
                alt89=3;
                }
                break;
            case QMARK:
                {
                alt89=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;
            }

            switch (alt89) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:766:7: c= constant
                    {
                    pushFollow(FOLLOW_constant_in_value4611);
                    c=constant();

                    state._fsp--;

                     value = c; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:767:7: l= collection_literal
                    {
                    pushFollow(FOLLOW_collection_literal_in_value4633);
                    l=collection_literal();

                    state._fsp--;

                     value = l; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:768:7: K_NULL
                    {
                    match(input,K_NULL,FOLLOW_K_NULL_in_value4643); 
                     value = Constants.NULL_LITERAL; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:769:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_value4667); 
                     value = new AbstractMarker.Raw(++currentBindMarkerIdx); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "value"


    // $ANTLR start "intValue"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:772:1: intValue returns [Term.Raw value] : ( | t= INTEGER | QMARK );
    public final Term.Raw intValue() throws RecognitionException {
        Term.Raw value = null;

        Token t=null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:773:5: ( | t= INTEGER | QMARK )
            int alt90=3;
            switch ( input.LA(1) ) {
            case EOF:
            case K_WHERE:
            case K_ALLOW:
            case K_TTL:
            case K_AND:
            case K_INSERT:
            case K_TIMESTAMP:
            case K_UPDATE:
            case K_SET:
            case K_DELETE:
            case K_APPLY:
            case 132:
                {
                alt90=1;
                }
                break;
            case INTEGER:
                {
                alt90=2;
                }
                break;
            case QMARK:
                {
                alt90=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 90, 0, input);

                throw nvae;
            }

            switch (alt90) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:5: 
                    {
                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:774:7: t= INTEGER
                    {
                    t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue4713); 
                     value = Constants.Literal.integer((t!=null?t.getText():null)); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:775:7: QMARK
                    {
                    match(input,QMARK,FOLLOW_QMARK_in_intValue4723); 
                     value = new AbstractMarker.Raw(++currentBindMarkerIdx); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return value;
    }
    // $ANTLR end "intValue"


    // $ANTLR start "functionName"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:778:1: functionName returns [String s] : (f= IDENT | u= unreserved_function_keyword | K_TOKEN );
    public final String functionName() throws RecognitionException {
        String s = null;

        Token f=null;
        String u = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:779:5: (f= IDENT | u= unreserved_function_keyword | K_TOKEN )
            int alt91=3;
            switch ( input.LA(1) ) {
            case IDENT:
                {
                alt91=1;
                }
                break;
            case K_AS:
            case K_FILTERING:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case K_TRIGGER:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt91=2;
                }
                break;
            case K_TOKEN:
                {
                alt91=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 91, 0, input);

                throw nvae;
            }

            switch (alt91) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:779:7: f= IDENT
                    {
                    f=(Token)match(input,IDENT,FOLLOW_IDENT_in_functionName4752); 
                     s = (f!=null?f.getText():null); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:780:7: u= unreserved_function_keyword
                    {
                    pushFollow(FOLLOW_unreserved_function_keyword_in_functionName4786);
                    u=unreserved_function_keyword();

                    state._fsp--;

                     s = u; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:781:7: K_TOKEN
                    {
                    match(input,K_TOKEN,FOLLOW_K_TOKEN_in_functionName4796); 
                     s = "token"; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return s;
    }
    // $ANTLR end "functionName"


    // $ANTLR start "functionArgs"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:1: functionArgs returns [List<Term.Raw> a] : ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' );
    public final List<Term.Raw> functionArgs() throws RecognitionException {
        List<Term.Raw> a = null;

        Term.Raw t1 = null;

        Term.Raw tn = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:785:5: ( '(' ')' | '(' t1= term ( ',' tn= term )* ')' )
            int alt93=2;
            int LA93_0 = input.LA(1);

            if ( (LA93_0==133) ) {
                int LA93_1 = input.LA(2);

                if ( (LA93_1==134) ) {
                    alt93=1;
                }
                else if ( (LA93_1==K_AS||LA93_1==K_FILTERING||LA93_1==INTEGER||LA93_1==K_VALUES||LA93_1==K_EXISTS||LA93_1==K_TIMESTAMP||LA93_1==K_COUNTER||(LA93_1>=K_KEY && LA93_1<=K_CUSTOM)||LA93_1==IDENT||(LA93_1>=STRING_LITERAL && LA93_1<=K_TRIGGER)||LA93_1==K_TYPE||LA93_1==K_LIST||(LA93_1>=K_ALL && LA93_1<=K_PASSWORD)||(LA93_1>=FLOAT && LA93_1<=K_TOKEN)||(LA93_1>=K_ASCII && LA93_1<=K_MAP)||LA93_1==133||LA93_1==137||LA93_1==142) ) {
                    alt93=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 93, 1, input);

                    throw nvae;
                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 93, 0, input);

                throw nvae;
            }
            switch (alt93) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:785:7: '(' ')'
                    {
                    match(input,133,FOLLOW_133_in_functionArgs4841); 
                    match(input,134,FOLLOW_134_in_functionArgs4843); 
                     a = Collections.emptyList(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:786:7: '(' t1= term ( ',' tn= term )* ')'
                    {
                    match(input,133,FOLLOW_133_in_functionArgs4853); 
                    pushFollow(FOLLOW_term_in_functionArgs4857);
                    t1=term();

                    state._fsp--;

                     List<Term.Raw> args = new ArrayList<Term.Raw>(); args.add(t1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:787:11: ( ',' tn= term )*
                    loop92:
                    do {
                        int alt92=2;
                        int LA92_0 = input.LA(1);

                        if ( (LA92_0==135) ) {
                            alt92=1;
                        }


                        switch (alt92) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:787:13: ',' tn= term
                    	    {
                    	    match(input,135,FOLLOW_135_in_functionArgs4873); 
                    	    pushFollow(FOLLOW_term_in_functionArgs4877);
                    	    tn=term();

                    	    state._fsp--;

                    	     args.add(tn); 

                    	    }
                    	    break;

                    	default :
                    	    break loop92;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_functionArgs4891); 
                     a = args; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return a;
    }
    // $ANTLR end "functionArgs"


    // $ANTLR start "term"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:791:1: term returns [Term.Raw term] : (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term );
    public final Term.Raw term() throws RecognitionException {
        Term.Raw term = null;

        Term.Raw v = null;

        String f = null;

        List<Term.Raw> args = null;

        CQL3Type c = null;

        Term.Raw t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:792:5: (v= value | f= functionName args= functionArgs | '(' c= comparatorType ')' t= term )
            int alt94=3;
            switch ( input.LA(1) ) {
            case INTEGER:
            case STRING_LITERAL:
            case FLOAT:
            case BOOLEAN:
            case UUID:
            case HEXNUMBER:
            case K_NULL:
            case QMARK:
            case 137:
            case 142:
                {
                alt94=1;
                }
                break;
            case K_AS:
            case K_FILTERING:
            case K_VALUES:
            case K_EXISTS:
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_KEY:
            case K_COMPACT:
            case K_STORAGE:
            case K_CLUSTERING:
            case K_CUSTOM:
            case IDENT:
            case K_TRIGGER:
            case K_TYPE:
            case K_LIST:
            case K_ALL:
            case K_PERMISSIONS:
            case K_PERMISSION:
            case K_KEYSPACES:
            case K_USER:
            case K_SUPERUSER:
            case K_NOSUPERUSER:
            case K_USERS:
            case K_PASSWORD:
            case K_TOKEN:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
            case K_MAP:
                {
                alt94=2;
                }
                break;
            case 133:
                {
                alt94=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 94, 0, input);

                throw nvae;
            }

            switch (alt94) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:792:7: v= value
                    {
                    pushFollow(FOLLOW_value_in_term4916);
                    v=value();

                    state._fsp--;

                     term = v; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:793:7: f= functionName args= functionArgs
                    {
                    pushFollow(FOLLOW_functionName_in_term4953);
                    f=functionName();

                    state._fsp--;

                    pushFollow(FOLLOW_functionArgs_in_term4957);
                    args=functionArgs();

                    state._fsp--;

                     term = new FunctionCall.Raw(f, args); 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:794:7: '(' c= comparatorType ')' t= term
                    {
                    match(input,133,FOLLOW_133_in_term4967); 
                    pushFollow(FOLLOW_comparatorType_in_term4971);
                    c=comparatorType();

                    state._fsp--;

                    match(input,134,FOLLOW_134_in_term4973); 
                    pushFollow(FOLLOW_term_in_term4977);
                    t=term();

                    state._fsp--;

                     term = new TypeCast(c, t); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return term;
    }
    // $ANTLR end "term"


    // $ANTLR start "columnOperation"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:797:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term );
    public final void columnOperation(List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations) throws RecognitionException {
        Token sig=null;
        Token i=null;
        ColumnIdentifier key = null;

        Term.Raw t = null;

        ColumnIdentifier c = null;

        Term.Raw k = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:798:5: (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term )
            int alt96=4;
            alt96 = dfa96.predict(input);
            switch (alt96) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:798:7: key= cident '=' t= term ( '+' c= cident )?
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation5000);
                    key=cident();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_columnOperation5002); 
                    pushFollow(FOLLOW_term_in_columnOperation5006);
                    t=term();

                    state._fsp--;

                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:798:29: ( '+' c= cident )?
                    int alt95=2;
                    int LA95_0 = input.LA(1);

                    if ( (LA95_0==144) ) {
                        alt95=1;
                    }
                    switch (alt95) {
                        case 1 :
                            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:798:30: '+' c= cident
                            {
                            match(input,144,FOLLOW_144_in_columnOperation5009); 
                            pushFollow(FOLLOW_cident_in_columnOperation5013);
                            c=cident();

                            state._fsp--;


                            }
                            break;

                    }


                              if (c == null)
                              {
                                  addRawUpdate(operations, key, new Operation.SetValue(t));
                              }
                              else
                              {
                                  if (!key.equals(c))
                                      addRecognitionError("Only expressions of the form X = <value> + X are supported.");
                                  addRawUpdate(operations, key, new Operation.Prepend(t));
                              }
                          

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:7: key= cident '=' c= cident sig= ( '+' | '-' ) t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation5034);
                    key=cident();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_columnOperation5036); 
                    pushFollow(FOLLOW_cident_in_columnOperation5040);
                    c=cident();

                    state._fsp--;

                    sig=(Token)input.LT(1);
                    if ( (input.LA(1)>=144 && input.LA(1)<=145) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    pushFollow(FOLLOW_term_in_columnOperation5054);
                    t=term();

                    state._fsp--;


                              if (!key.equals(c))
                                  addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
                              addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
                          

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:817:7: key= cident '=' c= cident i= INTEGER
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation5072);
                    key=cident();

                    state._fsp--;

                    match(input,143,FOLLOW_143_in_columnOperation5074); 
                    pushFollow(FOLLOW_cident_in_columnOperation5078);
                    c=cident();

                    state._fsp--;

                    i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_columnOperation5082); 

                              // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
                              if (!key.equals(c))
                                  // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
                                  addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
                              addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
                          

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:825:7: key= cident '[' k= term ']' '=' t= term
                    {
                    pushFollow(FOLLOW_cident_in_columnOperation5100);
                    key=cident();

                    state._fsp--;

                    match(input,137,FOLLOW_137_in_columnOperation5102); 
                    pushFollow(FOLLOW_term_in_columnOperation5106);
                    k=term();

                    state._fsp--;

                    match(input,138,FOLLOW_138_in_columnOperation5108); 
                    match(input,143,FOLLOW_143_in_columnOperation5110); 
                    pushFollow(FOLLOW_term_in_columnOperation5114);
                    t=term();

                    state._fsp--;


                              addRawUpdate(operations, key, new Operation.SetElement(k, t));
                          

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "columnOperation"


    // $ANTLR start "properties"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:831:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
    public final void properties(PropertyDefinitions props) throws RecognitionException {
        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:5: ( property[props] ( K_AND property[props] )* )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:7: property[props] ( K_AND property[props] )*
            {
            pushFollow(FOLLOW_property_in_properties5140);
            property(props);

            state._fsp--;

            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:23: ( K_AND property[props] )*
            loop97:
            do {
                int alt97=2;
                int LA97_0 = input.LA(1);

                if ( (LA97_0==K_AND) ) {
                    alt97=1;
                }


                switch (alt97) {
            	case 1 :
            	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:24: K_AND property[props]
            	    {
            	    match(input,K_AND,FOLLOW_K_AND_in_properties5144); 
            	    pushFollow(FOLLOW_property_in_properties5146);
            	    property(props);

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop97;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "properties"


    // $ANTLR start "property"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:835:1: property[PropertyDefinitions props] : k= cident '=' (simple= propertyValue | map= map_literal ) ;
    public final void property(PropertyDefinitions props) throws RecognitionException {
        ColumnIdentifier k = null;

        String simple = null;

        Maps.Literal map = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:836:5: (k= cident '=' (simple= propertyValue | map= map_literal ) )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:836:7: k= cident '=' (simple= propertyValue | map= map_literal )
            {
            pushFollow(FOLLOW_cident_in_property5169);
            k=cident();

            state._fsp--;

            match(input,143,FOLLOW_143_in_property5171); 
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:836:20: (simple= propertyValue | map= map_literal )
            int alt98=2;
            int LA98_0 = input.LA(1);

            if ( ((LA98_0>=K_COUNT && LA98_0<=K_AS)||(LA98_0>=K_FILTERING && LA98_0<=INTEGER)||LA98_0==K_VALUES||LA98_0==K_EXISTS||LA98_0==K_TIMESTAMP||LA98_0==K_COUNTER||(LA98_0>=K_KEY && LA98_0<=K_CUSTOM)||(LA98_0>=STRING_LITERAL && LA98_0<=K_TRIGGER)||LA98_0==K_TYPE||LA98_0==K_LIST||(LA98_0>=K_ALL && LA98_0<=K_PASSWORD)||(LA98_0>=FLOAT && LA98_0<=HEXNUMBER)||(LA98_0>=K_ASCII && LA98_0<=K_MAP)) ) {
                alt98=1;
            }
            else if ( (LA98_0==142) ) {
                alt98=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 98, 0, input);

                throw nvae;
            }
            switch (alt98) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:836:21: simple= propertyValue
                    {
                    pushFollow(FOLLOW_propertyValue_in_property5176);
                    simple=propertyValue();

                    state._fsp--;

                     try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:837:24: map= map_literal
                    {
                    pushFollow(FOLLOW_map_literal_in_property5205);
                    map=map_literal();

                    state._fsp--;

                     try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "property"


    // $ANTLR start "propertyValue"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:840:1: propertyValue returns [String str] : (c= constant | u= unreserved_keyword );
    public final String propertyValue() throws RecognitionException {
        String str = null;

        Constants.Literal c = null;

        String u = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:841:5: (c= constant | u= unreserved_keyword )
            int alt99=2;
            int LA99_0 = input.LA(1);

            if ( (LA99_0==INTEGER||LA99_0==STRING_LITERAL||(LA99_0>=FLOAT && LA99_0<=HEXNUMBER)) ) {
                alt99=1;
            }
            else if ( ((LA99_0>=K_COUNT && LA99_0<=K_AS)||(LA99_0>=K_FILTERING && LA99_0<=K_TTL)||LA99_0==K_VALUES||LA99_0==K_EXISTS||LA99_0==K_TIMESTAMP||LA99_0==K_COUNTER||(LA99_0>=K_KEY && LA99_0<=K_CUSTOM)||LA99_0==K_TRIGGER||LA99_0==K_TYPE||LA99_0==K_LIST||(LA99_0>=K_ALL && LA99_0<=K_PASSWORD)||(LA99_0>=K_ASCII && LA99_0<=K_MAP)) ) {
                alt99=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 99, 0, input);

                throw nvae;
            }
            switch (alt99) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:841:7: c= constant
                    {
                    pushFollow(FOLLOW_constant_in_propertyValue5233);
                    c=constant();

                    state._fsp--;

                     str = c.getRawText(); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:842:7: u= unreserved_keyword
                    {
                    pushFollow(FOLLOW_unreserved_keyword_in_propertyValue5255);
                    u=unreserved_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "propertyValue"


    // $ANTLR start "relationType"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:845:1: relationType returns [Relation.Type op] : ( '=' | '<' | '<=' | '>' | '>=' );
    public final Relation.Type relationType() throws RecognitionException {
        Relation.Type op = null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:846:5: ( '=' | '<' | '<=' | '>' | '>=' )
            int alt100=5;
            switch ( input.LA(1) ) {
            case 143:
                {
                alt100=1;
                }
                break;
            case 146:
                {
                alt100=2;
                }
                break;
            case 147:
                {
                alt100=3;
                }
                break;
            case 148:
                {
                alt100=4;
                }
                break;
            case 149:
                {
                alt100=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 100, 0, input);

                throw nvae;
            }

            switch (alt100) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:846:7: '='
                    {
                    match(input,143,FOLLOW_143_in_relationType5278); 
                     op = Relation.Type.EQ; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:7: '<'
                    {
                    match(input,146,FOLLOW_146_in_relationType5289); 
                     op = Relation.Type.LT; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:848:7: '<='
                    {
                    match(input,147,FOLLOW_147_in_relationType5300); 
                     op = Relation.Type.LTE; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:7: '>'
                    {
                    match(input,148,FOLLOW_148_in_relationType5310); 
                     op = Relation.Type.GT; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:850:7: '>='
                    {
                    match(input,149,FOLLOW_149_in_relationType5321); 
                     op = Relation.Type.GTE; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return op;
    }
    // $ANTLR end "relationType"


    // $ANTLR start "relation"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' );
    public final void relation(List<Relation> clauses) throws RecognitionException {
        ColumnIdentifier name = null;

        Relation.Type type = null;

        Term.Raw t = null;

        ColumnIdentifier name1 = null;

        ColumnIdentifier namen = null;

        Term.Raw f1 = null;

        Term.Raw fN = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:5: (name= cident type= relationType t= term | K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' )
            int alt103=3;
            alt103 = dfa103.predict(input);
            switch (alt103) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:854:7: name= cident type= relationType t= term
                    {
                    pushFollow(FOLLOW_cident_in_relation5343);
                    name=cident();

                    state._fsp--;

                    pushFollow(FOLLOW_relationType_in_relation5347);
                    type=relationType();

                    state._fsp--;

                    pushFollow(FOLLOW_term_in_relation5351);
                    t=term();

                    state._fsp--;

                     clauses.add(new Relation(name, type, t)); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:855:7: K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term
                    {
                    match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation5361); 
                     List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
                    match(input,133,FOLLOW_133_in_relation5384); 
                    pushFollow(FOLLOW_cident_in_relation5388);
                    name1=cident();

                    state._fsp--;

                     l.add(name1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:46: ( ',' namen= cident )*
                    loop101:
                    do {
                        int alt101=2;
                        int LA101_0 = input.LA(1);

                        if ( (LA101_0==135) ) {
                            alt101=1;
                        }


                        switch (alt101) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:48: ',' namen= cident
                    	    {
                    	    match(input,135,FOLLOW_135_in_relation5394); 
                    	    pushFollow(FOLLOW_cident_in_relation5398);
                    	    namen=cident();

                    	    state._fsp--;

                    	     l.add(namen); 

                    	    }
                    	    break;

                    	default :
                    	    break loop101;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_relation5404); 
                    pushFollow(FOLLOW_relationType_in_relation5416);
                    type=relationType();

                    state._fsp--;

                    pushFollow(FOLLOW_term_in_relation5420);
                    t=term();

                    state._fsp--;


                                for (ColumnIdentifier id : l)
                                    clauses.add(new Relation(id, type, t, true));
                            

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:7: name= cident K_IN '(' f1= term ( ',' fN= term )* ')'
                    {
                    pushFollow(FOLLOW_cident_in_relation5440);
                    name=cident();

                    state._fsp--;

                    match(input,K_IN,FOLLOW_K_IN_in_relation5442); 
                     Relation rel = Relation.createInRelation(name); 
                    match(input,133,FOLLOW_133_in_relation5453); 
                    pushFollow(FOLLOW_term_in_relation5457);
                    f1=term();

                    state._fsp--;

                     rel.addInValue(f1); 
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:44: ( ',' fN= term )*
                    loop102:
                    do {
                        int alt102=2;
                        int LA102_0 = input.LA(1);

                        if ( (LA102_0==135) ) {
                            alt102=1;
                        }


                        switch (alt102) {
                    	case 1 :
                    	    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:45: ',' fN= term
                    	    {
                    	    match(input,135,FOLLOW_135_in_relation5462); 
                    	    pushFollow(FOLLOW_term_in_relation5466);
                    	    fN=term();

                    	    state._fsp--;

                    	     rel.addInValue(fN); 

                    	    }
                    	    break;

                    	default :
                    	    break loop102;
                        }
                    } while (true);

                    match(input,134,FOLLOW_134_in_relation5473); 
                     clauses.add(rel); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "relation"


    // $ANTLR start "comparatorType"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:867:1: comparatorType returns [CQL3Type t] : (c= native_type | c= collection_type | s= STRING_LITERAL );
    public final CQL3Type comparatorType() throws RecognitionException {
        CQL3Type t = null;

        Token s=null;
        CQL3Type c = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:868:5: (c= native_type | c= collection_type | s= STRING_LITERAL )
            int alt104=3;
            switch ( input.LA(1) ) {
            case K_TIMESTAMP:
            case K_COUNTER:
            case K_ASCII:
            case K_BIGINT:
            case K_BLOB:
            case K_BOOLEAN:
            case K_DECIMAL:
            case K_DOUBLE:
            case K_FLOAT:
            case K_INET:
            case K_INT:
            case K_TEXT:
            case K_UUID:
            case K_VARCHAR:
            case K_VARINT:
            case K_TIMEUUID:
                {
                alt104=1;
                }
                break;
            case K_SET:
            case K_LIST:
            case K_MAP:
                {
                alt104=2;
                }
                break;
            case STRING_LITERAL:
                {
                alt104=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 104, 0, input);

                throw nvae;
            }

            switch (alt104) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:868:7: c= native_type
                    {
                    pushFollow(FOLLOW_native_type_in_comparatorType5498);
                    c=native_type();

                    state._fsp--;

                     t = c; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:869:7: c= collection_type
                    {
                    pushFollow(FOLLOW_collection_type_in_comparatorType5514);
                    c=collection_type();

                    state._fsp--;

                     t = c; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:7: s= STRING_LITERAL
                    {
                    s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType5526); 

                            try {
                                t = new CQL3Type.Custom((s!=null?s.getText():null));
                            } catch (SyntaxException e) {
                                addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
                            } catch (ConfigurationException e) {
                                addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
                            }
                          

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "comparatorType"


    // $ANTLR start "native_type"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:882:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID );
    public final CQL3Type native_type() throws RecognitionException {
        CQL3Type t = null;

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:883:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID )
            int alt105=16;
            switch ( input.LA(1) ) {
            case K_ASCII:
                {
                alt105=1;
                }
                break;
            case K_BIGINT:
                {
                alt105=2;
                }
                break;
            case K_BLOB:
                {
                alt105=3;
                }
                break;
            case K_BOOLEAN:
                {
                alt105=4;
                }
                break;
            case K_COUNTER:
                {
                alt105=5;
                }
                break;
            case K_DECIMAL:
                {
                alt105=6;
                }
                break;
            case K_DOUBLE:
                {
                alt105=7;
                }
                break;
            case K_FLOAT:
                {
                alt105=8;
                }
                break;
            case K_INET:
                {
                alt105=9;
                }
                break;
            case K_INT:
                {
                alt105=10;
                }
                break;
            case K_TEXT:
                {
                alt105=11;
                }
                break;
            case K_TIMESTAMP:
                {
                alt105=12;
                }
                break;
            case K_UUID:
                {
                alt105=13;
                }
                break;
            case K_VARCHAR:
                {
                alt105=14;
                }
                break;
            case K_VARINT:
                {
                alt105=15;
                }
                break;
            case K_TIMEUUID:
                {
                alt105=16;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 105, 0, input);

                throw nvae;
            }

            switch (alt105) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:883:7: K_ASCII
                    {
                    match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type5555); 
                     t = CQL3Type.Native.ASCII; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:7: K_BIGINT
                    {
                    match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type5569); 
                     t = CQL3Type.Native.BIGINT; 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:885:7: K_BLOB
                    {
                    match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type5582); 
                     t = CQL3Type.Native.BLOB; 

                    }
                    break;
                case 4 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:886:7: K_BOOLEAN
                    {
                    match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type5597); 
                     t = CQL3Type.Native.BOOLEAN; 

                    }
                    break;
                case 5 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:7: K_COUNTER
                    {
                    match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type5609); 
                     t = CQL3Type.Native.COUNTER; 

                    }
                    break;
                case 6 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:888:7: K_DECIMAL
                    {
                    match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type5621); 
                     t = CQL3Type.Native.DECIMAL; 

                    }
                    break;
                case 7 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:7: K_DOUBLE
                    {
                    match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type5633); 
                     t = CQL3Type.Native.DOUBLE; 

                    }
                    break;
                case 8 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:890:7: K_FLOAT
                    {
                    match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type5646); 
                     t = CQL3Type.Native.FLOAT; 

                    }
                    break;
                case 9 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:891:7: K_INET
                    {
                    match(input,K_INET,FOLLOW_K_INET_in_native_type5660); 
                     t = CQL3Type.Native.INET;

                    }
                    break;
                case 10 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:892:7: K_INT
                    {
                    match(input,K_INT,FOLLOW_K_INT_in_native_type5675); 
                     t = CQL3Type.Native.INT; 

                    }
                    break;
                case 11 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:893:7: K_TEXT
                    {
                    match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type5691); 
                     t = CQL3Type.Native.TEXT; 

                    }
                    break;
                case 12 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:894:7: K_TIMESTAMP
                    {
                    match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type5706); 
                     t = CQL3Type.Native.TIMESTAMP; 

                    }
                    break;
                case 13 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:895:7: K_UUID
                    {
                    match(input,K_UUID,FOLLOW_K_UUID_in_native_type5716); 
                     t = CQL3Type.Native.UUID; 

                    }
                    break;
                case 14 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:896:7: K_VARCHAR
                    {
                    match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type5731); 
                     t = CQL3Type.Native.VARCHAR; 

                    }
                    break;
                case 15 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:897:7: K_VARINT
                    {
                    match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type5743); 
                     t = CQL3Type.Native.VARINT; 

                    }
                    break;
                case 16 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:898:7: K_TIMEUUID
                    {
                    match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type5756); 
                     t = CQL3Type.Native.TIMEUUID; 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return t;
    }
    // $ANTLR end "native_type"


    // $ANTLR start "collection_type"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:901:1: collection_type returns [CQL3Type pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
    public final CQL3Type collection_type() throws RecognitionException {
        CQL3Type pt = null;

        CQL3Type t1 = null;

        CQL3Type t2 = null;

        CQL3Type t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
            int alt106=3;
            switch ( input.LA(1) ) {
            case K_MAP:
                {
                alt106=1;
                }
                break;
            case K_LIST:
                {
                alt106=2;
                }
                break;
            case K_SET:
                {
                alt106=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 106, 0, input);

                throw nvae;
            }

            switch (alt106) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
                    {
                    match(input,K_MAP,FOLLOW_K_MAP_in_collection_type5780); 
                    match(input,146,FOLLOW_146_in_collection_type5783); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5787);
                    t1=comparatorType();

                    state._fsp--;

                    match(input,135,FOLLOW_135_in_collection_type5789); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5793);
                    t2=comparatorType();

                    state._fsp--;

                    match(input,148,FOLLOW_148_in_collection_type5795); 
                     try {
                                // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
                                if (t1 != null && t2 != null)
                                    pt = CQL3Type.Collection.map(t1, t2);
                              } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:908:7: K_LIST '<' t= comparatorType '>'
                    {
                    match(input,K_LIST,FOLLOW_K_LIST_in_collection_type5813); 
                    match(input,146,FOLLOW_146_in_collection_type5815); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5819);
                    t=comparatorType();

                    state._fsp--;

                    match(input,148,FOLLOW_148_in_collection_type5821); 
                     try { if (t != null) pt = CQL3Type.Collection.list(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;
                case 3 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:910:7: K_SET '<' t= comparatorType '>'
                    {
                    match(input,K_SET,FOLLOW_K_SET_in_collection_type5839); 
                    match(input,146,FOLLOW_146_in_collection_type5842); 
                    pushFollow(FOLLOW_comparatorType_in_collection_type5846);
                    t=comparatorType();

                    state._fsp--;

                    match(input,148,FOLLOW_148_in_collection_type5848); 
                     try { if (t != null) pt = CQL3Type.Collection.set(t); } catch (InvalidRequestException e) { addRecognitionError(e.getMessage()); } 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return pt;
    }
    // $ANTLR end "collection_type"

    public static class username_return extends ParserRuleReturnScope {
    };

    // $ANTLR start "username"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:914:1: username : ( IDENT | STRING_LITERAL );
    public final CqlParser.username_return username() throws RecognitionException {
        CqlParser.username_return retval = new CqlParser.username_return();
        retval.start = input.LT(1);

        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:915:5: ( IDENT | STRING_LITERAL )
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:
            {
            if ( input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "username"


    // $ANTLR start "unreserved_keyword"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:919:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword | k= ( K_TTL | K_COUNT | K_WRITETIME ) );
    public final String unreserved_keyword() throws RecognitionException {
        String str = null;

        Token k=null;
        String u = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:920:5: (u= unreserved_function_keyword | k= ( K_TTL | K_COUNT | K_WRITETIME ) )
            int alt107=2;
            int LA107_0 = input.LA(1);

            if ( (LA107_0==K_AS||LA107_0==K_FILTERING||LA107_0==K_VALUES||LA107_0==K_EXISTS||LA107_0==K_TIMESTAMP||LA107_0==K_COUNTER||(LA107_0>=K_KEY && LA107_0<=K_CUSTOM)||LA107_0==K_TRIGGER||LA107_0==K_TYPE||LA107_0==K_LIST||(LA107_0>=K_ALL && LA107_0<=K_PASSWORD)||(LA107_0>=K_ASCII && LA107_0<=K_MAP)) ) {
                alt107=1;
            }
            else if ( (LA107_0==K_COUNT||(LA107_0>=K_WRITETIME && LA107_0<=K_TTL)) ) {
                alt107=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 107, 0, input);

                throw nvae;
            }
            switch (alt107) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:920:7: u= unreserved_function_keyword
                    {
                    pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword5906);
                    u=unreserved_function_keyword();

                    state._fsp--;

                     str = u; 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:921:7: k= ( K_TTL | K_COUNT | K_WRITETIME )
                    {
                    k=(Token)input.LT(1);
                    if ( input.LA(1)==K_COUNT||(input.LA(1)>=K_WRITETIME && input.LA(1)<=K_TTL) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     str = (k!=null?k.getText():null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "unreserved_keyword"


    // $ANTLR start "unreserved_function_keyword"
    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:924:1: unreserved_function_keyword returns [String str] : (k= ( K_KEY | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER ) | t= native_type );
    public final String unreserved_function_keyword() throws RecognitionException {
        String str = null;

        Token k=null;
        CQL3Type t = null;


        try {
            // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:925:5: (k= ( K_KEY | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER ) | t= native_type )
            int alt108=2;
            int LA108_0 = input.LA(1);

            if ( (LA108_0==K_AS||LA108_0==K_FILTERING||LA108_0==K_VALUES||LA108_0==K_EXISTS||(LA108_0>=K_KEY && LA108_0<=K_CUSTOM)||LA108_0==K_TRIGGER||LA108_0==K_TYPE||LA108_0==K_LIST||(LA108_0>=K_ALL && LA108_0<=K_PASSWORD)||LA108_0==K_MAP) ) {
                alt108=1;
            }
            else if ( (LA108_0==K_TIMESTAMP||LA108_0==K_COUNTER||(LA108_0>=K_ASCII && LA108_0<=K_TIMEUUID)) ) {
                alt108=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 108, 0, input);

                throw nvae;
            }
            switch (alt108) {
                case 1 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:925:7: k= ( K_KEY | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER )
                    {
                    k=(Token)input.LT(1);
                    if ( input.LA(1)==K_AS||input.LA(1)==K_FILTERING||input.LA(1)==K_VALUES||input.LA(1)==K_EXISTS||(input.LA(1)>=K_KEY && input.LA(1)<=K_CUSTOM)||input.LA(1)==K_TRIGGER||input.LA(1)==K_TYPE||input.LA(1)==K_LIST||(input.LA(1)>=K_ALL && input.LA(1)<=K_PASSWORD)||input.LA(1)==K_MAP ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                     str = (k!=null?k.getText():null); 

                    }
                    break;
                case 2 :
                    // /tmp/release/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:948:7: t= native_type
                    {
                    pushFollow(FOLLOW_native_type_in_unreserved_function_keyword6233);
                    t=native_type();

                    state._fsp--;

                     str = t.toString(); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return str;
    }
    // $ANTLR end "unreserved_function_keyword"

    // Delegated rules


    protected DFA2 dfa2 = new DFA2(this);
    protected DFA13 dfa13 = new DFA13(this);
    protected DFA36 dfa36 = new DFA36(this);
    protected DFA79 dfa79 = new DFA79(this);
    protected DFA96 dfa96 = new DFA96(this);
    protected DFA103 dfa103 = new DFA103(this);
    static final String DFA2_eotS =
        "\35\uffff";
    static final String DFA2_eofS =
        "\35\uffff";
    static final String DFA2_minS =
        "\1\4\7\uffff\3\46\2\uffff\1\5\17\uffff";
    static final String DFA2_maxS =
        "\1\75\7\uffff\3\106\2\uffff\1\111\17\uffff";
    static final String DFA2_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\3\uffff\1\20\1\21\1\uffff\1"+
        "\10\1\11\1\23\1\27\1\12\1\13\1\14\1\15\1\25\1\30\1\16\1\17\1\24"+
        "\1\26\1\22";
    static final String DFA2_specialS =
        "\35\uffff}>";
    static final String[] DFA2_transitionS = {
            "\1\6\1\1\17\uffff\1\2\7\uffff\1\3\1\uffff\1\5\1\4\4\uffff\1"+
            "\10\16\uffff\1\11\1\12\4\uffff\1\7\1\13\1\14\1\15",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\16\1\uffff\1\17\5\uffff\2\22\3\uffff\1\21\22\uffff\1\20",
            "\1\23\1\uffff\1\24\6\uffff\1\25\3\uffff\1\27\22\uffff\1\26",
            "\1\31\1\uffff\1\30\35\uffff\1\32",
            "",
            "",
            "\1\34\37\uffff\1\34\16\uffff\2\34\12\uffff\3\34\6\uffff\1\33",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA2_eot = DFA.unpackEncodedString(DFA2_eotS);
    static final short[] DFA2_eof = DFA.unpackEncodedString(DFA2_eofS);
    static final char[] DFA2_min = DFA.unpackEncodedStringToUnsignedChars(DFA2_minS);
    static final char[] DFA2_max = DFA.unpackEncodedStringToUnsignedChars(DFA2_maxS);
    static final short[] DFA2_accept = DFA.unpackEncodedString(DFA2_acceptS);
    static final short[] DFA2_special = DFA.unpackEncodedString(DFA2_specialS);
    static final short[][] DFA2_transition;

    static {
        int numStates = DFA2_transitionS.length;
        DFA2_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA2_transition[i] = DFA.unpackEncodedString(DFA2_transitionS[i]);
        }
    }

    class DFA2 extends DFA {

        public DFA2(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 2;
            this.eot = DFA2_eot;
            this.eof = DFA2_eof;
            this.min = DFA2_min;
            this.max = DFA2_max;
            this.accept = DFA2_accept;
            this.special = DFA2_special;
            this.transition = DFA2_transition;
        }
        public String getDescription() {
            return "172:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement | st2= insertStatement | st3= updateStatement | st4= batchStatement | st5= deleteStatement | st6= useStatement | st7= truncateStatement | st8= createKeyspaceStatement | st9= createTableStatement | st10= createIndexStatement | st11= dropKeyspaceStatement | st12= dropTableStatement | st13= dropIndexStatement | st14= alterTableStatement | st15= alterKeyspaceStatement | st16= grantStatement | st17= revokeStatement | st18= listPermissionsStatement | st19= createUserStatement | st20= alterUserStatement | st21= dropUserStatement | st22= listUsersStatement | st23= createTriggerStatement | st24= dropTriggerStatement );";
        }
    }
    static final String DFA13_eotS =
        "\31\uffff";
    static final String DFA13_eofS =
        "\31\uffff";
    static final String DFA13_minS =
        "\1\6\1\7\1\uffff\23\7\3\uffff";
    static final String DFA13_maxS =
        "\1\142\1\u0087\1\uffff\23\u0087\3\uffff";
    static final String DFA13_acceptS =
        "\2\uffff\1\1\23\uffff\1\4\1\2\1\3";
    static final String DFA13_specialS =
        "\31\uffff}>";
    static final String[] DFA13_transitionS = {
            "\1\2\1\3\6\uffff\1\3\1\24\1\25\6\uffff\1\3\2\uffff\1\3\1\uffff"+
            "\1\17\5\uffff\1\10\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\2\uffff"+
            "\1\3\6\uffff\1\3\4\uffff\11\3\1\2\6\uffff\1\26\1\uffff\1\4\1"+
            "\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23"+
            "\1\3",
            "\2\2\174\uffff\1\26\2\2",
            "",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\26\2\2",
            "\2\2\174\uffff\1\27\2\2",
            "\2\2\174\uffff\1\30\2\2",
            "",
            "",
            ""
    };

    static final short[] DFA13_eot = DFA.unpackEncodedString(DFA13_eotS);
    static final short[] DFA13_eof = DFA.unpackEncodedString(DFA13_eofS);
    static final char[] DFA13_min = DFA.unpackEncodedStringToUnsignedChars(DFA13_minS);
    static final char[] DFA13_max = DFA.unpackEncodedStringToUnsignedChars(DFA13_maxS);
    static final short[] DFA13_accept = DFA.unpackEncodedString(DFA13_acceptS);
    static final short[] DFA13_special = DFA.unpackEncodedString(DFA13_specialS);
    static final short[][] DFA13_transition;

    static {
        int numStates = DFA13_transitionS.length;
        DFA13_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA13_transition[i] = DFA.unpackEncodedString(DFA13_transitionS[i]);
        }
    }

    class DFA13 extends DFA {

        public DFA13(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 13;
            this.eot = DFA13_eot;
            this.eof = DFA13_eof;
            this.min = DFA13_min;
            this.max = DFA13_max;
            this.accept = DFA13_accept;
            this.special = DFA13_special;
            this.transition = DFA13_transition;
        }
        public String getDescription() {
            return "247:1: unaliasedSelector returns [Selectable s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' | f= functionName args= selectionFunctionArgs );";
        }
    }
    static final String DFA36_eotS =
        "\27\uffff";
    static final String DFA36_eofS =
        "\27\uffff";
    static final String DFA36_minS =
        "\1\6\24\10\2\uffff";
    static final String DFA36_maxS =
        "\1\142\24\u0089\2\uffff";
    static final String DFA36_acceptS =
        "\25\uffff\1\1\1\2";
    static final String DFA36_specialS =
        "\27\uffff}>";
    static final String[] DFA36_transitionS = {
            "\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff\1"+
            "\17\5\uffff\1\10\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\2\uffff"+
            "\1\3\6\uffff\1\3\4\uffff\11\3\1\2\10\uffff\1\4\1\5\1\6\1\7\1"+
            "\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "\1\25\176\uffff\1\25\1\uffff\1\26",
            "",
            ""
    };

    static final short[] DFA36_eot = DFA.unpackEncodedString(DFA36_eotS);
    static final short[] DFA36_eof = DFA.unpackEncodedString(DFA36_eofS);
    static final char[] DFA36_min = DFA.unpackEncodedStringToUnsignedChars(DFA36_minS);
    static final char[] DFA36_max = DFA.unpackEncodedStringToUnsignedChars(DFA36_maxS);
    static final short[] DFA36_accept = DFA.unpackEncodedString(DFA36_acceptS);
    static final short[] DFA36_special = DFA.unpackEncodedString(DFA36_specialS);
    static final short[][] DFA36_transition;

    static {
        int numStates = DFA36_transitionS.length;
        DFA36_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA36_transition[i] = DFA.unpackEncodedString(DFA36_transitionS[i]);
        }
    }

    class DFA36 extends DFA {

        public DFA36(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 36;
            this.eot = DFA36_eot;
            this.eof = DFA36_eof;
            this.min = DFA36_min;
            this.max = DFA36_max;
            this.accept = DFA36_accept;
            this.special = DFA36_special;
            this.transition = DFA36_transition;
        }
        public String getDescription() {
            return "386:1: deleteOp returns [Operation.RawDeletion op] : (c= cident | c= cident '[' t= term ']' );";
        }
    }
    static final String DFA79_eotS =
        "\27\uffff";
    static final String DFA79_eofS =
        "\1\uffff\24\25\2\uffff";
    static final String DFA79_minS =
        "\1\6\24\10\2\uffff";
    static final String DFA79_maxS =
        "\1\142\24\u008b\2\uffff";
    static final String DFA79_acceptS =
        "\25\uffff\1\2\1\1";
    static final String DFA79_specialS =
        "\27\uffff}>";
    static final String[] DFA79_transitionS = {
            "\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff\1"+
            "\17\5\uffff\1\10\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\2\uffff"+
            "\1\3\6\uffff\1\3\4\uffff\11\3\1\2\10\uffff\1\4\1\5\1\6\1\7\1"+
            "\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "\3\25\1\uffff\2\25\15\uffff\1\25\2\uffff\1\25\10\uffff\1\25"+
            "\14\uffff\2\25\1\uffff\3\25\4\uffff\2\25\104\uffff\2\25\5\uffff"+
            "\1\26",
            "",
            ""
    };

    static final short[] DFA79_eot = DFA.unpackEncodedString(DFA79_eotS);
    static final short[] DFA79_eof = DFA.unpackEncodedString(DFA79_eofS);
    static final char[] DFA79_min = DFA.unpackEncodedStringToUnsignedChars(DFA79_minS);
    static final char[] DFA79_max = DFA.unpackEncodedStringToUnsignedChars(DFA79_maxS);
    static final short[] DFA79_accept = DFA.unpackEncodedString(DFA79_acceptS);
    static final short[] DFA79_special = DFA.unpackEncodedString(DFA79_specialS);
    static final short[][] DFA79_transition;

    static {
        int numStates = DFA79_transitionS.length;
        DFA79_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA79_transition[i] = DFA.unpackEncodedString(DFA79_transitionS[i]);
        }
    }

    class DFA79 extends DFA {

        public DFA79(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 79;
            this.eot = DFA79_eot;
            this.eof = DFA79_eof;
            this.min = DFA79_min;
            this.max = DFA79_max;
            this.accept = DFA79_accept;
            this.special = DFA79_special;
            this.transition = DFA79_transition;
        }
        public String getDescription() {
            return "717:7: ( cfOrKsName[name, true] '.' )?";
        }
    }
    static final String DFA96_eotS =
        "\56\uffff";
    static final String DFA96_eofS =
        "\56\uffff";
    static final String DFA96_minS =
        "\1\6\24\u0089\1\uffff\1\6\24\21\3\uffff";
    static final String DFA96_maxS =
        "\1\142\24\u008f\1\uffff\1\u008e\24\u0091\3\uffff";
    static final String DFA96_acceptS =
        "\25\uffff\1\4\25\uffff\1\1\1\2\1\3";
    static final String DFA96_specialS =
        "\56\uffff}>";
    static final String[] DFA96_transitionS = {
            "\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff\1"+
            "\17\5\uffff\1\10\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\2\uffff"+
            "\1\3\6\uffff\1\3\4\uffff\11\3\1\2\10\uffff\1\4\1\5\1\6\1\7\1"+
            "\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23\1\3",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "\1\25\5\uffff\1\26",
            "",
            "\1\52\1\31\6\uffff\1\31\2\52\1\53\5\uffff\1\31\2\uffff\1\31"+
            "\1\uffff\1\45\5\uffff\1\36\7\uffff\5\31\1\uffff\1\27\1\uffff"+
            "\1\53\1\31\2\uffff\1\31\6\uffff\1\31\4\uffff\11\31\1\30\7\53"+
            "\1\uffff\1\32\1\33\1\34\1\35\1\37\1\40\1\41\1\42\1\43\1\44\1"+
            "\46\1\47\1\50\1\51\1\31\42\uffff\1\53\3\uffff\1\53\4\uffff\1"+
            "\53",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\176\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\163\uffff\1\53\12\uffff\2\54",
            "\1\55\176\uffff\2\54",
            "",
            "",
            ""
    };

    static final short[] DFA96_eot = DFA.unpackEncodedString(DFA96_eotS);
    static final short[] DFA96_eof = DFA.unpackEncodedString(DFA96_eofS);
    static final char[] DFA96_min = DFA.unpackEncodedStringToUnsignedChars(DFA96_minS);
    static final char[] DFA96_max = DFA.unpackEncodedStringToUnsignedChars(DFA96_maxS);
    static final short[] DFA96_accept = DFA.unpackEncodedString(DFA96_acceptS);
    static final short[] DFA96_special = DFA.unpackEncodedString(DFA96_specialS);
    static final short[][] DFA96_transition;

    static {
        int numStates = DFA96_transitionS.length;
        DFA96_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA96_transition[i] = DFA.unpackEncodedString(DFA96_transitionS[i]);
        }
    }

    class DFA96 extends DFA {

        public DFA96(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 96;
            this.eot = DFA96_eot;
            this.eof = DFA96_eof;
            this.min = DFA96_min;
            this.max = DFA96_max;
            this.accept = DFA96_accept;
            this.special = DFA96_special;
            this.transition = DFA96_transition;
        }
        public String getDescription() {
            return "797:1: columnOperation[List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations] : (key= cident '=' t= term ( '+' c= cident )? | key= cident '=' c= cident sig= ( '+' | '-' ) t= term | key= cident '=' c= cident i= INTEGER | key= cident '[' k= term ']' '=' t= term );";
        }
    }
    static final String DFA103_eotS =
        "\30\uffff";
    static final String DFA103_eofS =
        "\30\uffff";
    static final String DFA103_minS =
        "\1\6\24\123\3\uffff";
    static final String DFA103_maxS =
        "\1\142\24\u0095\3\uffff";
    static final String DFA103_acceptS =
        "\25\uffff\1\2\1\1\1\3";
    static final String DFA103_specialS =
        "\30\uffff}>";
    static final String[] DFA103_transitionS = {
            "\1\24\1\3\6\uffff\1\3\2\24\6\uffff\1\3\2\uffff\1\3\1\uffff\1"+
            "\17\5\uffff\1\10\7\uffff\5\3\1\uffff\1\1\2\uffff\1\3\2\uffff"+
            "\1\3\6\uffff\1\3\4\uffff\11\3\1\2\6\uffff\1\25\1\uffff\1\4\1"+
            "\5\1\6\1\7\1\11\1\12\1\13\1\14\1\15\1\16\1\20\1\21\1\22\1\23"+
            "\1\3",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "\1\27\73\uffff\1\26\2\uffff\4\26",
            "",
            "",
            ""
    };

    static final short[] DFA103_eot = DFA.unpackEncodedString(DFA103_eotS);
    static final short[] DFA103_eof = DFA.unpackEncodedString(DFA103_eofS);
    static final char[] DFA103_min = DFA.unpackEncodedStringToUnsignedChars(DFA103_minS);
    static final char[] DFA103_max = DFA.unpackEncodedStringToUnsignedChars(DFA103_maxS);
    static final short[] DFA103_accept = DFA.unpackEncodedString(DFA103_acceptS);
    static final short[] DFA103_special = DFA.unpackEncodedString(DFA103_specialS);
    static final short[][] DFA103_transition;

    static {
        int numStates = DFA103_transitionS.length;
        DFA103_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA103_transition[i] = DFA.unpackEncodedString(DFA103_transitionS[i]);
        }
    }

    class DFA103 extends DFA {

        public DFA103(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 103;
            this.eot = DFA103_eot;
            this.eof = DFA103_eof;
            this.min = DFA103_min;
            this.max = DFA103_max;
            this.accept = DFA103_accept;
            this.special = DFA103_special;
            this.transition = DFA103_transition;
        }
        public String getDescription() {
            return "853:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN '(' name1= cident ( ',' namen= cident )* ')' type= relationType t= term | name= cident K_IN '(' f1= term ( ',' fN= term )* ')' );";
        }
    }
 

    public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_132_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_cqlStatement138 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_cqlStatement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_batchStatement_in_cqlStatement188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_cqlStatement214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_useStatement_in_cqlStatement239 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_truncateStatement_in_cqlStatement267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createTableStatement_in_cqlStatement307 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement326 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement345 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement384 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement405 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement425 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_grantStatement_in_cqlStatement442 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_revokeStatement_in_cqlStatement467 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement491 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createUserStatement_in_cqlStatement506 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement526 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement547 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement569 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement590 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement607 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USE_in_useStatement639 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_keyspaceName_in_useStatement643 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SELECT_in_selectStatement677 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL,0x0000000000000100L});
    public static final BitSet FOLLOW_selectClause_in_selectStatement683 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_K_COUNT_in_selectStatement703 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_selectStatement705 = new BitSet(new long[]{0x0000000000020000L,0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_selectCountClause_in_selectStatement709 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_selectStatement711 = new BitSet(new long[]{0x0000000000000180L});
    public static final BitSet FOLLOW_K_AS_in_selectStatement716 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_selectStatement720 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_K_FROM_in_selectStatement735 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_selectStatement739 = new BitSet(new long[]{0x0000000000003602L});
    public static final BitSet FOLLOW_K_WHERE_in_selectStatement749 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_whereClause_in_selectStatement753 = new BitSet(new long[]{0x0000000000003402L});
    public static final BitSet FOLLOW_K_ORDER_in_selectStatement766 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_K_BY_in_selectStatement768 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement770 = new BitSet(new long[]{0x0000000000003002L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_selectStatement775 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_orderByClause_in_selectStatement777 = new BitSet(new long[]{0x0000000000003002L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_K_LIMIT_in_selectStatement794 = new BitSet(new long[]{0x0000000000022000L,0x0000000000020000L});
    public static final BitSet FOLLOW_intValue_in_selectStatement798 = new BitSet(new long[]{0x0000000000002002L});
    public static final BitSet FOLLOW_K_ALLOW_in_selectStatement813 = new BitSet(new long[]{0x0000000000004000L});
    public static final BitSet FOLLOW_K_FILTERING_in_selectStatement815 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_selector_in_selectClause852 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_selectClause857 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_selector_in_selectClause861 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_136_in_selectClause873 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unaliasedSelector_in_selector906 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_K_AS_in_selector909 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_selector913 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector942 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_WRITETIME_in_unaliasedSelector985 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_unaliasedSelector987 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector991 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_unaliasedSelector993 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TTL_in_unaliasedSelector1016 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_unaliasedSelector1024 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_unaliasedSelector1028 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_unaliasedSelector1030 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_functionName_in_unaliasedSelector1055 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_selectionFunctionArgs_in_unaliasedSelector1059 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_selectionFunctionArgs1082 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_selectionFunctionArgs1084 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_selectionFunctionArgs1094 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1098 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_selectionFunctionArgs1114 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1118 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_selectionFunctionArgs1132 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_136_in_selectCountClause1155 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_selectCountClause1177 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_relation_in_whereClause1213 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_AND_in_whereClause1217 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_relation_in_whereClause1219 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_cident_in_orderByClause1250 = new BitSet(new long[]{0x0000000000180002L});
    public static final BitSet FOLLOW_K_ASC_in_orderByClause1255 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DESC_in_orderByClause1259 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INSERT_in_insertStatement1297 = new BitSet(new long[]{0x0000000000400000L});
    public static final BitSet FOLLOW_K_INTO_in_insertStatement1299 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1303 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_insertStatement1315 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_insertStatement1319 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_insertStatement1326 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_insertStatement1330 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_insertStatement1337 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_K_VALUES_in_insertStatement1347 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_insertStatement1359 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_insertStatement1363 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_insertStatement1369 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_insertStatement1373 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_insertStatement1380 = new BitSet(new long[]{0x0000000009000002L});
    public static final BitSet FOLLOW_K_IF_in_insertStatement1393 = new BitSet(new long[]{0x0000000002000000L});
    public static final BitSet FOLLOW_K_NOT_in_insertStatement1395 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_insertStatement1397 = new BitSet(new long[]{0x0000000008000002L});
    public static final BitSet FOLLOW_usingClause_in_insertStatement1414 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_USING_in_usingClause1444 = new BitSet(new long[]{0x0000000010010000L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1446 = new BitSet(new long[]{0x0000000010050002L});
    public static final BitSet FOLLOW_K_AND_in_usingClause1451 = new BitSet(new long[]{0x0000000010010000L});
    public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1454 = new BitSet(new long[]{0x0000000010050002L});
    public static final BitSet FOLLOW_K_USING_in_usingClauseDelete1476 = new BitSet(new long[]{0x0000000010000000L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1478 = new BitSet(new long[]{0x0000000010040002L});
    public static final BitSet FOLLOW_K_AND_in_usingClauseDelete1483 = new BitSet(new long[]{0x0000000010000000L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseDelete1486 = new BitSet(new long[]{0x0000000010040002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDeleteObjective1508 = new BitSet(new long[]{0x0000000000020000L,0x0000000000020000L});
    public static final BitSet FOLLOW_intValue_in_usingClauseDeleteObjective1512 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_usingClauseDeleteObjective_in_usingClauseObjective1532 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective1541 = new BitSet(new long[]{0x0000000000020000L,0x0000000000020000L});
    public static final BitSet FOLLOW_intValue_in_usingClauseObjective1545 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UPDATE_in_updateStatement1579 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_updateStatement1583 = new BitSet(new long[]{0x0000000048000000L});
    public static final BitSet FOLLOW_usingClause_in_updateStatement1593 = new BitSet(new long[]{0x0000000040000000L});
    public static final BitSet FOLLOW_K_SET_in_updateStatement1605 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnOperation_in_updateStatement1607 = new BitSet(new long[]{0x0000000000000200L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_updateStatement1611 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnOperation_in_updateStatement1613 = new BitSet(new long[]{0x0000000000000200L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_K_WHERE_in_updateStatement1624 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_whereClause_in_updateStatement1628 = new BitSet(new long[]{0x0000000001000002L});
    public static final BitSet FOLLOW_K_IF_in_updateStatement1638 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_updateCondition_in_updateStatement1642 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_columnOperation_in_updateCondition1683 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_AND_in_updateCondition1688 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnOperation_in_updateCondition1690 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_DELETE_in_deleteStatement1726 = new BitSet(new long[]{0x20497C041481C1C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_deleteSelection_in_deleteStatement1732 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_K_FROM_in_deleteStatement1745 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement1749 = new BitSet(new long[]{0x0000000008000200L});
    public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement1759 = new BitSet(new long[]{0x0000000000000200L});
    public static final BitSet FOLLOW_K_WHERE_in_deleteStatement1771 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF40FFCL});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement1775 = new BitSet(new long[]{0x0000000001000002L});
    public static final BitSet FOLLOW_K_IF_in_deleteStatement1785 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_updateCondition_in_deleteStatement1789 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteOp_in_deleteSelection1835 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_deleteSelection1850 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_deleteOp_in_deleteSelection1854 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_cident_in_deleteOp1881 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_deleteOp1908 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_137_in_deleteOp1910 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_deleteOp1914 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_deleteOp1916 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BEGIN_in_batchStatement1950 = new BitSet(new long[]{0x0000000E00000000L});
    public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement1960 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_K_COUNTER_in_batchStatement1966 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement1979 = new BitSet(new long[]{0x00000000A8200000L});
    public static final BitSet FOLLOW_usingClause_in_batchStatement1983 = new BitSet(new long[]{0x00000000A8200000L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2001 = new BitSet(new long[]{0x00000010A8200000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_132_in_batchStatement2003 = new BitSet(new long[]{0x00000010A8200000L});
    public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2012 = new BitSet(new long[]{0x00000010A8200000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_132_in_batchStatement2014 = new BitSet(new long[]{0x00000010A8200000L});
    public static final BitSet FOLLOW_K_APPLY_in_batchStatement2028 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_K_BATCH_in_batchStatement2030 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective2061 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective2074 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective2087 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement2122 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2124 = new BitSet(new long[]{0x20497C041581C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement2127 = new BitSet(new long[]{0x0000000002000000L});
    public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement2129 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement2131 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement2140 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement2148 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_properties_in_createKeyspaceStatement2150 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createTableStatement2185 = new BitSet(new long[]{0x0000010000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement2187 = new BitSet(new long[]{0x20497C041581C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_K_IF_in_createTableStatement2190 = new BitSet(new long[]{0x0000000002000000L});
    public static final BitSet FOLLOW_K_NOT_in_createTableStatement2192 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement2194 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement2209 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_cfamDefinition_in_createTableStatement2219 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_cfamDefinition2238 = new BitSet(new long[]{0x20497E041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2240 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_cfamDefinition2245 = new BitSet(new long[]{0x20497E041481C0C0L,0x00000007FFF00FFCL,0x00000000000000C0L});
    public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2247 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_cfamDefinition2254 = new BitSet(new long[]{0x0000008000000002L});
    public static final BitSet FOLLOW_K_WITH_in_cfamDefinition2264 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2266 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_AND_in_cfamDefinition2271 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2273 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_cident_in_cfamColumns2299 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_cfamColumns2303 = new BitSet(new long[]{0x0000020000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2308 = new BitSet(new long[]{0x0000040000000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns2310 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2322 = new BitSet(new long[]{0x0000040000000000L});
    public static final BitSet FOLLOW_K_KEY_in_cfamColumns2324 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_cfamColumns2326 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL,0x0000000000000020L});
    public static final BitSet FOLLOW_pkDef_in_cfamColumns2328 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_cfamColumns2332 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_cfamColumns2336 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_cfamColumns2343 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_pkDef2363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_pkDef2373 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_pkDef2379 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_pkDef2385 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_pkDef2389 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_pkDef2396 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_cfamProperty2416 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty2425 = new BitSet(new long[]{0x0000100000000000L});
    public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty2427 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty2437 = new BitSet(new long[]{0x0000000000000400L});
    public static final BitSet FOLLOW_K_ORDER_in_cfamProperty2439 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_K_BY_in_cfamProperty2441 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_cfamProperty2443 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2445 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_cfamProperty2449 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2451 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_cfamProperty2456 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_cfamOrdering2484 = new BitSet(new long[]{0x0000000000180000L});
    public static final BitSet FOLLOW_K_ASC_in_cfamOrdering2487 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DESC_in_cfamOrdering2491 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement2529 = new BitSet(new long[]{0x0000C00000000000L});
    public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement2532 = new BitSet(new long[]{0x0000800000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement2538 = new BitSet(new long[]{0x0003000001000000L});
    public static final BitSet FOLLOW_K_IF_in_createIndexStatement2541 = new BitSet(new long[]{0x0000000002000000L});
    public static final BitSet FOLLOW_K_NOT_in_createIndexStatement2543 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement2545 = new BitSet(new long[]{0x0003000000000000L});
    public static final BitSet FOLLOW_IDENT_in_createIndexStatement2563 = new BitSet(new long[]{0x0002000000000000L});
    public static final BitSet FOLLOW_K_ON_in_createIndexStatement2567 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement2571 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_createIndexStatement2573 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_createIndexStatement2577 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_createIndexStatement2579 = new BitSet(new long[]{0x0000000008000002L});
    public static final BitSet FOLLOW_K_USING_in_createIndexStatement2591 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement2595 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement2629 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement2631 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_IDENT_in_createTriggerStatement2636 = new BitSet(new long[]{0x0002000000000000L});
    public static final BitSet FOLLOW_K_ON_in_createTriggerStatement2639 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement2643 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_K_USING_in_createTriggerStatement2645 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement2649 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement2680 = new BitSet(new long[]{0x0008000000000000L});
    public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement2682 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_IDENT_in_dropTriggerStatement2687 = new BitSet(new long[]{0x0002000000000000L});
    public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement2690 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement2694 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement2734 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement2736 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement2740 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement2750 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement2752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement2788 = new BitSet(new long[]{0x0000010000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement2790 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement2794 = new BitSet(new long[]{0x01B0008000000000L});
    public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement2808 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2812 = new BitSet(new long[]{0x0040000000000000L});
    public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement2814 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement2818 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ADD_in_alterTableStatement2834 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2840 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_alterTableStatement2844 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_alterTableStatement2867 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement2872 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_WITH_in_alterTableStatement2912 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_properties_in_alterTableStatement2915 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement2948 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3002 = new BitSet(new long[]{0x0200000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTableStatement3004 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3008 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_AND_in_alterTableStatement3029 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3033 = new BitSet(new long[]{0x0200000000000000L});
    public static final BitSet FOLLOW_K_TO_in_alterTableStatement3035 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_alterTableStatement3039 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement3094 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3096 = new BitSet(new long[]{0x20497C041581C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement3099 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement3101 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement3110 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropTableStatement3144 = new BitSet(new long[]{0x0000010000000000L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3146 = new BitSet(new long[]{0x20497C041581C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_K_IF_in_dropTableStatement3149 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement3151 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement3160 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement3194 = new BitSet(new long[]{0x0000800000000000L});
    public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement3196 = new BitSet(new long[]{0x0001000001000000L});
    public static final BitSet FOLLOW_K_IF_in_dropIndexStatement3199 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement3201 = new BitSet(new long[]{0x0001000000000000L});
    public static final BitSet FOLLOW_IDENT_in_dropIndexStatement3210 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement3241 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement3245 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_GRANT_in_grantStatement3270 = new BitSet(new long[]{0x0030002000000020L,0x0000000000000007L});
    public static final BitSet FOLLOW_permissionOrAll_in_grantStatement3282 = new BitSet(new long[]{0x0002000000000000L});
    public static final BitSet FOLLOW_K_ON_in_grantStatement3290 = new BitSet(new long[]{0x20497D441481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_resource_in_grantStatement3302 = new BitSet(new long[]{0x0200000000000000L});
    public static final BitSet FOLLOW_K_TO_in_grantStatement3310 = new BitSet(new long[]{0x0005000000000000L});
    public static final BitSet FOLLOW_username_in_grantStatement3322 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_REVOKE_in_revokeStatement3353 = new BitSet(new long[]{0x0030002000000020L,0x0000000000000007L});
    public static final BitSet FOLLOW_permissionOrAll_in_revokeStatement3365 = new BitSet(new long[]{0x0002000000000000L});
    public static final BitSet FOLLOW_K_ON_in_revokeStatement3373 = new BitSet(new long[]{0x20497D441481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_resource_in_revokeStatement3385 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_K_FROM_in_revokeStatement3393 = new BitSet(new long[]{0x0005000000000000L});
    public static final BitSet FOLLOW_username_in_revokeStatement3405 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement3443 = new BitSet(new long[]{0x0030002000000020L,0x0000000000000007L});
    public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement3455 = new BitSet(new long[]{0xC002000000000002L});
    public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement3465 = new BitSet(new long[]{0x20497D441481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_resource_in_listPermissionsStatement3467 = new BitSet(new long[]{0xC000000000000002L});
    public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement3482 = new BitSet(new long[]{0x0005000000000000L});
    public static final BitSet FOLLOW_username_in_listPermissionsStatement3484 = new BitSet(new long[]{0x8000000000000002L});
    public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement3499 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_permission3535 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALL_in_permissionOrAll3584 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000008L});
    public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll3588 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_permission_in_permissionOrAll3609 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
    public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll3613 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_dataResource_in_resource3641 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALL_in_dataResource3664 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource3666 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource3676 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_keyspaceName_in_dataResource3682 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource3694 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_columnFamilyName_in_dataResource3703 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_CREATE_in_createUserStatement3743 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_K_USER_in_createUserStatement3745 = new BitSet(new long[]{0x0005000000000000L});
    public static final BitSet FOLLOW_username_in_createUserStatement3747 = new BitSet(new long[]{0x0000008000000002L,0x0000000000000180L});
    public static final BitSet FOLLOW_K_WITH_in_createUserStatement3757 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_userOptions_in_createUserStatement3759 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000180L});
    public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement3773 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement3779 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement3824 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_K_USER_in_alterUserStatement3826 = new BitSet(new long[]{0x0005000000000000L});
    public static final BitSet FOLLOW_username_in_alterUserStatement3828 = new BitSet(new long[]{0x0000008000000002L,0x0000000000000180L});
    public static final BitSet FOLLOW_K_WITH_in_alterUserStatement3838 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_userOptions_in_alterUserStatement3840 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000180L});
    public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement3854 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement3860 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DROP_in_dropUserStatement3896 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_K_USER_in_dropUserStatement3898 = new BitSet(new long[]{0x0005000000000000L});
    public static final BitSet FOLLOW_username_in_dropUserStatement3900 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_listUsersStatement3925 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_K_USERS_in_listUsersStatement3927 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_userOption_in_userOptions3947 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_PASSWORD_in_userOption3968 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_userOption3972 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cident4001 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cident4026 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_cident4045 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_keyspaceName4078 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName4112 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_139_in_columnFamilyName4115 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cfOrKsName_in_columnFamilyName4119 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_cfOrKsName4140 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_NAME_in_cfOrKsName4165 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_cfOrKsName4184 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_constant4209 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_constant4221 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_in_constant4240 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BOOLEAN_in_constant4261 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUID_in_constant4280 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEXNUMBER_in_constant4302 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_140_in_set_tail4327 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_135_in_set_tail4335 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_set_tail4339 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001080L});
    public static final BitSet FOLLOW_set_tail_in_set_tail4343 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_140_in_map_tail4362 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_135_in_map_tail4370 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_map_tail4374 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_map_tail4376 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_map_tail4380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001080L});
    public static final BitSet FOLLOW_map_tail_in_map_tail4384 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_142_in_map_literal4406 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_140_in_map_literal4408 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_142_in_map_literal4418 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_map_literal4434 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000002000L});
    public static final BitSet FOLLOW_141_in_map_literal4436 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_map_literal4440 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001080L});
    public static final BitSet FOLLOW_map_tail_in_map_literal4444 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_141_in_set_or_map4476 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_set_or_map4480 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001080L});
    public static final BitSet FOLLOW_map_tail_in_set_or_map4484 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_tail_in_set_or_map4497 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_137_in_collection_literal4522 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004620L});
    public static final BitSet FOLLOW_term_in_collection_literal4530 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000480L});
    public static final BitSet FOLLOW_135_in_collection_literal4536 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_collection_literal4540 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000480L});
    public static final BitSet FOLLOW_138_in_collection_literal4550 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_142_in_collection_literal4560 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_collection_literal4564 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000003080L});
    public static final BitSet FOLLOW_set_or_map_in_collection_literal4568 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_142_in_collection_literal4584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000001000L});
    public static final BitSet FOLLOW_140_in_collection_literal4586 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_value4611 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collection_literal_in_value4633 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_NULL_in_value4643 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_value4667 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTEGER_in_intValue4713 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QMARK_in_intValue4723 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_in_functionName4752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_function_keyword_in_functionName4786 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TOKEN_in_functionName4796 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_functionArgs4841 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_functionArgs4843 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_functionArgs4853 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_functionArgs4857 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_functionArgs4873 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_functionArgs4877 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_functionArgs4891 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_value_in_term4916 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_functionName_in_term4953 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_functionArgs_in_term4957 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_133_in_term4967 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_term4971 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000040L});
    public static final BitSet FOLLOW_134_in_term4973 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_term4977 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation5000 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_columnOperation5002 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_columnOperation5006 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_144_in_columnOperation5009 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_columnOperation5013 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation5034 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_columnOperation5036 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_columnOperation5040 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000030000L});
    public static final BitSet FOLLOW_set_in_columnOperation5044 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_columnOperation5054 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation5072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_columnOperation5074 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_columnOperation5078 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_INTEGER_in_columnOperation5082 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_columnOperation5100 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_137_in_columnOperation5102 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_columnOperation5106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_138_in_columnOperation5108 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_columnOperation5110 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_columnOperation5114 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_property_in_properties5140 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_K_AND_in_properties5144 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_property_in_properties5146 = new BitSet(new long[]{0x0000000000040002L});
    public static final BitSet FOLLOW_cident_in_property5169 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
    public static final BitSet FOLLOW_143_in_property5171 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF0FFFCL,0x0000000000004000L});
    public static final BitSet FOLLOW_propertyValue_in_property5176 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_map_literal_in_property5205 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_propertyValue5233 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue5255 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_143_in_relationType5278 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_146_in_relationType5289 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_147_in_relationType5300 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_148_in_relationType5310 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_149_in_relationType5321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation5343 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000003C8000L});
    public static final BitSet FOLLOW_relationType_in_relation5347 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_relation5351 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TOKEN_in_relation5361 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_relation5384 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_relation5388 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_relation5394 = new BitSet(new long[]{0x20497C041481C0C0L,0x00000007FFF00FFCL});
    public static final BitSet FOLLOW_cident_in_relation5398 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_relation5404 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000003C8000L});
    public static final BitSet FOLLOW_relationType_in_relation5416 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_relation5420 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cident_in_relation5440 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_K_IN_in_relation5442 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_133_in_relation5453 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_relation5457 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_135_in_relation5462 = new BitSet(new long[]{0x204D7C041483C0C0L,0x00000007FFF7FFFCL,0x0000000000004220L});
    public static final BitSet FOLLOW_term_in_relation5466 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x00000000000000C0L});
    public static final BitSet FOLLOW_134_in_relation5473 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_native_type_in_comparatorType5498 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collection_type_in_comparatorType5514 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType5526 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_ASCII_in_native_type5555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BIGINT_in_native_type5569 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BLOB_in_native_type5582 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_BOOLEAN_in_native_type5597 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_COUNTER_in_native_type5609 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DECIMAL_in_native_type5621 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_DOUBLE_in_native_type5633 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_FLOAT_in_native_type5646 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INET_in_native_type5660 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_INT_in_native_type5675 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TEXT_in_native_type5691 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type5706 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_UUID_in_native_type5716 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_VARCHAR_in_native_type5731 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_VARINT_in_native_type5743 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_TIMEUUID_in_native_type5756 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_MAP_in_collection_type5780 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_146_in_collection_type5783 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5787 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000080L});
    public static final BitSet FOLLOW_135_in_collection_type5789 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5793 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_148_in_collection_type5795 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_LIST_in_collection_type5813 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_146_in_collection_type5815 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5819 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_148_in_collection_type5821 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_K_SET_in_collection_type5839 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_146_in_collection_type5842 = new BitSet(new long[]{0x204C7C0454804080L,0x00000007FFF007FCL});
    public static final BitSet FOLLOW_comparatorType_in_collection_type5846 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_148_in_collection_type5848 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_username0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword5906 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_unreserved_keyword5922 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_unreserved_function_keyword5957 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword6233 = new BitSet(new long[]{0x0000000000000002L});

}