/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.UUIDGen;
import org.jboss.netty.buffer.ChannelBuffer;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ChannelBuffer body, int version) {
            byte[] id = CBUtil.readBytes(body);
            int count = body.readUnsignedShort();
            ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(count);
            for (int i = 0; i < count; ++i) {
                values.add(CBUtil.readValue(body));
            }
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            int resultPageSize = -1;
            boolean skipMetadata = false;
            PagingState pagingState = null;
            if (version >= 2) {
                EnumSet<Flag> flags = Flag.deserialize(body.readByte());
                if (flags.contains((Object)Flag.PAGE_SIZE)) {
                    resultPageSize = body.readInt();
                }
                skipMetadata = flags.contains((Object)Flag.SKIP_METADATA);
                if (flags.contains((Object)Flag.PAGING_STATE)) {
                    pagingState = PagingState.deserialize(CBUtil.readValue(body));
                }
            }
            return new ExecuteMessage(MD5Digest.wrap(id), values, consistency, resultPageSize, skipMetadata, pagingState);
        }

        @Override
        public ChannelBuffer encode(ExecuteMessage msg, int version) {
            int vs = msg.values.size();
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            if (msg.resultPageSize >= 0) {
                flags.add(Flag.PAGE_SIZE);
            }
            if (msg.skipMetadata) {
                flags.add(Flag.SKIP_METADATA);
            }
            if (msg.pagingState != null) {
                flags.add(Flag.PAGING_STATE);
            }
            assert (flags.isEmpty() || version >= 2);
            int nbBuff = 3;
            if (version >= 2) {
                ++nbBuff;
                if (flags.contains((Object)Flag.PAGE_SIZE)) {
                    ++nbBuff;
                }
            }
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(nbBuff, 0, vs + (flags.contains((Object)Flag.PAGING_STATE) ? 1 : 0));
            builder.add(CBUtil.bytesToCB(msg.statementId.bytes));
            builder.add(CBUtil.shortToCB(vs));
            for (ByteBuffer value : msg.values) {
                builder.addValue(value);
            }
            builder.add(CBUtil.consistencyLevelToCB(msg.consistency));
            if (version >= 2) {
                builder.add(CBUtil.byteToCB((byte)Flag.serialize(flags)));
                if (flags.contains((Object)Flag.PAGE_SIZE)) {
                    builder.add(CBUtil.intToCB(msg.resultPageSize));
                }
                if (flags.contains((Object)Flag.PAGING_STATE)) {
                    builder.addValue(msg.pagingState == null ? null : msg.pagingState.serialize());
                }
            }
            return builder.build();
        }
    };
    public final MD5Digest statementId;
    public final List<ByteBuffer> values;
    public final ConsistencyLevel consistency;
    public final int resultPageSize;
    public final boolean skipMetadata;
    public final PagingState pagingState;

    public ExecuteMessage(byte[] statementId, List<ByteBuffer> values, ConsistencyLevel consistency, int resultPageSize) {
        this(MD5Digest.wrap(statementId), values, consistency, resultPageSize, false, null);
    }

    public ExecuteMessage(MD5Digest statementId, List<ByteBuffer> values, ConsistencyLevel consistency, int resultPageSize, boolean skipMetadata, PagingState pagingState) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.values = values;
        this.consistency = consistency;
        this.resultPageSize = resultPageSize;
        this.skipMetadata = skipMetadata;
        this.pagingState = pagingState;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this, this.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            CQLStatement statement = QueryProcessor.getPrepared(this.statementId);
            if (statement == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            if (this.resultPageSize == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (this.resultPageSize > 0) {
                    builder.put((Object)"page_size", (Object)Integer.toString(this.resultPageSize));
                }
                Tracing.instance.begin("Execute CQL3 prepared query", (Map<String, String>)builder.build());
            }
            ResultMessage response = QueryProcessor.processPrepared(statement, this.consistency, state, this.values, this.resultPageSize, this.pagingState);
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.values.size() + " values at consistency " + (Object)((Object)this.consistency);
    }

    public static enum Flag {
        PAGE_SIZE,
        SKIP_METADATA,
        PAGING_STATE;


        public static EnumSet<Flag> deserialize(int flags) {
            EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
            Flag[] values = Flag.values();
            for (int n = 0; n < values.length; ++n) {
                if ((flags & 1 << n) == 0) continue;
                set.add(values[n]);
            }
            return set;
        }

        public static int serialize(EnumSet<Flag> flags) {
            int i = 0;
            for (Flag flag : flags) {
                i |= 1 << flag.ordinal();
            }
            return i;
        }
    }
}

