/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.thrift.TCustomNonblockingServerSocket;
import org.apache.cassandra.thrift.TServerFactory;
import org.apache.cassandra.thrift.ThriftSessionManager;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TTransportException;

public class CustomTNonBlockingServer
extends TNonblockingServer {
    public CustomTNonBlockingServer(TNonblockingServer.Args args) {
        super((AbstractNonblockingServer.AbstractNonblockingServerArgs)args);
    }

    protected boolean requestInvoke(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        TNonblockingSocket socket = (TNonblockingSocket)frameBuffer.trans_;
        ThriftSessionManager.instance.setCurrentSocket(socket.getSocketChannel().socket().getRemoteSocketAddress());
        frameBuffer.invoke();
        return true;
    }

    public static class Factory
    implements TServerFactory {
        @Override
        public TServer buildTServer(TServerFactory.Args args) {
            TCustomNonblockingServerSocket serverTransport;
            if (DatabaseDescriptor.getClientEncryptionOptions().enabled) {
                throw new RuntimeException("Client SSL is not supported for non-blocking sockets. Please remove client ssl from the configuration.");
            }
            InetSocketAddress addr = args.addr;
            try {
                serverTransport = new TCustomNonblockingServerSocket(addr, args.keepAlive, args.sendBufferSize, args.recvBufferSize);
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", addr.getAddress(), addr.getPort()), e);
            }
            TNonblockingServer.Args serverArgs = (TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)((TNonblockingServer.Args)new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport).inputTransportFactory(args.inTransportFactory)).outputTransportFactory(args.outTransportFactory)).inputProtocolFactory(args.tProtocolFactory)).outputProtocolFactory(args.tProtocolFactory)).processor((TProcessor)args.processor);
            return new CustomTNonBlockingServer(serverArgs);
        }
    }
}

