/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.IAsyncCallback;

public abstract class AbstractPaxosCallback<T>
implements IAsyncCallback<T> {
    protected final CountDownLatch latch;
    protected final int targets;

    public AbstractPaxosCallback(int targets) {
        this.targets = targets;
        this.latch = new CountDownLatch(targets);
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }

    public int getResponseCount() {
        return (int)((long)this.targets - this.latch.getCount());
    }

    public void await() throws WriteTimeoutException {
        try {
            if (!this.latch.await(DatabaseDescriptor.getWriteRpcTimeout(), TimeUnit.MILLISECONDS)) {
                throw new WriteTimeoutException(WriteType.CAS, ConsistencyLevel.SERIAL, this.getResponseCount(), this.targets);
            }
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
    }
}

