/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class ListSerializer<T>
extends CollectionSerializer<List<T>> {
    private static final Map<TypeSerializer<?>, ListSerializer> instances = new HashMap();
    public final TypeSerializer<T> elements;

    public static synchronized <T> ListSerializer<T> getInstance(TypeSerializer<T> elements) {
        ListSerializer<T> t = instances.get(elements);
        if (t == null) {
            t = new ListSerializer<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private ListSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    public List<T> serialize(ByteBuffer bytes) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ListSerializer.getUnsignedShort(input);
            ArrayList<T> l = new ArrayList<T>(n);
            for (int i = 0; i < n; ++i) {
                int s = ListSerializer.getUnsignedShort(input);
                byte[] data = new byte[s];
                input.get(data);
                ByteBuffer databb = ByteBuffer.wrap(data);
                this.elements.validate(databb);
                l.add(this.elements.serialize(databb));
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public ByteBuffer deserialize(List<T> value) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value.size());
        int size = 0;
        for (T elt : value) {
            ByteBuffer bb = this.elements.deserialize(elt);
            bbs.add(bb);
            size += 2 + bb.remaining();
        }
        return ListSerializer.pack(bbs, value.size(), size);
    }

    @Override
    public String toString(List<T> value) {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; ");
            }
            sb.append(this.elements.toString(element));
        }
        return sb.toString();
    }

    @Override
    public Class<List<T>> getType() {
        return List.class;
    }
}

