/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FloatSerializer
implements TypeSerializer<Float> {
    public static final FloatSerializer instance = new FloatSerializer();

    @Override
    public Float serialize(ByteBuffer bytes) {
        return Float.valueOf(ByteBufferUtil.toFloat(bytes));
    }

    @Override
    public ByteBuffer deserialize(Float value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value.floatValue());
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 4 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 4 or 0 byte value for a float (%d)", bytes.remaining()));
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 4) {
            throw new MarshalException("A float is exactly 4 bytes : " + bytes.remaining());
        }
        return String.valueOf(ByteBufferUtil.toFloat(bytes));
    }

    @Override
    public String toString(Float value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }
}

