/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;

public class CompactionMetrics
implements CompactionManager.CompactionExecutorStatsCollector {
    public static final String GROUP_NAME = "org.apache.cassandra.metrics";
    public static final String TYPE_NAME = "Compaction";
    private static final Set<CompactionInfo.Holder> compactions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    public final Gauge<Integer> pendingTasks;
    public final Gauge<Long> completedTasks;
    public final Meter totalCompactionsCompleted;
    public final Counter bytesCompacted;

    public CompactionMetrics(final ThreadPoolExecutor ... collectors) {
        this.pendingTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "PendingTasks"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                int n = 0;
                for (String keyspaceName : Schema.instance.getKeyspaces()) {
                    for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                        n += cfs.getCompactionStrategy().getEstimatedRemainingTasks();
                    }
                }
                for (ThreadPoolExecutor collector : collectors) {
                    n = (int)((long)n + (collector.getTaskCount() - collector.getCompletedTaskCount()));
                }
                return n;
            }
        });
        this.completedTasks = Metrics.newGauge((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long completedTasks = 0L;
                for (ThreadPoolExecutor collector : collectors) {
                    completedTasks += collector.getCompletedTaskCount();
                }
                return completedTasks;
            }
        });
        this.totalCompactionsCompleted = Metrics.newMeter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "TotalCompactionsCompleted"), (String)"compaction completed", (TimeUnit)TimeUnit.SECONDS);
        this.bytesCompacted = Metrics.newCounter((MetricName)new MetricName(GROUP_NAME, TYPE_NAME, "BytesCompacted"));
    }

    @Override
    public void beginCompaction(CompactionInfo.Holder ci) {
        ci.started();
        compactions.add(ci);
    }

    @Override
    public void finishCompaction(CompactionInfo.Holder ci) {
        ci.finished();
        compactions.remove(ci);
        this.bytesCompacted.inc(ci.getCompactionInfo().getTotal());
        this.totalCompactionsCompleted.mark();
    }

    public static List<CompactionInfo.Holder> getCompactions() {
        return new ArrayList<CompactionInfo.Holder>(compactions);
    }
}

