/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.hadoop.cql3.CqlPagingInputFormat;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlPagingRecordReader
extends RecordReader<Map<String, ByteBuffer>, Map<String, ByteBuffer>>
implements org.apache.hadoop.mapred.RecordReader<Map<String, ByteBuffer>, Map<String, ByteBuffer>> {
    private static final Logger logger = LoggerFactory.getLogger(CqlPagingRecordReader.class);
    public static final int DEFAULT_CQL_PAGE_LIMIT = 1000;
    private ColumnFamilySplit split;
    private RowIterator rowIterator;
    private Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>> currentRow;
    private int totalRowCount;
    private String keyspace;
    private String cfName;
    private Cassandra.Client client;
    private ConsistencyLevel consistencyLevel;
    private List<BoundColumn> partitionBoundColumns = new ArrayList<BoundColumn>();
    private List<BoundColumn> clusterColumns = new ArrayList<BoundColumn>();
    private Map<Integer, Integer> preparedQueryIds = new HashMap<Integer, Integer>();
    private String columns;
    private int pageRowSize;
    private String userDefinedWhereClauses;
    private IPartitioner partitioner;
    private AbstractType<?> keyValidator;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = context.getConfiguration();
        this.totalRowCount = this.split.getLength() < Long.MAX_VALUE ? (int)this.split.getLength() : ConfigHelper.getInputSplitSize(conf);
        this.cfName = ConfigHelper.getInputColumnFamily(conf);
        this.consistencyLevel = ConsistencyLevel.valueOf((String)ConfigHelper.getReadConsistencyLevel(conf));
        this.keyspace = ConfigHelper.getInputKeyspace(conf);
        this.columns = CqlConfigHelper.getInputcolumns(conf);
        this.userDefinedWhereClauses = CqlConfigHelper.getInputWhereClauses(conf);
        try {
            this.pageRowSize = Integer.parseInt(CqlConfigHelper.getInputPageRowSize(conf));
        }
        catch (NumberFormatException e) {
            this.pageRowSize = 1000;
        }
        this.partitioner = ConfigHelper.getInputPartitioner(context.getConfiguration());
        try {
            if (this.client != null) {
                return;
            }
            String location = this.getLocation();
            int port = ConfigHelper.getInputRpcPort(conf);
            this.client = CqlPagingInputFormat.createAuthenticatedClient(location, port, conf);
            this.retrieveKeys();
            this.client.set_keyspace(this.keyspace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.rowIterator = new RowIterator();
        logger.debug("created {}", (Object)this.rowIterator);
    }

    public void close() {
        if (this.client != null) {
            TTransport transport = this.client.getOutputProtocol().getTransport();
            if (transport.isOpen()) {
                transport.close();
            }
            this.client = null;
        }
    }

    public Map<String, ByteBuffer> getCurrentKey() {
        return (Map)this.currentRow.left;
    }

    public Map<String, ByteBuffer> getCurrentValue() {
        return (Map)this.currentRow.right;
    }

    public float getProgress() {
        if (!this.rowIterator.hasNext()) {
            return 1.0f;
        }
        float progress = (float)this.rowIterator.totalRead / (float)this.totalRowCount;
        return progress > 1.0f ? 1.0f : progress;
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.rowIterator.hasNext()) {
            logger.debug("Finished scanning " + this.rowIterator.totalRead + " rows (estimate was: " + this.totalRowCount + ")");
            return false;
        }
        try {
            this.currentRow = (Pair)this.rowIterator.next();
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(ioe.getCause());
            throw ioe;
        }
        return true;
    }

    private String getLocation() {
        Collection<InetAddress> localAddresses = FBUtilities.getAllLocalAddresses();
        for (InetAddress address : localAddresses) {
            for (String location : this.split.getLocations()) {
                InetAddress locationAddress;
                try {
                    locationAddress = InetAddress.getByName(location);
                }
                catch (UnknownHostException e) {
                    throw new AssertionError((Object)e);
                }
                if (!address.equals(locationAddress)) continue;
                return location;
            }
        }
        return this.split.getLocations()[0];
    }

    public boolean next(Map<String, ByteBuffer> keys, Map<String, ByteBuffer> value) throws IOException {
        if (this.nextKeyValue()) {
            value.clear();
            value.putAll((Map<String, ByteBuffer>)this.getCurrentValue());
            keys.clear();
            keys.putAll((Map<String, ByteBuffer>)this.getCurrentKey());
            return true;
        }
        return false;
    }

    public long getPos() throws IOException {
        return this.rowIterator.totalRead;
    }

    public Map<String, ByteBuffer> createKey() {
        return new LinkedHashMap<String, ByteBuffer>();
    }

    public Map<String, ByteBuffer> createValue() {
        return new LinkedHashMap<String, ByteBuffer>();
    }

    private void retrieveKeys() throws Exception {
        String query = "select key_aliases,column_aliases, key_validator, comparator from system.schema_columnfamilies where keyspace_name='%s' and columnfamily_name='%s'";
        String formatted = String.format(query, this.keyspace, this.cfName);
        CqlResult result = this.client.execute_cql3_query(ByteBufferUtil.bytes(formatted), Compression.NONE, ConsistencyLevel.ONE);
        CqlRow cqlRow = (CqlRow)result.rows.get(0);
        String keyString = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(0)).getValue()));
        logger.debug("partition keys: " + keyString);
        List<String> keys = FBUtilities.fromJsonList(keyString);
        for (String key : keys) {
            this.partitionBoundColumns.add(new BoundColumn(key));
        }
        keyString = ByteBufferUtil.string(ByteBuffer.wrap(((Column)cqlRow.columns.get(1)).getValue()));
        logger.debug("cluster columns: " + keyString);
        keys = FBUtilities.fromJsonList(keyString);
        for (String key : keys) {
            this.clusterColumns.add(new BoundColumn(key));
        }
        Column rawKeyValidator = (Column)cqlRow.columns.get(2);
        String validator = ByteBufferUtil.string(ByteBuffer.wrap(rawKeyValidator.getValue()));
        logger.debug("row key validator: " + validator);
        this.keyValidator = CqlPagingRecordReader.parseType(validator);
        if (this.keyValidator instanceof CompositeType) {
            List<AbstractType<?>> types = ((CompositeType)this.keyValidator).types;
            for (int i = 0; i < this.partitionBoundColumns.size(); ++i) {
                this.partitionBoundColumns.get((int)i).validator = types.get(i);
            }
        } else {
            this.partitionBoundColumns.get((int)0).validator = this.keyValidator;
        }
    }

    private boolean reachEndRange() {
        ByteBuffer rowKey;
        if (this.keyValidator instanceof CompositeType) {
            ByteBuffer[] keys = new ByteBuffer[this.partitionBoundColumns.size()];
            for (int i = 0; i < this.partitionBoundColumns.size(); ++i) {
                keys[i] = this.partitionBoundColumns.get((int)i).value.duplicate();
            }
            CompositeType cfr_ignored_0 = (CompositeType)this.keyValidator;
            rowKey = CompositeType.build(keys);
        } else {
            rowKey = this.partitionBoundColumns.get((int)0).value;
        }
        String endToken = this.split.getEndToken();
        String currentToken = ((Token)this.partitioner.getToken(rowKey)).toString();
        logger.debug("End token: " + endToken + ", current token: " + currentToken);
        return endToken.equals(currentToken);
    }

    private static AbstractType<?> parseType(String type) throws IOException {
        try {
            if (type != null && type.equals("org.apache.cassandra.db.marshal.CounterColumnType")) {
                return LongType.instance;
            }
            return TypeParser.parse(type);
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        catch (SyntaxException e) {
            throw new IOException(e);
        }
    }

    private static String stringValue(ByteBuffer value) {
        try {
            return ByteBufferUtil.string(value);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BoundColumn {
        final String name;
        ByteBuffer value;
        AbstractType<?> validator;

        public BoundColumn(String name) {
            this.name = name;
        }
    }

    private class RowIterator
    extends AbstractIterator<Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>>> {
        protected int totalRead = 0;
        protected Iterator<CqlRow> rows;
        private int pageRows = 0;
        private String previousRowKey = null;
        private String partitionKeyString;
        private String partitionKeyMarkers;

        public RowIterator() {
            this.executeQuery();
        }

        protected Pair<Map<String, ByteBuffer>, Map<String, ByteBuffer>> computeNext() {
            if (this.rows == null) {
                return (Pair)this.endOfData();
            }
            int index = -2;
            while (!this.rows.hasNext()) {
                if (index == -1 || this.emptyPartitionKeyValues()) {
                    logger.debug("no more data.");
                    return (Pair)this.endOfData();
                }
                index = this.setTailNull(CqlPagingRecordReader.this.clusterColumns);
                logger.debug("set tail to null, index: " + index);
                this.executeQuery();
                this.pageRows = 0;
                if (this.rows != null && (this.rows.hasNext() || index >= 0)) continue;
                logger.debug("no more data.");
                return (Pair)this.endOfData();
            }
            Object valueColumns = CqlPagingRecordReader.this.createValue();
            Object keyColumns = CqlPagingRecordReader.this.createKey();
            int i = 0;
            CqlRow row = this.rows.next();
            for (Column column : row.columns) {
                String columnName = CqlPagingRecordReader.stringValue(ByteBuffer.wrap(column.getName()));
                logger.debug("column: " + columnName);
                if (i < CqlPagingRecordReader.this.partitionBoundColumns.size() + CqlPagingRecordReader.this.clusterColumns.size()) {
                    keyColumns.put(CqlPagingRecordReader.stringValue(column.name), column.value);
                } else {
                    valueColumns.put(CqlPagingRecordReader.stringValue(column.name), column.value);
                }
                ++i;
            }
            ++this.pageRows;
            if (this.newRow((Map<String, ByteBuffer>)keyColumns, this.previousRowKey)) {
                ++this.totalRead;
            }
            if (this.pageRows >= CqlPagingRecordReader.this.pageRowSize || !this.rows.hasNext()) {
                Iterator newKeys = keyColumns.keySet().iterator();
                for (BoundColumn column : CqlPagingRecordReader.this.partitionBoundColumns) {
                    column.value = (ByteBuffer)keyColumns.get(newKeys.next());
                }
                for (BoundColumn column : CqlPagingRecordReader.this.clusterColumns) {
                    column.value = (ByteBuffer)keyColumns.get(newKeys.next());
                }
                this.executeQuery();
                this.pageRows = 0;
            }
            return Pair.create(keyColumns, valueColumns);
        }

        private boolean newRow(Map<String, ByteBuffer> keyColumns, String previousRowKey) {
            if (keyColumns.isEmpty()) {
                return false;
            }
            String rowKey = "";
            if (keyColumns.size() == 1) {
                rowKey = ((BoundColumn)((CqlPagingRecordReader)CqlPagingRecordReader.this).partitionBoundColumns.get((int)0)).validator.getString(keyColumns.get(((BoundColumn)((CqlPagingRecordReader)CqlPagingRecordReader.this).partitionBoundColumns.get((int)0)).name));
            } else {
                Iterator<ByteBuffer> iter = keyColumns.values().iterator();
                for (BoundColumn column : CqlPagingRecordReader.this.partitionBoundColumns) {
                    rowKey = rowKey + column.validator.getString(ByteBufferUtil.clone(iter.next())) + ":";
                }
            }
            logger.debug("previous RowKey: " + previousRowKey + ", new row key: " + rowKey);
            if (previousRowKey == null) {
                this.previousRowKey = rowKey;
                return true;
            }
            if (rowKey.equals(previousRowKey)) {
                return false;
            }
            this.previousRowKey = rowKey;
            return true;
        }

        private int setTailNull(List<BoundColumn> values) {
            if (values.isEmpty()) {
                return -1;
            }
            Iterator<BoundColumn> iterator = values.iterator();
            int previousIndex = -1;
            while (iterator.hasNext()) {
                BoundColumn current = iterator.next();
                if (current.value == null) {
                    int index = previousIndex > 0 ? previousIndex : 0;
                    BoundColumn column = values.get(index);
                    logger.debug("set key " + column.name + " value to  null");
                    column.value = null;
                    return previousIndex - 1;
                }
                ++previousIndex;
            }
            BoundColumn column = values.get(previousIndex);
            logger.debug("set key " + column.name + " value to null");
            column.value = null;
            return previousIndex - 1;
        }

        private Pair<Integer, String> composeQuery(String columns) {
            Pair<Integer, String> clause = this.whereClause();
            if (columns == null) {
                columns = "*";
            } else {
                String partitionKey = this.keyString(CqlPagingRecordReader.this.partitionBoundColumns);
                String clusterKey = this.keyString(CqlPagingRecordReader.this.clusterColumns);
                columns = this.withoutKeyColumns(columns);
                columns = clusterKey == null || "".equals(clusterKey) ? partitionKey + "," + columns : partitionKey + "," + clusterKey + "," + columns;
            }
            return Pair.create(clause.left, "SELECT " + columns + " FROM " + CqlPagingRecordReader.this.cfName + (String)clause.right + (CqlPagingRecordReader.this.userDefinedWhereClauses == null ? "" : " AND " + CqlPagingRecordReader.this.userDefinedWhereClauses) + " LIMIT " + CqlPagingRecordReader.this.pageRowSize + " ALLOW FILTERING");
        }

        private String withoutKeyColumns(String columnString) {
            HashSet<String> keyNames = new HashSet<String>();
            for (BoundColumn column : Iterables.concat((Iterable)CqlPagingRecordReader.this.partitionBoundColumns, (Iterable)CqlPagingRecordReader.this.clusterColumns)) {
                keyNames.add(column.name);
            }
            String[] columns = columnString.split(",");
            String result = null;
            for (String column : columns) {
                String trimmed = column.trim();
                if (keyNames.contains(trimmed)) continue;
                result = result == null ? trimmed : result + "," + trimmed;
            }
            return result;
        }

        private Pair<Integer, String> whereClause() {
            if (this.partitionKeyString == null) {
                this.partitionKeyString = this.keyString(CqlPagingRecordReader.this.partitionBoundColumns);
            }
            if (this.partitionKeyMarkers == null) {
                this.partitionKeyMarkers = this.partitionKeyMarkers();
            }
            if (this.emptyPartitionKeyValues()) {
                return Pair.create(0, " WHERE token(" + this.partitionKeyString + ") > ? AND token(" + this.partitionKeyString + ") <= ?");
            }
            if (CqlPagingRecordReader.this.clusterColumns.size() == 0 || ((BoundColumn)((CqlPagingRecordReader)CqlPagingRecordReader.this).clusterColumns.get((int)0)).value == null) {
                return Pair.create(1, " WHERE token(" + this.partitionKeyString + ") > token(" + this.partitionKeyMarkers + ") " + " AND token(" + this.partitionKeyString + ") <= ?");
            }
            Pair<Integer, String> clause = this.whereClause(CqlPagingRecordReader.this.clusterColumns, 0);
            return Pair.create(clause.left, " WHERE token(" + this.partitionKeyString + ") = token(" + this.partitionKeyMarkers + ") " + (String)clause.right);
        }

        private Pair<Integer, String> whereClause(List<BoundColumn> column, int position) {
            if (position == column.size() - 1 || column.get((int)(position + 1)).value == null) {
                return Pair.create(position + 2, " AND " + column.get((int)position).name + " > ? ");
            }
            Pair<Integer, String> clause = this.whereClause(column, position + 1);
            return Pair.create(clause.left, " AND " + column.get((int)position).name + " = ? " + (String)clause.right);
        }

        private boolean emptyPartitionKeyValues() {
            for (BoundColumn column : CqlPagingRecordReader.this.partitionBoundColumns) {
                if (column.value == null) continue;
                return false;
            }
            return true;
        }

        private String keyString(List<BoundColumn> columns) {
            String result = null;
            for (BoundColumn column : columns) {
                result = result == null ? column.name : result + "," + column.name;
            }
            return result == null ? "" : result;
        }

        private String partitionKeyMarkers() {
            String result = null;
            for (BoundColumn column : CqlPagingRecordReader.this.partitionBoundColumns) {
                result = result == null ? "?" : result + ",?";
            }
            return result;
        }

        private Pair<Integer, List<ByteBuffer>> preparedQueryBindValues() {
            LinkedList<ByteBuffer> values = new LinkedList<ByteBuffer>();
            if (this.emptyPartitionKeyValues()) {
                values.add(CqlPagingRecordReader.this.partitioner.getTokenValidator().fromString(CqlPagingRecordReader.this.split.getStartToken()));
                values.add(CqlPagingRecordReader.this.partitioner.getTokenValidator().fromString(CqlPagingRecordReader.this.split.getEndToken()));
                return Pair.create(0, values);
            }
            for (BoundColumn partitionBoundColumn1 : CqlPagingRecordReader.this.partitionBoundColumns) {
                values.add(partitionBoundColumn1.value);
            }
            if (CqlPagingRecordReader.this.clusterColumns.size() == 0 || ((BoundColumn)((CqlPagingRecordReader)CqlPagingRecordReader.this).clusterColumns.get((int)0)).value == null) {
                values.add(CqlPagingRecordReader.this.partitioner.getTokenValidator().fromString(CqlPagingRecordReader.this.split.getEndToken()));
                return Pair.create(1, values);
            }
            int type = this.preparedQueryBindValues(CqlPagingRecordReader.this.clusterColumns, 0, values);
            return Pair.create(type, values);
        }

        private int preparedQueryBindValues(List<BoundColumn> column, int position, List<ByteBuffer> bindValues) {
            if (position == column.size() - 1 || column.get((int)(position + 1)).value == null) {
                bindValues.add(column.get((int)position).value);
                return position + 2;
            }
            bindValues.add(column.get((int)position).value);
            return this.preparedQueryBindValues(column, position + 1, bindValues);
        }

        private int prepareQuery(int type) throws InvalidRequestException, TException {
            Integer itemId = (Integer)CqlPagingRecordReader.this.preparedQueryIds.get(type);
            if (itemId != null) {
                return itemId;
            }
            Pair<Integer, String> query = null;
            query = this.composeQuery(CqlPagingRecordReader.this.columns);
            logger.debug("type:" + query.left + ", query: " + (String)query.right);
            CqlPreparedResult cqlPreparedResult = CqlPagingRecordReader.this.client.prepare_cql3_query(ByteBufferUtil.bytes((String)query.right), Compression.NONE);
            CqlPagingRecordReader.this.preparedQueryIds.put(query.left, cqlPreparedResult.itemId);
            return cqlPreparedResult.itemId;
        }

        private void executeQuery() {
            Pair<Integer, List<ByteBuffer>> bindValues = this.preparedQueryBindValues();
            logger.debug("query type: " + bindValues.left);
            if ((Integer)bindValues.left == 1 && CqlPagingRecordReader.this.reachEndRange()) {
                this.rows = null;
                return;
            }
            int retries = 0;
            while (retries < 3) {
                try {
                    CqlResult cqlResult = CqlPagingRecordReader.this.client.execute_prepared_cql3_query(this.prepareQuery((Integer)bindValues.left), (List)bindValues.right, CqlPagingRecordReader.this.consistencyLevel);
                    if (cqlResult != null && cqlResult.rows != null) {
                        this.rows = cqlResult.rows.iterator();
                    }
                    return;
                }
                catch (TimedOutException e) {
                    if (++retries < 3) continue;
                    this.rows = null;
                    RuntimeException rte = new RuntimeException(e.getMessage());
                    rte.initCause(e);
                    throw rte;
                }
                catch (UnavailableException e) {
                    if (++retries < 3) continue;
                    this.rows = null;
                    RuntimeException rte = new RuntimeException(e.getMessage());
                    rte.initCause(e);
                    throw rte;
                }
                catch (Exception e) {
                    this.rows = null;
                    RuntimeException rte = new RuntimeException(e.getMessage());
                    rte.initCause(e);
                    throw rte;
                }
            }
        }
    }
}

