/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.utils.BloomCalculations;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.Filter;
import org.apache.cassandra.utils.LegacyBloomFilter;
import org.apache.cassandra.utils.Murmur2BloomFilter;
import org.apache.cassandra.utils.Murmur3BloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFactory {
    private static final Logger logger = LoggerFactory.getLogger(FilterFactory.class);
    private static final TypeSizes TYPE_SIZES = TypeSizes.NATIVE;

    public static void serialize(Filter bf, DataOutput output) throws IOException {
        FilterFactory.serialize(bf, output, Type.MURMUR3);
    }

    public static void serialize(Filter bf, DataOutput output, Type type) throws IOException {
        switch (type) {
            case SHA: {
                LegacyBloomFilter.serializer.serialize((LegacyBloomFilter)bf, output);
                break;
            }
            case MURMUR2: {
                Murmur2BloomFilter.serializer.serialize((Murmur2BloomFilter)bf, output);
                break;
            }
            default: {
                Murmur3BloomFilter.serializer.serialize((Murmur3BloomFilter)bf, output);
            }
        }
    }

    public static Filter deserialize(DataInput input, Type type) throws IOException {
        switch (type) {
            case SHA: {
                return LegacyBloomFilter.serializer.deserialize(input);
            }
            case MURMUR2: {
                return Murmur2BloomFilter.serializer.deserialize(input);
            }
        }
        return Murmur3BloomFilter.serializer.deserialize(input);
    }

    public static long serializedSize(Filter bf) {
        return FilterFactory.serializedSize(bf, Type.MURMUR3);
    }

    public static long serializedSize(Filter bf, Type type) {
        switch (type) {
            case SHA: {
                return LegacyBloomFilter.serializer.serializedSize((LegacyBloomFilter)bf);
            }
            case MURMUR2: {
                return Murmur2BloomFilter.serializer.serializedSize((Murmur2BloomFilter)bf, TYPE_SIZES);
            }
        }
        return Murmur3BloomFilter.serializer.serializedSize((Murmur3BloomFilter)bf, TYPE_SIZES);
    }

    public static Filter getFilter(long numElements, int targetBucketsPerElem) {
        return FilterFactory.getFilter(numElements, targetBucketsPerElem, Type.MURMUR3);
    }

    static Filter getFilter(long numElements, int targetBucketsPerElem, Type type) {
        int maxBucketsPerElement = Math.max(1, BloomCalculations.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn(String.format("Cannot provide an optimal BloomFilter for %d elements (%d/%d buckets per element).", numElements, bucketsPerElement, targetBucketsPerElem));
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement, type);
    }

    public static Filter getFilter(long numElements, double maxFalsePosProbability) {
        return FilterFactory.getFilter(numElements, maxFalsePosProbability, Type.MURMUR3);
    }

    static Filter getFilter(long numElements, double maxFalsePosProbability, Type type) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        int bucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement, type);
    }

    private static Filter createFilter(int hash, long numElements, int bucketsPer, Type type) {
        switch (type) {
            case MURMUR2: {
                return new Murmur2BloomFilter(hash, numElements, bucketsPer);
            }
        }
        return new Murmur3BloomFilter(hash, numElements, bucketsPer);
    }

    public static BloomFilter emptyFilter() {
        return new Murmur3BloomFilter(0, 0L, 0);
    }

    public static enum Type {
        SHA,
        MURMUR2,
        MURMUR3;

    }
}

