/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public abstract class ResultMessage
extends Message.Response {
    public static final Message.Codec<ResultMessage> codec = new Message.Codec<ResultMessage>(){

        @Override
        public ResultMessage decode(ChannelBuffer body) {
            Kind kind = Kind.fromId(body.readInt());
            return (ResultMessage)kind.subcodec.decode(body);
        }

        @Override
        public ChannelBuffer encode(ResultMessage msg) {
            ChannelBuffer kcb = ChannelBuffers.buffer((int)4);
            kcb.writeInt(msg.kind.id);
            ChannelBuffer body = msg.encodeBody();
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{kcb, body});
        }
    };
    public final Kind kind;

    protected ResultMessage(Kind kind) {
        super(Message.Type.RESULT);
        this.kind = kind;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    protected abstract ChannelBuffer encodeBody();

    public abstract CqlResult toThriftResult();

    public static class Prepared
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                int id = body.readInt();
                return new Prepared(id, ResultSet.Metadata.codec.decode(body));
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof Prepared);
                Prepared prepared = (Prepared)msg;
                return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.intToCB(prepared.statementId), ResultSet.Metadata.codec.encode(prepared.metadata)});
            }
        };
        public final int statementId;
        public final ResultSet.Metadata metadata;

        public Prepared(int statementId, List<ColumnSpecification> names) {
            this(statementId, new ResultSet.Metadata(names));
        }

        private Prepared(int statementId, ResultSet.Metadata metadata) {
            super(Kind.PREPARED);
            this.statementId = statementId;
            this.metadata = metadata;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            throw new UnsupportedOperationException();
        }

        public CqlPreparedResult toThriftPreparedResult() {
            ArrayList<String> namesString = new ArrayList<String>(this.metadata.names.size());
            ArrayList<String> typesString = new ArrayList<String>(this.metadata.names.size());
            for (ColumnSpecification name : this.metadata.names) {
                namesString.add(name.toString());
                typesString.add(TypeParser.getShortName(name.type));
            }
            return new CqlPreparedResult(this.statementId, this.metadata.names.size()).setVariable_types(typesString).setVariable_names(namesString);
        }

        public String toString() {
            return "RESULT PREPARED " + this.statementId + " " + this.metadata;
        }
    }

    public static class Rows
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                return new Rows(ResultSet.codec.decode(body));
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof Rows);
                Rows rowMsg = (Rows)msg;
                return ResultSet.codec.encode(rowMsg.result);
            }
        };
        public final ResultSet result;

        public Rows(ResultSet result) {
            super(Kind.ROWS);
            this.result = result;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return this.result.toThriftResult();
        }

        public String toString() {
            return "ROWS " + this.result;
        }
    }

    public static class SetKeyspace
    extends ResultMessage {
        private final String keyspace;
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                String keyspace = CBUtil.readString(body);
                return new SetKeyspace(keyspace);
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof SetKeyspace);
                return CBUtil.stringToCB(((SetKeyspace)msg).keyspace);
            }
        };

        public SetKeyspace(String keyspace) {
            super(Kind.SET_KEYSPACE);
            this.keyspace = keyspace;
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public String toString() {
            return "RESULT set keyspace " + this.keyspace;
        }
    }

    public static class Void
    extends ResultMessage {
        public static final Message.Codec<ResultMessage> subcodec = new Message.Codec<ResultMessage>(){

            @Override
            public ResultMessage decode(ChannelBuffer body) {
                return Void.instance();
            }

            @Override
            public ChannelBuffer encode(ResultMessage msg) {
                assert (msg instanceof Void);
                return ChannelBuffers.EMPTY_BUFFER;
            }
        };

        private Void() {
            super(Kind.VOID);
        }

        @Override
        protected ChannelBuffer encodeBody() {
            return subcodec.encode(this);
        }

        @Override
        public CqlResult toThriftResult() {
            return new CqlResult(CqlResultType.VOID);
        }

        public static Void instance() {
            return Holder.instance;
        }

        public String toString() {
            return "EMPTY RESULT";
        }

        private static class Holder {
            static final Void instance = new Void();

            private Holder() {
            }
        }
    }

    public static enum Kind {
        VOID(1, Void.subcodec),
        ROWS(2, Rows.subcodec),
        SET_KEYSPACE(3, SetKeyspace.subcodec),
        PREPARED(4, Prepared.subcodec);

        public final int id;
        public final Message.Codec<ResultMessage> subcodec;
        private static final Kind[] ids;

        private Kind(int id, Message.Codec<ResultMessage> subcodec) {
            this.id = id;
            this.subcodec = subcodec;
        }

        public static Kind fromId(int id) {
            Kind k = ids[id];
            if (k == null) {
                throw new ProtocolException(String.format("Unknown kind id %d in RESULT message", id));
            }
            return k;
        }

        static {
            int maxId = -1;
            for (Kind k : Kind.values()) {
                maxId = Math.max(maxId, k.id);
            }
            ids = new Kind[maxId + 1];
            for (Kind k : Kind.values()) {
                if (ids[k.id] != null) {
                    throw new IllegalStateException("Duplicate kind id");
                }
                Kind.ids[k.id] = k;
            }
        }
    }
}

