/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler
extends AbstractWriteResponseHandler {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected final AtomicInteger responses;
    private final int blockFor;

    protected WriteResponseHandler(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback) {
        super(writeEndpoints, consistencyLevel, callback);
        this.blockFor = consistencyLevel.blockFor(table);
        this.responses = new AtomicInteger(this.blockFor);
    }

    protected WriteResponseHandler(InetAddress endpoint) {
        super(Arrays.asList(endpoint), ConsistencyLevel.ALL, null);
        this.blockFor = 1;
        this.responses = new AtomicInteger(1);
    }

    public static IWriteResponseHandler create(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table, Runnable callback) {
        return new WriteResponseHandler(writeEndpoints, consistencyLevel, table, callback);
    }

    public static IWriteResponseHandler create(InetAddress endpoint) {
        return new WriteResponseHandler(endpoint);
    }

    @Override
    public void response(MessageIn m) {
        if (this.responses.decrementAndGet() == 0) {
            this.signal();
        }
    }

    @Override
    protected int ackCount() {
        return this.blockFor - this.responses.get();
    }

    @Override
    protected int blockFor() {
        return this.blockFor;
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        if (this.consistencyLevel == ConsistencyLevel.ANY) {
            int effectiveEndpoints;
            int n = effectiveEndpoints = this.writeEndpoints.contains(FBUtilities.getBroadcastAddress()) ? this.writeEndpoints.size() : this.writeEndpoints.size() + 1;
            if (effectiveEndpoints < this.responses.get()) {
                throw new UnavailableException(this.consistencyLevel, this.responses.get(), effectiveEndpoints);
            }
            return;
        }
        int liveNodes = 0;
        for (InetAddress destination : this.writeEndpoints) {
            if (!FailureDetector.instance.isAlive(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.responses.get()) {
            throw new UnavailableException(this.consistencyLevel, this.responses.get(), liveNodes);
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

